// Persistence of Vision Ray Tracer Scene Description File
// File: lb_woods.pov
// Vers: 3.1
// Desc: A swamp/woodland scene, made for IRTC May/June 2000 : "The Wilderness"
// Date: 25 June 2000
// Auth: Luke Beeby




//First run cliff.pov, cliff_col.pov, moss.pov and height.pov at 640x480 with tga output
//then render at 600x900.


#include "colors.inc" 
#include "textures.inc"  
#include "stones.inc"

 
// set viewer's position in the scene
camera
{
  location  <0.0, 0, -10> // position of camera <X Y Z>
  direction 2.0*z            // which way are we looking <X Y Z> & zoom
  up        2*y                // which way is +up <X Y Z>
  right     4/3*x            // which way is +right <X Y Z> and aspect ratio
  look_at   <0.0, 1.0,  0.0> // point center of view at this point <X Y Z>
} 

global_settings
{
        max_trace_level 7
}


 
 
 

light_source
{
        <-10,20,-15>
        Gray30
        shadowless
}         

light_source
{
        <0,0,9>
        White     
        shadowless
}    

light_source
{      
        <0,10,0>
        White   
        area_light         // comment these lines
        x,z,2,2            // out if you don't want
        jitter             // to wait all day
        
}



          
//the sky
sky_sphere
{
        pigment
        {
                gradient y      
                color_map 
                {
                        [0.000 0.002 color rgb <1.0, 1.0, 0.0>
                                        color rgb <1.0, 0.2, 0.0>]
                        [0.002 0.200 color rgb <0.8, 0.1, 0.0>
                                        color rgb <0.2, 0.2, 0.3>]
                
                }
                scale 2
                translate -1
                rotate x*-100
                rotate y*-5
      }

}      


//the clouds

plane
{
        -z,-10
        pigment
        {
                bozo     
                turbulence 1
                color_map
                {
                        [0.3 color rgbf <0.1,0.1,0.1,1.0>]
                        [0.6 color rgbf <0.3,0.3,0.3,0.7>]
                        [1 color rgbf <0.5,0.5,0.5,0.5>] 
                        
                }
        }           
                        scale<4,2,2>
        
}

               
               
               
//the ground   

#declare Image =  pigment
{
        image_map
                                {
                                        tga "moss.tga"
                                }        
                                rotate x*90
                                
}


height_field
{
        tga "height.tga"
        smooth     
        pigment
        {
                Image                
        }  
        
        finish
        {
                phong 0.2
                reflection 0.1
        }
        
                             
        translate -0.5   
        
        
        scale <15,7.5,15>      
        
        rotate y*45
        translate <2,2.5,-2>  
}     


//the cliff
height_field
{
        tga "cliff.tga"
        pigment
        {      
                image_map{ tga"Cliff_col.tga" once}
                rotate x*90
        }
        
               
        translate -0.5
        scale<10,2,10>
        rotate z*95
        translate <2,5,3> 
        
        normal
        {
                bozo
                scale <0.1,0.5,0.1>
        }
        
}   

       

//a more distant cliff  
intersection
{
        height_field
        {
                tga "cliff.tga"
                
                
                texture
                {
                        pigment
                        {      
                                image_map{ tga"Cliff_col.tga" once                               }
                                rotate x*90
                        }
                }
                
                texture
                { 
                        pigment
                        {
                                gradient x
                                colour_map
                                {
                                        [0 rgbf<0.2,0.2,0.2,0.5>]
                                        [1 rgbf<0.0,0.0,0.0,0.5>]
                                }            
                                
                                scale 0.5
                        } 
                }
                    
                
                finish
                {
                        diffuse 0.3
                        ambient <1.0,0.8,0.8>
                }
                
                       
                translate -0.5
                scale<7.5,1.7,7.5>
                rotate z*70   
                rotate y*-45
                translate <2.5,1.0,7.5>       
                
        }     
        
        plane{z,10 pigment{White}}
}



//some spooky haze
fog               
{
        distance 1
        color rgbt <1,1,1,0.5>
        fog_type 2
        fog_offset -1.5
        fog_alt 0.3  
        turbulence 1
}            
        




#include "plant1.pov"
#declare Plant1 = object{TheFormObject} 
#include "plant2.pov"
#declare Plant2 = object{TheFormObject}
/*#include "plant3.pov"
#declare Plant3 = object{TheFormObject}   */
#include "plant4.pov"
#declare Plant4 = object{TheFormObject} 
#include "nettle.pov"
#declare Nettle = object{TheFormObject}
                      
                      
#declare PlantTex = texture
{
        pigment
        {
                cylindrical 
                color_map   
                {
                        [0.6 ForestGreen] 
                        [0.5 rgb<0.5,0.6,0>]
                }
                
        }
        finish
        {
                phong 0.2
                phong_size 20
        }
}


      
//leafy plant on left
object 
{
        Plant1 
                              
        rotate z*15                      
        scale 5
        translate <-1,-0.7,-5>
}            
  
//big pulpy plant on right  
object
{
        Plant2          
        texture{PlantTex}
        
        scale 3            
        rotate y*30
        translate <1,0,-6>
}     
/*
                         
//leafy plant in distance                         
object
{
        Plant3
        pigment{ White }
        
        scale 5
        translate <-0.7,-0.3,-3.5>
}    */                    //I've removed this coz it looks crap

                        
//small shoots in mid-foreground, left                        
object
{
        Plant4
        texture{ PlantTex }
        
        scale 1
        translate <-0.7,-0.4,-6.5>
}       


                   
//ditto, right                       
object
{
        Plant4
        texture{ PlantTex }
        
        scale 0.8
        rotate <0,60,15>
        translate <0.3,-0.3,-7.5>
}          
      
      
                                                                          
//foreground nettle                                                                          
object{ Nettle scale 5 translate<1.5,0.5,-5> pigment{rgb<0.95,0.8,0.5>}}                                                                                                                                   
object{ Nettle scale <3,4,3> rotate y*15 translate<1.5,0.5,-5> pigment{rgb<0.95,0.8,0.5>}}    



//background nettle
object{ Nettle scale 5 translate<0.5,-0.1,-3> pigment{rgb<0.95,0.8,0.5>}} 
//right 

                                                               
object{ Nettle scale 6 translate<-2.0,-0.5,-4.0> pigment{rgb<0.95,0.8,0.5>}}                               
//left

    


    
//Grassy flowers for Plant1    
    
#declare Flower =
union
{
        cylinder{<0,0,0>,<0,20,0>,0.1}
        
        #declare Count = 0;
        #while (Count < 1)                 
        
                #declare Angle = 0;
                #while (Angle < 360)   
                
                        cone
                        {
                                <0,0,0>,0
                                <0.5,0,0>,0.15  
                                open
                                
                                rotate z*-Count*45 
                                rotate y*Angle
                                scale 1+Count
                                translate y*(20 - Count * 2)
                        }
                        
                        #declare Angle = Angle + 60;
                #end 
        
                #declare Count = Count + 0.2;
        #end
}                       

    
 
union
{ 
        object{ Flower scale 0.08 rotate x*15 rotate y*60 } 
        object{ Flower scale 0.07 rotate x*17 rotate y*270 }   
        object{ Flower scale 0.10 rotate x*5 rotate y*100 }    
        texture
        {       
                gradient y
                texture_map
                {
                        [0.5 pigment{MediumForestGreen}]
                        [1 pigment{rgb<0.95,0.95,0.3>} finish{ambient 0.2 diffuse 1}]
                }                
                scale 2
        }   
        
        
        translate <-1.25,-0.7,-5>
       
}









//this routine should build a twisty stick-type thing around the y-axis

 #declare Twig =
union
{
        #declare XPos = 0;
        #declare YPos = 0;
        #declare ZPos = 0;
        #declare Step = 0;
        sphere{ <0,0,0> , 0.1/(Step + 1)}
        #while (Step < 1)
                #declare Step = Step + 0.2;
                #declare OldX = XPos;
                #declare OldY = YPos;
                #declare OldZ = ZPos;  
                
                #declare XPos = 0.5*sin(2*Step*pi);
                #declare YPos = Step * 5; 
                #declare ZPos = 0.5*cos(2*Step*pi);
                
                cone{<OldX,OldY,OldZ>,0.1/(Step + 0.8),<XPos,YPos,ZPos>,0.1/(Step+1)}
                sphere{<XPos,YPos,ZPos>,0.1/(Step+1)}
                        
        #end    
        
        scale 0.2                
}   

 //the following stuff should result in a decent tree
#declare Tree1 =
union
{
        object{Twig}
        object{Twig scale 0.8 rotate <0,90,-15> translate <0.1*sin(2*0.2*pi),0.2,0.1*cos(2*0.2*pi)> }  
        object{Twig scale 0.5 rotate <-30,-90,0> translate <0.1*sin(2*0.6*pi),0.6,0.1*cos(2*0.6*pi)> }  
        object{Twig scale 0.5 translate <0,1,0.1>}
        
        
}         

#declare Tree2 =
union
{
        object{Tree1}
        object{Tree1 scale 0.8 rotate <0,90,-15> translate <0.1*sin(2*0.2*pi),0.2,0.1*cos(2*0.2*pi)> }  
        object{Tree1 scale 0.5 rotate <-30,-90,0> translate <0.1*sin(2*0.6*pi),0.6,0.1*cos(2*0.6*pi)> }  
        object{Tree1 scale 0.5 translate <0,1,0.1>}
}            
          
          
          
#declare Tree3 =
union
{
        object{Tree2}
        object{Tree2 scale 0.8 rotate <0,90,-15> translate <0.1*sin(2*0.2*pi),0.2,0.1*cos(2*0.2*pi)> }  
        object{Tree2 scale 0.5 rotate <-30,-90,0> translate <0.1*sin(2*0.6*pi),0.6,0.1*cos(2*0.6*pi)> } 
        object{Tree2 scale 0.5 translate <0,1,0.1>} 

}    

#declare Tree4 =
union
{
        object{Tree3}
        object{Tree3 scale 0.8 rotate <0,90,-15> translate <0.1*sin(2*0.2*pi),0.2,0.1*cos(2*0.2*pi)> }  
        object{Tree3 scale 0.5 rotate <-30,-90,0> translate <0.1*sin(2*0.6*pi),0.6,0.1*cos(2*0.6*pi)> } 
        object{Tree3 scale 0.5 translate <0,1,0.1>} 

     
}    


object {Tree4 scale 3 rotate <0,180,10> translate<2,0,0> pigment{rgb<0.4,0.6,0>}}
object {Tree3 scale 1.5 rotate <0,45,25> translate<1,0,-2> pigment{rgb<0.4,0.6,0>}}

//fallen branches       
union
{                                                                                                                                         
        object {Tree1 scale 0.5 rotate x*40 rotate y*-30 rotate z*95 translate<-0.1,-0.315,-8.5> }
        object {Twig scale 0.5 rotate <40,0,95> translate<0.4,-0.280,-9.3> }                                           
        object {Tree1 scale 0.5 rotate <60,180,97> translate<0.1,-0.25,-8.5>} 
        object {Twig scale 0.5 rotate y*45 rotate <40,0,95> translate<0.55,-0.21,-8.97> }
        object {Twig scale 0.7 rotate <40,180,95> translate<0.3,-0.21,-8.1>} 
        object {Twig scale 0.3 rotate <30,90,95> translate<0.2,-0.23,-9.4>}                                                                                                                                

        texture
        {
                pigment {rgb<0.5,0.4,0>}
                normal {bumps 5 scale <0.04,0.0075,0.04>}   
                finish {phong 0.1}
        }
        
}                   
                   
                   
                   
                   
                   
                   
//build some csg boulders

#declare boulder1 =
difference
{       
        sphere{0,1 scale <1,1.5,1>}
        
        plane{<-2.5,-1,0.25>, -0.75}  
        plane{<-2.5,-1,0.25>, -0.75 rotate y*30}
        plane{<-2.7,-1,0.25>, -0.8 rotate y*65}
        plane{<-4,-1,0.25>, -0.6 rotate y*70}
        plane{<-2,-1,0.25>, -0.81 rotate y*15}
        plane{<-2.5,-1,0.25>, -0.75 rotate y*83} 
        plane{<-0.25,-1,0.25>,-1}
                
}               
      
        
        
        
        #declare StoneTex =
        texture
        { 
                    pigment 
                    {
                        granite
                        turbulence 1.25
                        colour_map  
                        {
                            [0.15 colour rgbf<0.72549, 0.73725, 0.54118, 0.0>]
                            [0.25 colour rgbf<0.22745, 0.14510, 0.00000, 0.0>]
                            [0.45 colour rgbf<0.72549, 0.73725, 0.54118, 0.0>]
                            [0.60 colour rgbf<0.22745, 0.14510, 0.00000, 0.0>]
                            [0.80 colour rgbf<0.22745, 0.14510, 0.00000, 0.0>]
                            [1.00 colour rgbf<0.60392, 0.61176, 0.46667, 0.0>]
                        }
                        
                        scale <0.95, 1.7, 0.39>
                        rotate <10, 5, 40>
                    }
                    
                    finish { brilliance 2.125 }  
                    normal { dents scale 0.1 }
        }
        
                
                texture  
                {
                    pigment 
                    {
                        granite
                        turbulence 0.825
                        colour_map 
                        {
                            [0.35 colour rgbf <0.56078, 0.54902, 0.42353,0.65>]
                            [0.65 colour rgbf <0.10196, 0.05882, 0.00000,0.85>]
                            [1.00 colour rgbf <0.56078, 0.54902, 0.42353,0.90>]
                        }
                        scale <0.76, 1.4, 0.4>
                        rotate <0, 10, -55>
                    }
                    finish { ambient 0.4 diffuse 0.575 crand 0.021 } 
                    normal { dents scale 0.1 }
                } 
 
 
object
{
        boulder1 
        scale 0.75
        rotate y*95             
                    




                
                
                
                
        
        texture
        {
                
                        
                leopard
                texture_map
                {
                        [0.2 StoneTex] 
                        [0.7 pigment{rgb<0.7,0.7,0.3>}] 
                        [0.71 pigment{rgb<0.7,0.7,0.3>}]
                } 
                
                scale 0.25    
                            
                
        }
        
        translate<1,0,-3>
}                     



       
       
       
//the big fallen tree in background       
#include "stump.pov"
#declare Stump = 
union
{
        object{TheFormObject}  
        difference
        {
                cone{<0,-0.1,0>,0.15,<0,-1.5,0>,0.15}
                sphere{<0,-0.1,0>,0.15 scale <1,0.2,1>} 
        }
        
}     



#declare MudTex =
texture
{
        pigment {rgb<0.3,0.2,0>} 
        normal {bozo 0.2 scale<0.1,1,0.1>}
}

#declare BarkTex = 
texture
{
        pigment {rgb<0.5,0.4,0>}
        normal {bozo 0.2 scale<0.1,1,0.1>}
}

#declare MossTex =
texture
{
        pigment{rgb<0.4,0.5,0>}    
        normal {bozo 0.2 scale<0.1,1,0.1>}
}



object
{            
          
        
        Stump
        
        texture  
        {
                cylindrical   
                texture_map
                {        
                        [0 MudTex]
                        [0.08 MossTex]
                        [0.1 BarkTex]
                        [0.15 BarkTex]
                        [1 MudTex]
                }       
                turbulence 1    
                scale<0.2,10,0.2>
        } 
        
        
        scale 7 
        
        rotate x*-90
        rotate y*20
        translate<-2.5,0,0>
                
}


//Put Twigs in root structure
                       
#declare Count = 0;
#while (Count <= 360)
        object
        {
                Twig    
                scale<0.5,1,0.5>
                translate y*(1 - mod (Count, 10)/20) 
                rotate y*Count*37
                rotate z*Count*21
                rotate x*-mod(Count,90)
                translate z*0.5  
                
                rotate y*20
                translate x*-2.5 
                
                pigment{IndianRed}
        }
        
        #declare Count = Count + 1;
#end            

//Get a diffuse muddy ball
sphere
{
        <0,0,0,>,2
        pigment{ rgbf 1}
        
        hollow yes
        
        interior
        {
                media
                {                                                                                                              
                        absorption rgb<0.8,0.8,1>
                        scattering {1, Gray20}
                        emission Gray20  
                        /*density
                        {
                                spherical
                                color_map
                                {
                                        [0 White]
                                        [0.2 Black]
                                }
                                
                                scale 1
                        }        */      
                        density
                        {
                                leopard
                                color_map
                                {
                                        [0 Black]
                                        [0.5 Black]
                                        [0.5 White]
                                        [1 White]
                                }     
                                scale 0.1
                        }        
                        
                        density
                        {
                                leopard
                                color_map
                                {
                                        [0 Black]
                                        [0.5 Black]
                                        [0.5 White]
                                        [1 White]
                                }     
                                scale 0.1
                        }
                        //two copies should double the density
                        
                }
        }         
        
        translate<-2.5,0,0>
}
   
   
   
   
   
   






//slap a frog in the scene


#declare Backleg =
blob
{             
        //leg
        threshold 0.3
        sphere {<0,0,0>,0.2,1}     
        sphere {<-0.015,-0.025,0.022>,0.19,1}
        sphere {<-0.03,-0.05,0.044>,0.18,1} 
        sphere {<-0.06,-0.1,0.088>,0.16,1}
        cylinder{<0,0,0>,<-0.15,-0.25,0.22>,0.1,1}  
        
        //toes
        sphere {<0,-0.25,0.3>,0.05,1} 
        sphere {<0.1,-0.25,0.25>,0.05,1}
        sphere {<0.05,-0.25,0.2>,0.05,1}
        cylinder{<-0.15,-0.25,0.22>,<0,-0.25,0.3>,0.025,1}   
        cylinder{<-0.15,-0.25,0.22>,<0.1,-0.25,0.25>,0.025,1}  
        cylinder{<-0.15,-0.25,0.22>,<0.05,-0.25,0.2>,0.025,1}  
}    

#declare Frontleg =
blob
{                              
        threshold 0.3
        cylinder{<0,0,0>,<0.1,-0.1,0.15>,0.07,1}          //upper arm
        cylinder{<0.1,-0.1,0.15>,<0.2,-0.1,0.20>,0.07,1}  //forearm
        
        
        //toes
        sphere{<0.35,-0.1,0.225>,0.05,1}
        sphere{<0.32,-0.1,0.3>,0.05,1}
        sphere{<0.34,-0.1,0.15>,0.05,1} 
        
        cylinder{<0.2,-0.1,0.20>,<0.35,-0.1,0.225>,0.025,1}   
        cylinder{<0.2,-0.1,0.20>,<0.32,-0.1,0.3>,0.025,1}   
        cylinder{<0.2,-0.1,0.20>,<0.34,-0.1,0.15>,0.025,1}         
}



#declare Frog = 
union
{       
        union
        {
                blob
                {           
                        threshold 0.3
                        cylinder{<0.1,0,0>,<-0.2,0,0>,0.3,2}   //main body section
                        sphere{<0.3,0,0>,0.25,1}                 //nose
                        sphere{<0.3,0.1,0.1>,0.1,0.8}              //right eye  
                        sphere{<0.3,0.1,-0.1>,0.1,0.8}             //left eye
                        sphere{<-0.15,0.1,0.12>,0.3,1}             //right flank   
                        sphere{<-0.15,0.1,-0.12>,0.3,1}            //left flank    
                        sphere{<-0.3,0,0.1>,0.3,1}             //right buttock
                        sphere{<-0.3,0,-0.1>,0.3,1}            //left buttock  
                        
                        
                        cylinder{<0.1,-0.1,-0.3>,<0.1,-0.1,0.3>,0.3,-0.4}
                        sphere{<0.1,-0.1,0>,0.2,-0.6}
                                                                //a fiddle to flatten the stomach
                }            
                
                object{Backleg translate <-0.15,0.15,0.175>}   
                object{Backleg translate <-0.15,0.15,0.175> scale<1,1,-1>}   
                
                object{Frontleg translate <0.1,0,0.1>}
                object{Frontleg translate <0.1,0,0.1> scale<1,1,-1>}  
                
                
                
                pigment
                {
                        bozo
                        color_map
                        {
                                [0.4 rgb<0.8,0.3,0.3>]
                                [1 Black]
                        }    
                        
                        turbulence 1
                        scale 0.05
                        
                }   
                      
                              
                normal{ bumps 1 scale 1.0}
                finish
                {
                        phong 0.5
                        phong_size 10
                        ambient 0.25
                }
         
                
                
                
        }
        
        
        #declare EyeTex =
        texture
        {
                pigment
                {
                        cylindrical
                        colour_map
                        {                 
                                [0 Red]
                                [0.5 Yellow]
                                [0.7 Yellow]
                                [0.7 Black]  
                                [1 Black]
                        }
                        scale 0.07
                } 
                
                finish
                {           
                        phong 1
                        phong_size 100
                }
                
        }
        
                
        sphere
        {
                <0,0,0>,
                0.07 
                texture{EyeTex rotate x*55 rotate y*30}
                translate <0.31,0.1,0.11>
        }
        //right eye  
        sphere
        {
                <0,0,0>,
                0.07 
                texture{EyeTex rotate x*-55 rotate y*-30}
                translate <0.31,0.1,-0.11> 
        }
        //left eye
        
        
        
}



object
{
        Frog    
        scale 0.1
        rotate y*-135
        rotate x*-40 
        translate<0.22,-0.28,-8.8>
        
        
        
        
        
}   



//put some mushrooms in
#include "mushroom.inc"

object{Shroom1 rotate y*70 scale 0.05 translate<-0.2,-0.35,-8.7>}   
object{Shroom1 rotate y*140 scale 0.055 translate<-0.28,-0.34,-8.9>}   
object{Shroom1 rotate y*210 scale 0.045 translate<-0.28,-0.34,-8.5>}   
object{Shroom1 rotate y*280 scale 0.06 translate<-0.10,-0.31,-8.95>}   
object{Shroom1 rotate y*350 scale 0.05 translate<-0.08,-0.34,-8.6>}   
object{Shroom1 rotate y*420 scale 0.0525 translate<-0.10,-0.34,-8.4>}   
object{Shroom1 rotate y*490 scale 0.045 translate<-0.24,-0.31,-9.2>} 

object{Shroom1 rotate y*30 scale 0.05 translate<-0.3,-0.35,-8.7>}   
object{Shroom1 rotate y*60 scale 0.055 translate<-0.20,-0.34,-8.9>}   
object{Shroom1 rotate y*90 scale 0.045 translate<-0.18,-0.34,-8.5>}   
object{Shroom1 rotate y*120 scale 0.06 translate<-0.04,-0.32,-8.98>}   
object{Shroom1 rotate y*150 scale 0.05 translate<-0.14,-0.34,-8.6>}   
object{Shroom1 rotate y*180 scale 0.0525 translate<-0.15,-0.34,-8.4>}   
object{Shroom1 rotate y*230 scale 0.045 translate<-0.18,-0.31,-8.99>}    
                        //cluster of small 'shrooms, fg left

object{Shroom3 rotate y*90 scale 0.1 translate<-0.38,-0.35,-8.65>}
                        //big solitary 'shroom, fg left
                        
                        
object{Shroom2 rotate y*030 scale 0.040 translate <0.50,-0.18,-8.0>}  
object{Shroom2 rotate y*060 scale 0.041 translate <0.55,-0.24,-8.1>}   
object{Shroom2 rotate y*090 scale 0.042 translate <0.45,-0.23,-8.2>}   
object{Shroom2 rotate y*120 scale 0.043 translate <0.40,-0.23,-8.3>}   
object{Shroom2 rotate y*150 scale 0.044 translate <0.43,-0.25,-8.4>}   
object{Shroom2 rotate y*180 scale 0.045 translate <0.45,-0.25,-8.5>}   
object{Shroom2 rotate y*210 scale 0.035 translate <0.36,-0.23,-8.1>}   
object{Shroom2 rotate y*240 scale 0.036 translate <0.53,-0.25,-8.2>}   
object{Shroom2 rotate y*270 scale 0.037 translate <0.38,-0.24,-8.3>}   
object{Shroom2 rotate y*300 scale 0.038 translate <0.42,-0.26,-8.4>}   
object{Shroom2 rotate y*330 scale 0.039 translate <0.47,-0.29,-8.5>}   
object{Shroom2 rotate y*360 scale 0.041 translate <0.35,-0.28,-8.1>}   
object{Shroom2 rotate y*030 scale 0.042 translate <0.37,-0.29,-8.2>}
                        //cluster of twisty 'shrooms, mid right
                        
object{Shroom3 rotate y*90 rotate x*-15 scale 0.12 translate<0.12,-0.35,-7.0>
        pigment
        {
                leopard
                colour_map
                {
                        [0 rgb<0.7,0.7,0.4>]
                        [1 rgb<0.8,0,0>]
                } 
                scale 0.12
        }
}
object{Shroom3 rotate x*-10 scale 0.08 translate<0.02,-0.35,-6.8>}  
object{Shroom3 rotate x*-20 scale 0.06 translate<0.33,-0.29,-7.0>}
                        //3 large 'shrooms, mid center    
                        
                        
object{Shroom4 scale 1.1 rotate y*40 rotate z*-1 rotate x*-10 scale 0.07 translate<-0.15,-0.32,-9.2>}
                        //Signature 'shroom 
                        
                        
                        
 
//puddles  


disc
{
        <0,0,0>,
        y,   
        0.32       
          
        normal 
        {            
                cylindrical
                normal_map
                {       
                        [0 ripples]
                        [1 
                                wood 0.05
                                scale -0.08
                                rotate x*90
                                turbulence 0.1  
                                ]
                                
                                
                }               
                scale 0.3
        }
        
        pigment {rgbf<0.6,0.5,0.0,0.8>} 
        finish
        { 
                reflection 0.3
                phong 0.1
        }
        
                      
        translate x*-sqrt(pow(0.205,2)-pow(0.15,2)) //needed to centre the disc at the intersection with the torus, below
        
        rotate y*-60              
        translate<0.31,-0.33,-8.76>     
        
}  

disc
{
        <0,0,0>,
        y,
        0.5                  
        
        texture { Water scale 0.4}   
        pigment {rgbf<0.4,0.5,0,0.7>} 
        finish
                { 
                        reflection 0.3
                        phong 0.3
                }  
        
        translate<-0.38,-0.43,-8.5>
        
}
  
disc
{
        <0,0,0>,
        y,
        1.0       
        
        texture { Water scale 0.4}   
        pigment {rgbf<0.4,0.5,0,0.7>} 
        finish
                { 
                        reflection 0.3
                        phong 0.3
                }  
        
        translate<-0.1,-0.51,-6.5>
        
}        




//trickle in fg right. This object is quite messy. Sorry  
merge
{
        intersection
        {
                torus
                {                              
                        0.19, 0.015                     
                                         
                        rotate x*90
                        rotate y*-60           
                        scale <1,1.05,1>
                                       
                        translate<0.315,-0.48,-8.755>
                } 
                plane{-y,0.33}    
                plane
                {
                        y,0
                        rotate z*25  
                        translate x*-sqrt(pow(0.205,2)-pow(0.15,2)) 
        
                        rotate y*-60              
                        translate<0.315,-0.33,-8.76> 
                }
                
                                  
                    
                
        }
        
        superellipsoid
        {
                <1, 0.5>
                rotate x*90
                scale <0.18,0.04,0.18>
                
                translate<0.48,-0.29,-8.7>
        }      
        
       
        normal
        {
                gradient y
                normal_map
                {
                        [0.8  marble
                                scale <0.5,5,0.5>   
                                rotate y*30  
                                turbulence 0.5   
                                ]
                        [1  ripples 
                                scale 0.26/0.04 
                                frequency 10 
                                ]
                                      
                } 
                scale 0.08
                translate y*-0.33
        }       
                     
        pigment
        {
                gradient y
                colour_map
                { 
                        [0.6 rgbf 1]
                        [1 rgbf<0.55,0.5,0.0,0.7> ]
                }
                scale 0.08
                translate y*-0.33
        }
        
        
        finish
                { 
                        reflection 0.3
                        phong 0.3
                }  
        
}  




//add in the ferns
#include "fern.inc"

object{Fern scale 0.3 translate<-0.5,-1.0,-1.3>} 
object{Fern rotate y*15 scale 0.25 translate<-1.3,-1.0,-2.7>}                                                                            
object{Fern rotate y*45 scale 0.08 translate<-0.0,-0.4,-4.3>}              
object{Fern rotate y*30 scale 0.15 translate<0.5,-0.5,-1.2>}


//background trees
box
{
        <0,0,9.9>,<1,1,9.91> 
                         
        texture
        {
                material_map
                {
                        png "Trees.png"
                        once    
                        
                        texture //color 0 : background
                        {
                                pigment{rgbt 1}
                        }
                        texture //color 1 : wood
                        {       
                                pigment
                                {
                                        granite 
                                        color_map
                                        {
                                                [0 rgb<0.4,0.4,0>]
                                                [0.3 rgb<0.05,0.05,0>]
                                        } 
                                        scale <0.05,1,0.05>
                                } 
                                normal
                                {
                                        granite
                                        scale <0.05,1,0.05>
                                }
                                
                                        
                        }                
                        texture //color 2 : shadow
                        {
                                pigment
                                {
                                        granite 
                                        color_map
                                        {
                                                [0 rgb<0.3,0.3,0>]
                                                [0.3 rgb<0.05,0.05,0>]
                                                [0.5 Black]
                                        } 
                                        scale <0.05,1,0.05>
                                }               
                                normal
                                {
                                        granite
                                        scale <0.05,1,0.05>
                                }
                        }
                        texture //color 3 : highlight
                        {                       
                                pigment { rgb<0.3,0.3,0> }                                                                                              
                                normal
                                {
                                        granite
                                        scale <0.05,1,0.05>
                                }
                        }
                        
                        texture //color 4 : leaves
                        {
                                pigment
                                {
                                        bozo
                                        color_map
                                        {
                                                [0 rgb<0,0.2,0>]
                                                [1 rgb<0,0.0,0>]
                                        }  
                                        scale 0.05
                                }      
                                normal
                                {
                                        granite
                                        scale 0.05
                                }
                                
                                
                                
                                
                        }             
                        
                        texture //color5 : transparent leaves 
                        {
                                pigment{rgbf<0,0.2,0,0.1>}
                                
                                normal
                                {
                                        bozo 0.5
                                        scale 0.05
                                } 
                        }
                        
                }  
                scale 1.001
        }      
        no_shadow                             
        scale <6.4,4.8,1> 
        scale <1.4,1.4,1>
        translate<-7.0,1.0,0>  
                
}