// Persistence of Vision Ray Tracer Scene Description File
// File: mars.pov
// Vers: 3.1
// Desc: for the IRTC May/June Wilderness round
// Date: 06/30/00
// Auth: Bob Franke
//

#version 3.1;

#include "colors.inc"

global_settings{assumed_gamma 2.4}


camera{
  location <200,-30,60>
  direction .9*z
  right     800/400*x
  look_at   <0, -75, 150>
}

sky_sphere{pigment{ White }}

light_source{     
  <10000,5000,-1000>
  color White*1.75
}

height_field {
  tga "marsmap2.tga"
  smooth
  pigment { color rgb <0.663, 0.392, 0.188>*1.3}  
  finish{crand .05}
  translate <-.5, -.5, -.5>   
  rotate<0,180,0>
  scale <880, 100, 880>
} 
    
fog {
  fog_type 1 // 1=constant, 2=ground_fog
  distance 400
  color rgb <0.784, 0.588, 0.255>*1.1
}
