/*
 *	"Sunrise over Lake Solitude"
 *
 *	Created for the IRTC topic "Wilderness"
 *	Copyright Mark Wagner 2000
 *
 *      Note: Because of a mistake I made, in order for the atmosphere to
 *      render properly, you must render the file "sol_sky.inc" rather than
 *      this file.
 *
 */


// Standard header stuff

#declare included = true;
#version unofficial MegaPov 0.5;

global_settings{ assumed_gamma 1 max_color 10 max_trace_level 8}

// Standard includes
#include "colors.inc"
#include "spectrum.inc" // from www.geocities.com/rengaw03/

// Other includes
// Set up scaling
#declare cm = 1/(30.48 * 100); // 1 pov unit = 100 feet
#include "units.inc"   // from www.geocities.com/rengaw03/
#include "rocks.inc"


//Select what parts of the scene to show
#declare FullMap = false;
#declare Clouds = 2;
#declare Sky = 2;
#declare Haze = off;
#declare Glare = on;
#declare Radiosity = off;
#declare Rocks = on;
#declare Birds = off;

// The height fields for the mountains.  Converted from STDS DEM data using
//  STDSEPOV to convert the STDS data to hf_grey_16 TGA images.
// The naming convention for the heightfields is the USGS map name followed by
//  the map's relation to the central map, in this case the Mt. Moran map.

// North is in the +z direction
#declare VegeObject = union{
	height_field{ tga "grandt~1/high-res TGA/Mt. Moran C.TGA" smooth}
	height_field{ tga "grandt~1/high-res TGA/Grand Teton S.TGA" smooth translate -z}
	#if(FullMap)
		height_field{ tga "grandt~1\high-res tga\Ranger Peak N.tga" smooth translate z}
		height_field{ tga "grandt~1\high-res tga\Moose SE.tga" smooth translate -z+x}
		height_field{ tga "grandt~1\high-res tga\Jenny Lake E.tga" smooth translate x}
		height_field{ tga "grandt~1\high-res tga\Colter Bay NE.tga" smooth translate z+x}
	#end
	no_shadow
	scale <32736,13770*15.734934,45936>*feet
}

// Include this here since the textures depend on VegeObject
#include "soltext.inc"	//Textures specific to this project

object{
	VegeObject
	texture{
		MainHFTexture
	}
}

/* Lake Solitude */
object{
	box{<8900,9105.2,16500>*feet,<7000,9105,15000>*feet}
	texture{
		pigment{rgb 1}
		finish{
			reflection 1
			ambient 0
			diffuse 0
			reflection_blur .003
			reflection_samples 5
			reflection_type 1
			conserve_energy
		}
	}
	interior{
		ior 1.33
	}
}

/* Locations of terrain features:
 *  Lake Solitude: <8000,0,16000>*feet
 *  Cirque Lake: 
 *  Mica Lake: <8500,0,12500>*feet
 *  Jenny Lake:
 *  Mt. Moran:
 *  Mt. Woodring
 *  Mt. St. John:
 *  Grand Teton:
 *  Teewinot Mtn.:
 */

#declare Location = <8000,0,16000>*feet;
#declare Locator = off;

#if(Locator)
	// Black ball points east, red ball points north
	union{
		cylinder{x*-250*feet,x*250*feet,50*feet pigment{rgb <0,0,1>}}
		cylinder{y*-250*feet,y*250*feet,50*feet pigment{rgb <.5,.5,.5>}}
		cylinder{z*-250*feet,z*250*feet,50*feet pigment{rgb <0,1,0>}}
		sphere{x*250*feet,100*feet pigment{rgb 0}}
		sphere{z*250*feet,100*feet pigment{rgb <1,0,0>}}
		scale 1
		translate Location+y*trace(VegeObject,Location+y*10*miles,-y)
		no_shadow
	}
#end

//The sun
light_source{
	<0,0,0>
        Spectrum(255,6000)
        color <_red,_green,_blue>
	looks_like{
		sphere{
			0, 18000
			pigment{rgb <1,1,0>}
			finish{ambient 10 diffuse 0}
		}
	}
	translate x*1000000
	rotate y*39
	rotate z*9
//	rotate z*50
}

// Sun glare
#declare CameraHeight = (trace(VegeObject,<8000,50000,16000>*feet,-y)).y;
#declare camera_location = <8000,CameraHeight/feet+50,16000>*feet;
#declare camera_look_at = <8100,CameraHeight/feet+50,15940>*feet;
#declare effect_location = vrotate(vrotate(<1000000,0,0>,<0,39,0>),<0,0,9>);
#declare glow_type = 4;
#declare glow_colour = <1.5, 1.1, .1>*4;
#declare glow_scale = <1, 1, 1> * 1.3;
#declare effect_always_on_top = false;
#if(Glare)
	#include "LnsEfcts.inc" //Chris Colefax's Lens Effects include
        #declare effect_always_on_top = true;
        #include "LnsEfcts.inc"
#end

// Includes created for this project
// Allow rendering from any file in the project
// The sky and clouds, but not the sun
#ifndef(sky_included)
	#include "sol_sky.inc"
#end

// Cameras are placed last to allow cameras to follow the "Locator" object
#ifndef(cam_included)
	#include "cameras.inc"	// Cameras
#end
camera{solitude_pan_2}
//camera{locate_top}

#if(Radiosity)
global_settings{
	radiosity{
		count 40
		nearest_count 5
		error_bound 3
		recursion_limit 2
		low_error_factor .5
		gray_threshold .5
		minimum_reuse .015
		brightness .2
		adc_bailout .01
	}
}
#end

#if(Rocks)
	object{BigRock1 translate <8025,9103.1,15985>*feet}
#end

#if(Birds)
	#include "sparrow.inc"
	#include "duck.inc"
	#declare BirdHeight = ((trace(BigRock1,<0,100,0>*feet,-y)).y)/feet;
	object{Sparrow translate <8025,9105.8+BirdHeight,15985>*feet}
	// Scatter a few ducks around the pond
	#declare VegeList = array[1]
	#declare VegeList[0] = object{Duck scale 3}
	#declare VegeMinBox = <8000,15500>*feet;
	#declare VegeMaxBox = <8150,16000>*feet;
        #include "vegetate.inc"
#end