#include "cactus1.inc"
#include "cactus2.inc"
#include "sun.inc"
#include "fish.inc"
#include "pyramid.inc"
#include "prickleypear.inc"


#version unofficial MegaPov 0.5;


global_settings {
	ambient_light rgb <0.47, .47, .47>
	assumed_gamma 1.8
}


camera {
	perspective 
	location <14, 8.0,-166>
	look_at <50.0, 0.0, 17.0>
}

//camera {
//	perspective 
//	location <14, 8, -160>
//	look_at <14, 3, -145.0>
//}


light_source {
	<20, 30, -300>
	rgb <0.436007, 0.436022, 0.519986>
	shadowless
}
light_source {
	<270, 50, 1500>
	rgb <.5, .5, .5>
	shadowless
}
light_source {
	<250, 300, 4200>
	rgb <4, 4, 4>
//	parallel
//	point_at <10.0, 0.0, -170.0>
//	looks_like { mySun }
	area_light <0.0, 5.0, 5.0>,   < 5.0,  0.0, 0.0 >,  5,  5
	orient 
}
//light_source {
//	<350, 50, 2200>
//	rgb <1.0, 1.0, 1.0>
//	parallel
//	point_at <0.0, 0.0, 0.0>
//	area_light <0.0, 5.0, 5.0>,   < 5.0,  0.0, 0.0 >,  5,  5
//	looks_like { }
//	
//}


//light_source {
//	<350, 50, 2200>
//	rgb <1.0, 1.0, 1.0>
//	
//	
//	looks_like { mySun }
//}


sky_sphere { 
	pigment { gradient <0.0, 1.0, 0.0>
	color_map {
		[ 0.0 rgb <1.000000, 0.320943, 0.030030> ]
		[ .45 rgb <0.949996, 0.764660, 0.095018> ]
		[ .55 rgb <0.984390, 0.070024, 1.000000> ]
		[ .65 rgb <0.035019, 0.046204, 0.699992> ]
		[ 1 rgb <0.035019, 0.046204, 0.699992> ]
	}
	//rotate <90, 0.0, 0.0>
	scale 2.5
	translate -1
}

}



//dark brown box for ground
box {
	<-500, -10, -2500>, <500, 2.999, 2500>
	texture {
		pigment {
			rgb <0.609995, 0.348394, 0.103700>
		}
		finish {
			ambient rgb <0.507771, 0.507771, 0.507771>
			diffuse .675
		}

normal {
	granite 0.7
	bump_size .0085
//	granite 0.5
//			bump_size 0.2
//			scale .3
}

	}
}

//light brown boxes to be dispersed over the brown box for a striped effect
#declare C = 0;
#declare Copies = 20;

#while ( C < Copies)
	box {
		<-26, -10, -2500>, <0, 3, 2500>
		texture {
			pigment {
				rgb <0.839994, 0.731609, 0.478798>
			}
		normal {
			granite 0.7
			bump_size .0085
//granite 0.5
//			bump_size 0.2
//			scale .3
		}	
		finish {
			ambient rgb <0.507771, 0.507771, 0.507771>
			diffuse .675
		}
		}

		translate x * (-475 + (C * (1000)/(Copies -1)))
	} //object
	#declare C = C +1;
#end  //while (C < Copies)

//background mountain range
height_field {
	tga "newRangeHiGr.tga"
 
	texture {
		pigment {
		
////			gradient <0.0, 1.0, 0.0>
////			color_map {
////				[ 0.0 rgb <0.609995, 0.348394, 0.103700> ]
////				[ .5 rgb <0.676967, 0.620005, 1.000000> ]
////				[ .75 rgb <0.676967, 0.620005, 1.000000> ]
////				[ 1.0 rgb <1.0, 1, 1> ]
////			}
			
			rgb <0.609995, 0.348394, 0.103700>
			}
		finish {
			diffuse 0.6
		}
	}
	scale <2500, 700, 2500>
	translate <-1350, -50.0, -550>
//////	smooth
}

object { cactus1
				scale .2
				rotate y*25
				translate < 32, 9, -141 >
				}
				
object { cactus2
				scale .2
				translate < 0, 9.2, -123>
				}
object { cactus1
				rotate y*-40
				scale .2
				translate < -12, 9, -55 >
				}
object { cactus2
				scale .2
				rotate y*-90
				translate < 120, 9.2, -40>
				}
object { mySun 
//				scale 3.5
				translate <350, 40, 2200>
				no_shadow
				}

object { myFish
				rotate < 0, 70, 0> 
				translate < 20, 6, -150 >
				}
				
object { myFish
				rotate < 0, 40, -90> 
				translate < 21, 2.85, -153 >
				}
				
//place a box under the fish to put a ripple normal on
cylinder {
	<0.0, -0.5, 0.0>, <0.0, 3, 0.0>, 2.5
	texture {
		pigment {
			rgb <0.609995, 0.348394, 0.103700>
		}
		finish {
			ambient rgb <0.457771, 0.457771, 0.457771>
			diffuse .65
		}
		normal {
			ripples .75
			scale .35
		}

	}
	translate < 21, 0, -153 >
}

object { myPyramid
				rotate y*45
				translate < 90, 2.75, 20 >
				}
				
object { myPyramid
				rotate y*45
				translate < -40, 2.75, 150 >
				}
				
object { myFish
				rotate < 0, 40, 70> 
				translate < 16, 3, -147 >
				}
				
//place a box under the fish to put a ripple normal on
cylinder {
	<0.0, -0.5, 0.0>, <0.0, 3, 0.0>, 3.0
	texture {
		pigment {
			rgb <0.609995, 0.348394, 0.103700>
		}
		finish {
			ambient rgb <0.457771, 0.457771, 0.457771>
			diffuse .65
		}
		normal {
			ripples .75
			scale .35
		}
	}
	translate <16, 0, -147>
	}
	
object { prickleyPear
				rotate y*5
				translate < 10, 3.90, -143>
				}