// File generated by sPatch, Copyright 1996-1998 by Mike Clifton
#version unofficial MegaPov 0.5;

#include "colors.inc"

#include "SeaStuff.pov"
#include "Bottle.pov"

#declare Quality=3; // 0, 1, 2, 3

global_settings {
	ambient_light rgb 0.2
	ini_option "+QR"
	radiosity{    
		pretrace_start 0.04//0.08
		#if ( Quality < 1 )
			pretrace_end   0.08
		#else 
			#if ( Quality < 2 )
				pretrace_end   0.04
			#else
				pretrace_end   0.04//0.02
			#end
		#end
		count 35             // CHANGE range from 20 to 150
		nearest_count 5      // CHANGE range from 3 to 10
		error_bound 1.8      // CHANGE - range from 1 to 3
		recursion_limit 4    // CHANGE        low_error_factor .5  // leave this
		gray_threshold 0.0   // leave this    minimum_reuse 0.015  // leave this
		brightness 1         // leave this    
		adc_bailout 0.01/2   // CHANGE - use adc_bailout = 0.01 / brightest_ambient_object
		media on
	}
}

background { color rgb <0, 0, 0> }

camera {
	location <-10, .1, -5>
	look_at <-5, -0.35, 0.000>
}

#declare MediaType = 3;


#declare MiddleDistance_Media =
	media {
	
		scattering {MediaType, .4 extinction 1}
		
		method 3
		samples 9, 9
		jitter 0.75
		aa_level 5
		aa_threshold 0.02
		intervals 1
		confidence .999
		variance 1/2
		ratio .7
		#if ( Quality > 2 )
			density {
				bozo 
				warp { turbulence 2 octaves 4}
				colour_map {
					[0    rgb 1  ]
					[0.45 rgb 0.8]
					[0.55 rgb 0.3]
					[1    rgb 0.1]
					
				}
			}
		#end
	}


intersection {
	plane {
		y, 4
	}
	sphere
	{
	  <-10, .5, -5> // center of sphere <X Y Z>
	  1000       // radius of sphere
	}
	texture
	  {
	 	pigment { Clear }
	  }
	hollow on
	interior {
		media { MiddleDistance_Media }
	}
}
	
sphere
{
  <-10, .5, -5> // center of sphere <X Y Z>
  10       // radius of sphere
  hollow on
  texture
  {
  	pigment { Clear }
  }
}

plane { y,-.4
	texture {
		pigment {color rgbf <1, 1, 1, 1>}
		normal { ripples translate <2,1,1>}
		finish {
			phong 1 phong_size 90 diffuse 0
			reflection_min .1
			reflection_max .9
			reflection_falloff 2
			conserve_energy
		}
	}
	interior { 
		ior 1.33
		media {
			absorption .2
			method 3
			samples 1,1
		}
	}
	hollow
}


light_source {
	< 100, 300, 60 >
	color rgb <.9, .9, 1>
	media_interaction on
	media_attenuation on
}

// create a point "spotlight" (conical directed) light source
light_source
{
	<-2.8,0.1,-.3>                 // light's position 
	color rgb <1,1,.8>*0.75       // light's color	
  	looks_like { sphere { 0, .05 texture { pigment { Yellow } } finish { ambient 1 } } }
	spotlight               // this kind of light source
	point_at <-10, -.4, -3> // direction of spotlight
	radius 2.5                // hotspot (inner, in degrees)
	tightness 50            // tightness of falloff (1...100) lower is softer, higher is tighter
	falloff 8               // intensity falloff radius (outer, in degrees)
	media_interaction on
	//media_attenuation on
}
	

#declare Hull_Wood_P = pigment
	{
		wood
		pigment_map
		{
			[ 0.7 DarkWood*.25 ]
			[ 1.0 DarkWood*.80 ]
		}
		rotate y*90
		scale 0.01
		warp {turbulence 0.1}
}
			

#declare Hull_T = texture
	{
		pigment {Hull_Wood_P }
	}


// Layer 2
union {
	bicubic_patch {
		type 1
		flatness 0.5
		u_steps 3
		v_steps 3
		<1.750, 0.000, -0.500> <1.733, -0.150, -0.448> <1.745, -0.368, -0.399> <1.693, -0.500, -0.325> 
		<1.300, 0.000, -0.575> <1.283, -0.150, -0.523> <1.366, -0.368, -0.447> <1.313, -0.500, -0.374> 
		<0.705, 0.000, -0.712> <0.758, -0.150, -0.633> <0.728, -0.379, -0.565> <0.809, -0.500, -0.463> 
		<0.250, 0.000, -0.750> <0.303, -0.150, -0.671> <0.346, -0.379, -0.589> <0.427, -0.500, -0.488> 
	}
	bicubic_patch {
		type 1
		flatness 0.5
		u_steps 3
		v_steps 3
		<1.750, 0.000, -0.500> <1.750, 0.000, -0.200> <1.750, 0.000, 0.200> <1.750, 0.000, 0.500> 
		<1.733, -0.150, -0.448> <1.733, -0.150, -0.148> <1.733, -0.150, 0.148> <1.733, -0.150, 0.448> 
		<1.745, -0.368, -0.399> <1.745, -0.368, -0.204> <1.745, -0.368, 0.204> <1.745, -0.368, 0.399> 
		<1.693, -0.500, -0.325> <1.693, -0.500, -0.130> <1.693, -0.500, 0.130> <1.693, -0.500, 0.325> 
	}
	bicubic_patch {
		type 1
		flatness 0.5
		u_steps 3
		v_steps 3
		<1.750, 0.000, 0.500> <1.300, 0.000, 0.575> <0.705, 0.000, 0.712> <0.250, 0.000, 0.750> 
		<1.733, -0.150, 0.448> <1.283, -0.150, 0.523> <0.758, -0.150, 0.633> <0.303, -0.150, 0.671> 
		<1.745, -0.368, 0.399> <1.366, -0.368, 0.447> <0.728, -0.379, 0.565> <0.346, -0.379, 0.589> 
		<1.693, -0.500, 0.325> <1.313, -0.500, 0.374> <0.809, -0.500, 0.463> <0.427, -0.500, 0.488> 
	}
	bicubic_patch {
		type 1
		flatness 0.5
		u_steps 3
		v_steps 3
		<0.250, 0.000, 0.750> <-0.198, 0.000, 0.787> <-0.427, 0.000, 0.940> <-1.250, 0.000, 0.750> 
		<0.303, -0.150, 0.671> <-0.145, -0.150, 0.709> <-0.303, -0.150, 0.861> <-1.126, -0.150, 0.671> 
		<0.346, -0.379, 0.589> <-0.033, -0.379, 0.613> <-0.304, -0.403, 0.693> <-1.006, -0.403, 0.569> 
		<0.427, -0.500, 0.488> <0.049, -0.500, 0.512> <-0.136, -0.500, 0.613> <-0.838, -0.500, 0.488> 
	}
	bicubic_patch {
		type 1
		flatness 0.5
		u_steps 3
		v_steps 3
		<-1.250, 0.000, 0.750> <-2.295, 0.000, 0.509> <-2.475, 0.000, 0.225> <-3.000, 0.000, 0.000> 
		<-1.126, -0.150, 0.671> <-2.172, -0.150, 0.430> <-2.269, -0.150, 0.225> <-2.794, -0.150, 0.000> 
		<-1.006, -0.403, 0.569> <-1.868, -0.403, 0.415> <-2.113, -0.419, 0.146> <-2.556, -0.419, 0.000> 
		<-0.838, -0.500, 0.488> <-1.700, -0.500, 0.334> <-1.871, -0.500, 0.146> <-2.314, -0.500, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0.5
		u_steps 3
		v_steps 3
		<-3.000, 0.000, 0.000> <-2.475, 0.000, -0.225> <-2.295, 0.000, -0.509> <-1.250, 0.000, -0.750> 
		<-2.794, -0.150, 0.000> <-2.269, -0.150, -0.225> <-2.172, -0.150, -0.430> <-1.126, -0.150, -0.671> 
		<-2.556, -0.419, 0.000> <-2.113, -0.419, -0.146> <-1.868, -0.403, -0.415> <-1.006, -0.403, -0.569> 
		<-2.314, -0.500, 0.000> <-1.871, -0.500, -0.146> <-1.700, -0.500, -0.334> <-0.838, -0.500, -0.488> 
	}
	bicubic_patch {
		type 1
		flatness 0.5
		u_steps 3
		v_steps 3
		<-1.250, 0.000, -0.750> <-0.427, 0.000, -0.940> <-0.198, 0.000, -0.787> <0.250, 0.000, -0.750> 
		<-1.126, -0.150, -0.671> <-0.303, -0.150, -0.861> <-0.145, -0.150, -0.709> <0.303, -0.150, -0.671> 
		<-1.006, -0.403, -0.569> <-0.304, -0.403, -0.693> <-0.033, -0.379, -0.613> <0.346, -0.379, -0.589> 
		<-0.838, -0.500, -0.488> <-0.136, -0.500, -0.613> <0.049, -0.500, -0.512> <0.427, -0.500, -0.488> 
	}
	bicubic_patch {
		type 1
		flatness 0.5
		u_steps 3
		v_steps 3
		<1.451, -0.750, 0.082> <1.451, -0.750, 0.082> <1.451, -0.750, 0.082> <1.451, -0.750, 0.082> 
		<1.451, -0.750, 0.033> <1.242, -0.750, 0.045> <1.242, -0.750, 0.045> <1.242, -0.750, 0.094> 
		<1.451, -0.750, -0.033> <1.259, -0.801, 0.059> <1.172, -0.750, 0.055> <0.962, -0.750, 0.117> 
		<1.451, -0.750, -0.082> <1.259, -0.801, 0.009> <0.962, -0.750, 0.061> <0.752, -0.750, 0.123> 
	}
	bicubic_patch {
		type 1
		flatness 0.5
		u_steps 3
		v_steps 3
		<1.451, -0.750, 0.082> <1.451, -0.750, 0.033> <1.451, -0.750, -0.033> <1.451, -0.750, -0.082> 
		<1.524, -0.675, 0.155> <1.524, -0.675, 0.106> <1.563, -0.720, -0.086> <1.563, -0.720, -0.135> 
		<1.651, -0.605, 0.267> <1.651, -0.605, 0.072> <1.651, -0.605, -0.072> <1.651, -0.605, -0.267> 
		<1.693, -0.500, 0.325> <1.693, -0.500, 0.130> <1.693, -0.500, -0.130> <1.693, -0.500, -0.325> 
	}
	bicubic_patch {
		type 1
		flatness 0.5
		u_steps 3
		v_steps 3
		<1.451, -0.750, 0.082> <1.524, -0.675, 0.155> <1.651, -0.605, 0.267> <1.693, -0.500, 0.325> 
		<1.242, -0.750, 0.094> <1.314, -0.675, 0.167> <1.271, -0.605, 0.315> <1.313, -0.500, 0.374> 
		<0.962, -0.750, 0.117> <1.043, -0.696, 0.249> <0.885, -0.612, 0.369> <0.809, -0.500, 0.463> 
		<0.752, -0.750, 0.123> <0.833, -0.696, 0.255> <0.503, -0.612, 0.394> <0.427, -0.500, 0.488> 
	}
	bicubic_patch {
		type 1
		flatness 0.5
		u_steps 3
		v_steps 3
		<0.053, -0.750, 0.123> <-0.410, -0.750, 0.085> <-0.518, -0.750, 0.037> <-0.763, -0.750, 0.000> 
		<0.446, -0.750, 0.155> <-0.018, -0.750, 0.117> <-0.273, -0.750, 0.000> <-0.518, -0.750, -0.037> 
		<0.542, -0.750, 0.129> <0.433, -0.823, -0.050> <-0.205, -0.782, -0.006> <-0.410, -0.750, -0.085> 
		<0.752, -0.750, 0.123> <0.642, -0.823, -0.056> <0.258, -0.782, -0.044> <0.053, -0.750, -0.123> 
	}
	bicubic_patch {
		type 1
		flatness 0.5
		u_steps 3
		v_steps 3
		<0.053, -0.750, 0.123> <0.446, -0.750, 0.155> <0.542, -0.750, 0.129> <0.752, -0.750, 0.123> 
		<-0.214, -0.675, 0.232> <0.178, -0.675, 0.264> <0.624, -0.696, 0.262> <0.833, -0.696, 0.255> 
		<-0.599, -0.637, 0.373> <0.103, -0.637, 0.498> <0.124, -0.612, 0.418> <0.503, -0.612, 0.394> 
		<-0.838, -0.500, 0.488> <-0.136, -0.500, 0.613> <0.049, -0.500, 0.512> <0.427, -0.500, 0.488> 
	}
	bicubic_patch {
		type 1
		flatness 0.5
		u_steps 3
		v_steps 3
		<0.053, -0.750, 0.123> <-0.214, -0.675, 0.232> <-0.599, -0.637, 0.373> <-0.838, -0.500, 0.488> 
		<-0.410, -0.750, 0.085> <-0.678, -0.675, 0.195> <-1.462, -0.637, 0.220> <-1.700, -0.500, 0.334> 
		<-0.518, -0.750, 0.037> <-0.984, -0.675, 0.037> <-1.424, -0.650, 0.146> <-1.871, -0.500, 0.146> 
		<-0.763, -0.750, 0.000> <-1.228, -0.675, 0.000> <-1.867, -0.650, 0.000> <-2.314, -0.500, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0.5
		u_steps 3
		v_steps 3
		<-0.763, -0.750, 0.000> <-1.228, -0.675, 0.000> <-1.867, -0.650, 0.000> <-2.314, -0.500, 0.000> 
		<-0.518, -0.750, -0.037> <-0.984, -0.675, -0.037> <-1.424, -0.650, -0.146> <-1.871, -0.500, -0.146> 
		<-0.410, -0.750, -0.085> <-0.686, -0.707, -0.191> <-1.462, -0.637, -0.220> <-1.700, -0.500, -0.334> 
		<0.053, -0.750, -0.123> <-0.223, -0.707, -0.229> <-0.599, -0.637, -0.373> <-0.838, -0.500, -0.488> 
	}
	bicubic_patch {
		type 1
		flatness 0.5
		u_steps 3
		v_steps 3
		<0.752, -0.750, -0.123> <0.542, -0.750, -0.129> <0.446, -0.750, -0.155> <0.053, -0.750, -0.123> 
		<0.655, -0.675, -0.232> <0.445, -0.675, -0.239> <0.170, -0.707, -0.261> <-0.223, -0.707, -0.229> 
		<0.503, -0.612, -0.394> <0.124, -0.612, -0.418> <0.103, -0.637, -0.498> <-0.599, -0.637, -0.373> 
		<0.427, -0.500, -0.488> <0.049, -0.500, -0.512> <-0.136, -0.500, -0.613> <-0.838, -0.500, -0.488> 
	}
	bicubic_patch {
		type 1
		flatness 0.5
		u_steps 3
		v_steps 3
		<0.752, -0.750, -0.123> <0.962, -0.750, -0.117> <1.242, -0.750, -0.094> <1.451, -0.750, -0.082> 
		<0.542, -0.750, -0.129> <0.753, -0.750, -0.123> <1.050, -0.801, -0.003> <1.259, -0.801, 0.009> 
		<0.446, -0.750, -0.155> <0.651, -0.782, -0.076> <0.852, -0.823, -0.118> <0.962, -0.750, 0.061> 
		<0.053, -0.750, -0.123> <0.258, -0.782, -0.044> <0.642, -0.823, -0.056> <0.752, -0.750, 0.123> 
	}
	bicubic_patch {
		type 1
		flatness 0.5
		u_steps 3
		v_steps 3
		<0.752, -0.750, -0.123> <0.655, -0.675, -0.232> <0.503, -0.612, -0.394> <0.427, -0.500, -0.488> 
		<0.962, -0.750, -0.117> <0.865, -0.675, -0.226> <0.885, -0.612, -0.369> <0.809, -0.500, -0.463> 
		<1.242, -0.750, -0.094> <1.353, -0.720, -0.147> <1.271, -0.605, -0.315> <1.313, -0.500, -0.374> 
		<1.451, -0.750, -0.082> <1.563, -0.720, -0.135> <1.651, -0.605, -0.267> <1.693, -0.500, -0.325> 
	}
	#ifndef (IMPORT_SPATCH)
	texture { Hull_T }
	#end
}
// Layer 3
union {
	bicubic_patch {
		type 1
		flatness 0.5
		u_steps 3
		v_steps 3
		<-2.962, 0.032, -0.050> <-2.857, -0.057, -0.050> <-2.722, -0.182, -0.050> <-2.613, -0.266, -0.050> 
		<-2.985, 0.013, -0.050> <-2.880, -0.077, -0.050> <-2.744, -0.203, -0.050> <-2.635, -0.286, -0.050> 
		<-3.015, -0.013, -0.050> <-2.910, -0.103, -0.050> <-2.775, -0.229, -0.050> <-2.665, -0.314, -0.050> 
		<-3.038, -0.032, -0.050> <-2.933, -0.123, -0.050> <-2.797, -0.249, -0.050> <-2.687, -0.334, -0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0.5
		u_steps 3
		v_steps 3
		<-2.962, 0.032, -0.050> <-2.962, 0.032, -0.020> <-2.962, 0.032, 0.020> <-2.962, 0.032, 0.050> 
		<-2.857, -0.057, -0.050> <-2.857, -0.057, -0.020> <-2.857, -0.057, 0.020> <-2.857, -0.057, 0.050> 
		<-2.722, -0.182, -0.050> <-2.722, -0.182, -0.020> <-2.722, -0.182, 0.020> <-2.722, -0.182, 0.050> 
		<-2.613, -0.266, -0.050> <-2.613, -0.266, -0.020> <-2.613, -0.266, 0.020> <-2.613, -0.266, 0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0.5
		u_steps 3
		v_steps 3
		<-2.962, 0.032, 0.050> <-2.985, 0.013, 0.050> <-3.015, -0.013, 0.050> <-3.038, -0.032, 0.050> 
		<-2.857, -0.057, 0.050> <-2.880, -0.077, 0.050> <-2.910, -0.103, 0.050> <-2.933, -0.123, 0.050> 
		<-2.722, -0.182, 0.050> <-2.744, -0.203, 0.050> <-2.775, -0.229, 0.050> <-2.797, -0.249, 0.050> 
		<-2.613, -0.266, 0.050> <-2.635, -0.286, 0.050> <-2.665, -0.314, 0.050> <-2.687, -0.334, 0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0.5
		u_steps 3
		v_steps 3
		<-3.038, -0.032, 0.050> <-3.038, -0.032, 0.020> <-3.038, -0.032, -0.020> <-3.038, -0.032, -0.050> 
		<-2.933, -0.123, 0.050> <-2.933, -0.123, 0.020> <-2.933, -0.123, -0.020> <-2.933, -0.123, -0.050> 
		<-2.797, -0.249, 0.050> <-2.797, -0.249, 0.020> <-2.797, -0.249, -0.020> <-2.797, -0.249, -0.050> 
		<-2.687, -0.334, 0.050> <-2.687, -0.334, 0.020> <-2.687, -0.334, -0.020> <-2.687, -0.334, -0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0.5
		u_steps 3
		v_steps 3
		<-2.613, -0.266, -0.050> <-2.533, -0.328, -0.050> <-2.425, -0.415, -0.050> <-2.331, -0.454, -0.050> 
		<-2.635, -0.286, -0.050> <-2.555, -0.349, -0.050> <-2.436, -0.443, -0.050> <-2.342, -0.482, -0.050> 
		<-2.665, -0.314, -0.050> <-2.574, -0.383, -0.050> <-2.464, -0.475, -0.050> <-2.358, -0.518, -0.050> 
		<-2.687, -0.334, -0.050> <-2.596, -0.404, -0.050> <-2.475, -0.502, -0.050> <-2.369, -0.546, -0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0.5
		u_steps 3
		v_steps 3
		<-2.613, -0.266, -0.050> <-2.613, -0.266, -0.020> <-2.613, -0.266, 0.020> <-2.613, -0.266, 0.050> 
		<-2.533, -0.328, -0.050> <-2.533, -0.328, -0.020> <-2.533, -0.328, 0.020> <-2.533, -0.328, 0.050> 
		<-2.425, -0.415, -0.050> <-2.425, -0.415, -0.020> <-2.425, -0.415, 0.020> <-2.425, -0.415, 0.050> 
		<-2.331, -0.454, -0.050> <-2.331, -0.454, -0.020> <-2.331, -0.454, 0.020> <-2.331, -0.454, 0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0.5
		u_steps 3
		v_steps 3
		<-2.613, -0.266, 0.050> <-2.635, -0.286, 0.050> <-2.665, -0.314, 0.050> <-2.687, -0.334, 0.050> 
		<-2.533, -0.328, 0.050> <-2.555, -0.349, 0.050> <-2.574, -0.383, 0.050> <-2.596, -0.404, 0.050> 
		<-2.425, -0.415, 0.050> <-2.436, -0.443, 0.050> <-2.464, -0.475, 0.050> <-2.475, -0.502, 0.050> 
		<-2.331, -0.454, 0.050> <-2.342, -0.482, 0.050> <-2.358, -0.518, 0.050> <-2.369, -0.546, 0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0.5
		u_steps 3
		v_steps 3
		<-2.687, -0.334, 0.050> <-2.687, -0.334, 0.020> <-2.687, -0.334, -0.020> <-2.687, -0.334, -0.050> 
		<-2.596, -0.404, 0.050> <-2.596, -0.404, 0.020> <-2.596, -0.404, -0.020> <-2.596, -0.404, -0.050> 
		<-2.475, -0.502, 0.050> <-2.475, -0.502, 0.020> <-2.475, -0.502, -0.020> <-2.475, -0.502, -0.050> 
		<-2.369, -0.546, 0.050> <-2.369, -0.546, 0.020> <-2.369, -0.546, -0.020> <-2.369, -0.546, -0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0.5
		u_steps 3
		v_steps 3
		<-2.331, -0.454, -0.050> <-2.178, -0.517, -0.050> <-1.963, -0.574, -0.050> <-1.799, -0.600, -0.050> 
		<-2.342, -0.482, -0.050> <-2.189, -0.544, -0.050> <-1.963, -0.604, -0.050> <-1.800, -0.630, -0.050> 
		<-2.358, -0.518, -0.050> <-2.194, -0.586, -0.050> <-1.975, -0.642, -0.050> <-1.800, -0.670, -0.050> 
		<-2.369, -0.546, -0.050> <-2.206, -0.614, -0.050> <-1.975, -0.672, -0.050> <-1.801, -0.700, -0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0.5
		u_steps 3
		v_steps 3
		<-2.331, -0.454, -0.050> <-2.331, -0.454, -0.020> <-2.331, -0.454, 0.020> <-2.331, -0.454, 0.050> 
		<-2.178, -0.517, -0.050> <-2.178, -0.517, -0.020> <-2.178, -0.517, 0.020> <-2.178, -0.517, 0.050> 
		<-1.963, -0.574, -0.050> <-1.963, -0.574, -0.020> <-1.963, -0.574, 0.020> <-1.963, -0.574, 0.050> 
		<-1.799, -0.600, -0.050> <-1.799, -0.600, -0.020> <-1.799, -0.600, 0.020> <-1.799, -0.600, 0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0.5
		u_steps 3
		v_steps 3
		<-2.331, -0.454, 0.050> <-2.342, -0.482, 0.050> <-2.358, -0.518, 0.050> <-2.369, -0.546, 0.050> 
		<-2.178, -0.517, 0.050> <-2.189, -0.544, 0.050> <-2.194, -0.586, 0.050> <-2.206, -0.614, 0.050> 
		<-1.963, -0.574, 0.050> <-1.963, -0.604, 0.050> <-1.975, -0.642, 0.050> <-1.975, -0.672, 0.050> 
		<-1.799, -0.600, 0.050> <-1.800, -0.630, 0.050> <-1.800, -0.670, 0.050> <-1.801, -0.700, 0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0.5
		u_steps 3
		v_steps 3
		<-2.369, -0.546, 0.050> <-2.369, -0.546, 0.020> <-2.369, -0.546, -0.020> <-2.369, -0.546, -0.050> 
		<-2.206, -0.614, 0.050> <-2.206, -0.614, 0.020> <-2.206, -0.614, -0.020> <-2.206, -0.614, -0.050> 
		<-1.975, -0.672, 0.050> <-1.975, -0.672, 0.020> <-1.975, -0.672, -0.020> <-1.975, -0.672, -0.050> 
		<-1.801, -0.700, 0.050> <-1.801, -0.700, 0.020> <-1.801, -0.700, -0.020> <-1.801, -0.700, -0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0.5
		u_steps 3
		v_steps 3
		<-1.799, -0.600, -0.050> <-1.502, -0.648, -0.050> <-1.102, -0.690, -0.050> <-0.801, -0.700, -0.050> 
		<-1.800, -0.630, -0.050> <-1.502, -0.678, -0.050> <-1.101, -0.720, -0.050> <-0.800, -0.730, -0.050> 
		<-1.800, -0.670, -0.050> <-1.502, -0.718, -0.050> <-1.101, -0.761, -0.050> <-0.800, -0.770, -0.050> 
		<-1.801, -0.700, -0.050> <-1.503, -0.748, -0.050> <-1.101, -0.791, -0.050> <-0.799, -0.800, -0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0.5
		u_steps 3
		v_steps 3
		<-1.799, -0.600, -0.050> <-1.799, -0.600, -0.020> <-1.799, -0.600, 0.020> <-1.799, -0.600, 0.050> 
		<-1.502, -0.648, -0.050> <-1.502, -0.648, -0.020> <-1.502, -0.648, 0.020> <-1.502, -0.648, 0.050> 
		<-1.102, -0.690, -0.050> <-1.102, -0.690, -0.020> <-1.102, -0.690, 0.020> <-1.102, -0.690, 0.050> 
		<-0.801, -0.700, -0.050> <-0.801, -0.700, -0.020> <-0.801, -0.700, 0.020> <-0.801, -0.700, 0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0.5
		u_steps 3
		v_steps 3
		<-1.799, -0.600, 0.050> <-1.800, -0.630, 0.050> <-1.800, -0.670, 0.050> <-1.801, -0.700, 0.050> 
		<-1.502, -0.648, 0.050> <-1.502, -0.678, 0.050> <-1.502, -0.718, 0.050> <-1.503, -0.748, 0.050> 
		<-1.102, -0.690, 0.050> <-1.101, -0.720, 0.050> <-1.101, -0.761, 0.050> <-1.101, -0.791, 0.050> 
		<-0.801, -0.700, 0.050> <-0.800, -0.730, 0.050> <-0.800, -0.770, 0.050> <-0.799, -0.800, 0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0.5
		u_steps 3
		v_steps 3
		<-1.801, -0.700, 0.050> <-1.801, -0.700, 0.020> <-1.801, -0.700, -0.020> <-1.801, -0.700, -0.050> 
		<-1.503, -0.748, 0.050> <-1.503, -0.748, 0.020> <-1.503, -0.748, -0.020> <-1.503, -0.748, -0.050> 
		<-1.101, -0.791, 0.050> <-1.101, -0.791, 0.020> <-1.101, -0.791, -0.020> <-1.101, -0.791, -0.050> 
		<-0.799, -0.800, 0.050> <-0.799, -0.800, 0.020> <-0.799, -0.800, -0.020> <-0.799, -0.800, -0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0.5
		u_steps 3
		v_steps 3
		<-0.801, -0.700, -0.050> <-0.130, -0.721, -0.050> <0.765, -0.727, -0.046> <1.435, -0.702, -0.050> 
		<-0.800, -0.730, -0.050> <-0.130, -0.751, -0.050> <0.774, -0.756, -0.046> <1.444, -0.731, -0.050> 
		<-0.800, -0.770, -0.050> <-0.121, -0.790, -0.050> <0.777, -0.800, -0.050> <1.456, -0.769, -0.050> 
		<-0.799, -0.800, -0.050> <-0.120, -0.820, -0.050> <0.786, -0.829, -0.050> <1.465, -0.798, -0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0.5
		u_steps 3
		v_steps 3
		<-0.801, -0.700, -0.050> <-0.801, -0.700, -0.020> <-0.801, -0.700, 0.020> <-0.801, -0.700, 0.050> 
		<-0.130, -0.721, -0.050> <-0.130, -0.721, -0.020> <-0.130, -0.721, 0.020> <-0.130, -0.721, 0.050> 
		<0.765, -0.727, -0.046> <0.765, -0.727, -0.016> <0.765, -0.727, 0.016> <0.765, -0.727, 0.046> 
		<1.435, -0.702, -0.050> <1.435, -0.702, -0.020> <1.435, -0.702, 0.020> <1.435, -0.702, 0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0.5
		u_steps 3
		v_steps 3
		<-0.801, -0.700, 0.050> <-0.800, -0.730, 0.050> <-0.800, -0.770, 0.050> <-0.799, -0.800, 0.050> 
		<-0.130, -0.721, 0.050> <-0.130, -0.751, 0.050> <-0.121, -0.790, 0.050> <-0.120, -0.820, 0.050> 
		<0.765, -0.727, 0.046> <0.774, -0.756, 0.046> <0.777, -0.800, 0.050> <0.786, -0.829, 0.050> 
		<1.435, -0.702, 0.050> <1.444, -0.731, 0.050> <1.456, -0.769, 0.050> <1.465, -0.798, 0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0.5
		u_steps 3
		v_steps 3
		<-0.799, -0.800, 0.050> <-0.799, -0.800, 0.020> <-0.799, -0.800, -0.020> <-0.799, -0.800, -0.050> 
		<-0.120, -0.820, 0.050> <-0.120, -0.820, 0.020> <-0.120, -0.820, -0.020> <-0.120, -0.820, -0.050> 
		<0.786, -0.829, 0.050> <0.786, -0.829, 0.020> <0.786, -0.829, -0.020> <0.786, -0.829, -0.050> 
		<1.465, -0.798, 0.050> <1.465, -0.798, 0.020> <1.465, -0.798, -0.020> <1.465, -0.798, -0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0.5
		u_steps 3
		v_steps 3
		<1.435, -0.702, -0.050> <1.483, -0.700, -0.050> <1.539, -0.651, -0.061> <1.568, -0.612, -0.064> 
		<1.444, -0.731, -0.050> <1.492, -0.729, -0.050> <1.558, -0.674, -0.057> <1.587, -0.635, -0.060> 
		<1.456, -0.769, -0.050> <1.516, -0.766, -0.050> <1.577, -0.713, -0.051> <1.613, -0.665, -0.054> 
		<1.465, -0.798, -0.050> <1.525, -0.795, -0.050> <1.596, -0.736, -0.047> <1.632, -0.688, -0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0.5
		u_steps 3
		v_steps 3
		<1.435, -0.702, -0.050> <1.435, -0.702, -0.020> <1.435, -0.702, 0.020> <1.435, -0.702, 0.050> 
		<1.483, -0.700, -0.050> <1.483, -0.700, -0.020> <1.483, -0.700, 0.020> <1.483, -0.700, 0.050> 
		<1.539, -0.651, -0.061> <1.539, -0.651, -0.022> <1.539, -0.651, 0.022> <1.539, -0.651, 0.061> 
		<1.568, -0.612, -0.064> <1.568, -0.612, -0.026> <1.568, -0.612, 0.026> <1.568, -0.612, 0.064> 
	}
	bicubic_patch {
		type 1
		flatness 0.5
		u_steps 3
		v_steps 3
		<1.435, -0.702, 0.050> <1.444, -0.731, 0.050> <1.456, -0.769, 0.050> <1.465, -0.798, 0.050> 
		<1.483, -0.700, 0.050> <1.492, -0.729, 0.050> <1.516, -0.766, 0.050> <1.525, -0.795, 0.050> 
		<1.539, -0.651, 0.061> <1.558, -0.674, 0.057> <1.577, -0.713, 0.051> <1.596, -0.736, 0.047> 
		<1.568, -0.612, 0.064> <1.587, -0.635, 0.060> <1.613, -0.665, 0.054> <1.632, -0.688, 0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0.5
		u_steps 3
		v_steps 3
		<1.465, -0.798, 0.050> <1.465, -0.798, 0.020> <1.465, -0.798, -0.020> <1.465, -0.798, -0.050> 
		<1.525, -0.795, 0.050> <1.525, -0.795, 0.020> <1.525, -0.795, -0.020> <1.525, -0.795, -0.050> 
		<1.596, -0.736, 0.047> <1.596, -0.736, 0.017> <1.596, -0.736, -0.017> <1.596, -0.736, -0.047> 
		<1.632, -0.688, 0.050> <1.632, -0.688, 0.020> <1.632, -0.688, -0.020> <1.632, -0.688, -0.050> 
	}
	bicubic_patch {
		type 1
		flatness 0.5
		u_steps 3
		v_steps 3
		<1.568, -0.612, -0.064> <1.621, -0.539, -0.070> <1.682, -0.429, -0.065> <1.701, -0.342, -0.079> 
		<1.587, -0.635, -0.060> <1.641, -0.562, -0.066> <1.711, -0.434, -0.065> <1.730, -0.347, -0.079> 
		<1.613, -0.665, -0.054> <1.680, -0.577, -0.060> <1.744, -0.460, -0.062> <1.770, -0.353, -0.079> 
		<1.632, -0.688, -0.050> <1.700, -0.600, -0.056> <1.773, -0.465, -0.062> <1.799, -0.358, -0.079> 
	}
	bicubic_patch {
		type 1
		flatness 0.5
		u_steps 3
		v_steps 3
		<1.568, -0.612, -0.064> <1.568, -0.612, -0.026> <1.568, -0.612, 0.026> <1.568, -0.612, 0.064> 
		<1.621, -0.539, -0.070> <1.621, -0.539, -0.031> <1.621, -0.539, 0.031> <1.621, -0.539, 0.070> 
		<1.682, -0.429, -0.065> <1.682, -0.429, -0.018> <1.682, -0.429, 0.018> <1.682, -0.429, 0.065> 
		<1.701, -0.342, -0.079> <1.701, -0.342, -0.031> <1.701, -0.342, 0.031> <1.701, -0.342, 0.079> 
	}
	bicubic_patch {
		type 1
		flatness 0.5
		u_steps 3
		v_steps 3
		<1.568, -0.612, 0.064> <1.587, -0.635, 0.060> <1.613, -0.665, 0.054> <1.632, -0.688, 0.050> 
		<1.621, -0.539, 0.070> <1.641, -0.562, 0.066> <1.680, -0.577, 0.060> <1.700, -0.600, 0.056> 
		<1.682, -0.429, 0.065> <1.711, -0.434, 0.065> <1.744, -0.460, 0.062> <1.773, -0.465, 0.062> 
		<1.701, -0.342, 0.079> <1.730, -0.347, 0.079> <1.770, -0.353, 0.079> <1.799, -0.358, 0.079> 
	}
	bicubic_patch {
		type 1
		flatness 0.5
		u_steps 3
		v_steps 3
		<1.632, -0.688, 0.050> <1.632, -0.688, 0.020> <1.632, -0.688, -0.020> <1.632, -0.688, -0.050> 
		<1.700, -0.600, 0.056> <1.700, -0.600, 0.026> <1.700, -0.600, -0.026> <1.700, -0.600, -0.056> 
		<1.773, -0.465, 0.062> <1.773, -0.465, 0.014> <1.773, -0.465, -0.014> <1.773, -0.465, -0.062> 
		<1.799, -0.358, 0.079> <1.799, -0.358, 0.031> <1.799, -0.358, -0.031> <1.799, -0.358, -0.079> 
	}
	bicubic_patch {
		type 1
		flatness 0.5
		u_steps 3
		v_steps 3
		<1.700, 0.001, -0.160> <1.730, 0.000, -0.160> <1.770, -0.000, -0.160> <1.800, -0.001, -0.160> 
		<1.700, -0.102, -0.135> <1.730, -0.102, -0.135> <1.770, -0.108, -0.135> <1.800, -0.108, -0.135> 
		<1.723, -0.240, -0.095> <1.752, -0.245, -0.095> <1.795, -0.248, -0.096> <1.825, -0.253, -0.096> 
		<1.701, -0.342, -0.079> <1.730, -0.347, -0.079> <1.770, -0.353, -0.079> <1.799, -0.358, -0.079> 
	}
	bicubic_patch {
		type 1
		flatness 0.5
		u_steps 3
		v_steps 3
		<1.700, 0.001, -0.160> <1.700, -0.102, -0.135> <1.723, -0.240, -0.095> <1.701, -0.342, -0.079> 
		<1.700, 0.001, -0.064> <1.700, -0.102, -0.040> <1.723, -0.240, -0.047> <1.701, -0.342, -0.031> 
		<1.700, 0.001, 0.064> <1.700, -0.102, 0.040> <1.723, -0.240, 0.047> <1.701, -0.342, 0.031> 
		<1.700, 0.001, 0.160> <1.700, -0.102, 0.135> <1.723, -0.240, 0.095> <1.701, -0.342, 0.079> 
	}
	bicubic_patch {
		type 1
		flatness 0.5
		u_steps 3
		v_steps 3
		<1.700, 0.001, 0.160> <1.700, -0.102, 0.135> <1.723, -0.240, 0.095> <1.701, -0.342, 0.079> 
		<1.730, 0.000, 0.160> <1.730, -0.102, 0.135> <1.752, -0.245, 0.095> <1.730, -0.347, 0.079> 
		<1.770, -0.000, 0.160> <1.770, -0.108, 0.135> <1.795, -0.248, 0.096> <1.770, -0.353, 0.079> 
		<1.800, -0.001, 0.160> <1.800, -0.108, 0.135> <1.825, -0.253, 0.096> <1.799, -0.358, 0.079> 
	}
	bicubic_patch {
		type 1
		flatness 0.5
		u_steps 3
		v_steps 3
		<1.800, -0.001, 0.160> <1.800, -0.108, 0.135> <1.825, -0.253, 0.096> <1.799, -0.358, 0.079> 
		<1.800, -0.001, 0.064> <1.800, -0.108, 0.040> <1.825, -0.253, 0.048> <1.799, -0.358, 0.031> 
		<1.800, -0.001, -0.064> <1.800, -0.108, -0.040> <1.825, -0.253, -0.048> <1.799, -0.358, -0.031> 
		<1.800, -0.001, -0.160> <1.800, -0.108, -0.135> <1.825, -0.253, -0.096> <1.799, -0.358, -0.079> 
	}
	#ifndef (IMPORT_SPATCH)
	pigment { Hull_Wood_P rotate z*45 }
	finish { phong 0.9 }
	#end
}

/***************************************************************************/


#declare Hand_Texture =
        texture{
                pigment{ color (Flesh*8+Wheat*2+Gold*5)/15 }
                finish{ ambient 0.15 diffuse 0.85 }
        }
        
#declare Height = 34;
#declare Gender = 1;
#declare Suit_Color = 4;

#declare R_Arm_Rotation =
        transform{
                rotate x * -25
                rotate z * 40
        }
#declare R_Elbow_Rotation = 
        transform{
                rotate z * -20
                rotate x * 0
        }
#declare R_Hand_Rotation =
        transform{
                rotate x * -10
                rotate y * 0
                rotate z * 0
        }
        
#declare L_Elbow_Rotation = 
        transform{
                rotate x * -85
        }
        
/***************************************************************************/
#include "person.inc"
/***************************************************************************/
union { 
  	object {Person}
  	object {Sailors_Cap_o scale 6 translate 16*y }
	rotate <0,-90,0>
  	scale 0.03
	translate <-2.5,0,0>
}


/***************************************************************************/
/***************************************************************************/

#declare Hand_Texture =
        texture{
                pigment{ color (Flesh*8+Wheat*2+Gold*5)/15 }
                finish{ ambient 0.15 diffuse 0.85 }
        }
        
#declare Height = 34;
#declare Gender = 1;

#declare R_Arm_Rotation =
        transform{
                rotate x * -25
                rotate z * 40
        }
#declare R_Elbow_Rotation = 
        transform{
                rotate z * -20
                rotate x * 0
        }
#declare R_Hand_Rotation =
        transform{
                rotate x * -10
                rotate y * 0
                rotate z * 0
        }
        
#declare R_Leg_Rotation = transform{ rotate z*0 rotate x*-90 }
#declare L_Leg_Rotation = transform{ rotate z*0 rotate x*-90 }
#declare R_Shin_Rotation = transform{ rotate x*90 }
#declare L_Shin_Rotation = transform{ rotate x*90 }

/***************************************************************************/
#include "person.inc"
/***************************************************************************/

object{
	Person
	rotate <0,90,0>
	scale 0.03
	translate <0,-.2,0.3>
}

object {
	Oar_o
	rotate z*-45
	rotate x*-30
	translate <.2,0,-.5>
}


object{
	Person
	rotate <0,90,0>
	scale 0.03
	translate <0,-.2,-0.3>
}

object {
	Oar_o
	rotate z*-45
	rotate x*-27
	rotate y*180
	translate <.2,0,.5>
}


object{
	Person
	rotate <0,90,0>
	scale 0.03
	translate <-1,-.2,0.3>
}

object {
	Oar_o
	rotate z*-60
	rotate x*-15
	rotate y*20
	translate <-.8,0,-.5>
}


object{
	Person
	rotate <0,90,0>
	scale 0.03
	translate <-1,-.2,-0.3>
}

object {
	Oar_o
	rotate z*-60
	rotate x*-15
	rotate y*160
	translate <-.8,0,.5>
}


/***************************************************************************/
/***************************************************************************/

#declare Suit_Color = 5;
#declare Gender = 2;
#declare Height = 32;
#declare Breasts = 8/16;

#declare Suit_Texture = Skin_Texture

#declare L_Arm_Rotation =
        transform{
                rotate y * 45
                rotate x * -120
        }
#declare R_Arm_Rotation =
        transform{
                rotate z * 70
                rotate y * -17
        }
#declare L_Elbow_Rotation = 
        transform{
                rotate z * -50
                rotate x * 0
                rotate y * 0
        }
#declare L_Elbow_Rotation = 
        transform{
                rotate z * 0
                rotate x * 0
                rotate y * 0
        }
#declare R_Hand_Rotation =
        transform{
                rotate x * -30
        }

#declare L_Hand_Position = "wide-relaxed"

#declare L_Hand_Rotation =
        transform{
        		rotate z * -15
                rotate y * 30
        }

#declare L_Leg_Rotation = transform{ rotate x*-30 }
#declare L_Shin_Rotation = transform{ rotate x*20 }
#declare L_Foot_Rotation = transform{ rotate x*450 }

#declare R_Leg_Rotation = transform{ rotate x*-60 }
#declare R_Shin_Rotation = transform{ rotate x*40 }
#declare R_Foot_Rotation = transform{ rotate x*40 }

#include "person.inc"

union { 
  	object {Person}
  	object {Survivors_Hair_o scale 5 translate 15*y }
  	rotate <-10,60,0>
  	scale 0.03
  	translate <-9,-.65,-3>
}

///////////////////////////////////////////////////

object {
	Bottle_o
	rotate y*-45
	rotate z*60
	translate <-8,-.4,-4>
}

object {
	Broken_Mast_o
	rotate y*60
	rotate x*10
	translate <-6,-.4,-1>
}

object {
	Broken_Plank_o
	rotate y*5
	rotate z*10
	translate <-6,-.4,-3>
}