//Dolphin, by Andrew Swan, 2000

#include "dolphin.inc"

#global_settings {max_trace_level 25}

#render "\n"
#declare R=seed(2);

#macro Bubbles (bubblenumber,bubblex,bubbley,bubblez,bubbleheight,bubblewidth,bubblesize)
        #render concat("Creating ",str(bubblenumber,0,0)," bubbles\n")
        #local n=0;
        #local size=0.01/bubblesize; 
        #while (n<bubblenumber)
                sphere {<0,0,0>,(0.01/((rand(R)+size))) scale <0.75+(rand(R)*0.25),0.75+(rand(R)*0.25),0.75+(rand(R)*0.25)> translate <rand(R)*bubblewidth,0,0> rotate <0,rand(R)*360,0> texture {Bubble} interior {ior 0.75} translate <bubblex,bubbley+(rand(R)*bubbleheight),bubblez> hollow}
                #declare n=n+1;
                #end
        #end        

#declare Dolphin_map=color_map {[0 color rgb<0.5,0.5,0.8>] [0.1 color rgb<0.57,0.5,0.82>] [0.3 color rgb<0.51,0.51,0.7>] [0.6 color rgb<0.53,0.53,0.61>] [0.8 color rgb<0.55,0.55,0.65>] [1 color rgb<0.5,0.5,0.8>]}

#declare Bubble=texture {pigment {color rgbt<0.999,0.999,0.999,0.999>} finish {ambient 0 diffuse 0}}

object {Dolphin texture {pigment {spiral2 7 color_map{Dolphin_map} turbulence 0.1 lambda 3 scale 0.75 rotate <90,0,0>} finish {specular 0.2 roughness 0.001} normal {bumps 0.1 scale 0.01}}}

plane {<0,1,0>,3 hollow texture {pigment {color rgbf<0.8,0.8,0.95,0.9>} finish {specular 0.8 roughness 0.001 ambient 0.1 diffuse 0.1 reflection 0.1} normal {waves 1 scale 1000 frequency 2500}} interior {media {scattering {1, rgb <0.01,0.04,0.03>} intervals 15 samples 1,15 confidence 0.9999 variance 1/1000 ratio 0.9} ior 1.33}}
plane {<0,1,0>,10 hollow texture {pigment {color rgb<0.5,0.5,1>} finish {ambient 0.4 diffuse 0}}}
plane {<0,1,-0.08>,-10 hollow texture {pigment {color rgb<0.2,0.18,0.16>} finish {ambient 0.5 diffuse 0}}}

Bubbles (1000,-3,-10,-2,13,0.5,0.1)
Bubbles (1000,-5,-10,3,13,1,0.2)
Bubbles (1000,5,15,10,13,0.5,0.3)
Bubbles (1000,-1,-10,-4,13,1,0.1)
Bubbles (1000,3.5,-10,0,13,2.5,0.2)

Bubbles (5000,0,-10,0,13,500,2)

media {emission rgb<0,0.01,0.008> intervals 15 ratio 0.9 samples 1,10 density {color 0.08}}

light_source {<2,9,-2.5> color rgb<3,3,3> spotlight point_at <0,0,0> area_light <1,0,0>,<0,0,1>,2,2 adaptive 1 jitter radius 12 falloff 18 media_attenuation on}
light_source {<0,0,-5> color rgb<0.2,0.2,0.2> media_interaction off}

camera {location <-3,-1,-8> look_at <0,0,0>}