// ============================================================================
//
// Atlantic Still Life
//
// Entry for July/August IRTC - Topic 'Sea'
//
// All code and images copyright (c) Ian Shumsky / Outerarm 2000
//
// ============================================================================

#version unofficial Megapov 0.5;

// ============================================================================
//
// This is the base file which defines settings, sets the lights and camera
// and includes and places the objects.
//
// ============================================================================

//
// Some basic controls to define the quality of the render and items placed in
// the scene. A value of 0 for do_area_lights means point lights are used.
// do_room_detail causes a normal to be applied to the walls and ceiling.
//

#declare do_radiosity = true;
#declare do_photons   = true;
#declare do_area_lights = 10;
#declare do_room_detail = true;
#declare do_fossil = true;

//
// Details about the globe including if it should be included (do_globe) and
// the ammount of details to be used. The size of the globe is also defined
// here - with a little effort this could easily be turned into a macro.
//

#declare do_globe = true;
#declare do_globe_land = true;
#declare do_globe_frame = true;
#declare do_globe_holder_markings = true;
#declare land_mass_thickness = 0.004; // 2mm
#declare inner_max = 0.25 - land_mass_thickness; // 25cm - 2mm
#declare vframe_thickness = 0.003; // 3mm
#declare hframe_thickness = 0.003; // 3mm
#declare earth_axis_rotation = 23 + 27/60;
#declare globe_rotation = -127;

//
// Include all the textures we will use in the render.
//

#include "asl_textures.inc"

//
// Specify the global settings. I'm actually missing assumed_gamma here...
//

global_settings
{
	max_trace_level 32

	#if (do_photons = true)
		photons
		{
			count 10000
			jitter .5
		}
	#end

	#if (do_radiosity = true)
		ambient_light 0.01
		ini_option "+QR"
		radiosity
		{
			pretrace_start 0.08
			pretrace_end   0.02
			count 50
			nearest_count 5
			error_bound 1
			recursion_limit 3
			low_error_factor .5
			gray_threshold 0.0
			minimum_reuse 0.015
			brightness 1
			adc_bailout 0.01/5
			normal on
		}
	#end
}

//
// Define the colours, intensities and sizes of the lights.
//

#declare main_light_colour = rgb <250,248,249>/255;
#declare main_light_intensity = 1;
#declare main_light_size = 0.1;

#declare fill_light_colour = rgb <247,243,242>/255;
#declare fill_light_intensity = 0.5;
#declare fill_light_size = 0.1;

#declare back_light_colour = rgb <252,244,242>/255;
#declare back_light_intensity = 0.75;
#declare back_light_size = 0.1;

//
// Add the lights. First add the main light.
//

light_source
{
	<0, 0, -1>
	colour main_light_colour * main_light_intensity
	fade_distance 5 / 5
	fade_power 1 / 5
	#if (do_area_lights > 1)
		area_light
		<main_light_size, 0, 0> <0, main_light_size, 0>
		do_area_lights, do_area_lights
		adaptive 0
		jitter
		#if (do_photons = true)
			photons
			{
				reflection on area_light
			}
		#end
	#end
	rotate y*-45
	rotate x*45
	translate <0, (inner_max + land_mass_thickness + 0.11 +0.015 + 0.8), 0>
}

//
// fill light
//

light_source
{
	<0, 0, -1>
	colour fill_light_colour * fill_light_intensity
	fade_distance 5 / 5
	fade_power 1 / 5
	#if (do_area_lights > 1)
		area_light
		<fill_light_size, 0, 0> <0, fill_light_size, 0>
		do_area_lights, do_area_lights
		adaptive 0
		jitter
		#if (do_photons = true)
			photons
			{
				reflection on area_light
			}
		#end
	#end
	rotate y*45
	rotate x*-27.5
	translate <0, (inner_max + land_mass_thickness + 0.11 +0.015 + 0.8), 0>
}

//
// back light
//

light_source
{
	<0, 0, 1>
	colour back_light_colour * back_light_intensity
	fade_distance 5 / 5
	fade_power 1 / 5
	#if (do_area_lights > 1)
		area_light
		<back_light_size, 0, 0> <0, back_light_size, 0>
		do_area_lights, do_area_lights
		adaptive 0
		jitter
		#if (do_photons = true)
			photons
			{
				reflection on area_light
			}
		#end
	#end
	rotate x*-45
	translate <0, (inner_max + land_mass_thickness + 0.11 +0.015 + 0.8), 0>
}

//
// Place and point the camera.
//

camera
{
	location <0, 1.31, -1.5>
	look_at <0, 1.1, 0>
	angle 37.5
}

//
// Define the size of the room.
//

#declare room_x_min = -2;
#declare room_x_max = 2;
#declare room_y_min = 0;
#declare room_y_max = 3.5;
#declare room_z_min = -5;
#declare room_z_max = 1;

//
// Define and include the room.
//

#declare base_room = box
{
	<room_x_min, room_y_min, room_z_min>, <room_x_max, room_y_max, room_z_max>
	inverse
	texture
	{
		pigment
		{
			colour rgb <247,224,192>/255 * .6
		}
		#if (do_room_detail = true)
			normal
			{
				granite
				scale 0.05
			}
		#end
		#if (do_radiosity = true)
			finish
			{
				ambient 5
			}
		#end
	}
}

object
{
	base_room
}

//
// Desk
//

#declare desk_top = height_field
{
	png "desk_hf.png"
	smooth
	translate <-0.5, 0, -0.5>
	scale <2, 0.02, 1>
}

#declare desk_holder = difference
{
	box
	{
		<-1, -0.05, -0.5>, <1, 0, 0.5>
	}
	box
	{
		<-0.9, -0.04, -0.499>, <0.9, 1, 0.499>
	}
}

#declare desk = union
{
	object
	{
		desk_holder
	}
	object
	{
		desk_top
		translate <0, -0.02, 0>
	}
	texture
	{
		wood_texture2
	}
	translate <0, 0.8, 0>
}

object
{
	desk
}

//
// Add the globe.
//

#include "globe.inc"

#if (do_globe = true)
	object
	{
		globe
		rotate y*5
		// Put it on top of the desk.
		translate <0, 0.8, 0>
	}
#end

//
// Add the fossils.
//

#if (do_fossil = true)
	#include "calymene_stand.inc"

	object
	{
		calymene_fossil_and_stand
		rotate y*-28.2
		translate <-0.3121, 0.8, 0.112>
	}

	#include "dalmanites_stand.inc"

	object
	{
		dalmanites_fossil_and_stand
		rotate y*29
		translate <0.3201, 0.8, 0.119>
	}
#end

