// ============================================================================
//
// Atlantic Still Life
//
// Entry for July/August IRTC - Topic 'Sea'
//
// All code and images copyright (c) Ian Shumsky / Outerarm 2000
//
// ============================================================================

#version unofficial Megapov 0.5;

// ============================================================================
//
// This file defines a glass dsiplay stand and then places a fossil on top of
// it then rotates it so that the stand rests on y=0 (well, almost). The stand
// code is pretty generic and could (should?) be turned into a macro with a
// little effort.
//
// ============================================================================

#declare stand_thickness = 0.01; // 10mm
#declare stand_width = 0.05; // 10cm
#declare stand_length = 0.25; // 30 cm
#declare stand_height = (tan (radians (30)) * stand_length) - (stand_thickness / 2);

#declare dalmanites_stand = merge
{
	//
	// Lip
	//

	box
	{
		<-stand_width, stand_thickness, 0>, <stand_width, stand_thickness + 0.02, -stand_thickness>
	}

	cylinder
	{
		<-stand_width, stand_thickness + 0.02, -(stand_thickness / 2)>, <stand_width, stand_thickness + 0.02, -(stand_thickness / 2)>, stand_thickness / 2
	}

	intersection
	{
		cylinder
		{
			<-stand_width, stand_thickness, 0>, <stand_width, stand_thickness, 0>, stand_thickness
		}
		box
		{
			<-1, 0, 0>, <1, stand_thickness, -1>
		}
	}

	//
	// long flat
	//

	box
	{
		<-stand_width, 0, 0>, <stand_width, stand_thickness, stand_length>
	}

	intersection
	{
		cylinder
		{
			<-stand_width, 0, stand_length>, <stand_width, 0, stand_length>, stand_thickness
		}
		box
		{
			<-1, 0, stand_length>, <1, 1, 1>
		}
	}

	//
	// stand
	//

	box
	{
		<-stand_width, 0, stand_length>, <stand_width, -stand_height, stand_length + stand_thickness>
	}

	cylinder
	{
		<-stand_width, -stand_height, stand_length + (stand_thickness / 2)>, <stand_width, -stand_height, stand_length + (stand_thickness / 2)>, stand_thickness / 2
	}

	material
	{
		Glass
	}
	photons
	{
		target 0.5
		refraction on
		reflection on
		ignore_photons
	}
}

#include "dalmanites_rock.inc"

#declare dalmanites_fossil_and_stand = union
{
	object
	{
		dalmanites_stand
	}
	object
	{
		dalmanites_rock
		translate <0, stand_thickness, 0.5 * 0.25 * 1.15>
	}

	rotate x*-30
}
