//  Persistence of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 3 lights, 24 materials and 915 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.2 For Windows Copyright (c) 1993-2000 Lutz + Kretzschmar
//

//  Date : 08/28/2000    (28.08.2000)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/* // Scene Comment

This scene was created with Moray V3.2 For Windows.
Comment merged from ship.mdl:
This scene was created with Moray V3.2 For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 2.5
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 20
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.424> }

camera {  //  Camera StdCam
  location  <    -53.275,     -57.944,      13.152>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.33895,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         19.35930    // Vertical      14.519
  look_at   <    -20.597,       0.150,       6.730>
}

//
// *******  L I G H T S *******
//

light_source {   // Arealight Arealight003
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>*0.2000
  area_light <2.000, 0.000, 0.000>, <0.000, 2.000, 0.000>, 3, 3
  adaptive 1
  jitter
  scale 10.0
  rotate <-64.643555, -2.799256, 89.158859>
  translate  <-118.988876, 0.96514, 40.234248>
}


light_source {   // Arealight Arealight002
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>*1.5000
  area_light <2.000, 0.000, 0.000>, <0.000, 2.000, 0.000>, 3, 3
  adaptive 1
  jitter
  scale 10.0
  rotate <-53.507427, 0.0, 26.974926>
  translate  <-84.680072, 127.598687, 68.241809>
}


light_source {   // Arealight Arealight001
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>*0.5000
  area_light <2.000, 0.000, 0.000>, <0.000, 2.000, 0.000>, 3, 3
  adaptive 1
  jitter
  shadowless
  scale <10.0, 10.0, 4.0>
  translate  <-24.431325, 2.053676, 128.082811>
}



//
// ********  MATERIALS  *******
//

#include "balt.inc"


//
// ********  REFERENCED OBJECTS  *******
//



//
// ********  OBJECTS  *******
//

sphere { // shipMspray6
  <0,0,0>,1
  material {
    spray_3_3_1
  }
  hollow
  scale <0.945434, 1.028706, 3.42291>
  rotate <101.61937, -3.5809, 0.193764>
  translate  <-21.35816, -10.691952, 0.638238>
}


sphere { // shipMspray4
  <0,0,0>,1
  material {
    spray_3_3_1
  }
  hollow
  scale <0.547178, 1.266739, 3.992916>
  rotate <92.49855, -10.415645, 11.15578>
  translate  <-22.136986, -4.703746, 1.458346>
}


sphere { // shipMspray3
  <0,0,0>,1
  material {
    spray_3_3_1
  }
  hollow
  scale <0.688257, 1.168659, 2.064828>
  rotate <104.334869, -2.993359, 7.034981>
  translate  <-22.392717, 0.447542, 2.168265>
}


sphere { // shipMspray2
  <0,0,0>,1
  material {
    spray_3_3_1
  }
  hollow
  scale <0.69404, 1.208322, 1.920065>
  rotate <258.18985, -168.783096, -193.350662>
  translate  <-22.956062, 2.205994, 3.861006>
}


sphere { // shipMspray1
  <0,0,0>,1
  material {
    spray_3_3_1
  }
  hollow
  scale <1.052196, 1.225022, 2.060287>
  rotate <87.163025, -1.158713, -25.390049>
  translate  <-22.610789, 4.262858, 4.588376>
}




object {   // gischtMsurface
  height_field {
    tga "E:\Projekte\Sea\sea-02-3copy .TGA"
    water_level 0.0
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    spray_3_5
  }
  hollow
  scale <60.0, 50.0, 3.1>
  rotate <0.0, -0.4, -90.0>
  translate  3.2*z
}


cylinder { // gischtM10
  <0,0,1>, <0,0,0>, 1 
  material {
    spray_3_3
  }
  hollow
  scale <3.015324, 1.005108, 14.071512>
  rotate <-179.474045, -94.535294, 193.807541>
  translate  <1.770102, 62.506383, 2.510152>
}


cylinder { // gischtM8
  <0,0,1>, <0,0,0>, 1 
  material {
    spray_3_3
  }
  hollow
  scale <3.0, 1.0, 14.0>
  rotate <-28.403158, -89.248985, 45.631378>
  translate  <28.120672, 47.241282, 0.495482>
}


cylinder { // gischtM9
  <0,0,1>, <0,0,0>, 1 
  material {
    spray_3_3
  }
  hollow
  scale <1.5, 1.0, 7.0>
  rotate <107.313156, -101.171951, -118.719749>
  translate  <-12.656638, 32.332313, 3.372186>
}


cylinder { // gischtM7
  <0,0,1>, <0,0,0>, 1 
  material {
    spray_3_3
  }
  hollow
  scale <2.0, 1.0, 5.0>
  rotate <104.30127, -114.528923, -102.930901>
  translate  <-14.611324, 3.416707, 3.930228>
}


cylinder { // gischtM6
  <0,0,1>, <0,0,0>, 1 
  material {
    spray_3_3
  }
  hollow
  scale <1.0, 1.0, 4.0>
  rotate <90.0, -114.080627, -90.0>
  translate  <-27.413538, 6.872745, 4.320152>
}


cylinder { // gischtM5
  <0,0,1>, <0,0,0>, 1 
  material {
    spray_3_3
  }
  hollow
  scale <1.5, 1.0, 4.0>
  rotate <90.0, -105.523918, -90.0>
  translate  <-25.048748, 6.512208, 4.405925>
}


cylinder { // gischtM4
  <0,0,1>, <0,0,0>, 1 
  material {
    spray_3_3
  }
  hollow
  scale <1.5, 1.0, 4.0>
  rotate <86.193024, 65.272606, -102.649399>
  translate  <-21.852442, 5.727864, 5.032639>
}


cylinder { // gischtM3
  <0,0,1>, <0,0,0>, 1 
  material {
    spray_3_3
  }
  hollow
  scale <2.0, 1.0, 7.5>
  rotate <96.723381, -128.983047, -101.690269>
  translate  <-5.307666, 1.655981, 2.96801>
}


cylinder { // gischtM2
  <0,0,1>, <0,0,0>, 1 
  material {
    spray_3_3
  }
  hollow
  scale <2.0, 1.0, 4.0>
  rotate <90.0, -106.701859, -90.0>
  translate  <-24.686952, -23.592469, 1.71929>
}


cylinder { // gischtM1
  <0,0,1>, <0,0,0>, 1 
  material {
    spray_3_3
  }
  hollow
  scale <1.76869, 1.06276, 4.587449>
  rotate <270.49585, -169.015167, -272.353027>
  translate  <-19.41193, 4.157676, 5.202275>
}






sphere { // stormMsky
  <0,0,0>,1
  material {
    skyMskinMlayeredMadvanced_2
  }
  hollow
  scale <1000.0, 1000.0, 600.0>
}


object {   // seaMsurface
  height_field {
    tga "E:\Projekte\Sea\sea-02-3copy .TGA"
    water_level 0.0
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  material {
    seaMskinMlayeredMadvanced
  }
  hollow
  scale <60.0, 50.0, 3.0>
  rotate -90.0*z
  translate  3.0*z
}


#declare Ruderblatt = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  10  // control points
  <-1.0, -1.0>,
  <-0.325856, -0.630499>,
  <0.166993, 0.081101>,
  <0.199677, 1.043066>,
  <-0.054164, 2.776604>,
  <-0.294123, 3.671812>,
  <-0.623631, 4.133099>,
  <-0.630151, 5.586159>,
  <-1.0, 5.586159>,
  <-1.0, -1.0>
  rotate -x*90
  material {
    plankMskinM02
  }
  scale <1.687065, 1.521841, 0.5>
  rotate <90.0, 24.812943, -0.0>
  translate  <58.249791, 0.225638, -8.25262>
}
#declare Ruder = union {
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    material {
      brownMmed
    }
    scale <0.293379, 0.4, 0.6>
    rotate 24.284628*y
    translate  <57.109224, 0.0, -6.315403>
  }
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    material {
      brownMmed
    }
    scale <0.293379, 0.4, 0.6>
    rotate 24.284628*y
    translate  <58.423201, 0.0, -3.45281>
  }
  object { Ruderblatt }
  translate  -0.187711*x
}
#declare bugspriet = union {
  cylinder { // Cylndr018
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale <0.967054, 0.644386, 0.974997>
    rotate <0.0, -77.278664, -0.0>
    translate  <-5.522303, 0.0, 3.471487>
  }
  cone { // Cone005
    <0,0,0>, 0.5, <0,0,1>, 1.0
    material {
      woodMskinMmed
    }
    scale <0.4, 0.4, 18.0>
    rotate <180.0, 77.409973, 180.0>
    translate  <-22.478754, 0.0, 7.758005>
  }
  cylinder { // Cylndr017
    <0,0,1>, <0,0,0>, 1 
    material {
      woodMskinMmed
    }
    scale <0.5, 0.5, 15.0>
    rotate -77.484604*y
    translate  <3.636783, 0.0, 1.058427>
  }
  box { // Cube073
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMmed
    }
    scale <0.346893, 0.326546, 1.950726>
    rotate <135.0, -90.0, 0.0>
    translate  <3.023824, 3.157431, 0.737982>
  }
  box { // Cube072
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMmed
    }
    scale <0.346893, 0.326546, 1.950726>
    rotate <-135.0, -90.0, 0.0>
    translate  <3.023824, -3.31021, 0.737982>
  }
  cylinder { // Cylndr022
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale <0.841602, 0.644386, 1.418815>
    rotate <0.0, -76.88884, -0.0>
    translate  <-1.376529, 0.0, 1.99358>
  }
  cylinder { // Cylndr021
    <0,0,1>, <0,0,0>, 1 
    material {
      woodMskinMmed
    }
    scale <0.15, 0.15, 11.0>
    rotate 13.902826*y
    translate  <-12.397913, 0.0, -0.191908>
  }
  cylinder { // Cylndr020
    <0,0,1>, <0,0,0>, 1 
    material {
      metalMskinMmed
    }
    scale <0.25, 0.25, 1.0>
    rotate -77.771942*y
    translate  <-21.345692, 0.0, 7.537111>
  }
  cylinder { // Cylndr019
    <0,0,1>, <0,0,0>, 1 
    material {
      woodMskinMmed
    }
    scale <0.921761, 0.644386, 0.972934>
    rotate <0.0, -77.92942, -0.0>
    translate  <-9.858493, 0.0, 4.404272>
  }
  box { // Cube074
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMmed
    }
    scale <0.720409, 1.263589, 1.0>
    rotate 7.707111*y
    translate  <3.799858, -0.087863, 0.975391>
  }
  cylinder { // Cylndr369
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.04, 0.04, 16.0>
    rotate <180.0, 62.462158, 180.0>
    translate  <-10.684033, 0.0, 4.035306>
  }
  cylinder { // Cylndr023
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.02, 0.02, 25.0>
    rotate <-10.278672, -73.476654, -0.008538>
    translate  <1.770609, -4.492236, 0.572031>
  }
  cylinder { // Cylndr024
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 25.0>
    rotate <10.345081, -73.439842, -0.624241>
    translate  <1.770609, 4.222702, 0.572031>
  }
  cylinder { // Cylndr025
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 15.0>
    rotate <111.835243, -84.711853, -94.547539>
    translate  <1.950298, 4.402392, 0.572031>
  }
  cylinder { // Cylndr026
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 15.0>
    rotate <-107.327103, -83.584549, 89.375595>
    translate  <1.950298, -4.582081, 0.572031>
  }
  cylinder { // Cylndr035
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.04, 0.04, 12.0>
    rotate -51.005028*y
    translate  <-12.41754, 0.0, -0.043536>
  }
  cylinder { // Cylndr036
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.04, 0.04, 6.9>
    rotate -29.887012*y
    translate  <-12.41754, 0.0, -0.043536>
  }
}
#declare TaperSweep001 = prism {
  conic_sweep
  linear_spline
  0.5,1.0
  17  // control points
  <-1.528353, -0.403813>,
  <-1.00356, -0.624608>,
  <-0.478767, -0.723915>,
  <1.0, -0.732594>,
  <1.379577, -0.686603>,
  <1.632629, -0.559578>,
  <1.932932, -0.321134>,
  <2.150235, 0.0>,
  <1.959023, 0.285453>,
  <1.690141, 0.497402>,
  <1.414085, 0.646421>,
  <1.0, 0.732594>,
  <-0.486592, 0.723915>,
  <-1.007472, 0.632384>,
  <-1.528353, 0.417853>,
  <-1.528353, 0.00702>,
  <-1.528353, -0.403813>
  rotate <90,0,90>
  material {
    pMskinMcomlxM01Mdense
  }
  scale <1.0, 1.0, 1.232758>
}
#declare CSG007 = difference {
  object { TaperSweep001 }
  sphere { // Sphere004
    <0,0,0>,1
    material {
      woodMskinMmed
    }
    scale <0.705329, 1.764946, 0.417642>
    translate  <-0.000031, 0.183112, 1.32354>
  }
  scale <9.421377, 9.908544, 9.421377>
  translate  <12.414409, 0.0, 6.123553>
}
#declare smallboat = union {
  box { // Cube079
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMbright
    }
    scale <5.687839, 1.115322, 0.391903>
    translate  <12.478585, -3.042508, 16.858872>
  }
  box { // Cube078
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMbright
    }
    scale <5.687839, 1.115322, 0.391903>
    translate  <12.478585, 3.179601, 16.858872>
  }
  box { // Cube077
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMbright
    }
    scale <5.687839, 1.115322, 0.391903>
    translate  <12.478585, 8.739783, 16.858872>
  }
  box { // Cube076
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMbright
    }
    scale <3.96683, 1.115322, 0.391903>
    translate  <12.478585, -10.853241, 16.858872>
  }
  box { // Cube075
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMbright
    }
    scale <3.834445, 1.115322, 0.391903>
    translate  <12.478585, 14.432351, 16.858872>
  }
  object { CSG007 }
  scale <0.205688, 0.250446, 0.246632>
  translate  <61.041903, -0.660982, -2.456622>
}
#declare CSG012 = difference {
  box { // Cube096
    <-1, -1, -1>, <1, 1, 1>
    scale <0.913145, 0.142857, 1.173709>
    translate  <-0.423285, -0.527473, 33.74646>
  }
  cylinder { // Cylndr032
    <0,0,1>, <0,0,0>, 1 
    material {
      plankMskinM01
    }
    scale <0.955875, 1.617753, 1.0>
    rotate -90.0*x
    translate  <-1.49888, -1.0, 32.59613>
  }
  translate  1.065934*y
}
#declare CSG013 = difference {
  box { // Cube097
    <-1, -1, -1>, <1, 1, 1>
    scale <0.913145, 0.142857, 1.173709>
    translate  <-0.423285, -0.527473, 33.74646>
  }
  cylinder { // Cylndr033
    <0,0,1>, <0,0,0>, 1 
    material {
      plankMskinM01
    }
    scale <0.955875, 1.617753, 1.0>
    rotate -90.0*x
    translate  <-1.49888, -1.0, 32.59613>
  }
}
#declare mainmast = union {
  cylinder { // Cylndr031
    <0,0,1>, <0,0,0>, 1 
    material {
      woodMskinMmed
    }
    scale <1.0, 1.0, 0.5>
    rotate -9.0*y
    translate  5.0*z
  }
  box { // Cube094
    <-1, -1, -1>, <1, 1, 1>
    material {
      plankMskinM01
    }
    scale <0.147735, 4.146969, 0.385398>
    translate  <1.013811, 0.0, 35.694262>
  }
  box { // Cube095
    <-1, -1, -1>, <1, 1, 1>
    material {
      plankMskinM01
    }
    scale <0.147735, 4.146969, 0.385398>
    translate  <-1.829938, 0.0, 35.694262>
  }
  object { CSG012 }
  object { CSG013 }
  box { // Cube098
    <-1, -1, -1>, <1, 1, 1>
    material {
      plankMskinM02
    }
    scale <2.2, 0.131868, 0.394719>
    translate  <-0.475939, 0.538462, 35.309073>
  }
  box { // Cube099
    <-1, -1, -1>, <1, 1, 1>
    material {
      plankMskinM02
    }
    scale <2.2, 0.131868, 0.394719>
    translate  <-0.475939, -0.527473, 35.309073>
  }
  box { // Cube100
    <-1, -1, -1>, <1, 1, 1>
    material {
      plankMskinM02
    }
    scale <1.631549, 0.615385, 0.483278>
    translate  <-0.516722, 0.0, 40.229654>
  }
  cylinder { // Cylndr034
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale <0.4, 0.4, 1.5>
    translate  <-0.961457, 0.0, 40.856626>
  }
  sphere { // Sphere007
    <0,0,0>,1
    material {
      woodMskinMmed
    }
    scale <0.25, 0.25, 0.166667>
    translate  <-0.936704, 0.010989, 61.054792>
  }
  cone { // Cone010
    <0,0,0>, 1.0, <0,0,1>, 0.3
    material {
      woodMskinMbright
    }
    scale <0.3, 0.3, 26.0>
    translate  <-0.943706, 0.0, 34.736726>
  }
  cone { // Cone011
    <0,0,0>, 1.0, <0,0,1>, 0.7
    material {
      woodMskinMbright
    }
    scale <0.6, 0.6, 41.0>
  }
  scale 0.93
  rotate 9.0*y
  translate  <15.925483, 0.0, -0.210373>
}
#declare talje15 = union {
  cylinder { // Cylndr218
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.05, 0.05, 1.3>
    translate  <0.120119, 0.0, -1.231789>
  }
  cylinder { // Cylndr219
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.05, 0.05, 1.3>
    translate  <-0.103531, 0.0, -1.231789>
  }
  cylinder { // Cylndr220
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale 0.25
    rotate -90.0*x
    translate  <0.0, -0.120123, -1.197327>
  }
  cylinder { // Cylndr221
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale 0.25
    rotate -90.0*x
    translate  -0.120123*y
  }
}
#declare staak15 = union {
  cylinder { // Cylndr216
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.0, 0.0, -0.989765>
    material {
      greyMdark
    }
    scale <0.05, 0.05, 3.0>
    rotate <-0.874101, 0.0, -0.0>
    translate  -1.303684*z
  }
  cylinder { // Cylndr217
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.525539, 0.0, -0.000938>
    material {
      greyMdark
    }
    scale <0.05, 0.05, 28.0>
    translate  <-0.026277, 0.0, 0.026277>
  }
  object { talje15 }
  translate  <-0.043766, 0.0, 1.225448>
  rotate <0.000756, -0.182668, -0.048568>
  translate  <1.720387, 0.0, -1.225448>
}
#declare talje16 = union {
  cylinder { // Cylndr224
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.05, 0.05, 1.3>
    translate  <0.120119, 0.0, -1.231789>
  }
  cylinder { // Cylndr225
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.05, 0.05, 1.3>
    translate  <-0.103531, 0.0, -1.231789>
  }
  cylinder { // Cylndr226
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale 0.25
    rotate -90.0*x
    translate  <0.0, -0.120123, -1.197327>
  }
  cylinder { // Cylndr227
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale 0.25
    rotate -90.0*x
    translate  -0.120123*y
  }
}
#declare staak16 = union {
  cylinder { // Cylndr222
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.0, 0.0, -0.989765>
    material {
      greyMdark
    }
    scale <0.05, 0.05, 3.0>
    rotate <-0.909375, -1.294732, -0.580587>
    translate  -1.303684*z
  }
  cylinder { // Cylndr223
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.525539, 0.0, -0.000938>
    material {
      greyMdark
    }
    scale <0.05, 0.05, 28.0>
    translate  <-0.026277, 0.0, 0.026277>
  }
  object { talje16 }
  translate  <-0.0, 0.0, 1.225448>
  rotate <-0.000491, 3.09835, 0.038512>
  translate  -1.225448*z
}
#declare wanteMvMoMstar1 = union {
  cylinder { // Cylndr203
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 0.728394>
    rotate 90.0*y
    translate  <0.960061, 0.0, 17.703569>
  }
  cylinder { // Cylndr204
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 0.799967>
    rotate 90.0*y
    translate  <0.888489, 0.0, 16.303569>
  }
  cylinder { // Cylndr205
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 0.884553>
    rotate 90.0*y
    translate  <0.810409, 0.0, 14.903569>
  }
  cylinder { // Cylndr206
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 0.943112>
    rotate 90.0*y
    translate  <0.745343, 0.0, 13.503569>
  }
  cylinder { // Cylndr207
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.021191>
    rotate 90.0*y
    translate  <0.686784, 0.0, 12.103569>
  }
  cylinder { // Cylndr208
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.125297>
    rotate 90.0*y
    translate  <0.582678, 0.0, 10.703569>
  }
  cylinder { // Cylndr209
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.17735>
    rotate 90.0*y
    translate  <0.524119, 0.0, 9.303569>
  }
  cylinder { // Cylndr210
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.190363>
    rotate 90.0*y
    translate  <0.478573, 0.0, 7.903569>
  }
  cylinder { // Cylndr211
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.268442>
    rotate 90.0*y
    translate  <0.393987, 0.0, 6.503569>
  }
  cylinder { // Cylndr212
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.353028>
    rotate 90.0*y
    translate  <0.322414, 0.0, 5.103569>
  }
  cylinder { // Cylndr213
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.44412>
    rotate 90.0*y
    translate  <0.257348, 0.0, 3.703569>
  }
  cylinder { // Cylndr214
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.556034>
    rotate 90.0*y
    translate  <0.153243, 0.0, 2.303569>
  }
  cylinder { // Cylndr215
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.665345>
    rotate 90.0*y
    translate  <0.06215, 0.0, 0.903569>
  }
  object { staak15 }
  object { staak16 }
  cylinder { // Cylndr228
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <-0.015385, -0.036569, -9.417606>
    rotate <201.216629, -187.919296, 177.363983>
    translate  <1.674578, 0.089086, -4.881844>
  }
  cylinder { // Cylndr229
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.010564, 0.034238, 9.0>
    rotate <-20.533718, -185.132919, 0.640761>
    translate  <-0.12818, 0.021282, -4.425205>
  }
  scale <-1.46751, -1.112217, -0.650291>
  rotate <171.143539, -4.230542, 179.721603>
  translate  <19.828781, 2.80697, 35.473984>
}
#declare talje17 = union {
  cylinder { // Cylndr245
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.05, 0.05, 1.3>
    translate  <0.120119, 0.0, -1.231789>
  }
  cylinder { // Cylndr246
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.05, 0.05, 1.3>
    translate  <-0.103531, 0.0, -1.231789>
  }
  cylinder { // Cylndr247
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale 0.25
    rotate -90.0*x
    translate  <0.0, -0.120123, -1.197327>
  }
  cylinder { // Cylndr248
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale 0.25
    rotate -90.0*x
    translate  -0.120123*y
  }
}
#declare staak17 = union {
  cylinder { // Cylndr243
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.0, 0.0, -0.989765>
    material {
      greyMdark
    }
    scale <0.05, 0.05, 3.0>
    rotate <-0.874101, 0.0, -0.0>
    translate  -1.303684*z
  }
  cylinder { // Cylndr244
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.525539, 0.0, -0.000938>
    material {
      greyMdark
    }
    scale <0.05, 0.05, 28.0>
    translate  <-0.026277, 0.0, 0.026277>
  }
  object { talje17 }
  translate  <-0.043766, 0.0, 1.225448>
  rotate <0.000756, -0.182668, -0.048568>
  translate  <1.720387, 0.0, -1.225448>
}
#declare talje18 = union {
  cylinder { // Cylndr251
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.05, 0.05, 1.3>
    translate  <0.120119, 0.0, -1.231789>
  }
  cylinder { // Cylndr252
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.05, 0.05, 1.3>
    translate  <-0.103531, 0.0, -1.231789>
  }
  cylinder { // Cylndr253
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale 0.25
    rotate -90.0*x
    translate  <0.0, -0.120123, -1.197327>
  }
  cylinder { // Cylndr254
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale 0.25
    rotate -90.0*x
    translate  -0.120123*y
  }
}
#declare staak18 = union {
  cylinder { // Cylndr249
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.0, 0.0, -0.989765>
    material {
      greyMdark
    }
    scale <0.05, 0.05, 3.0>
    rotate <-0.909375, -1.294732, -0.580587>
    translate  -1.303684*z
  }
  cylinder { // Cylndr250
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.525539, 0.0, -0.000938>
    material {
      greyMdark
    }
    scale <0.05, 0.05, 28.0>
    translate  <-0.026277, 0.0, 0.026277>
  }
  object { talje18 }
  translate  <-0.0, 0.0, 1.225448>
  rotate <-0.000491, 3.09835, 0.038512>
  translate  -1.225448*z
}
#declare wanteMvMoMback1 = union {
  cylinder { // Cylndr230
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 0.728394>
    rotate 90.0*y
    translate  <0.960061, 0.0, 17.703569>
  }
  cylinder { // Cylndr231
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 0.799967>
    rotate 90.0*y
    translate  <0.888489, 0.0, 16.303569>
  }
  cylinder { // Cylndr232
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 0.884553>
    rotate 90.0*y
    translate  <0.810409, 0.0, 14.903569>
  }
  cylinder { // Cylndr233
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 0.943112>
    rotate 90.0*y
    translate  <0.745343, 0.0, 13.503569>
  }
  cylinder { // Cylndr234
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.021191>
    rotate 90.0*y
    translate  <0.686784, 0.0, 12.103569>
  }
  cylinder { // Cylndr235
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.125297>
    rotate 90.0*y
    translate  <0.582678, 0.0, 10.703569>
  }
  cylinder { // Cylndr236
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.17735>
    rotate 90.0*y
    translate  <0.524119, 0.0, 9.303569>
  }
  cylinder { // Cylndr237
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.190363>
    rotate 90.0*y
    translate  <0.478573, 0.0, 7.903569>
  }
  cylinder { // Cylndr238
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.268442>
    rotate 90.0*y
    translate  <0.393987, 0.0, 6.503569>
  }
  cylinder { // Cylndr239
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.353028>
    rotate 90.0*y
    translate  <0.322414, 0.0, 5.103569>
  }
  cylinder { // Cylndr240
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.44412>
    rotate 90.0*y
    translate  <0.257348, 0.0, 3.703569>
  }
  cylinder { // Cylndr241
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.556034>
    rotate 90.0*y
    translate  <0.153243, 0.0, 2.303569>
  }
  cylinder { // Cylndr242
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.665345>
    rotate 90.0*y
    translate  <0.06215, 0.0, 0.903569>
  }
  object { staak17 }
  object { staak18 }
  cylinder { // Cylndr255
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.021281, 0.033033, 9.649512>
    rotate <159.096802, -3.131191, -176.972839>
    translate  <1.638128, 0.14034, -4.763219>
  }
  cylinder { // Cylndr256
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.021416, 0.032195, 9.838606>
    rotate <-20.72617, -187.641617, -353.232239>
    translate  <-0.115352, 0.037156, -4.626188>
  }
  scale <1.46751, 1.112217, 0.650291>
  rotate <-8.856463, 4.230542, -0.278396>
  translate  <19.828781, -2.806966, 35.473984>
}
#declare talje19 = union {
  cylinder { // Cylndr259
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.05, 0.05, 1.3>
    translate  <0.120119, 0.0, -1.231789>
  }
  cylinder { // Cylndr260
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.05, 0.05, 1.3>
    translate  <-0.103531, 0.0, -1.231789>
  }
  cylinder { // Cylndr261
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale 0.25
    rotate -90.0*x
    translate  <0.0, -0.120123, -1.197327>
  }
  cylinder { // Cylndr262
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale 0.25
    rotate -90.0*x
    translate  -0.120123*y
  }
}
#declare staak19 = union {
  cylinder { // Cylndr257
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.0, 0.0, -0.989765>
    material {
      greyMdark
    }
    scale <0.05, 0.05, 3.0>
    rotate <27.969189, -0.031142, -0.018633>
    translate  -1.303684*z
  }
  cylinder { // Cylndr258
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.525539, 0.0, -0.000938>
    material {
      greyMdark
    }
    scale <0.05, 0.05, 40.0>
    rotate <-9.945626, -2.051564, 0.359194>
    translate  <-0.026277, 0.0, 0.026277>
  }
  object { talje19 }
  translate  <-0.0, 0.0, 1.225448>
  scale 1.1
  rotate <1.497361, 1.406925, 0.038599>
  translate  <22.691734, -7.736787, 0.727773>
}
#declare talje20 = union {
  cylinder { // Cylndr265
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.05, 0.05, 1.3>
    translate  <0.120119, 0.0, -1.231789>
  }
  cylinder { // Cylndr266
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.05, 0.05, 1.3>
    translate  <-0.103531, 0.0, -1.231789>
  }
  cylinder { // Cylndr267
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale 0.25
    rotate -90.0*x
    translate  <0.0, -0.120123, -1.197327>
  }
  cylinder { // Cylndr268
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale 0.25
    rotate -90.0*x
    translate  -0.120123*y
  }
}
#declare staak20 = union {
  cylinder { // Cylndr263
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.0, 0.0, -0.989765>
    material {
      greyMdark
    }
    scale <0.05, 0.05, 3.0>
    rotate <27.997166, 0.0, 0.0>
    translate  -1.303684*z
  }
  cylinder { // Cylndr264
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.525539, 0.0, -0.000938>
    material {
      greyMdark
    }
    scale <0.05, 0.05, 47.0>
    rotate <-8.516235, -0.37206, 0.058779>
    translate  <-0.026277, 0.0, 0.026277>
  }
  object { talje20 }
  translate  <-0.0, 0.0, 1.225448>
  scale 1.1
  rotate <1.511838, -0.069916, -0.00222>
  translate  <23.830651, -7.72146, 0.743597>
}
#declare talje21 = union {
  cylinder { // Cylndr297
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.05, 0.05, 1.3>
    translate  <0.120119, 0.0, -1.231789>
  }
  cylinder { // Cylndr298
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.05, 0.05, 1.3>
    translate  <-0.103531, 0.0, -1.231789>
  }
  cylinder { // Cylndr299
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale 0.25
    rotate -90.0*x
    translate  <0.0, -0.120123, -1.197327>
  }
  cylinder { // Cylndr300
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale 0.25
    rotate -90.0*x
    translate  -0.120123*y
  }
}
#declare staak21 = union {
  cylinder { // Cylndr295
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.0, 0.0, -0.989765>
    material {
      greyMdark
    }
    scale <0.05, 0.05, 3.0>
    rotate <53.050507, -0.0, -0.0>
    translate  -1.303684*z
  }
  cylinder { // Cylndr296
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.525539, 0.0, -0.000938>
    material {
      greyMdark
    }
    scale <0.05, 0.05, 28.0>
    translate  <-0.026277, 0.0, 0.026277>
  }
  object { talje21 }
  translate  <-0.043766, 0.0, 1.225448>
  translate  <1.720387, 0.0, -1.225448>
}
#declare talje22 = union {
  cylinder { // Cylndr303
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.05, 0.05, 1.3>
    translate  <0.120119, 0.0, -1.231789>
  }
  cylinder { // Cylndr304
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.05, 0.05, 1.3>
    translate  <-0.103531, 0.0, -1.231789>
  }
  cylinder { // Cylndr305
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale 0.25
    rotate -90.0*x
    translate  <0.0, -0.120123, -1.197327>
  }
  cylinder { // Cylndr306
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale 0.25
    rotate -90.0*x
    translate  -0.120123*y
  }
}
#declare staak22 = union {
  cylinder { // Cylndr301
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.0, 0.0, -0.989765>
    material {
      greyMdark
    }
    scale <0.05, 0.05, 3.0>
    rotate <52.443462, 0.107783, 0.143872>
    translate  -1.303684*z
  }
  cylinder { // Cylndr302
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.525539, 0.0, -0.000938>
    material {
      greyMdark
    }
    scale <0.05, 0.05, 28.0>
    translate  <-0.026277, 0.0, 0.026277>
  }
  object { talje22 }
  translate  <-0.043766, 0.0, 1.225448>
  rotate 1.390532*y
  translate  <0.886356, 0.0, -1.225448>
}
#declare talje23 = union {
  cylinder { // Cylndr309
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.05, 0.05, 1.3>
    translate  <0.120119, 0.0, -1.231789>
  }
  cylinder { // Cylndr310
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.05, 0.05, 1.3>
    translate  <-0.103531, 0.0, -1.231789>
  }
  cylinder { // Cylndr311
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale 0.25
    rotate -90.0*x
    translate  <0.0, -0.120123, -1.197327>
  }
  cylinder { // Cylndr312
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale 0.25
    rotate -90.0*x
    translate  -0.120123*y
  }
}
#declare staak23 = union {
  cylinder { // Cylndr307
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.0, 0.0, -0.989765>
    material {
      greyMdark
    }
    scale <0.05, 0.05, 3.0>
    rotate <52.434818, 0.15751, 0.237646>
    translate  -1.303684*z
  }
  cylinder { // Cylndr308
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.525539, 0.0, -0.000938>
    material {
      greyMdark
    }
    scale <0.05, 0.05, 28.0>
    translate  <-0.026277, 0.0, 0.026277>
  }
  object { talje23 }
  translate  <-0.0, 0.0, 1.225448>
  rotate 2.9534*y
  translate  -1.225448*z
}
#declare wante2 = union {
  cylinder { // Cylndr269
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 0.689355>
    rotate 90.0*y
    translate  <0.992594, 0.0, 18.403569>
  }
  cylinder { // Cylndr270
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 0.728394>
    rotate 90.0*y
    translate  <0.960061, 0.0, 17.703569>
  }
  cylinder { // Cylndr271
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 0.780447>
    rotate 90.0*y
    translate  <0.921022, 0.0, 17.003569>
  }
  cylinder { // Cylndr272
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 0.799967>
    rotate 90.0*y
    translate  <0.888489, 0.0, 16.303569>
  }
  cylinder { // Cylndr273
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 0.858526>
    rotate 90.0*y
    translate  <0.849449, 0.0, 15.603569>
  }
  cylinder { // Cylndr274
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 0.884553>
    rotate 90.0*y
    translate  <0.810409, 0.0, 14.903569>
  }
  cylinder { // Cylndr275
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 0.910579>
    rotate 90.0*y
    translate  <0.777876, 0.0, 14.203569>
  }
  cylinder { // Cylndr276
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 0.943112>
    rotate 90.0*y
    translate  <0.745343, 0.0, 13.503569>
  }
  cylinder { // Cylndr277
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 0.962632>
    rotate 90.0*y
    translate  <0.725824, 0.0, 12.803569>
  }
  cylinder { // Cylndr278
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.021191>
    rotate 90.0*y
    translate  <0.686784, 0.0, 12.103569>
  }
  cylinder { // Cylndr279
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.021191>
    rotate 90.0*y
    translate  <0.660758, 0.0, 11.403569>
  }
  cylinder { // Cylndr280
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.125297>
    rotate 90.0*y
    translate  <0.582678, 0.0, 10.703569>
  }
  cylinder { // Cylndr281
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.151323>
    rotate 90.0*y
    translate  <0.550145, 0.0, 10.003569>
  }
  cylinder { // Cylndr282
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.17735>
    rotate 90.0*y
    translate  <0.524119, 0.0, 9.303569>
  }
  cylinder { // Cylndr283
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.190363>
    rotate 90.0*y
    translate  <0.504599, 0.0, 8.603569>
  }
  cylinder { // Cylndr284
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.190363>
    rotate 90.0*y
    translate  <0.478573, 0.0, 7.903569>
  }
  cylinder { // Cylndr285
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.261936>
    rotate 90.0*y
    translate  <0.42652, 0.0, 7.203569>
  }
  cylinder { // Cylndr286
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.268442>
    rotate 90.0*y
    translate  <0.393987, 0.0, 6.503569>
  }
  cylinder { // Cylndr287
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.340015>
    rotate 90.0*y
    translate  <0.361454, 0.0, 5.803569>
  }
  cylinder { // Cylndr288
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.353028>
    rotate 90.0*y
    translate  <0.322414, 0.0, 5.103569>
  }
  cylinder { // Cylndr289
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.392068>
    rotate 90.0*y
    translate  <0.309401, 0.0, 4.403569>
  }
  cylinder { // Cylndr290
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.44412>
    rotate 90.0*y
    translate  <0.257348, 0.0, 3.703569>
  }
  cylinder { // Cylndr291
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.52567>
    rotate 90.0*y
    translate  <0.177534, 0.0, 3.003569>
  }
  cylinder { // Cylndr292
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.556034>
    rotate 90.0*y
    translate  <0.153243, 0.0, 2.303569>
  }
  cylinder { // Cylndr293
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.634981>
    rotate 90.0*y
    translate  <0.098587, 0.0, 1.603569>
  }
  cylinder { // Cylndr294
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.665345>
    rotate 90.0*y
    translate  <0.06215, 0.0, 0.903569>
  }
  object { staak21 }
  object { staak22 }
  object { staak23 }
  scale <2.415146, 1.0, 1.14>
  rotate <-11.025712, -0.521985, 0.005246>
  translate  <17.25563, -7.453975, 2.067355>
}
#declare wantenMvMuMstar1 = union {
  object { staak19 }
  object { staak20 }
  object { wante2 }
  scale -1.0
  rotate <-0.0, -180.0, -6.378803>
  translate  <0.082604, 1.106411, 0.0>
}
#declare talje24 = union {
  cylinder { // Cylndr315
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.05, 0.05, 1.3>
    translate  <0.120119, 0.0, -1.231789>
  }
  cylinder { // Cylndr316
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.05, 0.05, 1.3>
    translate  <-0.103531, 0.0, -1.231789>
  }
  cylinder { // Cylndr317
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale 0.25
    rotate -90.0*x
    translate  <0.0, -0.120123, -1.197327>
  }
  cylinder { // Cylndr318
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale 0.25
    rotate -90.0*x
    translate  -0.120123*y
  }
}
#declare staak24 = union {
  cylinder { // Cylndr313
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.0, 0.0, -0.989765>
    material {
      greyMdark
    }
    scale <0.05, 0.05, 3.0>
    rotate <27.969189, -0.031142, -0.018633>
    translate  -1.303684*z
  }
  cylinder { // Cylndr314
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.525539, 0.0, -0.000938>
    material {
      greyMdark
    }
    scale <0.05, 0.05, 40.0>
    rotate <-9.945626, -2.051564, 0.359194>
    translate  <-0.026277, 0.0, 0.026277>
  }
  object { talje24 }
  translate  <-0.0, 0.0, 1.225448>
  scale 1.1
  rotate <-0.008402, 1.49464, 0.001271>
  translate  <22.691734, -7.736787, 0.727773>
}
#declare talje25 = union {
  cylinder { // Cylndr321
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.05, 0.05, 1.3>
    translate  <0.120119, 0.0, -1.231789>
  }
  cylinder { // Cylndr322
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.05, 0.05, 1.3>
    translate  <-0.103531, 0.0, -1.231789>
  }
  cylinder { // Cylndr323
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale 0.25
    rotate -90.0*x
    translate  <0.0, -0.120123, -1.197327>
  }
  cylinder { // Cylndr324
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale 0.25
    rotate -90.0*x
    translate  -0.120123*y
  }
}
#declare staak25 = union {
  cylinder { // Cylndr319
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.0, 0.0, -0.989765>
    material {
      greyMdark
    }
    scale <0.05, 0.05, 3.0>
    rotate <27.997166, 0.0, 0.0>
    translate  -1.303684*z
  }
  cylinder { // Cylndr320
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.525539, 0.0, -0.000938>
    material {
      greyMdark
    }
    scale <0.05, 0.05, 47.0>
    rotate <-8.516235, -0.37206, 0.058779>
    translate  <-0.026277, 0.0, 0.026277>
  }
  object { talje25 }
  translate  <-0.0, 0.0, 1.225448>
  scale 1.1
  rotate <0.047454, -0.064309, 0.001242>
  translate  <23.830651, -7.72146, 0.743597>
}
#declare talje26 = union {
  cylinder { // Cylndr353
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.05, 0.05, 1.3>
    translate  <0.120119, 0.0, -1.231789>
  }
  cylinder { // Cylndr354
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.05, 0.05, 1.3>
    translate  <-0.103531, 0.0, -1.231789>
  }
  cylinder { // Cylndr355
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale 0.25
    rotate -90.0*x
    translate  <0.0, -0.120123, -1.197327>
  }
  cylinder { // Cylndr356
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale 0.25
    rotate -90.0*x
    translate  -0.120123*y
  }
}
#declare staak26 = union {
  cylinder { // Cylndr351
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.0, 0.0, -0.989765>
    material {
      greyMdark
    }
    scale <0.05, 0.05, 3.0>
    rotate <48.560883, 0.0, 0.0>
    translate  -1.303684*z
  }
  cylinder { // Cylndr352
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.525539, 0.0, -0.000938>
    material {
      greyMdark
    }
    scale <0.05, 0.05, 28.0>
    translate  <-0.026277, 0.0, 0.026277>
  }
  object { talje26 }
  translate  <-0.043766, 0.0, 1.225448>
  translate  <1.720387, 0.0, -1.225448>
}
#declare talje27 = union {
  cylinder { // Cylndr359
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.05, 0.05, 1.3>
    translate  <0.120119, 0.0, -1.231789>
  }
  cylinder { // Cylndr360
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.05, 0.05, 1.3>
    translate  <-0.103531, 0.0, -1.231789>
  }
  cylinder { // Cylndr361
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale 0.25
    rotate -90.0*x
    translate  <0.0, -0.120123, -1.197327>
  }
  cylinder { // Cylndr362
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale 0.25
    rotate -90.0*x
    translate  -0.120123*y
  }
}
#declare staak27 = union {
  cylinder { // Cylndr357
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.0, 0.0, -0.989765>
    material {
      greyMdark
    }
    scale <0.05, 0.05, 3.0>
    rotate <53.546669, 0.118913, 0.159191>
    translate  -1.303684*z
  }
  cylinder { // Cylndr358
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.525539, 0.0, -0.000938>
    material {
      greyMdark
    }
    scale <0.05, 0.05, 28.0>
    translate  <-0.026277, 0.0, 0.026277>
  }
  object { talje27 }
  translate  <-0.043766, 0.0, 1.225448>
  rotate 1.390532*y
  translate  <0.886356, 0.0, -1.225448>
}
#declare talje28 = union {
  cylinder { // Cylndr365
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.05, 0.05, 1.3>
    translate  <0.120119, 0.0, -1.231789>
  }
  cylinder { // Cylndr366
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.05, 0.05, 1.3>
    translate  <-0.103531, 0.0, -1.231789>
  }
  cylinder { // Cylndr367
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale 0.25
    rotate -90.0*x
    translate  <0.0, -0.120123, -1.197327>
  }
  cylinder { // Cylndr368
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale 0.25
    rotate -90.0*x
    translate  -0.120123*y
  }
}
#declare staak28 = union {
  cylinder { // Cylndr363
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.0, 0.0, -0.989765>
    material {
      greyMdark
    }
    scale <0.05, 0.05, 3.0>
    rotate <52.229847, 0.153114, 0.231747>
    translate  -1.303684*z
  }
  cylinder { // Cylndr364
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.525539, 0.0, -0.000938>
    material {
      greyMdark
    }
    scale <0.05, 0.05, 28.0>
    translate  <-0.026277, 0.0, 0.026277>
  }
  object { talje28 }
  translate  <-0.0, 0.0, 1.225448>
  rotate 2.9534*y
  translate  -1.225448*z
}
#declare wante3 = union {
  cylinder { // Cylndr325
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 0.689355>
    rotate 90.0*y
    translate  <0.992594, 0.0, 18.403569>
  }
  cylinder { // Cylndr326
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 0.728394>
    rotate 90.0*y
    translate  <0.960061, 0.0, 17.703569>
  }
  cylinder { // Cylndr327
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 0.780447>
    rotate 90.0*y
    translate  <0.921022, 0.0, 17.003569>
  }
  cylinder { // Cylndr328
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 0.799967>
    rotate 90.0*y
    translate  <0.888489, 0.0, 16.303569>
  }
  cylinder { // Cylndr329
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 0.858526>
    rotate 90.0*y
    translate  <0.849449, 0.0, 15.603569>
  }
  cylinder { // Cylndr330
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 0.884553>
    rotate 90.0*y
    translate  <0.810409, 0.0, 14.903569>
  }
  cylinder { // Cylndr331
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 0.910579>
    rotate 90.0*y
    translate  <0.777876, 0.0, 14.203569>
  }
  cylinder { // Cylndr332
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 0.943112>
    rotate 90.0*y
    translate  <0.745343, 0.0, 13.503569>
  }
  cylinder { // Cylndr333
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 0.962632>
    rotate 90.0*y
    translate  <0.725824, 0.0, 12.803569>
  }
  cylinder { // Cylndr334
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.021191>
    rotate 90.0*y
    translate  <0.686784, 0.0, 12.103569>
  }
  cylinder { // Cylndr335
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.021191>
    rotate 90.0*y
    translate  <0.660758, 0.0, 11.403569>
  }
  cylinder { // Cylndr336
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.125297>
    rotate 90.0*y
    translate  <0.582678, 0.0, 10.703569>
  }
  cylinder { // Cylndr337
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.151323>
    rotate 90.0*y
    translate  <0.550145, 0.0, 10.003569>
  }
  cylinder { // Cylndr338
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.17735>
    rotate 90.0*y
    translate  <0.524119, 0.0, 9.303569>
  }
  cylinder { // Cylndr339
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.190363>
    rotate 90.0*y
    translate  <0.504599, 0.0, 8.603569>
  }
  cylinder { // Cylndr340
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.190363>
    rotate 90.0*y
    translate  <0.478573, 0.0, 7.903569>
  }
  cylinder { // Cylndr341
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.261936>
    rotate 90.0*y
    translate  <0.42652, 0.0, 7.203569>
  }
  cylinder { // Cylndr342
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.268442>
    rotate 90.0*y
    translate  <0.393987, 0.0, 6.503569>
  }
  cylinder { // Cylndr343
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.340015>
    rotate 90.0*y
    translate  <0.361454, 0.0, 5.803569>
  }
  cylinder { // Cylndr344
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.353028>
    rotate 90.0*y
    translate  <0.322414, 0.0, 5.103569>
  }
  cylinder { // Cylndr345
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.392068>
    rotate 90.0*y
    translate  <0.309401, 0.0, 4.403569>
  }
  cylinder { // Cylndr346
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.44412>
    rotate 90.0*y
    translate  <0.257348, 0.0, 3.703569>
  }
  cylinder { // Cylndr347
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.52567>
    rotate 90.0*y
    translate  <0.177534, 0.0, 3.003569>
  }
  cylinder { // Cylndr348
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.556034>
    rotate 90.0*y
    translate  <0.153243, 0.0, 2.303569>
  }
  cylinder { // Cylndr349
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.634981>
    rotate 90.0*y
    translate  <0.098587, 0.0, 1.603569>
  }
  cylinder { // Cylndr350
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.665345>
    rotate 90.0*y
    translate  <0.06215, 0.0, 0.903569>
  }
  object { staak26 }
  object { staak27 }
  object { staak28 }
  scale <2.415146, 1.0, 1.14>
  rotate <-12.970515, 0.0, -0.0>
  translate  <17.25563, -7.453975, 2.067355>
}
#declare wantenMvMuMback1 = union {
  object { staak24 }
  object { staak25 }
  object { wante3 }
  rotate <1.274264, -0.161819, 7.23606>
  translate  <0.188102, -1.671956, -0.020459>
}
#declare talje29 = union {
  cylinder { // Cylndr381
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.04, 0.04, 1.3>
    translate  <0.120119, 0.0, -1.231789>
  }
  cylinder { // Cylndr382
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.04, 0.04, 1.3>
    translate  <-0.103531, 0.0, -1.231789>
  }
  cylinder { // Cylndr383
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale <0.20483, 0.175629, 0.233342>
    rotate -90.0*x
    translate  <0.0, -0.120123, -1.197327>
  }
  cylinder { // Cylndr384
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale <0.191173, 0.15228, 0.233222>
    rotate -90.0*x
    translate  -0.120123*y
  }
  cylinder { // Cylndr385
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.04, 0.04, 2.3713>
    rotate -0.181559*y
    translate  <0.008427, 0.0, -1.783827>
  }
  scale <2.0, 2.0, 3.3>
  rotate <113.641273, -193.278122, 152.352524>
  translate  <63.259819, -0.126921, 4.638476>
}
#declare mainMboom = union {
  box { // Cube080
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMmed
    }
    scale <0.190207, 0.593834, 1.371485>
    rotate -90.0*y
    translate  <32.039814, -0.00853, 22.181196>
  }
  cone { // Cone006
    <0,0,0>, 0.5, <0,0,1>, 1.0
    open
    material {
      woodMskinMmed
    }
    scale <0.4, 0.4, 32.0>
    rotate <0.0, -90.0, 0.0>
    translate  <64.189159, 0.0, 22.181196>
  }
  cylinder { // Cylndr380
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale <0.299347, 0.299347, 1.0>
    rotate -90.0*y
    translate  <63.807608, 0.0, 22.160993>
  }
  translate  <8.078446, 0.0, -16.662013>
}
#declare mainMgaffel = union {
  box { // Cube105
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMmed
    }
    scale <0.190207, 0.593834, 1.371485>
    rotate -90.0*y
    translate  <46.088983, -0.00853, 22.181196>
  }
  cone { // Cone018
    <0,0,0>, 0.5, <0,0,1>, 1.0
    open
    material {
      woodMskinMmed
    }
    scale <0.4, 0.4, 18.0>
    rotate -90.0*y
    translate  <64.189159, 0.0, 22.181196>
  }
  cylinder { // Cylndr412
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale <0.299347, 0.299347, 1.0>
    rotate -90.0*y
    translate  <63.807608, 0.0, 22.160993>
  }
  cylinder { // Cylndr413
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 20.0>
    rotate -212.657761*y
    translate  <52.847438, 0.0, 39.126227>
  }
  rotate -13.89125*y
  translate  <3.159758, 0.0, -11.078954>
}
#declare foldedMsail3 = union {
  torus { // Torus040
    1.85, 0.15  rotate -x*90
    material {
      blackringMskin
    }
    scale <0.284385, 0.284385, 0.35418>
    rotate -90.0*y
    translate  <13.644668, 0.0, -0.365467>
  }
  torus { // Torus041
    1.85, 0.15  rotate -x*90
    material {
      blackringMskin
    }
    scale <0.284385, 0.284385, 0.35418>
    rotate -90.0*y
    translate  <-13.057321, 0.0, -0.412449>
  }
  torus { // Torus042
    1.85, 0.15  rotate -x*90
    material {
      blackringMskin
    }
    scale <0.284385, 0.284385, 0.35418>
    rotate -90.0*y
    translate  <-8.791545, 0.0, -0.502571>
  }
  torus { // Torus043
    1.85, 0.15  rotate -x*90
    material {
      blackringMskin
    }
    scale <0.284385, 0.284385, 0.35418>
    rotate -90.0*y
    translate  <9.442439, 0.0, -0.506631>
  }
  torus { // Torus044
    1.85, 0.15  rotate -x*90
    material {
      blackringMskin
    }
    scale <0.284385, 0.284385, 0.35418>
    rotate -90.0*y
    translate  <3.989283, 0.0, -0.615489>
  }
  torus { // Torus045
    1.85, 0.15  rotate -x*90
    material {
      blackringMskin
    }
    scale <0.284385, 0.284385, 0.35418>
    rotate -90.0*y
    translate  <-3.624549, 0.0, -0.592693>
  }
  sphere { // Sphere026
    <0,0,0>,1
    material {
      foldedMsailMskin
    }
    scale <3.496826, 0.62244, 0.436996>
    rotate 2.448526*y
    translate  <-11.896644, 0.0, -0.489574>
  }
  sphere { // Sphere027
    <0,0,0>,1
    material {
      foldedMsailMskin
    }
    scale <3.692656, 0.657298, 0.461469>
    translate  <-6.36446, 0.0, -0.538531>
  }
  sphere { // Sphere028
    <0,0,0>,1
    material {
      foldedMsailMskin
    }
    scale <3.349954, 0.596297, 0.418642>
    rotate -1.741166*y
    translate  <12.141431, 0.0, -0.489574>
  }
  sphere { // Sphere029
    <0,0,0>,1
    material {
      foldedMsailMskin
    }
    scale <3.692656, 0.657298, 0.461469>
    translate  <6.902991, 0.0, -0.538531>
  }
  sphere { // Sphere030
    <0,0,0>,1
    material {
      foldedMsailMskin
    }
    scale <4.818676, 0.657298, 0.608341>
    translate  <0.19583, 0.0, -0.685403>
  }
  rotate <178.62352, 0.0, -0.0>
  translate  <55.877962, -0.018061, 5.558895>
}
#declare grossMsegel1 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-3.076502, -1.357854, 0.000000>, <-1.282931, -1.741155, 0.000000>, <-0.016102, -2.015647, 0.000000>, <1.017829, -2.175684, 0.000000>, 
      <-2.935547, -0.202604, 2.461571>, <-0.830604, -0.507591, 2.299265>, <0.156378, -0.786704, 1.741773>, <1.000000, -1.000000, 0.000000>, 
      <-2.329428, 0.650088, 2.461571>, <-0.651253, 0.405161, 2.299265>, <0.209703, 0.186634, 1.741773>, <1.000000, 0.000000, 0.000000>, 
      <-0.942060, 1.950193, 0.000000>, <-0.428573, 1.651808, 0.000000>, <0.326046, 1.220351, 0.000000>, <1.045941, 0.821688, 0.000000>
    }
  }
  material {
    mainMsailMtex
  }
  scale <7.281448, 5.082769, 2.38611>
  rotate <90.0, -8.462852, -180.0>
  translate  <49.381125, -0.10428, 16.301183>
}
#declare mainMsail = union {
  cylinder { // Cylndr386
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 42.5>
    rotate <180.0, 39.747208, 180.0>
    translate  <44.374424, 0.0, 38.006973>
  }
  object { talje29 }
  object { mainMboom }
  object { mainMgaffel }
  object { foldedMsail3 }
  object { grossMsegel1 }
  cylinder { // Cylndr418
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 14.5>
    rotate <-12.717085, -225.439224, -29.806345>
    translate  <43.27295, -0.865871, 34.498283>
  }
  cylinder { // Cylndr417
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 17.5>
    rotate <-7.622719, -211.461853, -26.613468>
    translate  <44.745392, -1.218358, 39.318777>
  }
  rotate <-0.0, -9.606634, 0.0>
  translate  <-37.886704, 0.015175, -11.995871>
  scale 0.934579
  rotate <0.0, 9.606634, 12.231728>
  translate  <16.942033, -0.014182, 5.144865>
}
#declare mainmastgroup = union {
  box { // wantentraegerMvMstar1
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMbright
    }
    scale <3.991766, 0.651448, 0.2>
    rotate <-0.29923, 1.733651, -6.259081>
    translate  <21.156912, 6.384722, 0.0>
  }
  box { // wantentraegerMvMback1
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMbright
    }
    scale <4.037785, 0.750198, 0.200923>
    rotate <0.273485, 1.734977, 6.562198>
    translate  <21.31414, -6.457882, 0.0>
  }
  object { mainmast }
  object { wanteMvMoMstar1 }
  object { wanteMvMoMback1 }
  object { wantenMvMuMstar1 }
  object { wantenMvMuMback1 }
  object { mainMsail }
  scale 1.07
  translate  21.229337*x
}
#declare hullstar = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 2 v_steps 2,
      <-0.819495, -61.505908, 3.940596>, <0.057193, -61.461241, 3.679827>, <0.029198, -61.459255, 1.377488>, <0.602243, -61.417863, 0.030628>, 
      <-0.816247, -61.442572, 4.004250>, <0.059895, -61.441548, 3.679827>, <0.037859, -61.408912, 1.377488>, <0.687179, -61.385634, 0.030628>, 
      <-0.783751, -60.702810, 4.202801>, <0.717756, -60.673108, 4.828237>, <0.221370, -60.691603, 1.513039>, <1.074733, -60.702810, 0.000000>, 
      <-0.689652, -58.851405, 4.371403>, <0.967662, -58.848719, 5.055607>, <0.622688, -58.845801, 1.569815>, <1.842434, -58.851405, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 2 v_steps 2,
      <-0.689652, -58.851405, 4.371403>, <0.967662, -58.848719, 5.055607>, <0.622688, -58.845801, 1.569815>, <1.842434, -58.851405, 0.000000>, 
      <-0.595554, -57.000000, 4.540005>, <1.217569, -57.024329, 5.282978>, <1.024007, -57.000000, 1.626591>, <2.610134, -57.000000, 0.000000>, 
      <-0.300000, -53.100000, 5.056181>, <1.819963, -53.100000, 5.822623>, <2.333947, -53.100000, 1.806035>, <4.386405, -53.100000, 0.000000>, 
      <-0.300000, -51.050000, 5.328090>, <2.108890, -51.050000, 6.027292>, <2.860530, -51.050000, 1.951948>, <5.090852, -51.050000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 2 v_steps 2,
      <-0.300000, -51.050000, 5.328090>, <2.108890, -51.050000, 6.027292>, <2.860530, -51.050000, 1.951948>, <5.090852, -51.050000, 0.000000>, 
      <-0.300000, -49.000000, 5.600000>, <2.397818, -49.000000, 6.231961>, <3.387114, -49.000000, 2.097861>, <5.795300, -49.000000, 0.000000>, 
      <-0.300000, -44.300000, 6.300000>, <2.633260, -44.300000, 6.718051>, <4.104675, -44.300000, 2.437967>, <6.869924, -44.300000, 0.000000>, 
      <-0.300000, -41.650000, 6.550000>, <2.722842, -41.650000, 6.922720>, <4.417614, -41.650000, 2.572039>, <7.059587, -41.650000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 2 v_steps 2,
      <-0.300000, -41.650000, 6.550000>, <2.722842, -41.650000, 6.922720>, <4.417614, -41.650000, 2.572039>, <7.059587, -41.650000, 0.000000>, 
      <-0.300000, -39.000000, 6.800000>, <2.812423, -39.000000, 7.127389>, <4.730553, -39.000000, 2.706112>, <7.249249, -39.000000, 0.000000>, 
      <-0.400000, -33.800000, 7.200000>, <2.874474, -33.800000, 7.459977>, <4.801470, -33.800000, 2.782863>, <7.500000, -33.800000, 0.000000>, 
      <-0.450000, -31.300000, 7.350000>, <2.900438, -31.300000, 7.549520>, <4.821222, -31.300000, 2.760157>, <7.500000, -31.300000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 2 v_steps 2,
      <-0.450000, -31.300000, 7.350000>, <2.900438, -31.300000, 7.549520>, <4.821222, -31.300000, 2.760157>, <7.500000, -31.300000, 0.000000>, 
      <-0.500000, -28.800000, 7.500000>, <2.926402, -28.800000, 7.639063>, <4.840974, -28.800000, 2.737452>, <7.500000, -28.800000, 0.000000>, 
      <-0.500000, -23.800000, 7.400000>, <2.926402, -23.800000, 7.590280>, <4.840974, -23.800000, 2.660701>, <7.400000, -23.800000, 0.000000>, 
      <-0.600000, -21.200000, 7.350000>, <2.881201, -21.200000, 7.578681>, <4.800966, -21.200000, 2.642110>, <7.340570, -21.200000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 2 v_steps 2,
      <-0.600000, -21.200000, 7.350000>, <2.881201, -21.200000, 7.578681>, <4.800966, -21.200000, 2.642110>, <7.340570, -21.200000, 0.000000>, 
      <-0.700000, -18.600000, 7.300000>, <2.836000, -18.600000, 7.567082>, <4.760958, -18.600000, 2.623518>, <7.281140, -18.600000, 0.000000>, 
      <-0.900000, -13.600000, 6.800000>, <2.443132, -13.600000, 7.143759>, <4.362649, -13.600000, 2.546767>, <7.000000, -13.600000, 0.000000>, 
      <-1.000000, -11.700000, 6.400000>, <2.194014, -11.700000, 6.775331>, <4.005742, -11.700000, 2.448264>, <6.650000, -11.700000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 2 v_steps 2,
      <-1.000000, -11.700000, 6.400000>, <2.194014, -11.700000, 6.775331>, <4.005742, -11.700000, 2.448264>, <6.650000, -11.700000, 0.000000>, 
      <-1.100000, -9.800000, 6.000000>, <1.944896, -9.800000, 6.406902>, <3.648835, -9.800000, 2.349761>, <6.300000, -9.800000, 0.000000>, 
      <-1.300000, -6.700000, 5.036103>, <1.391958, -6.700000, 5.786647>, <2.844711, -6.700000, 2.102557>, <4.877271, -6.700000, 0.000000>, 
      <-1.450000, -5.100000, 4.027421>, <1.032107, -5.090983, 4.402314>, <2.072356, -5.100000, 1.760543>, <3.688635, -5.100000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 2 v_steps 2,
      <-1.450000, -5.100000, 4.027421>, <1.032107, -5.090983, 4.402314>, <2.072356, -5.100000, 1.760543>, <3.688635, -5.100000, 0.000000>, 
      <-1.600000, -3.500000, 3.018740>, <0.672256, -3.481965, 3.017980>, <1.300000, -3.500000, 1.418529>, <2.500000, -3.500000, 0.000000>, 
      <-1.619597, -0.300000, 0.000000>, <-0.889530, -0.460134, 0.000000>, <0.396565, -1.124651, 0.000000>, <1.096649, -1.793030, 0.000000>, 
      <-1.619597, 0.000000, 0.000000>, <-0.889530, -0.160134, 0.000000>, <0.195086, -0.845260, 0.018035>, <0.896649, -1.493030, 0.000000>
    }
  }
  rotate <0.0, 90.0, 90.0>
}
// Include contains 'kiel'
#include "balt.in1"

#declare kiel = object {
  kiel_Raw
  material {
    plankMskinM02
  }
  scale <1.0, 1.0, 0.5>
  rotate <-90.0, 90.0, 0.0>
  translate  -0.25*y
}
#declare hullback = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 2 v_steps 2,
      <-0.819495, -61.505908, -3.940596>, <0.057193, -61.461241, -3.679827>, <0.029198, -61.459255, -1.377488>, <0.602243, -61.417863, -0.030628>, 
      <-0.816247, -61.442572, -4.004250>, <0.059895, -61.441548, -3.679827>, <0.037859, -61.408912, -1.377488>, <0.687179, -61.385634, -0.030628>, 
      <-0.783751, -60.702810, -4.202801>, <0.717756, -60.673108, -4.828237>, <0.221370, -60.691603, -1.513039>, <1.074733, -60.702810, 0.000000>, 
      <-0.689652, -58.851405, -4.371403>, <0.967662, -58.848719, -5.055607>, <0.622688, -58.845801, -1.569815>, <1.842434, -58.851405, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 2 v_steps 2,
      <-0.689652, -58.851405, -4.371403>, <0.967662, -58.848719, -5.055607>, <0.622688, -58.845801, -1.569815>, <1.842434, -58.851405, 0.000000>, 
      <-0.595554, -57.000000, -4.540005>, <1.217569, -57.024329, -5.282978>, <1.024007, -57.000000, -1.626591>, <2.610134, -57.000000, 0.000000>, 
      <-0.300000, -53.100000, -5.056181>, <1.819963, -53.100000, -5.822623>, <2.333947, -53.100000, -1.806035>, <4.386405, -53.100000, 0.000000>, 
      <-0.300000, -51.050000, -5.328090>, <2.108890, -51.050000, -6.027292>, <2.860530, -51.050000, -1.951948>, <5.090852, -51.050000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 2 v_steps 2,
      <-0.300000, -51.050000, -5.328090>, <2.108890, -51.050000, -6.027292>, <2.860530, -51.050000, -1.951948>, <5.090852, -51.050000, 0.000000>, 
      <-0.300000, -49.000000, -5.600000>, <2.397818, -49.000000, -6.231961>, <3.387114, -49.000000, -2.097861>, <5.795300, -49.000000, 0.000000>, 
      <-0.300000, -44.300000, -6.300000>, <2.633260, -44.300000, -6.718051>, <4.104675, -44.300000, -2.437967>, <6.869924, -44.300000, 0.000000>, 
      <-0.300000, -41.650000, -6.550000>, <2.722842, -41.650000, -6.922720>, <4.417614, -41.650000, -2.572039>, <7.059587, -41.650000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 2 v_steps 2,
      <-0.300000, -41.650000, -6.550000>, <2.722842, -41.650000, -6.922720>, <4.417614, -41.650000, -2.572039>, <7.059587, -41.650000, 0.000000>, 
      <-0.300000, -39.000000, -6.800000>, <2.812423, -39.000000, -7.127389>, <4.730553, -39.000000, -2.706112>, <7.249249, -39.000000, 0.000000>, 
      <-0.400000, -33.800000, -7.200000>, <2.874474, -33.800000, -7.459977>, <4.801470, -33.800000, -2.782863>, <7.500000, -33.800000, 0.000000>, 
      <-0.450000, -31.300000, -7.350000>, <2.900438, -31.300000, -7.549520>, <4.821222, -31.300000, -2.760157>, <7.500000, -31.300000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 2 v_steps 2,
      <-0.450000, -31.300000, -7.350000>, <2.900438, -31.300000, -7.549520>, <4.821222, -31.300000, -2.760157>, <7.500000, -31.300000, 0.000000>, 
      <-0.500000, -28.800000, -7.500000>, <2.926402, -28.800000, -7.639063>, <4.840974, -28.800000, -2.737452>, <7.500000, -28.800000, 0.000000>, 
      <-0.500000, -23.800000, -7.400000>, <2.926402, -23.800000, -7.590280>, <4.840974, -23.800000, -2.660701>, <7.400000, -23.800000, 0.000000>, 
      <-0.600000, -21.200000, -7.350000>, <2.881201, -21.200000, -7.578681>, <4.800966, -21.200000, -2.642110>, <7.340570, -21.200000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 2 v_steps 2,
      <-0.600000, -21.200000, -7.350000>, <2.881201, -21.200000, -7.578681>, <4.800966, -21.200000, -2.642110>, <7.340570, -21.200000, 0.000000>, 
      <-0.700000, -18.600000, -7.300000>, <2.836000, -18.600000, -7.567082>, <4.760958, -18.600000, -2.623518>, <7.281140, -18.600000, 0.000000>, 
      <-0.900000, -13.600000, -6.800000>, <2.443132, -13.600000, -7.143759>, <4.362649, -13.600000, -2.546767>, <7.000000, -13.600000, 0.000000>, 
      <-1.000000, -11.700000, -6.400000>, <2.194014, -11.700000, -6.775331>, <4.005742, -11.700000, -2.448264>, <6.650000, -11.700000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 2 v_steps 2,
      <-1.000000, -11.700000, -6.400000>, <2.194014, -11.700000, -6.775331>, <4.005742, -11.700000, -2.448264>, <6.650000, -11.700000, 0.000000>, 
      <-1.100000, -9.800000, -6.000000>, <1.944896, -9.800000, -6.406902>, <3.648835, -9.800000, -2.349761>, <6.300000, -9.800000, 0.000000>, 
      <-1.300000, -6.700000, -5.036103>, <1.391958, -6.700000, -5.786647>, <2.844711, -6.700000, -2.102557>, <4.877271, -6.700000, 0.000000>, 
      <-1.450000, -5.100000, -4.027421>, <1.032107, -5.090983, -4.402314>, <2.072356, -5.100000, -1.760543>, <3.688635, -5.100000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 2 v_steps 2,
      <-1.450000, -5.100000, -4.027421>, <1.032107, -5.090983, -4.402314>, <2.072356, -5.100000, -1.760543>, <3.688635, -5.100000, 0.000000>, 
      <-1.600000, -3.500000, -3.018740>, <0.672256, -3.481965, -3.017980>, <1.300000, -3.500000, -1.418529>, <2.500000, -3.500000, 0.000000>, 
      <-1.619597, -0.300000, 0.000000>, <-0.889530, -0.460134, 0.000000>, <0.396565, -1.124651, 0.000000>, <1.096649, -1.793030, 0.000000>, 
      <-1.619597, 0.000000, 0.000000>, <-0.889530, -0.160134, 0.000000>, <0.195086, -0.845260, -0.018035>, <0.896649, -1.493030, 0.000000>
    }
  }
  rotate <-90.0, 90.0, 0.0>
}
#declare rumpf = union {
  object { hullstar }
  object { kiel }
  object { hullback }
}
#declare relingstar = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 2 v_steps 2,
      <0.200537, -61.958845, 3.894124>, <0.247354, -61.944833, 4.125629>, <0.937384, -61.751874, 4.100000>, <1.729239, -61.548103, 4.000000>, 
      <0.208544, -61.862673, 3.968494>, <0.241134, -61.846276, 4.100000>, <0.909982, -61.655702, 4.100000>, <1.722545, -61.457826, 4.000000>, 
      <0.284337, -60.751206, 4.006175>, <0.304480, -60.800000, 4.200000>, <0.980463, -60.800000, 4.300000>, <1.780463, -60.800000, 4.200000>, 
      <0.373658, -58.851206, 4.093360>, <0.412874, -58.900000, 4.450000>, <1.124244, -58.900000, 4.450000>, <1.880463, -58.881046, 4.400000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 2 v_steps 2,
      <0.373658, -58.851206, 4.093360>, <0.412874, -58.900000, 4.450000>, <1.124244, -58.900000, 4.450000>, <1.880463, -58.881046, 4.400000>, 
      <0.462979, -56.951206, 4.180545>, <0.521267, -57.000000, 4.700000>, <1.268025, -57.000000, 4.600000>, <1.980463, -56.962092, 4.600000>, 
      <0.562979, -53.051206, 4.780545>, <0.621267, -53.100000, 5.000000>, <1.480463, -53.100000, 5.100000>, <2.180463, -53.112438, 5.000000>, 
      <0.612979, -51.051206, 5.030545>, <0.721267, -51.100000, 5.300000>, <1.530463, -51.100000, 5.300000>, <2.230463, -51.096198, 5.300000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 2 v_steps 2,
      <0.612979, -51.051206, 5.030545>, <0.721267, -51.100000, 5.300000>, <1.530463, -51.100000, 5.300000>, <2.230463, -51.096198, 5.300000>, 
      <0.662979, -49.051206, 5.280545>, <0.821267, -49.100000, 5.600000>, <1.580463, -49.100000, 5.500000>, <2.280463, -49.079957, 5.600000>, 
      <0.662979, -44.251206, 5.980545>, <0.821267, -44.300000, 6.300000>, <1.680463, -44.313380, 6.200000>, <2.317011, -44.290282, 6.300000>, 
      <0.662979, -41.601206, 6.230545>, <0.821267, -41.650000, 6.550000>, <1.680463, -41.656690, 6.500000>, <2.298737, -41.645141, 6.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 2 v_steps 2,
      <0.662979, -41.601206, 6.230545>, <0.821267, -41.650000, 6.550000>, <1.680463, -41.656690, 6.500000>, <2.298737, -41.645141, 6.500000>, 
      <0.662979, -38.951206, 6.480545>, <0.821267, -39.000000, 6.800000>, <1.680463, -39.000000, 6.800000>, <2.280463, -39.000000, 6.700000>, 
      <0.662979, -33.751206, 6.880545>, <0.821267, -33.800000, 7.200000>, <1.580463, -33.800000, 7.100000>, <2.256666, -33.828610, 7.200000>, 
      <0.612979, -31.251206, 7.030545>, <0.807506, -31.300000, 7.350000>, <1.530463, -31.300000, 7.300000>, <2.218565, -31.340785, 7.350000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 2 v_steps 2,
      <0.612979, -31.251206, 7.030545>, <0.807506, -31.300000, 7.350000>, <1.530463, -31.300000, 7.300000>, <2.218565, -31.340785, 7.350000>, 
      <0.562979, -28.751206, 7.180545>, <0.793745, -28.800000, 7.500000>, <1.480463, -28.800000, 7.500000>, <2.180463, -28.852961, 7.500000>, 
      <0.562979, -23.751206, 7.080545>, <0.748560, -23.761989, 7.400000>, <1.549082, -23.747039, 7.400000>, <2.180463, -23.800000, 7.400000>, 
      <0.462979, -21.151206, 7.030545>, <0.664251, -21.180995, 7.350000>, <1.468088, -21.173520, 7.350000>, <2.070131, -21.198342, 7.350000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 2 v_steps 2,
      <0.462979, -21.151206, 7.030545>, <0.664251, -21.180995, 7.350000>, <1.468088, -21.173520, 7.350000>, <2.070131, -21.198342, 7.350000>, 
      <0.362979, -18.551206, 6.980545>, <0.579941, -18.600000, 7.300000>, <1.387093, -18.600000, 7.300000>, <1.959800, -18.596685, 7.300000>, 
      <0.262979, -13.551206, 6.480545>, <0.321267, -13.600000, 6.700000>, <1.117097, -13.600000, 6.700000>, <1.780463, -13.600000, 6.800000>, 
      <0.162979, -11.651206, 6.080545>, <0.235783, -11.699505, 6.350000>, <0.967990, -11.716832, 6.400000>, <1.630463, -11.700000, 6.400000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 2 v_steps 2,
      <0.162979, -11.651206, 6.080545>, <0.235783, -11.699505, 6.350000>, <0.967990, -11.716832, 6.400000>, <1.630463, -11.700000, 6.400000>, 
      <0.062979, -9.751206, 5.680545>, <0.150298, -9.799010, 6.000000>, <0.818882, -9.833663, 6.100000>, <1.480463, -9.800000, 6.000000>, 
      <-0.137021, -6.651206, 4.680545>, <-0.064155, -6.676158, 5.000000>, <0.561934, -6.628474, 5.000000>, <1.280463, -6.800000, 5.000000>, 
      <-0.203958, -5.051206, 3.830545>, <-0.119171, -5.073842, 4.100000>, <0.504603, -5.066553, 4.100000>, <1.163527, -5.126158, 4.150000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 2 v_steps 2,
      <-0.203958, -5.051206, 3.830545>, <-0.119171, -5.073842, 4.100000>, <0.504603, -5.066553, 4.100000>, <1.163527, -5.126158, 4.150000>, 
      <-0.270894, -3.451206, 2.980545>, <-0.174186, -3.471526, 3.200000>, <0.447271, -3.504632, 3.200000>, <1.046590, -3.452316, 3.300000>, 
      <-0.619045, 0.567752, 0.054216>, <-0.326513, 0.479841, 0.000000>, <0.314632, 0.111561, 0.000000>, <0.914158, -0.196269, 0.000000>, 
      <-0.629554, 0.669429, 0.054216>, <-0.291032, 0.542732, 0.000000>, <0.302511, 0.236052, 0.000000>, <0.902044, -0.065214, 0.000000>
    }
  }
  rotate <0.0, 90.0, 90.0>
  translate  <0.0, -0.027673, 2.53306>
}
#declare relingback = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 2 v_steps 2,
      <0.200537, -61.958845, -3.894124>, <0.247354, -61.944833, -4.125629>, <0.937384, -61.751874, -4.100000>, <1.729239, -61.548103, -4.000000>, 
      <0.208544, -61.862673, -3.968494>, <0.241134, -61.846276, -4.100000>, <0.909982, -61.655702, -4.100000>, <1.722545, -61.457826, -4.000000>, 
      <0.284337, -60.751206, -4.006175>, <0.304480, -60.800000, -4.200000>, <0.980463, -60.800000, -4.300000>, <1.780463, -60.800000, -4.200000>, 
      <0.373658, -58.851206, -4.093360>, <0.412874, -58.900000, -4.450000>, <1.124244, -58.900000, -4.450000>, <1.880463, -58.881046, -4.400000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 2 v_steps 2,
      <0.373658, -58.851206, -4.093360>, <0.412874, -58.900000, -4.450000>, <1.124244, -58.900000, -4.450000>, <1.880463, -58.881046, -4.400000>, 
      <0.462979, -56.951206, -4.180545>, <0.521267, -57.000000, -4.700000>, <1.268025, -57.000000, -4.600000>, <1.980463, -56.962092, -4.600000>, 
      <0.562979, -53.051206, -4.780545>, <0.621267, -53.100000, -5.000000>, <1.480463, -53.100000, -5.100000>, <2.180463, -53.112438, -5.000000>, 
      <0.612979, -51.051206, -5.030545>, <0.721267, -51.100000, -5.300000>, <1.530463, -51.100000, -5.300000>, <2.230463, -51.096198, -5.300000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 2 v_steps 2,
      <0.612979, -51.051206, -5.030545>, <0.721267, -51.100000, -5.300000>, <1.530463, -51.100000, -5.300000>, <2.230463, -51.096198, -5.300000>, 
      <0.662979, -49.051206, -5.280545>, <0.821267, -49.100000, -5.600000>, <1.580463, -49.100000, -5.500000>, <2.280463, -49.079957, -5.600000>, 
      <0.662979, -44.251206, -5.980545>, <0.821267, -44.300000, -6.300000>, <1.680463, -44.313380, -6.200000>, <2.317011, -44.290282, -6.300000>, 
      <0.662979, -41.601206, -6.230545>, <0.821267, -41.650000, -6.550000>, <1.680463, -41.656690, -6.500000>, <2.298737, -41.645141, -6.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 2 v_steps 2,
      <0.662979, -41.601206, -6.230545>, <0.821267, -41.650000, -6.550000>, <1.680463, -41.656690, -6.500000>, <2.298737, -41.645141, -6.500000>, 
      <0.662979, -38.951206, -6.480545>, <0.821267, -39.000000, -6.800000>, <1.680463, -39.000000, -6.800000>, <2.280463, -39.000000, -6.700000>, 
      <0.662979, -33.751206, -6.880545>, <0.821267, -33.800000, -7.200000>, <1.580463, -33.800000, -7.100000>, <2.256666, -33.828610, -7.200000>, 
      <0.612979, -31.251206, -7.030545>, <0.807506, -31.300000, -7.350000>, <1.530463, -31.300000, -7.300000>, <2.218565, -31.340785, -7.350000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 2 v_steps 2,
      <0.612979, -31.251206, -7.030545>, <0.807506, -31.300000, -7.350000>, <1.530463, -31.300000, -7.300000>, <2.218565, -31.340785, -7.350000>, 
      <0.562979, -28.751206, -7.180545>, <0.793745, -28.800000, -7.500000>, <1.480463, -28.800000, -7.500000>, <2.180463, -28.852961, -7.500000>, 
      <0.562979, -23.751206, -7.080545>, <0.748560, -23.761989, -7.400000>, <1.549082, -23.747039, -7.400000>, <2.180463, -23.800000, -7.400000>, 
      <0.462979, -21.151206, -7.030545>, <0.664251, -21.180995, -7.350000>, <1.468088, -21.173520, -7.350000>, <2.070131, -21.198342, -7.350000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 2 v_steps 2,
      <0.462979, -21.151206, -7.030545>, <0.664251, -21.180995, -7.350000>, <1.468088, -21.173520, -7.350000>, <2.070131, -21.198342, -7.350000>, 
      <0.362979, -18.551206, -6.980545>, <0.579941, -18.600000, -7.300000>, <1.387093, -18.600000, -7.300000>, <1.959800, -18.596685, -7.300000>, 
      <0.262979, -13.551206, -6.480545>, <0.321267, -13.600000, -6.700000>, <1.117097, -13.600000, -6.700000>, <1.780463, -13.600000, -6.800000>, 
      <0.162979, -11.651206, -6.080545>, <0.235783, -11.699505, -6.350000>, <0.967990, -11.716832, -6.400000>, <1.630463, -11.700000, -6.400000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 2 v_steps 2,
      <0.162979, -11.651206, -6.080545>, <0.235783, -11.699505, -6.350000>, <0.967990, -11.716832, -6.400000>, <1.630463, -11.700000, -6.400000>, 
      <0.062979, -9.751206, -5.680545>, <0.150298, -9.799010, -6.000000>, <0.818882, -9.833663, -6.100000>, <1.480463, -9.800000, -6.000000>, 
      <-0.137021, -6.651206, -4.680545>, <-0.064155, -6.676158, -5.000000>, <0.561934, -6.628474, -5.000000>, <1.280463, -6.800000, -5.000000>, 
      <-0.203958, -5.051206, -3.830545>, <-0.119171, -5.073842, -4.100000>, <0.504603, -5.066553, -4.100000>, <1.163527, -5.126158, -4.150000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 2 v_steps 2,
      <-0.203958, -5.051206, -3.830545>, <-0.119171, -5.073842, -4.100000>, <0.504603, -5.066553, -4.100000>, <1.163527, -5.126158, -4.150000>, 
      <-0.270894, -3.451206, -2.980545>, <-0.174186, -3.471526, -3.200000>, <0.447271, -3.504632, -3.200000>, <1.046590, -3.452316, -3.300000>, 
      <-0.619045, 0.567752, -0.054216>, <-0.326513, 0.479841, 0.000000>, <0.314632, 0.111561, 0.000000>, <0.914158, -0.196269, 0.000000>, 
      <-0.629554, 0.669429, -0.054216>, <-0.291032, 0.542732, 0.000000>, <0.302511, 0.236052, 0.000000>, <0.902044, -0.065214, 0.000000>
    }
  }
  rotate <-90.0, 90.0, 0.0>
  translate  <0.0, -0.027673, 2.53306>
}
#declare achterreling = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  11  // control points
  <-1.0, -0.146476>,
  <-0.5, -0.00054>,
  <-0.0, 0.043607>,
  <0.5, -0.00054>,
  <1.0, -0.146476>,
  <1.0, 0.068229>,
  <0.5, 0.182866>,
  <0.0, 0.195714>,
  <-0.5, 0.182866>,
  <-1.0, 0.068229>,
  <-1.0, -0.146476>
  rotate -x*90
  material {
    woodMskinMmed
  }
  scale <4.0576, 3.869492, 0.330031>
  rotate <4.92815, 0.0, -90.0>
  translate  <61.690869, -0.033235, 2.161207>
}
#declare reling = union {
  object { relingstar }
  object { relingback }
  box { // Cube069
    <-1, -1, -1>, <1, 1, 1>
    material {
      brownMmed
    }
    scale <1.057348, 0.202365, 0.361569>
    translate  <60.477528, -2.22673, 0.824671>
  }
  box { // Cube068
    <-1, -1, -1>, <1, 1, 1>
    material {
      brownMmed
    }
    scale <1.057348, 0.202365, 0.361569>
    translate  <60.477528, 2.193495, 0.824671>
  }
  box { // Cube067
    <-1, -1, -1>, <1, 1, 1>
    material {
      brownMmed
    }
    scale <-0.196452, -3.259965, -0.232203>
    rotate <-180.0, 11.634807, 0.0>
    translate  <61.814064, 0.0, 1.194351>
  }
  object { achterreling }
  box { // david1
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMmed
    }
    scale <-1.943235, -0.205476, -0.114938>
    rotate <-179.906906, 6.726823, -172.582458>
    translate  <62.094969, -3.799198, 2.437046>
  }
  box { // david
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMmed
    }
    scale <-1.943235, -0.205476, -0.114938>
    rotate <-179.906906, 6.726823, 172.582458>
    translate  <62.094969, 3.676375, 2.437046>
  }
  material {
    pMskinMcomlxM02
  }
}
// Include contains 'heckstar'
#include "balt.in2"

#declare heckstar = object {
  heckstar_Raw
  scale <1.0, 1.0, 0.2>
  rotate <77.026558, -0.0, -90.0>
  translate  <61.500977, 0.0, 0.002996>
}
// Include contains 'heckback'
#include "balt.in3"

#declare heckback = object {
  heckback_Raw
  scale <1.0, 1.0, 0.2>
  rotate <77.026558, -0.0, -90.0>
  translate  <61.500977, 0.0, 0.002996>
}
#declare heck = union {
  object { heckstar }
  object { heckback }
}
#declare deckback = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 2 v_steps 2,
      <-0.819495, -61.505908, -3.940596>, <-0.782111, -61.461241, -3.679827>, <-0.810106, -61.459255, -1.377488>, <-0.847506, -61.431400, -0.030628>, 
      <-0.816247, -61.442572, -4.004250>, <-0.779409, -61.441548, -3.679827>, <-0.801444, -61.408912, -1.377488>, <-0.855710, -61.406336, -0.030628>, 
      <-0.783751, -60.702810, -4.202801>, <-0.771331, -60.700183, -4.828237>, <-0.766843, -60.691603, -1.513039>, <-0.821742, -60.702810, 0.000000>, 
      <-0.689652, -58.851405, -4.371403>, <-0.677843, -58.862256, -5.055607>, <-0.670658, -58.845801, -1.569815>, <-0.731995, -58.851405, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 2 v_steps 2,
      <-0.689652, -58.851405, -4.371403>, <-0.677843, -58.862256, -5.055607>, <-0.670658, -58.845801, -1.569815>, <-0.731995, -58.851405, 0.000000>, 
      <-0.595554, -57.000000, -4.540005>, <-0.584354, -57.024329, -5.282978>, <-0.574473, -57.000000, -1.626591>, <-0.642247, -57.000000, 0.000000>, 
      <-0.300000, -53.100000, -5.056181>, <-0.330719, -53.100000, -5.822623>, <-0.783291, -53.216253, -1.806035>, <-0.871052, -53.187190, 0.000000>, 
      <-0.300000, -51.050000, -5.328090>, <-0.317893, -51.050000, -6.027292>, <-0.750783, -51.151721, -1.951948>, <-0.878654, -51.093595, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 2 v_steps 2,
      <-0.300000, -51.050000, -5.328090>, <-0.317893, -51.050000, -6.027292>, <-0.750783, -51.151721, -1.951948>, <-0.878654, -51.093595, 0.000000>, 
      <-0.300000, -49.000000, -5.600000>, <-0.305066, -49.000000, -6.231961>, <-0.718274, -49.087190, -2.097861>, <-0.886257, -49.000000, 0.000000>, 
      <-0.300000, -44.300000, -6.300000>, <-0.273067, -44.300000, -6.718051>, <-0.698231, -44.300000, -2.437967>, <-0.902698, -44.300000, 0.000000>, 
      <-0.300000, -41.650000, -6.550000>, <-0.285207, -41.664532, -6.922720>, <-0.704989, -41.693595, -2.572039>, <-0.886222, -41.700264, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 2 v_steps 2,
      <-0.300000, -41.650000, -6.550000>, <-0.285207, -41.664532, -6.922720>, <-0.704989, -41.693595, -2.572039>, <-0.886222, -41.700264, 0.000000>, 
      <-0.300000, -39.000000, -6.800000>, <-0.297346, -39.029063, -7.127389>, <-0.711746, -39.087190, -2.706112>, <-0.869747, -39.100529, 0.000000>, 
      <-0.400000, -33.800000, -7.200000>, <-0.409675, -33.800000, -7.459977>, <-0.783759, -33.770937, -2.782863>, <-0.999204, -33.800000, 0.000000>, 
      <-0.450000, -31.300000, -7.350000>, <-0.441838, -31.285468, -7.549520>, <-0.866922, -31.314532, -2.760157>, <-1.034937, -31.314532, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 2 v_steps 2,
      <-0.450000, -31.300000, -7.350000>, <-0.441838, -31.285468, -7.549520>, <-0.866922, -31.314532, -2.760157>, <-1.034937, -31.314532, 0.000000>, 
      <-0.500000, -28.800000, -7.500000>, <-0.474001, -28.770937, -7.639063>, <-0.950084, -28.858127, -2.737452>, <-1.070669, -28.829063, 0.000000>, 
      <-0.500000, -23.800000, -7.400000>, <-0.551452, -23.800000, -7.590280>, <-0.853144, -23.743906, -2.660701>, <-1.098890, -23.519528, 0.000000>, 
      <-0.600000, -21.200000, -7.350000>, <-0.582568, -21.200000, -7.578681>, <-0.904166, -21.171953, -2.642110>, <-1.177250, -21.025267, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 2 v_steps 2,
      <-0.600000, -21.200000, -7.350000>, <-0.582568, -21.200000, -7.578681>, <-0.904166, -21.171953, -2.642110>, <-1.177250, -21.025267, 0.000000>, 
      <-0.700000, -18.600000, -7.300000>, <-0.613684, -18.600000, -7.567082>, <-0.955188, -18.600000, -2.623518>, <-1.255609, -18.531006, 0.000000>, 
      <-0.900000, -13.600000, -6.800000>, <-0.883349, -13.600000, -7.143759>, <-1.218520, -13.520798, -2.546767>, <-1.464049, -13.600000, 0.000000>, 
      <-1.000000, -11.700000, -6.400000>, <-1.013664, -11.700000, -6.775331>, <-1.382609, -11.660399, -2.448264>, <-1.616044, -11.700000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 2 v_steps 2,
      <-1.000000, -11.700000, -6.400000>, <-1.013664, -11.700000, -6.775331>, <-1.382609, -11.660399, -2.448264>, <-1.616044, -11.700000, 0.000000>, 
      <-1.100000, -9.800000, -6.000000>, <-1.143980, -9.800000, -6.406902>, <-1.546697, -9.800000, -2.349761>, <-1.768040, -9.800000, 0.000000>, 
      <-1.409827, -6.700000, -5.036103>, <-1.408623, -6.700000, -5.786647>, <-1.383616, -6.700000, -2.102557>, <-1.916332, -6.700000, 0.000000>, 
      <-1.504913, -5.100000, -4.027421>, <-1.493907, -5.118439, -4.402314>, <-1.497011, -5.100000, -1.760543>, <-2.056552, -5.100000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 2 v_steps 2,
      <-1.504913, -5.100000, -4.027421>, <-1.493907, -5.118439, -4.402314>, <-1.497011, -5.100000, -1.760543>, <-2.056552, -5.100000, 0.000000>, 
      <-1.600000, -3.500000, -3.018740>, <-1.579191, -3.536879, -3.017980>, <-1.610407, -3.500000, -1.418529>, <-2.196771, -3.500000, 0.000000>, 
      <-2.332231, -0.300000, 0.000000>, <-2.322601, -0.377799, 0.000000>, <-2.312710, -0.939396, 0.000000>, <-2.312480, -1.648943, 0.000000>, 
      <-2.332231, 0.000000, 0.000000>, <-2.302017, 0.004537, 0.000000>, <-2.308349, -0.536501, -0.018035>, <-2.327224, -1.287191, 0.000000>
    }
  }
  rotate <-90.0, 90.0, 0.0>
  translate  -0.0*z
}
#declare deckstar = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 2 v_steps 2,
      <-0.819495, -61.505908, 3.940596>, <-0.782111, -61.461241, 3.679827>, <-0.810106, -61.459255, 1.377488>, <-0.847506, -61.431400, 0.030628>, 
      <-0.816247, -61.442572, 4.004250>, <-0.779409, -61.441548, 3.679827>, <-0.801444, -61.408912, 1.377488>, <-0.855710, -61.406336, 0.030628>, 
      <-0.783751, -60.702810, 4.202801>, <-0.771331, -60.700183, 4.828237>, <-0.766843, -60.691603, 1.513039>, <-0.821742, -60.702810, 0.000000>, 
      <-0.689652, -58.851405, 4.371403>, <-0.677843, -58.862256, 5.055607>, <-0.670658, -58.845801, 1.569815>, <-0.731995, -58.851405, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 2 v_steps 2,
      <-0.689652, -58.851405, 4.371403>, <-0.677843, -58.862256, 5.055607>, <-0.670658, -58.845801, 1.569815>, <-0.731995, -58.851405, 0.000000>, 
      <-0.595554, -57.000000, 4.540005>, <-0.584354, -57.024329, 5.282978>, <-0.574473, -57.000000, 1.626591>, <-0.642247, -57.000000, 0.000000>, 
      <-0.300000, -53.100000, 5.056181>, <-0.330719, -53.100000, 5.822623>, <-0.783291, -53.216253, 1.806035>, <-0.871052, -53.187190, 0.000000>, 
      <-0.300000, -51.050000, 5.328090>, <-0.317893, -51.050000, 6.027292>, <-0.750783, -51.151721, 1.951948>, <-0.878654, -51.093595, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 2 v_steps 2,
      <-0.300000, -51.050000, 5.328090>, <-0.317893, -51.050000, 6.027292>, <-0.750783, -51.151721, 1.951948>, <-0.878654, -51.093595, 0.000000>, 
      <-0.300000, -49.000000, 5.600000>, <-0.305066, -49.000000, 6.231961>, <-0.718274, -49.087190, 2.097861>, <-0.886257, -49.000000, 0.000000>, 
      <-0.300000, -44.300000, 6.300000>, <-0.273067, -44.300000, 6.718051>, <-0.698231, -44.300000, 2.437967>, <-0.902698, -44.300000, 0.000000>, 
      <-0.300000, -41.650000, 6.550000>, <-0.285207, -41.664532, 6.922720>, <-0.704989, -41.693595, 2.572039>, <-0.886222, -41.700264, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 2 v_steps 2,
      <-0.300000, -41.650000, 6.550000>, <-0.285207, -41.664532, 6.922720>, <-0.704989, -41.693595, 2.572039>, <-0.886222, -41.700264, 0.000000>, 
      <-0.300000, -39.000000, 6.800000>, <-0.297346, -39.029063, 7.127389>, <-0.711746, -39.087190, 2.706112>, <-0.869747, -39.100529, 0.000000>, 
      <-0.400000, -33.800000, 7.200000>, <-0.409675, -33.800000, 7.459977>, <-0.783759, -33.770937, 2.782863>, <-0.999204, -33.800000, 0.000000>, 
      <-0.450000, -31.300000, 7.350000>, <-0.441838, -31.285468, 7.549520>, <-0.866922, -31.314532, 2.760157>, <-1.034937, -31.314532, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 2 v_steps 2,
      <-0.450000, -31.300000, 7.350000>, <-0.441838, -31.285468, 7.549520>, <-0.866922, -31.314532, 2.760157>, <-1.034937, -31.314532, 0.000000>, 
      <-0.500000, -28.800000, 7.500000>, <-0.474001, -28.770937, 7.639063>, <-0.950084, -28.858127, 2.737452>, <-1.070669, -28.829063, 0.000000>, 
      <-0.500000, -23.800000, 7.400000>, <-0.551452, -23.800000, 7.590280>, <-0.853144, -23.743906, 2.660701>, <-1.098890, -23.519528, 0.000000>, 
      <-0.600000, -21.200000, 7.350000>, <-0.582568, -21.200000, 7.578681>, <-0.904166, -21.171953, 2.642110>, <-1.177250, -21.025267, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 2 v_steps 2,
      <-0.600000, -21.200000, 7.350000>, <-0.582568, -21.200000, 7.578681>, <-0.904166, -21.171953, 2.642110>, <-1.177250, -21.025267, 0.000000>, 
      <-0.700000, -18.600000, 7.300000>, <-0.613684, -18.600000, 7.567082>, <-0.955188, -18.600000, 2.623518>, <-1.255609, -18.531006, 0.000000>, 
      <-0.900000, -13.600000, 6.800000>, <-0.883349, -13.600000, 7.143759>, <-1.218520, -13.520798, 2.546767>, <-1.464049, -13.600000, 0.000000>, 
      <-1.000000, -11.700000, 6.400000>, <-1.013664, -11.700000, 6.775331>, <-1.382609, -11.660399, 2.448264>, <-1.616044, -11.700000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 2 v_steps 2,
      <-1.000000, -11.700000, 6.400000>, <-1.013664, -11.700000, 6.775331>, <-1.382609, -11.660399, 2.448264>, <-1.616044, -11.700000, 0.000000>, 
      <-1.100000, -9.800000, 6.000000>, <-1.143980, -9.800000, 6.406902>, <-1.546697, -9.800000, 2.349761>, <-1.768040, -9.800000, 0.000000>, 
      <-1.409827, -6.700000, 5.036103>, <-1.408623, -6.700000, 5.786647>, <-1.383616, -6.700000, 2.102557>, <-1.916332, -6.700000, 0.000000>, 
      <-1.504913, -5.100000, 4.027421>, <-1.493907, -5.118439, 4.402314>, <-1.497011, -5.100000, 1.760543>, <-2.056552, -5.100000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 2 v_steps 2,
      <-1.504913, -5.100000, 4.027421>, <-1.493907, -5.118439, 4.402314>, <-1.497011, -5.100000, 1.760543>, <-2.056552, -5.100000, 0.000000>, 
      <-1.600000, -3.500000, 3.018740>, <-1.579191, -3.536879, 3.017980>, <-1.610407, -3.500000, 1.418529>, <-2.196771, -3.500000, 0.000000>, 
      <-2.332231, -0.300000, 0.000000>, <-2.322601, -0.377799, 0.000000>, <-2.312710, -0.939396, 0.000000>, <-2.312480, -1.648943, 0.000000>, 
      <-2.332231, 0.000000, 0.000000>, <-2.302017, 0.004537, 0.000000>, <-2.308349, -0.536501, 0.018035>, <-2.327224, -1.287191, 0.000000>
    }
  }
  rotate <-90.0, 90.0, 0.0>
  translate  -0.0*z
}
#declare CSG002 = difference {
  box { // Cube006
    <-1, -1, -1>, <1, 1, 1>
    material {
      plankMskinM02
    }
    scale <1.0, 1.0, 0.5>
  }
  box { // Cube007
    <-1, -1, -1>, <1, 1, 1>
    material {
      plankMskinM02
    }
    scale <0.878667, 0.777556, 0.598565>
  }
}
#declare gitterluke1 = union {
  object { CSG002 }
  box { // Cube008
    <-1, -1, -1>, <1, 1, 1>
    material {
      gridMskin
    }
    scale <0.878667, 0.777556, 0.3>
  }
  scale <2.357087, 2.454021, 1.0>
  rotate 0.5*y
  translate  <32.589453, 0.0, 0.818976>
}
#declare CSG001 = difference {
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    material {
      plankMskinM02
    }
    scale <1.0, 1.0, 0.5>
  }
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    material {
      plankMskinM02
    }
    scale <0.878667, 0.777556, 0.598565>
  }
}
#declare gitterluke = union {
  object { CSG001 }
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    material {
      gridMskin
    }
    scale <0.878667, 0.777556, 0.3>
  }
  scale <2.357087, 2.454021, 1.0>
  rotate 0.5*y
  translate  <22.42995, 0.0, 0.982889>
}
#declare winch = union {
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 
    material {
      woodMskinMmed
    }
    scale <3.178298, 1.684608, 1.0>
    rotate -90.0*y
    translate  <9.728286, 0.995794, -1.431453>
  }
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1 
    material {
      woodMskinMmed
    }
    scale <3.178298, 1.684608, 1.0>
    rotate -90.0*y
    translate  <0.467706, 0.995794, -1.431453>
  }
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    material {
      metalMskinMmed
    }
    scale <2.0, 2.0, 3.0>
    rotate -90.0*y
    translate  <-1.403118, 0.0, 1.122494>
  }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    material {
      metalMskinMmed
    }
    scale <2.0, 2.0, 3.0>
    rotate -90.0*y
    translate  <13.657016, 0.0, 1.122494>
  }
  box { // Cube013
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMmed
    }
    scale <0.5, 3.764366, 2.012034>
    rotate -15.651586*x
    translate  <9.260579, 3.049618, -3.734226>
  }
  box { // Cube012
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMmed
    }
    scale <0.5, 3.764366, 2.012034>
    rotate -15.651586*x
    translate  <0.0, 3.049618, -3.734226>
  }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    material {
      metalMskinMmed
    }
    scale <0.4, 0.4, 20.0>
    rotate -90.0*y
    translate  <14.498887, 0.0, 1.122494>
  }
  box { // Cube011
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMmed
    }
    scale <6.799555, 1.0, 0.625835>
    translate  <4.67706, -0.933556, 4.676689>
  }
  box { // Cube010
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMmed
    }
    scale <0.83703, 1.0, 4.666815>
    translate  <9.167038, 0.0, 1.140787>
  }
  box { // Cube009
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMmed
    }
    scale <0.83703, 1.0, 4.666815>
    translate  1.140787*z
  }
  scale <0.25, 0.25, 0.225931>
  rotate <0.5, -0.0, 90.0>
  translate  <7.971985, -1.117053, 2.458252>
}
#declare mastrail1 = union {
  box { // Cube022
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMmed
    }
    scale <7.388515, 1.131722, 0.485494>
    rotate -90.0*z
    translate  <-5.230679, -0.065861, 3.454542>
  }
  box { // Cube023
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMmed
    }
    scale <5.544408, 0.934139, 0.485494>
    translate  <0.894392, -4.67613, 3.454542>
  }
  box { // Cube024
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMmed
    }
    scale <5.544408, 0.934139, 0.485494>
    translate  <0.894392, 5.137157, 3.454542>
  }
  box { // Cube025
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMmed
    }
    scale <0.903881, 0.934139, 2.0>
    translate  <5.524416, 5.103224, 0.981805>
  }
  box { // Cube026
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMmed
    }
    scale <0.903881, 0.934139, 2.0>
    translate  <5.524416, -4.701078, 0.956856>
  }
  box { // Cube027
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMmed
    }
    scale <0.903881, 0.934139, 3.844526>
    translate  <-4.420592, -4.741991, 2.793034>
  }
  box { // Cube028
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMmed
    }
    scale <0.903881, 0.934139, 3.844526>
    translate  <-4.420592, 5.071296, 2.793034>
  }
  box { // Cube029
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMmed
    }
    scale <2.646525, 2.514803, 1.0>
  }
  scale <-0.356, -0.356, -0.219143>
  rotate <-180.0, -0.5, -180.0>
  translate  <38.430415, 0.0, 0.986003>
}
#declare mastrail = union {
  box { // Cube021
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMmed
    }
    scale <7.388515, 1.131722, 0.485494>
    rotate -90.0*z
    translate  <-5.230679, -0.065861, 3.454542>
  }
  box { // Cube020
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMmed
    }
    scale <5.544408, 0.934139, 0.485494>
    translate  <0.894392, -4.67613, 3.454542>
  }
  box { // Cube016
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMmed
    }
    scale <5.544408, 0.934139, 0.485494>
    translate  <0.894392, 5.137157, 3.454542>
  }
  box { // Cube019
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMmed
    }
    scale <0.903881, 0.934139, 2.0>
    translate  <5.524416, 5.103224, 0.981805>
  }
  box { // Cube018
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMmed
    }
    scale <0.903881, 0.934139, 2.0>
    translate  <5.524416, -4.701078, 0.956856>
  }
  box { // Cube017
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMmed
    }
    scale <0.903881, 0.934139, 3.844526>
    translate  <-4.420592, -4.741991, 2.793034>
  }
  box { // Cube015
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMmed
    }
    scale <0.903881, 0.934139, 3.844526>
    translate  <-4.420592, 5.071296, 2.793034>
  }
  box { // Cube014
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMmed
    }
    scale <2.646525, 2.514803, 1.0>
  }
  scale <-0.33, -0.33, -0.203138>
  rotate <-180.0, -0.5, -180.0>
  translate  <16.075171, 0.0, 1.307132>
}
#declare aufgang1 = union {
  box { // Cube033
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMbright
    }
    scale <0.451291, 0.698399, 1.174589>
    translate  <0.648474, 0.0, 0.972711>
  }
  box { // Cube034
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMmed
    }
    scale <1.2, 1.2, 0.2>
    rotate -7.467126*y
    translate  <-0.024941, 0.0, 2.519072>
  }
  box { // Cube035
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMmed
    }
    scale <1.0, 1.0, 1.5>
    translate  0.989216*z
  }
  scale <0.642333, 0.701357, 0.771181>
  rotate <0.463467, 0.187613, 67.962204>
  translate  <8.179666, -4.265576, 1.574992>
}
#declare aufgang = union {
  box { // Cube032
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMbright
    }
    scale <0.451291, 0.698399, 1.174589>
    translate  <0.648474, 0.0, 0.972711>
  }
  box { // Cube031
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMmed
    }
    scale <1.2, 1.2, 0.2>
    rotate -7.467126*y
    translate  <-0.024941, 0.0, 2.519072>
  }
  box { // Cube030
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMmed
    }
    scale <1.0, 1.0, 1.5>
    translate  0.989216*z
  }
  scale <0.642333, 0.701357, 0.771181>
  rotate <-0.463467, 0.187613, -67.962204>
  translate  <8.179666, 4.400155, 1.574992>
}
#declare lukeMbig = union {
  box { // Cube039
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMbright
    }
    scale <0.239111, 0.886222, 0.808>
    translate  <-0.078222, 0.0, 0.383826>
  }
  box { // Cube040
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMbright
    }
    scale <0.239111, 0.886222, 0.808>
    translate  <-0.689274, 0.0, 0.383826>
  }
  box { // Cube041
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMmed
    }
    scale <1.881408, 1.0, 1.0>
    translate  -0.397719*x
  }
  box { // Cube045
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMbright
    }
    scale <0.239111, 0.886222, 0.808>
    translate  <-1.894998, 0.0, 0.383826>
  }
  box { // Cube044
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMbright
    }
    scale <0.239111, 0.886222, 0.808>
    translate  <-1.284317, 0.0, 0.383826>
  }
  box { // Cube043
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMbright
    }
    scale <0.239111, 0.886222, 0.808>
    translate  <1.148592, 0.0, 0.383826>
  }
  box { // Cube042
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMbright
    }
    scale <0.239111, 0.886222, 0.808>
    translate  <0.527941, 0.0, 0.383826>
  }
  box { // Cube052
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMbright
    }
    scale <0.239111, 0.886222, 0.808>
    translate  <0.527941, 1.822696, 0.383826>
  }
  box { // Cube051
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMbright
    }
    scale <0.239111, 0.886222, 0.808>
    translate  <1.148592, 1.822696, 0.383826>
  }
  box { // Cube050
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMbright
    }
    scale <0.239111, 0.886222, 0.808>
    translate  <-1.284317, 1.822696, 0.383826>
  }
  box { // Cube049
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMbright
    }
    scale <0.239111, 0.886222, 0.808>
    translate  <-1.894998, 1.822696, 0.383826>
  }
  box { // Cube048
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMmed
    }
    scale <1.881408, 1.0, 1.0>
    translate  <-0.397719, 1.822696, 0.0>
  }
  box { // Cube047
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMbright
    }
    scale <0.239111, 0.886222, 0.808>
    translate  <-0.689274, 1.822696, 0.383826>
  }
  box { // Cube046
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMbright
    }
    scale <0.239111, 0.886222, 0.808>
    translate  <-0.078222, 1.822696, 0.383826>
  }
  rotate 0.5*y
  translate  <50.871308, -0.893822, 0.068404>
}
#declare lukeMsmall = union {
  box { // Cube038
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMbright
    }
    scale <0.239111, 0.886222, 0.808>
    translate  <-0.078222, 0.0, 0.383826>
  }
  box { // Cube037
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMbright
    }
    scale <0.239111, 0.886222, 0.808>
    translate  <-0.654222, 0.0, 0.383826>
  }
  box { // Cube036
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMmed
    }
    scale <0.651556, 1.0, 1.0>
    translate  -0.362667*x
  }
  scale <1.44698, 1.357584, 1.0>
  rotate 3.686009*y
  translate  <11.944374, 0.0, 0.839927>
}
#declare CSG004 = difference {
  sphere { // Sphere002
    <0,0,0>,1
    material {
      woodMskinMbright
    }
    scale <1.0, 1.0, 2.0>
  }
  box { // Cube055
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMmed
    }
    scale <1.19158, 1.19158, 0.659414>
    translate  1.788077*z
  }
  box { // Cube056
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMmed
    }
    scale <1.19158, 1.19158, 0.659414>
    translate  <0.0, 0.021287, -1.83065>
  }
}
#declare fass1 = union {
  torus { // Torus003
    1.95, 0.05  rotate -x*90
    material {
      metalMskinMmed
    }
    scale <0.488, 0.488, 2.0>
    translate  -0.596026*z
  }
  torus { // Torus004
    1.95, 0.05  rotate -x*90
    material {
      metalMskinMmed
    }
    scale <0.488, 0.488, 2.0>
    translate  0.596026*z
  }
  object { CSG004 }
  scale <1.0, 1.0, 1.404446>
  rotate 90.0*x
  translate  2.243705*x
}
#declare CSG003 = difference {
  sphere { // Sphere001
    <0,0,0>,1
    material {
      woodMskinMbright
    }
    scale <1.0, 1.0, 2.0>
  }
  box { // Cube053
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMmed
    }
    scale <1.19158, 1.19158, 0.659414>
    translate  1.788077*z
  }
  box { // Cube054
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMmed
    }
    scale <1.19158, 1.19158, 0.659414>
    translate  <0.0, 0.021287, -1.83065>
  }
}
#declare fass = union {
  torus { // Torus002
    1.95, 0.05  rotate -x*90
    material {
      metalMskinMmed
    }
    scale <0.488, 0.488, 2.0>
    translate  -0.596026*z
  }
  torus { // Torus001
    1.95, 0.05  rotate -x*90
    material {
      metalMskinMmed
    }
    scale <0.488, 0.488, 2.0>
    translate  0.596026*z
  }
  object { CSG003 }
  scale <1.0, 1.0, 1.404446>
  rotate 90.0*x
}
#declare fassMgroup = union {
  box { // Cube058
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMmed
    }
    scale <2.750583, 0.235661, 0.552981>
    translate  <1.035556, -1.151297, -0.830179>
  }
  box { // Cube057
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMmed
    }
    scale <2.750583, 0.235661, 0.552981>
    translate  <1.035556, 1.232805, -0.830179>
  }
  object { fass1 }
  object { fass }
  scale 0.8
  rotate <-0.5, -0.0, -90.0>
  translate  <27.487454, 0.779928, 1.713736>
}
#declare spill = union {
  cylinder { // Cylndr009
    <0,0,1>, <0,0,0>, 1 
    material {
      woodMskinMmed
    }
    scale <1.5, 1.5, 0.5>
    translate  2.311112*z
  }
  sphere { // Sphere003
    <0,0,0>,1
    material {
      woodMskinMmed
    }
    scale <1.0, 1.0, 0.5>
    translate  3.723458*z
  }
  cylinder { // Cylndr008
    <0,0,1>, <0,0,0>, 1 
    material {
      woodMskinMmed
    }
    scale <1.5, 1.5, 0.5>
    translate  3.209878*z
  }
  cylinder { // Cylndr007
    <0,0,1>, <0,0,0>, 1 
    material {
      woodMskinMmed
    }
    scale <1.5, 1.5, 0.5>
  }
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1 
    material {
      woodMskinMmed
    }
    scale <1.0, 1.0, 3.0>
    translate  0.385185*z
  }
  material {
    woodMskinMmed
  }
  scale <0.506132, 0.506132, 0.50557>
  rotate 0.5*y
  translate  <47.406187, 0.0, 0.475399>
}
#declare cabin = union {
  box { // Cube064
    <-1, -1, -1>, <1, 1, 1>
    material {
      plankMskinM01
    }
    scale <1.904278, 1.003886, 0.130103>
    rotate 23.573429*x
    translate  <0.0, -0.869897, 1.203358>
  }
  box { // Cube063
    <-1, -1, -1>, <1, 1, 1>
    material {
      plankMskinM01
    }
    scale <1.904278, 1.003886, 0.130103>
    rotate -23.573429*x
    translate  <0.0, 0.869897, 1.203358>
  }
  box { // Cube062
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMmed
    }
    scale <0.506758, 1.378152, 0.403052>
    translate  <-2.208707, 0.0, -0.596948>
  }
  box { // Cube061
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMmed
    }
    scale <0.671172, 1.098648, 0.149349>
    rotate -9.269251*y
    translate  <2.208707, 0.0, 1.910233>
  }
  box { // Cube060
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMmed
    }
    scale <0.506504, 0.967117, 1.462635>
    translate  <2.235778, 0.016441, 0.492482>
  }
  box { // Cube059
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMmed
    }
    scale <1.730437, 1.533773, 0.971003>
  }
  scale <0.916055, 1.0, 0.651568>
  rotate 0.5*y
  translate  <43.467536, 0.0, 1.317278>
}
#declare compasshut = union {
  box { // Cube066
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMmed
    }
    scale <1.156551, 2.000326, 0.220478>
    rotate -4.531462*y
    translate  <-0.0, 0.0, 1.125977>
  }
  box { // Cube065
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMmed
    }
    scale <0.943378, 1.830459, 1.187663>
  }
  scale <0.534367, 0.746019, 1.0>
  rotate 0.5*y
  translate  <53.426588, 0.0, 1.312564>
}
#declare ruderpinne = union {
  cylinder { // Cylndr012
    <0,0,1>, <0,0,0>, 1 
    material {
      woodMskinMmed
    }
    scale <0.5, 0.5, 5.0>
    rotate 27.239052*y
    translate  <-1.258892, 0.0, -3.04681>
  }
  cylinder { // Cylndr011
    <0,0,1>, <0,0,0>, 1 
    material {
      woodMskinMmed
    }
    scale <1.973045, 0.741763, 0.7>
    translate  <-0.082957, 0.0, 0.174227>
  }
  cylinder { // Cylndr010
    <0,0,1>, <0,0,0>, 1 
    material {
      woodMskinMmed
    }
    scale <0.3, 0.2, 10.0>
    rotate <-0.0, -79.474449, -0.0>
    translate  0.459847*z
  }
  scale <0.520241, 0.619275, 0.619275>
  rotate 0.5*y
  translate  <60.377791, 0.0, 1.213294>
}
#declare CSG006 = difference {
  torus { // Torus008
    1.85, 0.15  rotate -x*90
    scale <1.0, 1.493973, 1.0>
  }
  box { // Cube071
    <-1, -1, -1>, <1, 1, 1>
    scale <1.395178, 3.395769, 1.0>
    translate  <-0.889151, 0.049397, 0.0>
  }
}
#declare anker1 = union {
  cone { // Cone003
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 0.072, -0.036116>
    scale <0.4, 0.3, 1.409395>
    rotate <-61.530731, 89.710724, -41.092575>
    translate  <-0.543535, -2.983976, 0.0>
  }
  cone { // Cone004
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 0.072, -0.036116>
    scale <0.4, 0.3, 1.409395>
    rotate <1.747177, 89.499481, -18.900101>
    translate  <-0.618661, 2.981018, 0.0>
  }
  cylinder { // Cylndr015
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.5>
    rotate -90.0*x
    translate  <-3.6554, -1.259631, 0.0>
  }
  torus { // Torus007
    1.5, 0.5  rotate -x*90
    scale <0.234342, 0.184944, 0.184944>
    translate  -4.470456*x
  }
  cylinder { // Cylndr016
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 6.0>
    rotate -90.0*y
    translate  1.852399*x
  }
  object { CSG006 }
  material {
    metalMskinMmed
  }
  scale <0.489853, 0.410089, 0.489853>
  rotate <-69.555984, -165.541656, -211.650894>
  translate  <5.672046, -4.809295, 1.940353>
}
#declare CSG005 = difference {
  torus { // Torus005
    1.85, 0.15  rotate -x*90
    scale <1.0, 1.493973, 1.0>
  }
  box { // Cube070
    <-1, -1, -1>, <1, 1, 1>
    scale <1.395178, 3.395769, 1.0>
    translate  <-0.889151, 0.049397, 0.0>
  }
}
#declare anker = union {
  cone { // Cone002
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 0.072, -0.036116>
    scale <0.4, 0.3, 1.409395>
    rotate <-61.530731, 89.710724, -41.092575>
    translate  <-0.543535, -2.983976, 0.0>
  }
  cone { // Cone001
    <0,0,0>, 0.0, <0,0,1>, 1.0
    rotate <0.0, -0.0, 0.0>
    translate  <-0.0, 0.072, -0.036116>
    scale <0.4, 0.3, 1.409395>
    rotate <1.747177, 89.499481, -18.900101>
    translate  <-0.618661, 2.981018, 0.0>
  }
  cylinder { // Cylndr014
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 2.5>
    rotate -90.0*x
    translate  <-3.6554, -1.259631, 0.0>
  }
  torus { // Torus006
    1.5, 0.5  rotate -x*90
    scale <0.234342, 0.184944, 0.184944>
    translate  -4.470456*x
  }
  cylinder { // Cylndr013
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 6.0>
    rotate -90.0*y
    translate  1.852399*x
  }
  object { CSG005 }
  material {
    metalMskinMmed
  }
  scale <0.478084, 0.400237, 0.478084>
  rotate <-112.442322, -166.666367, 213.362747>
  translate  <5.685153, 4.738915, 2.020653>
}
#declare deck = union {
  object { deckback }
  object { deckstar }
  object { gitterluke1 }
  object { gitterluke }
  object { winch }
  object { mastrail1 }
  object { mastrail }
  object { aufgang1 }
  object { aufgang }
  object { lukeMbig }
  object { lukeMsmall }
  object { fassMgroup }
  object { spill }
  object { cabin }
  object { compasshut }
  object { ruderpinne }
  object { anker1 }
  object { anker }
  material {
    deckMskin
  }
  rotate -0.5*y
  translate  -0.70103*z
}
#declare CSG010 = difference {
  box { // Cube089
    <-1, -1, -1>, <1, 1, 1>
    scale <0.913145, 0.142857, 1.173709>
    translate  <-0.423285, -0.527473, 33.74646>
  }
  cylinder { // Cylndr028
    <0,0,1>, <0,0,0>, 1 
    material {
      plankMskinM01
    }
    scale <0.955875, 1.617753, 1.0>
    rotate -90.0*x
    translate  <-1.49888, -1.0, 32.59613>
  }
  translate  1.065934*y
}
#declare CSG011 = difference {
  box { // Cube090
    <-1, -1, -1>, <1, 1, 1>
    scale <0.913145, 0.142857, 1.173709>
    translate  <-0.423285, -0.527473, 33.74646>
  }
  cylinder { // Cylndr029
    <0,0,1>, <0,0,0>, 1 
    material {
      plankMskinM01
    }
    scale <0.955875, 1.617753, 1.0>
    rotate -90.0*x
    translate  <-1.49888, -1.0, 32.59613>
  }
}
#declare foremast = union {
  cylinder { // Cylndr027
    <0,0,1>, <0,0,0>, 1 
    material {
      woodMskinMmed
    }
    scale <1.0, 1.0, 0.5>
    rotate -9.0*y
    translate  5.0*z
  }
  box { // Cube087
    <-1, -1, -1>, <1, 1, 1>
    material {
      plankMskinM01
    }
    scale <0.147735, 4.146969, 0.385398>
    translate  <1.013811, 0.0, 35.694262>
  }
  box { // Cube088
    <-1, -1, -1>, <1, 1, 1>
    material {
      plankMskinM01
    }
    scale <0.147735, 4.146969, 0.385398>
    translate  <-1.829938, 0.0, 35.694262>
  }
  object { CSG010 }
  object { CSG011 }
  box { // Cube091
    <-1, -1, -1>, <1, 1, 1>
    material {
      plankMskinM02
    }
    scale <2.2, 0.131868, 0.394719>
    translate  <-0.475939, 0.538462, 35.309073>
  }
  box { // Cube092
    <-1, -1, -1>, <1, 1, 1>
    material {
      plankMskinM02
    }
    scale <2.2, 0.131868, 0.394719>
    translate  <-0.475939, -0.527473, 35.309073>
  }
  box { // Cube093
    <-1, -1, -1>, <1, 1, 1>
    material {
      plankMskinM02
    }
    scale <1.631549, 0.615385, 0.483278>
    translate  <-0.516722, 0.0, 40.229654>
  }
  cylinder { // Cylndr030
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale <0.4, 0.4, 1.5>
    translate  <-0.961457, 0.0, 40.856626>
  }
  sphere { // Sphere006
    <0,0,0>,1
    material {
      woodMskinMmed
    }
    scale <0.25, 0.25, 0.166667>
    translate  <-0.945985, 0.010989, 60.647302>
  }
  cone { // Cone008
    <0,0,0>, 1.0, <0,0,1>, 0.3
    material {
      woodMskinMbright
    }
    scale <0.3, 0.3, 26.0>
    translate  <-0.943706, 0.0, 34.736726>
  }
  cone { // Cone009
    <0,0,0>, 1.0, <0,0,1>, 0.7
    material {
      woodMskinMbright
    }
    scale <0.6, 0.6, 41.0>
  }
  scale 0.93
  rotate 9.0*y
  translate  <15.925483, 0.0, -0.210373>
}
#declare talje12 = union {
  cylinder { // Cylndr184
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.05, 0.05, 1.3>
    translate  <0.120119, 0.0, -1.231789>
  }
  cylinder { // Cylndr185
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.05, 0.05, 1.3>
    translate  <-0.103531, 0.0, -1.231789>
  }
  cylinder { // Cylndr186
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale 0.25
    rotate -90.0*x
    translate  <0.0, -0.120123, -1.197327>
  }
  cylinder { // Cylndr193
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale 0.25
    rotate -90.0*x
    translate  -0.120123*y
  }
}
#declare staak12 = union {
  cylinder { // Cylndr182
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.0, 0.0, -0.989765>
    material {
      greyMdark
    }
    scale <0.05, 0.05, 3.0>
    rotate <-0.874101, 0.0, -0.0>
    translate  -1.303684*z
  }
  cylinder { // Cylndr183
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.525539, 0.0, -0.000938>
    material {
      greyMdark
    }
    scale <0.05, 0.05, 28.0>
    translate  <-0.026277, 0.0, 0.026277>
  }
  object { talje12 }
  translate  <-0.043766, 0.0, 1.225448>
  rotate <0.000756, -0.182668, -0.048568>
  translate  <1.720387, 0.0, -1.225448>
}
#declare talje14 = union {
  cylinder { // Cylndr196
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.05, 0.05, 1.3>
    translate  <0.120119, 0.0, -1.231789>
  }
  cylinder { // Cylndr197
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.05, 0.05, 1.3>
    translate  <-0.103531, 0.0, -1.231789>
  }
  cylinder { // Cylndr198
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale 0.25
    rotate -90.0*x
    translate  <0.0, -0.120123, -1.197327>
  }
  cylinder { // Cylndr199
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale 0.25
    rotate -90.0*x
    translate  -0.120123*y
  }
}
#declare staak14 = union {
  cylinder { // Cylndr194
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.0, 0.0, -0.989765>
    material {
      greyMdark
    }
    scale <0.05, 0.05, 3.0>
    rotate <-0.909375, -1.294732, -0.580587>
    translate  -1.303684*z
  }
  cylinder { // Cylndr195
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.525539, 0.0, -0.000938>
    material {
      greyMdark
    }
    scale <0.05, 0.05, 28.0>
    translate  <-0.026277, 0.0, 0.026277>
  }
  object { talje14 }
  translate  <-0.0, 0.0, 1.225448>
  rotate <-0.000491, 3.09835, 0.038512>
  translate  -1.225448*z
}
#declare wanteMvMoMstar = union {
  cylinder { // Cylndr151
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 0.728394>
    rotate 90.0*y
    translate  <0.960061, 0.0, 17.703569>
  }
  cylinder { // Cylndr153
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 0.799967>
    rotate 90.0*y
    translate  <0.888489, 0.0, 16.303569>
  }
  cylinder { // Cylndr155
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 0.884553>
    rotate 90.0*y
    translate  <0.810409, 0.0, 14.903569>
  }
  cylinder { // Cylndr157
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 0.943112>
    rotate 90.0*y
    translate  <0.745343, 0.0, 13.503569>
  }
  cylinder { // Cylndr159
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.021191>
    rotate 90.0*y
    translate  <0.686784, 0.0, 12.103569>
  }
  cylinder { // Cylndr161
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.125297>
    rotate 90.0*y
    translate  <0.582678, 0.0, 10.703569>
  }
  cylinder { // Cylndr163
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.17735>
    rotate 90.0*y
    translate  <0.524119, 0.0, 9.303569>
  }
  cylinder { // Cylndr165
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.190363>
    rotate 90.0*y
    translate  <0.478573, 0.0, 7.903569>
  }
  cylinder { // Cylndr167
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.268442>
    rotate 90.0*y
    translate  <0.393987, 0.0, 6.503569>
  }
  cylinder { // Cylndr169
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.353028>
    rotate 90.0*y
    translate  <0.322414, 0.0, 5.103569>
  }
  cylinder { // Cylndr171
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.44412>
    rotate 90.0*y
    translate  <0.257348, 0.0, 3.703569>
  }
  cylinder { // Cylndr173
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.556034>
    rotate 90.0*y
    translate  <0.153243, 0.0, 2.303569>
  }
  cylinder { // Cylndr181
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.665345>
    rotate 90.0*y
    translate  <0.06215, 0.0, 0.903569>
  }
  object { staak12 }
  object { staak14 }
  cylinder { // Cylndr201
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <-0.015385, -0.036569, -9.417606>
    rotate <201.216629, -187.919296, 177.363983>
    translate  <1.674578, 0.089086, -4.881844>
  }
  cylinder { // Cylndr202
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.010564, 0.034238, 9.0>
    rotate <-20.533718, -185.132919, 0.640761>
    translate  <-0.12818, 0.021282, -4.425205>
  }
  scale <-1.46751, -1.112217, -0.650291>
  rotate <171.143539, -4.230542, 179.721603>
  translate  <19.828781, 2.80697, 35.473984>
}
#declare talje11 = union {
  cylinder { // Cylndr177
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.05, 0.05, 1.3>
    translate  <0.120119, 0.0, -1.231789>
  }
  cylinder { // Cylndr178
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.05, 0.05, 1.3>
    translate  <-0.103531, 0.0, -1.231789>
  }
  cylinder { // Cylndr179
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale 0.25
    rotate -90.0*x
    translate  <0.0, -0.120123, -1.197327>
  }
  cylinder { // Cylndr180
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale 0.25
    rotate -90.0*x
    translate  -0.120123*y
  }
}
#declare staak11 = union {
  cylinder { // Cylndr175
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.0, 0.0, -0.989765>
    material {
      greyMdark
    }
    scale <0.05, 0.05, 3.0>
    rotate <-0.874101, 0.0, -0.0>
    translate  -1.303684*z
  }
  cylinder { // Cylndr176
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.525539, 0.0, -0.000938>
    material {
      greyMdark
    }
    scale <0.05, 0.05, 28.0>
    translate  <-0.026277, 0.0, 0.026277>
  }
  object { talje11 }
  translate  <-0.043766, 0.0, 1.225448>
  rotate <0.000756, -0.182668, -0.048568>
  translate  <1.720387, 0.0, -1.225448>
}
#declare talje13 = union {
  cylinder { // Cylndr189
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.05, 0.05, 1.3>
    translate  <0.120119, 0.0, -1.231789>
  }
  cylinder { // Cylndr190
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.05, 0.05, 1.3>
    translate  <-0.103531, 0.0, -1.231789>
  }
  cylinder { // Cylndr191
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale 0.25
    rotate -90.0*x
    translate  <0.0, -0.120123, -1.197327>
  }
  cylinder { // Cylndr192
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale 0.25
    rotate -90.0*x
    translate  -0.120123*y
  }
}
#declare staak13 = union {
  cylinder { // Cylndr187
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.0, 0.0, -0.989765>
    material {
      greyMdark
    }
    scale <0.05, 0.05, 3.0>
    rotate <-0.909375, -1.294732, -0.580587>
    translate  -1.303684*z
  }
  cylinder { // Cylndr188
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.525539, 0.0, -0.000938>
    material {
      greyMdark
    }
    scale <0.05, 0.05, 28.0>
    translate  <-0.026277, 0.0, 0.026277>
  }
  object { talje13 }
  translate  <-0.0, 0.0, 1.225448>
  rotate <-0.000491, 3.09835, 0.038512>
  translate  -1.225448*z
}
#declare wanteMvMoMback = union {
  cylinder { // Cylndr150
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 0.728394>
    rotate 90.0*y
    translate  <0.960061, 0.0, 17.703569>
  }
  cylinder { // Cylndr152
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 0.799967>
    rotate 90.0*y
    translate  <0.888489, 0.0, 16.303569>
  }
  cylinder { // Cylndr154
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 0.884553>
    rotate 90.0*y
    translate  <0.810409, 0.0, 14.903569>
  }
  cylinder { // Cylndr156
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 0.943112>
    rotate 90.0*y
    translate  <0.745343, 0.0, 13.503569>
  }
  cylinder { // Cylndr158
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.021191>
    rotate 90.0*y
    translate  <0.686784, 0.0, 12.103569>
  }
  cylinder { // Cylndr160
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.125297>
    rotate 90.0*y
    translate  <0.582678, 0.0, 10.703569>
  }
  cylinder { // Cylndr162
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.17735>
    rotate 90.0*y
    translate  <0.524119, 0.0, 9.303569>
  }
  cylinder { // Cylndr164
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.190363>
    rotate 90.0*y
    translate  <0.478573, 0.0, 7.903569>
  }
  cylinder { // Cylndr166
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.268442>
    rotate 90.0*y
    translate  <0.393987, 0.0, 6.503569>
  }
  cylinder { // Cylndr168
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.353028>
    rotate 90.0*y
    translate  <0.322414, 0.0, 5.103569>
  }
  cylinder { // Cylndr170
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.44412>
    rotate 90.0*y
    translate  <0.257348, 0.0, 3.703569>
  }
  cylinder { // Cylndr172
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.556034>
    rotate 90.0*y
    translate  <0.153243, 0.0, 2.303569>
  }
  cylinder { // Cylndr174
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.665345>
    rotate 90.0*y
    translate  <0.06215, 0.0, 0.903569>
  }
  object { staak11 }
  object { staak13 }
  cylinder { // Cylndr200
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.021281, 0.033033, 9.649512>
    rotate <159.096802, -3.131191, -176.972839>
    translate  <1.638128, 0.14034, -4.763219>
  }
  cylinder { // Cylndr149
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.021416, 0.032195, 9.838606>
    rotate <-20.72617, -187.641617, -353.232239>
    translate  <-0.115352, 0.037156, -4.626188>
  }
  scale <1.46751, 1.112217, 0.650291>
  rotate <-8.856463, 4.230542, -0.278396>
  translate  <19.828781, -2.806966, 35.473984>
}
#declare talje6 = union {
  cylinder { // Cylndr095
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.05, 0.05, 1.3>
    translate  <0.120119, 0.0, -1.231789>
  }
  cylinder { // Cylndr096
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.05, 0.05, 1.3>
    translate  <-0.103531, 0.0, -1.231789>
  }
  cylinder { // Cylndr097
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale 0.25
    rotate -90.0*x
    translate  <0.0, -0.120123, -1.197327>
  }
  cylinder { // Cylndr098
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale 0.25
    rotate -90.0*x
    translate  -0.120123*y
  }
}
#declare staak6 = union {
  cylinder { // Cylndr093
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.0, 0.0, -0.989765>
    material {
      greyMdark
    }
    scale <0.05, 0.05, 3.0>
    rotate <27.969189, -0.031142, -0.018633>
    translate  -1.303684*z
  }
  cylinder { // Cylndr094
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.525539, 0.0, -0.000938>
    material {
      greyMdark
    }
    scale <0.05, 0.05, 40.0>
    rotate <-9.945626, -2.051564, 0.359194>
    translate  <-0.026277, 0.0, 0.026277>
  }
  object { talje6 }
  translate  <-0.0, 0.0, 1.225448>
  scale 1.1
  rotate 1.560767*y
  translate  <22.691734, -7.736787, 0.727773>
}
#declare talje7 = union {
  cylinder { // Cylndr101
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.05, 0.05, 1.3>
    translate  <0.120119, 0.0, -1.231789>
  }
  cylinder { // Cylndr102
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.05, 0.05, 1.3>
    translate  <-0.103531, 0.0, -1.231789>
  }
  cylinder { // Cylndr103
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale 0.25
    rotate -90.0*x
    translate  <0.0, -0.120123, -1.197327>
  }
  cylinder { // Cylndr104
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale 0.25
    rotate -90.0*x
    translate  -0.120123*y
  }
}
#declare staak7 = union {
  cylinder { // Cylndr099
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.0, 0.0, -0.989765>
    material {
      greyMdark
    }
    scale <0.05, 0.05, 3.0>
    rotate <27.997166, 0.0, 0.0>
    translate  -1.303684*z
  }
  cylinder { // Cylndr100
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.525539, 0.0, -0.000938>
    material {
      greyMdark
    }
    scale <0.05, 0.05, 47.0>
    rotate <-8.516235, -0.37206, 0.058779>
    translate  <-0.026277, 0.0, 0.026277>
  }
  object { talje7 }
  translate  <-0.0, 0.0, 1.225448>
  scale 1.1
  translate  <23.830651, -7.72146, 0.743597>
}
#declare talje8 = union {
  cylinder { // Cylndr133
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.05, 0.05, 1.3>
    translate  <0.120119, 0.0, -1.231789>
  }
  cylinder { // Cylndr134
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.05, 0.05, 1.3>
    translate  <-0.103531, 0.0, -1.231789>
  }
  cylinder { // Cylndr135
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale 0.25
    rotate -90.0*x
    translate  <0.0, -0.120123, -1.197327>
  }
  cylinder { // Cylndr136
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale 0.25
    rotate -90.0*x
    translate  -0.120123*y
  }
}
#declare staak8 = union {
  cylinder { // Cylndr131
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.0, 0.0, -0.989765>
    material {
      greyMdark
    }
    scale <0.05, 0.05, 3.0>
    rotate <53.050507, -0.0, -0.0>
    translate  -1.303684*z
  }
  cylinder { // Cylndr132
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.525539, 0.0, -0.000938>
    material {
      greyMdark
    }
    scale <0.05, 0.05, 28.0>
    translate  <-0.026277, 0.0, 0.026277>
  }
  object { talje8 }
  translate  <-0.043766, 0.0, 1.225448>
  translate  <1.720387, 0.0, -1.225448>
}
#declare talje9 = union {
  cylinder { // Cylndr139
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.05, 0.05, 1.3>
    translate  <0.120119, 0.0, -1.231789>
  }
  cylinder { // Cylndr140
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.05, 0.05, 1.3>
    translate  <-0.103531, 0.0, -1.231789>
  }
  cylinder { // Cylndr141
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale 0.25
    rotate -90.0*x
    translate  <0.0, -0.120123, -1.197327>
  }
  cylinder { // Cylndr142
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale 0.25
    rotate -90.0*x
    translate  -0.120123*y
  }
}
#declare staak9 = union {
  cylinder { // Cylndr137
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.0, 0.0, -0.989765>
    material {
      greyMdark
    }
    scale <0.05, 0.05, 3.0>
    rotate <52.443462, 0.107783, 0.143872>
    translate  -1.303684*z
  }
  cylinder { // Cylndr138
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.525539, 0.0, -0.000938>
    material {
      greyMdark
    }
    scale <0.05, 0.05, 28.0>
    translate  <-0.026277, 0.0, 0.026277>
  }
  object { talje9 }
  translate  <-0.043766, 0.0, 1.225448>
  rotate 1.390532*y
  translate  <0.886356, 0.0, -1.225448>
}
#declare talje10 = union {
  cylinder { // Cylndr145
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.05, 0.05, 1.3>
    translate  <0.120119, 0.0, -1.231789>
  }
  cylinder { // Cylndr146
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.05, 0.05, 1.3>
    translate  <-0.103531, 0.0, -1.231789>
  }
  cylinder { // Cylndr147
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale 0.25
    rotate -90.0*x
    translate  <0.0, -0.120123, -1.197327>
  }
  cylinder { // Cylndr148
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale 0.25
    rotate -90.0*x
    translate  -0.120123*y
  }
}
#declare staak10 = union {
  cylinder { // Cylndr143
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.0, 0.0, -0.989765>
    material {
      greyMdark
    }
    scale <0.05, 0.05, 3.0>
    rotate <52.434818, 0.15751, 0.237646>
    translate  -1.303684*z
  }
  cylinder { // Cylndr144
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.525539, 0.0, -0.000938>
    material {
      greyMdark
    }
    scale <0.05, 0.05, 28.0>
    translate  <-0.026277, 0.0, 0.026277>
  }
  object { talje10 }
  translate  <-0.0, 0.0, 1.225448>
  rotate 2.9534*y
  translate  -1.225448*z
}
#declare wante1 = union {
  cylinder { // Cylndr105
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 0.689355>
    rotate 90.0*y
    translate  <0.992594, 0.0, 18.403569>
  }
  cylinder { // Cylndr106
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 0.728394>
    rotate 90.0*y
    translate  <0.960061, 0.0, 17.703569>
  }
  cylinder { // Cylndr107
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 0.780447>
    rotate 90.0*y
    translate  <0.921022, 0.0, 17.003569>
  }
  cylinder { // Cylndr108
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 0.799967>
    rotate 90.0*y
    translate  <0.888489, 0.0, 16.303569>
  }
  cylinder { // Cylndr109
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 0.858526>
    rotate 90.0*y
    translate  <0.849449, 0.0, 15.603569>
  }
  cylinder { // Cylndr110
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 0.884553>
    rotate 90.0*y
    translate  <0.810409, 0.0, 14.903569>
  }
  cylinder { // Cylndr111
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 0.910579>
    rotate 90.0*y
    translate  <0.777876, 0.0, 14.203569>
  }
  cylinder { // Cylndr112
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 0.943112>
    rotate 90.0*y
    translate  <0.745343, 0.0, 13.503569>
  }
  cylinder { // Cylndr113
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 0.962632>
    rotate 90.0*y
    translate  <0.725824, 0.0, 12.803569>
  }
  cylinder { // Cylndr114
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.021191>
    rotate 90.0*y
    translate  <0.686784, 0.0, 12.103569>
  }
  cylinder { // Cylndr115
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.021191>
    rotate 90.0*y
    translate  <0.660758, 0.0, 11.403569>
  }
  cylinder { // Cylndr116
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.125297>
    rotate 90.0*y
    translate  <0.582678, 0.0, 10.703569>
  }
  cylinder { // Cylndr117
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.151323>
    rotate 90.0*y
    translate  <0.550145, 0.0, 10.003569>
  }
  cylinder { // Cylndr118
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.17735>
    rotate 90.0*y
    translate  <0.524119, 0.0, 9.303569>
  }
  cylinder { // Cylndr119
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.190363>
    rotate 90.0*y
    translate  <0.504599, 0.0, 8.603569>
  }
  cylinder { // Cylndr120
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.190363>
    rotate 90.0*y
    translate  <0.478573, 0.0, 7.903569>
  }
  cylinder { // Cylndr121
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.261936>
    rotate 90.0*y
    translate  <0.42652, 0.0, 7.203569>
  }
  cylinder { // Cylndr122
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.268442>
    rotate 90.0*y
    translate  <0.393987, 0.0, 6.503569>
  }
  cylinder { // Cylndr123
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.340015>
    rotate 90.0*y
    translate  <0.361454, 0.0, 5.803569>
  }
  cylinder { // Cylndr124
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.353028>
    rotate 90.0*y
    translate  <0.322414, 0.0, 5.103569>
  }
  cylinder { // Cylndr125
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.392068>
    rotate 90.0*y
    translate  <0.309401, 0.0, 4.403569>
  }
  cylinder { // Cylndr126
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.44412>
    rotate 90.0*y
    translate  <0.257348, 0.0, 3.703569>
  }
  cylinder { // Cylndr127
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.52567>
    rotate 90.0*y
    translate  <0.177534, 0.0, 3.003569>
  }
  cylinder { // Cylndr128
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.556034>
    rotate 90.0*y
    translate  <0.153243, 0.0, 2.303569>
  }
  cylinder { // Cylndr129
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.634981>
    rotate 90.0*y
    translate  <0.098587, 0.0, 1.603569>
  }
  cylinder { // Cylndr130
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.665345>
    rotate 90.0*y
    translate  <0.06215, 0.0, 0.903569>
  }
  object { staak8 }
  object { staak9 }
  object { staak10 }
  scale <2.415146, 1.0, 1.14>
  rotate <-12.970515, 0.0, -0.0>
  translate  <17.25563, -7.453975, 2.067355>
}
#declare wantenMvMuMstar = union {
  object { staak6 }
  object { staak7 }
  object { wante1 }
  scale -1.0
  rotate <-180.0, 0.0, -180.0>
}
#declare talje5 = union {
  cylinder { // Cylndr089
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.05, 0.05, 1.3>
    translate  <0.120119, 0.0, -1.231789>
  }
  cylinder { // Cylndr090
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.05, 0.05, 1.3>
    translate  <-0.103531, 0.0, -1.231789>
  }
  cylinder { // Cylndr091
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale 0.25
    rotate -90.0*x
    translate  <0.0, -0.120123, -1.197327>
  }
  cylinder { // Cylndr092
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale 0.25
    rotate -90.0*x
    translate  -0.120123*y
  }
}
#declare staak5 = union {
  cylinder { // Cylndr087
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.0, 0.0, -0.989765>
    material {
      greyMdark
    }
    scale <0.05, 0.05, 3.0>
    rotate <27.969189, -0.031142, -0.018633>
    translate  -1.303684*z
  }
  cylinder { // Cylndr088
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.525539, 0.0, -0.000938>
    material {
      greyMdark
    }
    scale <0.05, 0.05, 40.0>
    rotate <-9.945626, -2.051564, 0.359194>
    translate  <-0.026277, 0.0, 0.026277>
  }
  object { talje5 }
  translate  <-0.0, 0.0, 1.225448>
  scale 1.1
  rotate 1.560767*y
  translate  <22.691734, -7.736787, 0.727773>
}
#declare talje4 = union {
  cylinder { // Cylndr083
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.05, 0.05, 1.3>
    translate  <0.120119, 0.0, -1.231789>
  }
  cylinder { // Cylndr084
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.05, 0.05, 1.3>
    translate  <-0.103531, 0.0, -1.231789>
  }
  cylinder { // Cylndr085
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale 0.25
    rotate -90.0*x
    translate  <0.0, -0.120123, -1.197327>
  }
  cylinder { // Cylndr086
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale 0.25
    rotate -90.0*x
    translate  -0.120123*y
  }
}
#declare staak4 = union {
  cylinder { // Cylndr081
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.0, 0.0, -0.989765>
    material {
      greyMdark
    }
    scale <0.05, 0.05, 3.0>
    rotate <27.997166, 0.0, 0.0>
    translate  -1.303684*z
  }
  cylinder { // Cylndr082
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.525539, 0.0, -0.000938>
    material {
      greyMdark
    }
    scale <0.05, 0.05, 47.0>
    rotate <-8.516235, -0.37206, 0.058779>
    translate  <-0.026277, 0.0, 0.026277>
  }
  object { talje4 }
  translate  <-0.0, 0.0, 1.225448>
  scale 1.1
  translate  <23.830651, -7.72146, 0.743597>
}
#declare talje3 = union {
  cylinder { // Cylndr051
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.05, 0.05, 1.3>
    translate  <0.120119, 0.0, -1.231789>
  }
  cylinder { // Cylndr052
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.05, 0.05, 1.3>
    translate  <-0.103531, 0.0, -1.231789>
  }
  cylinder { // Cylndr053
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale 0.25
    rotate -90.0*x
    translate  <0.0, -0.120123, -1.197327>
  }
  cylinder { // Cylndr054
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale 0.25
    rotate -90.0*x
    translate  -0.120123*y
  }
}
#declare staak3 = union {
  cylinder { // Cylndr049
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.0, 0.0, -0.989765>
    material {
      greyMdark
    }
    scale <0.05, 0.05, 3.0>
    rotate <48.560883, 0.0, 0.0>
    translate  -1.303684*z
  }
  cylinder { // Cylndr050
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.525539, 0.0, -0.000938>
    material {
      greyMdark
    }
    scale <0.05, 0.05, 28.0>
    translate  <-0.026277, 0.0, 0.026277>
  }
  object { talje3 }
  translate  <-0.043766, 0.0, 1.225448>
  translate  <1.720387, 0.0, -1.225448>
}
#declare talje2 = union {
  cylinder { // Cylndr045
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.05, 0.05, 1.3>
    translate  <0.120119, 0.0, -1.231789>
  }
  cylinder { // Cylndr046
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.05, 0.05, 1.3>
    translate  <-0.103531, 0.0, -1.231789>
  }
  cylinder { // Cylndr047
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale 0.25
    rotate -90.0*x
    translate  <0.0, -0.120123, -1.197327>
  }
  cylinder { // Cylndr048
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale 0.25
    rotate -90.0*x
    translate  -0.120123*y
  }
}
#declare staak2 = union {
  cylinder { // Cylndr043
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.0, 0.0, -0.989765>
    material {
      greyMdark
    }
    scale <0.05, 0.05, 3.0>
    rotate <53.546669, 0.118913, 0.159191>
    translate  -1.303684*z
  }
  cylinder { // Cylndr044
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.525539, 0.0, -0.000938>
    material {
      greyMdark
    }
    scale <0.05, 0.05, 28.0>
    translate  <-0.026277, 0.0, 0.026277>
  }
  object { talje2 }
  translate  <-0.043766, 0.0, 1.225448>
  rotate 1.390532*y
  translate  <0.886356, 0.0, -1.225448>
}
#declare talje1 = union {
  cylinder { // Cylndr039
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.05, 0.05, 1.3>
    translate  <0.120119, 0.0, -1.231789>
  }
  cylinder { // Cylndr040
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.05, 0.05, 1.3>
    translate  <-0.103531, 0.0, -1.231789>
  }
  cylinder { // Cylndr041
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale 0.25
    rotate -90.0*x
    translate  <0.0, -0.120123, -1.197327>
  }
  cylinder { // Cylndr042
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale 0.25
    rotate -90.0*x
    translate  -0.120123*y
  }
}
#declare staak1 = union {
  cylinder { // Cylndr037
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.0, 0.0, -0.989765>
    material {
      greyMdark
    }
    scale <0.05, 0.05, 3.0>
    rotate <52.229847, 0.153114, 0.231747>
    translate  -1.303684*z
  }
  cylinder { // Cylndr038
    <0,0,1>, <0,0,0>, 1 
    rotate -0.0*y
    translate  <0.525539, 0.0, -0.000938>
    material {
      greyMdark
    }
    scale <0.05, 0.05, 28.0>
    translate  <-0.026277, 0.0, 0.026277>
  }
  object { talje1 }
  translate  <-0.0, 0.0, 1.225448>
  rotate 2.9534*y
  translate  -1.225448*z
}
#declare wante = union {
  cylinder { // Cylndr080
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 0.689355>
    rotate 90.0*y
    translate  <0.992594, 0.0, 18.403569>
  }
  cylinder { // Cylndr079
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 0.728394>
    rotate 90.0*y
    translate  <0.960061, 0.0, 17.703569>
  }
  cylinder { // Cylndr078
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 0.780447>
    rotate 90.0*y
    translate  <0.921022, 0.0, 17.003569>
  }
  cylinder { // Cylndr077
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 0.799967>
    rotate 90.0*y
    translate  <0.888489, 0.0, 16.303569>
  }
  cylinder { // Cylndr076
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 0.858526>
    rotate 90.0*y
    translate  <0.849449, 0.0, 15.603569>
  }
  cylinder { // Cylndr075
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 0.884553>
    rotate 90.0*y
    translate  <0.810409, 0.0, 14.903569>
  }
  cylinder { // Cylndr074
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 0.910579>
    rotate 90.0*y
    translate  <0.777876, 0.0, 14.203569>
  }
  cylinder { // Cylndr073
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 0.943112>
    rotate 90.0*y
    translate  <0.745343, 0.0, 13.503569>
  }
  cylinder { // Cylndr072
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 0.962632>
    rotate 90.0*y
    translate  <0.725824, 0.0, 12.803569>
  }
  cylinder { // Cylndr071
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.021191>
    rotate 90.0*y
    translate  <0.686784, 0.0, 12.103569>
  }
  cylinder { // Cylndr070
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.021191>
    rotate 90.0*y
    translate  <0.660758, 0.0, 11.403569>
  }
  cylinder { // Cylndr069
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.125297>
    rotate 90.0*y
    translate  <0.582678, 0.0, 10.703569>
  }
  cylinder { // Cylndr068
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.151323>
    rotate 90.0*y
    translate  <0.550145, 0.0, 10.003569>
  }
  cylinder { // Cylndr067
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.17735>
    rotate 90.0*y
    translate  <0.524119, 0.0, 9.303569>
  }
  cylinder { // Cylndr066
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.190363>
    rotate 90.0*y
    translate  <0.504599, 0.0, 8.603569>
  }
  cylinder { // Cylndr065
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.190363>
    rotate 90.0*y
    translate  <0.478573, 0.0, 7.903569>
  }
  cylinder { // Cylndr064
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.261936>
    rotate 90.0*y
    translate  <0.42652, 0.0, 7.203569>
  }
  cylinder { // Cylndr063
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.268442>
    rotate 90.0*y
    translate  <0.393987, 0.0, 6.503569>
  }
  cylinder { // Cylndr062
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.340015>
    rotate 90.0*y
    translate  <0.361454, 0.0, 5.803569>
  }
  cylinder { // Cylndr061
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.353028>
    rotate 90.0*y
    translate  <0.322414, 0.0, 5.103569>
  }
  cylinder { // Cylndr060
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.392068>
    rotate 90.0*y
    translate  <0.309401, 0.0, 4.403569>
  }
  cylinder { // Cylndr059
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.44412>
    rotate 90.0*y
    translate  <0.257348, 0.0, 3.703569>
  }
  cylinder { // Cylndr058
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.52567>
    rotate 90.0*y
    translate  <0.177534, 0.0, 3.003569>
  }
  cylinder { // Cylndr057
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.556034>
    rotate 90.0*y
    translate  <0.153243, 0.0, 2.303569>
  }
  cylinder { // Cylndr056
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.634981>
    rotate 90.0*y
    translate  <0.098587, 0.0, 1.603569>
  }
  cylinder { // Cylndr055
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 1.665345>
    rotate 90.0*y
    translate  <0.06215, 0.0, 0.903569>
  }
  object { staak3 }
  object { staak2 }
  object { staak1 }
  scale <2.415146, 1.0, 1.14>
  rotate <-12.970515, 0.0, -0.0>
  translate  <17.25563, -7.453975, 2.067355>
}
#declare wantenMvMuMback = union {
  object { staak5 }
  object { staak4 }
  object { wante }
}
#declare foremastMgaffel = union {
  box { // Cube081
    <-1, -1, -1>, <1, 1, 1>
    material {
      plankMskinM01
    }
    scale <1.695974, 0.172932, 0.715167>
    rotate 90.0*x
  }
  cone { // Cone007
    <0,0,0>, 1.0, <0,0,1>, 0.5
    material {
      woodMskinMmed
    }
    scale <0.3, 0.3, 17.0>
    rotate 90.0*y
  }
  sphere { // Sphere005
    <0,0,0>,1
    material {
      foldedMsailMskin
    }
    scale <2.598998, 0.425879, 0.394469>
    rotate 3.595125*y
    translate  <3.988535, 0.004633, -0.353253>
  }
  sphere { // Sphere008
    <0,0,0>,1
    material {
      foldedMsailMskin
    }
    scale <2.598998, 0.425879, 0.394469>
    translate  <7.857259, 0.018822, -0.458018>
  }
  sphere { // Sphere009
    <0,0,0>,1
    material {
      foldedMsailMskin
    }
    scale <2.598998, 0.425879, 0.394469>
    rotate 0.0*y
    translate  <11.78484, 0.018822, -0.379892>
  }
  sphere { // Sphere010
    <0,0,0>,1
    material {
      foldedMsailMskin
    }
    scale <2.0, 0.327726, 0.303554>
    rotate -4.43646*y
    translate  <14.732997, 0.035871, -0.303556>
  }
  torus { // Torus010
    1.85, 0.15  rotate -x*90
    material {
      blackringMskin
    }
    scale 0.167222
    rotate <0.0, -89.632088, -0.0>
    translate  <9.917736, 0.003623, -0.41082>
  }
  torus { // Torus009
    1.85, 0.15  rotate -x*90
    material {
      blackringMskin
    }
    scale 0.167222
    rotate <0.0, -89.632088, -0.0>
    translate  <5.85616, 0.003623, -0.445055>
  }
  torus { // Torus011
    1.85, 0.15  rotate -x*90
    material {
      blackringMskin
    }
    scale 0.167222
    rotate <0.0, -89.632088, -0.0>
    translate  <13.709868, 0.003623, -0.365173>
  }
  torus { // Torus012
    1.85, 0.15  rotate -x*90
    material {
      blackringMskin
    }
    scale 0.167222
    rotate <0.0, -89.632088, -0.0>
    translate  <2.286147, 0.019637, -0.319526>
  }
  cylinder { // Cylndr387
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 32.0>
    rotate <180.0, 24.282928, 180.0>
    translate  <3.490312, 0.0, 29.225365>
  }
  translate  <17.705706, 0.0, 5.12186>
}
#declare foldedMsail2 = union {
  torus { // Torus031
    1.85, 0.15  rotate -x*90
    material {
      blackringMskin
    }
    scale <0.284385, 0.284385, 0.35418>
    rotate -90.0*y
    translate  <13.644668, 0.0, -0.365467>
  }
  torus { // Torus032
    1.85, 0.15  rotate -x*90
    material {
      blackringMskin
    }
    scale <0.284385, 0.284385, 0.35418>
    rotate -90.0*y
    translate  <-13.057321, 0.0, -0.412449>
  }
  torus { // Torus033
    1.85, 0.15  rotate -x*90
    material {
      blackringMskin
    }
    scale <0.284385, 0.284385, 0.35418>
    rotate -90.0*y
    translate  <-8.791545, 0.0, -0.502571>
  }
  torus { // Torus034
    1.85, 0.15  rotate -x*90
    material {
      blackringMskin
    }
    scale <0.284385, 0.284385, 0.35418>
    rotate -90.0*y
    translate  <9.442439, 0.0, -0.506631>
  }
  torus { // Torus035
    1.85, 0.15  rotate -x*90
    material {
      blackringMskin
    }
    scale <0.284385, 0.284385, 0.35418>
    rotate -90.0*y
    translate  <3.989283, 0.0, -0.615489>
  }
  torus { // Torus036
    1.85, 0.15  rotate -x*90
    material {
      blackringMskin
    }
    scale <0.284385, 0.284385, 0.35418>
    rotate -90.0*y
    translate  <-3.624549, 0.0, -0.592693>
  }
  sphere { // Sphere021
    <0,0,0>,1
    material {
      foldedMsailMskin
    }
    scale <3.496826, 0.62244, 0.436996>
    rotate 2.448526*y
    translate  <-11.896644, 0.0, -0.489574>
  }
  sphere { // Sphere022
    <0,0,0>,1
    material {
      foldedMsailMskin
    }
    scale <3.692656, 0.657298, 0.461469>
    translate  <-6.36446, 0.0, -0.538531>
  }
  sphere { // Sphere023
    <0,0,0>,1
    material {
      foldedMsailMskin
    }
    scale <3.349954, 0.596297, 0.418642>
    rotate -1.741166*y
    translate  <12.141431, 0.0, -0.489574>
  }
  sphere { // Sphere024
    <0,0,0>,1
    material {
      foldedMsailMskin
    }
    scale <3.692656, 0.657298, 0.461469>
    translate  <6.902991, 0.0, -0.538531>
  }
  sphere { // Sphere025
    <0,0,0>,1
    material {
      foldedMsailMskin
    }
    scale <4.818676, 0.657298, 0.608341>
    translate  <0.19583, 0.0, -0.685403>
  }
}
#declare CSG018 = difference {
  torus { // Torus037
    1.85, 0.15  rotate -x*90
    material {
      greyMdark
    }
    scale <0.608341, 0.706256, 0.706256>
    translate  0.489574*y
  }
  box { // Cube102
    <-1, -1, -1>, <1, 1, 1>
    material {
      greyMdark
    }
    scale <1.489574, 0.80417, 1.0>
    translate  -0.783318*y
  }
}
#declare Group005 = union {
  cylinder { // Cylndr404
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale <0.176456, 0.176456, 0.387462>
    translate  15.427312*z
  }
  cylinder { // Cylndr405
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale <0.480074, 0.413091, 0.418522>
    translate  <-0.102194, 0.0, -0.0>
  }
  cone { // Cone016
    <0,0,0>, 1.0, <0,0,1>, 0.5
    material {
      woodMskinMmed
    }
    scale <0.3, 0.3, 16.0>
  }
  rotate 90.0*y
}
#declare Group006 = union {
  cylinder { // Cylndr406
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale <0.176456, 0.176456, 0.387462>
    translate  15.427312*z
  }
  cylinder { // Cylndr407
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale <0.480074, 0.413091, 0.418522>
    translate  0.094137*x
  }
  cone { // Cone017
    <0,0,0>, 1.0, <0,0,1>, 0.5
    material {
      woodMskinMmed
    }
    scale <0.3, 0.3, 16.0>
  }
  rotate -90.0*y
}
#declare CSG019 = difference {
  torus { // Torus038
    1.95, 0.05  rotate -x*90
    rotate -90.0*x
  }
  box { // Cube103
    <-1, -1, -1>, <1, 1, 1>
    scale <2.9562, 1.0, 1.363944>
    translate  <-0.045493, 0.0, 1.364791>
  }
  material {
    greyMdark
  }
  scale <4.548456, 1.0, 1.0>
  translate  6.550995*x
}
#declare CSG020 = difference {
  torus { // Torus039
    1.95, 0.05  rotate -x*90
    rotate -90.0*x
  }
  box { // Cube104
    <-1, -1, -1>, <1, 1, 1>
    scale <2.9562, 1.0, 1.363944>
    translate  <-0.045493, 0.0, 1.364791>
  }
  material {
    greyMdark
  }
  scale <4.548456, 1.0, 1.0>
  translate  -6.369023*x
}
#declare yard2 = union {
  object { CSG018 }
  object { Group005 }
  object { Group006 }
  cylinder { // Cylndr408
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.04, 0.04, 16.0>
    rotate <-20.049603, -66.786507, 15.059474>
    translate  <15.09509, 0.0, -0.048863>
  }
  cylinder { // Cylndr409
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.04, 0.04, 16.0>
    rotate <-6.348649, 67.952744, -0.102647>
    translate  <-14.996951, 0.0, -0.090891>
  }
  object { CSG019 }
  object { CSG020 }
  cylinder { // Cylndr410
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.04, 0.04, 44.0>
    rotate <-106.880188, -6.792203, -18.658455>
    translate  <-14.926611, 0.074496, -0.048863>
  }
  cylinder { // Cylndr411
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.04, 0.04, 44.0>
    rotate <-106.922607, 6.447443, 18.446493>
    translate  <15.09509, 0.0, -0.048863>
  }
}
#declare topMyardMsail = union {
  object { foldedMsail2 }
  object { yard2 }
  scale <0.56, 0.56, 0.6>
  rotate <-4.242166, -0.0, -90.0>
  translate  <22.237846, 0.0, 49.481899>
}
#declare foldedMsail1 = union {
  torus { // Torus022
    1.85, 0.15  rotate -x*90
    material {
      blackringMskin
    }
    scale <0.284385, 0.284385, 0.35418>
    rotate -90.0*y
    translate  <13.644668, 0.0, -0.365467>
  }
  torus { // Torus023
    1.85, 0.15  rotate -x*90
    material {
      blackringMskin
    }
    scale <0.284385, 0.284385, 0.35418>
    rotate -90.0*y
    translate  <-13.057321, 0.0, -0.412449>
  }
  torus { // Torus024
    1.85, 0.15  rotate -x*90
    material {
      blackringMskin
    }
    scale <0.284385, 0.284385, 0.35418>
    rotate -90.0*y
    translate  <-8.791545, 0.0, -0.502571>
  }
  torus { // Torus025
    1.85, 0.15  rotate -x*90
    material {
      blackringMskin
    }
    scale <0.284385, 0.284385, 0.35418>
    rotate -90.0*y
    translate  <9.442439, 0.0, -0.506631>
  }
  torus { // Torus026
    1.85, 0.15  rotate -x*90
    material {
      blackringMskin
    }
    scale <0.284385, 0.284385, 0.35418>
    rotate -90.0*y
    translate  <3.989283, 0.0, -0.615489>
  }
  torus { // Torus027
    1.85, 0.15  rotate -x*90
    material {
      blackringMskin
    }
    scale <0.284385, 0.284385, 0.35418>
    rotate -90.0*y
    translate  <-3.624549, 0.0, -0.592693>
  }
  sphere { // Sphere016
    <0,0,0>,1
    material {
      foldedMsailMskin
    }
    scale <3.496826, 0.62244, 0.436996>
    rotate 2.448526*y
    translate  <-11.896644, 0.0, -0.489574>
  }
  sphere { // Sphere017
    <0,0,0>,1
    material {
      foldedMsailMskin
    }
    scale <3.692656, 0.657298, 0.461469>
    translate  <-6.36446, 0.0, -0.538531>
  }
  sphere { // Sphere018
    <0,0,0>,1
    material {
      foldedMsailMskin
    }
    scale <3.349954, 0.596297, 0.418642>
    rotate -1.741166*y
    translate  <12.141431, 0.0, -0.489574>
  }
  sphere { // Sphere019
    <0,0,0>,1
    material {
      foldedMsailMskin
    }
    scale <3.692656, 0.657298, 0.461469>
    translate  <6.902991, 0.0, -0.538531>
  }
  sphere { // Sphere020
    <0,0,0>,1
    material {
      foldedMsailMskin
    }
    scale <4.818676, 0.657298, 0.608341>
    translate  <0.19583, 0.0, -0.685403>
  }
}
#declare CSG015 = difference {
  torus { // Torus028
    1.85, 0.15  rotate -x*90
    material {
      greyMdark
    }
    scale <0.608341, 0.706256, 0.706256>
    translate  0.489574*y
  }
  box { // Cube085
    <-1, -1, -1>, <1, 1, 1>
    material {
      greyMdark
    }
    scale <1.489574, 0.80417, 1.0>
    translate  -0.783318*y
  }
}
#declare Group003 = union {
  cylinder { // Cylndr396
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale <0.176456, 0.176456, 0.387462>
    translate  15.427312*z
  }
  cylinder { // Cylndr397
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale <0.480074, 0.413091, 0.418522>
    translate  <-0.102194, 0.0, -0.0>
  }
  cone { // Cone014
    <0,0,0>, 1.0, <0,0,1>, 0.5
    material {
      woodMskinMmed
    }
    scale <0.3, 0.3, 16.0>
  }
  rotate 90.0*y
}
#declare Group004 = union {
  cylinder { // Cylndr398
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale <0.176456, 0.176456, 0.387462>
    translate  15.427312*z
  }
  cylinder { // Cylndr399
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale <0.480074, 0.413091, 0.418522>
    translate  0.094137*x
  }
  cone { // Cone015
    <0,0,0>, 1.0, <0,0,1>, 0.5
    material {
      woodMskinMmed
    }
    scale <0.3, 0.3, 16.0>
  }
  rotate -90.0*y
}
#declare CSG016 = difference {
  torus { // Torus029
    1.95, 0.05  rotate -x*90
    rotate -90.0*x
  }
  box { // Cube086
    <-1, -1, -1>, <1, 1, 1>
    scale <2.9562, 1.0, 1.363944>
    translate  <-0.045493, 0.0, 1.364791>
  }
  material {
    greyMdark
  }
  scale <4.548456, 1.0, 1.0>
  translate  6.550995*x
}
#declare CSG017 = difference {
  torus { // Torus030
    1.95, 0.05  rotate -x*90
    rotate -90.0*x
  }
  box { // Cube101
    <-1, -1, -1>, <1, 1, 1>
    scale <2.9562, 1.0, 1.363944>
    translate  <-0.045493, 0.0, 1.364791>
  }
  material {
    greyMdark
  }
  scale <4.548456, 1.0, 1.0>
  translate  -6.369023*x
}
#declare yard1 = union {
  object { CSG015 }
  object { Group003 }
  object { Group004 }
  cylinder { // Cylndr400
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.04, 0.04, 16.0>
    rotate <-20.049603, -66.786507, 15.059474>
    translate  <15.09509, 0.0, -0.048863>
  }
  cylinder { // Cylndr401
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.04, 0.04, 16.0>
    rotate <-6.348649, 67.952744, -0.102647>
    translate  <-14.996951, 0.0, -0.090891>
  }
  object { CSG016 }
  object { CSG017 }
  cylinder { // Cylndr402
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.04, 0.04, 32.0>
    rotate <-91.121498, -0.345226, -27.542444>
    translate  <-14.926611, 0.074496, -0.048863>
  }
  cylinder { // Cylndr403
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.04, 0.04, 32.0>
    rotate <-91.071548, 0.556311, 27.557232>
    translate  <15.09509, 0.0, -0.048863>
  }
}
#declare middleMyardMsail = union {
  object { foldedMsail1 }
  object { yard1 }
  scale 0.8
  rotate <-3.291857, -0.0, -90.0>
  translate  <20.796828, 0.0, 42.062975>
}
#declare foldedMsail = union {
  torus { // Torus019
    1.85, 0.15  rotate -x*90
    material {
      blackringMskin
    }
    scale <0.284385, 0.284385, 0.35418>
    rotate -90.0*y
    translate  <13.644668, 0.0, -0.365467>
  }
  torus { // Torus018
    1.85, 0.15  rotate -x*90
    material {
      blackringMskin
    }
    scale <0.284385, 0.284385, 0.35418>
    rotate -90.0*y
    translate  <-13.057321, 0.0, -0.412449>
  }
  torus { // Torus017
    1.85, 0.15  rotate -x*90
    material {
      blackringMskin
    }
    scale <0.284385, 0.284385, 0.35418>
    rotate -90.0*y
    translate  <-8.791545, 0.0, -0.502571>
  }
  torus { // Torus016
    1.85, 0.15  rotate -x*90
    material {
      blackringMskin
    }
    scale <0.284385, 0.284385, 0.35418>
    rotate -90.0*y
    translate  <9.442439, 0.0, -0.506631>
  }
  torus { // Torus015
    1.85, 0.15  rotate -x*90
    material {
      blackringMskin
    }
    scale <0.284385, 0.284385, 0.35418>
    rotate -90.0*y
    translate  <3.989283, 0.0, -0.615489>
  }
  torus { // Torus014
    1.85, 0.15  rotate -x*90
    material {
      blackringMskin
    }
    scale <0.284385, 0.284385, 0.35418>
    rotate -90.0*y
    translate  <-3.624549, 0.0, -0.592693>
  }
  sphere { // Sphere015
    <0,0,0>,1
    material {
      foldedMsailMskin
    }
    scale <3.496826, 0.62244, 0.436996>
    rotate 2.448526*y
    translate  <-11.896644, 0.0, -0.489574>
  }
  sphere { // Sphere014
    <0,0,0>,1
    material {
      foldedMsailMskin
    }
    scale <3.692656, 0.657298, 0.461469>
    translate  <-6.36446, 0.0, -0.538531>
  }
  sphere { // Sphere013
    <0,0,0>,1
    material {
      foldedMsailMskin
    }
    scale <3.349954, 0.596297, 0.418642>
    rotate -1.741166*y
    translate  <12.141431, 0.0, -0.489574>
  }
  sphere { // Sphere012
    <0,0,0>,1
    material {
      foldedMsailMskin
    }
    scale <3.692656, 0.657298, 0.461469>
    translate  <6.902991, 0.0, -0.538531>
  }
  sphere { // Sphere011
    <0,0,0>,1
    material {
      foldedMsailMskin
    }
    scale <4.818676, 0.657298, 0.608341>
    translate  <0.19583, 0.0, -0.685403>
  }
}
#declare CSG008 = difference {
  torus { // Torus013
    1.85, 0.15  rotate -x*90
    material {
      greyMdark
    }
    scale <0.608341, 0.706256, 0.706256>
    translate  0.489574*y
  }
  box { // Cube082
    <-1, -1, -1>, <1, 1, 1>
    material {
      greyMdark
    }
    scale <1.489574, 0.80417, 1.0>
    translate  -0.783318*y
  }
}
#declare Group002 = union {
  cylinder { // Cylndr390
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale <0.176456, 0.176456, 0.387462>
    translate  15.427312*z
  }
  cylinder { // Cylndr391
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale <0.480074, 0.413091, 0.418522>
    translate  <-0.102194, 0.0, -0.0>
  }
  cone { // Cone013
    <0,0,0>, 1.0, <0,0,1>, 0.5
    material {
      woodMskinMmed
    }
    scale <0.3, 0.3, 16.0>
  }
  rotate 90.0*y
}
#declare Group001 = union {
  cylinder { // Cylndr389
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale <0.176456, 0.176456, 0.387462>
    translate  15.427312*z
  }
  cylinder { // Cylndr388
    <0,0,1>, <0,0,0>, 1 
    material {
      blackringMskin
    }
    scale <0.480074, 0.413091, 0.418522>
    translate  0.094137*x
  }
  cone { // Cone012
    <0,0,0>, 1.0, <0,0,1>, 0.5
    material {
      woodMskinMmed
    }
    scale <0.3, 0.3, 16.0>
  }
  rotate -90.0*y
}
#declare CSG014 = difference {
  torus { // Torus021
    1.95, 0.05  rotate -x*90
    rotate -90.0*x
  }
  box { // Cube084
    <-1, -1, -1>, <1, 1, 1>
    scale <2.9562, 1.0, 1.363944>
    translate  <-0.045493, 0.0, 1.364791>
  }
  material {
    greyMdark
  }
  scale <4.548456, 1.0, 1.0>
  translate  6.550995*x
}
#declare CSG009 = difference {
  torus { // Torus020
    1.95, 0.05  rotate -x*90
    rotate -90.0*x
  }
  box { // Cube083
    <-1, -1, -1>, <1, 1, 1>
    scale <2.9562, 1.0, 1.363944>
    translate  <-0.045493, 0.0, 1.364791>
  }
  material {
    greyMdark
  }
  scale <4.548456, 1.0, 1.0>
  translate  -6.369023*x
}
#declare yard = union {
  object { CSG008 }
  object { Group002 }
  object { Group001 }
  cylinder { // Cylndr393
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.04, 0.04, 16.0>
    rotate <-20.049603, -66.786507, 15.059474>
    translate  <15.09509, 0.0, -0.048863>
  }
  cylinder { // Cylndr392
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.04, 0.04, 16.0>
    rotate <-6.348649, 67.952744, -0.102647>
    translate  <-14.996951, 0.0, -0.090891>
  }
  object { CSG014 }
  object { CSG009 }
  cylinder { // Cylndr395
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.04, 0.04, 35.0>
    rotate <-138.117889, -12.042632, -10.423541>
    translate  <-14.926611, 0.074496, -0.048863>
  }
  cylinder { // Cylndr394
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.04, 0.04, 35.0>
    rotate <-138.197662, 11.361526, 9.972046>
    translate  <15.09509, 0.0, -0.048863>
  }
}
#declare lowerMyardMsail = union {
  object { foldedMsail }
  object { yard }
  rotate <-1.81026, -0.0, -90.0>
  translate  <19.044246, 0.0, 26.538083>
}
#declare fockMsegel3 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.172773, -0.470798, -1.650769>, <-0.649284, -0.522498, -1.573890>, <-1.481617, -0.622466, -1.404028>, <-4.516790, -1.004439, -0.020545>, 
      <0.332648, 0.210924, -1.396977>, <-0.315807, 0.341971, -1.341269>, <-0.966648, 0.291823, -1.182758>, <-3.130765, 0.147566, -0.020545>, 
      <0.526828, 1.323112, -0.961291>, <0.066345, 1.390064, -0.965236>, <-0.394286, 1.418122, -0.879404>, <-2.217537, 0.924921, -0.020545>, 
      <0.851108, 3.216544, -0.029653>, <0.976319, 3.745355, -0.059306>, <1.099717, 3.971456, 0.000000>, <0.646677, 3.430659, 0.000000>
    }
  }
  material {
    fockMsailMskinMlayered
  }
  scale <4.800403, 4.252859, 3.910582>
  rotate <90.0, 0.310701, -0.0>
  translate  <12.6027, 0.418564, 14.779152>
}
#declare aussenklueersail = union {
  object { fockMsegel3 }
  cylinder { // Cylndr416
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 13.0>
    rotate <-8.372167, -147.096786, 193.305557>
    translate  <13.471738, 6.829187, 12.780209>
  }
  scale <1.127596, 1.0, 1.2>
  rotate -0.622946*y
  translate  <-7.469143, -0.445826, -2.033923>
}
#declare fockMsegel2 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.185384, -0.470798, -1.348111>, <-0.636673, -0.522498, -1.271232>, <-1.469006, -0.622466, -1.101370>, <-4.516790, -1.004439, -0.020545>, 
      <0.345258, 0.210924, -1.094319>, <-0.303196, 0.341971, -1.038611>, <-0.954037, 0.291823, -0.880100>, <-3.130765, 0.147566, -0.020545>, 
      <0.488996, 1.061274, -0.809191>, <0.078956, 1.128225, -0.813136>, <-0.469951, 1.156283, -0.639029>, <-2.217537, 0.924921, -0.020545>, 
      <0.834594, 3.216544, -0.029653>, <0.976319, 3.745355, -0.059306>, <1.099717, 3.971456, 0.000000>, <0.646677, 3.430659, 0.000000>
    }
  }
  material {
    fockMsailMskinMlayered_1
  }
  scale <4.800403, 4.252859, 3.910582>
  rotate <90.0, 0.310701, -0.0>
  translate  <12.6027, 0.418564, 14.779152>
}
#declare innenklueersail = union {
  object { fockMsegel2 }
  cylinder { // Cylndr415
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 11.0>
    rotate <-3.210972, -143.200668, 193.563431>
    translate  <13.459308, 5.562381, 12.780071>
  }
  translate  <-4.7273, -0.35666, -3.018749>
}
#declare fockMsegel1 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.026314, -1.642843, -0.973913>, <-0.760687, -1.790571, -1.124373>, <-1.456881, -1.815947, -1.002527>, <-4.442197, -1.999006, -0.020545>, 
      <0.218880, -0.881429, -1.072053>, <-0.311730, -0.917201, -0.979306>, <-0.905506, -0.892757, -0.830679>, <-3.329678, -0.871865, -0.020545>, 
      <0.475461, 0.616778, -0.783456>, <0.144802, 0.586452, -0.763122>, <-0.309862, 0.561011, -0.650174>, <-2.006191, 0.527094, -0.020545>, 
      <0.942359, 3.216544, 0.000000>, <1.035624, 3.745355, 0.000000>, <1.099717, 3.971456, 0.000000>, <0.646677, 3.430659, 0.000000>
    }
  }
  material {
    fockMsailMskinMlayered
  }
  scale <4.800403, 4.252859, 3.910582>
  rotate <90.0, 0.310701, -0.0>
  translate  <12.6027, 0.418564, 14.779152>
}
#declare focksail = union {
  object { fockMsegel1 }
  cylinder { // Cylndr414
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 12.0>
    rotate <122.345139, -8.098481, 15.453591>
    translate  <12.59871, 3.749782, 7.6693>
  }
  translate  <-0.089165, -0.445826, 0.122295>
}
#declare foremastgroup = union {
  box { // wantentraegerMvMstar
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMbright
    }
    scale <3.991766, 0.651448, 0.2>
    rotate <-0.017389, 1.758362, 3.46206>
    translate  <20.396255, 7.560284, 0.0>
  }
  box { // wantentraegerMvMback
    <-1, -1, -1>, <1, 1, 1>
    material {
      woodMskinMbright
    }
    scale <3.991766, 0.651448, 0.2>
    rotate <-0.017389, 1.758362, -3.462065>
    translate  <20.311332, -7.598501, 0.0>
  }
  object { foremast }
  object { wanteMvMoMstar }
  object { wanteMvMoMback }
  object { wantenMvMuMstar }
  object { wantenMvMuMback }
  object { foremastMgaffel }
  object { topMyardMsail }
  object { middleMyardMsail }
  object { lowerMyardMsail }
  object { aussenklueersail }
  object { innenklueersail }
  object { focksail }
}
#declare backMstay = union {
  cylinder { // Cylndr379
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 58.5>
    rotate <-178.917633, -6.588303, -50.96254>
    translate  <46.453786, 0.0, 57.577438>
  }
  cylinder { // Cylndr378
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 58.5>
    rotate <-173.432632, 0.035034, -50.519745>
    translate  <46.453786, 0.0, 57.577438>
  }
  cylinder { // Cylndr377
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 54.0>
    rotate <-173.998474, 2.512604, -50.151001>
    translate  <23.554038, 0.0, 53.592054>
  }
  cylinder { // Cylndr376
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 54.0>
    rotate <-173.86969, 3.106934, 179.830032>
    translate  <23.554038, 0.0, 53.592054>
  }
}
#declare bobMstays = union {
  cylinder { // Cylndr375
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 22.0>
    rotate <180.0, 88.727448, 180.0>
    translate  <21.690452, 0.0, 35.95599>
  }
  cylinder { // Cylndr374
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 32.5>
    rotate 49.226101*y
    translate  <21.837725, 0.0, 36.471446>
  }
  cylinder { // Cylndr373
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 41.0>
    rotate 47.250744*y
    translate  <-10.724542, 0.0, 4.959574>
  }
  cylinder { // Cylndr372
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 44.0>
    rotate 53.045704*y
    translate  <-15.871481, 0.0, 6.220049>
  }
  cylinder { // Cylndr371
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 56.5>
    rotate 50.611988*y
    translate  <-21.753697, 0.0, 7.585564>
  }
  cylinder { // Cylndr370
    <0,0,1>, <0,0,0>, 1 
    material {
      greyMdark
    }
    scale <0.03, 0.03, 65.0>
    rotate 44.375175*y
    translate  <-21.753697, 0.0, 7.585564>
  }
}
#declare rigg = union {
  object { backMstay }
  object { bobMstays }
}
#declare Unterarm14 = union {
  sphere { // Sphere159
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr519
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere160
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-29.437571, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm14 = union {
  cylinder { // Cylndr518
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere158
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm14 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  scale <1.1, 1.1, 1.2>
  rotate <-61.591579, -180.0, -179.786514>
  translate  <-0.105107, -0.278887, 3.685775>
}
#declare Unterarm15 = union {
  sphere { // Sphere162
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr521
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere163
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-30.381542, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm15 = union {
  cylinder { // Cylndr520
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere161
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm15 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  scale <1.1, 1.1, 1.2>
  rotate <41.852478, -7.001359, -13.997181>
  translate  <-2.401394, 0.453128, 3.74843>
}
#declare Kopf7 = union {
  sphere { // Sphere164
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr522
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere165
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.673836, 1.180246, 0.102711>
    rotate <44.196861, 0.0, -0.0>
    translate  <0.016255, 1.326042, 4.890801>
  }
  sphere { // Sphere166
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.415908, 0.636478, 0.500141>
    rotate <55.48772, -0.0, 0.0>
    translate  <0.014679, 1.414108, 5.212719>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-16.202301, -0.0, -0.0>
  translate  <0.0, -0.093435, 3.807426>
}
#declare Oberkoeper7 = union {
  cylinder { // Cylndr517
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere157
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm14 }
  object { Oberarm15 }
  object { Kopf7 }
  translate  <0.0, 0.1, -1.1>
  rotate <-8.680178, -0.097739, -0.019938>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh14 = union {
  cylinder { // Cylndr525
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr526
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere169
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere170
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <86.472839, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel14 = union {
  cylinder { // Cylndr524
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere168
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh14 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-24.8113, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein14 = union {
  cylinder { // Cylndr523
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere167
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel14 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <3.9097, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh15 = union {
  cylinder { // Cylndr529
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr530
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere173
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere174
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel15 = union {
  cylinder { // Cylndr528
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere172
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh15 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-34.439198, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein15 = union {
  cylinder { // Cylndr527
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere171
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel15 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <29.16674, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare sailor8 = union {
  object { Oberkoeper7 }
  object { Bein14 }
  object { Bein15 }
  scale 0.44
  rotate <0.117038, -0.0, 0.852776>
  translate  <20.484955, -6.115321, 9.869251>
}
#declare Unterarm8 = union {
  sphere { // Sphere105
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr477
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere106
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-29.437571, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm8 = union {
  cylinder { // Cylndr476
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere104
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm8 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-111.449455, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm9 = union {
  sphere { // Sphere108
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr479
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere109
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-11.290077, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm9 = union {
  cylinder { // Cylndr478
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere107
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm9 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <34.146553, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf4 = union {
  sphere { // Sphere110
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr480
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere111
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.673836, 1.180246, 0.102711>
    rotate <44.196861, 0.0, -0.0>
    translate  <0.016255, 1.326042, 4.890801>
  }
  sphere { // Sphere112
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.415908, 0.636478, 0.500141>
    rotate <55.48772, -0.0, 0.0>
    translate  <0.014679, 1.414108, 5.212719>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-16.202301, -0.0, -0.0>
  translate  <0.0, -0.093435, 3.807426>
}
#declare Oberkoeper4 = union {
  cylinder { // Cylndr475
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere103
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm8 }
  object { Oberarm9 }
  object { Kopf4 }
  translate  <0.0, 0.1, -1.1>
  rotate <-8.680178, -0.097739, -0.019938>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh8 = union {
  cylinder { // Cylndr483
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr484
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere115
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere116
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <86.472839, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel8 = union {
  cylinder { // Cylndr482
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere114
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh8 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-55.190166, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein8 = union {
  cylinder { // Cylndr481
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere113
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel8 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <38.753166, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh9 = union {
  cylinder { // Cylndr487
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr488
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere119
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere120
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <104.58036, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel9 = union {
  cylinder { // Cylndr486
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere118
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh9 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-55.042477, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein9 = union {
  cylinder { // Cylndr485
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere117
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel9 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <10.565237, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare sailor5 = union {
  object { Oberkoeper4 }
  object { Bein8 }
  object { Bein9 }
  scale 0.44
  rotate <0.117038, -0.0, 24.47938>
  translate  <15.773721, 5.200863, 1.589458>
}
#declare Unterarm6 = union {
  sphere { // Sphere087
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr463
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere088
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-29.437571, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm6 = union {
  cylinder { // Cylndr462
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere086
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm6 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  scale <1.1, 1.1, 1.2>
  rotate <-94.985336, -180.0, -170.696152>
  translate  <-0.107465, -0.428931, 3.62332>
}
#declare Unterarm7 = union {
  sphere { // Sphere090
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr465
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere091
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-30.381542, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm7 = union {
  cylinder { // Cylndr464
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere089
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm7 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  scale <1.1, 1.1, 1.2>
  rotate <105.927444, 2.92867, -18.421713>
  translate  <-2.401394, 0.453128, 3.74843>
}
#declare Kopf3 = union {
  sphere { // Sphere092
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr466
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere093
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.673836, 1.180246, 0.102711>
    rotate <44.196861, 0.0, -0.0>
    translate  <0.016255, 1.326042, 4.890801>
  }
  sphere { // Sphere094
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.415908, 0.636478, 0.500141>
    rotate <55.48772, -0.0, 0.0>
    translate  <0.014679, 1.414108, 5.212719>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-16.202301, -0.0, -0.0>
  translate  <0.0, -0.093435, 3.807426>
}
#declare Oberkoeper3 = union {
  cylinder { // Cylndr461
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere085
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm6 }
  object { Oberarm7 }
  object { Kopf3 }
  translate  <0.0, 0.1, -1.1>
  rotate <-8.680178, -0.097739, -0.019938>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh6 = union {
  cylinder { // Cylndr469
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr470
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere097
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere098
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <86.472839, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel6 = union {
  cylinder { // Cylndr468
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere096
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh6 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-24.8113, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein6 = union {
  cylinder { // Cylndr467
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere095
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel6 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <3.9097, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh7 = union {
  cylinder { // Cylndr473
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr474
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere101
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere102
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel7 = union {
  cylinder { // Cylndr472
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere100
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh7 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-34.439198, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein7 = union {
  cylinder { // Cylndr471
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere099
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel7 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <29.16674, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare sailor4 = union {
  object { Oberkoeper3 }
  object { Bein6 }
  object { Bein7 }
  scale 0.44
  rotate <0.117038, -0.0, 46.739857>
  translate  <14.168761, 4.989791, 1.753744>
}
#declare Unterarm4 = union {
  sphere { // Sphere069
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr449
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere070
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-29.437571, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm4 = union {
  cylinder { // Cylndr448
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere068
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm4 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-175.548309, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm5 = union {
  sphere { // Sphere072
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr451
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere073
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-11.290077, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm5 = union {
  cylinder { // Cylndr450
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere071
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm5 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <34.146553, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf2 = union {
  sphere { // Sphere074
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr452
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere075
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.673836, 1.180246, 0.102711>
    rotate <44.196861, 0.0, -0.0>
    translate  <0.016255, 1.326042, 4.890801>
  }
  sphere { // Sphere076
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.415908, 0.636478, 0.500141>
    rotate <55.48772, -0.0, 0.0>
    translate  <0.014679, 1.414108, 5.212719>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-16.202301, -0.0, -0.0>
  translate  <0.0, -0.093435, 3.807426>
}
#declare Oberkoeper2 = union {
  cylinder { // Cylndr447
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere067
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm4 }
  object { Oberarm5 }
  object { Kopf2 }
  translate  <0.0, 0.1, -1.1>
  rotate <-8.680178, -0.097739, -0.019938>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh4 = union {
  cylinder { // Cylndr455
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr456
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere079
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere080
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <86.472839, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel4 = union {
  cylinder { // Cylndr454
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere078
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh4 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-24.8113, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein4 = union {
  cylinder { // Cylndr453
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere077
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel4 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <3.9097, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh5 = union {
  cylinder { // Cylndr459
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr460
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere083
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere084
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel5 = union {
  cylinder { // Cylndr458
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere082
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh5 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-34.439198, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein5 = union {
  cylinder { // Cylndr457
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere081
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel5 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <29.16674, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare sailor3 = union {
  object { Oberkoeper2 }
  object { Bein4 }
  object { Bein5 }
  scale 0.44
  rotate <0.117038, -0.0, 115.375786>
  translate  <48.381162, -4.557098, 1.753744>
}
#declare Unterarm2 = union {
  sphere { // Sphere051
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr435
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere052
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-46.601192, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm2 = union {
  cylinder { // Cylndr434
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere050
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm2 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-107.824043, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm3 = union {
  sphere { // Sphere054
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr437
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere055
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-50.499157, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm3 = union {
  cylinder { // Cylndr436
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere053
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm3 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <66.72998, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf1 = union {
  sphere { // Sphere056
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr438
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere057
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.673836, 1.180246, 0.102711>
    rotate <44.196861, 0.0, -0.0>
    translate  <0.016255, 1.326042, 4.890801>
  }
  sphere { // Sphere058
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.415908, 0.636478, 0.500141>
    rotate <55.48772, -0.0, 0.0>
    translate  <0.014679, 1.414108, 5.212719>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-16.202301, -0.0, -0.0>
  translate  <0.0, -0.093435, 3.807426>
}
#declare Oberkoeper1 = union {
  cylinder { // Cylndr433
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere049
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm2 }
  object { Oberarm3 }
  object { Kopf1 }
  translate  <0.0, 0.1, -1.1>
  rotate <-43.399723, -0.0, 0.0>
  translate  <0.0, -0.126321, 1.149128>
}
#declare Schuh2 = union {
  cylinder { // Cylndr441
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr442
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere061
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere062
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <97.646255, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel2 = union {
  cylinder { // Cylndr440
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere060
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh2 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-23.021675, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein2 = union {
  cylinder { // Cylndr439
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere059
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel2 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-30.675865, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh3 = union {
  cylinder { // Cylndr445
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr446
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere065
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere066
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <96.660667, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel3 = union {
  cylinder { // Cylndr444
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere064
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh3 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-7.958426, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein3 = union {
  cylinder { // Cylndr443
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere063
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel3 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-24.186872, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare sailor2 = union {
  object { Oberkoeper1 }
  object { Bein2 }
  object { Bein3 }
  scale 0.44
  rotate <5.064835, -0.112228, 175.745697>
  translate  <57.332892, 1.440132, 1.787315>
}
#declare Unterarm12 = union {
  sphere { // Sphere141
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr505
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere142
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-29.437571, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm12 = union {
  cylinder { // Cylndr504
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere140
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm12 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  scale <1.1, 1.1, 1.2>
  rotate <-145.462494, -180.0, -175.378143>
  translate  <-0.107465, -0.428931, 3.62332>
}
#declare Unterarm13 = union {
  sphere { // Sphere144
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr507
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere145
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-30.381542, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm13 = union {
  cylinder { // Cylndr506
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere143
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm13 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  scale <1.1, 1.1, 1.2>
  rotate <41.852478, -7.001359, -13.997181>
  translate  <-2.401394, 0.453128, 3.74843>
}
#declare Kopf6 = union {
  sphere { // Sphere146
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr508
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere147
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.673836, 1.180246, 0.102711>
    rotate <44.196861, 0.0, -0.0>
    translate  <0.016255, 1.326042, 4.890801>
  }
  sphere { // Sphere148
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.415908, 0.636478, 0.500141>
    rotate <55.48772, -0.0, 0.0>
    translate  <0.014679, 1.414108, 5.212719>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-16.202301, -0.0, -0.0>
  translate  <0.0, -0.093435, 3.807426>
}
#declare Oberkoeper6 = union {
  cylinder { // Cylndr503
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere139
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm12 }
  object { Oberarm13 }
  object { Kopf6 }
  translate  <0.0, 0.1, -1.1>
  rotate <-8.680178, -0.097739, -0.019938>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh12 = union {
  cylinder { // Cylndr511
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr512
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere151
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere152
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <86.472839, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel12 = union {
  cylinder { // Cylndr510
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere150
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh12 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-24.8113, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein12 = union {
  cylinder { // Cylndr509
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere149
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel12 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <3.9097, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh13 = union {
  cylinder { // Cylndr515
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr516
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere155
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere156
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel13 = union {
  cylinder { // Cylndr514
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere154
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh13 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-34.439198, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein13 = union {
  cylinder { // Cylndr513
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere153
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel13 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <29.16674, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare sailor7 = union {
  object { Oberkoeper6 }
  object { Bein12 }
  object { Bein13 }
  scale 0.44
  rotate <0.117038, -0.0, -151.942596>
  translate  <26.707828, -2.400494, 1.405>
}
#declare Unterarm10 = union {
  sphere { // Sphere123
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr491
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere124
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-29.437571, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm10 = union {
  cylinder { // Cylndr490
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere122
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm10 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  scale <1.1, 1.1, 1.2>
  rotate <-145.462494, -180.0, -175.378143>
  translate  <-0.107465, -0.428931, 3.62332>
}
#declare Unterarm11 = union {
  sphere { // Sphere126
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr493
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere127
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-30.381542, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm11 = union {
  cylinder { // Cylndr492
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere125
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm11 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  scale <1.1, 1.1, 1.2>
  rotate <41.852478, -7.001359, -13.997181>
  translate  <-2.401394, 0.453128, 3.74843>
}
#declare Kopf5 = union {
  sphere { // Sphere128
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr494
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere129
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.673836, 1.180246, 0.102711>
    rotate <44.196861, 0.0, -0.0>
    translate  <0.016255, 1.326042, 4.890801>
  }
  sphere { // Sphere130
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.415908, 0.636478, 0.500141>
    rotate <55.48772, -0.0, 0.0>
    translate  <0.014679, 1.414108, 5.212719>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-16.202301, -0.0, -0.0>
  translate  <0.0, -0.093435, 3.807426>
}
#declare Oberkoeper5 = union {
  cylinder { // Cylndr489
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere121
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm10 }
  object { Oberarm11 }
  object { Kopf5 }
  translate  <0.0, 0.1, -1.1>
  rotate <-8.680178, -0.097739, -0.019938>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh10 = union {
  cylinder { // Cylndr497
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr498
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere133
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere134
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <86.472839, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel10 = union {
  cylinder { // Cylndr496
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere132
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh10 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-24.8113, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein10 = union {
  cylinder { // Cylndr495
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere131
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel10 }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <3.9097, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh11 = union {
  cylinder { // Cylndr501
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr502
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere137
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere138
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel11 = union {
  cylinder { // Cylndr500
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere136
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh11 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-34.439198, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein11 = union {
  cylinder { // Cylndr499
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere135
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel11 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <29.16674, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare sailor6 = union {
  object { Oberkoeper5 }
  object { Bein10 }
  object { Bein11 }
  scale 0.44
  rotate <0.117038, -0.0, 97.58873>
  translate  <10.134013, -2.702086, 1.473291>
}
#declare Unterarm = union {
  sphere { // Sphere033
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr421
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere034
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-29.437571, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm = union {
  cylinder { // Cylndr420
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere032
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <-125.731262, -180.0, -180.0>
  translate  <-0.082821, -0.002111, 3.687547>
}
#declare Unterarm1 = union {
  sphere { // Sphere036
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.1, 0.4, 0.2>
    rotate -20.0*x
    translate  <1.2, 1.2, 1.95>
  }
  cylinder { // Cylndr423
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    rotate -115.0*x
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere037
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 0.25>
    translate  <1.2, 0.0, 2.5>
  }
  rotate <-0.0, 0.0, 0.0>
  translate  <0.0, 0.0, -2.5>
  // Scaling fixed
  // Translation fixed
  rotate <-11.290077, 0.0, -0.0>
  translate  <-0.0, 0.0, 2.5>
}
#declare Oberarm1 = union {
  cylinder { // Cylndr422
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.2, 0.25, 1.3>
    translate  <1.2, 0.0, 2.5>
  }
  sphere { // Sphere035
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.24, 0.3, 0.24>
    translate  <1.2, 0.0, 3.8>
  }
  object { Unterarm1 }
  translate  <0.0, -0.0, -3.8>
  // Scaling fixed
  // Translation fixed
  scale <1.1, 1.1, 1.2>
  rotate <34.146553, 0.0, -0.0>
  translate  <-2.555515, -0.004546, 3.67978>
}
#declare Kopf = union {
  sphere { // Sphere038
    <0,0,0>,1
    material {
      skin
    }
    // All transformations fixed
    scale <0.4, 0.5, 0.7>
    rotate 15.0*x
    translate  <0.0, 1.6, 5.0>
  }
  cylinder { // Cylndr424
    <0,0,1>, <0,0,0>, 1 
    material {
      skin
    }
    // All transformations fixed
    scale <0.3, 0.3, 1.0>
    rotate -10.0*x
    translate  <0.0, 1.4, 3.6>
  }
  sphere { // Sphere039
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.673836, 1.180246, 0.102711>
    rotate <44.196861, 0.0, -0.0>
    translate  <0.016255, 1.326042, 4.890801>
  }
  sphere { // Sphere048
    <0,0,0>,1
    material {
      black_dull
    }
    scale <0.415908, 0.636478, 0.500141>
    rotate <55.48772, -0.0, 0.0>
    translate  <0.014679, 1.414108, 5.212719>
  }
  rotate 5.24395*x
  translate  <0.0, -1.117657, -4.067126>
  rotate <-16.202301, -0.0, -0.0>
  translate  <0.0, -0.093435, 3.807426>
}
#declare Oberkoeper = union {
  cylinder { // Cylndr419
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    scale <1.121166, 0.604204, 2.86524>
    translate  <0.0, -0.084278, 0.9>
  }
  sphere { // Sphere031
    <0,0,0>,1
    material {
      black_dull
    }
    scale <1.467486, 0.509054, 0.592445>
    translate  <0.0, -0.1, 3.7>
  }
  object { Oberarm }
  object { Oberarm1 }
  object { Kopf }
  translate  <0.0, 0.1, -1.1>
  rotate <-31.974028, -0.0, 0.0>
  translate  <0.0, -0.1, 1.1>
}
#declare Schuh = union {
  cylinder { // Cylndr427
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr428
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere042
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere043
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <86.472839, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel = union {
  cylinder { // Cylndr426
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere041
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-24.8113, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein = union {
  cylinder { // Cylndr425
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere040
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel }
  rotate <0.0, -0.0, -0.0>
  translate  <-0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <-14.840015, 0.0, -0.0>
  translate  <-0.80123, 0.0, 1.0>
}
#declare Schuh1 = union {
  cylinder { // Cylndr431
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.5, 0.5, 2.0>
    translate  0.786595*x
  }
  cylinder { // Cylndr432
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.971907, 0.522425, 1.0>
  }
  sphere { // Sphere046
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.965467, 0.522425, 0.679319>
    rotate -15.781613*y
    translate  <-0.061356, 0.0, 1.084568>
  }
  sphere { // Sphere047
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.38283, 0.339811, 1.192899>
    translate  <0.806605, 0.0, 2.158137>
  }
  rotate <0.0, -0.0, -86.366524>
  translate  <-0.051117, 0.804983, -2.158137>
  // Scaling fixed
  // Translation fixed
  scale <0.545776, 0.563379, 0.208274>
  rotate <65.728935, 1.350429, -0.608842>
  translate  <1.189946, 2.45357, 1.387853>
}
#declare Unterschenkel1 = union {
  cylinder { // Cylndr430
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.28, 0.35, 1.82>
    rotate -115.0*x
    translate  <1.2, 0.721588, 2.147894>
  }
  sphere { // Sphere045
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.3, 0.4, 0.4>
    rotate <65.0, -0.0, 0.0>
    translate  <1.2, 0.733501, 2.146482>
  }
  object { Schuh1 }
  rotate <-65.272026, -0.0, -0.0>
  translate  <-0.0, -2.277359, -0.231115>
  // Scaling fixed
  // Translation fixed
  rotate <-34.439198, 0.0, 0.0>
  translate  <0.0, -0.004146, 1.685323>
}
#declare Bein1 = union {
  cylinder { // Cylndr429
    <0,0,1>, <0,0,0>, 1 
    material {
      black_dull
    }
    // All transformations fixed
    scale <0.32, 0.4, 2.08>
    translate  <1.2, 0.0, 1.7>
  }
  sphere { // Sphere044
    <0,0,0>,1
    material {
      black_dull
    }
    // All transformations fixed
    scale 0.5
    translate  <1.2, -0.112798, 3.716295>
  }
  object { Unterschenkel1 }
  rotate <-0.0, -0.0, -0.0>
  translate  <0.0, 0.000572, -3.687631>
  // Scaling fixed
  // Translation fixed
  rotate <29.16674, 0.0, -0.0>
  translate  <-1.60123, 0.0, 1.0>
}
#declare sailor1 = union {
  object { Oberkoeper }
  object { Bein }
  object { Bein1 }
  scale 0.44
  rotate <0.117038, -0.0, -9.853782>
  translate  <56.203128, -1.345633, 1.80925>
}
union { // ship
  object { Ruder }
  object { bugspriet }
  object { smallboat }
  object { mainmastgroup }
  object { rumpf }
  object { reling }
  object { heck }
  object { deck }
  object { foremastgroup }
  object { rigg }
  object { sailor8 }
  object { sailor5 }
  object { sailor4 }
  object { sailor3 }
  object { sailor2 }
  object { sailor7 }
  object { sailor6 }
  object { sailor1 }
  material {
    pMskinMcomlxM01
  }
  scale 0.25
  rotate <-7.076649, 9.904057, -86.610458>
  translate  <-21.781242, 6.036728, 5.0>
}


