#version unofficial megapov 0.5;

global_settings { hf_gray_16 }


#declare Bumps1 = function {
	pigment {
		bumps
		scale <1,.4, 1>
		rotate z*10
		color_map {
			[0 rgb 0]
			[1 rgb 1]
		}
	}
}

#declare Wrinkles1 = function {
	pigment {
		wrinkles
		scale .1
		color_map {
			[0 rgb 0]
			[.8 rgb 1]
		}
	}
}


#declare Pig = pigment {	
	function { (Bumps1(x*2,y*2,0)^3)*(.4+.6*Wrinkles1(x,y,0)) }
	color_map {
		[0 rgb 0]
		[1 rgb 1]
	}
	translate .5*x + .5*y
	scale 1/4
}


#declare PigX = pigment {
	gradient x
	pigment_map {
		[.3 Pig]
		[.7 Pig translate x]
	}
}

plane { -z, 0
	pigment {
		gradient y
		pigment_map {
			[.3 PigX]
			[.7 PigX translate y]
		}
	}
	finish { ambient 1 diffuse 0 }
}


camera {
	orthographic
	location <.5,.5,-10>
	right 1*x
	up 1*y
	look_at <.2,.2,0>
}

