//=========================================
//      DEFINITION DU PHARE
//=========================================
#version unofficial MegaPov 0.5;


//=========================================
//      MACROS DIVERSES
//=========================================
#macro Toit(lngt, lrgt, nblng, nblrg, ep, t_seed)

#local t_rnd = seed(t_seed);

union {

	#local lrg = lrgt/(1+(nblrg-1)*.75);
	#local lng = lngt/nblng;
	#local beta = atan2(ep, lrg*.75);
	#local ardoise = box { <0,0,0>, <lng, ep, -lrg>
						rotate x*degrees(beta) }
	#local demi_ardoise = box { <0,0,0>, <lng*.5, ep, -lrg>
						rotate x*degrees(beta) }

	#local i=0;
	#while (i < nblrg)
		/* premiere ardoise de la rangee */
		#if (mod(i,2)=1)
			object { demi_ardoise rotate (-1+2*rand(t_rnd))*y translate -i*lrg*.75*z }
		#else
			object { ardoise rotate (-1+2*rand(t_rnd))*y translate -i*lrg*.75*z }
		#end
		/* autres ardoises de la rangee */
		#local j=1;
		#while (j < (nblng-1))

			object { ardoise rotate (-1+2*rand(t_rnd))*y translate -i*lrg*.75*z + (j-.5*mod(i,2))*lng*x }

			#local j=j+1;	
		#end
		/* derniere ardoise de la rangee */
		#if (mod(i,2)=1)
			object { ardoise rotate (-1+2*rand(t_rnd))*y translate -i*lrg*.75*z + (nblng-1.5)*lng*x }
			object { demi_ardoise rotate (-1+2*rand(t_rnd))*y translate -i*lrg*.75*z + (nblng-0.5)*lng*x }
		#else
			object { ardoise rotate (-1+2*rand(t_rnd))*y translate -i*lrg*.75*z + (nblng-1)*lng*x }
		#end

		#local i=i+1;	
	#end
	
	texture { T_Ardoise }
}

#end


#macro Ornement(rayon1, rayon2, haut, nbx, nby, o_seed)

#local o_rnd = seed(o_seed);

#local beta = 360/nbx;
#local gamma = degrees(atan2(rayon1-rayon2,h));
#local scx = .97*rayon2*sin(radians(beta)*.5)/.6;
#local scy = .97*haut/nby;

#local brique = box { <-1, 0, -.5>, <1, 1, 0> scale <scx, scy, 1> }


union {
	#local i=0;
	#while (i<nby)
		#local j=0;
		#while (j<nbx)
			object { brique
				translate -y*haut*i/nby
				translate z*(rayon1-rayon2)*i/nby
				translate rayon2*z+.01
				rotate y*(j+.5*mod(i,2))*beta
			}
			#local j=j+1;
		#end
		#local i=i+1;
	#end
	texture { T_Brique }
}

#end


//===================================
//    CORPS PRINCIPAL DU PHARE
//===================================


#declare Cone_Principal = 
#if (Detail_Phare < 2)
	cone {
		<0,0,0>, 4
		<0,30,0>, 3
	}
#else
	#local St = seed(12);
	#local cond1 = false;
	#local cond2 = false;
	union {
		#local i = 0;
		#local c1 = <0,0,0>;
		#while (i < 30)
			#local h = .5+rand(St);
			#if (i+h > 29)
				#local h = 30 - i;
			#end
			#local c2 = vturbulence(1, .3, 3, <0, i/10, 0>)*<.12,0,.05>;
			sphere { c1+i*y, (4-i/30) }
			cone { c1+i*y, (4-i/30), c2+(i+h)*y, (4-(i+h)/30) }

			#local c1 = c2;
			#local i = i + h;
		#end
	}
#end


#local Angle_Toit = radians(20);

#declare Cabane = 
#if (Detail_Phare > 0)
	union {
		box { <-5.8, -1, -3>, <0, 3, 3> }
		cylinder { <-5.8, -1, -2.8>, <-5.8, 3, -2.8>, .2 }
		box { <-6, -1, -2.8>, <-5.8, 3, 2.8> }
		cylinder { <-5.8, -1, 2.8>, <-5.8, 3, 2.8>, .2 }
		intersection {
			box { <0, 0, -1>, <.2, 1, 0> scale <1, 3*tan(Angle_Toit), 3> }
			plane { y, 0 rotate -45*x translate -z scale <1, 3*tan(Angle_Toit), 3> }
			union {
				box { <-0.01, 0, -1>, <.21, 1, 0> scale <1, 3*tan(Angle_Toit), 3> }
				sphere { <0.2, 0, -2.8>, .2 }
			}
			translate -6*x + 3*y
		}
		intersection {
			box { <0, 0, 0>, <.2, 1, 1> scale <1, 3*tan(Angle_Toit), 3> }
			plane { y, 0 rotate 45*x translate z scale <1, 3*tan(Angle_Toit), 3> }
			union {
				box { <-0.01, 0, 0>, <.21, 1, 1> scale <1, 3*tan(Angle_Toit), 3> }
				sphere { <.2, 0, 2.8>, .2 }
			}
			translate -6*x + 3*y
		}
	}
#else
	box { <-6, -1, -3>, <0, 3, 3> }
#end


#declare Toit_Cabane = union {

#if (Detail_Phare >= 3)
	object { Toit(6.1, 3.1/cos(Angle_Toit), 20, 7, .01, 321) rotate -x*degrees(Angle_Toit) translate -6.1*x + (3 + 3*tan(Angle_Toit))*y }
	object { Toit(6.1, 3.1/cos(Angle_Toit), 20, 7, .01, 524) rotate -x*degrees(Angle_Toit) rotate y*180 translate (3 + 3*tan(Angle_Toit))*y }
#else
	box { <-6.1, .01, 0>, <0, -.05, 3.1/cos(Angle_Toit)> rotate x*degrees(Angle_Toit) translate (3 + 3*tan(Angle_Toit))*y }
	box { <-6.1, .01, 0>, <0, -.05, -3.1/cos(Angle_Toit)> rotate -x*degrees(Angle_Toit) translate (3 + 3*tan(Angle_Toit))*y }
	texture {
		pigment { color rgb<.2, .2, .3>*.5 }
		normal {
			average
			normal_map {
				[ 1 bozo turbulence .4 scale .04 ]
				[ 1 brick 5 mortar .2 scale <.1, 100, .1> ]
			}
		}
		finish { ambient .3 diffuse .7
			specular .2 roughness .0005
			phong .2 phong_size 40 metallic
		}
	}
#end
}


#declare Fenetre_Tour = union {
	box { <-.25, 0, -.01>, <.25, 1.2, .01> material { M_Vitre } }
	box { <-.25, 0, -.02>, <-.20, 1.2, .02> }
	box { <.20, 0, -.02>, <.25, 1.2, .02> }
	box { <-.03, 0, -.02>, <.03, 1.2, .02> }
	box { <-.2, 0, -.02>, <.20, .05, .02> }
	box { <-.2, 1.15, -.02>, <.20, 1.20, .02> }
	box { <-.2, .05+1.1*1/4-.01, -.015>, <.20, .05+1.1*1/4+.01, .015> }
	box { <-.2, .05+1.1*2/4-.01, -.015>, <.20, .05+1.1*2/4+.01, .015> }
	box { <-.2, .05+1.1*3/4-.01, -.015>, <.20, .05+1.1*3/4+.01, .015> }
	texture { T_Fenetre_Tour } 
}

#declare Fenetre_Cabane = union {
	box { <-5.00, 2.00, -0.01>, <-4.00, 2.70, 0.01> material { M_Vitre } }
	box { <-5.00, 2.00, -0.02>, <-4.95, 2.70, 0.02> }
	box { <-4.05, 2.00, -0.02>, <-4.00, 2.70, 0.02> }
	box { <-4.53, 2.00, -0.02>, <-4.47, 2.70, 0.02> }
	box { <-4.54, 2.00, -0.03>, <-4.48, 2.70, 0.02> }
	box { <-5.00, 2.00, -0.02>, <-4.00, 2.05, 0.02> }
	box { <-5.00, 2.65, -0.02>, <-4.00, 2.70, 0.02> }
	box { <-5.00, 2.05+0.6*1/2-.01, -.015>, <-4.00, 2.05+0.6*1/2+.01, .015> }
	box { <-4.95+.9*1/4-.01, 2.0, -.015>, <-4.95+.9*1/4+.01, 2.7, .015> }
	box { <-4.95+.9*3/4-.01, 2.0, -.015>, <-4.95+.9*3/4+.01, 2.7, .015> }
	texture { T_Fenetre_Tour } 
}

#declare Porte_Cabane = union {
	box { <0, 0, -.5>, <0.05, 1.4, .5> }
	cylinder { <0, 0, 0>, <0.05, 0, 0>, 1 scale <1, .4, .5> translate 1.4*y }
	box { <-.04, .1, -.45>,  <-.055, .2, .45> }
	box { <-.04, 1.2, -.45>, <-.055, 1.3, .45> }
	box { <-.04, 0.3, -.05>, <-.055, 1.1, .05> }
	box { <-.04, 0.3, -.35>, <-.055, 1.1, -.25> }
	box { <-.04, 0.3, .35>,  <-.055, 1.1, .25> }
	union {
		cylinder { -.03, .08, .005 }
		sphere {0, 1.5 scale <0.015, 0.03, 0.02> translate x*.08 }
		sphere {0, 1.5 scale <0.015, 0.03, 0.02> translate -x*.03 }
		translate <0, 1, -.4>
		texture { T_Tole }
	}
	texture { T_Fenetre_Tour }
}


#declare Corps_Principal = union {

	difference {
		object { Cone_Principal texture { T_Corps_Phare } }
		cone { <0,0,0>, 3, <0,30,0>, 2 } // interieur
		box { <-.25, 0, -4.5>, <.25, 1.2, 0> translate y*6 }
		box { <-.25, 0, -4.5>, <.25, 1.2, 0> translate y*11 }
		box { <-.25, 0, -4.5>, <.25, 1.2, 0> translate y*16 }
		box { <-.25, 0, -4.5>, <.25, 1.2, 0> translate y*21 }
		box { <-.25, 0, -4.5>, <.25, 1.2, 0> translate y*26 }
		cutaway_textures
	}
#if (Detail_Phare > 2)
	cone { 0, 2, 30*y, 1 pigment { color rgb<.5, .5, .5> } finish { ambient .2 diffuse .4 } }
	object { Fenetre_Tour translate (-3.8 +  6/30)*z +  6*y }
	object { Fenetre_Tour translate (-3.8 + 11/30)*z + 11*y }
	object { Fenetre_Tour translate (-3.8 + 16/30)*z + 16*y }
	object { Fenetre_Tour translate (-3.8 + 21/30)*z + 21*y }
	object { Fenetre_Tour translate (-3.8 + 26/30)*z + 26*y }
#end

	difference {
		object { Cabane texture { T_Corps_Phare } }
		box { <-5.7, 1.0, -2.8>, <0, 3.1, 2.8> } // interieur
		box { <-5.0, 2.0, -3.1>, <-4.0, 2.7, -2.7> }  // fenetre
		box { <-6.1, 1.0, -.5>, <-5.6, 2.4, .5> }	//porte
		cylinder { <-6.1, 0, 0>, <-5.6, 0, 0>, 1 scale <1, .4, .5> translate 2.4*y } //porte
		cutaway_textures
	}
#if (Detail_Phare > 2)
	object { Fenetre_Cabane translate -2.9*z }
	object { Porte_Cabane
		translate -.5*z -.05*x
		//rotate -y*40
		translate .5*z
		translate -5.9*x + y }
#end
	object { Toit_Cabane }
#if (Detail_Phare > 4)
	box {<-5.7, 1.0, -2.8>, <0, 3.1, 2.8>
		pigment { rgbt 1 }
		hollow
		interior {
			media {
				intervals 5
				emission <1,1,.5>*.8
				samples 1,1
				method 2
				variance 1/200
				confidence .9
				density {
					spherical
					scale <3,2,2.5>
					translate 3*y - 2*x
					density_map {
						[0 rgb 0]
						[1 rgb 1]
					}
				}
			}
		}
	}
#end

}

//===================================
//    BASE DU PHARE (PLATEFORME)
//===================================

#declare Base = difference {
	union {
		box { <-1.495, -6, -17.5>, <1.495, -.1, -9> }
		#if (Iso_Base)
		
			#declare F_Crack = function {
				pigment {
					gradient y
					pigment_map {
						[0.60 crackle turbulence .2 scale .1 color_map { [.10 rgb 0] [.15 rgb 1] } ]
						[0.80 crackle turbulence .2 scale .1 color_map { [.15 rgb 0] [.20 rgb 1] } ]
						[0.90 crackle turbulence .2 scale .1 color_map { [.20 rgb 0] [.25 rgb 1] } ]
						[0.95 crackle turbulence .2 scale .1 color_map { [.25 rgb 0] [.30 rgb 1] } ]
						[0.98 crackle turbulence .2 scale .1 color_map { [.30 rgb 0] [.35 rgb 1] } ]
					}
					translate -y
				}
			}
			#declare F_Cyl = function { x^2 + z^2 - (81 - 40*y )}
			isosurface {
				function { F_Cyl(x,y,z) - .7*F_Crack(x/6,y,z/6) }
				threshold 0
				eval
				contained_by { box { <-11, -1, -11>, <11, 0, 11> } }
				scale <1,6,1>
				texture { T_Base scale 6 translate -6*y }
			}

		#else
		cone { -6*y, 11, 0, 9
			//texture { T_Base scale 6 translate -6*y }
		}
		#end
	}
	union {
		#local i=0;
		#while (i<30)
			box { <-1.5, i*.2, -1>, <1.5, i*.2+.3, i*.3> }
			#local i=i+1;
		#end
		translate -6*y - 17*z
	}
	rotate y*60
	scale <1, 1, 7/9>
	texture {
		planar
		scale 8
		translate -8*y
		warp { reset_children }
		texture_map {
			[0.2 T_Tres_Cracra]
			[0.8 T_Tres_Tres_Cracra]
		}
	}
}

#declare Balustrade = union {
	difference {
		cylinder { 1.08*y, 1.12*y, 8.95 }
		cylinder { 1.07*y, 1.13*y, 8.85 }
		box { <-1.60, 1.07, -9>, <1.60, 1.13, -8.7> rotate y*60 }
	}
	#local i= 0;
	#while (i<360)
		#if ((i<51) | (i>69))
			cylinder { 0, 1.1*y, .04
				translate -8.9*z rotate i*y
			}
		#end
		#local i=i+5;
	#end
	scale <1, 1, 7/9>
	texture { T_Tole scale .5 }
}

#declare Base_Phare = union {
	object { Base }
	object { Balustrade }
}


//===================================
//    HAUT DU PHARE
//===================================


#declare Renforts = union {

	#local r_rnd=seed(351);

	#local Un_Renfort = intersection {
		difference {
			union {
				cylinder { -.11*z, .11*z, 1 scale <.15, .3, 1> translate .15*x }
				box { <-.01, -.51,-.11>, <.15, .01,.11> }
			}
			cylinder { -.11*z, .11*z, 1 scale <.10, .2, 1> translate .15*x-.5*y }
		}
		box { <0, -.5, -.10>, <.30, 0, .10> }
		scale <2,2,1.5>
	}
	#local i=0;
	#while (i<360)
		object { Un_Renfort
			translate 3*x
			texture { T_Brique translate x*325*rand(r_rnd) }
			rotate y*i
		}
		#local i=i+15;
	#end
}


#declare Passerelle = union {
	union {
		torus { 3.6 .2 scale <1,2,1> translate y*.4 }
		cylinder { 0*y, .8*y, 3.6 }
		cylinder { .8*y, 2*y, 2.1 }
		texture { T_Corps_Phare_1 translate -28*y }
	}
	#local i= 0;
	#while (i<360)
		union {
			cylinder { 0, 1.3*y, .04}
			sphere { 0, 1 scale <.05, .01, .04> translate 1.3*y }
			translate 3.6*z rotate i*y translate .8*y
		}
		#local i=i+5;
	#end
	difference {
		cylinder { 2.10*y, 2.11*y, 3.65 }
		cylinder { 2.09*y, 2.12*y, 3.55 }
	}
	texture { T_Tole scale .3 }
}


#declare Guitoune = union {
	#local i=0;
	#while (i<360)
		union {
			sphere { 0, 1 scale <.1, .05, .1> }
			cylinder { 0, 3*y, .05 }
			sphere { 0, 1 scale <.1, .05, .1> translate y }
			sphere { 0, 1 scale <.1, .05, .1> translate 3.0*y }
			translate 2*z
			rotate y*i
		}
		box { <-1, 0, -.02>, <1, 1, .02>
			scale <2*sin(radians(15)),1,1>
			translate 2*cos(radians(15))*z
			rotate (15+i)*y
		}
		#local i=i+30;
	#end
	texture { T_Tole }
}

#declare Vitre_Guitoune = union {
	#local i=0;
	#while (i<360)
		box { <-1, 0, -.01>, <1, 2, .01> scale <2*sin(radians(15)),1,1>
			translate 2*cos(radians(15))*z + y
 			rotate (15+i)*y
		}
		#local i=i+30;
	#end
	material { M_Vitre2 }
}

#declare Toit_Guitoune = union {
	#local i=0;
	#while (i<360)
		#local tmp1 = 2*sin(radians(15));
		#local tmp2 = 2*cos(radians(15));
		union {
			cylinder { 2*y, 2*z, .1 scale <1,.5,1> }
			triangle { <-tmp1, 0, tmp2>, <tmp1, 0, tmp2>, <0, 1, 0>
				rotate 15*y
			}
			triangle { <-tmp1, 0, tmp2>, <tmp1, 0, tmp2>, <0, .5, 0>
				texture { T_Interieur_Guitoune }
				rotate 15*y
			}
			translate 3*y
 			rotate i*y
		}
		#local i=i+30;
	#end

	sphere { 0, 1 scale <.2, .1, .2>
		translate 4*y
	}
	cone { 4*y, .05, 6*y, .005 }

	
	texture { T_Tole }
}


#macro Morceau_Lentille(Rayon, Angle)
difference {
	sphere { 0, Rayon }
	cylinder { -Rayon*1.1*z, Rayon*1.1*z, Rayon*sin(Angle) }
	translate -Rayon*cos(Angle)*z
}
#end

#declare Lentille_Fresnel = intersection {
	merge {	
		#local nblent = 10;
		#local temp1 =  cos(radians(30));
		#local Rayon = 1/sin(radians(30));
		//#debug concat("Rayon = ", str(Rayon, 5, 5), "\n")
		sphere { 0, Rayon translate -Rayon*z }
		#local i = nblent-1;
		#while (i>0)
			#local Angle = acos((temp1 +(1-temp1)*i/nblent));
			//#debug concat("Angle = ", str(Angle*180/pi, 5, 5), "\n")
			Morceau_Lentille(Rayon, Angle)
			#local i=i-1;
		#end
	}
	box { <-1, -1, -.05>, <1,1,0.01> }
	bounded_by { box { <-1, -1, -.05>, <1,1,0.01> } }
	translate y 
}

#declare Lampe_Phare = union {
	object { Lentille_Fresnel scale <tan(radians(30)), tan(radians(30))*1.2, 1> translate z }
	object { Lentille_Fresnel scale <tan(radians(30)), tan(radians(30))*1.2, 1> translate z rotate y*60 }
	object { Lentille_Fresnel scale <tan(radians(30)), tan(radians(30))*1.2, 1> translate z rotate y*120 }
	object { Lentille_Fresnel scale <tan(radians(30)), tan(radians(30))*1.2, 1> translate z rotate y*180 }
	object { Lentille_Fresnel scale <tan(radians(30)), tan(radians(30))*1.2, 1> translate z rotate -y*60 }
	object { Lentille_Fresnel scale <tan(radians(30)), tan(radians(30))*1.2, 1> translate z rotate -y*120 }
	material { M_Lens }
}


#declare Haut_Phare = union {
	object { Passerelle }
	object { Guitoune translate 2*y }
#if (Detail_Phare > 2)
	object { Renforts }
	object { Vitre_Guitoune translate 2*y }
	object { Toit_Guitoune translate 2*y }
#end
#if (Detail_Phare > 4)
	object { Lampe_Phare translate 3*y }
	union {
		triangle { <0,.5,0>, <tan(radians(30)), 0, 1>, <-tan(radians(30)), 0, 1> }
		triangle { <0,.5,0>, <tan(radians(30)), 0, 1>, <-tan(radians(30)), 0, 1> rotate y*60 }
		triangle { <0,.5,0>, <tan(radians(30)), 0, 1>, <-tan(radians(30)), 0, 1> rotate y*120 }
		triangle { <0,.5,0>, <tan(radians(30)), 0, 1>, <-tan(radians(30)), 0, 1> rotate y*180 }
		triangle { <0,.5,0>, <tan(radians(30)), 0, 1>, <-tan(radians(30)), 0, 1> rotate -y*60 }
		triangle { <0,.5,0>, <tan(radians(30)), 0, 1>, <-tan(radians(30)), 0, 1> rotate -y*120 }
		texture { T_Tole }
		translate y*(3 + 2*tan(radians(30))*1.2)
	}
#end
}


//===================================
//    ASSEMBLAGE DES MORCEAUX
//===================================

#declare Phare = 

union {
	object { Corps_Principal }
	object { Haut_Phare translate y*30 }
#if (Detail_Phare > 4)
	object { Base_Phare translate y }
#end
}
	

