#include "colors.inc"
#include "cadre.inc"
#include "barre.inc"
#include "dauphin.inc"

#declare h_plafond = 250;      
#declare long_piece = 480;
#declare larg_piece = 360; 
#declare taille_carrelage = 20; 
#declare  e_mur = 20;   
#declare long_cheminee =120;
#declare larg_cheminee =40;  
#declare larg_porte = 80; 
#declare e_porte = 4;
#declare h_porte = 200;  
#declare h_chassis_fenetre = 70;
#declare h_fenetre = h_porte-h_chassis_fenetre;
#declare larg_fenetre = 120;
#declare e_fenetre = 4;
#declare h_chassis_cheminee = 120;
#declare e_chassis_cheminee = 3;   
#declare rebord_cheminee = 20;
#declare long_chassis_cheminee = long_cheminee + 2*rebord_cheminee;
#declare larg_chassis_cheminee = larg_cheminee + rebord_cheminee;
#declare h_bas_cheminee =  h_chassis_cheminee - e_chassis_cheminee;
#declare long_bas_cheminee = long_cheminee + rebord_cheminee;
#declare larg_bas_cheminee = larg_cheminee + rebord_cheminee/2;    

#declare r_miroir = 30;
     
#declare vue_scene =      
camera {
  location <300, h_chassis_cheminee+21, -110 >
  angle 40
  look_at  <240, h_chassis_cheminee+21, -50 >  
  focal_point <240, h_chassis_cheminee+21, -50 >
  aperture 0.9     
  // blur_samples 4       // fewer samples, faster to render
  blur_samples 20      // more samples, higher quality image
  }
                        

#declare vue_reflet_direct =      
camera {
  location <160, h_chassis_cheminee+21, -110 >
  //angle 40
  look_at  < 0, h_chassis_cheminee+21, -270 >
  }                      
  
#declare rase_cheminee = 
camera {
  location <300, h_chassis_cheminee+50, -40 >
  //angle 40
  look_at  <240, h_chassis_cheminee+50, -40 >
  } 
  
camera {vue_scene}

light_source { <long_piece/2, h_plafond-e_mur, -larg_piece/2> 
  rgb <255/255,234/255,168/255>
  area_light 30*x, 10*y, 12, 4 }

background { SummerSky }


//texture murs
#declare T_murs = 
  texture {
    pigment {White}
    normal  { bumps 0.3
      scale 0.2}
    finish {
      ambient 0.4
      }
    }  
                        
  
//horloge
 
object { dauphin
  translate < long_piece/2+5, h_chassis_cheminee + 1, -55 >
  }
  
//sol                               
plane { y, 0
  pigment  {checker White, SummerSky
    scale taille_carrelage
    }
  finish { ambient 0.3 phong 0.2}  
  }                               
    
//plafond
box { <-e_mur, 0, e_mur >, 
      < long_piece + e_mur, e_mur, -larg_piece - e_mur>
  translate h_plafond*y  
  pigment {White}
  finish { ambient 0.5 }  
  }   

    
// mur de la chemine  
difference {
  box { <-e_mur, 0, e_mur >, 
        < long_piece + e_mur, h_plafond,0>
    }   
  // ouverture porte  
  box { < 0, -e_mur, -e_mur>,
        < larg_porte, h_porte, 2*e_mur >
    translate 40*x
    }
  texture { T_murs }
  }

// porte 
union {    
  box { < 0, 0, 0>,
        < larg_porte, h_porte, -e_porte >
       } 
  #local bande = 20;     
  object { cadre(<bande, bande,0>,
                 < larg_porte-bande, h_porte-bande, -e_porte >,
                 1)
    }              
  translate <40, 0, e_mur>
  pigment { SummerSky } 
  finish {ambient 0.3
          phong 0.2} 
  }   

// fentre  
#declare fenetre =   
  difference {  
    #local montant = 8;
    box { <0,0,0>, < e_fenetre, h_fenetre, - larg_fenetre > }
    box { <-1,montant,-montant>, 
          < e_fenetre+1, h_fenetre-montant, (montant - larg_fenetre)/2 > }
    box { <-1,montant,-montant>, 
          < e_fenetre+1, h_fenetre-montant, (montant - larg_fenetre)/2 >
      translate -(larg_fenetre-montant)/2*z
      }
  pigment { SummerSky } 
  finish {ambient 0.3
          phong 0.2} 
    }
      
object { fenetre
  translate <-e_mur, h_chassis_fenetre, -40>
  }      

object { fenetre
  translate <-e_mur, h_chassis_fenetre, -80-larg_fenetre>
  }      
           
  
// mur oppos au mur de la chemine           
box { <-e_mur, 0, e_mur >, 
      < long_piece + e_mur, h_plafond,0>   
  translate (-larg_piece - e_mur)*z    
  texture { T_murs }
  }  
  
// mur du fond    
difference {
  box { <-e_mur, 0, e_mur >, 
        < 0, h_plafond, -larg_piece - e_mur >
    }                  
  //ouverture fenetre  
  box { < -2*e_mur, h_fenetre, -larg_fenetre >,
        < e_mur, 0, 0 >  
    translate < 0, h_chassis_fenetre, -40 >
    }
  //ouverture fenetre  
  box { < -2*e_mur, h_fenetre, -larg_fenetre >,
        < e_mur, 0, 0 >  
    translate < 0, h_chassis_fenetre, -80-larg_fenetre>
    } 
  texture { T_murs }
  }    

// mur oppos au mur du fond  
box { <-e_mur, 0, e_mur >, 
      < 0, h_plafond, -larg_piece - e_mur >
  translate (long_piece + e_mur)*x     
  texture { T_murs } 
  }           
   
//chemine  
box { < 0, 0, 0 >
      < long_cheminee, h_plafond ,-larg_cheminee>
  translate ( long_piece - long_cheminee )/2*x
  texture { T_murs }
  //pigment { Gray50}
  //finish {reflection 1}
  }

// cheminee
union {
  //bas chemine  
  box { < 0, 0, 0 >
        < long_bas_cheminee, h_bas_cheminee ,-larg_bas_cheminee>
    translate ( long_piece - long_bas_cheminee )/2*x
    }
   
  // Chassis cheminee
  union{
    #local A = < 0, 0, 0 >;
    #local B = < long_chassis_cheminee, -e_chassis_cheminee ,-larg_chassis_cheminee>;
    box { A, B } 
      object { cadre(A+(A.y+B.y)/2*y,B-(A.y+B.y)/2*y,e_chassis_cheminee*3/8) }
    translate <(long_piece - long_chassis_cheminee )/2, h_chassis_cheminee, 0>
    }
    
  texture { T_Stone17  scale 10}
  finish {ambient 0.5}
  } 


// dcors     
 
box { <0, 0, e_mur >, 
      < long_piece , h_plafond,0>           
  pigment{
    image_map{ sys "paysage.bmp"} 
    scale < h_plafond*884/598, h_plafond, 1> 
    } 
  no_shadow  
  finish { ambient 1 diffuse 0}  
  translate -100*x   
  rotate -135*y
  translate < -e_mur, 0, (-larg_piece-e_mur) >    
  } 
    
light_source { <-long_piece, h_plafond,-2* larg_piece> 
  rgb 0.75*<255/255,139/255,70/255> 
  area_light 3*y, 2*(z-x), 6, 6 
  }
 
// portrait
union {
  #local larg_portrait = 10;
  #local h_portrait = 15;
  #local bord = 0.5;   
  union {
    object { cadre (<bord,bord,0>,
                    <larg_portrait+3*bord, h_portrait+3*bord, 0>,
                    bord)
            }        
    object { cadre (<2*bord,2*bord,0>,
                    <larg_portrait+2*bord, h_portrait+2*bord, 0>,
                    bord/2)
            }
    pigment {White}
    finish { ambient 0.3 phong 0.2}        
    }  
  box {<0,0,0>, <larg_portrait, h_portrait, bord> 
    pigment{
      image_map{ sys "portrait.bmp"} 
      scale < larg_portrait, h_portrait, 1> 
      } 
    translate <2*bord,2*bord,0>
    }
  rotate <20,-25,0>
  translate <190,h_chassis_cheminee,-55>
  }    
               
     
    
// miroir  
object { barre(9) 
  scale r_miroir/16
  translate < long_piece/2, 
              h_chassis_cheminee + ( h_plafond - h_chassis_cheminee)/2,
              -larg_cheminee>
  }