#version unofficial MegaPov 0.5;

#declare SMerP = seed(1);
#include "bm_pose.inc"
#macro MerPeople(U)
  #local U1 = trace(Plage_Obj, <U.x, 10000, U.z>, -y);
  #local taille = 150+30*rand(SMerP);
  #if (U1.y > 25-taille) // Avoid drowning by numbers!
    #declare BM_Hair_On    = 0;
    #declare BM_R_Foot = 0;
    #declare BM_L_Foot = 0;
    #declare BM_R_Hand = 0;
    #declare BM_L_Hand = 0;
    #declare BM_R_Thigh_Mass = 1;
    #declare BM_L_Thigh_Mass = 1;
    #declare BM_R_Calf_Mass = 1;
    #declare BM_L_Calf_Mass = 1;
    #declare BM_Head_Mass = -1;
    #switch(int(rand(SMerP)*3))
      #case(0)
	#declare BM_PoseNo=0;
      #break
      #case(1)
	#declare BM_PoseNo=1;
      #break
      #case(2)
	#declare BM_PoseNo=6;
      #break
    #end
    #declare BM_HairStyle=0;
    #if (vlength(U1-<-4000, 500, -5000>) < 3000)
      #switch(int(rand(SMerP)*3))
	#case(0)
	  #declare Torso_IMap = "soutif-b.png"
	  #declare Abdomen_IMap = "soutif-b.png"
	#break
	#case(1)
	  #declare Torso_IMap = "soutif-n.png"
	  #declare Abdomen_IMap = "soutif-n.png"
	#break
	#case(2)
	  #declare Torso_IMap = "soutif-r.png"
	  #declare Abdomen_IMap = "soutif-r.png"
	#break
      #end
    #else
      #undef Torso_IMap
      #undef Abdomen_IMap
    #end
    Blob_Man(Female,taille)
    object {BlobMan 
      transform BMO_Foot_L
      rotate (90+30-60*rand(SMerP))*y translate U1
    }
  #else
    #declare n = n-1;
  #end
#end

#declare SMPed=seed(10);
#macro Pedalo(U)
  #local Flotteur=union{
    sphere{130*z, 5}
    cone {100*z, 15, 130*z, 5}
    cylinder{100*z, -100*z, 15}
    cone {-100*z, 15, -130*z, 5}
    sphere{-130*z, 5}
  }
  union{
    union{
      object{ Flotteur translate 70*x}
      object{ Flotteur translate -70*x}
      box{<-70, -3, -100>, <70, 3, 100>}
      cylinder{<-20, 0, -10>, <20, 0, -10>, 30}
      pigment{White}
      finish{Dull}
    }
    /*
    #if (vlength(U-<-4000, 500, -5000>) < 10000)
      #include "chaise-pose.inc"
      #declare BM_Hair_On    = 0;
      #declare BM_R_Foot = 0;
      #declare BM_L_Foot = 0;
      #declare BM_R_Hand = 0;
      #declare BM_L_Hand = 0;
      #declare BM_R_Thigh_Mass = 1;
      #declare BM_L_Thigh_Mass = 1;
      #declare BM_R_Calf_Mass = 1;
      #declare BM_L_Calf_Mass = 1;
      #declare BM_Head_Mass = -1;
      #declare BM_PoseNo=0;
      #declare BM_HairStyle=0;
    #end
    #if (vlength(U-<-4000, 500, -5000>) < 3000)
      #switch(int(rand(SMPed)*3))
	#case(0)
	  #declare Torso_IMap = "soutif-b.png"
	  #declare Abdomen_IMap = "soutif-b.png"
	#break
	#case(1)
	  #declare Torso_IMap = "soutif-n.png"
	  #declare Abdomen_IMap = "soutif-n.png"
	#break
	#case(2)
	  #declare Torso_IMap = "soutif-r.png"
	  #declare Abdomen_IMap = "soutif-r.png"
	#break
      #end
    #else
      #ifdef(Torso_IMap)
	#undef Torso_IMap
      #end
      #ifdef(Abdomen_IMap)
	#undef Abdomen_IMap
      #end
    #end
    Blob_Man(Female,165)
    object {BlobMan 
      transform BMO_Abdomen_B
      rotate x*70
      rotate 180*y
      translate <-50, 10, -50>
    }
    #if (vlength(U-<-4000, 500, -5000>) < 3000)
      #switch(int(rand(SMPed)*3))
	#case(0)
	  #declare Torso_IMap = "soutif-b.png"
	  #declare Abdomen_IMap = "soutif-b.png"
	#break
	#case(1)
	  #declare Torso_IMap = "soutif-n.png"
	  #declare Abdomen_IMap = "soutif-n.png"
	#break
	#case(2)
	  #declare Torso_IMap = "soutif-r.png"
	  #declare Abdomen_IMap = "soutif-r.png"
	#break
      #end
    #else
      #ifdef(Torso_IMap)
	#undef Torso_IMap
      #end
      #ifdef(Abdomen_IMap)
	#undef Abdomen_IMap
      #end
    #end
    Blob_Man(Female,165)
    object {BlobMan 
      transform BMO_Abdomen_B
      rotate x*70
      rotate 180*y
      translate <50, 10, -50>
    }
  */
    rotate <5*rand(SMPed), 360*rand(SMPed), 5*rand(SMPed)>
    translate U
  }
#end

#macro Mer(WAVES, GENS)
  #local PEcume=pigment{Clear}

  box {<-1000000, -100000, -100000>, <0, -1, 100000>
    hollow
    #if (WAVES = 1)
      pigment {
	granite
	pigment_map{
//	  [0.0 White]
	  [0.1 White]
//	  [0.1 Green]
	  [0.1 PEcume]
//	  [1.0 PEcume]
	}
	scale 300
      }
      finish {
	phong 1 phong_size 90 diffuse 0
	#local ref_color=rgb <.5, 1, .80>*.8;
	reflection_min .1*ref_color
	reflection_max .9*ref_color
	reflection_falloff 2
	conserve_energy
      }
      normal {granite scale 300}
      interior{
	media {
	  method 3
	  absorption .001 // Colour?
	  samples 2, 2
	}
      }
    #else
      pigment {
	granite
	pigment_map{
	  [0.0 White]
	  [0.1 White]
	  [0.1 Blue]
	  [1.0 Blue]
	}
	scale 300
      }
      normal {granite scale 300}
    #end
  }
  
  // Wavelets: close, near center of picture
  
  #declare NEAR_CENTER = 1;
  #ifdef(NEAR_CENTER)
    height_field{
      tga "wave1.tga"
      smooth
      water_level 0.55
      translate <-.5, -.5, -.5> 
      scale <500, 50, 700>
      texture {
	pigment{
	  agate turbulence 1 color_map{
	    [0.5 White]
	    [0.8 Clear]
	  }
	  scale 30
	}
	finish{ambient 1}
      }
      translate <-5400, -5, -3750>
      no_shadow
    }
  #end // def NEAR_CENTER
  height_field{
    tga "waveleft.tga"
    smooth
    water_level 0.5
    translate <-.5, -.5, -.5>
    scale <9000, 200, 1000>
    translate <-2000, 0, 100>
    pigment{
      agate turbulence 1 color_map{
	[0.5 White]
	[0.8 Clear]
      }
      scale 30
    }
    finish{ambient .5}
    rotate y*degrees(atan2(2500, 7000))
    translate <(-5000-12000)/2, 0, (-5500-3000)/2-200>
  }
  #if (GENS = 1)
    #local S = seed(0)
    #declare n = 0;
    #while (n<30)
      #local X = -5000-2000*rand(S)
      #local Z = 3000-7000*rand(S)
      MerPeople(<X, 0, Z>)
      #declare n = n+1;
    #end
    #local S = seed(60)//60
    #declare n = 0;
    #while (n<10)
      #local X = -6000-5000*rand(S)
      #local Z = 3000-7000*rand(S)
      Pedalo(<X, 0, Z>)
      #declare n = n+1;
    #end
  #end
#end

