#version unofficial MegaPov 0.5;

/*****************************************************************************
*
* 0 makes a flat beach
* 1 uses an isosurface, low memory but huge rendering time
* 2 creates an HF
*
*****************************************************************************/

#include "mchair.pov"

#macro Plage(ISO, RESOL_SOL)
  #declare Plage_Obj1=object{
    
    
    
    
    
    /******************************* FLAT **************************/
    
    
    
    #if (ISO = 0)
      box {<1000000, -1000, -100000>, <-12000, 0, 100000>}
    #end
    
    
    
    
    
    /***************************** TRUE ISOSURFACE *****************/
    
    
    
    #if (ISO = 1)
      #local Pig_GPlage=function{
	pigment{
	  bozo
	  scale <1000, 200, 1000> 
	  color_map{
	    [0 rgb 1]
	    [1 rgb 0]
	  }
	}
      }
      #local Pig_PPlage=function{
	pigment{
	  granite
	  scale <100, 10, 100> 
	  color_map{
	    [0 rgb 1]
	    [1 rgb 0]
	  }
	}
      }
      #declare Pig_Plage=function{(y-10*Pig_PPlage(x, y, z)-200*Pig_GPlage(x, y, z))/200}
	isosurface{
	  function {Pig_Plage(x, y, z)}
	  sign 1
	  threshold 0
	  method 2 max_gradient 10
	  contained_by {box{<1000000, -1000, -100000>, <-8000, 200, 100000>}}
	}
    #end
    
    
    
    
    
    /********************************* HF *******************************/
    
    
    
    #if (ISO = 2)
      #local Pig_GPlage=function{
	pigment{
	  bozo
	  translate 1
	  scale <3000, 200, 1000> 
	  color_map{
	    [0 rgb 1]
	    [1 rgb 0]
	  }
	}
      }
      #local Pig_PPlage=function{
	pigment{
	  granite
	  scale <100, 10, 100> 
	  color_map{
	    [0 rgb 1]
	    [1 rgb 0]
	  }
	}
      }
      #declare Pig_Plage=function{
	(10*Pig_PPlage(x, y, z)
	  +200*Pig_GPlage(x, y, z))
	/210
      }
      union{
	object{
	  height_field{
	    pattern RESOL_SOL, RESOL_SOL{
	      hf_gray_16
	      function {Pig_Plage(x, y, z)}
	      scale <1/20000, 1, 1/20000>
	    }
	    smooth
	  }
	  scale <20000, 400, 20000>
	  translate <-10000, -450, -10000>
	}
	plane {y, -400 rotate -2*z}
      }
    #end
    
    
    /**** TEXTURING ********************************************/
    
    
    #local TDry=texture{
      //pigment{color rgb <1.00, .95, .80>*1.4} // Dry sand
      pigment{color rgb <.97, .95, .80>*1.4} // Dry sand
      finish {phong .3 phong_size 10 ambient 0}
    }
    #local TWet=texture{
      pigment{color rgb <1.00, .95, .80>*1.0} // Wet sand
      finish {phong .3 phong_size 10 ambient 0}
    }
    #local TSuperWet=texture{
      pigment{color rgb <1.00, .95, .80>*1.0} // Super Wet sand
      normal {
	bumps bump_size 1
	scale 10
      }
      finish {
	phong .2 phong_size 1
	reflection_min .1
	reflection_max .3
	reflection_falloff 2
	conserve_energy
      }
    }
    #local TWeed=texture{
      pigment{color rgb <0.2, .5, .2>} // Seaweed
      finish {phong .3 phong_size 10 ambient 0}
    }
    #local TSable1=texture{
      bozo turbulence 1 texture_map{
	[0.0 TWeed]
	[0.5 TWeed]
	[0.6 TWet]
	[1.0 TWet]
      }
      scale .05
    }
    
    #local TEcume=texture{
      pigment{
	bozo turbulence 1 color_map{
	  [0.0 White]
	  [0.9 White]
	  [0.9 Clear]
	}
	scale .1
      }
      normal {
	bumps bump_size 1
	scale .01
      }
      finish {
	phong .6 phong_size .3
      }
    }
    
    #local dummy=0;
    
  }
  
  #declare Plage_Obj=object {
    Plage_Obj1
    translate 8000*x
    rotate 3*z
    translate -10000*x
  }
  object {
    Plage_Obj1
    texture {
      gradient y
      turbulence 0.02
      texture_map{
	[0.00 TWet]
	[0.15 TWet]
	[0.20 TEcume]
	[0.23 TEcume]
	[0.25 TSuperWet]
	[0.27 TWet]
	[0.30 TWet]
	[0.32 TSable1]
	[0.33 TWet]
	[0.35 TDry]
	[1.00 TDry]
      }
      scale 500
      translate -530*y
      rotate -3*z
    }
    translate 8000*x
    rotate 3*z
    translate -10000*x
  }
#end





/*
Cabines
*/

#declare TPBlanche=texture{
  pigment {White}
  /*pigment {
    cells color_map{
      [0 rgb <1, 1, 1.2>]
      [1 rgb <1, 1, .8>]
    }
    scale <50, 50, 10>
  }*/
  
  normal {
    crackle scallop_wave
    scale <2, 10, 2>
    bump_size .3
  }
  /*
  normal {
    cells scallop_wave
    scale <1000, 1000, 10>
    bump_size 5
  }
  */
  finish {
    //ambient 0.2
    phong .9 phong_size 1
    reflection 0.03
    brilliance 1
    //metallic
  }
}

#declare SOuvPorte = seed(35);
#declare SNumPorte = seed(0);
#macro UneCabine(P)
  union{
    box{<-50, -10, -50>, <-45, 15, -45>}
    box{< 50, -10, -50>, < 45, 15, -45>}
    box{<-50, -10,  50>, <-45, 15,  45>}
    box{< 50, -10,  50>, < 45, 15,  45>}
    box{<-50, 15, -50>, <50, 17, 50>}
    difference{
      box{<-45, 17, -45>, <45, 300, 45>}
      box{<-40, 15, -50>, <40, 215, 40>}
      box{<-100, 0, -100>, <100, 100, 100> rotate -45*z translate 280*y}
      box{<-100, 0, -100>, <100, 100, 100> rotate  45*z translate 280*y}
    }
    box {<-65, 0, -55>, <0, 2, 55> rotate  45*z translate 280*y}
    box {< 65, 0, -55>, <0, 2, 55> rotate -45*z translate 280*y}
    #local OUVERTE = 0;
    #if (P = 0) // No detail if facing opposite direction
      #local O = rand(SOuvPorte);
      #if (O > .7)
	#local OUVERTE = OCCUPE;
      #else
	#local OUVERTE = 0;
      #end
      difference{
	box{<0, 25, -1>, <-80, 215, 1>}
	box{-10, 10 rotate 45*z translate <-38, 170, 0>}
	#if (OUVERTE = 1)
	  rotate -y*(20+120*rand(SOuvPorte))
	#end
	translate <40, 0, -45>
      }
      text {
	ttf "/usr/ttfonts/winfonts/tt0191m_.ttf"
	#local numero = int(10+90*rand(SNumPorte));
	//"16"
	str(numero, 0, 0)
	0.1, 0
	pigment{
	  bozo turbulence 1 color_map{
	    [.9 Red]
	    [.9 Clear]
	  }
	  translate 1000*rand(SNumPorte)
	  scale 3
	}
	scale <40, 40, 1>
	translate <-20, 220, -45.1>
	no_shadow
      }
    #end
    texture {TPBlanche}
    rotate P*180*y
    rotate <2, 5, 2>*<rand(SNumPorte), rand(SNumPorte), rand(SNumPorte)>
  }
    #if ((OUVERTE = 1) & (rang < 5) & (col < 6) & (P = 0))
      #include "bm_pose.inc"
      #if ((rang < 2) & (col < 5))
	#declare BM_Hair_On    = 1;
	#declare BM_R_Foot = 1;
	#declare BM_L_Foot = 1;
	#declare BM_R_Hand = 1;
	#declare BM_L_Hand = 1;
	#declare BM_Head_Mass = 1;
	#declare BM_R_Thigh_Mass = 1;
	#declare BM_L_Thigh_Mass = 1;
	#declare BM_R_Calf_Mass = 1;
	#declare BM_L_Calf_Mass = 1;
	#declare BM_Nipples = 1;
      #else
	#declare BM_Hair_On    = 0;
	#declare BM_R_Foot = 0;
	#declare BM_L_Foot = 0;
	#declare BM_R_Hand = 0;
	#declare BM_L_Hand = 0;
	#declare BM_Head_Mass = -1;
      #end
      #declare BM_PoseNo=0;
      #declare BM_HairStyle=0;
      Blob_Man(Female,165)
      object {BlobMan 
	transform BMO_Foot_L rotate 10*y translate 17*y
      }
    #end
#end





#macro Corde(U1, U2)
  #local R=3;
  #local K = abs(U1.x+U1.z-U2.x-U2.z)/600;
  #local DY = abs(U1.y-U2.y);
  sphere_sweep{
    // I hope one day I'll understand what Catmull-Rom splines are!
    catmull_rom_spline_sphere_sweep,
    5
    ((U1-U2)/2)+(40*K+1.5*DY)*y, R
    U1, R
    ((U1+U2)/2)-15*K*y, R
    U2, R
    ((U2-U1)/2)+(40*K+1.5*DY)*y, R
    pigment{rgb<1, .9, .6>}
  }
#end

#macro Poteau(X, Z, P)
  #if (P=0)
    #local U1 = trace(Plage_Obj, <X-250, 10000, Z-300>, -y);
    #local U2 = trace(Plage_Obj, <X+100, 10000, Z-300>, -y);
    #local U3 = trace(Plage_Obj, <X+200, 10000, Z-300>, -y);
    #local U1Right = trace(Plage_Obj, <X+250, 10000, Z-300>, -y);
    #local U1Back = trace(Plage_Obj, <X-250, 10000, Z+300>, -y);
    #local U1Opp = trace(Plage_Obj, <X+250, 10000, Z+300>, -y);
  #else
    #local U1 = trace(Plage_Obj, <X-250, 10000, Z+300>, -y);
    #local U2 = trace(Plage_Obj, <X+100, 10000, Z+300>, -y);
    #local U3 = trace(Plage_Obj, <X+200, 10000, Z+300>, -y);
    #local U1Right = trace(Plage_Obj, <X+250, 10000, Z+300>, -y);
    #local U1Back = trace(Plage_Obj, <X-250, 10000, Z-300>, -y);
    #local U1Opp = trace(Plage_Obj, <X+250, 10000, Z-300>, -y);
  #end
  box{<-3, -10, -3>, <3, 30, 3> translate U1 texture {TPBlanche}}
  box{<-3, -10, -3>, <3, 30, 3> translate U3 texture {TPBlanche}}
  box{<-3, -10, -3>, <3, 30, 3> translate U2 texture {TPBlanche}}
  //cylinder {U1+25*y, U2+25*y, 2 pigment {Green}}
  object {Corde(U1+<-X, 25, -Z>, U2+<-X, 25, -Z>) translate <X, 0, Z>}
  //cylinder {U3+25*y, U1Right+25*y, 2 pigment {Green}}
  object {Corde(U3+<-X, 25, -Z>, U1Right+<-X, 25, -Z>) translate <X, 0, Z>}
  //cylinder {U1+25*y, U1Back+25*y, 2 pigment {Green}}
  object {Corde(U1+<-X, 25, -Z>, U1Back+<-X, 25, -Z>) translate <X, 0, Z>}
  #if (P=0)
  box{<-3, -10, -3>, <3, 30, 3> translate U1Back texture {TPBlanche}}
  box{<-3, -10, -3>, <3, 30, 3> translate U1Opp texture {TPBlanche}}
  //cylinder {U1Back+25*y, U1Opp+25*y, 2 pigment {Green}}
  object {Corde(U1Back+<-X, 25, -Z>, U1Opp+<-X, 25, -Z>) translate <X, 0, Z>}
  #end
#end





#macro Caillebotis(Z)
  #if (rang < 8)
    #local S = seed(1);
    #local X = -5500;
    #local DX=10;
    #while (X < 3000)
      #local U1 = trace(Plage_Obj, <X, 10000, Z-25>, -y);
      #local U2 = trace(Plage_Obj, <X, 10000, Z-75>, -y);
      #local U3 = trace(Plage_Obj, <X, 10000, Z-125>, -y);
      box{
	<-DX/2+1, 0, -50>, <DX/2-1, 5, 50>
	rotate -x*degrees(atan2(U1.y-U3.y, 100))
	translate U2-2*y
	#local CM=int(rand(S)*3);
	pigment {
	  P_WoodGrain4A color_map {
	    #switch(CM)
	      #case(0) M_Wood7A #break
	      #case(1) M_Wood10A #break
	      #case(2) M_Wood11A #break
	    #end
	  }
	  scale 20
	  translate z*1000*rand(S)
	  rotate 1*z
	}
      }
      #local X = X+DX;
    #end
  #end
#end





#declare SChaise=seed(0);
#macro ChaiseLongue(U)
  #if (rang < 6)
    #local U1 = trace(Plage_Obj, <U.x, 10000, U.z>, -y);
    #declare colChair=rgb<1,0.8,0.6>*0.8;      
    #local pig = int(rand(SChaise)*5);
    #switch(pig)
      #case(0)#local coul=colour Red; #break
      #case(1)#local coul=colour Yellow; #break
      #case(2)#local coul=colour Green; #break
      #case(3)#local coul=colour White; #break
      #case(4)#local coul=colour Orange; #break
    #end
    #local pig = int(rand(SChaise)*5);
    #switch(pig)
      #case(0)#local coul2=colour Red; #break
      #case(1)#local coul2=colour Yellow; #break
      #case(2)#local coul2=colour Green; #break
      #case(3)#local coul2=colour White; #break
      #case(4)#local coul2=colour Orange; #break
    #end
    #local pig = int(rand(SChaise)*5);
    #switch(pig)
      #case(0)#local coul3=colour Red; #break
      #case(1)#local coul3=colour Yellow; #break
      #case(2)#local coul3=colour Green; #break
      #case(3)#local coul3=colour White; #break
      #case(4)#local coul3=colour Orange; #break
    #end
    #local CL=object{
      MakeEasyChair(10,colChair,coul, coul2, coul3)
      #local ang = -30+60*rand(SChaise);
      rotate ang*y
      scale 10
      translate U1
    }
    object{CL}
    #if ((rang < 3) & (col < 6))
      #include "chaise-pose.inc"
	#if ((rang < 2) & (col < 5))
	  #declare BM_Hair_On    = 1;
	  #declare BM_R_Foot = 1;
	  #declare BM_L_Foot = 1;
	  #declare BM_R_Hand = 1;
	  #declare BM_L_Hand = 1;
	  #declare BM_Head_Mass = 1;
	  #declare BM_R_Thigh_Mass = 1;
	  #declare BM_L_Thigh_Mass = 1;
	  #declare BM_R_Calf_Mass = 1;
	  #declare BM_L_Calf_Mass = 1;
	  #declare Torso_IMap = "soutif-n.png"
	  #declare Abdomen_IMap = "soutif-n.png"
	#else
	  #declare BM_Hair_On    = 0;
	  #declare BM_R_Foot = 0;
	  #declare BM_L_Foot = 0;
	  #declare BM_R_Hand = 0;
	  #declare BM_L_Hand = 0;
	  #declare BM_Head_Mass = -1;
	#end
      #declare BM_PoseNo=0;
      #declare BM_HairStyle=0;
      Blob_Man(Female,165)
      object {BlobMan 
	transform BMO_Abdomen_B rotate x*70 
	#local U1 = trace(CL, <U.x, 10000, U.z>, -y);
	rotate ang*y translate U1
      }
      #undef Torso_IMap
      #undef Abdomen_IMap
    #end
  #end
#end




#include "bm_hair.inc"

#declare SServiette=seed(0);
#macro Serviette(U)
  #if (rang < 5)
    union{
      intersection{
	#local ang=-50+100*rand(SServiette);
	#if (rand(SServiette) > .5)
	  #local ang = -ang;
	#end
	box {<-50, -10000, -80>, <50, 1000, 80> rotate ang*y translate U}
	Plage_Obj
	#local pig = int(rand(SServiette)*5);
	#switch(pig)
	  #case(0)#local coul=colour Red; #break
	  #case(1)#local coul=colour Yellow; #break
	  #case(2)#local coul=colour Green; #break
	  #case(3)#local coul=colour White; #break
	  #case(4)#local coul=colour Orange; #break
	#end
	pigment {coul}
	normal {wrinkles 1 bump_size 1 scale 30}
	finish {ambient 0.3 phong 0.5 phong_size .3 metallic}
	translate .5*y
      }
      #if ((rang < 3) & (col < 6))
	#include "bm_pose.inc"
	#if ((rang < 2) & (col < 5))
	  #declare BM_Hair_On    = 1;
	  #declare BM_R_Foot = 1;
	  #declare BM_L_Foot = 1;
	  #declare BM_R_Hand = 1;
	  #declare BM_L_Hand = 1;
	  #declare BM_Head_Mass = 1;
	  #declare BM_R_Thigh_Mass = 1;
	  #declare BM_L_Thigh_Mass = 1;
	  #declare BM_R_Calf_Mass = 1;
	  #declare BM_L_Calf_Mass = 1;
	#else
	  #declare BM_Hair_On    = 0;
	  #declare BM_R_Foot = 0;
	  #declare BM_L_Foot = 0;
	  #declare BM_R_Hand = 0;
	  #declare BM_L_Hand = 0;
	  #declare BM_Head_Mass = -1;
	#end
	#local pos=int(2*rand(SServiette));
	#switch(pos)
	  #case(0)
	    #declare BM_PoseNo=8;
	    #declare BM_HairStyle=1;
	    #if ((rang < 2) & (col < 5))
	      #declare Torso_IMap = "soutif-b.png"
	      #declare Abdomen_IMap = "soutif-b.png"
	    #end
	Blob_Man(Female,165)
	object {BlobMan 
	  transform BMO_Torso_B rotate x*99 
	  #local U1 = trace(Plage_Obj, <U.x, 10000, U.z>, -y);
	  rotate (ang)*y translate U1
	}
      #break
      #case(1)
	#declare BM_PoseNo=11;
	#declare BM_HairStyle=2;
	#if ((rang < 2) & (col < 5))
	  #declare Torso_IMap = "soutif-r.png"
	  #declare Abdomen_IMap = "soutif-r.png"
	#end
	Blob_Man(Female,165)
	object {BlobMan 
	  transform BMO_Abdomen_L rotate z*-85
	  #local U1 = trace(Plage_Obj, <U.x, 10000, U.z>, -y);
	  rotate (-90+ang)*y translate U1
	}
      #break
  #end
      #undef Torso_IMap
      #undef Abdomen_IMap
#end
    }
#end
#end





#declare SParasol=seed(0);
#macro Parasol(U)
  #local U1 = trace(Plage_Obj, <U.x, 10000, U.z>, -y);
  union{
    cylinder {
      0, 150*y, 2
      pigment {White}
      finish{phong 1 phong_size 1}
    }
    union{
      #local a=0;
      #local Ybas = 110+20*rand(SParasol);
      #while (a<8)
	smooth_triangle {
	  <0, 150, 0>, <-1, -1, 0>,
	  <80, Ybas,  80*tan(pi/8)>, <-1, -1,  .3>,
	  <80, Ybas, -80*tan(pi/8)>, <-1, -1, -.3>
	  double_illuminate
	  rotate y*360/8*a
	}
	#local a = a+1;
      #end
      #local pig = int(rand(SParasol)*5);
	#switch(pig)
	  #case(0)#local coul=colour Red; #break
	  #case(1)#local coul=colour Yellow; #break
	  #case(2)#local coul=colour Green; #break
	  #case(3)#local coul=colour White; #break
	  #case(4)#local coul=colour Orange; #break
	#end
      #local pig = int(rand(SParasol)*5);
	#switch(pig)
	  #case(0)#local coul2=colour Red; #break
	  #case(1)#local coul2=colour Yellow; #break
	  #case(2)#local coul2=colour Green; #break
	  #case(3)#local coul2=colour White; #break
	  #case(4)#local coul2=colour Orange; #break
	#end
      #local pat = int(rand(SParasol)*3);
      pigment {
	#switch(pat)
	  #case(0) coul #break
	  #case(1)
	    radial color_map{
	      [0 coul][.25 coul]
	      [.25 coul2][.75 coul2]
	      [.75 coul][1 coul]
	    } frequency 4
	  #break
	  #case(2)
	    gradient y color_map{
	      [0/8 coul] [1/8 coul]
	      [1/8 coul2][2/8 coul2]
	      [2/8 coul] [3/8 coul]
	      [3/8 coul2][4/8 coul2]
	      [4/8 coul] [5/8 coul]
	      [5/8 coul2][6/8 coul2]
	      [6/8 coul] [7/8 coul]
	      [7/8 coul2][8/8 coul2]
	    }
	    scale 150-Ybas translate 150*y
	  #break
	#end
      }
    }
    rotate <-40*rand(SParasol), 20-40*rand(SParasol), 0*rand(SParasol)>
    translate U1-30*rand(SParasol)*y
  }
#end


#macro Glacier(GENS)
  #local CGlacier = rgb <1, .9, .6>;
  #local TPGlacier=texture{
    pigment {
      crackle solid color_map{
	[0 CGlacier*1.2]
	[1 CGlacier*.7]
      }
      scale <50, 50, 10>
    }
    normal {
      dents
      scallop_wave
      scale <10, 10, 10>
      bump_size .3
    }
    finish {
      ambient 0.2
      phong .9 phong_size 1
      reflection 0.03
      brilliance 1
      //metallic
    }
  }
  texture{
    pigment {
      gradient y turbulence 0.2 color_map{
	[0 rgbf <0.3, 0.4, 0.3, 0>]
	[.1 rgbf <0.3, 0.6, 0.3, 0>]
	[.3 rgbf <0.3, 0.5, 0.3, 1>]
      }
      scale <10, 300, 10>
      translate -60*y
    }
    normal {
      dents
      scallop_wave
      scale <10, 10, 10>
      bump_size .3
    }
    finish {
      ambient 0.2
      phong .9 phong_size 1
      reflection 0.03
      brilliance 1
      //metallic
    }
  }
  #local Poubelle=object {
    difference {
      union {
	intersection {
	  cone {0, 15, 50*y, 20 scale <5/20, 1, 1>}
	  box {<-10, -5, -50>, <0, 55, 50>}
	}
	intersection {
	  cone {0, 15, 50*y, 20 scale <25/20, 1, 1>}
	  box {<0, -5, -50>, <30, 55, 50>}
	}
	intersection {
	  sphere {0, 1 scale <5, 10, 20>}
	  box {<-10, 0, -50>, <0, 15, 50>}
	  translate 50*y
	}
	intersection {
	  sphere {0, 1 scale <25, 10, 20>}
	  box {<0, 0, -50>, <30, 15, 50>}
	  translate 50*y
	}
      }
      intersection {
	cone {y, 14, 50.01*y, 19 scale <4/19, 1, 1>}
	box {<-10, -5, -50>, <0, 55, 50>}
      }
      intersection {
	cone {y, 14, 50.01*y, 19 scale <24/19, 1, 1>}
	box {<0, -5, -50>, <30, 55, 50>}
      }
      intersection {
	sphere {0, 1 scale <4, 9, 19>}
	box {<-10, -0.01, -50>, <0, 15, 50>}
	translate 50*y
      }
      intersection {
	sphere {0, 1 scale <24, 9, 19>}
	box {<0, -0.01, -50>, <30, 15, 50>}
	translate 50*y
      }
      cylinder {50*y, 70*y, 1 scale <8, 1, 15> translate 15*x}
    }
    pigment {
      bozo 
      turbulence 0.2 
      #local seuil1=0.15;
      #local CPoubelle=color rgb <1, .6, 0>;
      color_map{
	[0 CPoubelle]
	[1-seuil1 CPoubelle]
	[1-seuil1 rgb <.5, .4, .3>]
	[1-seuil1*.7 rgb <.6, .5, .4>]
	[1.0 Gray50]
      }
      scale 10
      translate <3681, 3671, 617>
    }
    normal {
      dents
      turbulence 0.5
      bump_size 1
      scale 10
      translate <3681, 3671, 617>
    }
    finish {
      phong .1 phong_size 1
      brilliance 0.3
    }
  }
  //*********************************
  
  #local S = seed(0);
  union{
    object{
      difference{
	box {<-100, -30, -100>, <100, 200, 100>}
	box {<-95, -30, -95>, <95, 190, 95>}
	box {<-5, 100, -95>, <105, 170, 95>}
	box {<-95, 100, -105>, <95, 170, 105>}
      }
      texture{TPGlacier}
    }
    union{
      box {<100, 170, -95>, <170, 172, 95>}
      texture{TPGlacier}
    }
    text {
      ttf "/usr/ttfonts/winfonts/tt0191m_.ttf"
      "GLACES - ICE CREAMS"
      0.1, 0
      pigment{
	bozo turbulence 1 color_map{
	  [.9 NavyBlue]
	  [.9 Clear]
	}
	scale 3
      }
      finish {ambient .3}
      rotate -90*y
      scale <1, 30, 17>
      translate <105, 175, -95>
      no_shadow
    }
    #local Z=-50;
    #local dZ = 10;
    #while (Z <= 50)
      box {
	<99, 100, Z-dZ/2>, <50, 85, Z+dZ/2>
	pigment {rgb<.5+.5*rand(S), .5+.5*rand(S), .5+.5*rand(S)>}
	//pigment {rgb m_RGBfromhue(rand(S))}
	finish{Dull ambient 0.3}
      }
      #local Z = Z+dZ;
    #end
    union { // Vitres
      box {<0, 0, 95>, <1, 30, -95> rotate 10*z translate <98, 100, 0>}
      box {<97, 129, 95>, <77, 130, -95>}
      pigment {rgbf <1, 1, 1, 1>}
      finish {reflection 0.1}
      interior{
	ior 1.5
	media {
	  absorption rgb <0.1, 0, 0.02>
	}
      }
    }
    object {Poubelle rotate 0*y translate <105, 30, -80>}
    #local U = <-5000, 0, -4600>
    #local Uboy = U + <150, 0, -50>
    #local Umother = U + <150, 0, -30>
    #local Uman = U + <-50, 0, -30>
    #local U1 = trace(Plage_Obj, <U.x, 10000, U.z>, -y);
    rotate 30*y translate U1+20*y
  }
  height_field{
    tga "glace-masque.tga"
    //inverse
    water_level 0.5
    pigment {
      image_map{
	tga "glace.tga"
      }
      rotate 90*x
    }
    normal {bumps .1}
    finish {ambient 0.3 phong 0.3 phong_size 1}
    rotate -90*x translate -.5*x scale <100, 100*696/444, 5>
    #local U = <-5000, 0, -4600> + <150, 0, 150>
    rotate -30*y
    translate trace(Plage_Obj, <U.x, 10000, U.z>, -y)
  }
  #if(GENS = 1)
    // Small boy
    #include "boy-pose.inc"
    #declare BM_Hair_On = 1;
    #declare BM_R_Foot = 1;
    #declare BM_L_Foot = 1;
    #declare BM_R_Hand = 1;
    #declare BM_L_Hand = 1;
    #declare BM_Head_Mass = 1;
    #declare BM_R_Thigh_Mass = 1;
    #declare BM_L_Thigh_Mass = 1;
    #declare BM_R_Calf_Mass = 1;
    #declare BM_L_Calf_Mass = 1;
    #declare Abdomen_IMap = "soutif-r.png"
    #declare Thigh_R_IMap = "maillot-r.png"
    #declare Thigh_L_IMap = "maillot-r.png"
    #declare BM_PoseNo=0;
    #declare BM_HairStyle=0;
    Blob_Man(Male,110)
    #undef Abdomen_IMap
    #undef Thigh_R_IMap
    #undef Thigh_L_IMap
    object {BlobMan 
      transform BMO_Foot_L rotate y*100 
      #local U1 = trace(Plage_Obj, <Uboy.x, 10000, Uboy.z>, -y);
      translate U1
    }
    // Mother
    #include "bm_pose.inc"
    #declare BM_Hair_On = 1;
    #declare BM_R_Foot = 1;
    #declare BM_L_Foot = 1;
    #declare BM_R_Hand = 1;
    #declare BM_L_Hand = 1;
    #declare BM_Head_Mass = 1;
    #declare BM_R_Thigh_Mass = 1;
    #declare BM_L_Thigh_Mass = 1;
    #declare BM_R_Calf_Mass = 1;
    #declare BM_L_Calf_Mass = 1;
    #declare Torso_IMap = "soutif-b.png"
    #declare Abdomen_IMap = "soutif-b.png"
    #declare BM_PoseNo=0;
    #declare BM_HairStyle=1;
    Blob_Man(Female,170)
    #undef Torso_IMap
    #undef Abdomen_IMap
    object {BlobMan 
      transform BMO_Foot_L rotate y*0 
      #local U1 = trace(Plage_Obj, <Umother.x, 10000, Umother.z>, -y);
      translate U1
    }
    // Salesman
    #include "bm_pose.inc"
    #declare BM_HairStyle=-1;
    #declare BM_Hair_On = 0;
    #declare BM_R_Foot = 0;
    #declare BM_L_Foot = 0;
    #declare BM_R_Hand = 1;
    #declare BM_L_Hand = 1;
    #declare BM_Head_Mass = -1;
    #declare BM_R_Thigh_Mass = 1;
    #declare BM_L_Thigh_Mass = 1;
    #declare BM_R_Calf_Mass = 0;
    #declare BM_L_Calf_Mass = 0;
    #declare Torso_IMap = "soutif-n.png"
    #declare Abdomen_IMap = "soutif-n.png"
    #declare BM_PoseNo=1;
    Blob_Man(Male,170)
    #undef Torso_IMap
    #undef Abdomen_IMap
    object {BlobMan 
      transform BMO_Foot_L rotate -90*y 
      #local U1 = trace(Plage_Obj, <Uman.x, 10000, Uman.z>, -y);
      translate U1+20*y
    }
  #end
#end


#declare SeedOccupe = seed(0);
#macro Cabines()
  #declare rang = 0;
  #local ZMIN=-4000;
  #local ZMAX=3000;
  #local SPos=seed(5);
  #local SPosPara=seed(0);
  #local SPosServ=seed(10);
  #local Z = ZMIN;
  #local P=0;
  #while(Z < 3000)
    #local X=-5000;
    #declare col = 0;
    #while (X < 3000)
      #local X1 = X-200+400*rand(SPos);
      #if (P=0)
	#local Z1 = Z+250*rand(SPos);
      #else
	#local Z1 = Z-250*rand(SPos);
      #end
      #local o = rand(SeedOccupe);
      #declare OCCUPE = 0;
      #if (o>.1)
	#declare OCCUPE = 1;
      #end
      #local U = trace(Plage_Obj, <X1, 10000, Z1>, -y);
      union {UneCabine(P) translate U}
      #if (OCCUPE = 1)
	#local XPara=X-200+400*rand(SPosPara);
	#local ZPara=Z+50+200*rand(SPosPara)-300*(1-P);
	#local ok=0;
	#while (ok = 0)
	  #local XServ=X-200+400*rand(SPosServ);
	  #local ZServ=Z+50+200*rand(SPosServ)-300*(1-P);
	  #if ((XServ>XPara+70) | (XServ<XPara-70) | (ZServ>ZPara+100) | (ZServ<ZPara-100))
	    #local ok = 1;
	  #end
	#end
	#if(rand(SPosServ)>.2)
	  Parasol(<XPara, 0, ZPara>)
	#end
	#local siege=rand(SPosServ);
	#if ((siege>.1) & (siege<.7))
	  Serviette(<XServ, 0, ZServ>)
	#end
	#if (siege>=.7)
	  ChaiseLongue(<XServ, 0, ZServ>)
	#end
      #end
      Poteau(X, Z, P)
      #local X = X+500;
      #declare col = col +1;
    #end
    #local Z = Z+600+150*P;
    #local P = 1-P;
    #declare rang = rang + 1;
  #end
  #local Z = ZMIN;
  #declare rang = 0;
  #while (Z < ZMAX)
    Caillebotis(Z-300)
    #local Z = Z+600+600+150;
    #declare rang = rang + 2;
  #end
#end