/******************************************************************************
*
* Persistence of Vision Raytracer MegaPov version alpha 0.5a
*
* plage.pov
*
* Dessin pour G.Landfelder et IRTC.
*
******************************************************************************/

#version unofficial MegaPov 0.5;
#include "common31.inc"
#include "jv_sky.inc"
#include "plage.inc"
#include "ciel.inc"
#include "mer.inc"
#include "mur.inc"
#include "bmpeople.inc"


global_settings{
  max_trace_level 30
  adc_bailout 1/255
  assumed_gamma 2.3
  //ambient_light 0 // Pbs with clouds
  radiosity{
    always_sample    off
    pretrace_start   0.08 // HQ settings
    pretrace_end     0.02
    brightness       .3
    count            50
    error_bound      1.0
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    5
    recursion_limit  4
    adc_bailout 0.01/1
  }
}

camera {
  perspective
  up           y
  right        800/300*x
  location     <-4000, 500, -5000>
  look_at      <-8500, 500, 5000>
  angle        120
}


#declare Lights=union{
  light_source{
    <-4000, 15000, -8000>*100
    Gold*.4+Silver*.6
    parallel point_at 0
  }
  light_source{
    <4000, 500, -8000>*100
    Gold*0.1+Silver*.5
    parallel point_at 0
    shadowless
  }
}

/////////////////////////////////////////////////////////////////////

#declare TPoteaux=texture{
  pigment{White}
  finish{phong 1 phong_size .3 ambient .3}
}

#declare TBarb=texture{
  pigment {
    gradient y color_map{
      [.15 White]
      [.15 Clear]
    }
    scale 20
  }
  finish {ambient -10000}
}

#macro DigueRight(ISO)
  #if (ISO = 0)
    box {<-12000, -1000, -200>, <0, 200, 200>
      pigment {Green}
      translate 1500*z
    }
  #else
    #local Pig=function{
      pigment{
	crackle
	scale 1
	color_map{
	  [0 rgb 1]
	  [1 rgb 0]
	}
      }
    }
    #local Pig3=function{
      pigment{
	granite
	scale .1
	color_map{
	  [0 rgb 1]
	  [1 rgb 0]
	}
      }
    }
    
    #local P=4;
    #local Iso3=isosurface{
      function {0.2*(abs(x/10)^P+abs(y)^P+abs(z)^P)+0.8*Pig(x*10, y, z)}
      sign 1
      threshold 1.2
      //method 2 
      max_gradient 10
      contained_by {box{<-25, -2, -2>, <25, 2, 2>}}
      //scale .15
      rotate 45*x //translate -.5*y
    }
    
    #local T_Algues=texture{
      pigment {SeaGreen}
      normal {granite scale .01}
    }
    
    #local T_Digue=texture {
      slope y
      texture_map{
	[0.0 T_Algues]
	[0.7 T_Algues]
	[0.7 T_Stone19]
	[1.0 T_Stone19]
      }
    }
    
    object {Iso3
      scale <1000, 200, 200>
      rotate 2*z
      rotate y*degrees(atan2(400, 12000))
      translate <-12000/2, 0, 1500>
      texture {T_Digue}
    }
  #end
  union{
    #local X = 5000;
    #while (X > -8000)
      cylinder {
	0, 400*y, 25
	rotate -2*z
	translate <X, 300, 0>
	rotate 2*z
	rotate y*degrees(atan2(400, 12000))
	translate <-12000/2, 0, 1500>
      }
      #local X = X-300;
    #end
    texture{TPoteaux}
  }
  box {
    5000*x, <-8000, 700, 1>
    texture{TBarb}
    rotate 2*z
    rotate y*degrees(atan2(400, 12000))
    translate <-12000/2, 0, 1500>
  }
#end

#macro DigueLeft(ISO)
  #if (ISO = 1)
    #local Pig=function{
      pigment{
	crackle
	scale 1
	color_map{
	  [0 rgb 1]
	  [1 rgb 0]
	}
      }
    }
    #local Pig3=function{
      pigment{
	granite
	scale .1
	color_map{
	  [0 rgb 1]
	  [1 rgb 0]
	}
      }
    }
    
    #local P=4;
    #local Iso3=isosurface{
      function {0.2*(abs(x/10)^P+abs(y)^P+abs(z)^P)+0.8*Pig(x*10, y, z)}
      sign 1
      threshold 1.2
      //method 2 
      max_gradient 10
      contained_by {box{<-25, -2, -2>, <25, 2, 2>}}
      //scale .15
      rotate 45*x //translate -.5*y
    }
    
    #local T_Algues=texture{
      pigment {SeaGreen}
      normal {granite scale .01}
    }
    
    #local T_Digue=texture {
      slope y
      texture_map{
	[0.0 T_Algues]
	[0.7 T_Algues]
	[0.7 T_Stone19]
	[1.0 T_Stone19]
      }
    }
    
    object {Iso3
      scale <1500, 200, 200>
      rotate 2*z
      rotate y*degrees(atan2(2500, 7000))
      translate <(-5000-12000)/2, 0, (-5500-3000)/2-200>
      texture {T_Digue}
    } 
  #else
      sphere {
	0, 1
	scale <10, 1, 1>
	scale <7500, 300, 300>
	rotate y*degrees(atan2(2500, 7000))
	translate <-5000-12000, 0, -5500-3000>/2
	pigment {Blue}
      }
  #end
  
  union{
    #local X = 500;
    #while (X > -8000)
      cylinder {
	0, 400*y, 10
	rotate -2*z
	translate <X, 300, 0>
	rotate 2*z
	rotate y*degrees(atan2(2500, 7000))
	translate <(-5000-12000)/2, 0, (-5500-3000)/2-200>
      }
      #local X = X-300;
    #end
    texture{TPoteaux}
  }
  box {
    1000*x, <-8000, 700, 1>
    texture{TBarb}
    rotate 2*z
    rotate y*degrees(atan2(2500, 7000))
    translate <(-5000-12000)/2, 0, (-5500-3000)/2-200>
  }
#end

#macro Grille()
  #local U0 = -8000*x;
  #local U0 = vrotate(U0, y*degrees(atan2(400, 12000)));
  #local U0 = U0 + <-12000/2, 0, 1500>;
  cylinder{0, 2000*y, 20 translate U0 texture{TPoteaux} no_shadow}
  #local U1 = -8000*x;
  #local U1 = vrotate(U1, y*degrees(atan2(2500, 7000)));
  #local U1 = U1 + <(-5000-12000)/2, 0, (-5500-3000)/2-200>;
  cylinder{0, 2000*y, 20 translate U1 texture{TPoteaux} no_shadow}
  #local N = int(vlength(U1-U0)/300);
  #local n = 1;
  #while (n<N)
    #local n = n+1;
    cylinder{0, 400*y, 30 texture{TPoteaux} translate U0+(U1-U0)*n/N}
  #end
  triangle {
    -100*y, 0, <100, -50, 0>
    pigment {Green}
    normal {bumps 1 bump_size 1 translate 10 scale 100}
    finish {phong 1 phong_size 1 ambient .3}
    scale 2.5
    rotate -60*y
    translate (U0+2000*y)
  }
  triangle {
    -100*y, 0, <100, -50, 0>
    pigment {Green}
    normal {bumps 1 bump_size 1 scale 100}
    finish {phong 1 phong_size 1 ambient .3}
    scale 2.5
    rotate -60*y
    translate (U1+2000*y)}
  box {
    U0-U0.y*y, U1+z
    texture{TBarb}
    no_shadow
  }
#end





#macro Montagne()
  #local T_Arbres=texture{
    pigment {SeaGreen}
    normal {granite bump_size .3}
    finish{phong .2 phong_size 3}
  }
  #local T_Roche=texture{
    pigment {
      agate color_map{
	[0 rgb <1, .9, .8>*1.1]
	[1 rgb <1, .7, .4>]
      }
    }
    normal {granite}
  }
  object{
    height_field{
      tga "mont.tga"
      smooth
    }
    translate <-.5, -.5, -.5> 
    scale <1000000, 50000, 100000>
    texture {
      slope y
      texture_map{
	[0.0 pigment{White}]
	[0.1 pigment{White}]
	[0.1 T_Roche]//19
	[0.7 T_Roche]
	[0.7 T_Arbres]
	[1.0 T_Arbres]
      }
      scale 1000
    }
    translate <-150000, -1000, 100000>
    no_reflection
  }
#end

/////////////////////////////////////////////////////////////////////

Fog()
Montagne()
Ciel(1) // 0=basic, 1=clouds
object{Plage(2, 1000)} // 2=HF; res.
Cabines() // Requires Plage!
Glacier(1) // Requires Plage!
union {Mer(1, 1)} // 0=plain,1=water; 1=people
union {Mur(1)} // 0=plain,1=full,-1=trees,-2=lifeguards,-3=hotel,-4=phare
union {DigueLeft(1)} // Left
union {DigueRight(1)} // Right
union {Grille()}
object {Lights}
