#declare Ta=texture{ pigment{
//agate
//agate_turb 5.0
bozo
color_map   {
      [ 0.0     rgbft <0.505118, 0.536548, 0.516432, 0.0, 0.0> ]
      [ 1.0     rgbft <0.6458, 0.6458, .6, 0.0, 0.0> ]}
      turbulence 1
}
scale 10
finish{metallic
specular .1
roughness 1
//reflection .1
//phong .1
}
}

#declare Farales=
texture{
pigment{
bozo
color_map{
[0,rgb .7*.75]
[1,rgb <.7,.5,.5>*.75]}
}
finish{
specular 1
roughness .05
phong 5
phong_size 100
//reflection .1
metallic
}
normal{bumps .05 scale .1}
scale 5
}


#declare RockT = 
   material  
   {   
      texture
      {      
         pigment
         {
            granite
            color_map
            {
               [ 0.0     rgbft <0.520833, 0.520833, 0.520833, 0.0, 0.0> ]
               [ 0.875   rgbft <0.791667, 0.791667, 0.791667, 0.05, 0.0> ]
               [ 1.0     rgbft <0.791667, 0.791667, 0.791667, 0.05, 0.0> ]
            }
            turbulence 1.0
            ramp_wave
         }
      }
        interior{media{emission rgb <0.1,.1,.1>*.5}}  

   }


#declare final_ext = 
   material  // final ext
   {   
      texture
      {      
         pigment
         {
            color rgb <0.8229, 0.8229, 0.8229>
         }      
         normal
         {
            checker
            bump_size 1.0
            turbulence 0.5
            ramp_wave
         }      
         finish
         {
            ambient 0.1
            brilliance 1.729
            specular 0.705033
         }
      }
   }


//  $MRY$: 'blue fire'


#declare blue_fire = 
   material  // blue fire
   {   
      texture
      {      
         pigment
         {
            color rgbf <1.0, 1.0, 1.0, 1.0>
         }
      }   
      interior
      {
         media
         {
            emission rgbf <0.541667, 0.541667, 1.0, 0.7604>
            density
            {
               spotted
               turbulence 1.0
               ramp_wave
               scale  2.0
            }
         }
      }
   }


//  $MRY$: 'Material1'


#declare Material1 = 
   material  // Material1
   {   
      texture
      {      
         pigment
         {
            color rgb <0.8229, 0.8229, 0.8229>
         }      
         normal
         {
            checker
            bump_size 1.0
            turbulence 0.5
            ramp_wave
            scale  0.5
         }      
         finish
         {
            ambient 0.1
            brilliance 1.729
            specular 0.705033
         }
      }
   }


//  $MRY$: 'Ygold'


#declare Ygold = 
   material  // Ygold
   {   
      texture
      {      
         pigment
         {
            color rgb <0.354133, 0.354133, 0.0>
         }      
         finish
         {
            ambient 0.1
            brilliance 2.556333
            specular 1.0
            reflection 1.0
         }
      }
   }


//  $MRY$: 'yellow fire'


#declare yellow_fire = 
   material  // yellow fire
   {   
      texture
      {      
         pigment
         {
            color rgbf <1.0, 1.0, 1.0, 1.0>
         }
      }   
      interior
      {
         media
         {
            variance 1.0/7.81939
            emission rgb <1.0, 1.0, 0.0>
            density
            {
               spherical
               scale  5.0
            }
         }
      }
   }


//  $MRY$: 'white fire'


#declare white_fire = 
   material  // white fire
   {   
      texture
      {      
         pigment
         {
            color rgbf <1.0, 1.0, 1.0, 1.0>
         }
      }   
      interior
      {
         media
         {
            emission rgb <1.0, 1.0, 1.0>
         }
      }
   }


//  $MRY$: 'metalfusion'


#declare metalfusion = 
   material  // metalfusion
   {   
      texture
      {      
         pigment
         {
            color rgbf <1.0, 1.0, 0.0, 0.343733>
         }      
         normal
         {
            agate , 0.25
            agate_turb 1.0
            turbulence 0.5
            ramp_wave
            scale  0.1
         }      
         finish
         {
            ambient 0.1
            brilliance 2.857
            specular 1.0
         }
      }   
      interior
      {
         media
         {
            emission rgb <1.0, 1.0, 0.0>
         }
      }
   }


//  $MRY$: 'black'


#declare black = 
   material  // black
   {   
      texture
      {      
         pigment
         {
            color rgb <0.0, 0.0, 0.0>
         }
      }
   }


#declare BarT1 = 
   material  // BarT1
   {   
      texture
      {      
         pigment
         {
            color rgb <0.4479, 0.4479, 0.4479>
         }      
         finish
         {
            ambient 0.1
            brilliance 1.503667
            specular 1.0
            roughness 0.04
         }
      }
   }


//  $MRY$: 'BarTlight'


#declare BarTlight = 
   material  // BarTlight
   {   
      texture
      {      
         pigment
         {
            color rgbf <1.0, 1.0, 1.0, 1.0>
         }
      }   
      interior
      {
         media
         {
            emission rgb <1.0, 1.0, 1.0>
            /* no density type given.
            density
            {
            }
            */
         }
      }
   }




#declare T1=texture{Ta}//pigment{rgb 1 }}  
#declare T2=texture{Ta}//pigment{rgb .5 }}  




//---------------------------------------------
#declare B1=
box{<.5,3,0>,<-.5,3.5,-10>}

#declare EB=
union{
object{B1}
object{B1 rotate 40*y}
object{B1 rotate -40*y}
object{B1 rotate 80*y}
object{B1 rotate -80*y}}
//---------------------------------------

//support  

//plateforme

#declare Plate=
union{
difference{  
sphere{0,10 scale <2,.7,5> }  
box{<50,.5,50>,<-50,50,-50> }
//box{<50,-50,30><-50,10,50>}
texture{T2}}  
lathe {
quadratic_spline 7, <10,-50><5,-45><3,-35><2,-25><3,-10><4,-5><5,0>
texture{T1} scale<.7,1,1> translate<12,0,-19>}
lathe {
quadratic_spline 7, <10,-50><5,-45><3,-35><2,-25><3,-10><4,-5><5,0>
texture{T1} scale<.7,1,1> translate<-12,0,-19>}
}  
#declare Q=0 ; 
#declare P=15;  


#declare Veles=
union{  
cylinder{<P,-45,Q>,<P,0,Q>, 1 texture{T1}}        
cylinder{<P,-10,Q>,<P,-11,Q>,10 texture{T1}}

difference{
cylinder{<P,-11,Q>,<P,-11.5,Q>,8 texture{T1}}
cylinder{<P,-11,Q>,<P,-11.75,Q>,7 texture{T1}}
}

#declare K=6  ;
#declare Angle=30;
#declare F=0      ;

union{
#while (K>=0)

cylinder{<0,-15,0>,<0,-11,8.5>,.25 texture{T1} rotate F*y}

#declare K=K-1     ;
#declare F=F+Angle ;
#end 
translate P*x
}

cylinder{<P,-25,Q>,<P,-26,Q>,15 texture{T1}}

difference{
cylinder{<P,-26,Q>,<P,-27,Q>,10 texture{T1}}
cylinder{<P,-26,Q>,<P,-27.25,Q>,8 texture{T1}}
}

#declare K=6  ;
#declare Angle=30;
#declare F=0      ;

union{
#while (K>=0)

cylinder{<0,-35,0>,<0,-26,8.5>,.25 texture{T1} rotate F*y}

#declare K=K-1     ;
#declare F=F+Angle ;
#end 
translate P*x
}
}

#declare Veleia=
difference{
object{Veles}
box{<10,-30,50>,<-10,50,-50>}
}


//tour
#declare Tower=
difference{
union{
lathe{
cubic_spline
    7, <7,-1><6,0><4.5,3><3.9,6><3.8,9><3.9,15><4.5,16>texture{T1}}
  
lathe {linear_spline 
   4,<0,15> <5,15> <4,15.5> <0,15.25> texture{T1}}
sphere{<0,15.2,0>,3.9 texture{T1}}}  

box{<.5,0,0>,<-.5,1,-10>}
object{EB}
object{EB rotate 20*y translate 1*y}
object{EB  translate 3*y}
object{EB rotate 20*y translate 5*y}
object{EB  translate 7*y}
object{EB rotate 20*y translate 9*y}
object{EB  translate 11*y}
}  


//----------------------------------------------------------------

#declare Rock=
difference{
height_field
{
  tga "hfield1.tga"
  hollow
  
  smooth
scale 500
translate <-250,-120,0>
}
box{<7,45,-500>,<-7,30,500>}
cylinder{<0,45,-50>,<0,45,200>,7}
material{RockT}
}
   

//----------------Petits ventilateurs, position horiz sur la plate-forme

#declare Venti=

union{
difference{
superellipsoid
{<.2,.2>rotate 90*x scale<1,.2,1> translate 1*y}
cylinder{<0,-2,0>,<0,2,0>,.75}
pigment{rgb 1}}
cylinder{<0,.8,0>,<0,.6,0>,.1 pigment{rgb 1}}
cone{<0,.8,0>,.15,<0,1,0>,0 pigment{rgb 1}}
difference{
superellipsoid
{<.2,.2> scale<.9,1,.9> pigment{rgb 1}}
cylinder{<0,-2,0>,<0,2,0>,.7}
pigment{rgb 1}}}



#declare Madrasi=
union{
#declare G=17;
object{Venti finish{ambient 1 diffuse 1} translate<G,0,15>}
object{Venti finish{ambient 1 diffuse 1} translate<G,0,10>}
object{Venti finish{ambient 1 diffuse 1} translate<G,0,5>}
object{Venti finish{ambient 1 diffuse 1} translate<G,0,0>}
object{Venti finish{ambient 1 diffuse 1} translate<G,0,-5>}
object{Venti finish{ambient 1 diffuse 1} translate<G,0,-10>}
object{Venti finish{ambient 1 diffuse 1} translate<G,0,-15>}

#declare G=-17;
object{Venti finish{ambient 1 diffuse 1} translate<G,0,15>}
object{Venti finish{ambient 1 diffuse 1} translate<G,0,10>}
object{Venti finish{ambient 1 diffuse 1} translate<G,0,5>}
object{Venti finish{ambient 1 diffuse 1} translate<G,0,0>}
object{Venti finish{ambient 1 diffuse 1} translate<G,0,-5>}
object{Venti finish{ambient 1 diffuse 1} translate<G,0,-10>}
object{Venti finish{ambient 1 diffuse 1} translate<G,0,-15>}
}

//------------------------------------------------------------------------
//sur les 2 tours
#declare Window=
union{
sphere{<16,45,40>,1 pigment{rgbf <1,1,1,.7>} finish{phong 1}}
difference{
cylinder{<16,45,40.1>,<16,45,39.9>,1.01}
cylinder{<16,45,40.2>,<16,45,39.8>,1 pigment{rgb 2}}
}

difference{
cylinder{<16,45.1,40>,<16,44.9,40>,1.01}
cylinder{<16,45.2,40>,<16,44.8,40>,1 pigment{rgb 2}}
}
}

#declare Windowl=
union{
sphere{<-16,45,40>,1 pigment{rgbf <1,1,1,.7>} finish{phong 1}}
difference{
cylinder{<-16,45,40.1>,<-16,45,39.9>,1.01}
cylinder{<-16,45,40.2>,<-16,45,39.8>,1 pigment{rgb 2}}
}

difference{
cylinder{<-16,45.1,40>,<-16,44.9,40>,1.01}
cylinder{<-16,45.2,40>,<-16,44.8,40>,1 pigment{rgb 2}}
}
}

#declare Bubbles= //bulles de verre
union{
object{Window}
object{Window translate<0,-5,0>}
object{Window translate<0,-10,0>}
object{Window translate<0,-15,0>}
object{Window translate<0,-20,0>}
object{Window translate<0,-25,0>}
object{Windowl}
object{Windowl translate<0,-5,0>}
object{Windowl translate<0,-10,0>}
object{Windowl translate<0,-15,0>}
object{Windowl translate<0,-20,0>}
object{Windowl translate<0,-25,0>}
}

//------------------------------------------------------------------------------------------

#declare HStation=    //les 6 stations

union{
#declare LGHT=color rgb <1,1,.5>

superellipsoid{
<1,.75>  scale <2,2,.75> rotate<90,0,0> translate .5*y}

difference{
cone{<0,0,0>,3,<0,.5,0>,2}
cylinder{.1*y,2*y,2.25}
} 

#declare N=10  ;
#declare An=360/N;
#declare R=0  ;

#while (N>=0)
cone{<3,0,0>,.05,<2.5,2,0>,0 rotate R*y}
sphere{<2.75,.125,0>,.125 pigment{rgbf <1,1,2,1>} hollow   interior{media{emission rgb 5}}
rotate (R+An/2)*y
}
sphere{<2.7,.125,0>,.12 pigment{rgb 1} 
rotate (R+An/2)*y
}

       //lumires de la couronne des stations
light_source{  <2.1,.25,0>,color LGHT   
rotate (R)*y fade_distance 5 fade_power 1.2}
light_source{  <2.1,.25,0>,color LGHT  
rotate (R+An/4)*y fade_distance 5 fade_power 1.2}
light_source{  <2.1,.25,0>,color LGHT  
rotate (R+An/2)*y fade_distance 5 fade_power 1.2}
light_source{  <2.1,.25,0>,color LGHT   
rotate (R+3*An/4)*y fade_distance 5 fade_power 1.2}
  
  
#declare N=N-1   ;
#declare R=R+An  ;
#end


pigment{
dents
color_map{
[0,rgb .4]
[.25,rgb .25]
[.5,rgb <.4,.3,.3>]
[1,rgb .4]
}
turbulence 1}
finish{
specular .7
//roughness .1
ambient .3}
normal{radial 1 frequency 20}
scale 5}


#declare HStations=
union{
object{HStation translate<80,-50,0>}    
object{HStation translate<80,-50,60>}
object{HStation translate<80,-50,-60>}
object{HStation translate<-80,-50,0>}    
object{HStation translate<-80,-50,60>}
object{HStation translate<-80,-50,-60>}
}

#declare HStation2=
cylinder{0,1*y,3 pigment{rgb 1}
scale 5
}
  
#declare HStations2=
union{
object{HStation2 translate<80,-50,-20>}    
object{HStation2 translate<80,-50,-120>}
object{HStation2 translate<80,-50,-70>}
object{HStation2 translate<-80,-50,-20>}    
object{HStation2 translate<-80,-50,-120>}
object{HStation2 translate<-80,-50,-70>}
}

//--------------------------------------------------------------------

#declare Aranbal=   //lieu de stockage au bout des 2 tubes
union{
cone{<0,1,0>,3,0,4 pigment{rgb .4}
finish{specular .7
ambient .3}

}
#declare Jn=10  ;
#declare Ja=360/Jn;
#declare Jr=0  ;
#while (Jn>=0)
cone{<0,0,3.5>,.1,<0,5,4>,0 rotate Jr*y pigment{rgb 1}}

sphere{<0,2.5,3.75>,.1  rotate Jr*y  pigment{rgbf 1}
hollow interior{media{emission rgb <5,5,0>}}}

sphere{<0,5,4>,.1  rotate Jr*y  pigment{rgbf 1}
hollow interior{media{emission rgb <5,5,0>}}}

light_source{<3.5,1,0> rgb 2
fade_distance 5
fade_power 2
rotate (Ja/2+Jr)*y
} 

#declare Jn=Jn-1 ;
#declare Jr=Jr+Ja;
#end

superellipsoid{<1,.7> rotate 90*x scale <3,2,3>  pigment{

radial
frequency 8 
 color_map {
 [0,rgbf 1]
 [.4, rgbf 1]
 [.5,rgb 1]
 [.6,rgbf 1]
 [1,rgbf 1]
 }
 //rgb 1
}finish{phong 1 reflection .6}}

light_source{<0,1.5,0> blue 2
fade_distance 10
fade_power .5
}
scale 10
translate <0,-50,-60>
}
//----------------------------------------------------------------------


#declare Dtower=   //les 6 tourelles avec 4 lampes
union{

#declare Dtex1=
texture{
pigment{rgb .2}
finish{specular .5
reflection .5
}
}

#declare Dtex2=
texture{
pigment{rgb 0}
finish{specular .5
reflection 1
}
}

cylinder{0,50*y,3 pigment{rgb <1,1,0>}}

#declare Dn=12 ;
#declare Da=360/Dn;
#declare Dr=0  ;

#while (Dn>=0)
box{<3.2,0,.6>,<3.1,50,-.6> texture{Dtex1} rotate Dr*y}

#declare Dn=Dn-1;
#declare Dr=Dr+Da;
#end

sphere{<0,50,0>,3.1 texture{Dtex2}}

cone{<0,50,0>,.2,<30,55,0>,0 pigment{rgb 1}} 
cone{<0,50,0>,.2,<-30,55,0>,0 pigment{rgb 1}} 
cone{<0,50,0>,.2,<0,55,30>,0 pigment{rgb 1}} 
cone{<0,50,0>,.2,<0,55,-30>,0 pigment{rgb 1}} 

#declare Dlight=
material{
texture{pigment{rgbf 1}}
interior{media{emission rgb <1,1,5>}} 
}
 
sphere{<30,55,0>,.5 hollow material{Dlight}}
sphere{<-30,55,0>,.5  hollow material{Dlight}}
sphere{<0,55,30>,.5 hollow material{Dlight}}
sphere{<0,55,-30>,.5 hollow material{Dlight}}
cylinder{0,-10*y,3.5 pigment{rgb 1}}


cylinder{<0,-7,0>,<0,-10,0>,7
pigment{
bozo
color_map{
[0,rgbf 1]
[.4,rgbf 1]
[1, rgb 2]
} scale 2
turbulence 1
//rgbf 1
}
hollow
interior{media{emission rgbf .1
density{spiral1 5 turbulence 1
}
scale 10 }
} 
no_shadow}

/*
cylinder{-2*y,-10*y,5 pigment{bozo
color_map{
[0,rgbf 1]
[.5,rgbf 1]
[1, rgb 2]
}
turbulence 1
}
hollow
interior{media{emission rgb .05 density{bozo turbulence 1} }} 
no_shadow}

cylinder{0,-10*y,3.5 pigment{rgb 1}}
cylinder{-5*y,-10*y,10 pigment{bozo
color_map{
[0,rgbf 1]
[.5,rgbf 1]
[1, rgb 2]
}
turbulence 1
}
hollow
interior{media{emission rgb .05 density{bozo turbulence 1} }} 
no_shadow}

cylinder{-7.5*y,-10*y,12 pigment{bozo
color_map{
[0,rgbf 1]
[.5,rgbf 1]
[1, rgb 2]
}
turbulence 1
}
hollow
interior{media{emission rgb .05 density{bozo turbulence 1}}
}no_shadow

}*/
 translate 10*y
 scale 2
} 

#declare Dtowers=
union{
object{Dtower translate<150,0,-350>}
object{Dtower translate<-150,0,-350>}
object{Dtower translate<150,0,-250>}
object{Dtower translate<-150,0,-250>}
object{Dtower translate<150,0,-150>}
object{Dtower translate<-150,0,-150>}
translate -50*y
}

       
//-----------------------------------------------------------------------


#declare Wbase=  //base scientifique, nouvelle
        union{
union{


#declare T01 = 
      texture
      {      
         pigment
         {
            agate
            agate_turb 1.0
            color_map
            {
               [ 0.0     rgbft <0.864567, 0.864567, 0.864567, 0.0, 0.0> ]
               [ 1.0     rgbft <1.0, 1.0, 1.0, 0.0, 0.0> ]
            }
            turbulence 1
            ramp_wave
            scale  10
         }      
         finish
         {
            ambient 0.1
            diffuse 0.5
            brilliance .9
            phong_size 39.07
            specular 0.647467
            metallic 1.0
         }
         normal{agate .025 scale .1}
      }


#declare W1=
texture{
T01}

#declare W2=

material{texture{

pigment{rgbf 1}
finish{phong 1}
}

interior{media{emission rgb .25 density{spotted turbulence 1}}}
}


disc
{
  <0, .5, 0> 
  y,        
  2,       
pigment{rgb<1,1,0>}
finish{reflection 1 phong 1 metallic}
}
cone{.49*y,2,.25*y,2.25 texture{W1}}


cylinder{<2,.25,0>,<2,-1,0>,5 texture{W1}}

//////////////////////////////////////////////////
//tuyaux
cylinder{<4,0,4>,<4,1,4>,.25 texture{W1}}
cylinder{<4,.5,4>,<4,.6,4>,.35 texture{W1}}


#declare Tor1=
difference{
torus{.5,.25 texture{W1} rotate <90,-45,0>}
cylinder{0,<0,-2,0>,2}
}
#declare Tor1a=
difference{
torus{.5,.25 texture{W1} rotate <90,45,0>}
cylinder{0,<0,-2,0>,2}
}

#declare Tor2=
difference{
torus{.5,.25 texture{W1} rotate <90,-45,0>}
cylinder{0,<0,-2,0>,2}
cylinder{0,<2,-0,0>,2}
}

object{Tor1 translate<4.35,1,4.35>}
cylinder{<4.7,1,4.7><4.7,-1,4.7>.25 texture{W1}}
cylinder{<4.7,0,4.7><4.7,.1,4.7>.35 texture{W1}}

cylinder{<2.5,0,4>,<2.5,1,4>,.5 texture{W1}}
sphere{<2.5,1,4>,.5  texture{W1}}

cylinder{<2.25,.5,4>,<2.25,.5,5.5>,.1 texture{W1}}
sphere{<2.25,.5,5.5>,.1  texture{W1}}
cylinder{<2.25,.5,5.5>,<2.25,-1,5.5>,.1 texture{W1}}

cylinder{<2.5,.5,4>,<2.5,.5,5.5>,.1 texture{W1}}
sphere{<2.5,.5,5.5>,.1  texture{W1}}
cylinder{<2.5,.5,5.5>,<2.5,-1,5.5>,.1 texture{W1}}

cylinder{<2.75,.5,4>,<2.75,.5,5.5>,.1 texture{W1}}
sphere{<2.75,.5,5.5>,.1  texture{W1}}
cylinder{<2.75,.5,5.5>,<2.75,-1,5.5>,.1 texture{W1}}


object{Tor1a translate<4.35,1,-4.35>}
cylinder{<4.7,1,-4.7><4.7,-1,-4.7>.25 texture{W1}}
cylinder{<4.7,0,-4.7><4.7,.1,-4.7>.35 texture{W1}}

cylinder{<2.5,0,-4>,<2.5,1,-4>,.5 texture{W1}}
sphere{<2.5,1,-4>,.5  texture{W1}}

cylinder{<2.25,.5,-4>,<2.25,.5,-5.5>,.1 texture{W1}}
sphere{<2.25,.5,-5.5>,.1  texture{W1}}
cylinder{<2.25,.5,-5.5>,<2.25,-1,-5.5>,.1 texture{W1}}

cylinder{<2.5,.5,-4>,<2.5,.5,-5.5>,.1 texture{W1}}
sphere{<2.5,.5,-5.5>,.1  texture{W1}}
cylinder{<2.5,.5,-5.5>,<2.5,-1,-5.5>,.1 texture{W1}}

cylinder{<2.75,.5,-4>,<2.75,.5,-5.5>,.1 texture{W1}}
sphere{<2.75,.5,-5.5>,.1  texture{W1}}
cylinder{<2.75,.5,-5.5>,<2.75,-1,-5.5>,.1 texture{W1}}


//////////////////////////////////////////////////////


sphere{<0,.5,4>,1.5 texture{W1}}
sphere{<0,.5,-4>,1.5 texture{W1}}

cylinder{<0,.5,4>,<-3,.5,4>,1.5 texture{W1}}
cylinder{<0,.5,-4>,<-3,.5,-4>,1.5 texture{W1}}

#declare Vgs=30;
union{
cylinder{<0,.5,4>,<-Vgs,.5,4>,1.4 }
cylinder{<0,.5,-4>,<-Vgs,.5,-4>,1.4 }
material{W2}
hollow
}


#declare TKR=
torus
{
  1.4,
  0.2 
  pigment{rgbf 1}
  hollow
  interior{
  media{
  emission rgb <0,0,1>}}
}

#declare Vg=5;

#while (Vgs>=5)
object{TKR rotate 90*z translate<-Vgs,.5,4>}
object{TKR rotate 90*z translate<-Vgs,.5,-4>}

#declare Vgs=Vgs-Vg;
#end

difference{
union{
sphere{<4.5,.5,0>,2 texture{W1}}
cylinder{<4.5,.5,0>,<7.5,.5,0>,2 texture{W1}}
cylinder{<4.5,.5,0>,<19,.5,0>,1.9 material{W2}
hollow
}
}
plane{y,0}

}
difference{
sphere{ <29,.5,0>,10 }
box{<29,15,15>,<40,-15,-15>}
box{<45,0,15>,<0,-15,-15>}
sphere{<29,.5,0>,9.5}
texture{W1}
}
difference{
cylinder{<29,.5,0>,<33,.5,0>,10 }
cylinder{<25,.5,0>,<34,.5,0>,9.5}
box{<45,0,15>,<0,-15,-15>}   texture{W1}
}

difference{
disc
{
  <29,.5,0>  // center position
  y,         // normal vector
  10,       // outer radius
}
box{<33,-50,30>,<50,50,-50>}
box{<0,5,10>,<40,-1,20>}
box{<0,5,-10>,<40,-1,-20>}
texture{T01}
}


//////////////////////////lumires sur passerelle
#declare Ln=10;
#declare La=180/Ln;
#declare Lr=0  ;

#while (Ln>=0)
sphere{<33,0,9.5>,.25 pigment{rgbf 1} hollow interior{media{emission rgb <1,1,2>}}
rotate -Lr*x
translate .5*y
}
light_source{ <33,0,9.5> rgb <1,1,2> 
fade_distance 5
fade_power 2
rotate -Lr*x
} 

#declare Ln=Ln-1;
#declare Lr=Lr+La ;
#end

  
//light_source { <29,6,0> rgb 1}

box{<33,.5,6>,<50,0,-6> texture{W1}}   

#declare Thn=17/2;
#declare The=(50-33)/Thn ;
#declare Thx=33   ;
#while (Thn>=0)
sphere{<Thx,.5,6.1>,.25 pigment{rgbf 1} hollow interior{media{emission rgb <1,1,2>}}}
sphere{<Thx,.5,-6.1>,.25 pigment{rgbf 1} hollow interior{media{emission rgb <1,1,2>}}}
light_source{ <Thx,1,6.1> rgb <1,1,2> fade_distance 3 fade_power 1.5 }
light_source{ <Thx,1,-6.1> rgb <1,1,2> fade_distance 3 fade_power 1.5 }
  
#declare Thn=Thn-1 ;
#declare Thx=Thx+The ;
#end  

box{<50,.5,10>,<65,0,-10> texture{W1}}  

#declare Wn=3;
#declare We=4/Wn;
#declare Wf=6  ;

#while (Wn>=0)
sphere{<50,.5,Wf>,.25 pigment{rgbf 1} hollow interior{media{emission rgb <1,1,2>}}}
light_source{ <50,1,Wf> rgb <1,1,2> fade_distance 3 fade_power 1.5 }
sphere{<50,.5,-Wf>,.25 pigment{rgbf 1} hollow interior{media{emission rgb <1,1,2>}}}
light_source{ <50,1,-Wf> rgb <1,1,2> fade_distance 3 fade_power 1.5 }
#declare Wn=Wn-1;
#declare Wf=Wf+We;
#end
  
 //supprim
/*#declare Wan=3;
#declare Wae=15/Wn;
#declare Waf=50  ;

#while (Wan>=0)
sphere{<Waf,.5,10.1>,.25 pigment{rgbf 1} hollow interior{media{emission rgb <1,1,0>}}}
light_source{ <Waf,1,10.1> rgb <1,1,0> fade_distance 3 fade_power 1.5 }
sphere{<Waf,.5,-10.1>,.25 pigment{rgbf 1} hollow interior{media{emission rgb <1,1,0>}}}
light_source{ <Waf,1,-10.1> rgb <1,1,0> fade_distance 3 fade_power 1.5 }
#declare Wan=Wan-1;
#declare Waf=Waf+Wae;
#end
  */

cylinder{<65,.5,0>,<65,0,0>,15 texture{W1}}
light_source{ <65,2,0> rgb <1,1,2> fade_distance 10 fade_power 1.5 }


sphere{<64,2,-13>,.25 pigment{rgbf 1} hollow interior{media{emission rgb <1,1,2>}}no_shadow}
light_source{ <65,2,-12> rgb <1,1,2> fade_distance 3 fade_power 1.5 }
sphere{<64,2,13>,.25 pigment{rgbf 1} hollow interior{media{emission rgb <1,1,2>}}no_shadow}
light_source{ <65,2,12> rgb <1,1,2> fade_distance 3 fade_power 1.5 }

sphere{<60,2,-13>,.25 pigment{rgbf 1} hollow interior{media{emission rgb <1,1,2>}}no_shadow}
cylinder{<60,0,-12>,<60,2,-12>,.1 pigment{rgb 1}}
light_source{ <58,2,-12> rgb <1,1,2> fade_distance 3 fade_power 1.5 }
sphere{<60,2,13>,.25 pigment{rgbf 1} hollow interior{media{emission rgb <1,1,2>}}no_shadow}
cylinder{<60,0,12>,<60,2,12>,.1 pigment{rgb 1}}
light_source{ <58,2,12> rgb <1,1,2> fade_distance 3 fade_power 1.5 }

sphere{<51,2,-10>,.25 pigment{rgbf 1} hollow interior{media{emission rgb <1,1,2>}}no_shadow}
cylinder{<51,0,-10>,<51,2,-10>,.1 pigment{rgb 1}}
light_source{ <51,2,-9> rgb <1,1,2> fade_distance 3 fade_power 1.5 }
sphere{<51,2,10>,.25 pigment{rgbf 1} hollow interior{media{emission rgb <1,1,2>}}no_shadow}
cylinder{<51,0,10>,<51,2,10>,.1 pigment{rgb 1}}
light_source{ <51,2,9> rgb <1,1,2> fade_distance 3 fade_power 1.5 }


/////////////////////////////////////////////////////

cylinder{<65,1.5,14>,<65,1.5,14.5>,2 texture{W1}}
cylinder{<65,1.5,-14>,<65,1.5,-14.5>,2 texture{W1}}

difference{
sphere{<65,1.5,0>,14 texture{W1}}
sphere{<65,1.5,0>,13.5 texture{W1}}
cylinder{<65,1.5,0>,<50,15,0>,15}
}
scale 2
rotate 90*y
translate <0,-50,-150>
}


        }

//------------------------------------------------------- 



#declare BRZ=

union{

difference{
union{
cylinder{<7,0,35>,<15,0,35>,15 texture{T1}}
cylinder{<-7,0,35>,<-15,0,35>,15 texture{T1}}
}
box{<50,-.5,80>,<-50,-50,0>}

} 

difference{
union{
box{<7,7,35>,<14.99,50,60> }
box{<-7,7,35>,<-14.99,50,60> }
}
cylinder{<50,15,35>,<-50,15,35>,.2 }
cylinder{<50,20,35>,<-50,20,35>,.2 }
cylinder{<50,25,35>,<-50,25,35>,.2 }
cylinder{<50,30,35>,<-50,30,35>,.2 }
cylinder{<50,35,35>,<-50,35,35>,.2 }
cylinder{<50,40,35>,<-50,40,35>,.2 }

texture{T1}}


difference{
union{
cone{ <11,50,35>,  4,  <11,50,10>, 1.0}
cone{ <-11,50,35>,  4, <-11,50,10>, 1.0}}
box{<-30,50,0>,<30,80,50>}texture{T1}}
}
  

#declare L=
box{<.1,0,-0>,<-.1,0.01,.6> texture{T1} rotate <-0,0,10>translate .8*y}

union{
object{L }
object{L rotate 120*y}
object{L rotate 240*y}
rotate 987*y
}
#declare J=10 ;
#declare Js=1.4/J;
#declare V=-.7 ;

union{
#while (J>=0)
cylinder{<-.7,1,V>,<.7,1,V>,.01 }
cylinder{<V,1,-.7>,<V,1,.7>,.01 }

#declare J=J-1  ;
#declare V=V+Js  ;
#end
}



#declare Cannon=

union{
difference{
cone{<0,45,0>,2,<0,40,50>,3.5 pigment{rgb 1}}
cone{<0,45,-.5>,1.8,<0,40,50>,3.2 pigment{rgb 1}}
}

cylinder{<0,47,5>,<0,44,50>,.2 pigment{rgb 1}}

#declare Fy=3       ;
#declare Fz=-10*Fy   ;

union{
cylinder{<4,Fy+40,Fz+50>,<4,30,40>,.5 }
sphere{ <4,Fy+40,Fz+50>,.5}

cylinder{<-4,Fy+40,Fz+50>,<-4,30,40>,.5 }
sphere{ <-4,Fy+40,Fz+50>,.5}

cylinder{<-4.5,Fy+40,Fz+50>,<4.5,Fy+40,Fz+50>,1 }
sphere{ <4.5,Fy+40,Fz+50>,1}
sphere{ <-4.5,Fy+40,Fz+50>,1}

pigment{rgb 1}
} }

#declare Gahrans=  //2 tourelles au sommet
union{
difference{
union{
cylinder{<22.50,50,45>,<22.5,65,45>,6 }
sphere{<22.5,65,45>,6}
cylinder{<-22.50,50,45>,<-22.5,65,45>,6 }
sphere{<-22.5,65,45>,6}
texture{T1}
scale<.5,1,1> 
}  

#declare La=42 ;
#declare Ln=10  ;
#declare Lh=53 ;
#while(Ln>=0)

box{<50,Lh,La>,<-50,Lh+.25,-La>}
cylinder{<50,Lh+.125,La+2>,<-50,Lh+.125,La+2>,.25}

#declare Ln=Ln-1;
#declare Lh=Lh+1;
#end
}
//cone{<0,42.5,15>,4.5,<0,40,50>,5.5 pigment{red 1}}
union{
cylinder{<22.50,50,45>,<22.5,65,45>,5.95 }
cylinder{<-22.50,50,45>,<-22.5,65,45>,5.95 }
pigment{rgbf 1}
hollow
interior{media{emission rgb 1}}
scale<.5,1,1>
}
}

//tuyaux 

#declare Tubes=

union{
#declare U=0 ;
 union{
#declare Grt=45;
 cylinder{ <16,50.5,Grt>,<16,U,Grt>,.5}
 sphere{ <16,50.5,Grt>,.5}
 cylinder{<16,50.5,Grt>,<14,50,Grt>,.5}

#declare Grt=46;
 cylinder{ <16,50.5,Grt>,<16,U,Grt>,.5}
 sphere{ <16,50.5,Grt>,.5}
 cylinder{<16,50.5,Grt>,<14,50.5,Grt>,.5}

#declare Grt=47;
 cylinder{ <16,50.5,Grt>,<16,U,Grt>,.5}
 sphere{ <16,50.5,Grt>,.5}
 cylinder{<16,50.5,Grt>,<14,50.5,Grt>,.5}

cylinder{<16,45,45>,<16,44,45>,1}
cylinder{<16,45,47>,<16,44,47>,1}
box{<16,44,47>,<17,45,45>}

cylinder{<16,25,45>,<16,24,45>,1}
cylinder{<16,25,47>,<16,24,47>,1}
box{<16,24,47>,<17,25,45>}
 pigment{rgb 1}
 }

 union{
#declare Grt=45;
 cylinder{ <-16,50.5,Grt>,<-16,U,Grt>,.5}
 sphere{ <-16,50.5,Grt>,.5}
 cylinder{<-16,50.5,Grt>,<-14,50.5,Grt>,.5}

#declare Grt=46;
 cylinder{ <-16,50.5,Grt>,<-16,U,Grt>,.5}
 sphere{ <-16,50.5,Grt>,.5}
 cylinder{<-16,50.5,Grt>,<-14,50.5,Grt>,.5}

#declare Grt=47;
 cylinder{ <-16,50.5,Grt>,<-16,U,Grt>,.5}
 sphere{ <-16,50.5,Grt>,.5}
 cylinder{<-16,50.5,Grt>,<-14,50.5,Grt>,.5}

cylinder{<-16,45,45>,<-16,44,45>,1}
cylinder{<-16,45,47>,<-16,44,47>,1}
box{<-16,44,47>,<-17,45,45>}

cylinder{<-16,25,45>,<-16,24,45>,1}
cylinder{<-16,25,47>,<-16,24,47>,1}
box{<-16,24,47>,<-17,25,45>}
 pigment{rgb 1}
 }
}
//ascenseur
union{
box{<15,20,50>,<15.5,50,50.1>}
box{<15,20,51>,<15.5,50,51.1>}
cylinder{<16,20,50.55>,<15,50,50.55>,.05 pigment{rgb 2}}

box{<15,50,50>,<15.6,51.5,51>}
cylinder{<15.3,51.5,50>,<15.3,51.5,51>,.3}

difference{
cylinder{<15,20,49.1>,<15,20,52>,1}
box{<10,20,55>,<20,22,45>}
}
 pigment{rgb 1}}

#declare Hn=20 ; //nombre de marches
#declare Hl=.2  ;//hauteur de la marche
#declare HL=.5;//longueur de la marche
#declare Hr=.5; //largeur
#declare Hz=0; //espacement horizontal
#declare Hy=.25; //vertical
#declare Ht=19.5;
#declare Hh=48.5;

#declare Marche=box{<0,0,0>,<Hr,Hl,HL>pigment{rgb 1}} 

#while (Hn>=0)

object{Marche translate<16,Ht,Hh>}

#declare Hh=Hh-Hz;
#declare Ht=Ht-Hy;
#declare Hh=Hh-HL;
#declare Hn=Hn-1 ;
#end

#declare Aranbal2=
cylinder{<0,2,0>,0,4 pigment{rgb 1}scale 10

translate <0,-50,-60>
}

//--------------------------------------------------------
//The space transport

#declare Transport=
union{ 
 
text {   // TText002
  ttf    "C:\WINDOWS\Fonts\bnkgothm.ttf",
  "HSSV-739",
  0.1,  // Depth
  <0.0,   0.0, 0.0> // Offset
  material {
    black
  }
  scale 2.0
  rotate <35.0, 0.0, 270.0>
  translate  <-4.0, -4.0, 7.6>
}


text {   // TText001
  ttf    "C:\WINDOWS\Fonts\bnkgothm.ttf",
  "HSSV-739",
  0.1,  // Depth
  <0.0,   0.0, 0.0> // Offset
  material {
    black
  }
  scale 2.0
  rotate <35.0, 0.0, 90.0>
  translate  <4.0, -14.0, 7.6>
}



union { // gold
  cone { // Cone003
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <2.0, 2.0, 1.0>
    rotate 180.0*x
    translate  <0.0, -5.0, 9.5>
  }
  cone { // Cone002
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <2.0, 2.0, 1.0>
    rotate 180.0*x
    translate  <0.0, 10.0, 9.5>
  }
  cone { // Cone001
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <2.0, 2.0, 1.0>
    rotate 180.0*x
    translate  <0.0, 5.0, 9.5>
  }
  material {
    metalfusion
  }
  hollow
}


union { // sidelights
  sphere { // lghtg4
    <0,0,0>,1
    material {
      yellow_fire
    }
    hollow
    scale 0.5
    translate  <-5.2, -6.0, 6.0>
  }
  sphere { // lghtg3
    <0,0,0>,1
    material {
      yellow_fire
    }
    hollow
    scale 0.5
    translate  <-5.2, -3.0, 6.0>
  }
  sphere { // lghtg2
    <0,0,0>,1
    material {
      yellow_fire
    }
    hollow
    scale 0.5
    translate  <-5.2, 6.0, 6.0>
  }
  sphere { // lghtg1
    <0,0,0>,1
    material {
      yellow_fire
    }
    hollow
    scale 0.5
    translate  <-5.2, 3.0, 6.0>
  }
  sphere { // lghtg
    <0,0,0>,1
    material {
      yellow_fire
    }
    hollow
    scale 0.5
    translate  <-5.2, 0.0, 6.0>
  }
  sphere { // lght4
    <0,0,0>,1
    material {
      yellow_fire
    }
    hollow
    scale 0.5
    translate  <5.2, -6.0, 6.0>
  }
  sphere { // lght3
    <0,0,0>,1
    material {
      yellow_fire
    }
    hollow
    scale 0.5
    translate  <5.2, -3.0, 6.0>
  }
  sphere { // lght2
    <0,0,0>,1
    material {
      yellow_fire
    }
    hollow
    scale 0.5
    translate  <5.2, 6.0, 6.0>
  }
  sphere { // lght1
    <0,0,0>,1
    material {
      yellow_fire
    }
    hollow
    scale 0.5
    translate  <5.2, 3.0, 6.0>
  }
  sphere { // lght
    <0,0,0>,1
    material {
      yellow_fire
    }
    hollow
    scale 0.5
    translate  <5.2, 0.0, 6.0>
  }
}


union { // structure2
  sphere { // Sphere009
    <0,0,0>,1
    translate  <0.0, -14.0, 9.0>
  }
  cylinder { // Cylndr014
    <0,0,1>, <0,0,0>, 1 
    translate  <0.0, -14.0, 8.5>
  }
  sphere { // Sphere010
    <0,0,0>,1
    translate  <4.0, 0.0, 8.0>
  }
  cylinder { // Cylndr015
    <0,0,1>, <0,0,0>, 1 
    scale <0.125, 0.125, 10.0>
    rotate -90.0*x
    translate  <4.0, 0.0, 8.2>
  }
  sphere { // Sphere011
    <0,0,0>,1
    translate  <4.0, 10.0, 8.0>
  }
  cylinder { // Cylndr016
    <0,0,1>, <0,0,0>, 1 
    scale <0.125, 0.125, 10.0>
    rotate -90.0*x
    translate  <3.5, 0.0, 8.4>
  }
  cylinder { // Cylndr017
    <0,0,1>, <0,0,0>, 1 
    scale <0.125, 0.125, 10.0>
    rotate -90.0*x
    translate  <4.5, 0.0, 8.0>
  }
  cylinder { // Cylndr020
    <0,0,1>, <0,0,0>, 1 
    rotate -90.0*y
    translate  <-4.5, -5.0, 3.0>
  }
  cylinder { // Cylndr019
    <0,0,1>, <0,0,0>, 1 
    rotate -90.0*y
    translate  <-4.5, 0.0, 3.0>
  }
  cylinder { // Cylndr018
    <0,0,1>, <0,0,0>, 1 
    rotate -90.0*y
    translate  <-4.5, 5.0, 3.0>
  }
  material {
    Material1
  }
}


union { // structures
  box { // struct5
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 3.0, 1.0>
    translate  <-4.0, -5.0, 2.0>
  }
  box { // struct4
    <-1, -1, -1>, <1, 1, 1>
    translate  <4.0, -4.0, 1.0>
  }
  box { // struct3
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 4.0, 0.2>
    translate  <4.0, 2.0, 2.0>
  }
  box { // struct2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 1.0, 2.0>
    translate  <5.0, 0.0, 3.0>
  }
  box { // struct1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 5.0, 0.5>
    translate  <-4.0, 0.0, 1.0>
  }
  box { // struct
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 5.0, 0.2>
    translate  <4.0, 0.0, 1.0>
  }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    rotate -20.0*y
    translate  <-4.5, 0.0, 5.0>
  }
  cylinder { // Cylndr021
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 11.0>
    rotate -90.0*y
    translate  <5.5, -18.0, 1.0>
  }
  cylinder { // Cylndr022
    <0,0,1>, <0,0,0>, 1 
    scale <0.125, 0.125, 5.0>
    rotate 90.0*x
    translate  <5.5, -18.0, 0.5>
  }
  cylinder { // Cylndr023
    <0,0,1>, <0,0,0>, 1 
    scale <0.125, 0.125, 5.0>
    rotate 90.0*x
    translate  <5.5, -18.0, 1.0>
  }
  cylinder { // Cylndr024
    <0,0,1>, <0,0,0>, 1 
    scale <0.125, 0.125, 5.0>
    rotate 90.0*x
    translate  <5.5, -18.0, 1.5>
  }
  cylinder { // Cylndr025
    <0,0,1>, <0,0,0>, 1 
    scale <0.125, 0.125, 5.0>
    rotate 90.0*x
    translate  <-5.5, -18.0, 0.5>
  }
  cylinder { // Cylndr026
    <0,0,1>, <0,0,0>, 1 
    scale <0.125, 0.125, 5.0>
    rotate 90.0*x
    translate  <-5.5, -18.0, 1.0>
  }
  cylinder { // Cylndr027
    <0,0,1>, <0,0,0>, 1 
    scale <0.125, 0.125, 5.0>
    rotate 90.0*x
    translate  <-5.5, -18.0, 1.5>
  }
  cylinder { // Cylndr028
    <0,0,1>, <0,0,0>, 1 
    scale <0.75, 0.75, 11.0>
    rotate -90.0*y
    translate  <5.5, -23.0, 1.0>
  }
  material {
    Material1
  }
}


#declare dg = union {
  sphere { // Wlight3
    <0,0,0>,1
    material {
      white_fire
    }
    hollow
    scale 0.5
    translate  <7.8, -10.0, 5.0>
  }
  translate  <-16.0, 20.0, 0.0>
}
#declare CSG004 = union {
  sphere { // Wlight2
    <0,0,0>,1
    material {
      white_fire
    }
    hollow
    scale 0.5
    translate  <7.8, -10.0, 5.0>
  }
  translate  -16.0*x
}
#declare CSG003 = union {
  sphere { // Wlight1
    <0,0,0>,1
    material {
      white_fire
    }
    hollow
    scale 0.5
    translate  <7.8, -10.0, 5.0>
  }
  translate  20.0*y
}
#declare CSG002 = union {
  sphere { // Wlight
    <0,0,0>,1
    material {
      white_fire
    }
    hollow
    scale 0.5
    translate  <7.8, -10.0, 5.0>
  }
}
union { // Wlights
  object { dg }
  object { CSG004 }
  object { CSG003 }
  object { CSG002 }
}


union { // tubes
  sphere { // Sphere007
    <0,0,0>,1
    translate  <0.0, 1.5, 9.0>
  }
  cylinder { // Cylndr009
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 0.5>
    translate  <0.0, 1.5, 9.0>
  }
  cylinder { // Cylndr008
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 4.0>
    rotate -50.0*y
    translate  <5.25, 1.5, 7.0>
  }
  sphere { // Sphere006
    <0,0,0>,1
    scale 0.25
    translate  <5.25, 1.5, 7.0>
  }
  cylinder { // Cylndr007
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 7.0>
    translate  <5.25, 1.5, 0.0>
  }
  superellipsoid { // SuperQ002
    <1.0, 0.5>
    translate  <5.0, 1.5, 0.0>
  }
  cylinder { // Cylndr010
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 2.0>
    rotate -90.0*y
    translate  <2.0, 1.5, 9.6>
  }
  sphere { // Sphere008
    <0,0,0>,1
    scale 0.25
    translate  <2.1, 1.5, 9.6>
  }
  cylinder { // Cylndr013
    <0,0,1>, <0,0,0>, 1 
    scale <0.125, 0.125, 10.0>
    rotate 90.0*x
    translate  <0.5, -0.5, 9.7>
  }
  cylinder { // Cylndr012
    <0,0,1>, <0,0,0>, 1 
    scale <0.125, 0.125, 10.0>
    rotate 90.0*x
    translate  <-0.5, -0.5, 9.7>
  }
  cylinder { // Cylndr011
    <0,0,1>, <0,0,0>, 1 
    scale <0.125, 0.125, 10.0>
    rotate 90.0*x
    translate  <0.0, -0.5, 9.7>
  }
  superellipsoid { // SuperQ004
    <0.5, 0.5>
    translate  <0.0, -10.0, 9.3>
  }
  superellipsoid { // SuperQ003
    <0.5, 0.5>
    translate  <0.0, -1.0, 9.3>
  }
  material {
    Material1
  }
}


#declare TransSweep001 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  9  // control points
  <-1.0, -1.0>,
  <1.307856, -1.0>,
  <0.384289, 0.288747>,
  <-0.67157, 1.692976>,
  <-0.762357, 1.789039>,
  <-0.930361, 1.670382>,
  <-1.169851, 1.191083>,
  <-1.159236, 0.643312>,
  <-1.0, -1.0>
  rotate -x*90
  material {
    Material1
  }
  scale <2.6, 4.5, 10.0>
  rotate <-180.0, -90.0, 0.0>
  translate  <-5.0, -18.0, 2.5>
}
union { // main
  object { TransSweep001 }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    material {
      Material1
    }
    scale <5.0, 3.0, 30.0>
    rotate -90.0*x
    translate  <0.0, -14.0, 6.0>
  }
  sphere { // Sphere005
    <0,0,0>,1
    material {
      Material1
    }
    scale <5.0, 5.0, 3.0>
    translate  <0.0, -14.0, 6.0>
  }
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    material {
      Material1
    }
    hollow
    scale <5.0, 15.0, 3.0>
    translate  <0.0, 1.0, 3.0>
  }
  material {
    Material1
  }
}


union { // FB
  sphere { // Fb3
    <0,0,0>,1
    material {
      blue_fire
    }
    hollow
    scale <1.5, 3.0, 3.0>
    translate  <6.0, -10.0, 0.0>
  }
  sphere { // Fb2
    <0,0,0>,1
    material {
      blue_fire
    }
    hollow
    scale <1.5, 3.0, 3.0>
    translate  <-6.0, -10.0, 0.0>
  }
  sphere { // Fb1
    <0,0,0>,1
    material {
      blue_fire
    }
    hollow
    scale <1.5, 3.0, 3.0>
    translate  <-6.0, 10.0, 0.0>
  }
  sphere { // Fb
    <0,0,0>,1
    material {
      blue_fire
    }
    hollow
    scale <1.5, 3.0, 3.0>
    translate  <6.0, 10.0, 0.0>
  }
}


union { // direction
  sphere { // Sphere004
    <0,0,0>,1
    material {
      Material1
    }
    scale <1.5, 3.0, 3.0>
    translate  <-6.0, -10.0, 5.0>
  }
  sphere { // Sphere003
    <0,0,0>,1
    material {
      Material1
    }
    scale <1.5, 3.0, 3.0>
    translate  <6.0, -10.0, 5.0>
  }
  sphere { // Sphere002
    <0,0,0>,1
    material {
      Material1
    }
    scale <1.5, 3.0, 3.0>
    translate  <-6.0, 10.0, 5.0>
  }
  sphere { // Sphere001
    <0,0,0>,1
    material {
      Material1
    }
    scale <1.5, 3.0, 3.0>
    translate  <6.0, 10.0, 5.0>
  }
  cylinder { // IWR3
    <0,0,1>, <0,0,0>, 1 
    material {
      Material1
    }
    scale <1.5, 3.0, 5.0>
    translate  <-6.0, -10.0, 0.0>
  }
  cylinder { // IWR2
    <0,0,1>, <0,0,0>, 1 
    material {
      Material1
    }
    scale <1.5, 3.0, 5.0>
    translate  <6.0, -10.0, 0.0>
  }
  cylinder { // IWR1
    <0,0,1>, <0,0,0>, 1 
    material {
      Material1
    }
    scale <1.5, 3.0, 5.0>
    translate  <-6.0, 10.0, 0.0>
  }
  cylinder { // IWR
    <0,0,1>, <0,0,0>, 1 
    material {
      Material1
    }
    scale <1.5, 3.0, 5.0>
    translate  <6.0, 10.0, 0.0>
  }
}


union { // reactors
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1 
    material {
      Material1
    }
    scale <1.5, 1.5, 5.0>
    rotate -90.0*x
    translate  <0.0, 13.0, 7.0>
  }
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 
    material {
      Material1
    }
    scale <1.5, 1.5, 5.0>
    rotate -90.0*x
    translate  <-2.5, 13.0, 2.0>
  }
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1 
    material {
      Material1
    }
    scale <1.5, 1.5, 5.0>
    rotate -90.0*x
    translate  <2.5, 13.0, 2.0>
  }
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    material {
      Material1
    }
    scale <1.5, 1.5, 5.0>
    rotate -90.0*x
    translate  <-2.5, 13.0, 5.0>
  }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    material {
      Material1
    }
    scale <1.5, 1.5, 5.0>
    rotate -90.0*x
    translate  <2.5, 13.0, 5.0>
  }
}


union { // reactfire
  sphere { // react4
    <0,0,0>,1
    material {
      blue_fire
    }
    hollow
    scale <1.5, 3.0, 1.5>
    translate  <0.0, 17.0, 7.0>
  }
  sphere { // react3
    <0,0,0>,1
    material {
      blue_fire
    }
    hollow
    scale <1.5, 3.0, 1.5>
    translate  <-2.5, 17.0, 5.0>
  }
  sphere { // react2
    <0,0,0>,1
    material {
      blue_fire
    }
    hollow
    scale <1.5, 3.0, 1.5>
    translate  <2.5, 17.0, 5.0>
  }
  sphere { // react1
    <0,0,0>,1
    material {
      blue_fire
    }
    hollow
    scale <1.5, 3.0, 1.5>
    translate  <-2.5, 17.0, 2.0>
  }
  sphere { // react
    <0,0,0>,1
    material {
      blue_fire
    }
    hollow
    scale <1.5, 3.0, 1.5>
    translate  <2.5, 17.0, 2.0>
  }
  material {
    blue_fire
  }
}


superellipsoid { // SuperQ001
  <0.1, 0.4>
  material {
    Ygold
  }
  scale <4.5, 4.0, 1.0>
  rotate 25.0*x
  translate  <0.0, -20.0, 2.7>
}


box { // reactga3
  <-1, -1, -1>, <1, 1, 1>
  material {
    Material1
  }
  scale <1.0, 3.0, 2.5>
  translate  <-5.5, -10.0, 1.5>
}


box { // reactga2
  <-1, -1, -1>, <1, 1, 1>
  material {
    Material1
  }
  scale <1.0, 3.0, 2.5>
  translate  <5.5, -10.0, 1.5>
}


box { // reactga1
  <-1, -1, -1>, <1, 1, 1>
  material {
    Material1
  }
  scale <1.0, 3.0, 2.5>
  translate  <-5.5, 10.0, 1.5>
}


box { // reactga
  <-1, -1, -1>, <1, 1, 1>
  material {
    Material1
  }
  scale <1.0, 3.0, 2.5>
  translate  <5.5, 10.0, 1.5>
}
rotate<-100,25,10> translate <0,-30,-280>
}
//--------------------------------------------------------

#declare Arsaneth=
union{

// *******  L I G H T S *******
//

#declare FD=7;
#declare FP=1.1;

light_source {   // Light006
  <34.088, 0.000, 105.419>
  color rgb <0.000, 0.014, 1.000>*2.2854
  fade_distance  FD
  fade_power FP
}

light_source {   // Light001
  <-25.000, 0.000, 95.000>
  color rgb <0.014, 0.000, 1.000>*2.7137
  fade_distance  FD
  fade_power FP
}

light_source {   // Light005
  <20.000, -15.000, 82.000>
  color rgb <1.000, 1.000, 1.000>
  fade_distance  FD
  fade_power FP
}

light_source {   // Light004
  <20.000, 15.000, 82.000>
  color rgb <1.000, 1.000, 1.000>
  fade_distance  FD
  fade_power FP
}

light_source {   // Light003
  <35.000, 0.000, 82.000>
  color rgb <1.000, 1.000, 1.000>
  fade_distance  FD
  fade_power FP
}

light_source {   // Light002
  <5.000, 0.000, 82.000>
  color rgb <1.000, 1.000, 1.000>
  fade_distance  FD
  fade_power FP
}



//
// ********  OBJECTS  *******
//

superellipsoid { // SuperQ001
  <0.5, 0.5>
  material {
    BarT1
  }
  scale 5.0
  translate  <-24.0, 0.0, 80.0>
}


union { // lights
  sphere { // Sphere004
    <0,0,0>,1
    material {
      BarTlight
    }
    scale 0.5
    translate  <20.0, -15.0, 82.0>
  }
  sphere { // Sphere003
    <0,0,0>,1
    scale 0.5
    translate  <20.0, 15.0, 82.0>
  }
  sphere { // Sphere002
    <0,0,0>,1
    scale 0.5
    translate  <35.0, 0.0, 82.0>
  }
  sphere { // Sphere001
    <0,0,0>,1
    scale 0.5
    translate  <5.0, 0.0, 82.0>
  }
  material {
    BarTlight
  }
  no_shadow
  hollow
}


union { // upbar
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    material {
      BarT1
    }
    scale <1.0, 1.0, 50.0>
  }
  cone { // Cone005
    <0,0,0>, 1.0, <0,0,1>, 0.0
    scale <1.0, 1.0, 10.0>
    translate  50.0*z
  }
  sphere { // Sphere005
    <0,0,0>,1
    material {
      BarTlight
    }
    hollow
    rotate -80.0*y
    translate  60.0*z
  }
  sphere { // Sphere006
    <0,0,0>,1
    material {
      BarTlight
    }
    hollow
    rotate -80.0*y
  }
  sphere { // Sphere007
    <0,0,0>,1
    material {
      BarTlight
    }
    hollow
    rotate -80.0*y
  }
  material {
    BarT1
  }
  rotate 80.0*y
  translate  <-25.0, 0.0, 95.0>
}










cone { // Cone004
  <0,0,0>, 1.0, <0,0,1>, 0.0
  material {
    BarT1
  }
  scale <0.25, 0.25, 15.0>
  rotate <0.0, -90.0, 90.0>
  translate  <20.0, 0.0, 82.0>
}


cone { // Cone003
  <0,0,0>, 1.0, <0,0,1>, 0.0
  material {
    BarT1
  }
  scale <0.25, 0.25, 15.0>
  rotate <0.0, -90.0, -180.0>
  translate  <20.0, 0.0, 82.0>
}


cone { // Cone002
  <0,0,0>, 1.0, <0,0,1>, 0.0
  material {
    BarT1
  }
  scale <0.25, 0.25, 15.0>
  rotate <0.0, -90.0, -90.0>
  translate  <20.0, 0.0, 82.0>
}


cone { // Cone001
  <0,0,0>, 1.0, <0,0,1>, 0.0
  material {
    BarT1
  }
  scale <0.25, 0.25, 15.0>
  rotate -90.0*y
  translate  <20.0, 0.0, 82.0>
}


cylinder { // Cylndr003
  <0,0,1>, <0,0,0>, 1 
  material {
    BarT1
  }
  scale <0.5, 0.5, 20.0>
  translate  <20.0, 0.0, 82.0>
}


cylinder { // Cylndr002
  <0,0,1>, <0,0,0>, 1 
  material {
    BarT1
  }
  scale <0.5, 0.5, 10.0>
  translate  <-24.0, 0.0, 85.0>
}


cylinder { // Smat4
  <0,0,1>, <0,0,0>, 1 
  material {
    BarT1
  }
  scale <1.0, 1.0, 50.0>
  rotate 11.5*y
  translate  -10.0*x
}


cylinder { // Smat3
  <0,0,1>, <0,0,0>, 1 
  material {
    BarT1
  }
  scale <1.0, 1.0, 50.0>
  rotate -11.5*y
  translate  10.0*x
}


cylinder { // Smat2
  <0,0,1>, <0,0,0>, 1 
  material {
    BarT1
  }
  scale <1.0, 1.0, 50.0>
  rotate -11.5*x
  translate  -10.0*y
}


cylinder { // Smat1
  <0,0,1>, <0,0,0>, 1 
  material {
    BarT1
  }
  scale <1.0, 1.0, 50.0>
  rotate 11.5*x
  translate  10.0*y
}

cylinder { // Mat
  <0,0,1>, <0,0,0>, 1 
  material {
    BarT1
  }
  scale <1.0, 1.0, 100.0>
}
}

#declare Varandare=
union{
object{Arsaneth rotate <-90,0,0> translate<-40,-50,-20> }    
object{Arsaneth rotate <-90,0,0> translate<-40,-50,-60> }
object{Arsaneth rotate <-90,180,0> translate<40,-50,-20> }    
object{Arsaneth rotate <-90,180,0> translate<40,-50,-60> }
}

//----------------------------------------------------------------