#include "colors.inc"
#include "skies.inc"

  camera {
    location <0, 1, -4>
    look_at <0, 2, 0>
    angle 80
  }
  
  light_source { <10, 10, 10> rgb<1,1,1> }
  
sky_sphere
{
  S_Cloud4  
  
  
  scale 1
  
  
}

  plane { y, -10
    pigment {ripples color_map {[0.0 color rgb <0.2,0.35,0.8>] } turbulence 2 scale 2}
    normal { ripples turbulence 1 scale 10}
    finish { ambient .3 diffuse 0.7 reflection 0.52}
  }
  
sphere { 0,2.5
texture {
pigment { color rgb<1,1,1> }              
normal { waves turbulence 12 scale 5 }
finish { ambient 0.45 reflection 0 diffuse 0.5  }

}
translate <0,25,25>
} 


#declare star =union {
sphere { 0,0.7   }
cone   { 1.9*y,  0.0, 0.5*y, 0.3 }
cone   { -1.9*y,  0.0, -0.5*y, 0.3 }
cone   { 1.9*x,  0.0, 0.5*x, 0.3 }
cone   { -1.9*x,  0.0,-0.5*x, 0.3 }
//translate <0,3,10> 
pigment { color rgb<1,1,1> }
finish  { specular 1000 ambient 0.56 diffuse 0}
}

object { star rotate z*5 rotate x*10 translate <10,25,75> }
object { star rotate z*45 translate <20,45,75> }
object { star rotate z*30 translate <-40,55,75> }
object { star rotate z*20 translate <25 ,15,85> }
// create a TrueType text shape
text
{
  ttf             // font type (only TrueType format for now)
  "timrom.ttf",  // Microsoft Windows-format TrueType font file name
  "2000 Oops",      // the string to create
  0.05,              // the extrusion depth
  0               // inter-character spacing
  pigment { color White }
  scale 0.15
  translate <1.5,0,-0.85>
}



                                                 
fog { 
fog_type 2 distance 500 color rgb 1//rgb <0.2,0.35,0.8>
fog_offset 2 fog_alt 1
up y
}
