#version unofficial MegaPov 0.5;

#declare Couleurs1 = 
      color_map
      {
         [ 0.0     rgbft <1.0, 1.0, 1.0,                0.5, 0.0> ]
         [ 0.2     rgbft <0.68554, 0.639375, 0.43946,   0.3, 0.0> ]
         [ 0.4     rgbft <0.709194, 0.599041, 0.457472, 0.5, 0.0> ]
         [ 0.6     rgbft <0.814853, 0.769486, 0.711181, 0.3, 0.0> ]
         [ 0.8     rgbft <0.424531, 0.390284, 0.346269, 0.0, 0.0> ]
         [ 1.0     rgbft <0.266578, 0.224704, 0.170889, 0.0, 0.0> ]
      }


#declare Couleurs2 = 
   color_map
   {
      [ 0.0     rgbft <0.707322, 0.146811, 0.146811, 0.0, 0.0>*1.2 ]
      [ 0.142857  rgbft <0.956597, 0.956597, 0.210069, 0.2, 0.0>*1.2 ]
      [ 0.285714  rgbft <1.0, 0.710925, 0.229133, 0.0, 0.0>*1.5 ]
      [ 0.428571  rgbft <0.796294, 0.155153, 0.057839, 0.0, 0.0>*1.2 ]
      [ 0.571429  rgbft <0.956597, 0.956597, 0.210069, 0.5, 0.0> ]
      [ 0.714286  rgbft <0.911021, 0.446037, 0.234779, 0.0, 0.0>*1.2 ]
      [ 0.857143  rgbft <1.0, 0.125, 0.125, 0.0, 0.0>*1.5 ]
      [ 1.0     rgbft <0.956597, 0.956597, 0.210069, 0.3, 0.0> ]
   }


#declare Pig02 = 
   pigment
   {
      bozo
      color_map
      {
    Couleurs1
      }
      turbulence 0.5
      omega .8
      sine_wave   
      scale 2
   }


//======================= BLOB

#declare coff=2; 
#declare Corps_Poisson =
blob {
threshold .6

sphere {<0,.8,-3.5>,.4*coff,1}
sphere {<0,.8,-3>,.5*coff,1}
sphere {<0,.7,-2.5>,.7*coff,1}
sphere {<0,.7,-2>,1.0*coff,1}
sphere {<0,.7,-1.5>,1.0*coff,1}

sphere {<0,.5,-1.1>,1.6*coff,1}//joue

sphere {<0,1.2,1>,2.3*coff,1}
sphere {<0,1,2>,1.0*coff,1}
sphere {<0,2,2>,.5*coff,1}
sphere {<0,1.5,3>,1.0*coff,1}
sphere {<0,1.2,4>,0.9*coff,1}
sphere {<0,1.3,5>,0.8*coff,1}

cylinder {<0,1.3,5.5>,<0,1.1,7.2>,0.5*coff,1}

scale <.3,1,1>  
}

//======================= MACROS

#macro SplineFromArray (PtArr)  //cre une "spline type 2"  partir d'un array
#local NbP = dimension_size(PtArr,1);
spline {cubic_spline 
             -.1,PtArr[0]
          #local I=0;
          #while (I < NbP)
           ((I+1)/NbP),PtArr[I],
          #local I=I+1;
          #end  
           1.1,PtArr[NbP-1]    
        }
#end


#macro ExtractFromArray (PtArr)  //extrait sequentiellement les valeurs d'un array
#local NbP = dimension_size(PtArr,1);
          #local I=0;
          #while (I < NbP)
           PtArr[I]
          #local I=I+1;
          #end
#end

#macro Follow3DSpline (Spl_Indent,Step,Start_Rad,End_Rad,XMap)
  #local TempoSpline =  SplineFromArray (Spl_Indent)
  #local Rad_Step = (Start_Rad - End_Rad) / (1/Step);
  #local Actu_Rad = Start_Rad;
  #local I=0.0;   
  union {
          #while (I < 1-Step)
            cone {TempoSpline(I+Step), Actu_Rad,
                  TempoSpline(I)+.001, Actu_Rad - Rad_Step   
                  //pigment {rgb eval_pigment (Pig02,<XMap,I,0>)+<.2,.2,.2>}
                  }  
            #local Actu_Rad = Actu_Rad - Rad_Step;
          #local I=I+Step;
          #end   
  }
#end

//======================= DEFINITION DES SPLINES

#declare Spline1 = array [4] {<0,3.2,0>,<0,3.2,2>,<0,2.5,4>,<0,1.8,6>}
#declare Spline2 = array [4] {<0,4,.8>,<0,3.5,3>,<0,3,4>,<0,1.8,6>}
#declare Spline3 = array [4] {<.2,4.75*1.2,1>,<-.1,4,4>,<0,3,5>,<0,1.8,6>}

#init_3d_spline {"SplineB1",natural,ExtractFromArray (Spline1)}
#init_3d_spline {"SplineB2",natural,ExtractFromArray (Spline2)}
#init_3d_spline {"SplineB3",natural,ExtractFromArray (Spline3)}

#declare Spline4 = array [4] {<0,-1,1.5>,<0,-.3,3>,<0,.3,5>,<0,.8,6.8>}
#declare Spline5 = array [4] {<0,-1.2,2>,<0,-.5,4>,<0,0,5>,<0,.8,6.8>}
#declare Spline6 = array [4] {<0,-1.5,2.5>,<0,-.8,4>,<0,0,6>,<0,.8,6.8>}

#init_3d_spline {"SplineB4",natural,ExtractFromArray (Spline4)}
#init_3d_spline {"SplineB5",natural,ExtractFromArray (Spline5)}
#init_3d_spline {"SplineB6",natural,ExtractFromArray (Spline6)}

#declare Spline7 = array [3] {<.1,1.6,7>,<0,1,7.5>,<0,.75,7>}
#declare Spline8 = array [3] {<-.2,0,10>,<0,1,9.5>,<0,2,10>}
#declare Spline9 = array [4] {<.1,0,12>,<-.5,1,11.5>,<0,1.8,12>,<1.5,2.5,14>}

#init_3d_spline {"SplineB7",natural,ExtractFromArray (Spline7)}
#init_3d_spline {"SplineB8",natural,ExtractFromArray (Spline8)}
#init_3d_spline {"SplineB9",natural,ExtractFromArray (Spline9)}

#declare Spline10 = array [3] {<0,0,0>,<0,0,.5>,<.3,-.1,.1>}
#declare Spline11 = array [3] {<1.6,.5,.5>,<1.6,.4,.3>,<1.5,.5,.4>}
#declare Spline12 = array [3] {<2.2,.75,2>,<2,1.3,2.5>,<2.3,.75,2.8>}

#init_3d_spline {"SplineB10",natural,ExtractFromArray (Spline10)}
#init_3d_spline {"SplineB11",natural,ExtractFromArray (Spline11)}
#init_3d_spline {"SplineB12",natural,ExtractFromArray (Spline12)}

#declare Essai = union {
   Follow3DSpline (Spline10,.01,.1,.1,0) 
   Follow3DSpline (Spline11,.01,.1,.1,0) 
   Follow3DSpline (Spline12,.01,.1,.1,0) 
   pigment {Green}
   }

//======================= PLACEMENT DES NAGEOIRES

#declare Nb1 = .035; //longueur des segments d'un 'brin' (1/x)
#declare Nb2 = .06;  //radius de dpart
#declare Nb3 = .008; //radius d'arrive
#declare Nb4 = .025; //intervalle entre deux "brins" (1/x)

#declare Nageoire_Dos = union {
#declare A=0;
#while (A < 1)          
  #declare A1 = eval_3d_spline ("SplineB1",A);
  #declare A2 = eval_3d_spline ("SplineB2",A);
  #declare A3 = eval_3d_spline ("SplineB3",A);
  
  #declare SplineA = array [3]{A1,A2,A3}
  object {
  Follow3DSpline (SplineA,Nb1,Nb2,Nb3,0)
  }
#declare A = A + Nb4/1.5;
#end  
}


#declare Nageoire_Ventre = union {
#declare A=0;
#while (A < 1)          
  #declare A1 = eval_3d_spline ("SplineB4",A);
  #declare A2 = eval_3d_spline ("SplineB5",A);
  #declare A3 = eval_3d_spline ("SplineB6",A);
  
  #declare SplineA = array [3]{A1,A2,A3}
  object {
  Follow3DSpline (SplineA,Nb1,Nb2,Nb3,0)
  }
#declare A = A + Nb4/1.5;
#end
}

#declare Nageoire_Queue = union {
#declare A=0;
#while (A < 1)          
  #declare A1 = eval_3d_spline ("SplineB7",A);
  #declare A2 = eval_3d_spline ("SplineB8",A);
  #declare A3 = eval_3d_spline ("SplineB9",A);
    
  #declare SplineA = array [3]{A1,A2,A3}
  object {
  Follow3DSpline (SplineA,Nb1,Nb2*3,Nb3*3,0)
  }
#declare A = A + Nb4*4;
#end
translate z*-1}



#declare Nageoire_Laterale = union {
#declare A=0;
#while (A < 1)          
  #declare A1 = eval_3d_spline ("SplineB10",A);
  #declare A2 = eval_3d_spline ("SplineB11",A);
  #declare A3 = eval_3d_spline ("SplineB12",A);
  
  #declare SplineA = array [3]{A1,A2,A3}
  object {
  Follow3DSpline (SplineA,Nb1,Nb2,Nb3,0)
  }
#declare A = A + Nb4*4;
#end    
translate y*1
}

#declare Noeil = union {
torus {.5,.05 pigment {Black} rotate z*90}
sphere {0,.5 pigment {rgbft <.8,1,.9,1.2,.2>} interior {ior 1.5}}
sphere {0,.3 pigment {Black}}
scale <.3,1,1>
}

#declare Poisson_Complet = union {
object {Corps_Poisson}
object {Noeil rotate <0,5,5> translate <.3,1.4,-2.5>}
object {Noeil rotate <0,5,5> translate <.3,1.4,-2.5> scale <-1,1,1>}
object {Nageoire_Dos}
object {Nageoire_Ventre}
object {Nageoire_Queue}
object {Nageoire_Laterale}
object {Nageoire_Laterale scale <-1,1,1>}
}
    
#declare Poisson_InComplet = union {
object {Corps_Poisson}
object {Noeil rotate <0,5,5> translate <.3,1.4,-2.5>}
object {Noeil rotate <0,5,5> translate <.3,1.4,-2.5> scale <-1,1,1>}
object {Nageoire_Dos}
//object {Nageoire_Ventre}
object {Nageoire_Queue}
//object {Nageoire_Laterale}
//object {Nageoire_Laterale scale <-1,1,1>}
}    
//object {Poisson_Complet rotate y*180}
