#version unofficial MegaPov 0.5;
#include "metals.inc"
#declare Bois_01 = 
 texture {   
      pigment {
         wood  color_map
         {
            [ 0.0     rgbft <0.46875, 0.316387, 0.28125, 0.0, 0.0> ]
            [ 0.2     rgbft <0.605792, 0.402346, 0.321275, 0.0, 0.0> ]
            [ 0.4     rgbft <0.82991, 0.537797, 0.31069, 0.0, 0.0> ]
            [ 0.6     rgbft <0.648425, 0.457965, 0.414042, 0.0, 0.0> ]
            [ 0.8     rgbft <0.862422, 0.569838, 0.438328, 0.0, 0.0> ]
            [ 1.0     rgbft <0.899083, 0.593766, 0.45505, 0.0, 0.0> ]
         }
         turbulence 0.0094
         ramp_wave
         scale  0.05
         rotate    <-10.0, -30.0, -20.0>
         translate    <10.0, 10.0, 10.0>
      }
   }
   texture
   {   
      pigment
      {
         wrinkles
         color_map
         {
            [ 0.0     rgbft <0.333633, 0.187167, 0.223783, 0.0, 0.364567> ]
            [ 0.25    rgbft <0.72395, 0.388025, 0.27605, 0.0, 0.416667> ]
            [ 0.5     rgbft <0.845052, 0.527124, 0.279948, 0.0, 0.3854> ]
            [ 0.75    rgbft <0.689744, 0.370738, 0.122723, 0.0, 0.677067> ]
            [ 1.0     rgbft <0.663066, 0.514728, 0.399401, 0.0, 1.0> ]
         }
      }   
      finish
      {
         specular 0.40567
      }
   }
   texture
   {   
      pigment
      {
         waves
         color_map
         {
            [ 0.0     rgbft <0.707975, 0.43878, 0.229492, 0.0, 0.739567> ]
            [ 0.2     rgbft <0.850473, 0.713979, 0.60786, 0.0, 1.0> ]
            [ 0.4     rgbft <0.426427, 0.255536, 0.198573, 0.135417, 0.5677> ]
            [ 0.6     rgbft <0.322957, 0.195092, 0.16661, 0.203125, 0.0> ]
            [ 0.8     rgbft <0.426427, 0.255536, 0.198573, 0.135417, 0.5677> ]
            [ 1.0     rgbft <0.850473, 0.713979, 0.60786, 0.0, 1.0> ]
         }
         turbulence 1.0
         ramp_wave
         scale  0.1  
         rotate <40,20,60>
      }   
      finish
      {
         ambient 0.1
         phong 0.7964       
         phong_size 25
         reflection .05
      }
   }



#declare OldPlast = 
   texture
   {   
      pigment
      {
         bozo
         color_map
         {
            [ 0.0     rgbft <1.0, 0.960917, 0.791667, 0.0, 0.0> ]
            [ 1.0     rgbft <0.94249, 0.924984, 0.849177, 0.0, 0.0> ]
         }
      }   
      finish
      {
         ambient 0.1
         phong 0.165467
         specular 0.1151
      }
   }


#declare Caisse1=union {
cylinder {<0,0,-15>,<-30,0,-15>,4}
cylinder {<0,0,+15>,<-30,0,+15>,4}
box {<0,15,-15>,<-30,-4,15>}
cylinder {<0,20,-10>,<-30,20,-10>,4}
cylinder {<0,20,+10>,<-30,20,+10>,4}

#declare L1 = sqrt (25 + 400)
box {<0,0,4>,<-30,L1,-4> rotate x*degrees (atan2 (5/20,1)) translate z*-15}
box {<0,0,4>,<-30,L1,-4> rotate x*-degrees (atan2 (5/20,1)) translate z*15}  

#declare B=10; #declare C=20; #declare A = sqrt (B*B + C*C);
#declare D = A+4; #declare F =(A*D)/C;
#declare Ang1 = degrees (atan2 (C/B,1));

intersection {
cylinder {<-0.01,20-C,0>,<-30,20-C,0>,D}
plane {y,0 rotate x*Ang1 translate y*(20-C) inverse} 
plane {y,0 rotate x*-Ang1 translate y*(20-C) inverse} 
}
}

#declare Caisse2=union {         
#declare Ep1 = 3;
cylinder {<0,0,-15>,<-30,0,-15>,Ep1}
cylinder {<0,0,+15>,<-30,0,+15>,Ep1}
box {<0,9+Ep1,-15>,<-30,-Ep1,15>}
box {<0,8+Ep1,-10>,<-30,9+Ep1*3,10>}
cylinder {<0,20,-10>,<-30,20,-10>,Ep1}
cylinder {<0,20,+10>,<-30,20,+10>,Ep1}

#declare L1 = sqrt (25 + 400)
box {<0,0,Ep1>,<-30,L1,-Ep1> rotate x*degrees (atan2 (5/20,1)) translate z*-15}
box {<0,0,Ep1>,<-30,L1,-Ep1> rotate x*-degrees (atan2 (5/20,1)) translate z*15}  

#declare B=10; #declare C=20; #declare A = sqrt (B*B + C*C);
#declare D = A+Ep1; #declare F =(A*D)/C;
#declare Ang1 = degrees (atan2 (C/B,1));


intersection {
cylinder {<-0.01,20-C,0>,<-30,20-C,0>,D}
plane {y,0 rotate x*Ang1 translate y*(20-C) inverse} 
plane {y,0 rotate x*-Ang1 translate y*(20-C) inverse} 
}
}

#declare WoodCase =
difference {
object {Caisse1}
object {Caisse2 translate x*.1}
texture {Bois_01 scale 20}
}

#declare PlasticCase = 
difference {
object {Caisse2 scale <.9,1,1> translate x*-1} 
superellipsoid {<.2,.8> rotate <90,0,90> scale <.5,1,1>*10 translate y*13} 
 texture {OldPlast}
}

#declare Tube = intersection {
superellipsoid {<.1,1> rotate <90,0,90> scale <.5,1,1>*10 translate y*13} 
sphere {<-25,13,0>,25}
//pigment {color rgb <0.329,0.620,0.706>}
}

#declare Bouton = union {
cylinder {<.2,0,0>,<0,0,0>,.3 texture {T_Silver_4D}}
cylinder {<.2,0,0>,<1,0,0>,.7}
difference {
  cylinder {<1.8,0,0>,<1,0,0>,1.5}
  sphere {<1.8+4,0,0>,4.2}
  }
#declare I=0;
#while (I < 360)
  cylinder {<1.2,1.5,0>,<1.6,1.5,0>,.07 rotate x*I}
  sphere {<1.2,1.5,0>,.07 rotate x*I}
  sphere {<1.6,1.5,0>,.07 rotate x*I}
#declare I=I+10;
#end             
torus {1.3 .1 rotate z*90 translate x*1.8}
 texture {OldPlast}
}

#declare FrontPanel=union {
//text {ttf "trebuc","POV-Ray",.3,0 align_center rotate y*-90 scale 3 translate x*.6}
#declare Boucle=0;
#while (Boucle < 5)
 box {<0,0,-8>,<.3,.1,8> translate y*Boucle*(2/5)}
#declare Boucle=Boucle+1;
#end              
 texture {OldPlast}
}

#declare Antenne = union {
sphere {0,3}        
cone {<0,0,0>,.5,<0,20,0>,.2 rotate x*20}
cone {<0,20,0>,.5,<0,20.5,0>,.2 rotate x*20}
cone {<0,0,0>,.5,<0,20,0>,.2 rotate x*-25}
cone {<0,20,0>,.5,<0,20.5,0>,.2 rotate x*-25}

texture {T_Chrome_3E}
}

#declare Teloche = union {
object {Antenne translate <-10,26.5,0>}
object {WoodCase}
object {PlasticCase}
object {FrontPanel translate x*-1}

object {Tube pigment {image_map {png "cousteau"} scale <20,20,1> rotate y*-90 translate <0,5,-5>} finish {ambient 1.7 diffuse 0} no_shadow}                       
//light_source {<-2,13,0> color rgb <0.329,0.620,0.706>*.5 area_light y*8,z*8,2,2 jitter adaptive 0}

object {Bouton scale 1.5 translate <-1,3,-12>}
object {Bouton scale 1.5 translate <-1,3,+12>}
}
