// Persistence of Vision Ray Tracer Scene Description
// File: .pov
// Vers: 3.01 f1 / MacOS
// Desc: 
// Date: 
// Auth: Joost Egelie

global_settings { assumed_gamma 1.0 }
#include "colors.inc"
#include "textures.inc"

camera{
	location <6.0, 5.3, -12.0>
	direction 1.0*z
	up y
	right 4/3*x
	look_at <-2.0, 1.5, 0.0>
}

#declare Can_O_Tuna = object{
	lathe {
		linear_spline
		38, 
		<0, 0.01>,
		<0.39922, 0.01>,
		<0.42442, 0>,
		<0.44961, 0.01>,
		<0.47868, 0>,
		<0.50775, 0.01>,
		<0.57558, 0.01>,
		<0.60659, 0>,
		<0.63953, 0.01>,
		<0.66473, 0.01>,
		<0.69380, 0>,
		<0.72093, 0.02>,
		<0.72287, 0.08317>,
		<0.72287, 0.147725>,
		<0.73450, 0.18182>,
		<0.72287, 0.21228>,
		<0.72287, 0.309113>,
		<0.73062, 0.34236>,
		<0.72287, 0.373668>,
		<0.72287, 0.4705>,
		<0.73062, 0.50290>,
		<0.72287, 0.535055>,
		<0.72287, 0.59961>,
		<0.74031, 0.60155>,
		<0.75000, 0.61702>,
		<0.75000, 0.65764>,
		<0.74612, 0.67698>,
		<0.71899, 0.67505>,
		<0.71318, 0.64990>,
		<0.63953, 0.64990>,
		<0.60465, 0.66151>,
		<0.57558, 0.64990>,
		<0.50581, 0.64990>,
		<0.47674, 0.65957>,
		<0.44961, 0.64990>,
		<0.42248, 0.65957>,
		<0.39729, 0.64990>,
		<0, 0.64990>
		sturm
		scale <0.5/0.75,1.3/0.67698,0.5/0.75>
		translate<0,-0.15,0>
		texture{Chrome_Metal}
		texture{
			pigment {
				image_map {
					png "Wrapper2.png"
					map_type 2	//cylindrical
					once
					interpolate 4	//normalized distance
				}
			}
		}
		rotate<0,-90,0>
		translate<0,0.15,0>
		scale<7.5,3.667,7.5>
	}
}


object{Can_O_Tuna
	translate<-3.76,0,0>
	rotate<0,-33,0>
}
object{Can_O_Tuna
	rotate<0,90,0>
	translate<3.76,0,2>
	rotate<0,-33,0>
}

plane{y,0
	texture{pigment{Pink_Granite}
		finish{Glossy}
	}
}

sphere{0,30 hollow
	texture{pigment {
		gradient y
		color_map {
			[ 0.0 rgb <0.198901, 0.294469, 0.389990> ]
			[ 0.75 rgb <0.664302, 0.687297, 0.729992> ]
			[ 1.0 rgb <0.940002, 0.986007, 1.000000> ]
		}
		scale 30
	}
		finish{Dull}
	}
}

light_source {
	<10, 20, -10>
	rgb <1.000000, 1.000000, 1.000000>
	spotlight
 	point_at <0.0, 1.5, 0.0>
	radius 30
	falloff 60
	tightness 50
	area_light < 5,  0.0, 0.0 >,   < 0.0, 0.0, 5 >,  5,  5
}

light_source {
	<-6, 1, -12>
	rgb <1.000000, 1.000000, 1.000000>
	shadowless
}

