// Triplet.inc - inspired by the cover of "Godel, Escher, Bach: an Eternal Golden Braid"
//               by Douglas R. Hofstadter.  A macro for creating a single block which
//               casts three different shadows.
//
// Author: Kevin Jackson-Mead (jacksonmead@mindspring.com)
// Date:   16 August 2000
// Usage:  object { triplet("P","O","V") texture { MyTexture } }
//         or do it without a texture to get the shadows without the block.  I use
//         3 spotlights down the three axes, centered on the block (block goes from
//         <0, 0, 0> to <1, 1, 1>.


#version unofficial MegaPov 0.5;

#declare bottom = -0.01;
#declare top = 1.01;

#declare A_Missing_Bits = prism { linear_sweep linear_spline bottom, top, 17
	<0.2, 0.001>, <0.4, 0.4>, <0.6, 0.4>, <0.8, 0.001>, <0.2, 0.001>,
	<0.001, 0.001>, <0.001, 0.999>, <0.4, 0.999>, <0.001, 0.001>,
	<0.999, 0.001>, <0.6, 0.999>, <0.999, 0.999>, <0.999, 0.001>,
	<0.4, 0.6>, <0.5, 0.8>, <0.6, 0.6>, <0.4, 0.6>
}

#declare B_Missing_Bits = union {
	prism { linear_sweep linear_spline bottom, top, 10
		<0.3, 0.2>, <0.3, 0.4>, <0.6, 0.4>, <0.6, 0.2>, <0.3, 0.2>,
		<0.3, 0.6>, <0.3, 0.8>, <0.6, 0.8>, <0.6, 0.6>, <0.3, 0.6>
	}
	cylinder { <0.6, bottom, 0.3>, <0.6, top, 0.3>, 0.1 }
	cylinder { <0.6, bottom, 0.7>, <0.6, top, 0.7>, 0.1 }
	difference {
		box { <0.8, bottom, 0.8>, <top, top, top> }
		cylinder { <0.8, bottom, 0.8>, <0.8, top+.01, 0.8>, 0.2 }
	}
	difference {
		box { <0.8, bottom, 0.2>, <top, top, bottom> }
		cylinder { <0.8, bottom, 0.2>, <0.8, top+0.1, 0.2>, 0.2 }
	}
	difference {
		box { <0.8, bottom, 0.3>, <top, top, 0.7> }
		cylinder { <0.8, bottom, 0.3>, <0.8, top, 0.3>, 0.2 }
		cylinder { <0.8, bottom, 0.7>, <0.8, top, 0.7>, 0.2 }
	}
}

#declare C_Missing_Bits = box { <0.2, 0.001, 0.2>, <0.999, 0.999, 0.8> }

#declare D_Missing_Bits = prism { linear_sweep linear_spline bottom, top, 15,
	<0.2, 0.2>, <0.6, 0.2>, <0.8, 0.4>, <0.8, 0.6>, <0.6, 0.8>, <0.2, 0.8>, <0.2, 0.2>,
	<0.8, 0.001>, <0.999, 0.001>, <0.999, 0.2>, <0.8, 0.001>,
	<0.8, 0.999>, <0.999, 0.8>, <0.999, 0.999>, <0.8, 0.999>
}

#declare E_Missing_Bits = prism { linear_sweep linear_spline bottom, top, 10,
	<0.2, 0.2>, <0.2, 0.4>, <0.999, 0.4>, <0.999, 0.2>, <0.2, 0.2>,
	<0.2, 0.6>, <0.2, 0.8>, <0.999, 0.8>, <0.999, 0.6>, <0.2, 0.6>
}

#declare F_Missing_Bits = prism { linear_sweep linear_spline bottom, top, 9,
	<0.2, 0.001>, <0.2, 0.4>, <0.7, 0.4>, <0.7, 0.6>,
	<0.2, 0.6>, <0.2, 0.8>, <0.999, 0.8>, <0.999, 0.001>, <0.2, 0.001>
}

#declare G_Missing_Bits = prism { linear_sweep linear_spline bottom, top, 9,
	<0.2, 0.2>, <0.2, 0.8>, <1.01, 0.8>, <1.01, 0.6>,
	<0.5, 0.6>, <0.5, 0.4>, <0.8, 0.4>, <0.8, 0.2>, <0.2, 0.2>
}

#declare H_Missing_Bits = prism { linear_sweep linear_spline bottom, top, 10,
	<0.2, 0.001>, <0.8, 0.001>, <0.8, 0.4>, <0.2, 0.4>, <0.2, 0.001>,
	<0.2, 0.6>, <0.8, 0.6>, <0.8, 0.999>, <0.2, 0.999>, <0.2, 0.6>
}

#declare I_Missing_Bits = object { H_Missing_Bits rotate -90*y translate x }

#declare J_Missing_Bits = prism { linear_sweep linear_spline bottom, top, 7,
	<0.001, 0.41>, <0.001, 0.999>, <0.8, 0.999>,
	<0.8, 0.2>, <0.2, 0.2>, <0.2, 0.41>, <0.001, 0.41>
}

#declare K_Missing_Bits = prism { linear_sweep linear_spline bottom, top, 15,
	<0.2, 0.001>, <0.2, 0.4>, <0.4, 0.4>, <0.8, 0.001>, <0.2, 0.001>,
	<0.2, 0.6>, <0.2, 0.999>, <0.8, 0.999>, <0.4, 0.6>, <0.2, 0.6>,
	<0.6, 0.4>, <0.6, 0.6>, <0.999, 0.8>, <0.999, 0.2>, <0.6, 0.4>
}

#declare L_Missing_Bits = box { <0.2, bottom, 0.2>, <0.999, top, 0.999> }

#declare M_Missing_Bits = prism { linear_sweep linear_spline bottom, top, 10,
	<0.2, 0.001>, <0.2, 0.8>, <0.5, 0.5>, <0.8, 0.8>, <0.8, 0.001>,
	<0.2, 0.001>, <0.2, 0.999>, <0.8, 0.999>, <0.5, 0.7>, <0.2, 0.999>
}

#declare N_Missing_Bits = prism { linear_sweep linear_spline bottom, top, 8,
	<0.2, 0.001>, <0.8, 0.001>, <0.2, 0.8>, <0.2, 0.001>,
	<0.2, 0.999>, <0.8, 0.2>, <0.8, 0.999>, <0.2, 0.999>
}

#declare O_Missing_Bits = box { <0.2, bottom, 0.2>, <0.8, top, 0.8> }

#declare P_Missing_Bits = prism { linear_sweep linear_spline bottom, top, 10,
	<0.2, 0.001>, <0.999, 0.001>, <0.999, 0.4>, <0.2, 0.4>, <0.2, 0.001>,
	<0.2, 0.8>, <0.2, 0.6>, <0.8, 0.6>, <0.8, 0.8>, <0.2, 0.8>
}

#declare Q_Missing_Bits = prism { linear_sweep linear_spline bottom, top, 8
	<0.2, 0.2>, <0.7, 0.2>, <0.6, 0.3>, <0.7, 0.4>, <0.8, 0.3>,
	<0.8, 0.8>, <0.2, 0.8>, <0.2, 0.2>
}

#declare R_Missing_Bits = prism { linear_sweep linear_spline bottom, top, 14,
	<0.2, 0.001>, <0.8, 0.001>, <0.6, 0.4>, <0.2, 0.4>, <0.2, 0.001>,
	<0.2, 0.6>, <0.8, 0.6>, <0.8, 0.8>, <0.2, 0.8>, <0.2, 0.6>,
	<0.999, 0.001>, <0.999, 0.6>, <0.8, 0.4>, <0.999, 0.001>
}

#declare S_Missing_Bits = prism { linear_sweep linear_spline bottom, top, 10,
	<0.001, 0.2>, <0.8, 0.2>, <0.8, 0.4>, <0.001, 0.4>, <0.001, 0.2>,
	<0.2, 0.6>, <0.999, 0.6>, <0.999, 0.8>, <0.2, 0.8>, <0.2, 0.6>
}

#declare T_Missing_Bits = prism { linear_sweep linear_spline bottom, top, 10,
	<0.001, 0.001>, <0.4, 0.001>, <0.4, 0.8>, <0.001, 0.8>, <0.001, 0.001>,
	<0.6, 0.001>, <0.999, 0.001>, <0.999, 0.8>, <0.6, 0.8>, <0.6, 0.001>
}

#declare U_Missing_Bits = box { <0.2, bottom, 0.2>, <0.8, top, 0.999> }

#declare V_Missing_Bits = prism { linear_sweep linear_spline bottom, top, 12,
	<0.001, 0.001>, <0.4, 0.001>, <0.001, 0.999>, <0.001, 0.001>,
	<0.6, 0.001>, <0.999, 0.001>, <0.999, 0.999>, <0.6, 0.001>,
	<0.5, 0.3>, <0.8, 0.999>, <0.2, 0.999>, <0.5, 0.3>
}

#declare W_Missing_Bits = prism { linear_sweep linear_spline bottom, top, 18,
	<0.001, 0.001>, <0.2, 0.001>, <0.001, 0.999>, <0.001, 0.001>,
	<0.4, 0.001>, <0.6, 0.001>, <0.5, 0.1>, <0.4, 0.001>,
	<0.8, 0.001>, <0.999, 0.001>, <0.999, 0.999>, <0.8, 0.001>,
	<0.2, 0.999>, <0.4, 0.2>, <0.5, 0.4>, <0.6, 0.2>, <0.8, 0.999>, <0.2, 0.999>
}

#declare X_Missing_Bits = prism { linear_sweep linear_spline bottom, top, 16,
	<0.2, 0.001>, <0.8, 0.001>, <0.5, 0.3>, <0.2, 0.001>,
	<0.999, 0.1>, <0.999, 0.9>, <0.6, 0.5>, <0.999, 0.1>,
	<0.2, 0.999>, <0.5, 0.7>, <0.8, 0.999>, <0.2, 0.999>,
	<0.001, 0.1>, <0.4, 0.5>, <0.001, 0.9>, <0.001, 0.1>
}

#declare Y_Missing_Bits = prism { linear_sweep linear_spline bottom, top, 14,
	<0.001, 0.001>, <0.4, 0.001>, <0.4, 0.4>, <0.001, 0.999>, <0.001, 0.001>,
	<0.6, 0.001>, <0.999, 0.001>, <0.999, 0.999>, <0.6, 0.4>, <0.6, 0.001>,
	<0.2, 0.999>, <0.5, 0.6>, <0.8, 0.999>, <0.2, 0.999>
}

#declare Z_Missing_Bits = object { N_Missing_Bits rotate -90*y translate x }

#declare Letter_Bits = array[26] {
	A_Missing_Bits,
	B_Missing_Bits,
	C_Missing_Bits,
	D_Missing_Bits,
	E_Missing_Bits,
	F_Missing_Bits,
	G_Missing_Bits,
	H_Missing_Bits,
	I_Missing_Bits,
	J_Missing_Bits,
	K_Missing_Bits,
	L_Missing_Bits,
	M_Missing_Bits,
	N_Missing_Bits,
	O_Missing_Bits,
	P_Missing_Bits,
	Q_Missing_Bits,
	R_Missing_Bits,
	S_Missing_Bits,
	T_Missing_Bits,
	U_Missing_Bits,
	V_Missing_Bits,
	W_Missing_Bits,
	X_Missing_Bits,
	Y_Missing_Bits,
	Z_Missing_Bits
}

#macro triplet (First, Second, Third)
	difference {
		box { 0, 1 }
		object { Letter_Bits[asc(strupr(First))-65] rotate <-90, -90, 0> }
		object { Letter_Bits[asc(strupr(Second))-65] rotate -90*x translate z }
		object { Letter_Bits[asc(strupr(Third))-65] }
	}
#end

	

	