// Triplet.pov - inspired by the cover of "Godel, Escher, Bach: an Eternal Golden Braid"
//               by Douglas R. Hofstadter.  A single block which casts three different
//               shadows.
//
// Author: Kevin Jackson-Mead (jacksonmead@mindspring.com)
// Date:   23 July 2000
// Update: 16 August 2000 - uses the triplet macro now

#version unofficial MegaPov 0.5;

#include "triplet.inc"

global_settings {
	ambient_light 2
}


camera {
	location <4, 4, -4>
	look_at <0.5, 0.5, 0.5>
	//angle 45
}

background { color rgb<0,0,0> }

//light_source { <20, 20, -20> color rgb<1,1,1> shadowless }

// z-axis spotlight
light_source {
	<0.5, 0.5, -10>
	color rgb<0,0,1>
	cylinder
	radius 2
	falloff 5
	tightness 0.1
	point_at <0.5, 0.5, 0>
}

// x-axis spotlight
light_source {
	<10, 0.5, 0.5>
	color rgb<0,1,0>
	cylinder
	radius 2
	falloff 5
	tightness 0.1
	point_at <0, 0.5, 0.5>
}

// y-axis spotlight
light_source {
	<0.5, 10, 0.5>
	color rgb<1,0,1>
	cylinder
	radius 2
	falloff 5
	tightness 0.1
	point_at <0.5, 0, 0.5>
}

// E projection surface
box { <-1, -1, 4>, <2, 2, 4.1>
	texture {
		pigment { color rgb<1,1,1> }
	}
}

// G projection surface
box { <-3, -1, -1>, <-3.1, 2, 2>
	texture {
		pigment { color rgb<1,1,1> }
	}
}

// B projection surface
box { <-1, -2, -1>, <2, -2.1, 2>
	texture {
		pigment { color rgb<1,1,1> }
	}
}


#declare BoxTex = texture { pigment { color rgb<1,1,1> } finish { ambient 0.2 } }

object { triplet("G","E","B") texture { BoxTex } }
