//  Persistence of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 2 lights, 32 materials and 459 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.2 For Windows Copyright (c) 1993-2000 Lutz + Kretzschmar
//

//  Date : 08/31/2000    (31.08.2000)
//


default {
  texture {
    pigment { rgb <1,0,0> }
  }
}


global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera StdCam
  location  <   -765.200,    -484.000,     151.700>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.36108,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         42.00000    // Vertical      31.500
  look_at   <    -11.000,      88.900,     155.800>
}

//
// *******  L I G H T S *******
//

light_source {   // Light002
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  translate  <-800.0, 500.0, 600.0>
}

light_source {   // Light001
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  translate  <-800.0, 0.0, 600.0>
}


//
// ********  MATERIALS  *******
//

#include "sea6.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#declare Cube001 = object {
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <200.0, 1000.0, 20.0>
    translate  <0.0, 500.0, -20.0>
  }
}
#declare Cube071 = object {
  object { // Cube071->Cube001
    Cube001
    rotate -90.0*y
    translate  <200.0, 0.0, 200.0>
  }
}
#declare CSG001 = difference {
  box { // Cube069
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 3.0, 12.0>
    translate  <0.0, 2.5, 12.0>
  }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 25.0>
    translate  <9.8, -0.5, -0.5>
  }
  cylinder { // Cylndr086
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 25.0>
    translate  <9.8, 5.5, -0.5>
  }
  torus { // Torus078
    8.125, 0.125  rotate -x*90
    sturm
    material {
      Brass_Texture
    }
    scale <0.8, 0.3, 1.0>
    rotate -90.0*x
    translate  <0.0, 5.5, 14.5>
  }
  cylinder { // Cylndr087
    <0,0,1>, <0,0,0>, 1 
    material {
      Brass_Texture
    }
    scale <0.125, 0.125, 20.0>
    rotate -90.0*y
    translate  <10.0, 5.5, 4.0>
  }
  cylinder { // Cylndr088
    <0,0,1>, <0,0,0>, 1 
    material {
      Brass_Texture
    }
    scale <0.125, 0.125, 20.0>
    rotate -90.0*y
    translate  <10.0, -0.5, 4.0>
  }
  cylinder { // Cylndr089
    <0,0,1>, <0,0,0>, 1 
    material {
      Brass_Texture
    }
    scale <0.125, 0.125, 20.0>
    rotate -90.0*y
    translate  <10.0, -0.5, 20.0>
  }
  cylinder { // Cylndr090
    <0,0,1>, <0,0,0>, 1 
    material {
      Brass_Texture
    }
    scale <0.125, 0.125, 20.0>
    rotate -90.0*y
    translate  <10.0, 5.5, 20.0>
  }
  text {   // TText001
    ttf      "C:\WINNT\Fonts\Bookos.ttf",
    "ROBINSON CRUSOE",
    0.25,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      Brass_Texture
    }
    scale <1.0, 2.0, 2.0>
    rotate <90.0, 0.0, 180.0>
    translate  <4.75, 5.375, 14.0>
  }

}
#declare CSG004 = difference {
  cylinder { // Cylndr091
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 3.0, 24.0>
    translate  <10.0, 2.5, 0.0>
  }
  box { // Cube070
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 3.0, 12.0>
    translate  <9.0, 2.5, 12.0>
  }
  torus { // Torus079
    2.0, 0.25  rotate -x*90
    sturm
    material {
      Brass_Texture
    }
    scale <0.5, 1.5, 0.5>
    translate  <10.0, 2.5, 20.0>
  }
  torus { // Torus080
    2.0, 0.25  rotate -x*90
    sturm
    material {
      Brass_Texture
    }
    scale <0.5, 1.5, 0.5>
    translate  <10.0, 2.5, 4.0>
  }
  text {   // TText002
    ttf      "C:\WINNT\Fonts\Bookos.ttf",
    "ROBINSON CRUSOE",
    0.25,  // Depth
    <0.0,     0.0, 0.0> // Offset
    material {
      Brass_Texture
    }
    scale <1.0, 2.5, 2.0>
    rotate <0.0, -90.0, -180.0>
    translate  <10.6, 3.2, 7.0>
  }

}
#declare Book = union {
  object { CSG001 }
  object { CSG004 }
  material {
    S_Wood4
  }
  scale 15.0
  rotate <10.0, 0.0, 180.0>
  translate  420.0*y
}
#declare Cylndr025 = object {
  cylinder { // Cylndr025
    <0,0,1>, <0,0,0>, 1 
    material {
      Cuivre
    }
    scale <0.3, 0.3, 7.0>
    translate  <-10.65, -67.7, 7.0>
  }
}
#declare Cylndr012 = object {
  cylinder { // Cylndr012
    <0,0,1>, <0,0,0>, 1 
    material {
      Cuivre
    }
    scale <0.3, 0.3, 5.0>
    translate  <-7.0, -85.3, 9.0>
  }
}
#declare Cylndr036 = object {
  cylinder { // Cylndr036
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.3, 2.0>
    rotate -90.0*x
    translate  <-4.0, -86.2, 14.9>
  }
}
#declare Cube027 = object {
  box { // Cube027
    <-1, -1, -1>, <1, 1, 1>
    scale <1.5, 0.75, 1.35>
    translate  <-4.0, -85.0, 12.95>
  }
}
#declare Cube009 = object {
  box { // Cube009
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 4.0, 4.0>
    translate  <-10.35, -72.0, 11.5>
  }
}
#declare Cylndr039 = object {
  object { // Cylndr039->Cylndr036
    Cylndr036
    scale <0.89, 0.88, 1.0>
    rotate -90.0*z
    translate  <64.6, -73.55, -1.3>
  }
}
#declare Cube031 = object {
  object { // Cube031->Cube027
    Cube027
    scale 0.88
    rotate <0.0, -0.0, -90.0>
    translate  <64.4, -73.5, 1.15>
  }
}
#declare Cube004 = object {
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 5.0, 3.5>
    rotate -22.0*z
    translate  <8.5, -80.5, 12.0>
  }
}
#declare CSG003 = intersection {
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 2.0, 5.0>
    translate  <7.5, 0.0, 20.0>
  }
  torus { // Torus001
    2.525, 0.4  rotate -x*90
    scale <1.0, 1.0, 5.0>
    rotate -90.0*x
    translate  <7.5, 0.0, 15.0>
  }
  bounded_by { // Bound00003
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      scale <8.084666, 2.184667, 4.134666>
      translate  <7.5, -0.0, 18.95>
    }
  }
}
#declare Cylndr006 = object {
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 2.0, 15.0>
  }
}
#declare CSG007 = intersection {
  torus { // Torus002
    7.5, 0.4  rotate -x*90
    scale <1.0, 1.0, 5.0>
    rotate -90.0*x
    translate  <7.5, 0.0, 15.0>
  }
  box { // Cube006
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 2.0, 5.0>
    translate  <7.5, 0.0, 20.0>
  }
}
#declare Cylndr007 = object {
  cylinder { // Cylndr007
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 2.0, 15.0>
    rotate -90.0*y
    translate  <15.0, 0.0, 6.5>
  }
}
#declare Cylndr008 = object {
  object { // Cylndr008->Cylndr007
    Cylndr007
    translate  6.5*z
  }
}
#declare Cylndr010 = object {
  cylinder { // Cylndr010
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 2.0, 5.0>
    rotate -45.0*y
    translate  <6.125, 0.0, 17.125>
  }
}
#declare Fenetre = union {
  object { CSG003 }
  object { // Cylndr005->Cylndr006
    Cylndr006
    translate  15.0*x
  }
  object { // Cylndr004->Cylndr006
    Cylndr006
    translate  10.0*x
  }
  object { // Cylndr003->Cylndr006
    Cylndr006
    translate  5.0*x
  }
  object { // Cylndr002->Cylndr006
    Cylndr006
  }
  object { Cylndr006 }
  object { CSG007 }
  object { Cylndr007 }
  object { Cylndr008 }
  cylinder { // Cylndr009
    <0,0,1>, <0,0,0>, 1 
    material {
      Glass_1
    }
    scale <7.5, 7.5, 2.8>
    rotate -90.0*x
    translate  <7.5, -1.4, 15.0>
  }
  box { // Cube012
    <-1, -1, -1>, <1, 1, 1>
    material {
      Glass_1
    }
    scale <7.5, 1.4, 7.5>
    translate  <7.5, 0.0, 7.5>
  }
  object { Cylndr010 }
  object { // Cylndr011->Cylndr010
    Cylndr010
    rotate 90.0*y
    translate  <-8.25, 0.0, 23.25>
  }
  object { // Cylndr014->Cylndr008
    Cylndr008
    translate  -13.0*z
  }
  material {
    Cuivre
  }
  scale <0.2, 0.3, 0.15>
  translate  <-5.5, -85.0, 10.0>
}
#declare Fenetre3 = object {
  object { // Fenetre3->Fenetre
    Fenetre
    rotate -68.0*z
    translate  <70.9, -50.2, 0.4>
  }
}
#declare Fenetre4 = object {
  object { // Fenetre4->Fenetre3
    Fenetre3
    rotate <0.0, 0.0, 0.0>
    translate  <1.6, -4.0, 0.0>
  }
}
#declare Fenetre7 = object {
  object { // Fenetre7->Fenetre
    Fenetre
    scale 0.9
    rotate <-0.0, 0.0, -90.0>
    translate  <66.1, -77.2, 1.5>
  }
}
#declare Fenetre8 = object {
  object { // Fenetre8->Fenetre7
    Fenetre7
    rotate <0.0, 0.0, -0.0>
    translate  3.6*y
  }
}
#declare Cylndr026 = object {
  object { // Cylndr026->Cylndr025
    Cylndr025
    rotate 0.0*x
    translate  -8.3*y
  }
}
#declare Marche1 = union {
  box { // Cube014
    <-1, -1, -1>, <1, 1, 1>
    scale <0.4, 2.0, 0.15>
    rotate -90.0*y
    translate  <0.8, 0.0, 0.4>
  }
  box { // Cube015
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 2.0, 0.15>
    translate  <1.5, 0.0, 0.8>
  }
  material {
    T_Wood5
  }
  scale <1.0, 0.8, 1.0>
}
#declare Torus006 = object {
  torus { // Torus006
    1.1, 0.1  rotate -x*90
    scale <0.7, 0.7, 0.25>
    translate  0.4*z
  }
}
#declare Torus010 = object {
  torus { // Torus010
    1.5, 0.4  rotate -x*90
    scale <0.5, 0.5, 0.2>
    translate  8.0*z
  }
}
#declare Cone022 = object {
  cone { // Cone022
    <0,0,0>, 0.5, <0,0,1>, 1.0
    scale <0.25, 1.0, 1.5>
    rotate -90.0*y
    translate  7.0*z
  }
}
#declare Cone023 = object {
  cone { // Cone023
    <0,0,0>, 0.4, <0,0,1>, 0.2
    scale <1.0, 1.0, 9.0>
    rotate -90.0*x
    translate  <-1.75, 0.0, 7.0>
  }
}
#declare Cone026 = object {
  object { // Cone026->Cone023
    Cone023
    scale 0.75
    translate  <-0.35, 0.0, 13.75>
  }
}
#declare BezPtch001 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-6.700000, -6.100000, 0.000000>, <-6.000000, -6.100000, 0.500000>, <-5.900000, -6.000000, 0.300000>, <-4.950000, -6.000000, 0.400000>, 
      <-7.100000, -5.200000, 0.800000>, <-5.700000, -5.200000, 0.800000>, <-6.000000, -5.000000, 0.800000>, <-5.000000, -5.000000, 0.900000>, 
      <-7.200000, -4.200000, 0.000000>, <-7.700000, -4.000000, 0.300000>, <-6.000000, -4.000000, 0.800000>, <-5.000000, -4.000000, 1.050000>, 
      <-7.350000, -3.500000, 0.150000>, <-7.350000, -3.000000, 0.300000>, <-6.000000, -3.000000, 0.800000>, <-5.000000, -3.000000, 1.100000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-7.350000, -3.500000, 0.150000>, <-7.350000, -3.000000, 0.300000>, <-6.000000, -3.000000, 0.800000>, <-5.000000, -3.000000, 1.100000>, 
      <-7.500000, -2.800000, 0.300000>, <-7.000000, -2.000000, 0.300000>, <-6.000000, -2.000000, 0.800000>, <-5.000000, -2.000000, 1.150000>, 
      <-7.700000, -1.400000, 0.400000>, <-7.500000, -1.100000, 1.000000>, <-6.000000, -2.800000, 0.800000>, <-5.000000, -1.900000, 1.150000>, 
      <-7.658190, -0.893276, 0.100000>, <-7.250000, -0.150000, 0.500000>, <-6.000000, -0.900000, 0.800000>, <-5.000000, -0.450000, 1.150000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-7.658190, -0.893276, 0.100000>, <-7.250000, -0.150000, 0.500000>, <-6.000000, -0.900000, 0.800000>, <-5.000000, -0.450000, 1.150000>, 
      <-7.616380, -0.386552, -0.200000>, <-7.000000, 0.800000, 0.000000>, <-6.000000, 1.000000, 0.800000>, <-5.000000, 1.000000, 1.150000>, 
      <-7.600000, 1.600000, -0.100000>, <-7.000000, 1.600000, -0.100000>, <-5.740344, 1.740344, 0.800000>, <-4.870172, 1.870172, 1.150000>, 
      <-7.550000, 2.450000, -0.100000>, <-6.750000, 2.800000, 0.200000>, <-4.720172, 2.870172, 0.800000>, <-4.285086, 2.935086, 1.150000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-7.550000, 2.450000, -0.100000>, <-6.750000, 2.800000, 0.200000>, <-4.720172, 2.870172, 0.800000>, <-4.285086, 2.935086, 1.150000>, 
      <-7.500000, 3.300000, -0.100000>, <-6.500000, 4.000000, 0.500000>, <-3.700000, 4.000000, 0.800000>, <-3.700000, 4.000000, 1.150000>, 
      <-7.400000, 5.000000, 0.400000>, <-8.557934, 5.173104, 0.300000>, <-5.200000, 5.000000, 0.800000>, <-4.200000, 5.000000, 0.900000>, 
      <-8.141555, 6.000000, 0.000000>, <-3.500000, 6.000000, 0.300000>, <-3.876035, 5.010516, 0.300000>, <-2.988018, 5.455258, 0.400000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.950000, -6.000000, 0.400000>, <-4.000000, -6.000000, 0.500000>, <-3.000000, -6.200000, 0.500000>, <-2.000000, -6.100000, 0.500000>, 
      <-5.000000, -5.000000, 0.900000>, <-4.000000, -5.000000, 1.000000>, <-3.000000, -5.000000, 1.300000>, <-2.150000, -5.100000, 1.100000>, 
      <-5.000000, -4.000000, 1.050000>, <-4.000000, -4.000000, 1.300000>, <-3.000000, -4.000000, 1.000000>, <-1.600000, -4.250000, 1.150000>, 
      <-5.000000, -3.000000, 1.100000>, <-4.000000, -3.000000, 1.400000>, <-3.000000, -3.000000, 1.400000>, <-1.800000, -3.175000, 1.475000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.000000, -3.000000, 1.100000>, <-4.000000, -3.000000, 1.400000>, <-3.000000, -3.000000, 1.400000>, <-1.800000, -3.175000, 1.475000>, 
      <-5.000000, -2.000000, 1.150000>, <-4.000000, -2.000000, 1.500000>, <-3.000000, -2.000000, 1.800000>, <-2.000000, -2.100000, 1.800000>, 
      <-5.000000, -1.900000, 1.150000>, <-4.000000, -1.000000, 1.500000>, <-2.697068, -0.740344, 1.800000>, <-1.798534, -1.320172, 1.750000>, 
      <-5.000000, -0.450000, 1.150000>, <-4.000000, 0.000000, 1.500000>, <-2.848534, 0.129828, 1.800000>, <-2.049267, -0.335086, 1.775000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.000000, -0.450000, 1.150000>, <-4.000000, 0.000000, 1.500000>, <-2.848534, 0.129828, 1.800000>, <-2.049267, -0.335086, 1.775000>, 
      <-5.000000, 1.000000, 1.150000>, <-4.000000, 1.000000, 1.500000>, <-3.000000, 1.000000, 1.800000>, <-2.300000, 0.650000, 1.800000>, 
      <-4.870172, 1.870172, 1.150000>, <-4.000000, 2.000000, 1.500000>, <-3.000000, 2.000000, 1.800000>, <-1.675430, 1.533620, 1.900000>, 
      <-4.285086, 2.935086, 1.150000>, <-3.850000, 3.000000, 1.500000>, <-1.850000, 2.900000, 1.650000>, <-1.262715, 2.541810, 1.775000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.285086, 2.935086, 1.150000>, <-3.850000, 3.000000, 1.500000>, <-1.850000, 2.900000, 1.650000>, <-1.262715, 2.541810, 1.775000>, 
      <-3.700000, 4.000000, 1.150000>, <-3.700000, 4.000000, 1.500000>, <-0.700000, 3.800000, 1.500000>, <-0.850000, 3.550000, 1.650000>, 
      <-4.200000, 5.000000, 0.900000>, <-3.200000, 5.000000, 1.000000>, <-0.500000, 5.000000, 1.000000>, <-0.150000, 4.800000, 1.150000>, 
      <-2.988018, 5.455258, 0.400000>, <-2.100000, 5.900000, 0.500000>, <0.000000, 6.000000, 0.500000>, <0.000000, 6.000000, 0.650000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -6.100000, 0.500000>, <-1.000000, -6.000000, 0.500000>, <-0.200000, -5.700000, 1.000000>, <0.900000, -5.850000, 0.650000>, 
      <-2.150000, -5.100000, 1.100000>, <-1.300000, -5.200000, 0.900000>, <0.000000, -5.200000, 0.800000>, <0.650000, -5.150000, 0.900000>, 
      <-1.600000, -4.250000, 1.150000>, <-0.200000, -4.500000, 1.300000>, <0.700000, -5.000000, 1.300000>, <1.350000, -4.500000, 1.300000>, 
      <-1.800000, -3.175000, 1.475000>, <-0.600000, -3.350000, 1.550000>, <0.350000, -3.500000, 1.400000>, <1.175000, -3.250000, 1.350000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.800000, -3.175000, 1.475000>, <-0.600000, -3.350000, 1.550000>, <0.350000, -3.500000, 1.400000>, <1.175000, -3.250000, 1.350000>, 
      <-2.000000, -2.100000, 1.800000>, <-1.000000, -2.200000, 1.800000>, <0.000000, -2.000000, 1.500000>, <1.000000, -2.000000, 1.400000>, 
      <-1.798534, -1.320172, 1.750000>, <-0.900000, -1.900000, 1.700000>, <0.500000, -1.000000, 2.000000>, <0.750000, -1.250000, 1.900000>, 
      <-2.049267, -0.335086, 1.775000>, <-1.250000, -0.800000, 1.750000>, <0.200000, -0.850000, 2.100000>, <0.850000, -0.450000, 2.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.049267, -0.335086, 1.775000>, <-1.250000, -0.800000, 1.750000>, <0.200000, -0.850000, 2.100000>, <0.850000, -0.450000, 2.000000>, 
      <-2.300000, 0.650000, 1.800000>, <-1.600000, 0.300000, 1.800000>, <-0.100000, -0.700000, 2.200000>, <0.950000, 0.350000, 2.100000>, 
      <-1.675430, 1.533620, 1.900000>, <-0.350861, 1.067240, 2.000000>, <0.000000, 1.900000, 1.900000>, <0.850000, 1.500000, 1.450000>, 
      <-1.262715, 2.541810, 1.775000>, <-0.675430, 2.183620, 1.900000>, <0.150000, 2.850000, 1.600000>, <1.000000, 2.650000, 1.425000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.262715, 2.541810, 1.775000>, <-0.675430, 2.183620, 1.900000>, <0.150000, 2.850000, 1.600000>, <1.000000, 2.650000, 1.425000>, 
      <-0.850000, 3.550000, 1.650000>, <-1.000000, 3.300000, 1.800000>, <0.300000, 3.800000, 1.300000>, <1.150000, 3.800000, 1.400000>, 
      <-0.150000, 4.800000, 1.150000>, <0.200000, 4.600000, 1.300000>, <0.000000, 4.500000, 1.300000>, <0.650000, 4.650000, 1.150000>, 
      <0.000000, 6.000000, 0.650000>, <0.000000, 6.000000, 0.800000>, <0.300000, 6.000000, 0.500000>, <0.600000, 5.900000, 0.550000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.900000, -5.850000, 0.650000>, <2.000000, -6.000000, 0.300000>, <2.800000, -5.700000, 0.500000>, <3.900000, -5.850000, 0.400000>, 
      <0.650000, -5.150000, 0.900000>, <1.300000, -5.100000, 1.000000>, <2.700000, -5.100000, 0.800000>, <3.850000, -5.050000, 0.800000>, 
      <1.350000, -4.500000, 1.300000>, <2.000000, -4.000000, 1.300000>, <2.900000, -3.700000, 0.800000>, <4.100000, -3.950000, 1.050000>, 
      <1.175000, -3.250000, 1.350000>, <2.000000, -3.000000, 1.300000>, <3.050000, -3.100000, 1.150000>, <4.175000, -3.100000, 1.025000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.175000, -3.250000, 1.350000>, <2.000000, -3.000000, 1.300000>, <3.050000, -3.100000, 1.150000>, <4.175000, -3.100000, 1.025000>, 
      <1.000000, -2.000000, 1.400000>, <2.000000, -2.000000, 1.300000>, <3.200000, -2.500000, 1.500000>, <4.250000, -2.250000, 1.000000>, 
      <0.750000, -1.250000, 1.900000>, <1.000000, -1.500000, 1.800000>, <2.500000, -0.800000, 1.500000>, <4.350000, -1.000000, 0.900000>, 
      <0.850000, -0.450000, 2.000000>, <1.500000, -0.050000, 1.900000>, <2.750000, 0.000000, 1.400000>, <4.250000, -0.050000, 0.900000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.850000, -0.450000, 2.000000>, <1.500000, -0.050000, 1.900000>, <2.750000, 0.000000, 1.400000>, <4.250000, -0.050000, 0.900000>, 
      <0.950000, 0.350000, 2.100000>, <2.000000, 1.400000, 2.000000>, <3.000000, 0.800000, 1.300000>, <4.150000, 0.900000, 0.900000>, 
      <0.850000, 1.500000, 1.450000>, <1.700000, 1.100000, 1.000000>, <3.000000, 2.000000, 1.500000>, <4.250000, 1.950000, 1.100000>, 
      <1.000000, 2.650000, 1.425000>, <1.850000, 2.450000, 1.250000>, <2.750000, 2.900000, 1.400000>, <4.200000, 2.925000, 1.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.000000, 2.650000, 1.425000>, <1.850000, 2.450000, 1.250000>, <2.750000, 2.900000, 1.400000>, <4.200000, 2.925000, 1.000000>, 
      <1.150000, 3.800000, 1.400000>, <2.000000, 3.800000, 1.500000>, <2.500000, 3.800000, 1.300000>, <4.150000, 3.900000, 0.900000>, 
      <0.650000, 4.650000, 1.150000>, <1.300000, 4.800000, 1.000000>, <2.500000, 4.800000, 0.800000>, <2.900000, 4.900000, 0.650000>, 
      <0.600000, 5.900000, 0.550000>, <0.900000, 5.800000, 0.600000>, <2.173104, 5.423965, 1.000000>, <3.136552, 5.611982, 0.650000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <3.900000, -5.850000, 0.400000>, <5.000000, -6.000000, 0.300000>, <6.000000, -6.000000, 0.500000>, <5.500000, -6.100000, 0.000000>, 
      <3.850000, -5.050000, 0.800000>, <5.000000, -5.000000, 0.800000>, <6.000000, -5.000000, 0.500000>, <5.600000, -5.500000, 0.800000>, 
      <4.100000, -3.950000, 1.050000>, <5.300000, -4.200000, 1.300000>, <6.000000, -4.200000, 0.800000>, <6.000000, -4.700000, 0.500000>, 
      <4.175000, -3.100000, 1.025000>, <5.300000, -3.100000, 0.900000>, <6.000000, -3.100000, 0.650000>, <6.250000, -4.100000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.175000, -3.100000, 1.025000>, <5.300000, -3.100000, 0.900000>, <6.000000, -3.100000, 0.650000>, <6.250000, -4.100000, 0.500000>, 
      <4.250000, -2.250000, 1.000000>, <5.300000, -2.000000, 0.500000>, <6.000000, -2.000000, 0.500000>, <6.500000, -3.500000, 0.500000>, 
      <4.350000, -1.000000, 0.900000>, <6.200000, -1.200000, 0.300000>, <6.300000, -2.300000, 0.300000>, <6.800000, -1.900000, 0.500000>, 
      <4.250000, -0.050000, 0.900000>, <5.750000, -0.100000, 0.400000>, <6.300000, -0.750000, 0.150000>, <6.800000, -2.100000, 0.200000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.250000, -0.050000, 0.900000>, <5.750000, -0.100000, 0.400000>, <6.300000, -0.750000, 0.150000>, <6.800000, -2.100000, 0.200000>, 
      <4.150000, 0.900000, 0.900000>, <5.300000, 1.000000, 0.500000>, <6.300000, 0.800000, 0.000000>, <6.800000, -2.300000, -0.100000>, 
      <4.250000, 1.950000, 1.100000>, <5.500000, 1.900000, 0.700000>, <6.800000, 1.300000, -0.200000>, <6.900000, 0.200000, -0.100000>, 
      <4.200000, 2.925000, 1.000000>, <5.650000, 2.950000, 0.600000>, <6.550000, 2.550000, 0.050000>, <6.800000, 1.200000, -0.150000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.200000, 2.925000, 1.000000>, <5.650000, 2.950000, 0.600000>, <6.550000, 2.550000, 0.050000>, <6.800000, 1.200000, -0.150000>, 
      <4.150000, 3.900000, 0.900000>, <5.800000, 4.000000, 0.500000>, <6.300000, 3.800000, 0.300000>, <6.700000, 2.200000, -0.200000>, 
      <2.900000, 4.900000, 0.650000>, <3.300000, 5.000000, 0.500000>, <6.519311, 5.476035, 0.300000>, <7.365519, 4.584830, 0.000000>, 
      <3.136552, 5.611982, 0.650000>, <4.100000, 5.800000, 0.300000>, <6.100000, 6.000000, -0.100000>, <7.411727, 6.116380, 0.000000>
    }
  }
  material {
    Voile_blanc
  }
  rotate -90.0*x
  translate  6.0*z
}
#declare Voile = union {
  object { BezPtch001 }
  scale <1.2, 1.5, 0.995>
  rotate 90.0*z
  translate  <-1.5, 0.5, 7.0>
}
#declare Nacelle = union {
  object { // Torus012->Torus010
    Torus010
    scale <0.65, 0.65, 0.7>
    translate  15.95*z
  }
  cone { // Cone028
    <0,0,0>, 0.8, <0,0,1>, 1.4
    open
    scale <1.0, 1.0, 2.0>
    translate  21.6*z
  }
  disc { // Disc001
    <0,0,0>, <0,0,1>, 1.0
    scale 0.8
    translate  21.6*z
  }
  scale <0.8, 0.8, 1.0>
  translate  7.0*z
}
#declare Torus014 = object {
  torus { // Torus014
    1.5, 0.1  rotate -x*90
    scale 0.21
    translate  -3.0*z
  }
}
#declare Flag_bezier = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-8.685950, -8.062359, 0.000000>, <-7.000000, -8.000000, 0.250000>, <-5.823702, -7.294809, 0.500000>, <-4.992777, -7.382958, 0.375000>, 
      <-8.249436, -7.124718, 0.000000>, <-6.647405, -6.471107, 0.250000>, <-6.000000, -7.000000, 0.500000>, <-4.728330, -6.559256, 0.500000>, 
      <-7.875282, -6.155898, 0.000000>, <-7.000000, -6.000000, 0.500000>, <-6.250000, -6.000000, 0.750000>, <-5.500000, -6.000000, 0.375000>, 
      <-7.750564, -5.218257, 0.000000>, <-7.031180, -4.984410, 0.500000>, <-6.250000, -5.000000, 0.625000>, <-5.437500, -5.000000, 0.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-7.750564, -5.218257, 0.000000>, <-7.031180, -4.984410, 0.500000>, <-6.250000, -5.000000, 0.625000>, <-5.437500, -5.000000, 0.375000>, 
      <-7.625846, -4.280616, 0.000000>, <-7.062359, -3.968820, 0.500000>, <-6.250000, -4.000000, 0.500000>, <-5.375000, -4.000000, 0.375000>, 
      <-7.532307, -3.342975, 0.000000>, <-7.000000, -3.000000, 0.500000>, <-6.000000, -3.000000, 0.500000>, <-5.375000, -3.000000, 0.375000>, 
      <-7.485538, -2.420924, 0.000000>, <-7.062359, -2.046769, 0.500000>, <-6.125000, -2.000000, 0.500000>, <-5.375000, -2.000000, 0.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-7.485538, -2.420924, 0.000000>, <-7.062359, -2.046769, 0.500000>, <-6.125000, -2.000000, 0.500000>, <-5.375000, -2.000000, 0.375000>, 
      <-7.438768, -1.498873, 0.000000>, <-7.124718, -1.093539, 0.500000>, <-6.250000, -1.000000, 0.500000>, <-5.375000, -1.000000, 0.375000>, 
      <-7.532307, -0.436513, 0.000000>, <-6.812923, 0.000000, 0.500000>, <-6.250000, 0.000000, 0.500000>, <-5.500000, 0.000000, 0.375000>, 
      <-7.641435, 0.501127, 0.000000>, <-6.890872, 1.000000, 0.500000>, <-6.250000, 1.000000, 0.500000>, <-5.500000, 1.000000, 0.437500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-7.641435, 0.501127, 0.000000>, <-6.890872, 1.000000, 0.500000>, <-6.250000, 1.000000, 0.500000>, <-5.500000, 1.000000, 0.437500>, 
      <-7.750564, 1.438768, 0.000000>, <-6.968820, 2.000000, 0.500000>, <-6.250000, 2.000000, 0.500000>, <-5.500000, 2.000000, 0.500000>, 
      <-7.657025, 3.187077, 0.000000>, <-7.000000, 3.000000, 0.500000>, <-6.250000, 3.000000, 0.250000>, <-5.500000, 3.000000, 0.250000>, 
      <-7.828513, 4.093539, 0.000000>, <-7.078231, 3.984410, 0.500000>, <-6.375000, 4.000000, 0.125000>, <-5.625000, 4.000000, 0.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-7.828513, 4.093539, 0.000000>, <-7.078231, 3.984410, 0.500000>, <-6.375000, 4.000000, 0.125000>, <-5.625000, 4.000000, 0.250000>, 
      <-8.000000, 5.000000, 0.000000>, <-7.156461, 4.968820, 0.500000>, <-6.500000, 5.000000, 0.000000>, <-5.750000, 5.000000, 0.250000>, 
      <-8.124718, 5.750564, 0.000000>, <-6.878679, 5.931974, 0.500000>, <-6.000000, 6.000000, -0.250000>, <-5.375000, 6.000000, 0.000000>, 
      <-8.685950, 7.031180, 0.000000>, <-7.099769, 6.997167, 0.500000>, <-6.000000, 7.000000, -0.250000>, <-5.375000, 7.000000, 0.125000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-4.992777, -7.382958, 0.375000>, <-4.161851, -7.471107, 0.250000>, <-2.647405, -7.382958, 0.500000>, <-1.823702, -7.691479, 0.250000>, 
      <-4.728330, -6.559256, 0.500000>, <-3.456660, -6.118511, 0.500000>, <-3.000000, -7.000000, 1.000000>, <-2.000000, -7.044074, 0.500000>, 
      <-5.500000, -6.000000, 0.375000>, <-4.750000, -6.000000, 0.000000>, <-3.000000, -6.000000, 0.750000>, <-2.000000, -6.000000, 0.375000>, 
      <-5.437500, -5.000000, 0.375000>, <-4.625000, -5.000000, 0.125000>, <-3.000000, -5.000000, 0.750000>, <-2.000000, -5.000000, 0.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.437500, -5.000000, 0.375000>, <-4.625000, -5.000000, 0.125000>, <-3.000000, -5.000000, 0.750000>, <-2.000000, -5.000000, 0.375000>, 
      <-5.375000, -4.000000, 0.375000>, <-4.500000, -4.000000, 0.250000>, <-3.000000, -4.000000, 0.750000>, <-2.000000, -4.000000, 0.375000>, 
      <-5.375000, -3.000000, 0.375000>, <-4.750000, -3.000000, 0.250000>, <-3.000000, -3.000000, 0.750000>, <-2.000000, -3.000000, 0.375000>, 
      <-5.375000, -2.000000, 0.375000>, <-4.625000, -2.000000, 0.250000>, <-3.000000, -2.000000, 0.875000>, <-2.000000, -2.000000, 0.437500>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.375000, -2.000000, 0.375000>, <-4.625000, -2.000000, 0.250000>, <-3.000000, -2.000000, 0.875000>, <-2.000000, -2.000000, 0.437500>, 
      <-5.375000, -1.000000, 0.375000>, <-4.500000, -1.000000, 0.250000>, <-3.000000, -1.000000, 1.000000>, <-2.000000, -1.000000, 0.500000>, 
      <-5.500000, 0.000000, 0.375000>, <-4.750000, 0.000000, 0.250000>, <-3.000000, 0.000000, 1.000000>, <-2.000000, 0.000000, 0.500000>, 
      <-5.500000, 1.000000, 0.437500>, <-4.750000, 1.000000, 0.375000>, <-3.000000, 1.000000, 1.000000>, <-2.000000, 1.000000, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.500000, 1.000000, 0.437500>, <-4.750000, 1.000000, 0.375000>, <-3.000000, 1.000000, 1.000000>, <-2.000000, 1.000000, 0.500000>, 
      <-5.500000, 2.000000, 0.500000>, <-4.750000, 2.000000, 0.500000>, <-3.000000, 2.000000, 1.000000>, <-2.000000, 2.000000, 0.500000>, 
      <-5.500000, 3.000000, 0.250000>, <-4.750000, 3.000000, 0.250000>, <-3.250000, 3.000000, 0.500000>, <-2.250000, 3.000000, 0.125000>, 
      <-5.625000, 4.000000, 0.250000>, <-4.875000, 4.000000, 0.375000>, <-3.125000, 4.000000, 0.750000>, <-2.250000, 4.000000, 0.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.625000, 4.000000, 0.250000>, <-4.875000, 4.000000, 0.375000>, <-3.125000, 4.000000, 0.750000>, <-2.250000, 4.000000, 0.250000>, 
      <-5.750000, 5.000000, 0.250000>, <-5.000000, 5.000000, 0.500000>, <-3.000000, 5.000000, 1.000000>, <-2.250000, 5.000000, 0.375000>, 
      <-5.375000, 6.000000, 0.000000>, <-4.750000, 6.000000, 0.250000>, <-3.000000, 6.000000, 1.250000>, <-2.250000, 6.000000, 0.500000>, 
      <-5.375000, 7.000000, 0.125000>, <-4.750000, 7.000000, 0.500000>, <-3.625220, 6.732300, 1.250000>, <-2.687610, 6.866150, 0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.823702, -7.691479, 0.250000>, <-1.000000, -8.000000, 0.000000>, <-2.000000, -8.000000, -2.000000>, <-0.235553, -7.735553, -1.500000>, 
      <-2.000000, -7.044074, 0.500000>, <-1.000000, -7.088149, 0.000000>, <-2.000000, -7.000000, -2.000000>, <-0.500000, -7.000000, -1.500000>, 
      <-2.000000, -6.000000, 0.375000>, <-1.000000, -6.000000, 0.000000>, <-2.000000, -6.000000, -2.000000>, <-0.500000, -6.000000, -1.500000>, 
      <-2.000000, -5.000000, 0.375000>, <-1.000000, -5.000000, 0.000000>, <-2.000000, -5.000000, -2.000000>, <-0.500000, -5.000000, -1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -5.000000, 0.375000>, <-1.000000, -5.000000, 0.000000>, <-2.000000, -5.000000, -2.000000>, <-0.500000, -5.000000, -1.500000>, 
      <-2.000000, -4.000000, 0.375000>, <-1.000000, -4.000000, 0.000000>, <-2.000000, -4.000000, -2.000000>, <-0.500000, -4.000000, -1.500000>, 
      <-2.000000, -3.000000, 0.375000>, <-1.000000, -3.000000, 0.000000>, <-2.000000, -3.000000, -2.000000>, <-0.500000, -3.000000, -1.500000>, 
      <-2.000000, -2.000000, 0.437500>, <-1.000000, -2.000000, 0.000000>, <-2.000000, -2.000000, -2.000000>, <-0.500000, -2.000000, -1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.437500>, <-1.000000, -2.000000, 0.000000>, <-2.000000, -2.000000, -2.000000>, <-0.500000, -2.000000, -1.500000>, 
      <-2.000000, -1.000000, 0.500000>, <-1.000000, -1.000000, 0.000000>, <-2.000000, -1.000000, -2.000000>, <-0.500000, -1.000000, -1.500000>, 
      <-2.000000, 0.000000, 0.500000>, <-1.000000, 0.000000, 0.000000>, <-2.000000, 0.000000, -2.000000>, <-0.500000, 0.000000, -1.500000>, 
      <-2.000000, 1.000000, 0.500000>, <-1.000000, 1.000000, 0.000000>, <-2.000000, 1.000000, -2.000000>, <-0.500000, 1.000000, -1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, 1.000000, 0.500000>, <-1.000000, 1.000000, 0.000000>, <-2.000000, 1.000000, -2.000000>, <-0.500000, 1.000000, -1.500000>, 
      <-2.000000, 2.000000, 0.500000>, <-1.000000, 2.000000, 0.000000>, <-2.000000, 2.000000, -2.000000>, <-0.500000, 2.000000, -1.500000>, 
      <-2.250000, 3.000000, 0.125000>, <-1.250000, 3.000000, -0.250000>, <-2.000000, 3.000000, -2.000000>, <-0.500000, 3.000000, -1.500000>, 
      <-2.250000, 4.000000, 0.250000>, <-1.375000, 4.000000, -0.250000>, <-2.000000, 4.000000, -2.000000>, <-0.500000, 4.000000, -1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.250000, 4.000000, 0.250000>, <-1.375000, 4.000000, -0.250000>, <-2.000000, 4.000000, -2.000000>, <-0.500000, 4.000000, -1.500000>, 
      <-2.250000, 5.000000, 0.375000>, <-1.500000, 5.000000, -0.250000>, <-2.000000, 5.000000, -2.000000>, <-0.500000, 5.000000, -1.500000>, 
      <-2.250000, 6.000000, 0.500000>, <-1.500000, 6.000000, -0.250000>, <-1.500000, 6.000000, -1.500000>, <-0.035840, 5.812610, -1.250000>, 
      <-2.687610, 6.866150, 0.500000>, <-1.750000, 7.000000, -0.250000>, <-1.553981, 6.625220, -1.500000>, <0.008629, 6.705530, -1.375000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.235553, -7.735553, -1.500000>, <1.528893, -7.471107, -1.000000>, <3.000000, -8.000000, -0.500000>, <4.440744, -7.691479, -0.500000>, 
      <-0.500000, -7.000000, -1.500000>, <1.000000, -7.000000, -1.000000>, <3.528893, -6.382958, -0.500000>, <4.264447, -6.691479, -0.500000>, 
      <-0.500000, -6.000000, -1.500000>, <1.000000, -6.000000, -1.000000>, <3.000000, -6.000000, -0.500000>, <4.000000, -6.000000, -0.500000>, 
      <-0.500000, -5.000000, -1.500000>, <1.000000, -5.000000, -1.000000>, <3.000000, -5.000000, -0.500000>, <4.000000, -5.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.500000, -5.000000, -1.500000>, <1.000000, -5.000000, -1.000000>, <3.000000, -5.000000, -0.500000>, <4.000000, -5.000000, -0.500000>, 
      <-0.500000, -4.000000, -1.500000>, <1.000000, -4.000000, -1.000000>, <3.000000, -4.000000, -0.500000>, <4.000000, -4.000000, -0.500000>, 
      <-0.500000, -3.000000, -1.500000>, <1.000000, -3.000000, -1.000000>, <2.839380, -1.768581, -0.500000>, <3.919690, -2.384291, -0.500000>, 
      <-0.500000, -2.000000, -1.500000>, <1.000000, -2.000000, -1.000000>, <3.214160, -1.330751, -0.500000>, <4.107080, -1.665375, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.500000, -2.000000, -1.500000>, <1.000000, -2.000000, -1.000000>, <3.214160, -1.330751, -0.500000>, <4.107080, -1.665375, -0.500000>, 
      <-0.500000, -1.000000, -1.500000>, <1.000000, -1.000000, -1.000000>, <3.588939, -0.892920, -0.500000>, <4.294470, -0.946460, -0.500000>, 
      <-0.500000, 0.000000, -1.500000>, <1.000000, 0.000000, -1.000000>, <3.588939, 0.642479, -0.500000>, <4.294470, 0.321240, -0.500000>, 
      <-0.500000, 1.000000, -1.500000>, <1.000000, 1.000000, -1.000000>, <3.294470, 1.321240, -0.500000>, <4.147235, 1.160620, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.500000, 1.000000, -1.500000>, <1.000000, 1.000000, -1.000000>, <3.294470, 1.321240, -0.500000>, <4.147235, 1.160620, -0.500000>, 
      <-0.500000, 2.000000, -1.500000>, <1.000000, 2.000000, -1.000000>, <3.000000, 2.000000, -0.500000>, <4.000000, 2.000000, -0.500000>, 
      <-0.500000, 3.000000, -1.500000>, <1.000000, 3.000000, -1.000000>, <3.000000, 3.000000, -0.500000>, <4.000000, 3.000000, -0.500000>, 
      <-0.500000, 4.000000, -1.500000>, <1.000000, 4.000000, -1.000000>, <3.000000, 4.000000, -0.500000>, <4.000000, 4.000000, -0.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.500000, 4.000000, -1.500000>, <1.000000, 4.000000, -1.000000>, <3.000000, 4.000000, -0.500000>, <4.000000, 4.000000, -0.500000>, 
      <-0.500000, 5.000000, -1.500000>, <1.000000, 5.000000, -1.000000>, <3.000000, 5.000000, -0.500000>, <4.000000, 5.000000, -0.500000>, 
      <-0.035840, 5.812610, -1.250000>, <1.428320, 5.625220, -1.000000>, <3.000000, 6.000000, -0.500000>, <4.000000, 6.000000, -0.500000>, 
      <0.008629, 6.705530, -1.375000>, <1.571240, 6.785840, -1.250000>, <3.999559, 7.000000, -0.750000>, <4.606859, 6.919690, -0.750000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.440744, -7.691479, -0.500000>, <5.881489, -7.382958, -0.500000>, <6.000000, -8.000000, -1.000000>, <10.250000, -8.000000, -1.000000>, 
      <4.264447, -6.691479, -0.500000>, <5.000000, -7.000000, -0.500000>, <6.000000, -7.000000, -1.000000>, <10.734084, -8.043340, -1.000000>, 
      <4.000000, -6.000000, -0.500000>, <5.000000, -6.000000, -0.500000>, <6.000000, -6.000000, -1.000000>, <9.500000, -6.000000, -1.000000>, 
      <4.000000, -5.000000, -0.500000>, <5.000000, -5.000000, -0.500000>, <6.000000, -5.000000, -1.000000>, <9.125000, -5.000000, -1.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.000000, -5.000000, -0.500000>, <5.000000, -5.000000, -0.500000>, <6.000000, -5.000000, -1.000000>, <9.125000, -5.000000, -1.000000>, 
      <4.000000, -4.000000, -0.500000>, <5.000000, -4.000000, -0.500000>, <6.000000, -4.000000, -1.000000>, <8.750000, -4.000000, -1.000000>, 
      <3.919690, -2.384291, -0.500000>, <5.000000, -3.000000, -0.500000>, <6.000000, -3.000000, -1.000000>, <9.750000, -3.000000, -1.000000>, 
      <4.107080, -1.665375, -0.500000>, <5.000000, -2.000000, -0.500000>, <6.000000, -2.000000, -1.000000>, <9.500000, -2.125000, -1.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.107080, -1.665375, -0.500000>, <5.000000, -2.000000, -0.500000>, <6.000000, -2.000000, -1.000000>, <9.500000, -2.125000, -1.000000>, 
      <4.294470, -0.946460, -0.500000>, <5.000000, -1.000000, -0.500000>, <6.000000, -1.000000, -1.000000>, <9.250000, -1.250000, -1.000000>, 
      <4.294470, 0.321240, -0.500000>, <5.000000, 0.000000, -0.500000>, <6.000000, 0.000000, -1.000000>, <7.750000, -0.250000, -1.000000>, 
      <4.147235, 1.160620, -0.500000>, <5.000000, 1.000000, -0.500000>, <6.000000, 1.000000, -1.000000>, <7.875000, 0.500000, -1.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.147235, 1.160620, -0.500000>, <5.000000, 1.000000, -0.500000>, <6.000000, 1.000000, -1.000000>, <7.875000, 0.500000, -1.250000>, 
      <4.000000, 2.000000, -0.500000>, <5.000000, 2.000000, -0.500000>, <6.000000, 2.000000, -1.000000>, <8.000000, 1.250000, -1.500000>, 
      <4.000000, 3.000000, -0.500000>, <5.000000, 3.000000, -0.500000>, <6.000000, 3.000000, -1.000000>, <9.000000, 2.250000, -1.500000>, 
      <4.000000, 4.000000, -0.500000>, <5.000000, 4.000000, -0.500000>, <6.000000, 4.000000, -1.000000>, <9.250000, 3.250000, -1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.000000, 4.000000, -0.500000>, <5.000000, 4.000000, -0.500000>, <6.000000, 4.000000, -1.000000>, <9.250000, 3.250000, -1.500000>, 
      <4.000000, 5.000000, -0.500000>, <5.000000, 5.000000, -0.500000>, <6.000000, 5.000000, -1.000000>, <9.500000, 4.250000, -1.500000>, 
      <4.000000, 6.000000, -0.500000>, <5.000000, 6.000000, -0.500000>, <6.321240, 5.625220, -1.000000>, <9.000000, 5.750000, -1.750000>, 
      <4.606859, 6.919690, -0.750000>, <5.214160, 6.839380, -0.750000>, <6.571240, 6.785840, -1.250000>, <10.250000, 7.000000, -2.250000>
    }
  }
  material {
    Flag_Text
  }
  scale <1.0, 0.5, 1.0>
  rotate 90.0*x
  translate  <8.7, 0.0, 4.0>
}
#declare Flag = union {
  object { Flag_bezier }
  scale 0.2
  rotate -180.0*z
  translate  <-0.2, 0.0, -3.0>
}
#declare FlagApointe = union {
  sphere { // Sphere075
    <0,0,0>,1
    scale 0.3
  }
  cone { // Cone029
    <0,0,0>, 0.15, <0,0,1>, 0.0
    scale <1.0, 1.0, 2.0>
  }
  object { // Torus013->Torus014
    Torus014
    scale <0.9, 0.9, 1.0>
    translate  1.5*z
  }
  object { Torus014 }
  object { Flag }
  translate  35.0*z
}
#declare Cone031 = object {
  object { // Cone031->Cone023
    Cone023
    scale 0.5
    translate  <-0.2, 0.0, 24.5>
  }
}
#declare Mat = union {
  object { Torus006 }
  cone { // Cone020
    <0,0,0>, 1.2, <0,0,1>, 0.75
    scale <1.0, 1.0, 0.4>
  }
  cone { // Cone021
    <0,0,0>, 0.75, <0,0,1>, 0.25
    scale <1.0, 1.0, 35.0>
  }
  object { // Torus007->Torus006
    Torus006
    scale <0.9, 0.9, 1.0>
    translate  3.0*z
  }
  object { // Torus008->Torus006
    Torus006
    scale <0.9, 0.9, 1.0>
    translate  3.4*z
  }
  object { // Torus009->Torus006
    Torus006
    scale <0.9, 0.9, 1.0>
    translate  3.8*z
  }
  object { Torus010 }
  object { Cone022 }
  object { Cone023 }
  object { // Cone024->Cone023
    Cone023
    rotate 180.0*z
    translate  -3.5*x
  }
  object { // Torus011->Torus010
    Torus010
    scale <0.65, 0.65, 1.0>
    translate  10.0*z
  }
  object { // Cone025->Cone022
    Cone022
    translate  <0.1, 0.0, 12.0>
  }
  object { Cone026 }
  object { // Cone027->Cone026
    Cone026
    rotate 180.0*z
    translate  -3.33*x
  }
  object { Voile }
  object { Nacelle }
  object { FlagApointe }
  object { // Cone030->Cone022
    Cone022
    scale 0.7
    translate  23.1*z
  }
  object { Cone031 }
  object { // Cone032->Cone031
    Cone031
    rotate -180.0*z
    translate  -2.15*x
  }
  object { // Voile1->Voile
    Voile
    scale <0.7, 0.6, 0.7>
    rotate -0.0*z
    translate  14.5*z
  }
  material {
    Mat_txt
  }
  scale <1.5, 1.5, 1.7>
  rotate -90.0*z
  translate  <0.0, -45.0, 7.2>
}
#declare Cube022 = object {
  box { // Cube022
    <-1, -1, -1>, <1, 1, 1>
  }
}
#declare Torus016 = object {
  torus { // Torus016
    1.5, 0.5  rotate -x*90
    scale <0.5, 0.5, 0.2>
    translate  1.1*z
  }
}
#declare Cube023 = object {
  box { // Cube023
    <-1, -1, -1>, <1, 1, 1>
    material {
      S_Wood4
    }
    scale <3.0, 1.75, 0.2>
    translate  <-1.0, 0.0, 5.9>
  }
}
#declare Montant = union {
  object { // Cube021->Cube022
    Cube022
    translate  4.75*z
  }
  object { // Torus015->Torus016
    Torus016
    translate  2.5*z
  }
  sphere { // Sphere076
    <0,0,0>,1
    scale <1.0, 1.0, 1.5>
    translate  2.25*z
  }
  object { Torus016 }
  object { Cube022 }
  object { Cube023 }
  object { // Cube024->Cube023
    Cube023
    scale <1.0, 1.0, 0.666667>
    translate  -5.0*z
  }
  material {
    DMFWood6
  }
  scale <0.3, 0.3, 0.35>
  translate  <4.0, -68.5, 14.51>
}
#declare Montant31 = object {
  object { // Montant31->Montant
    Montant
    rotate <0.0, -0.0, 90.0>
    translate  <-58.26, -79.2, 0.0>
  }
}
#declare Montant8 = object {
  object { // Montant8->Montant
    Montant
    rotate 90.0*z
    translate  <-78.8, -72.5, 0.0>
  }
}
#declare Montant12 = object {
  object { // Montant12->Montant8
    Montant8
    rotate 22.0*z
    translate  <-26.2, -7.8, 0.0>
  }
}
#declare Montant16 = object {
  object { // Montant16->Montant12
    Montant12
    rotate -0.0*z
    translate  <2.705, -6.68, 0.0>
  }
}
#declare Montant17 = object {
  object { // Montant17->Montant16
    Montant16
    translate  <0.671, -1.67, 0.0>
  }
}
#declare Montant26 = object {
  object { // Montant26->Montant17
    Montant17
    rotate -44.0*z
    translate  <70.2, -28.0, 0.0>
  }
}
#declare Montant22 = object {
  object { // Montant22->Montant
    Montant
    rotate -0.0*y
    translate  <-2.6, -16.15, 0.0>
  }
}
#declare Montant18 = object {
  object { // Montant18->Montant
    Montant
    rotate <0.0, -0.0, 180.0>
    translate  <-2.4, -153.15, 0.0>
  }
}
#declare CSG009 = difference {
  cylinder { // Cylndr028
    <0,0,1>, <0,0,0>, 1 
    scale 0.4
    rotate -90.0*x
  }
  cylinder { // Cylndr029
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 0.6>
    rotate -90.0*x
    translate  -0.1*y
  }
  translate  <0.0, -1.2, 4.0>
}
#declare CSG011 = difference {
  cylinder { // Cylndr030
    <0,0,1>, <0,0,0>, 1 
    scale <1.5, 1.5, 0.4>
    rotate -90.0*x
  }
  cylinder { // Cylndr031
    <0,0,1>, <0,0,0>, 1 
    scale <1.25, 1.25, 0.6>
    rotate -90.0*x
    translate  -0.1*y
  }
  translate  <0.0, -1.2, 4.0>
}
#declare CSG020 = union {
  cylinder { // Cylndr032
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 1.45>
  }
  sphere { // Sphere077
    <0,0,0>,1
    scale <0.15, 0.15, 0.5>
    translate  1.7*z
  }
  translate  <0.0, -1.0, 4.25>
}
#declare Barre = union {
  object { CSG009 }
  object { CSG011 }
  object { CSG020 }
  object { // CSG021->CSG020
    CSG020
    rotate -45.0*y
    translate  <2.828427, 0.0, 1.171573>
  }
  object { // CSG022->CSG020
    CSG020
    rotate -90.0*y
    translate  <4.0, 0.0, 4.0>
  }
  object { // CSG023->CSG020
    CSG020
    rotate <180.0, -45.0, 180.0>
    translate  <2.828427, 0.0, 6.828427>
  }
  object { // CSG024->CSG020
    CSG020
    rotate <180.0, 0.0, 180.0>
    translate  <-0.0, 0.0, 8.0>
  }
  object { // CSG025->CSG020
    CSG020
    rotate <180.0, 45.0, 180.0>
    translate  <-2.828427, 0.0, 6.828427>
  }
  object { // CSG026->CSG020
    CSG020
    rotate 90.0*y
    translate  <-4.0, 0.0, 4.0>
  }
  object { // CSG027->CSG020
    CSG020
    rotate 45.0*y
    translate  <-2.828427, 0.0, 1.171573>
  }
  material {
    T_Wood33
  }
}
#declare Cylndr016 = object {
  cylinder { // Cylndr016
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 2.0>
    rotate -90.0*y
    translate  <-4.0, -2.0, 0.0>
  }
}
#declare Sphere079 = object {
  sphere { // Sphere079
    <0,0,0>,1
    scale 0.4
    translate  <-6.0, -2.0, 0.0>
  }
}
#declare Sphere082 = object {
  sphere { // Sphere082
    <0,0,0>,1
    scale 0.3
  }
}
#declare Gonds_Haut = union {
  object { Sphere082 }
  cylinder { // Cylndr018
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 3.0>
  }
  object { // Sphere083->Sphere082
    Sphere082
    translate  3.0*z
  }
  material {
    Cuivre
  }
  translate  <7.1, -1.2, 8.0>
}
#declare Champ_haut = object {
  box { // Champ_haut
    <-1, -1, -1>, <1, 1, 1>
    material {
      Ebony_Wood
    }
    scale <5.5, 1.15, 0.3>
    translate  -0.5*z
  }
}
#declare Sphere084 = object {
  sphere { // Sphere084
    <0,0,0>,1
    scale <0.4, 2.0, 0.4>
  }
}
#declare Cylndr041 = object {
  cylinder { // Cylndr041
    <0,0,1>, <0,0,0>, 1 
    scale <0.4, 2.0, 5.0>
  }
}
#declare Cylndr021 = object {
  object { // Cylndr021->Cylndr041
    Cylndr041
    rotate 90.0*y
  }
}
#declare Carreau = union {
  object { Sphere084 }
  object { // Cylndr019->Cylndr021
    Cylndr021
    translate  5.0*z
  }
  object { // Cylndr020->Cylndr021
    Cylndr021
    rotate -90.0*y
    translate  5.0*x
  }
  object { Cylndr021 }
  object { Cylndr041 }
  object { // Sphere085->Sphere084
    Sphere084
    translate  5.0*x
  }
  object { // Sphere086->Sphere084
    Sphere084
    translate  <5.0, 0.0, 5.0>
  }
  object { // Sphere087->Sphere084
    Sphere084
    translate  5.0*z
  }
  box { // Cube025
    <-1, -1, -1>, <1, 1, 1>
    material {
      Glass_1
    }
    scale <2.5, 1.4, 2.5>
    translate  <2.5, 0.0, 2.5>
  }
  scale <1.0, 0.75, 1.0>
  translate  <-5.0, 0.0, 2.0>
}
#declare Cube042 = object {
  box { // Cube042
    <-1, -1, -1>, <1, 1, 1>
    scale <0.09, 0.08, 0.045>
    translate  1.75*z
  }
}
#declare Cube043 = object {
  box { // Cube043
    <-1, -1, -1>, <1, 1, 1>
    material {
      Cuivre
    }
    scale <0.17, 0.22, 0.015>
    translate  <0.15, 0.0, 2.49>
  }
}
#declare Cube048 = object {
  object { // Cube048->Cube043
    Cube043
    scale <2.45, 1.0, 1.0>
    translate  <0.035, 0.0, -2.5>
  }
}
#declare Torus023 = object {
  torus { // Torus023
    1.1, 0.1  rotate -x*90
    scale <0.7, 0.7, 0.25>
    translate  0.4*z
  }
}
#declare Torus027 = object {
  torus { // Torus027
    1.5, 0.4  rotate -x*90
    scale <0.5, 0.5, 0.2>
    translate  8.0*z
  }
}
#declare SupportCanon = union {
  box { // Cube051
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 2.0, 0.2>
    rotate -0.0*x
    translate  <-3.5, -31.4, 8.5>
  }
  box { // Cube050
    <-1, -1, -1>, <1, 1, 1>
    material {
      S_Wood
    }
    scale <4.5, 2.0, 0.6>
    rotate -0.0*x
    translate  <-7.5, -31.4, 7.7>
  }
  material {
    S_Wood
  }
  translate  0.3*x
}
#declare Cylndr042 = object {
  cylinder { // Cylndr042
    <0,0,1>, <0,0,0>, 1 
    scale <0.7, 0.7, 0.3>
    rotate -90.0*x
  }
}
#declare RExt_Int = difference {
  object { Cylndr042 }
  object { // Cylndr043->Cylndr042
    Cylndr042
    scale <0.8, 2.0, 0.8>
    translate  -0.2*y
  }
}
#declare Cylndr044 = object {
  cylinder { // Cylndr044
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 0.3>
    rotate -90.0*x
  }
}
#declare RInt = difference {
  object { Cylndr044 }
  object { // Cylndr045->Cylndr044
    Cylndr044
    scale <0.41, 2.0, 0.41>
    translate  -0.1*y
  }
}
#declare Cylndr046 = object {
  cylinder { // Cylndr046
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Chrome_3A
    }
    scale <0.1, 0.1, 0.4>
    translate  <0.0, 0.15, 0.2>
  }
}
#declare Roue = union {
  object { RExt_Int }
  object { RInt }
  object { Cylndr046 }
  object { // Cylndr047->Cylndr046
    Cylndr046
    rotate -45.0*y
  }
  object { // Cylndr048->Cylndr046
    Cylndr046
    rotate -90.0*y
  }
  object { // Cylndr049->Cylndr046
    Cylndr046
    rotate <180.0, -45.0, 180.0>
  }
  object { // Cylndr050->Cylndr046
    Cylndr046
    rotate <180.0, 0.0, 180.0>
  }
  object { // Cylndr051->Cylndr046
    Cylndr046
    rotate <180.0, 45.0, 180.0>
  }
  object { // Cylndr052->Cylndr046
    Cylndr046
    rotate 90.0*y
  }
  object { // Cylndr053->Cylndr046
    Cylndr046
    rotate 45.0*y
  }
  material {
    Canon_Text
  }
  translate  <-3.0, -2.2, -2.8>
}
#declare TransSweep001 = prism {
  linear_sweep
  linear_spline
  -0.4,0.0
  18  // control points
  <0.0, 0.0>,
  <9.0, 0.0>,
  <9.0, 1.0>,
  <7.0, 1.0>,
  <7.0, 2.0>,
  <5.5, 2.0>,
  <5.5, 2.0>,
  <5.5, 2.5>,
  <4.5, 2.5>,
  <4.5, 3.0>,
  <2.917797, 3.0>,
  <2.876695, 2.708898>,
  <2.486299, 2.637005>,
  <2.126695, 2.705508>,
  <2.0, 3.0>,
  <0.25, 3.0>,
  <0.0, 2.75>,
  <0.0, 0.0>
  rotate -x*90
  scale <0.8, 0.8, 1.0>
  rotate 90.0*x
  translate  <-4.0, -1.35, -2.2>
}
#declare Cube035 = object {
  box { // Cube035
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 1.7, 0.2>
    translate  <-3.0, 0.0, -2.8>
  }
}
#declare Cylndr055 = object {
  cylinder { // Cylndr055
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 4.5>
    rotate -90.0*x
    translate  <-3.0, -2.25, -2.8>
  }
}
#declare Cube037 = object {
  box { // Cube037
    <-1, -1, -1>, <1, 1, 1>
    material {
      Canon_Text
    }
    scale <2.9, 0.25, 0.05>
    translate  <-1.2, -1.55, -1.32>
  }
}
#declare SuperQ001 = object {
  superellipsoid { // SuperQ001
    <0.1, 1.0>
    material {
      T_Chrome_3A
    }
    scale 0.07
    translate  <-0.2, 0.0, 1.05>
  }
}
#declare SuperQ011 = object {
  object { // SuperQ011->SuperQ001
    SuperQ001
    translate  <-1.0, -1.55, -0.81>
  }
}
#declare Attache_axe_canon = union {
  box { // Cube039
    <-1, -1, -1>, <1, 1, 1>
    material {
      Canon_Text
    }
    scale <1.0, 0.15, 0.02>
    translate  <-2.0, -1.55, 0.22>
  }
  object { SuperQ011 }
  object { // SuperQ012->SuperQ011
    SuperQ011
    rotate -0.0*y
    translate  <-0.3, 0.0, 0.0>
  }
  object { // SuperQ013->SuperQ011
    SuperQ011
    rotate -0.0*y
    translate  <-1.6, 0.0, 0.0>
  }
  object { // SuperQ014->SuperQ011
    SuperQ011
    rotate -0.0*y
    translate  <-1.3, 0.0, 0.0>
  }
}
#declare Torus017 = object {
  torus { // Torus017
    1.5, 0.2  rotate -x*90
    material {
      Canon_Text
    }
    scale 0.2
    rotate -90.0*x
    translate  <2.3, 1.55, -1.4>
  }
}
#declare Torus019 = object {
  torus { // Torus019
    1.0, 0.1  rotate -x*90
    rotate -90.0*y
  }
}
#declare Cylndr059 = object {
  cylinder { // Cylndr059
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 0.4>
    rotate -90.0*x
    translate  <-2.0, 0.9, 0.0>
  }
}
#declare Cylndr061 = object {
  cylinder { // Cylndr061
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 0.5>
    rotate -90.0*x
    translate  <-2.0, 1.3, 0.0>
  }
}
#declare Porte_canon = union {
  object { TransSweep001 }
  object { // TransSweep002->TransSweep001
    TransSweep001
    translate  3.1*y
  }
  box { // Cube034
    <-1, -1, -1>, <1, 1, 1>
    scale <3.6, 1.8, 0.2>
    translate  <-0.4, 0.0, -2.4>
  }
  cylinder { // Cylndr054
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 3.0>
    rotate -90.0*x
    translate  <-3.5, -1.5, -1.15>
  }
  object { Cube035 }
  object { // Cube036->Cube035
    Cube035
    translate  5.0*x
  }
  object { Cylndr055 }
  object { // Cylndr056->Cylndr055
    Cylndr055
    rotate <-0.0, 0.0, -0.0>
    translate  <5.0, 0.0, 0.0>
  }
  object { Cube037 }
  object { // Cube038->Cube037
    Cube037
    translate  3.1*y
  }
  object { Attache_axe_canon }
  object { // Attache_axe_canon1->Attache_axe_canon
    Attache_axe_canon
    translate  3.1*y
  }
  object { Torus017 }
  object { // Torus018->Torus017
    Torus017
    rotate <0.0, -0.0, -0.0>
    translate  -3.1*y
  }
  material {
    T_Wood1
  }
}
#declare Canon = union {
  cylinder { // Cylndr057
    <0,0,1>, <0,0,0>, 1 open
    scale <1.0, 1.0, 2.0>
    rotate -90.0*y
  }
  sphere { // Sphere088
    <0,0,0>,1
  }
  object { Torus019 }
  object { // Torus020->Torus019
    Torus019
    translate  -2.0*x
  }
  cylinder { // Cylndr058
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 0.3>
    rotate 45.0*y
    translate  <0.6, 0.0, 0.6>
  }
  torus { // Torus021
    1.5, 0.3  rotate -x*90
    scale 0.15
    rotate -90.0*x
    translate  <0.8, 0.0, -0.6>
  }
  object { Cylndr059 }
  object { // Cylndr060->Cylndr059
    Cylndr059
    translate  -2.2*y
  }
  object { Cylndr061 }
  object { // Cylndr064->Cylndr061
    Cylndr061
    rotate <-0.0, 0.0, -0.0>
    translate  -3.1*y
  }
  box { // Cube040
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 0.1, 0.05>
    translate  <-1.0, 0.0, 1.0>
  }
  box { // Cube053
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.1, 0.05>
    rotate -3.0*y
    translate  <-4.0, 0.0, 0.9>
  }
  object { SuperQ001 }
  object { // SuperQ002->SuperQ001
    SuperQ001
    translate  -0.5*x
  }
  object { // SuperQ003->SuperQ001
    SuperQ001
    translate  -1.0*x
  }
  object { // SuperQ004->SuperQ001
    SuperQ001
    translate  -1.5*x
  }
  object { // SuperQ005->SuperQ001
    SuperQ001
    translate  -2.0*x
  }
  object { // SuperQ006->SuperQ001
    SuperQ001
    translate  <-2.75, 0.0, -0.05>
  }
  object { // SuperQ007->SuperQ001
    SuperQ001
    translate  <-3.5, 0.0, -0.075>
  }
  object { // SuperQ008->SuperQ001
    SuperQ001
    translate  <-4.25, 0.0, -0.11>
  }
  object { // SuperQ009->SuperQ001
    SuperQ001
    translate  <-5.0, 0.0, -0.15>
  }
  object { // SuperQ010->SuperQ001
    SuperQ001
    translate  <-5.75, 0.0, -0.23>
  }
  object { // Torus022->Torus019
    Torus019
    scale 0.75
    translate  -6.0*x
  }
  cone { // Cone034
    <0,0,0>, 1.0, <0,0,1>, 0.75
    open
    scale <1.0, 1.0, 4.0>
    rotate -90.0*y
    translate  -2.0*x
  }
  material {
    Canon_Text
  }
  scale <1.5, 1.0, 1.0>
  translate  1.0*x
}
#declare Canon_ = union {
  object { Roue }
  object { Porte_canon }
  object { Canon }
  object { // Roue1->Roue
    Roue
    translate  5.0*x
  }
  object { // Roue2->Roue
    Roue
    translate  4.1*y
  }
  object { // Roue3->Roue
    Roue
    translate  <5.0, 4.1, 0.0>
  }
  scale 0.8
  rotate 2.0*y
  translate  <-6.2, -31.4, 11.18>
}
#declare GRCanon = union {
  object { SupportCanon }
  object { Canon_ }
  translate  5.8*y
}
#declare GRCanon3 = object {
  object { // GRCanon3->GRCanon
    GRCanon
    rotate -180.0*z
    translate  -51.0*y
  }
}
#declare Cube054 = object {
  box { // Cube054
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 0.1, 0.5>
    translate  <0.0, -1.9, 0.7>
  }
}
#declare Cube057 = object {
  box { // Cube057
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 1.8, 0.1>
    rotate -90.0*y
    translate  <-2.9, 0.0, 0.7>
  }
}
#declare Boulet001 = object {
  sphere { // Boulet001
    <0,0,0>,1
    material {
      Military_Brass_Metal
    }
    scale 0.75
    translate  <-2.1, 1.1, 1.0>
  }
}
#declare Caisse_boulets = union {
  object { Cube054 }
  box { // Cube055
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 2.0, 0.1>
    translate  0.1*z
  }
  object { // Cube056->Cube054
    Cube054
    translate  3.8*y
  }
  object { Cube057 }
  object { // Cube058->Cube057
    Cube057
    translate  5.8*x
  }
  box { // Cube059
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 2.0, 0.2>
    translate  <2.6, 0.0, -0.2>
  }
  object { Boulet001 }
  object { // Boulet002->Boulet001
    Boulet001
    translate  -1.5*y
  }
  object { // Boulet003->Boulet001
    Boulet001
    translate  <1.2, -2.2, 0.0>
  }
  object { // Boulet004->Boulet001
    Boulet001
    translate  <1.2, -0.75, 0.0>
  }
  object { // Boulet005->Boulet001
    Boulet001
    translate  2.4*x
  }
  object { // Boulet006->Boulet001
    Boulet001
    rotate 0.0*z
    translate  <2.4, -1.5, 0.0>
  }
  object { // Boulet007->Boulet001
    Boulet001
    translate  <3.6, -0.75, 0.0>
  }
  object { // Boulet008->Boulet001
    Boulet001
    translate  <3.6, -2.2, 0.0>
  }
  object { // Boulet009->Boulet001
    Boulet001
    translate  <0.5, -0.8, 1.0>
  }
  object { // Boulet010->Boulet001
    Boulet001
    rotate 0.0*z
    translate  <1.7, -1.6, 1.0>
  }
  object { // Boulet011->Boulet001
    Boulet001
    rotate 0.0*z
    translate  <2.7, -0.6, 1.0>
  }
  material {
    BoisJaune
  }
  scale 0.8
  rotate -4.5*y
  translate  <-8.2, -19.5, 7.5>
}
#declare Caisse_boulets5 = object {
  object { // Caisse_boulets5->Caisse_boulets
    Caisse_boulets
    rotate <0.0, -0.0, -180.0>
    translate  -39.0*y
  }
}
#declare Cube061 = object {
  box { // Cube061
    <-1, -1, -1>, <1, 1, 1>
    material {
      Ferrures
    }
    scale <3.05, 2.05, 0.05>
    translate  1.5*z
  }
}
#declare Sphere089 = object {
  sphere { // Sphere089
    <0,0,0>,1
    scale 0.1
  }
}
#declare Coffre_gond = union {
  cylinder { // Cylndr066
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.1, 1.0>
    rotate -90.0*y
  }
  object { Sphere089 }
  object { // Sphere090->Sphere089
    Sphere089
    translate  -1.0*x
  }
  translate  <-1.5, 2.1, 1.5>
  material {
    Ferrures
    // Transform to world space
    translate  <-4.7, 66.3, -8.2>
    rotate -180.0*z
    scale 1.0/0.5
    translate  <0.0, -0.111111, 18.444445>
    scale 1.0/1.666667
    translate  -131.0*z
  }
}
#declare TransSweep004 = prism {
  linear_sweep
  cubic_spline
  -0.1,0.0
  49  // control points
  <-0.75, 1.75>,
  <-0.5, 1.75>,
  <-0.5, 0.0>,
  <0.5, 0.0>,
  <0.5, 1.75>,
  <0.75, 1.75>,
  <0.75, 1.5>,
  <1.0, 1.25>,
  <1.25, 1.5>,
  <1.25, 1.75>,
  <1.5, 1.75>,
  <1.75, 2.0>,
  <1.75, 2.0>,
  <1.5, 2.25>,
  <1.25, 2.25>,
  <1.25, 2.5>,
  <1.0, 2.75>,
  <0.75, 2.5>,
  <0.75, 2.25>,
  <0.25, 2.25>,
  <0.25, 2.75>,
  <0.5, 2.75>,
  <0.75, 3.0>,
  <0.5, 3.25>,
  <0.25, 3.25>,
  <0.25, 3.5>,
  <0.0, 3.75>,
  <-0.25, 3.5>,
  <-0.25, 3.25>,
  <-0.5, 3.25>,
  <-0.75, 3.0>,
  <-0.5, 2.75>,
  <-0.25, 2.75>,
  <-0.25, 2.25>,
  <-0.75, 2.25>,
  <-0.75, 2.5>,
  <-1.0, 2.75>,
  <-1.25, 2.5>,
  <-1.25, 2.25>,
  <-1.5, 2.25>,
  <-1.75, 2.0>,
  <-1.5, 1.75>,
  <-1.25, 1.75>,
  <-1.25, 1.5>,
  <-1.0, 1.25>,
  <-0.75, 1.5>,
  <-0.75, 1.75>,
  <-0.5, 1.75>,
  <-0.5, 0.0>
  rotate -x*90
  scale <0.4, 0.5, 0.1>
  rotate -90.0*x
}
#declare SuperQ015 = object {
  superellipsoid { // SuperQ015
    <0.1, 2.0>
    scale 0.1
    rotate -90.0*x
    translate  -0.3*z
    material {
      Gold_Texture
      // Transform to world space
      translate  <2.0, -2.0, -1.5>
      translate  <-4.7, 66.3, -8.2>
      rotate -180.0*z
      scale 1.0/0.5
      translate  <0.0, -0.111111, 18.444445>
      scale 1.0/1.666667
      translate  -131.0*z
    }
  }
}
#declare SuperQ016 = object {
  object { // SuperQ016->SuperQ015
    SuperQ015
    rotate -0.0*x
    translate  -0.5*z
  }
}
#declare Fer_Gond = union {
  object { TransSweep004 }
  object { SuperQ015 }
  object { SuperQ016 }
  cylinder { // Cylndr067
    <0,0,1>, <0,0,0>, 1 
    material {
      Ferrures
    }
    scale <2.05, 2.05, 0.4>
    rotate -90.0*y
    translate  <0.2, -2.0, 0.0>
  }
  object { // TransSweep005->TransSweep004
    TransSweep004
    translate  -4.01*y
  }
  object { // SuperQ017->SuperQ015
    SuperQ015
    rotate -0.0*x
    translate  -4.0*y
  }
  object { // SuperQ018->SuperQ016
    SuperQ016
    translate  -4.0*y
  }
  material {
    Ferrures
  }
  translate  <-2.0, 2.0, 1.5>
}
#declare Torus030 = object {
  torus { // Torus030
    1.5, 0.3  rotate -x*90
    sturm
  }
}
#declare Cone035 = object {
  cone { // Cone035
    <0,0,0>, 2.0, <0,0,1>, 1.0
    scale <1.0, 1.0, 2.0>
    translate  0.3*z
  }
}
#declare Cylndr071 = object {
  cylinder { // Cylndr071
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 0.8>
    rotate -90.0*x
    translate  <0.0, 2.3, 4.45>
  }
}
#declare Cone037 = object {
  cone { // Cone037
    <0,0,0>, 0.14, <0,0,1>, 0.2
    scale <1.0, 1.0, 0.3>
    rotate -90.0*x
    translate  <0.0, 3.1, 4.45>
  }
}
#declare TransSweep007 = prism {
  linear_sweep
  linear_spline
  -0.4,0.0
  13  // control points
  <0.0, 0.0>,
  <0.75, -0.25>,
  <2.5, -0.5>,
  <4.0, 0.0>,
  <4.75, 1.5>,
  <4.75, 2.25>,
  <4.25, 1.25>,
  <3.75, 0.5>,
  <2.5, 0.0>,
  <0.936833, 0.451729>,
  <0.549466, 1.0>,
  <0.0, 1.0>,
  <0.0, 0.0>
  rotate -x*90
  scale <0.8, 1.0, 1.0>
  rotate <90.0, 0.0, -90.0>
  translate  <0.2, 0.0, 0.6>
}
#declare TransSweep008 = prism {
  linear_sweep
  linear_spline
  -0.2,0.0
  5  // control points
  <-1.0, -0.25>,
  <0.0, 0.25>,
  <1.0, -0.25>,
  <0.0, 2.0>,
  <-1.0, -0.25>
  rotate -x*90
  rotate 90.0*x
  translate  <0.0, -3.7, 2.0>
}
#declare Pointe = union {
  object { TransSweep008 }
  object { // TransSweep009->TransSweep008
    TransSweep008
    rotate -90.0*z
    translate  <3.8, -3.8, 0.2>
  }
}
#declare TransSweep010 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  21  // control points
  <-1.0, 1.5>,
  <-2.0, 0.0>,
  <-1.25, 0.0>,
  <-0.75, 0.25>,
  <-0.5, 1.0>,
  <0.0, 1.25>,
  <0.5, 1.0>,
  <0.75, 0.25>,
  <1.25, 0.0>,
  <2.0, 0.0>,
  <1.0, 1.5>,
  <2.0, 2.75>,
  <1.75, 3.0>,
  <1.5, 3.0>,
  <1.0, 2.5>,
  <0.0, 2.0>,
  <-1.0, 2.5>,
  <-1.5, 3.0>,
  <-1.75, 3.0>,
  <-2.0, 2.75>,
  <-1.0, 1.5>
  rotate -x*90
  material {
    DMFWood6
  }
  scale <50.0, 40.0, 10.0>
  rotate 90.0*x
  translate  <0.0, 100.0, -131.0>
}




//
// ********  OBJECTS  *******
//



//
// Include file contains 'Bouteille'
//
#include "sea6.in1"
#declare Bouteille = object {
  Bouteille_Raw
  material {
    Glass_1
  }
  scale 30.0
  rotate -90.0*x
  translate  <0.0, -230.0, 40.0>
}
#declare BezPtch002 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.377465, -3.000000, 0.015962>, <-1.750000, -3.000000, 0.000000>, <-0.995389, -2.731241, 0.000000>, <0.125000, -2.754611, 0.125000>, 
      <-2.050382, -1.977660, -0.077171>, <-1.500000, -2.000000, 0.000000>, <-0.750000, -2.000000, -0.250000>, <0.125000, -2.000000, -0.125000>, 
      <-2.229918, -0.932979, -0.091372>, <-1.750000, -1.000000, 0.000000>, <-0.890222, -0.976630, 0.000000>, <-0.155445, -0.988315, 0.000000>, 
      <-2.424995, 0.033510, 0.063352>, <-1.586407, -0.011685, 0.000000>, <-0.632400, -0.023370, 0.082950>, <0.078633, -0.024831, -0.028636>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.424995, 0.033510, 0.063352>, <-1.586407, -0.011685, 0.000000>, <-0.632400, -0.023370, 0.082950>, <0.078633, -0.024831, -0.028636>, 
      <-2.620072, 1.000000, 0.218075>, <-1.422815, 0.976630, 0.000000>, <-0.374579, 0.929889, 0.165901>, <0.312711, 0.938653, -0.057272>, 
      <-2.642412, 2.022340, 0.234038>, <-1.757074, 2.000000, 0.000000>, <-0.750000, 2.000000, 0.000000>, <-0.061963, 2.011685, 0.125000>, 
      <-2.526526, 3.000000, 0.265962>, <-1.436150, 3.543708, 0.000000>, <-0.534111, 3.807124, -0.250000>, <0.072288, 3.802923, 0.022623>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.125000, -2.754611, 0.125000>, <1.245389, -2.777981, 0.250000>, <2.250000, -3.000000, 0.250000>, <3.000000, -3.000000, 0.500000>, 
      <0.125000, -2.000000, -0.125000>, <1.000000, -2.000000, 0.000000>, <2.250000, -2.000000, 0.250000>, <2.547761, -1.977660, 0.000000>, 
      <-0.155445, -0.988315, 0.000000>, <0.579333, -1.000000, 0.000000>, <1.555963, -1.000000, 0.000000>, <3.026598, -0.865959, 0.500000>, 
      <0.078633, -0.024831, -0.028636>, <0.789666, -0.026292, -0.140222>, <1.777981, -0.026292, -0.157750>, <2.793557, 0.009625, 0.207746>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.078633, -0.024831, -0.028636>, <0.789666, -0.026292, -0.140222>, <1.777981, -0.026292, -0.157750>, <2.793557, 0.009625, 0.207746>, 
      <0.312711, 0.938653, -0.057272>, <1.000000, 0.947417, -0.280445>, <2.000000, 0.947417, -0.315500>, <2.560516, 0.885208, -0.084508>, 
      <-0.061963, 2.011685, 0.125000>, <0.626074, 2.023370, 0.250000>, <1.548888, 2.023370, 0.250000>, <2.447400, 1.954289, 0.000000>, 
      <0.072288, 3.802923, 0.022623>, <0.678688, 3.798722, 0.295246>, <2.122300, 3.276682, 0.250000>, <2.754143, 3.142641, 0.250000>
    }
  }
  material {
    Pacific
  }
  scale <22.222223, 50.0, 44.444447>
  translate  <0.0, -61.000002, -18.444445>
}
#declare Pancarte = union {
  box { // Cube008
    <-1, -1, -1>, <1, 1, 1>
    material {
      Cuivre
    }
    scale <6.0, 0.3, 0.1>
    translate  <0.0, -85.9, 10.0>
  }
  box { // Cube007
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Stone
    }
    scale <4.0, 0.3, 1.0>
    translate  <0.0, -85.8, 9.0>
  }
}
#declare CSG013 = difference {
  box { // Cube011
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 10.65, 4.0>
    rotate -90.0*z
    translate  <0.0, -68.0, 9.1>
  }
  box { // Cube028
    <-1, -1, -1>, <1, 1, 1>
    rotate -180.0*z
    translate  <-7.0, -68.2, 10.85>
  }
  scale <1.0, 1.0, 1.176471>
}
#declare CSG014 = difference {
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 7.0, 4.705882>
    rotate -90.0*z
    translate  <0.0, -85.0, 12.529412>
  }
  object { Cylndr036 }
  object { Cube027 }
  object { // Cylndr037->Cylndr036
    Cylndr036
    rotate 0.0*x
    translate  4.0*x
  }
  object { // Cylndr038->Cylndr036
    Cylndr036
    rotate 0.0*x
    translate  8.0*x
  }
  object { // Cube029->Cube027
    Cube027
    rotate -0.0*y
    translate  4.0*x
  }
  object { // Cube030->Cube027
    Cube027
    rotate -0.0*y
    translate  8.0*x
  }
  scale <1.0, 1.0, 0.85>
  translate  0.9*z
}
#declare CSG015 = difference {
  object { // Cube010->Cube009
    Cube009
    translate  0.0*x
  }
  object { Cylndr039 }
  object { // Cylndr040->Cylndr036
    Cylndr036
    scale <0.88, 0.88, 1.0>
    rotate -90.0*z
    translate  <64.6, -77.1, -1.3>
  }
  object { Cube031 }
  object { // Cube032->Cube027
    Cube027
    scale 0.88
    rotate <0.0, -0.0, -90.0>
    translate  <64.4, -77.1, 1.15>
  }
  translate  20.7*x
}
#declare CSG017 = difference {
  object { Cube009 }
  object { // Cylndr083->Cylndr039
    Cylndr039
    rotate <-0.0, -0.0, 0.0>
  }
  object { // Cylndr084->Cylndr039
    Cylndr039
    rotate <-0.0, -0.0, 0.0>
    translate  -3.6*y
  }
  object { // Cube066->Cube031
    Cube031
    rotate <-0.0, -0.0, 0.0>
    translate  0.0*y
  }
  object { // Cube067->Cube031
    Cube031
    rotate <-0.0, -0.0, 0.0>
    translate  -3.65*y
  }
}
#declare CSG018 = difference {
  object { // Cube002->Cube004
    Cube004
    scale <1.0, 1.0, 0.85>
    rotate <-0.0, -0.0, 44.0>
    translate  <-70.9, -28.8, -1.1>
  }
}
#declare CSG019 = difference {
  object { Cube004 }
}
#declare Pont_arriere = union {
  object { CSG013 }
  object { CSG014 }
  object { CSG015 }
  cylinder { // Cylndr063
    <0,0,1>, <0,0,0>, 1 
    scale <0.9, 0.9, 10.0>
    translate  <0.0, -76.05, 5.4>
  }
  object { CSG017 }
  object { CSG018 }
  object { CSG019 }
  material {
    Mat_txt
  }
  scale <1.0, 1.0, 0.85>
  translate  0.85*z
}
#declare TaperSweep009 = prism {
  conic_sweep
  cubic_spline
  0.1,1.0
  14  // control points
  <-1.0, 0.0>,
  <-0.7, -0.3>,
  <-0.3, -0.7>,
  <0.0, -0.7>,
  <0.0, -0.6>,
  <-0.2, -0.6>,
  <-0.2, 0.6>,
  <0.0, 0.6>,
  <0.0, 0.7>,
  <-0.3, 0.7>,
  <-0.7, 0.3>,
  <-1.0, 0.0>,
  <-0.7, -0.3>,
  <-0.3, -0.7>
  rotate <90,0,90>
  scale 5.0
  rotate 90.0*x
  translate  5.0*z
}
#declare TaperSweep011 = prism {
  conic_sweep
  cubic_spline
  2.0,1.5
  14  // control points
  <-1.0, 0.0>,
  <-0.7, -0.3>,
  <-0.3, -0.7>,
  <0.0, -0.7>,
  <0.0, -0.6>,
  <-0.2, -0.6>,
  <-0.2, 0.6>,
  <0.0, 0.6>,
  <0.0, 0.7>,
  <-0.3, 0.7>,
  <-0.7, 0.3>,
  <-1.0, 0.0>,
  <-0.7, -0.3>,
  <-0.3, -0.7>
  rotate <90,0,90>
  scale <5.0, 5.0, 15.0>
  rotate 90.0*x
  translate  <0.0, 13.0, 5.0>
}
#declare TaperSweep012 = prism {
  conic_sweep
  cubic_spline
  2.5,2.0
  14  // control points
  <-1.0, 0.0>,
  <-0.7, -0.3>,
  <-0.3, -0.7>,
  <0.0, -0.7>,
  <0.0, -0.6>,
  <-0.2, -0.6>,
  <-0.2, 0.6>,
  <0.0, 0.6>,
  <0.0, 0.7>,
  <-0.3, 0.7>,
  <-0.7, 0.3>,
  <-1.0, 0.0>,
  <-0.7, -0.3>,
  <-0.3, -0.7>
  rotate <90,0,90>
  scale <5.0, 5.0, 40.0>
  rotate 90.0*x
  translate  <0.0, 63.0, 5.0>
}
#declare TaperSweep013 = prism {
  conic_sweep
  cubic_spline
  2.4,2.5
  14  // control points
  <-1.0, 0.0>,
  <-0.7, -0.3>,
  <-0.3, -0.7>,
  <0.0, -0.7>,
  <0.0, -0.6>,
  <-0.2, -0.6>,
  <-0.2, 0.6>,
  <0.0, 0.6>,
  <0.0, 0.7>,
  <-0.3, 0.7>,
  <-0.7, 0.3>,
  <-1.0, 0.0>,
  <-0.7, -0.3>,
  <-0.3, -0.7>
  rotate <90,0,90>
  scale <5.0, 5.0, 400.0>
  rotate <90.0, 0.0, -180.0>
  translate  <0.0, -1037.0, 5.0>
}
#declare TaperSweep014 = prism {
  conic_sweep
  cubic_spline
  2.3,2.4
  14  // control points
  <-1.0, 0.0>,
  <-0.7, -0.3>,
  <-0.3, -0.7>,
  <0.0, -0.7>,
  <0.0, -0.6>,
  <-0.2, -0.6>,
  <-0.2, 0.6>,
  <0.0, 0.6>,
  <0.0, 0.7>,
  <-0.3, 0.7>,
  <-0.7, 0.3>,
  <-1.0, 0.0>,
  <-0.7, -0.3>,
  <-0.3, -0.7>
  rotate <90,0,90>
  scale <5.0, 5.0, 300.0>
  rotate <90.0, 0.0, 180.0>
  translate  <0.0, -797.0, 5.0>
}
#declare TaperSweep015 = prism {
  conic_sweep
  cubic_spline
  1.5,2.3
  14  // control points
  <-1.0, 0.0>,
  <-0.7, -0.3>,
  <-0.3, -0.7>,
  <0.0, -0.7>,
  <0.0, -0.6>,
  <-0.2, -0.6>,
  <-0.2, 0.6>,
  <0.0, 0.6>,
  <0.0, 0.7>,
  <-0.3, 0.7>,
  <-0.7, 0.3>,
  <-1.0, 0.0>,
  <-0.7, -0.3>,
  <-0.3, -0.7>
  rotate <90,0,90>
  scale <5.0, 5.0, 15.0>
  rotate <90.0, 0.0, -180.0>
  translate  <0.0, -141.5, 5.0>
}
#declare TaperSweep016 = prism {
  conic_sweep
  cubic_spline
  1.3,1.5
  13  // control points
  <-1.0, 0.0>,
  <-0.7, -0.3>,
  <-0.3, -0.7>,
  <0.0, -0.7>,
  <0.0, -0.6>,
  <-0.000147, 0.0>,
  <0.0, 0.6>,
  <0.0, 0.7>,
  <-0.3, 0.7>,
  <-0.7, 0.3>,
  <-1.0, 0.0>,
  <-0.7, -0.3>,
  <-0.3, -0.7>
  rotate <90,0,90>
  scale 5.0
  rotate <90.0, 0.0, 180.0>
  translate  <0.0, -126.5, 5.0>
}
#declare TaperSweep010 = prism {
  conic_sweep
  cubic_spline
  1.0,1.5
  14  // control points
  <-1.0, 0.0>,
  <-0.7, -0.3>,
  <-0.3, -0.7>,
  <0.0, -0.7>,
  <0.0, -0.6>,
  <-0.2, -0.6>,
  <-0.2, 0.6>,
  <0.0, 0.6>,
  <0.0, 0.7>,
  <-0.3, 0.7>,
  <-0.7, 0.3>,
  <-1.0, 0.0>,
  <-0.7, -0.3>,
  <-0.3, -0.7>
  rotate <90,0,90>
  scale <5.0, 5.0, 9.0>
  rotate 90.0*x
  translate  <0.0, 4.0, 5.0>
}
#declare CSG016 = difference {
  object { TaperSweep010 }
  cylinder { // Cylndr082
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 2.0>
    rotate <0.0, -100.0, -45.0>
    translate  <-3.9, -8.8, 4.0>
  }
}
#declare Coque1 = union {
  object { TaperSweep009 }
  object { TaperSweep011 }
  object { TaperSweep012 }
  object { TaperSweep013 }
  object { TaperSweep014 }
  object { TaperSweep015 }
  object { TaperSweep016 }
  object { CSG016 }
  material {
    S_Wood
  }
  scale <1.5, 0.8, 1.0>
  translate  <0.0, 10.0, 5.0>
}
#declare Batant = merge {
  cone { // Cone017
    <0,0,0>, 0.1, <0,0,1>, 0.15
  }
  sphere { // Sphere074
    <0,0,0>,1
    scale 0.2
  }
  material {
    Cuivre
  }
  scale <1.0, 1.0, 1.5>
  translate  0.1*z
}
//
// Include file contains 'RotSweep002'
//
#include "sea6.in2"
#declare RotSweep002 = object {
  RotSweep002_Raw
  material {
    Gold_Texture
  }
}
#declare Cloche = union {
  torus { // Torus003
    1.5, 0.5  rotate -x*90
    material {
      Gold_Texture
    }
    scale <0.15, 0.15, 0.3>
    rotate -90.0*x
    translate  4.4*z
  }
  cylinder { // Cylndr022
    <0,0,1>, <0,0,0>, 1 
    material {
      T_Chrome_1A
    }
    scale <0.2, 0.2, 5.0>
    rotate -90.0*y
    translate  <2.5, 0.0, 2.8>
  }
  box { // Cube013
    <-1, -1, -1>, <1, 1, 1>
    material {
      T_Wood5
    }
    scale <2.0, 0.3, 0.3>
    translate  2.8*z
  }
  object { RotSweep002 }
}
#declare Support = union {
  cylinder { // Cylndr023
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.3, 5.0>
    translate  <2.2, 0.0, -2.6>
  }
  cylinder { // Cylndr024
    <0,0,1>, <0,0,0>, 1 
    scale <0.1, 0.3, 5.0>
    translate  <-2.2, 0.0, -2.6>
  }
  torus { // Torus004
    1.5, 0.5  rotate -x*90
    scale 0.3
    rotate -90.0*y
    translate  <2.2, 0.0, 2.9>
  }
  torus { // Torus005
    1.5, 0.5  rotate -x*90
    scale 0.3
    rotate -90.0*y
    translate  <-2.2, 0.0, 2.9>
  }
  cone { // Cone018
    <0,0,0>, 0.8, <0,0,1>, 0.5
    material {
      Black_Vein_Granit
    }
    translate  <2.2, 0.0, -2.6>
  }
  cone { // Cone019
    <0,0,0>, 0.8, <0,0,1>, 0.5
    material {
      Black_Vein_Granit
    }
    translate  <-2.2, 0.0, -2.6>
  }
  material {
    Cuivre
  }
}
#declare Cloche_ = union {
  object { Batant }
  object { Cloche }
  object { Support }
  scale 0.6
  translate  <0.0, -66.0, 8.9>
}
#declare Fenetres = union {
  object { // Fenetre6->Fenetre4
    Fenetre4
    rotate <-0.0, 0.0, -44.0>
    translate  <70.7, -28.3, 0.0>
  }
  object { // Fenetre2->Fenetre
    Fenetre
    rotate <0.0, -0.0, -0.0>
    translate  <8.0, 0.0, 0.0>
  }
  object { Fenetre }
  object { // Fenetre1->Fenetre
    Fenetre
    rotate <0.0, -0.0, -0.0>
    translate  <4.0, 0.0, 0.0>
  }
  object { Fenetre3 }
  object { Fenetre4 }
  object { // Fenetre5->Fenetre3
    Fenetre3
    rotate -44.0*z
    translate  <70.5, -28.7, 0.0>
  }
  object { Fenetre7 }
  object { Fenetre8 }
  object { // Fenetre9->Fenetre7
    Fenetre7
    rotate -0.0*z
    translate  20.7*x
  }
  object { // Fenetre10->Fenetre8
    Fenetre8
    rotate -0.0*z
    translate  20.7*x
  }
}
#declare Escalier = union {
  object { Marche1 }
  object { // Marche2->Marche1
    Marche1
    translate  <1.4, 0.0, 0.9>
  }
  object { // Marche3->Marche1
    Marche1
    translate  <2.8, 0.0, 1.8>
  }
  object { // Marche4->Marche1
    Marche1
    translate  <4.2, 0.0, 2.7>
  }
  object { // Marche5->Marche1
    Marche1
    translate  <5.6, 0.0, 3.6>
  }
  object { // Marche6->Marche1
    Marche1
    translate  <7.0, 0.0, 4.5>
  }
  object { // Marche7->Marche1
    Marche1
    translate  <8.4, 0.0, 5.4>
  }
  scale <0.8, 0.9, 1.0>
  rotate -90.0*z
  translate  <6.5, -59.1, 7.2>
}
#declare Pont_sup = union {
  box { // Cube016
    <-1, -1, -1>, <1, 1, 1>
    scale <10.9, 4.25, 0.1>
    translate  <0.1, -71.75, 14.0>
  }
  box { // Cube017
    <-1, -1, -1>, <1, 1, 1>
    scale <1.8, 5.0, 0.1>
    rotate 22.0*z
    translate  <-7.2, -79.9, 14.0>
  }
  box { // Cube018
    <-1, -1, -1>, <1, 1, 1>
    scale <7.0, 5.0, 0.1>
    translate  <0.0, -80.0, 14.0>
  }
  box { // Cube019
    <-1, -1, -1>, <1, 1, 1>
    scale <1.8, 5.0, 0.1>
    rotate -22.0*z
    translate  <7.2, -79.9, 14.0>
  }
  box { // Cube020
    <-1, -1, -1>, <1, 1, 1>
    scale <7.0, 0.3, 0.2>
    translate  <0.0, -85.3, 14.0>
    material {
      T_Stone
      // Transform to world space
      translate  <0.0, -0.111111, 18.444445>
      scale 1.0/1.666667
      translate  -131.0*z
    }
  }
  material {
    DMFWood
  }
}
#declare Barriere_pont_sup = union {
  object { // Montant36->Montant
    Montant
    rotate <0.0, -0.0, 180.0>
    translate  <12.5, -137.0, 0.0>
  }
  object { // Montant35->Montant
    Montant
    rotate <0.0, -0.0, 90.0>
    translate  <-58.26, -72.6, 0.0>
  }
  object { // Montant34->Montant31
    Montant31
    rotate -0.0*z
    translate  5.4*y
  }
  object { // Montant33->Montant31
    Montant31
    rotate -0.0*z
    translate  3.6*y
  }
  object { // Montant32->Montant31
    Montant31
    rotate -0.0*z
    translate  1.8*y
  }
  object { Montant31 }
  object { // Montant30->Montant26
    Montant26
    translate  <2.695, 6.68, 0.0>
  }
  object { // Montant29->Montant26
    Montant26
    translate  <2.02, 5.01, 0.0>
  }
  object { // Montant28->Montant26
    Montant26
    translate  <1.344, 3.34, 0.0>
  }
  object { // Montant27->Montant26
    Montant26
    translate  <0.67, 1.67, 0.0>
  }
  object { Montant26 }
  object { // Montant25->Montant22
    Montant22
    rotate -0.0*x
    translate  5.4*x
  }
  object { // Montant24->Montant22
    Montant22
    rotate -0.0*x
    translate  3.6*x
  }
  object { // Montant23->Montant22
    Montant22
    rotate -0.0*x
    translate  1.8*x
  }
  object { Montant22 }
  object { // Montant21->Montant18
    Montant18
    rotate <0.0, 0.0, 0.0>
    translate  <5.4, 0.0, -0.0>
  }
  object { // Montant20->Montant18
    Montant18
    rotate <0.0, 0.0, 0.0>
    translate  <3.6, 0.0, -0.0>
  }
  object { // Montant19->Montant18
    Montant18
    rotate <0.0, 0.0, 0.0>
    translate  <1.8, 0.0, -0.0>
  }
  object { Montant18 }
  object { Montant17 }
  object { Montant16 }
  object { // Montant15->Montant12
    Montant12
    rotate -0.0*z
    translate  <2.03, -5.01, 0.0>
  }
  object { // Montant14->Montant12
    Montant12
    rotate -0.0*z
    translate  <1.355, -3.34, 0.0>
  }
  object { // Montant13->Montant12
    Montant12
    rotate -0.0*z
    translate  <0.68, -1.67, 0.0>
  }
  object { Montant12 }
  object { // Montant11->Montant8
    Montant8
    rotate 0.0*z
    translate  <-0.0, -5.4, 0.0>
  }
  object { // Montant10->Montant8
    Montant8
    rotate 0.0*z
    translate  <-0.0, -3.6, 0.0>
  }
  object { // Montant9->Montant8
    Montant8
    rotate 0.0*z
    translate  <-0.0, -1.8, 0.0>
  }
  object { Montant8 }
  object { // Montant7->Montant
    Montant
    translate  <-12.6, 0.0, -0.0>
  }
  object { // Montant6->Montant
    Montant
    translate  <-10.8, 0.0, -0.0>
  }
  object { // Montant5->Montant
    Montant
    translate  <-9.0, 0.0, -0.0>
  }
  object { // Montant4->Montant
    Montant
    translate  <-7.2, 0.0, -0.0>
  }
  object { // Montant3->Montant
    Montant
    translate  <-5.4, 0.0, -0.0>
  }
  object { // Montant2->Montant
    Montant
    translate  <-3.6, 0.0, -0.0>
  }
  object { // Montant1->Montant
    Montant
    translate  <-1.8, 0.0, -0.0>
  }
  object { Montant }
}
#declare Support_barre = union {
  cylinder { // Cylndr033
    <0,0,1>, <0,0,0>, 1 
    scale <0.5, 0.5, 3.5>
  }
  cylinder { // Cylndr034
    <0,0,1>, <0,0,0>, 1 
    rotate -90.0*x
    translate  <0.0, -0.5, 4.0>
  }
  cylinder { // Cylndr035
    <0,0,1>, <0,0,0>, 1 
    material {
      Cuivre
    }
    scale <0.2, 0.2, 3.0>
    rotate -90.0*x
    translate  <0.0, -1.5, 4.0>
  }
  material {
    Gold_Texture
    // Transform to world space
    translate  <0.0, 71.0, -14.0>
    scale 1.0/0.6
    translate  <0.0, -0.111111, 18.444445>
    scale 1.0/1.666667
    translate  -131.0*z
  }
}
#declare Barre_de_gouverne = union {
  object { Barre }
  object { Support_barre }
  object { // Barre1->Barre
    Barre
    translate  2.0*y
  }
  scale 0.6
  translate  <0.0, -71.0, 14.0>
}
#declare Poignee = union {
  cylinder { // Cylndr015
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 4.0>
    rotate -90.0*x
    translate  <-6.0, -2.0, 0.0>
  }
  object { Cylndr016 }
  object { // Sphere078->Sphere079
    Sphere079
    translate  2.0*x
  }
  object { Sphere079 }
  object { // Sphere080->Sphere079
    Sphere079
    translate  <2.0, 4.0, 0.0>
  }
  object { // Sphere081->Sphere079
    Sphere079
    translate  4.0*y
  }
  object { // Cylndr017->Cylndr016
    Cylndr016
    translate  4.0*y
  }
  material {
    Cuivre
  }
  translate  1.0*z
}
#declare Gonds = union {
  object { Gonds_Haut }
  object { // Gonds_Bas->Gonds_Haut
    Gonds_Haut
    translate  -19.0*z
  }
  object { // Gonds_Milieu->Gonds_Haut
    Gonds_Haut
    translate  -9.5*z
  }
}
#declare Panneau_porte = union {
  box { // Panneau
    <-1, -1, -1>, <1, 1, 1>
    scale <5.25, 1.1, 5.5>
    translate  -6.0*z
    material {
      DMFWood
      // Transform to world space
      translate  <7.0, 68.0, -10.3>
      rotate 180.0*z
      scale <1.0/0.2, 1.0/0.35, 1.0/0.2>
      translate  <0.0, -0.111111, 18.444445>
      scale 1.0/1.666667
      translate  -131.0*z
    }
  }
  object { Champ_haut }
  object { // Champ_bas->Champ_haut
    Champ_haut
    translate  -11.0*z
  }
  object { // Champ_gauche->Champ_haut
    Champ_haut
    rotate -90.0*y
    translate  <-5.75, 0.0, -6.0>
  }
  object { // Champ_droite->Champ_haut
    Champ_haut
    rotate -90.0*y
    translate  <4.75, 0.0, -6.0>
  }
}
#declare Fenetre_porte = union {
  object { Carreau }
  object { // Carreau2->Carreau
    Carreau
    translate  <5.0, 0.0, 5.0>
  }
  object { // Carreau3->Carreau
    Carreau
    translate  5.0*z
  }
  object { // Carreau1->Carreau
    Carreau
    translate  5.0*x
  }
  material {
    Cuivre
  }
}
#declare Encadrement = difference {
  box { // Cube026
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 1.2, 14.75>
  }
  box { // Porte_1
    <-1, -1, -1>, <1, 1, 1>
    scale <7.0, 2.0, 13.5>
  }
  material {
    DMFWood
    // Transform to world space
    translate  <7.0, 68.0, -10.3>
    rotate 180.0*z
    scale <1.0/0.2, 1.0/0.35, 1.0/0.2>
    translate  <0.0, -0.111111, 18.444445>
    scale 1.0/1.666667
    translate  -131.0*z
  }
}
#declare Porte_trou = difference {
  box { // Porte_
    <-1, -1, -1>, <1, 1, 1>
    scale <7.0, 1.0, 13.5>
    material {
      DMFLightOak
      // Transform to world space
      translate  <7.0, 68.0, -10.3>
      rotate 180.0*z
      scale <1.0/0.2, 1.0/0.35, 1.0/0.2>
      translate  <0.0, -0.111111, 18.444445>
      scale 1.0/1.666667
      translate  -131.0*z
    }
  }
  box { // Cube033
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 2.0, 5.0>
    translate  7.0*z
  }
  material {
    DMFLightOak
    // Transform to world space
    translate  <7.0, 68.0, -10.3>
    rotate 180.0*z
    scale <1.0/0.2, 1.0/0.35, 1.0/0.2>
    translate  <0.0, -0.111111, 18.444445>
    scale 1.0/1.666667
    translate  -131.0*z
  }
}
#declare Porte = union {
  object { Poignee }
  object { Gonds }
  object { Panneau_porte }
  object { Fenetre_porte }
  object { Encadrement }
  object { Porte_trou }
  scale <0.2, 0.35, 0.2>
  rotate -180.0*z
  translate  <-7.0, -68.0, 10.3>
}
#declare TransSweep003 = prism {
  linear_sweep
  linear_spline
  -0.4,0.0
  16  // control points
  <0.05703, -1.0>,
  <0.688656, -1.0>,
  <0.8, -0.85>,
  <0.8, 0.0>,
  <0.3, 2.5>,
  <0.0, 2.8>,
  <0.0, 1.8>,
  <0.1, 1.8>,
  <0.1, 1.7>,
  <0.0, 1.7>,
  <0.0, 1.0>,
  <0.1, 1.0>,
  <0.1, 0.9>,
  <0.0, 0.9>,
  <0.0, -0.905>,
  <0.05703, -1.0>
  rotate -x*90
  rotate 90.0*x
  translate  0.2*y
}
#declare Gouvernail = union {
  object { // Cube041->Cube042
    Cube042
    translate  -0.8*z
  }
  object { Cube042 }
  object { TransSweep003 }
  object { Cube043 }
  object { // Cube044->Cube043
    Cube043
    scale <1.35, 1.0, 1.0>
    translate  <0.01, 0.0, -0.6>
  }
  object { // Cube045->Cube043
    Cube043
    scale <1.5, 1.0, 1.0>
    translate  <0.01, 0.0, -0.85>
  }
  object { // Cube046->Cube043
    Cube043
    scale <1.81, 1.0, 1.0>
    translate  <0.015, 0.0, -1.4>
  }
  object { // Cube047->Cube043
    Cube043
    scale <2.0, 1.0, 1.0>
    translate  <0.02, 0.0, -1.65>
  }
  object { Cube048 }
  object { // Cube049->Cube048
    Cube048
    translate  -0.8*z
  }
  material {
    Mat_txt
  }
  scale <2.5, 1.5, 3.0>
  rotate -90.0*z
  translate  <0.0, -86.2, 1.0>
}
#declare Mat3 = union {
  object { Torus023 }
  cone { // Cone033
    <0,0,0>, 0.75, <0,0,1>, 0.25
    scale <1.0, 1.0, 35.0>
  }
  object { // Torus024->Torus023
    Torus023
    scale <0.9, 0.9, 1.0>
    translate  3.0*z
  }
  object { // Torus025->Torus023
    Torus023
    scale <0.9, 0.9, 1.0>
    translate  3.4*z
  }
  object { // Torus026->Torus023
    Torus023
    scale <0.9, 0.9, 1.0>
    translate  3.8*z
  }
  object { Torus027 }
  object { // Torus028->Torus027
    Torus027
    scale <0.65, 0.65, 1.0>
    translate  10.0*z
  }
  box { // Cube052
    <-1, -1, -1>, <1, 1, 1>
    rotate 90.0*z
    translate  <-0.6, 0.0, 15.0>
  }
  material {
    Mat_txt
  }
  scale <1.5, 1.5, 1.2>
  rotate <0.0, -80.0, -90.0>
  translate  <0.0, -12.5, 7.3>
}
#declare Foc = union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-5.000000, -5.600000, 0.000000>, <-3.700000, -5.200000, 0.100000>, <-3.000000, -4.600000, 0.300000>, <-1.650000, -4.600000, 0.450000>, 
      <-3.600000, -5.000000, 0.200000>, <-3.600000, -4.300000, 0.900000>, <-3.000000, -4.000000, 0.600000>, <-1.850000, -4.100000, 0.400000>, 
      <-0.700000, -4.200000, 0.500000>, <0.700000, -4.100000, 0.400000>, <-3.300000, -4.000000, 0.500000>, <-2.200000, -3.550000, 0.600000>, 
      <-0.700000, -4.050000, 0.500000>, <1.050000, -3.950000, 0.500000>, <-1.600000, -4.000000, 0.600000>, <-1.158174, -3.312559, 0.755731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.700000, -4.050000, 0.500000>, <1.050000, -3.950000, 0.500000>, <-1.600000, -4.000000, 0.600000>, <-1.158174, -3.312559, 0.755731>, 
      <-0.700000, -3.900000, 0.500000>, <1.400000, -3.800000, 0.600000>, <0.100000, -4.000000, 0.700000>, <-0.100000, -3.100000, 0.900000>, 
      <2.300000, -4.400000, 0.200000>, <0.000000, -4.000000, 1.000000>, <1.100000, -4.000000, 0.300000>, <1.050000, -2.750000, 0.300000>, 
      <2.550000, -4.500000, 0.300000>, <0.950000, -4.000000, 0.900000>, <2.050000, -4.050000, 0.350000>, <1.992431, -3.175952, 0.365096>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.550000, -4.500000, 0.300000>, <0.950000, -4.000000, 0.900000>, <2.050000, -4.050000, 0.350000>, <1.992431, -3.175952, 0.365096>, 
      <2.800000, -4.600000, 0.400000>, <1.900000, -4.000000, 0.800000>, <3.000000, -4.100000, 0.400000>, <2.950000, -3.600000, 0.400000>, 
      <3.000000, -5.000000, 0.200000>, <3.000000, -3.900000, 0.400000>, <3.100000, -3.100000, 0.300000>, <3.050000, -2.050000, 0.150000>, 
      <4.000000, -5.000000, 0.000000>, <3.700000, -5.500000, 0.000000>, <4.100000, -4.700000, 0.000000>, <3.300000, -4.200000, 0.200000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.650000, -4.600000, 0.450000>, <-0.300000, -4.600000, 0.600000>, <0.500000, -4.400000, 0.500000>, <1.500000, -4.500000, 0.350000>, 
      <-1.850000, -4.100000, 0.400000>, <-0.700000, -4.200000, 0.200000>, <-0.100000, -4.000000, 0.600000>, <0.950000, -4.050000, 0.450000>, 
      <-2.200000, -3.550000, 0.600000>, <-1.100000, -3.100000, 0.700000>, <0.000000, -3.000000, 0.500000>, <0.450000, -3.000000, 0.450000>, 
      <-1.158174, -3.312559, 0.755731>, <-0.700000, -2.650000, 0.900000>, <0.150000, -2.150000, 0.650000>, <0.824786, -2.079812, 0.512830>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.158174, -3.312559, 0.755731>, <-0.700000, -2.650000, 0.900000>, <0.150000, -2.150000, 0.650000>, <0.824786, -2.079812, 0.512830>, 
      <-0.100000, -3.100000, 0.900000>, <-0.300000, -2.200000, 1.100000>, <0.300000, -1.300000, 0.800000>, <1.200000, -1.150000, 0.600000>, 
      <1.050000, -2.750000, 0.300000>, <1.000000, -1.500000, 0.300000>, <0.700000, -1.300000, 0.900000>, <1.350000, -0.650000, 0.650000>, 
      <1.992431, -3.175952, 0.365096>, <1.950000, -2.300000, 0.350000>, <1.200000, -1.100000, 0.650000>, <1.710937, -0.200117, 0.426940>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.992431, -3.175952, 0.365096>, <1.950000, -2.300000, 0.350000>, <1.200000, -1.100000, 0.650000>, <1.710937, -0.200117, 0.426940>, 
      <2.950000, -3.600000, 0.400000>, <2.900000, -3.100000, 0.400000>, <1.700000, -0.900000, 0.400000>, <2.050000, 0.250000, 0.200000>, 
      <3.050000, -2.050000, 0.150000>, <3.000000, -1.000000, 0.000000>, <3.900000, -2.900000, 0.100000>, <3.350000, -0.250000, 0.050000>, 
      <3.300000, -4.200000, 0.200000>, <2.500000, -3.700000, 0.400000>, <2.100000, -3.000000, 0.500000>, <2.700000, -1.000000, 0.250000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.500000, -4.500000, 0.350000>, <2.500000, -4.600000, 0.200000>, <3.000000, -5.000000, 0.000000>, <4.000000, -5.600000, 0.000000>, 
      <0.950000, -4.050000, 0.450000>, <2.000000, -4.100000, 0.300000>, <3.000000, -4.000000, 0.300000>, <4.100000, -4.400000, 0.000000>, 
      <0.450000, -3.000000, 0.450000>, <0.900000, -3.000000, 0.400000>, <3.000000, -3.000000, 0.000000>, <2.400000, -3.400000, 0.400000>, 
      <0.824786, -2.079812, 0.512830>, <1.500000, -2.000000, 0.400000>, <3.000000, -2.000000, 0.000000>, <2.800000, -2.600000, 0.350000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.824786, -2.079812, 0.512830>, <1.500000, -2.000000, 0.400000>, <3.000000, -2.000000, 0.000000>, <2.800000, -2.600000, 0.350000>, 
      <1.200000, -1.150000, 0.600000>, <2.100000, -1.000000, 0.400000>, <3.000000, -1.000000, 0.000000>, <3.200000, -1.800000, 0.300000>, 
      <1.350000, -0.650000, 0.650000>, <2.000000, 0.000000, 0.400000>, <3.000000, 0.000000, 0.000000>, <3.100000, -2.700000, 0.300000>, 
      <1.710937, -0.200117, 0.426940>, <2.200000, 0.700000, 0.200000>, <3.000000, 1.000000, 0.000000>, <3.350000, -0.850000, 0.150000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <1.710937, -0.200117, 0.426940>, <2.200000, 0.700000, 0.200000>, <3.000000, 1.000000, 0.000000>, <3.350000, -0.850000, 0.150000>, 
      <2.050000, 0.250000, 0.200000>, <2.400000, 1.400000, 0.000000>, <3.000000, 2.000000, 0.000000>, <3.600000, 1.000000, 0.000000>, 
      <3.350000, -0.250000, 0.050000>, <2.800000, 2.400000, 0.000000>, <3.400000, 3.300000, 0.000000>, <4.000000, 3.000000, 0.000000>, 
      <2.700000, -1.000000, 0.250000>, <3.300000, 1.000000, 0.000000>, <3.700000, 3.300000, 0.000000>, <4.000000, 4.000000, 0.000000>
    }
  }
  translate  <-0.3, 4.0, 0.0>
}
#declare Voile2 = union {
  object { Foc }
  material {
    Voile_blanc
  }
  scale <4.0, 4.8, 3.0>
  rotate <90.0, 10.0, -90.0>
  translate  <0.3, 6.0, 18.7>
}
#declare Caisse = merge {
  cylinder { // Cylndr065
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 6.0>
    rotate -90.0*y
    translate  <3.0, 0.0, 1.5>
  }
  box { // Cube060
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 2.0, 1.5>
  }
  object { Cube061 }
  object { // Cube062->Cube061
    Cube061
    translate  -3.0*z
  }
  material {
    Coffre_bois
  }
}
#declare Serrure = difference {
  box { // Cube063
    <-1, -1, -1>, <1, 1, 1>
    scale <0.5, 0.15, 0.5>
  }
  cylinder { // Cylndr068
    <0,0,1>, <0,0,0>, 1 
    scale <0.2, 0.2, 0.5>
    rotate -90.0*x
    translate  <0.0, -0.25, 0.2>
  }
  box { // Cube064
    <-1, -1, -1>, <1, 1, 1>
    scale <0.125, 0.25, 0.25>
  }
  material {
    Fer
  }
  scale <0.5, 1.0, 0.5>
  translate  <0.0, -1.9, 1.2>
}
#declare Coffre = union {
  object { Caisse }
  object { Coffre_gond }
  object { // Coffre_gond1->Coffre_gond
    Coffre_gond
    translate  4.0*x
  }
  object { Fer_Gond }
  object { // Fer_Gond1->Fer_Gond
    Fer_Gond
    translate  4.0*x
  }
  object { Serrure }
  scale 0.5
  rotate 180.0*z
  translate  <4.7, -66.3, 8.2>
}
#declare Chaine = union {
  object { Torus030 }
  object { // Torus031->Torus030
    Torus030
    rotate <0.0, -90.0, -45.0>
    translate  <1.6, 0.6, 0.0>
  }
  object { // Torus032->Torus030
    Torus030
    translate  <3.1, 1.8, 0.0>
  }
  object { // Torus033->Torus030
    Torus030
    rotate <90.0, -90.0, 0.0>
    translate  <4.9, 2.3, 0.0>
  }
  object { // Torus034->Torus030
    Torus030
    translate  <6.8, 2.3, 0.0>
  }
  object { // Torus035->Torus030
    Torus030
    rotate <0.0, -90.0, 45.0>
    translate  <8.5, 0.7, 0.0>
  }
  object { // Torus036->Torus030
    Torus030
    translate  10.0*x
  }
  object { // Torus037->Torus030
    Torus030
    rotate -90.0*y
    translate  <10.2, -2.3, 0.0>
  }
  object { // Torus038->Torus030
    Torus030
    translate  <10.4, -4.6, 0.0>
  }
  object { // Torus039->Torus030
    Torus030
    rotate <0.0, -90.0, -45.0>
    translate  <8.7, -6.2, 0.0>
  }
  object { // Torus040->Torus030
    Torus030
    translate  <7.0, -7.6, 0.0>
  }
  object { // Torus041->Torus030
    Torus030
    rotate <90.0, -90.0, 0.0>
    translate  <4.8, -7.7, 0.0>
  }
  object { // Torus042->Torus030
    Torus030
    translate  <2.6, -8.0, 0.0>
  }
  object { // Torus043->Torus030
    Torus030
    rotate <90.0, -90.0, 0.0>
    translate  <0.4, -8.1, 0.0>
  }
  object { // Torus044->Torus030
    Torus030
    translate  <-1.7, -8.3, 0.0>
  }
  object { // Torus045->Torus030
    Torus030
    rotate <90.0, -90.0, 0.0>
    translate  <-3.9, -8.3, 0.0>
  }
  object { // Torus046->Torus030
    Torus030
    translate  <-6.0, -8.4, 0.0>
  }
  object { // Torus047->Torus030
    Torus030
    rotate <90.0, -90.0, 0.0>
    translate  <-7.6, -8.7, 0.0>
  }
  object { // Torus048->Torus030
    Torus030
    rotate <90.0, -90.0, 0.0>
    translate  <-11.6, -8.4, 0.0>
  }
  object { // Torus049->Torus030
    Torus030
    translate  <-9.5, -8.6, 0.0>
  }
  object { // Torus050->Torus030
    Torus030
    translate  <-13.7, -8.4, 0.0>
  }
  object { // Torus051->Torus030
    Torus030
    rotate <90.0, -90.0, 0.0>
    translate  <-15.9, -8.5, 0.0>
  }
  object { // Torus052->Torus030
    Torus030
    translate  <-18.1, -8.6, 0.0>
  }
  object { // Torus053->Torus030
    Torus030
    rotate -90.0*y
    translate  <-0.2, -2.2, 0.0>
  }
  object { // Torus054->Torus030
    Torus030
    rotate <0.0, -90.0, -90.0>
    translate  <-20.0, -8.8, 0.0>
  }
  object { // Torus055->Torus030
    Torus030
    translate  -4.4*y
  }
  object { // Torus056->Torus030
    Torus030
    rotate <0.0, -90.0, -30.0>
    translate  <-1.0, -6.3, 0.0>
  }
  object { // Torus057->Torus030
    Torus030
    translate  <-22.1, -8.8, 0.0>
  }
  object { // Torus058->Torus030
    Torus030
    rotate <0.0, -90.0, -90.0>
    translate  <-24.2, -8.7, 0.0>
  }
  object { // Torus059->Torus030
    Torus030
    translate  <-26.5, -8.7, 0.0>
  }
  object { // Torus060->Torus030
    Torus030
    rotate <0.0, -90.0, -90.0>
    translate  <-28.6, -8.7, 0.0>
  }
  object { // Torus061->Torus030
    Torus030
    translate  <-30.7, -8.5, 0.0>
  }
  object { // Torus062->Torus030
    Torus030
    rotate <0.0, -90.0, -100.0>
    translate  <-32.8, -8.4, 0.0>
  }
  object { // Torus063->Torus030
    Torus030
    translate  <-35.0, -8.4, 0.0>
  }
  object { // Torus064->Torus030
    Torus030
    rotate <0.0, -90.0, -100.0>
    translate  <-37.0, -8.1, 0.0>
  }
  object { // Torus065->Torus030
    Torus030
    translate  <-39.4, -7.9, 0.0>
  }
  object { // Torus066->Torus030
    Torus030
    rotate <0.0, -90.0, -100.0>
    translate  <-41.4, -7.8, 0.0>
  }
  object { // Torus067->Torus030
    Torus030
    translate  <-43.7, -7.5, 0.0>
  }
  object { // Torus068->Torus030
    Torus030
    rotate <0.0, -90.0, -100.0>
    translate  <-45.9, -7.3, 0.0>
  }
  object { // Torus069->Torus030
    Torus030
    translate  <-48.2, -7.1, 0.0>
  }
  object { // Torus070->Torus030
    Torus030
    rotate <0.0, -90.0, -100.0>
    translate  <-50.4, -7.0, 0.0>
  }
  object { // Torus071->Torus030
    Torus030
    translate  <-52.6, -6.6, 0.0>
  }
  object { // Torus072->Torus030
    Torus030
    rotate <0.0, -90.0, -75.0>
    translate  <-54.6, -7.2, 0.0>
  }
  object { // Torus073->Torus030
    Torus030
    translate  <-56.8, -7.9, -0.5>
  }
  object { // Torus074->Torus030
    Torus030
    rotate <0.0, -90.0, -45.0>
    translate  <-58.6, -9.6, -1.2>
  }
  object { // Torus075->Torus030
    Torus030
    rotate -20.0*y
    translate  <-60.1, -11.4, -1.7>
  }
  object { // Torus076->Torus030
    Torus030
    rotate <0.0, -90.0, -40.0>
    translate  <-61.6, -13.1, -2.5>
  }
  object { // Torus077->Torus030
    Torus030
    rotate -20.0*y
    translate  <-63.2, -14.7, -3.2>
  }
  material {
    Chrome_Metal
  }
  scale 0.3
  translate  <-1.7, 0.8, 2.3>
}
#declare Bobine = union {
  cylinder { // Cylndr069
    <0,0,1>, <0,0,0>, 1 
    scale <3.0, 3.0, 0.3>
  }
  object { Cone035 }
  object { // Cone036->Cone035
    Cone035
    rotate 180.0*x
    translate  4.6*z
  }
  cylinder { // Cylndr070
    <0,0,1>, <0,0,0>, 1 
    scale <2.4, 2.4, 0.3>
    translate  4.3*z
  }
  object { Cylndr071 }
  object { Cone037 }
  object { // Cone038->Cone037
    Cone037
    rotate 30.0*z
  }
  object { // Cone039->Cone037
    Cone037
    rotate 60.0*z
  }
  object { // Cone040->Cone037
    Cone037
    rotate 90.0*z
  }
  object { // Cone041->Cone037
    Cone037
    rotate 120.0*z
  }
  object { // Cone042->Cone037
    Cone037
    rotate 150.0*z
  }
  object { // Cone043->Cone037
    Cone037
    rotate -180.0*z
  }
  object { // Cone044->Cone037
    Cone037
    rotate -150.0*z
  }
  object { // Cone045->Cone037
    Cone037
    rotate -120.0*z
  }
  object { // Cone046->Cone037
    Cone037
    rotate -90.0*z
  }
  object { // Cone047->Cone037
    Cone037
    rotate -60.0*z
  }
  object { // Cone048->Cone037
    Cone037
    rotate -30.0*z
  }
  object { // Cylndr072->Cylndr071
    Cylndr071
    rotate <0.0, 0.0, 30.0>
  }
  object { // Cylndr073->Cylndr071
    Cylndr071
    rotate <0.0, 0.0, 60.0>
  }
  object { // Cylndr074->Cylndr071
    Cylndr071
    rotate <0.0, 0.0, 90.0>
  }
  object { // Cylndr075->Cylndr071
    Cylndr071
    rotate <0.0, 0.0, 120.0>
  }
  object { // Cylndr076->Cylndr071
    Cylndr071
    rotate <0.0, 0.0, 150.0>
  }
  object { // Cylndr077->Cylndr071
    Cylndr071
    rotate <0.0, 0.0, -180.0>
  }
  object { // Cylndr078->Cylndr071
    Cylndr071
    rotate <0.0, 0.0, -150.0>
  }
  object { // Cylndr079->Cylndr071
    Cylndr071
    rotate <0.0, 0.0, -120.0>
  }
  object { // Cylndr080->Cylndr071
    Cylndr071
    rotate <0.0, 0.0, -90.0>
  }
  object { // Cylndr081->Cylndr071
    Cylndr071
    rotate <0.0, 0.0, -60.0>
  }
  object { // Cylndr085->Cylndr071
    Cylndr071
    rotate <0.0, 0.0, -30.0>
  }
  cone { // Cone049
    <0,0,0>, 2.0, <0,0,1>, 1.0
    scale <1.0, 1.0, 0.4>
    translate  4.6*z
  }
  material {
    Aluminum
  }
}
#declare Bob_chaine = union {
  object { Chaine }
  object { Bobine }
  scale 0.5
  rotate -80.0*z
  translate  <-4.1, -6.0, 7.7>
}
#declare Ancre = union {
  object { // TransSweep006->TransSweep007
    TransSweep007
    rotate 180.0*z
  }
  object { TransSweep007 }
  box { // Cube065
    <-1, -1, -1>, <1, 1, 1>
    scale <2.5, 0.4, 0.2>
    translate  8.5*z
  }
  torus { // Torus029
    1.5, 0.5  rotate -x*90
    scale <0.3, 0.3, 0.6>
    rotate -90.0*x
    translate  9.9*z
  }
  box { // Cube068
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 0.3, 4.0>
    translate  5.5*z
  }
  superellipsoid { // SuperQ019
    <1.0, 3.0>
    scale <0.5, 0.5, 2.0>
    rotate -90.0*y
    translate  1.0*z
  }
  object { Pointe }
  object { // Pointe1->Pointe
    Pointe
    translate  7.6*y
  }
  material {
    Ancre_Text
  }
  scale 0.6
  rotate <-10.0, -5.0, -40.0>
  translate  <-8.0, 3.1, 2.4>
}
#declare Voilier = union {
  object { Cylndr025 }
  object { Pancarte }
  object { Cylndr012 }
  object { // Cylndr013->Cylndr012
    Cylndr012
    rotate -0.0*x
    translate  14.0*x
  }
  object { Pont_arriere }
  object { Coque1 }
  object { Cloche_ }
  object { Fenetres }
  object { Cylndr026 }
  object { // Cylndr027->Cylndr026
    Cylndr026
    translate  21.3*x
  }
  object { Escalier }
  object { Mat }
  object { Pont_sup }
  object { Barriere_pont_sup }
  object { Barre_de_gouverne }
  object { Porte }
  object { // Cylndr062->Cylndr012
    Cylndr012
    translate  <17.7, 17.6, 0.0>
  }
  object { Gouvernail }
  object { // Mat1->Mat
    Mat
    scale 0.8
    rotate -0.0*x
    translate  <0.0, -40.0, 8.2>
  }
  object { // Mat2->Mat
    Mat
    scale 0.8
    rotate -0.0*x
    translate  <0.0, 20.0, 1.65>
  }
  object { Mat3 }
  object { GRCanon }
  object { // GRCanon1->GRCanon
    GRCanon
    translate  -12.0*y
  }
  object { // GRCanon2->GRCanon
    GRCanon
    translate  -24.0*y
  }
  object { GRCanon3 }
  object { // GRCanon4->GRCanon
    GRCanon
    translate  <0.3, 12.0, 0.0>
  }
  object { // GRCanon5->GRCanon3
    GRCanon3
    rotate -0.0*z
    translate  -12.0*y
  }
  object { // GRCanon6->GRCanon3
    GRCanon3
    rotate -0.0*z
    translate  -24.0*y
  }
  object { // GRCanon7->GRCanon3
    GRCanon3
    rotate -0.0*z
    translate  <-0.3, 12.0, 0.0>
  }
  object { // GRCanon8->GRCanon
    GRCanon
    translate  <1.4, -49.0, 6.7>
  }
  object { // GRCanon9->GRCanon3
    GRCanon3
    rotate -0.0*z
    translate  <-1.4, -49.25, 6.7>
  }
  object { Caisse_boulets }
  object { // Caisse_boulets1->Caisse_boulets
    Caisse_boulets
    rotate -0.0*y
    translate  <0.0, -12.0, 0.0>
  }
  object { // Caisse_boulets2->Caisse_boulets
    Caisse_boulets
    rotate -0.0*y
    translate  <0.0, -24.0, 0.0>
  }
  object { // Caisse_boulets3->Caisse_boulets
    Caisse_boulets
    rotate -0.0*y
    translate  <4.2, -59.3, 6.8>
  }
  object { Caisse_boulets5 }
  object { // Caisse_boulets6->Caisse_boulets5
    Caisse_boulets5
    translate  -12.0*y
  }
  object { // Caisse_boulets7->Caisse_boulets5
    Caisse_boulets5
    translate  -24.0*y
  }
  object { Voile2 }
  object { Coffre }
  object { Bob_chaine }
  object { Ancre }
  scale 1.666667
  translate  <0.0, 0.111111, -18.444445>
}
#declare Portebouteille = union {
  object { TransSweep010 }
  object { // TransSweep011->TransSweep010
    TransSweep010
    material {
      DMFWood6
    }
    rotate -0.0*x
    translate  <0.0, -250.0, 0.0>
  }
  box { // Cube076
    <-1, -1, -1>, <1, 1, 1>
    material {
      DMFWood6
    }
    scale <10.0, 150.0, 5.0>
    translate  <0.0, -30.0, -65.0>
  }
  translate  -50.0*y
}
#declare Bottle = union {
  object { Bouteille }
  cone { // Bouchon
    <0,0,0>, 0.9, <0,0,1>, 1.0
    material {
      Cork
    }
    scale <20.0, 20.0, 70.0>
    rotate -90.0*x
    translate  <0.0, 205.0, 40.0>
  }
  object { BezPtch002 }
  object { Voilier }
  object { Portebouteille }
  translate  131.0*z
}
union { // Etagere
  object { Cube001 }
  object { Cube071 }
  object { // Cube072->Cube001
    Cube001
    translate  440.0*z
  }
  object { // Cube073->Cube071
    Cube071
    rotate -0.0*y
    translate  <0.0, 0.0, -440.0>
  }
  object { // Cube074->Cube001
    Cube001
    translate  -440.0*z
  }
  object { // Cube075->Cube071
    Cube071
    rotate -0.0*y
    translate  <0.0, 0.0, 440.0>
  }
  object { Book }
  object { // Book1->Book
    Book
    rotate 10.0*x
    translate  <14.1, 164.9, -75.0>
  }
  object { Bottle }
  object { // Book2->Book
    Book
    rotate <10.0, 0.0, -0.0>
    translate  <48.0, 155.0, -512.0>
  }
  object { // Book3->Book
    Book
    rotate -0.0*z
    translate  <48.0, -100.0, -440.0>
  }
  object { // Book4->Book
    Book
    rotate <10.0, 0.0, -0.0>
    translate  <48.0, 60.0, -512.0>
  }
  material {
    DMFWood4
  }
}
