/* draw the sea's height field */

#include "colors.inc"

#include "sea_surface.inc"


global_settings { hf_gray_16 on }

// Cunning trick:
//  render to a unit square at 0,0, as that's what the height field will be mapped to.
//  this means we can line up textures in the final image with the hf if we want to.

camera {
  orthographic
  location <0,500,0>
  up <0,0,0.5>
  right <0.5,0,0>
  direction <0,-0.5,0>
}  

plane { y, 0
  texture {
    pigment {
    	sea_height(HEIGHT)
    	colour_map {
    		[0 rgb 0]
    		[1 rgb 1]
    	}
    	scale 1/hf_region
    }
    finish {
      ambient 1.0
      diffuse 0.0
    }
  }
}



