/*

Compartmentalized Sea
by Tek (who, incidentally, didn't use his pseudonim when entering the IRTC, 'cause everyone else was using real names and he felt a bit silly to be honest)

"The collector was feeling in a pacific mood today..."

*/


#declare rs = seed(71); //number chosen because the random heights of the water in the cabinets was asthetically pleasing.

#include "colors.inc"

#include "sea_surface.inc"
#include "splash.inc"


 /*******************
 * global settings *
*******************/

global_settings {
	assumed_gamma 2.2
  adc_bailout 0.02
  max_trace_level 20
}


 /*************
 * Constants *
*************/

//scene settings
#declare full = on;
#declare blur = off;

#declare box_colour_style = 1; //2 gives cool pop-music styling (I reckon)

#declare final_cam	= 0; 
#declare door_cam		= 1; 
#declare splash_cam	= 2; 
#declare cam_type		= final_cam; 


//output image values
#declare IMAGE_W_BY_H = 2.5/1;

#declare room_dim = <6,5,13>;
#declare room_centre = <0,0,-5>;

#declare wall_thick = 0.3;


//must be updated if box water pours from has moved (it will give an error if different)
#declare pour_point = <-1.95,1.25,0.125>;


 /**********
 * Camera *
**********/

camera {
	#switch (cam_type)
	
		#case (splash_cam)
			#declare cam_angle = 10;
		  #declare cam_loc = <3.5,0.85,-0.4>;
		  #declare lookat = <pour_point.x,0.1,pour_point.z-0.62>;
		#break
	
		#case (door_cam)
			#declare cam_angle = 5;
		  #declare cam_loc = <3.5,0.85,-8.4>;
		  #declare lookat = <1.80,1.2,-0>;
		#break
	
		#case (final_cam)
			#declare cam_angle = 50;
		  #declare cam_loc = <3.5,0.85,-0.4>;
		  #declare lookat = <0,0.85,-1.1>;
		#break
		
	#end
  #declare sky_vect = y;
  location cam_loc
  direction -x
  up sky_vect
  right -IMAGE_W_BY_H*z
  look_at lookat
  angle cam_angle


#if ( blur = on )
   aperture 0.0001   //kills the lens flare if much higher (it's too close to the camera!)
   focal_point pour_point
   blur_samples 40
   confidence 0.999
   variance 1/256
#end
}



 /**********
 * Lights *
**********/

#declare light_loc = <-10000, 700, -5800>;

#declare flare_type = "sunset1"
#declare flare_size = 0.5;
#declare flare_brightness =0.7;  

#include "nkflare.inc"

#declare sun_rad = 200;

light_source {
  light_loc
  rgb 1.0//<1.0, 0.8, 0.7>
}

#if (full = off)
light_source {
  <10000,10000,-10000>
  rgb 1.0
}
#end


 /*******
 * Sky *
*******/


//very nice sunset fx

#declare sunset_layer1 =
  //blue
  pigment {
    gradient y
    cubic_wave //use a cubic wave to avoid mach banding.
    colour_map {
      [0.00 rgbt <1.0, 1.0, 1.0, 0.0>]
      [1.00 rgbt <0.0, 0.0, 1.0, 0.8>]
    }
  }

#declare sunset_layer2 =
  //green
  pigment {
    boxed
    scale <1, 0.7, 1>
    pigment_map {
      [0.0 rgbt <0.0, 0.0, 0.0, 1.0>]
      [0.000000000001
        gradient y
        cubic_wave
        colour_map {
          [0.00 rgbt <1.0, 1.0, 1.0, 0.0>]
          [1.00 rgbt <0.0, 1.0, 0.0, 1.0>]
        }
      ]
    }
  }

#declare sunset_layer3 =
  //red
  pigment {
    boxed
    scale <1, 0.6, 1>
    pigment_map {
      [0.0 rgbt <0.0, 0.0, 0.0, 1.0>]
      [0.000000000001
        gradient y
        cubic_wave
        colour_map {
          [0.00 rgbt <1.0, 1.0, 1.0, 0.0>]
          [1.00 rgbt <1.0, 0.0, 0.0, 1.0>]
        }
      ]
    }
  }

sky_sphere {
  pigment { sunset_layer1 }
  pigment { sunset_layer2 }
  pigment { sunset_layer3 }
  translate -0.15*y
}




 /***********
 * The sea *
***********/

plane {
	y, 0
	texture {
		#if ( full = on )
			sea_surface
		#else
			pigment {
				rgb <102/255, 106/255, 88/255>
			}
			normal { sea_normal }
			finish {
				sea_finish
				reflection 0.0
				diffuse 0.9
				ambient 0.1
			}
			scale 3
		#end
		rotate y*90
		translate <0.45,0,0.45>
	}
}





 /***************
 * The cabinet *
***************/

#declare cab_wood =
	texture {
		pigment {
			wood
			scale 0.002
			warp {
				turbulence 0.1
			}
			scale 10
			colour_map {
				[0.4 rgb <0.25, 0.0, 0.0>]
				[0.4 rgb <0.3, 0.05, 0.0>]
			}
			scale <1/3,1,1>
			rotate y*90
		}
		finish {
			diffuse 0.7
			ambient 0.3
			specular 0.4 roughness 0.001
		}
	}
	

#declare box_in_tex =
	texture {
		pigment {
			gradient z
			colour_map {
				[0.00 Gray50]
				[0.05 Black]
				[0.45 Black]
				[0.55 White]
				[0.95 White]
				[1.00 Gray50]
			}
		}
		finish {
			ambient 1.0
			diffuse 0.0
		}
	}


#declare glass_col = rgbf <0.8,0.86,0.9,1.0>; //rgbt<1.0,1.0,1.0,0.95>;

//glass for the doors
#declare glass =
	material {
		texture {
			pigment {
				#if (full = on)
					glass_col
				#else
					rgbf <1.0,1.0,1.0,0.85>
				#end				
			}
			finish {
				#if (full = on)
					reflection 0.1
				#else
					reflection 0.0
				#end				
				specular 0.0
				roughness 0.005
				diffuse 1.0
				ambient 0.0
			}
		}
		interior {
			#if (full = on)
				ior 1.3
			#end
			fade_distance 0.2
			fade_power 2.0
		}
	}





 /************
 * Some Sea *
************/

#declare sea_scale = <5, 0.05, 5>;

//declare the height field as a seperate obj.
//if we do this in the macro, it re-parses it each time, which takes forever.
#declare sea_hf =
	height_field {
	  png "hf.png"
	  smooth
	}

#macro boxed_sea( box_centre, box_dimension, sea_level )
	intersection {
		object {
			sea_hf
			scale sea_scale
			translate <-rand(rs)*(sea_scale.x-box_dimension.x)-box_dimension.x/2, (sea_level-0.5)*box_dimension.y, -rand(rs)*(sea_scale.z-box_dimension.z)-box_dimension.z/2>
		}
		box {
			-box_dimension/2
			box_dimension/2
		}
		texture {
			pigment {
//				rgbft <0.10, 0.45, 1.0, 0.0, 0.8> //exagerate the colour
				rgbft <0.00, 0.15, 0.10, 0.0, 0.6>
			}
			finish {
				sea_finish
				#if ( full = off )
					reflection 0.0
					diffuse 0.7
					ambient 0.3
				#end
			}
		}
		interior {
			#if ( full = on )
				ior 1.3
				fade_distance 0.5
			#end
		}
		translate box_centre
	}
#end


 /*****************
 * cabinet doors *
*****************/
#declare door_thick = 0.02;
#declare handle_rad	=	0.03;

#macro cut(box_dimension)
	cylinder {
		<-box_dimension.x/2-4, box_dimension.y/2, -box_dimension.z/2 - door_thick >,
		<box_dimension.x/2+4, box_dimension.y/2, -box_dimension.z/2 - door_thick >,
		door_thick/2
	}
#end


#macro door( box_centre, box_dimension, door_open )
	//door for a cabinet of the specified size
	difference {
		intersection {
			box {
				-box_dimension/2 + 2*z
				box_dimension/2 - box_dimension.z*z - door_thick*z
			}
			plane {
				z, -box_dimension.z/2
			}
		}
		union {
			object { cut(box_dimension) rotate 0*z	}
			object { cut(box_dimension) rotate 90*z	}
			object { cut(box_dimension) rotate 180*z	}
			object { cut(box_dimension) rotate 270*z	}
		}
		material { glass }

		#if (door_open)
			translate <-box_dimension.x/2,0,box_dimension.z/2>
			rotate -y*95
			translate <box_dimension.x/2,0,-box_dimension.z/2>
		#end
		translate box_centre
		no_shadow
	}

	//door handle	
	sphere {
		<-box_dimension.x/2 + 0.08, 0, -box_dimension.z/2 - door_thick - handle_rad>, handle_rad		
		texture {
			cab_wood
			finish { specular 1.0 roughness 0.02 }
			scale 1//0.2
			rotate <rand(rs)*90,rand(rs)*90,rand(rs)*90> //it's a sphere, so make the grain run in a random direction.
			translate <rand(rs),rand(rs),rand(rs)> 
		}
		#if (door_open)
			translate <-box_dimension.x/2,0,box_dimension.z/2>
			rotate -y*95
			translate <box_dimension.x/2,0,-box_dimension.z/2>
		#end
		translate box_centre
	}
	
	//screw holding handle to door
	cylinder {
		<-box_dimension.x/2 + 0.08, 0, -box_dimension.z/2>, <-box_dimension.x/2 + 0.08, 0, -box_dimension.z/2 - door_thick - handle_rad>, handle_rad/3
		texture {
			cab_wood
			finish { specular 1.0 roughness 0.02 }
			scale 1//0.2
			rotate <rand(rs)*90,rand(rs)*90,rand(rs)*90>
			translate <rand(rs),rand(rs),rand(rs)> 
		}
		#if (door_open)
			translate <-box_dimension.x/2,0,box_dimension.z/2>
			rotate -y*95
			translate <box_dimension.x/2,0,-box_dimension.z/2>
		#end
		translate box_centre
	}
#end



 /*****************
 * pouring water *
*****************/
#macro pour(pos, dim, ground_height)

#if (vlength(pour_point-pos) != 0)
	//change pour point to whatever it prints here:
	#warning concat("pour_point incorrect\nshould be: <",str(pos.x,0,5),",",str(pos.y,0,5),",",str(pos.z,0,5),">\n")
	#error "balls"
#end

	difference {
		julia_fractal {
		  <0.2+0.7*1.65*0.22,0.5,0.2+0.7*1.65*0.22,0.5*1.65*0.22>
		  quaternion
		  max_iteration 7
		  precision 400//4
		}
		cylinder {
//			<-20,0.3,0>, <20,0.3,0>, 0.6
			<-20,0.45,10>, <20,0.45,-10>, 0.65
		}
	
		texture {
			pigment {
#if (full = on)
				rgbft <0.00, 0.15, 0.10, 0.0, 0.6>
#else
				sea_pigment
#end
			}
			finish {
				sea_finish
#if (full = on)
				reflection 0.4
#else
				reflection 0.0
#end
				specular 1.0
				roughness 0.01
			}
		}
		interior {
			ior 1.3
		}
	
	  rotate <20,10,-10>
	  scale <-dim.x, (pos.y-ground_height)*0.8, 0.5>
	  translate <pos.x+0.03,ground_height+(pos.y-ground_height)*0.14,pos.z-dim.z/2-0.08>
	}
#end



 /***************
 * The cabinet *
***************/
//a grid-shaped arrangement of glass fronted cupboards of sea

//cabinet dimensions
#declare cab_front		= 0; //z
#declare cab_back			= 0.25; //z
#declare cab_height		= 5; //y (centred on 0)
#declare cab_width		= 5; //x (centred on 0)

#declare shelf_thick	= 0.06;


//grid values
#declare grid_rows		= 10;
#declare grid_columns	= 10;


/* draw the shelves */

#declare i = 0;

#while (i <= grid_rows) //<= because we want 11 dividers, to hold 10 boxes
	#declare dist = i*cab_height/grid_rows;

	intersection {
		box {
			<-cab_width/2,-cab_height/2,cab_front-0.005> //bring the front out by 5mm
			< cab_width/2, cab_height/2,cab_back>
			texture {
				cab_wood
			}
		}
		//chop it off with two planes in different colours, so the inside of the boxes is black at the front
		//and white at the back (makes reflection/refraction in boxed water more visible).
		plane {
			y, -cab_height/2+dist+shelf_thick/2
			#if ( box_colour_style = 1 )
				texture { box_in_tex translate -1.05*z }//only show black on the floor
			#else
				texture { box_in_tex rotate x*90 }
			#end
		}
		plane {
			-y, -(-cab_height/2+dist-shelf_thick/2)
			#if ( box_colour_style = 1 )
				texture { box_in_tex translate -0.35*z }
			#else
				texture { box_in_tex rotate x*90 }
			#end
		}
	}

	#declare i = i+1;
#end 

/* draw the struts (vertical shelves) */

#declare i = 0;

#while (i <= grid_columns) //<= because we want 11 dividers, to hold 10 boxes
	#declare dist = i*cab_width/grid_columns;

	intersection {
	
		box {
			<-cab_width/2,-cab_height/2,cab_front>
			< cab_width/2, cab_height/2,cab_back>
			texture {
				cab_wood
				rotate z*90 //turn the grain of the wood. subtle touch. looks odd if it lines up with grain on shelves.
			}
		}

		plane {
			x, -cab_width/2+dist+shelf_thick/2
			#if ( box_colour_style = 1 )
				texture { box_in_tex translate -0.35*z }
			#else
				texture { box_in_tex rotate x*90 }
			#end
		}
		plane {
			-x, -(-cab_width/2+dist-shelf_thick/2)
			#if ( box_colour_style = 1 )
				texture { box_in_tex translate -0.35*z }
			#else
				texture { box_in_tex rotate x*90 }
			#end
		}
		
	}

	#declare i = i+1;
#end

/* draw the back */ 
box {
	<-cab_width/2,-cab_height/2,cab_back>
	<cab_width/2, cab_height/2,cab_back+shelf_thick>
/*	texture {
		cab_wood
		rotate z*15 //turn the grain of the wood. subtle touch.
	}*/
	#if ( box_colour_style = 1 )
		texture { box_in_tex rotate x*90 scale 0.5 } //white at top, black at bottom of each row
	#else
		texture { box_in_tex rotate x*90 } //rows alternate white and black.
	#end
}



/* sea boxes */
//for each space in the shelves create a lump of sea and a door, except the one where it's pouring.

#declare dim = <cab_width/grid_columns - shelf_thick, cab_height/grid_rows - shelf_thick, cab_back-cab_front>;

#declare j = 0;

#while (j < grid_rows)


	#declare i = 0;

	#while (i < grid_columns)

	
		#declare pos = <(i+0.5)*cab_width/grid_columns-cab_width/2, (j+0.5)*cab_height/grid_rows-cab_height/2 + 2*cab_height/grid_rows, (cab_front+cab_back)/2>;

		#if ( i = 1 & j = 5 )
			pour( pos-0.2*x, dim, -room_dim.y/2 + 4*cab_height/grid_rows )

			object {
				splash( <0,0,0>, 0.18 )
				#if (full = on)
					texture {
						pigment {
							//rgbt <0.00, 0.15, 0.10, 0.6>
							//rgbt <0.50, 0.575, 0.55, 0.6>
							//rgbt <0.10, 0.25, 0.20, 0.95>
							White transmit 0.9//.65
						}
						finish {
							sea_finish
							diffuse 0.8 //0.8
							ambient 0.6 //0.2
							reflection 0//.4
							specular 1.0
							roughness 0.5//0.01
						}
					}
					interior {
						ior 1.05//less to look more bubbly 1.3
					}
				#else
					//traditional red debug colouring!
					texture {
						pigment { Red }//transmit 0.8 }
						finish { //phong 1.0 phong_size 10 }
							diffuse 0.7
							ambient 0.3
							specular 1.0
							roughness 0.02
						}
					}
				#end
				rotate -35*y
				translate <pos.x, 0, pos.z-0.62>
			}
		
			//create glass door
			door( pos, dim, true )
		#else
			//create sea inna box
			boxed_sea( pos, dim, rand(rs)*.8+.1 )

			//create glass door
			door( pos, dim, false )
		#end

		#declare i = i + 1;      
	#end//while
	
	#declare j = j + 1;
#end//while


	