/**
 * Variables
 */
#declare Main = 1;

#declare sun_dis = 6000000;
#declare sun_hgt = 100000;
#declare sun_ofs = -3000000;
#declare sun_rad = 100000;

#declare cloud_media = 10;
#declare athms_media = 10;

#declare single_cloud = 0;
#declare storm_cloud = 1;
#declare trireme_geometry = 0;

#declare cam = 1;

/**
 * Settings
 */

global_settings { 
    max_trace_level 19
    radiosity {
        distance_maximum 10000
        error_bound .4
    }
}

/**
 * Light source
 */
        
light_source { 
    <sun_ofs,sun_hgt,sun_dis>
    color rgb <2,1.2,.75>*1.3
    //area_light <0,2,0>*sun_rad <2*dis,0,0>*dis 3 3
    //looks_like { sphere { 0 1*sun_rad pigment { color rgb <1,1,.5> } finish {ambient 1 } } }
    media_attenuation on
    spotlight
    point_at 0
} 

light_source { 
    <15,5,-15>
    color rgb <1.75,1.2,.75>*.25
    fade_power 1
    fade_distance 30
    media_interaction off
    shadowless
} 

/**
 * Athmospheric media
 */

#if (athms_media)
    media {
        scattering {5 color rgb .00000175 eccentricity -.2 extinction 0.01 }
        intervals athms_media
    }
#end

/**
 * Camera
 */

#if (cam)
    camera {location <0,3,-10> look_at <0,2.75,10> }
#else
    camera {location <0,100000,0> orthographic look_at <0,0,0> }
#end

/**
 * Water
 */


#declare water = 
texture {
    pigment {
        color rgb <.8,.9,1>
    }
    normal {
        bumps 1
        scale <.25,.125,.125>
        rotate y*120
    }
    finish  {
        diffuse 0
        ambient 0
        reflection .666
    }
}

height_field {
    png "watermap.png"
    smooth
    translate <-.5,0,-.5>
    rotate y*120
    scale <250,2.4,250>
    texture { water }
    translate <-2.25,0,-1.25>
}

/**
 * Trireme 
 * Trireme mesh hull is
 *      56  units long
 *      8   units wide
 *      6   units high
 */

#if (trireme_geometry)
#declare trireme =
    union {
        #include "trireme.pov"
        scale .5
    }
  
object { trireme rotate z*4 rotate y*117.5 translate <6,.15,6.6> }
#end
/**
 * Clouds
 */

// material

#if (cloud_media)

    #declare cloud_material_1 = material {
        texture { 
            pigment{ color rgbf <1,1,1,1>}
            finish {ambient 0}
        }
        interior {
            media {
                scattering {4 color rgb <.0001,.0001,.0001> extinction 1}
                intervals cloud_media
                density {
                    spherical
                    color_map {
                        [0   color rgb 0]
                        [.15 color rgb 0]
                        [.25 color rgb 1]
                        [1   color rgb 1]
                    }
                    turbulence .75
                    octaves 10
                    lambda 3
                    omega .75
                }
            }
            
        }
    }

    #declare cloud_material_2 = material {
        texture { 
            pigment{ color rgbf <1,1,1,1> }
            finish {ambient 0}
        }
        interior {
            media {
                scattering {4 color rgb <.000005,.000005,.000005> extinction 1}
                intervals cloud_media
                density {
                    spherical
                    color_map {
                        [0    color rgb 0]
                        [.15  color rgb 0]
                        [.25  color rgb 1]
                        [1    color rgb 1]
                    }
                    turbulence .75
                    octaves 10
                    lambda 3
                    omega .75
                }
            }
            
        }
    }

    #declare cloud_material_3 = material {
        texture { 
            pigment{ color rgbf <1,1,1,1> }
            finish {ambient 0}
        }
        interior {
            media {
                scattering {4 color rgb <.0001,.0001,.0001> extinction 1}
                intervals cloud_media
                density {
                    spherical
                    color_map {
                        [0    color rgb 0]
                        [.15  color rgb 0]
                        [.25  color rgb 1]
                        [1    color rgb 1]
                    }
                    turbulence .75
                    octaves 10
                    lambda 3
                    omega .75
                }
            }
            
        }
    }

#else

    #declare cloud_material_1 =
    material {
        texture {
            pigment {color rgb <.35,.27,.16>}
            finish {ambient .6}
        }
    }

    #declare cloud_material_2 = cloud_material_1
    #declare cloud_material_3 = cloud_material_1
    
#end

// cloud-objects

#declare cloud_1 =
sphere {
    <0,0,0> 1.1
    hollow
    material {
        cloud_material_2
    }
}

#declare cloud_2 =
sphere {
    <0,0,0> 1.1
    hollow
    material {
        cloud_material_2
    }
}

#declare cloud_3 =
sphere {
    <0,0,0> 1.1
    hollow
    material {
        cloud_material_3
    }
}

// placement of single clouds
#if (single_cloud)

// Thincloud
//object { cloud_3 scale <7,9,7>  translate <-5000,1500,5000> }

// Thincloud
object { cloud_3 scale <10,10,10>  translate <-4000,1700,20000> }
#end


// Storm
#if (storm_cloud)

/*
// Stormcloud

object { cloud_2 scale <14000,4200,22400>  translate <13500,1200,50000> }
object { cloud_2 scale <14000,4200,11200>  translate <14500,1250,40000> }
object { cloud_2 scale <14000,4200,11200>  translate <13500,1300,35000> }
*/
// Darkcloud
object { cloud_2 scale <14000,3050,22400>  translate <0,3000,50000> }
object { cloud_2 scale <14000,2750,11200>  translate <12500,3250,40000> }
object { cloud_2 scale <14000,2520,11200>  translate <11500,3300,35000> }
object { cloud_2 scale <14000,2520,11200>  translate <9500,3850,30000> }
object { cloud_2 scale <14000,2520,11200>  translate <11500,3700,25000> }
object { cloud_2 scale <14000,3080,11200>  translate <1900,3700,20000> }
object { cloud_2 scale <14000,2520,11200>  translate <11500,3600,13000> }

// Thincloud
//object { cloud_3 scale <14000,1120,33600>  translate <-60030,2500,140000> }
//object { cloud_3 scale <14000,1120,33600>  translate <-35000,3000,85000> }
object { cloud_3 scale <14000,1120,33600>  translate <-8000,4900,65000> }
//object { cloud_3 scale <14000,1120,33600>  translate <6600,4900,50000> }
object { cloud_3 scale <14000,1120,33600>  translate <-8000,4000,40000> }
//object { cloud_3 scale <14000,1120,33600>  translate <7000,4100,35000> }
//object { cloud_3 scale <14000,1120,33600>  translate <4500,4200,30000> }
//object { cloud_3 scale <14000,1120,33600>  translate <8000,4300,25000> }
//object { cloud_3 scale <14000,1120,33600>  translate <7000,4400,20000> }

object { cloud_3 scale <14000,1120,33600>  translate <-5100,4500,15000> }

#end                       

