// Persistence of Vision Ray Tracer include File
// File: BWing.inc
// Vers: 3.1
// Date: 16/10/98
// Auth: Mick Hazelgrove 

/*
#version 3.1;

#include "colors.inc"

global_settings
{
  assumed_gamma 1.0
}

// ----------------------------------------
camera
{
  location  <0.0, 0.5, -20.0>
  direction 1.5*z
  right     4/3*x
  look_at   <0.0, 0.0,  0.0>
}

sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}

light_source{<-30, 30, -30>,color rgb<1,1,1>}

*/
// ----------------------------------------


#ifndef (Wangle) #declare Wangle = 80; #end 
#ifndef (WHeight) #declare WHeight = 2.75; #end
#ifndef (WWidth) #declare WWidth = 3; #end

#declare FTex = texture{
        pigment {rgb 2}
                finish{ambient 0.2 diffuse 0.2 specular 1 roughness 0.125 reflection 0.1 }
} 

//-------------------------------------------------------------------------------------

#declare AOuter_Wing = blob{
  threshold 0.3
 sphere { 0, 1, 1 scale <2,13,0.2> translate y*13 rotate z*-2 }
 sphere { 0, 1, 1 scale <1.5,12,0.2> translate y*12 rotate z*-6.5 }
 sphere { 0, 1, 1 scale <1.5,11,0.2> translate y*11 rotate z*-10 }
 sphere { 0, 1, 1 scale <1.5,10,0.2> translate y*10 rotate z*-14.5 }
 sphere { 0, 1, 1 scale <1.5,9,0.2> translate y*9 rotate z*-19 }
 sphere { 0, 1, 1 scale <1.5,8,0.2> translate y*8 rotate z*-23.5 }
 sphere { 0, 1, 1 scale <1.5,7,0.2> translate y*7 rotate z*-28 }
 sphere { 0, 1, 1 scale <1.5,6,0.2> translate y*6 rotate z*-32.5 }
 sphere { 0, 1, 1 scale <1.5,5,0.2> translate y*5 rotate z*-37 }
 sphere { 0, 1, 1 scale <1.5,4,0.2> translate y*4 rotate z*-42 }
 sphere { 0, 1, 1 scale <1.5,4,0.2> translate y*4 rotate z*-48 }
 sphere { 0, 1, 1 scale <1.5,4,0.2> translate y*4 rotate z*-55 }
 }
 #declare L = seed(6736); 
 
 #declare AInner_Wing = blob{
  threshold 0.3
     #declare C =0;
         #while (C<15)
                sphere { 0, 1, 1 scale <1.25,3+(rand(L)),0.2> translate y*5 rotate z*-75 
                translate y*-C
                }
             #declare C = C+1;
         #end
 }
 
#declare AWing = union{
     object{AOuter_Wing texture{FTex}scale 0.25}
        object{AOuter_Wing pigment{Gray75*2}scale <0.15,0.15,0.25> rotate z*5}

     object{AInner_Wing texture{FTex}scale 0.25  rotate z*30 rotate x*-20
     rotate y*-10
     translate y*-.675 
     translate z*.225
     }
        object{AInner_Wing pigment{Gray55}scale <0.15,0.25,0.2> rotate z*30 rotate x*-20 translate x*-.1
        rotate y*-10
        translate y*-.675 
        translate z*.225
        }
 }
//------------------------------------------------------------------------------------------------------------
#declare BOuter_Wing = blob{
  threshold 0.3
 sphere { 0, 1, 1 scale <2,13,0.2> translate y*13 rotate z*-2 }
 sphere { 0, 1, 1 scale <1.5,12,0.2> translate y*12 rotate z*-6.5 }
 sphere { 0, 1, 1 scale <1.5,11,0.2> translate y*11 rotate z*-10 }
 sphere { 0, 1, 1 scale <1.5,10,0.2> translate y*10 rotate z*-14.5 }
 sphere { 0, 1, 1 scale <1.5,9,0.2> translate y*9 rotate z*-19 }
 sphere { 0, 1, 1 scale <1.5,8,0.2> translate y*8 rotate z*-23.5 }
 sphere { 0, 1, 1 scale <1.5,7,0.2> translate y*7 rotate z*-28 }
 sphere { 0, 1, 1 scale <1.5,6,0.2> translate y*6 rotate z*-32.5 }
 sphere { 0, 1, 1 scale <1.5,5,0.2> translate y*5 rotate z*-37 }
 sphere { 0, 1, 1 scale <1.5,4,0.2> translate y*4 rotate z*-42 }
 sphere { 0, 1, 1 scale <1.5,4,0.2> translate y*4 rotate z*-48 }
 sphere { 0, 1, 1 scale <1.5,4,0.2> translate y*4 rotate z*-55 }
 }
 #declare L = seed(6736); 
 
 #declare BInner_Wing = blob{
  threshold 0.3
     #declare C =0;
         #while (C<15)
                sphere { 0, 1, 1 scale <1.25,3+(rand(L)),0.2> translate y*5 rotate z*-75 
                translate y*-C
                }
             #declare C = C+1;
         #end
 }
 
#declare BWing = union{
     object{BOuter_Wing texture{FTex}scale 0.25}
        object{BOuter_Wing pigment{Gray75*2}scale <0.15,0.15,0.25> rotate z*5}

     object{BInner_Wing texture{FTex}scale 0.25  rotate z*30 rotate x*20
     rotate y*10
     translate y*-.3 //up/down
     translate z*-.15
     }
        object{BInner_Wing pigment{Gray55}scale <0.15,0.25,0.2> rotate z*30 rotate x*20 translate x*-.1
        rotate y*10
        translate y*-.3 
        translate z*-.15
        }
 }
 //-------------------------------------------------------------------------------------------------------
  /*
  #declare Wangle = 50;
  #declare WHeight = 3.75;
  #declare WWidth =  1.5;
*/
 #declare Wings =
        union{
        object{AWing scale <1.75,1,1>  
                rotate x*Wangle
                translate z*WWidth
        }

        object{BWing scale <1.75,1,1>
               rotate x*-Wangle 
               translate z*-WWidth
        }
     scale 0.3
  texture{FTex}
}


// ---------------------------------------------------
//     Tail Feathers
//----------------------------------------------------


 
#declare BTail = union{
#declare Count = 0;
#declare Angle = -56;
#declare Hangle = 16;

#while(Count<16)
        blob{
          threshold 0.3
         sphere { 0, 1, 1 scale <2,13,0.2> translate y*11 rotate z*Angle  rotate y*Hangle}
         texture{FTex}
        }
        
     #declare Count = Count +1;
     #declare Angle = Angle +7.5;
     #declare Hangle = Hangle - 2;
#end     
}


#declare Bird = union{
object{Wings
scale <2,4,4>
rotate z*-20 
translate<1.75,0,0>
translate y*WHeight
}
object{BTail  
rotate x*-110
rotate y*-90
scale 0.15
translate<4,0,0> 
}
object{sphere{0,1 //body
scale <1.75,0.8,1>
rotate z*5
translate<3,-0.50,0>
texture{FTex scale 0.5}
normal{granite 0.1}
}}
object{cone{1*y,0.5,-1*y, 1.0 }//neck
scale 0.7
rotate z*130
translate<1.5,-1.05,0> 
texture{FTex scale 0.5 }
normal{granite 0.1}
}
object{sphere{0,1 //head
scale <0.7,0.5,0.5>
rotate z*-120
translate<1,-1.5,0>
texture{FTex scale 0.5 } 
normal{granite 0.1}
}}
object{cone{0.5*y,0.05,-1*y, 0.3 }//beak
scale 0.85
rotate z*155
translate<0.5,-2.1,0> 
texture{pigment{Yellow} finish{ ambient 2 specular 1}}
}
//rotate y*-45
}



/*
object{Bird
rotate y*-90
//rotate x*-90
 scale .5
}
*/