

 // Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.1
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: Mick Hazelgrove
//

/*

#include "colors.inc"

global_settings
{
  assumed_gamma 1.0
}

// ----------------------------------------
 

background{colour rgb<0,.125,.25>}

light_source{<-30, 30, -30>,color rgb<1,1,1>}
 light_source{<30, 30, -30>,color rgb<1,1,1>/2}
// ----------------------------------------
*/
#version unofficial MegaPov 0.5;

//=================Boat.inc====================

#declare Chain_Tex = texture{
	pigment {
		bozo
		color_map {
			[ 0.25 rgb.9 ]
			[ 0.50 rgb<.8,.4,0> ]
			[ 1 color rgb.7 ]
		} // color_map 
            turbulence .6 scale .001
	 } // pigment
        finish {phong 1 phong_size .01 reflection .5 metallic}
            normal{dents 6 scale .01}
            }

#declare B_Tex = texture {
  pigment {
    gradient x
    turbulence 0.3 octaves 2 omega 0.1 lambda 0.5
    color_map {
      [0.50 color rgb<0.8, 0.35, 0.000>]
      [1.00 color rgb<0.91, 0.76, 0.25>]
    }
    frequency 5
  }
  finish { specular .5 roughness.1 reflection .15}
  normal{wrinkles 1 scale 0.1}
  rotate z*90
  scale 0.1
  }
    
//-----------------------------------------------------------
#declare Scallop = difference{
        torus{2.2,0.2 rotate x*90}
        sphere{0,20  translate<-1,18.75,0>}   
}

#declare FScallop = union{
object{Scallop}
sphere{0,.2 translate<1.8925,-1.1225,0>}
}

#declare BPost = difference{
cylinder{z*-0.05,z*0.05,2.1}
object{FScallop translate<0,0,-0.195>} 
object{FScallop translate<0,0,0.195>} 
cylinder{z*-0.2,z*0.2,1.95 scale<1.03,1,1>}
scale<2.5,1.25,1>
}


#declare LPost = intersection{
object{BPost}
object{sphere{0,20 inverse translate<1,19.1,0>}}
}
 
#declare Bsphere = difference{
        sphere{0,2}
        sphere{0,1.95}
        scale <2.5,1.25,1>
        }
#declare Bsphere2 = difference{
        sphere{0,2}
        sphere{0,1.95 scale <1.03,1.0,1.0>}
        scale <2.5,1.25,1> 
        }
                  
#declare BtShape = union{
intersection{  
 object{Bsphere}
        sphere{0,20 inverse translate<1,18,0>}
        }

intersection{   
 object{Bsphere}
        sphere{0,20 inverse translate<1,18.2,0>}
        scale 1.01
        }
intersection{
 object{Bsphere }

        sphere{0,20  inverse translate<1,18.4,0>}
        sphere{0,20 translate<1,18.2,0>}
        scale 1.02
        }
intersection{
 object{Bsphere }

        sphere{0,20  inverse translate<1,18.6,0>}
        sphere{0,20 translate<1,18.4,0>}
        scale 1.03
        }
intersection{        
 object{Bsphere }

        sphere{0,20  inverse translate<1,18.8,0>}
        sphere{0,20 translate<1,18.6,0>}
        scale 1.04
        }
intersection{
 object{Bsphere }

        sphere{0,20  inverse translate<1,19,0>}
        sphere{0,20 translate<1,18.8,0>}
        scale 1.05
        pigment{rgb<0,.5,0>}
        normal{bumps .05 scale .1 }
        finish{specular 1 reflection .1}
        }          
}

#declare Ribs = union{
        #declare T = -5;
        #declare Inc = 0.025;       
                #while (T<5)
                #if(T>2)#declare Inc = 0.05;#end 
                #if(T<-2)#declare Inc = 0.05;#end
                intersection{
                        object{Bsphere2}
                            sphere{0,20 inverse translate<1,18.712,0>}
                                plane{x,T}
                                plane{x,T-Inc inverse}
                                }
                        #declare T = T+0.5;
                #end
} 

#declare Tiller =
sphere_sweep{
        b_spline_sphere_sweep, 
            7,
            <5,0,0>,.175
            <0,0,0>,.125
            <-1,0,0>,.115
            <-2,0.5,0>,.1
            <-3,0.5,0>,.1
            <-4,0.5,0>,.09
            <-4.1,0.5,0>,.5
            }

 #declare Fgunwale =
sphere_sweep{
        b_spline_sphere_sweep, 
            7,
            <-7.5,  0.6,      1.6>,.07
            <-5,   -0.175,   -0.475>,.07
            <-3,   -1.3,     -1.05>,.07
            <0,    -1.925,   -1.25>,.07
            <3,    -1.875,   -1.0>,.07 //==
            <5,    -1.25,     -0.5>,.07
            <6.75,    -1.1,   1.8>,.07
            }
#declare Bgunwale =
sphere_sweep{
        b_spline_sphere_sweep, 
            7,
            <-7.5,   0.6,     -1.6>,.07
            <-5,     -0.175,      0.475>,   .07
            <-3,     -1.3,      1.05>,  .07
            <0,      -1.925,      1.25>,  .07
            <3,      -1.875,      1>,.07
            <5,      -1.25,      0.5>,.07
            <6.75,    -1.1,   -1.8>,.07
            }

//----------------------------------------------------------------


#declare Plank =
    box{<-1,0,-.1><1,0.025,.1>
    //texture{B_Tex}
    pigment{White}finish { specular .25  reflection .125}normal{wrinkles .3 scale 0.5}
    }
    
#declare Deck = union{
   
object{Plank scale <1.2,1,1> translate <.5,-0.05,0>}//centre

object{Plank scale <1.1,1,1> translate <.6,-0.05125,-.22>}
object{Plank scale <1.1,1,1> translate <.6,-0.05125,.22>}
 
object{Plank scale <.9,1,1> translate <.81,-0.0525,-.44>}
object{Plank scale <.9,1,1> translate <.81,-0.0525,.44>}

object{Plank scale <.7,1,1> translate <1,-0.055,-.66>}
object{Plank scale <.7,1,1> translate <1,-0.055,.66>}

object{Plank scale <.5,1,1> translate <1.2,-0.0575,-.88>}
object{Plank scale <.5,1,1> translate <1.2,-0.0575,.88>}
     
}

#declare Bulkhead = 
prism {
  linear_sweep 
  linear_spline 
  0, 
  0.025,
  8,
  < 0.85, -0.85>,//left top 
  < 0.85,  0.85>,//right top 
  < 0.25, 0.75>
  < 0.25, 0.5>
  <0,  0>,// bottom point
  < 0.25, -0.5>
  < 0.5, -0.75>
  < 0.85, -0.85> //close
rotate z*90
translate <-2.95,-1.9,0>
}

#declare Mast = difference{
    //cylinder{y*-2,y*1,.0625
    cone{y*-2,0.08,y*1,.0625 
          pigment {
            spiral2 20
            turbulence 0.15 
                color_map {
                    [0.50 color rgb<0.8, 0.35, 0.000>]
                    [1.00 color rgb<0.91, 0.76, 0.25>]
                    }
                    rotate x*90 translate y*-2
            }
        normal{spiral2 20 .35 turbulence .15 ramp_wave rotate x*90 translate y*-2}
            finish{specular 1 roughness .001} 
            translate<1.5,0,0>
    }
      #declare C= 0; #declare RD = seed(5764); #declare Ang = 0;
        union{
        #while(C<6)
            cone{y*0,.1 +(rand(RD)/3),y*1,0
            rotate x*180
               pigment{Tan*4}
               normal{radial 50 turbulence .3 ramp_wave scale .001 frequency 25} 
               translate z*.3
               rotate y*Ang
               scale <.2,.5,.2>
               }
        #declare C=C+1;
        #declare Ang = Ang +60*rand(RD);
        #end
        translate<1.5,1.1,0>
        }
}
 
#declare Pole = union{
object{Mast}
object{cylinder{y*.45,y*.55,.08 texture{Chain_Tex}translate x*1.5}}
}

#declare Bowsprit = 
    object{Pole scale<.65,1.2,.65>
      rotate z*-80  
        translate<5.5,0.325,-.1>
}

#declare Link = union{
    #declare Chain_End = difference{torus{.75,.25 rotate x*-90}box{<-1.5,-1.5,-.5> <1.5,0,.5> }texture{Chain_Tex}}
    #declare Chain_Side = cylinder{x*-1,x*1,.25 texture{Chain_Tex}}
        object{Chain_End rotate z*-90 translate x*1} 
        object{Chain_End rotate z*90 translate x*-1}
        object{Chain_Side translate y*.75} 
        object{Chain_Side translate y*-.75}
}

$ Chain = union{

$ Start_Point = -36;
$ End_Point = 30 ;
$ Ang = 0;
$ C=Start_Point;

#while(C<End_Point)

  #if(mod(C,2)=0)
    object{Link translate x*C }
  #else
    object{Link translate x*C rotate x*-90 }
  #end
    $ C=C+3; 
     
#end 
}
        
#declare boat_hull = union{        
object{BtShape clipped_by{plane{z,-0.4 }}translate<0,0,.4>pigment{White}finish { specular .5  reflection .125}normal{wrinkles .3 scale 0.5}}
object{BtShape clipped_by{plane{z,0.4 inverse }}translate<0,0,-.4>pigment{White}finish {specular .5  reflection .125}normal{wrinkles .3 scale 0.5}}
object{Ribs clipped_by{plane{z,-0.4 }}translate<0,0,.4>scale <1,0.95,1.065>pigment{White}finish {ambient .2 specular .5  reflection .125}normal{wrinkles .3 scale 0.5}}
object{Ribs clipped_by{plane{z,0.4 inverse}}translate<0,0,-.4>scale <1,0.95,1.065>pigment{White}finish {ambient .2 specular .5  reflection .125}normal{wrinkles .3 scale 0.5}}
}
 
#declare boat = union{
//object{Bowsprit} 
//object{boat_hull }      
//object{LPost texture{B_Tex rotate z*45}}
//upper Gunwale
//object{Fgunwale texture{B_Tex rotate x*-25}scale <1,0.5,1.5> translate<0,0,0.25>}
//object{Bgunwale texture{B_Tex rotate x*-25}scale <1,0.5,1.5>translate<0,0,-0.25>}
//lower Gunwale
//object{Fgunwale texture{B_Tex rotate x*-25}scale <1,0.5,1.5>scale 0.9725 translate<0,-0.265,0.25>}
//object{Bgunwale texture{B_Tex rotate x*-25}scale <1,0.5,1.5>scale 0.9725 translate<0,-0.265,-0.25>}
//object{Tiller texture{B_Tex rotate z*90}scale <0.75,0.45,0.5> rotate z*15 rotate y*195 translate <0,0,0> translate<-4.925,0.0,0>}
//object{Deck rotate z *-12 translate <-4.5,-.6,0> }
//object{Bulkhead pigment{White}}
object{Mast}
//object{Plank rotate y*90 scale <2.25,1.25,1.3> translate <1.5,-1.35,0.1> rotate z *3.5 texture{B_Tex}}
//object{Plank rotate y*90 scale <2,1.25,1.3> translate <-1.4,-1.3,0.1> texture{B_Tex}}
//object{Chain scale .025 rotate z*25 translate<5.55,-.9,-.075>}    
/*prism {
  linear_sweep 
  linear_spline 
  0, 
  0.025,
  4,
  <-2,0>,<0,.95>,<0,-.95>,<-2,0> 
    pigment{Black} 
        rotate z *-12 
            translate<-2.9,-1.025,0>
  }
  */
}

/*
object{boat scale 1 
translate <3,0,0>}

camera{location  <0.0, 20, 0.0>
  direction 1.5*z
  right     4/3*x
  look_at   <0.0, 0.0,  0.0>}


camera {location <0,1.5,-5> look_at z*10000}

object{boat scale .5  //was 1.5
rotate y*75
rotate z*8 
translate <1,1.25,1.75>}
*/