//-------------------Starfish.inc----------------------

#version unofficial MegaPov 0.5;

#declare StarfishTex = texture{
pigment{radial frequency 25
    color_map {
    [ 0.25 rgb <3, 1.5, 0>/1.5]
      [0.7 rgb <3,2,0>/1.5]
      [0.75 rgb<2,2,0>/1.5]
      [0.8 rgb<0,3,0>/1.5]
      [0.95 rgb <3,0,0>/1.5]
   }
   scale .25  rotate x*-90
 }
finish{specular .5   reflection .25  ambient .15}
normal{ bumps .001}
}

#declare Starfish = union{

#declare Depth =0;
#declare Rad = 1;
#declare Sdiam = 1;
#declare Sdiam_inc = 0.1;
#declare Count = 0;
#declare Reps = 0;
#declare Radinc = 0.5 ;
#declare Angle = 0;

#while(Reps<9)
       #while(Count<5)
          blob{
             threshold 0.45
             sphere{<0,0,0>,Sdiam,1
             translate<0,Rad,Depth>
             rotate z*Angle
             }
              texture{StarfishTex}
             }
          #declare Count = Count + 1;
          #declare Angle = Angle + 72;
       #end
    #declare Reps = Reps +1;
       #if (Reps = 1)
           #declare Rad = Rad + Radinc;
         #else
           #declare Rad = Rad + Radinc/(Reps/2);
       #end
    #declare Count = 0;
    #declare Sdiam = Sdiam - Sdiam_inc;
    #declare Depth = Depth + 0.2;
#end

object{sphere{<0,0,0,>1}scale<1,1,0.75>
        texture{StarfishTex}
     }
}


