#version unofficial MegaPov 0.5;
#include "colors.inc"

global_settings {
assumed_gamma 1.0
max_trace_level 15
}

camera {location <0,1.5,-5> look_at z*10000} //was-5
//camera {location <0,10,> look_at 0}

//Main Light        
light_source { <1200000,2500000/1.25,93000000> 
color <0.9, 0.8, 0.3>*.275 //<0.9, 0.8, 0.4>*.275
//parallel 
rotate x*-5 
//rotate y*-2.5     //none or 5 OK -5vg
media_attenuation on //light decreases passing through media
media_interaction on
}
                       
//Fill Light
light_source { <25,100,-100> color <0.9, 0.8, 0.4>*.33
media_attenuation off 
media_interaction off
}

//sky_sphere{pigment{gradient y turbulence .2 color_map{[0.0 color rgb <0,.7,.9>/2][0.3 color rgb <0,.7,.9>/3  ]}}}
sky_sphere{pigment{radial frequency 4
//rotate y*20 
color_map{                                                                                                                          
[0.0 rgb<.9,.9,.7>/1.125]
[0.5 rgb<.3,.6,.7>/4]
[1.0 rgb<.9,.9,.7>/1.125]
}}}

//-------------------------------------------------
                                                                                                  
$ Sky_on = 1; 
$ Atmos_on = 1;
$ Boat_on = 1;
$ Sea_on = 0; 
$ Fog_on = 1;
$ Hills_on = 1;
$ Birds_on =1;
$ Ground_on =  0; 
$ Starfish_on =0;
$ Spray_on = 0;
$ Figures_on = 1;

//------------------------------------------------------

#if(Boat_on = 1)

#include"Boat.inc" 
#include"Sail.inc"
#include "Sail3.inc" 
//#include"Sail4.inc"

object{boat scale .5 rotate y*75 rotate z*8 translate <1,1.25,1.75>}

#declare C = -1;
#declare Rings = union{
    #while (C<4)
        torus{.05,.01 pigment{rgb.4}finish{specular 1 roughness.001 metallic}
            translate y*C/7
        }
      #declare C = C+1;
    #end
}

#declare SailOB = union{
    object{Sail scale <.2,.175,.2> rotate y*75  rotate z*18 translate <0,.275,1.75>clipped_by{plane{y,0.125 inverse}}} //<-.125,.13,1.75> 
    object{Sail3 scale <.3,.3,.2>  rotate z*20 rotate y*0 rotate x*-4.5 translate <-0.29,.775,0.5>clipped_by{plane{y,0.3125 inverse}}}
    object{Mast scale <.5,.5,.6> scale <1,2,1> rotate z*90 rotate y*70 rotate z *-10 translate <-.125,0.175,1.75> no_shadow}
    object{Rings rotate z*90 rotate y*70 rotate z *-10 translate <0,0.9125,1.75>}
}

//object{SailOB rotate z*-15 rotate y*-25 translate <.55,-0.0825,.5>} 

#declare Loop = torus{1,0.05}
#declare End = torus {.2,0.05}
#declare Link = cylinder{z*.2,z*.3,0.05}

#declare Rope = union{
object{Loop clipped_by{plane{z,0 inverse}}rotate x*90}
//Front
object{End rotate y*90 rotate x*90 rotate y*90 clipped_by{plane{y,0 inverse}}clipped_by{plane{z,0 }}translate <-1,0,.2>}//left 
object{End rotate y*90 rotate x*90 rotate y*90 clipped_by{plane{y,0 inverse}}clipped_by{plane{z,0 }}translate <1,0,.2>}//right
//Back
object{End rotate y*90 rotate x*90 rotate y*90 clipped_by{plane{y,0 inverse}}clipped_by{plane{z,0 inverse}}translate <-1,0,.3>}//left 
object{End rotate y*90 rotate x*90 rotate y*90 clipped_by{plane{y,0 inverse}}clipped_by{plane{z,0 inverse}}translate <1,0,.3>}//right
//links
object{Link translate<1,.2,0>}
object{Link translate<-1,.2,0>}
}
#declare Ropes = union{
object{Rope pigment{Tan/2}scale<.75,1.25,1> normal{granite 1 scale .002 }}
object{Rope pigment{Tan/2}scale<.75,1.25,1>scale <.75,1,1> translate x*-.325 normal{granite 1 scale .002 }} 
object{Rope pigment{Tan/2}scale<.75,1.25,1>scale <.75,.75,1> translate x*-.75 normal{granite 1 scale .002 }}
}

//object{Ropes scale .25 rotate y*46 rotate z*12 translate <1,.8,-0.175>}
#end
//-------------------------------------------------

# if(Sea_on = 1)

#declare Spume = texture{   
       pigment {bozo  pigment_map {
         [0.55 bozo color_map {[.25 rgb 3][.3 rgbt <0.21, 0.3, 0.22,.35>]} scale .5 turbulence 3]  //rgb <0.21, 0.3, 0.22> WASrgb<.175,.35,.45>/2
         [.65 crackle color_map {[.0001 rgb <4.5,6,4.5>] [.125 rgbt <0.21, 0.3, 0.22,.35>]}scale .2 turbulence 0.5] 
         [.85 crackle color_map {[.0001 rgb <4.5,6,4.5>] [.325 rgbt <0.21, 0.3, 0.22,.35>]}scale .2 turbulence 0.5]
         }
         rotate y*90
          scale  .5  
         } // end of pigment map
         finish{ambient 0.125 diffuse .8 specular .75 roughness .001 reflection .4} 
            normal {granite -.8 scale .5}
}

#declare Spume2 = texture{   
       pigment  {crackle color_map {
            [.01 rgb <2.5,3,2.5>  ] 
            [.375 rgbt <0.21, 0.3, 0.22,.35>] //was.55
            }
            scale .15 turbulence 0.5
            }
            finish{ambient 0.175 specular 1 roughness .001 reflection .4} 
            //normal {crackle -.8 scale .5}
}

#declare Spume3 = texture{   
       pigment  {crackle color_map {
            [.01 rgb <2.5,3,2.5>  ] 
            [.75 rgbt <0.21, 0.3, 0.22,.35>]
            }
            scale .05 turbulence 0.5
            }
            finish{ambient 0.2 specular .5 roughness .001 reflection .4}
           // normal {crackle -.8 scale .25}
}

#declare Ocean_Tex =  
  texture {
    gradient y 
    turbulence <.2,.35,.2>//.2      
    texture_map {
      [.6 Spume] //5
      [.85 Spume2]  //75
      [.9 Spume3]
    }
    scale <1,.5,1>
  }
  
#declare Ocean = object{ 
 height_field{png "seapig.png "
 smooth
  translate <-0.5,0,-0.5>
  scale <100,0.5,150>
      texture{Ocean_Tex}
  	interior{
 	   media{absorption <.2,.05,.2>
  	    samples 2,2
  	    }
  	    }  
  //texture{pigment{rgbt <0.21, 0.3, 0.22,.35>} }finish{ambient 0.125 diffuse .8 specular .75 roughness .001 reflection .4}}
 hollow  
 }
}

object{Ocean}

#end

//----------------------------------------------------------

#if(Sky_on = 1)

#declare Rad = 2500000/(2 * pi);

difference {
  sphere { 0,Rad}
  sphere {0,Rad-5000}
  material{
    texture{
    //pigment{rgbt<0,1,0,.5>}
      pigment{ rgbf 1}
    }
    interior{
      media{            
        scattering {2, <.0125,.0125,.01> extinction 0.4} //was <.01,.0125,.01> .4
        method 3
        samples 22,22  //22
        intervals 2   
         density { 
          wrinkles   
          ramp_wave
          turbulence .5 
          color_map {           
            [0 rgb 0]           
            [0.4 rgb 0]    
            [0.6 rgb 0.275]
            [1 rgb 0.475]        
          }//colmap 
          scale <20*300,1000,35*300> 
          rotate y*60
         translate <1000,Rad-3000,0> 
        }//density   
        
        density {
          granite
          triangle_wave
          color_map {           
            [0 rgb 0]           
            [0.25 rgb 0]
            [0.325 rgb 0.2]
            [1 rgb 0.4]         
          }//colmap 
          turbulence .4 octaves 3 lambda 7 omega .5         
          scale <20,10,35>*100  
          scale <25,20,25>*1.25 
          //rotate y*-60
         translate <0,Rad-3000,0> 
        }//density
         
      }//media
    }//interior
  }//material
  hollow 
  rotate y*45 
  rotate x*-5
  translate <0,9000-Rad,0>
  clipped_by{plane{y,-1000 inverse}} //-0.1
 //clipped_by{plane{z,5000 inverse}rotate x*-45}
}//difference

#end

//------------------------------------------------------------------

#if(Atmos_on = 1)
                                                   
sphere{0,Rad-5000.5                                                                                                                      
  material{
    texture{
      pigment{ rgbf 1}
      //pigment{ rgbt <0,0,1,.5>}
    }
    interior {
      media {                                                 
        scattering {3, .01 extinction 0.0875}//.195/2
        method 3                                      
        samples 15,15     //15   
        intervals 1
        density {
          color rgb <.3/2 ,.275/2,.175/2 > 
        }
      }
    }
  }
  hollow
  translate <0,9000-Rad,0>
  clipped_by{plane{y,-1000 inverse}}
 //clipped_by{plane{z,5000 inverse}rotate x*-45}
}
#end

//------------------------------------------------------------------------

#if(Fog_on = 1)

fog
{
  fog_type   2
  distance   300 
  color  rgbt<0.55, 0.7 ,0.7,0.6> 
  fog_offset 4 //was 2
  fog_alt    1 
  turbulence 55 // was 15 
}

fog
{
  fog_type   2
  distance   100 
  color  rgbt<0.45/3, 0.6/3,0.6/3,0.2> 
  fog_offset 3 //was 2
  fog_alt    .5  
  turbulence 75  //was 55
}

fog
{
  fog_type   2
  distance   70 
  color  rgbt<0.25/4, 0.6/4,0.6/4,0.0> 
  fog_offset 2 //was 2
  fog_alt    .05  
  turbulence 75  //was 55
}
#end 

//-----------------------------------------------------------------
#if(Hills_on = 1)

#declare Hills =
height_field{
  tga "Hills.tga"     

//texture {pigment{rgb <0, 0.06, 0.5>}finish{ambient .6}}  
texture {pigment{rgb <0.3, 0.38, 0.4>}finish{ambient .6}}
smooth        
translate <-.5,0,-.5>
rotate y*180

scale <200,15,150>

}

object{Hills translate <65,-3,200> }
object{Hills translate <105,-3.325,110> }

#end

//--------------------------------------------------------------------
#if(Birds_on = 1)

#declare Wangle = 80;
#declare WHeight = 2.75;
#declare WWidth = 2.75;

#include "BWing.inc" 

object{Bird //top
scale 0.05/2
rotate x*20                                     
rotate y*-65
translate<1.5,5,3.5>
no_shadow 
}

#declare Wangle = 50;
#declare WHeight = 3.75;
#declare WWidth = 1.5; 

#include "BWing.inc" 

object{Bird  //mid right
scale 0.075/2 
rotate y*115
rotate z*15
translate<2.75,2.75,2.5>
no_shadow  
}

#declare Wangle = 110;
#declare WHeight = 1;
#declare WWidth = 3.75;
#include "BWing.inc" 

object{Bird //low centre 
scale 0.06/2
rotate y*70 //was 30
rotate z*30 //was 10
rotate x*-15
rotate y*160
translate<-.85,2,0>
no_shadow  
}

#declare Wangle = 110;
#declare WHeight = 1;
#declare WWidth = 3.75;

#include "BWing.inc" 

object{Bird //midleft
scale 0.06/2
rotate y*-70
rotate z*30
translate<-3.25,3.5,3>
no_shadow  
}

#declare Wangle = 80;
#declare WHeight = 2.75;
#declare WWidth = 2.75;

#include "BWing.inc" 

object{Bird  //low midright
scale 0.06/2
rotate y*-60
rotate x*15
rotate z*15
translate<1.5,1.8,1>
no_shadow  
}

#declare Wangle = 110;
#declare WHeight = 1;
#declare WWidth = 3.75;

#include "BWing.inc" 

object{Bird  //low farleft
scale 0.1/2
rotate y*80
rotate z*-30
translate<-3,2.25,1>
no_shadow  
}

#end

//-----------------------------------------------------------------

#if (Ground_on = 1)

//mAlign was Borrowed from Gilles Trans Tree macro

#macro mAlign(P1,P2)
#local yV1=vnormalize(P2-P1);
#local xV1=vnormalize(vcross(yV1,z));
#local zV1=vcross(xV1,yV1);
     matrix <xV1.x,xV1.y,xV1.z,yV1.x,yV1.y,yV1.z,zV1.x,zV1.y,zV1.z,P1.x,P1.y,P1.z>
#end 

$ RockTex = texture{
	pigment {
		bozo
		color_map {
			[ 0.25 color < 1, .75, .45> ]
			[ 0.50 color <.9, .75, .6> ]
			[ 1 color <.85, .7, .6> ]
		} // color_map 
            turbulence .6 lambda 8 frequency 6 scale .125
	} // pigment
	   finish{
	        specular .75
	        roughness .25
	        diffuse .9 
	        brilliance 1
	        ambient -.0000001
	       metallic
	        reflection .2
	        }
	             normal{
                    average normal_map{
                        #declare Count = 1;
                            #while(Count<10)
                               [ 1 crackle 45/Count turbulence .25 scale .05/Count]
                               [ 1 bumps 90/Count ramp_wave scale .05/Count]
                               [ 1 bumps 75/Count ramp_wave scale .15/Count]
                            #declare Count = Count+1;
                            #end
                            } 
	                    }   
}	        
texture{ 
  pigment {
    bozo
    turbulence .5
    frequency 3
    lambda 6
    color_map {
      [0.45 rgbt 1]
      [0.475 rgbt <.5,.3,.2,.6>*3]
      [0.6 rgb <.3,.1,0>*3]
      [0.75 rgb <.3,.25,0>*5]
      [0.95 rgb <.6,.3,0>*3]
    }
    scale .125
  }
  finish{specular 1 roughness.01 ambient 0 diffuse 1}
  normal{bumps 5 scale 0.001}
}

#declare ShellTex = texture{
pigment{radial frequency 25
    color_map {
    [ 0.25 rgb <0.99609, 0.99609, 0.84375>]
      [0.7 rgb 3]
      [0.75 rgb<0,1,0>]
      [0.8 rgb<0,3,0>]
      [0.85 rgb <3,3,0>]
      [0.9 rgb <3,1.5,0>]
      [0.95 rgb <3,0,0>]
   }
   scale .25
 }
finish{specular 10  metallic reflection .5 brilliance 5 ambient .1}
normal{ 
average normal_map{
    [1.0 radial .5 frequency 20 scallop_wave]
    [1.0 gradient y .3 frequency 10 scallop_wave]
    }
    }
}

        
#declare MaxHeight = 1;

$ HF =
height_field
{
  tga               
  "Rocks.tga"     
inverse 
smooth

scale <2,MaxHeight,2> 
}

$ TracedObj = union{
$ Norm = <0,0,0>;
$ Xpos = -2;
$ Zpos = 2; 
$  Rnd = seed(7967);
$ Cutoff_Height = .25;

#while (Xpos<2)

   #while (Zpos>-2)
        
       $ SPos = <Xpos,MaxHeight+1,Zpos>;
  
       $ Inter = trace (HF,SPos,<0,-1,0>, Norm ); 
       
                        #if (Norm.x != 0 | Norm.y != 0 | Norm.z != 0)
                             #if (Inter.y > Cutoff_Height)
                                    isosurface{
                                        function{sqrt(sqr(x*2)+sqr(z*2))+(y)+(noise3d(x*20,0,z*20)/10)}
                                            threshold 1
                                            sign 1
                                            contained_by{box{<-1,0,-1>,<1,.8,1>}}
                                            texture{ShellTex}
                                            //pigment{White}
                                            scale <0.1,0.0375,0.1> +(rand(Rnd)/25)
                                            scale .375
                                            mAlign(Inter-.00875,Inter+Norm)
                                            }

                            #end
                        #end 
                        
    $ Zpos = Zpos -(.01+(rand(Rnd)/25));
    #end           
    $ Zpos = 2;
  $ Xpos = Xpos +(.01+(rand(Rnd)/25)); 
 #end 
}

$ Rocks = union{ 
object{HF texture{RockTex}}  
//object{HF pigment{Tan/2}} 
object{TracedObj}
}

object{Rocks scale 1.3 rotate y*25 translate<-3.75,-.1,-2>} //translate<-3.25,-.1,-2>
object{Rocks scale 1.1 rotate y*180 translate<0.125,-.1,-2.325>}


#end

//--------------------------------------------------------------------------------
#if(Starfish_on = 1)

#include"Starfish.inc"

object{Starfish scale .025 rotate x*20 rotate z*-50 rotate y*-45 translate<-1.675,0.45,-1.65>}
object{Starfish scale .0175 rotate z*25 rotate x*20 rotate y*-35 translate<-2,0.9,-1.6125>}
object{Starfish scale .02 rotate z*45 rotate x*20 rotate y*-67.5 translate<-1.7,0.7,-1.45>}

#end

//--------------------------------------------------------------------------------

#if(Spray_on = 1)
 
#declare SprayTex =  
  texture {pigment{
    gradient y 
    turbulence .3      
    pigment_map {
           [0.25 spotted pigment_map {[0.35 color rgbt <1,1,1,1>][1 color rgbt <20,20,20,>]}
                scale .025 
                turbulence .25  
                ]
           [0.325 spotted pigment_map {[0.65 color rgbt <1,1,1,1>][1 color rgbt <20,20,20,>]}
                scale .0375
                turbulence .25  
                ]
           [0.5 spotted pigment_map {[0.75 color rgbt <1,1,1,1>][1 color rgbt <20,20,20,>]}
                scale .05
                turbulence .25  
                ]                
    }
    scale <1,1.5,1>translate y*-.25
    }
  }
  
#declare SprayTex2 =  
  texture {pigment{
    gradient y 
    turbulence .3      
    pigment_map {
           [0.35 spotted pigment_map {[0.675 color rgbt <1,1,1,1>][1 color rgbt 30]}
                scale .025 //.25
                turbulence .25  
                ]
           [0.5 spotted pigment_map {[0.75 color rgbt <1,1,1,1>][1 color rgbt 30]}
                scale .0225
                turbulence .325  
                ]
           [0.75 spotted pigment_map {[0.8 color rgbt <1,1,1,1>][1 color rgbt 30]}
                scale .02
                turbulence .25  
                ]                
    }
    scale <1,1.5,1>translate y*-.25
    }
    normal{crackle 50 scale .05 ramp_wave}
  }
    
//Rocks on left
/*  
cone{1*y,  1.0,-1*y, 0.0 open texture{SprayTex}rotate y*25 rotate z*20 scale <.9,1.25,.3>translate<-3,.45,0>}
cone{1*y,  1.0,-1*y, 0.0 open texture{SprayTex}rotate y*45 scale <.9,1.5,.3>translate<-2.5,.8,0.5>}
cone{1*y,  1.0,-1*y, 0.0 open texture{SprayTex}rotate y*85 scale <.9,1.75,.3>translate<-2.5,.4,0.5>}
cone{1*y,  1.0,-1*y, 0.0 open texture{SprayTex}rotate y*135 scale <.9,1.35,.3>translate<-2,.375,0.5>}
cone{1*y,  1.0,-1*y, 0.0 open texture{SprayTex}rotate z*-30 scale <.9,1.5,.3>translate<-1,.125,0>}
cone{1*y,  1.0,-1*y, 0.0 open texture{SprayTex}rotate z*-20 scale <.9,1,.3>translate<-2.25,0,0>}
*/

//boat
#include"spray2.inc"
object{Spray2 texture{SprayTex2 scale 1.5 translate y*-2}
scale <.7,.9,.7> 
rotate z*70 
rotate x*-19
translate<1.5,0.125,0>
}
#include"spray2.inc"
object{Spray2 texture{SprayTex2 scale 1.5 translate y*-2}
scale <.7,.9,.7>/1.1 
rotate z*70 
rotate x*-25
translate<1.6,0.15,-0.1>
}
 
object{Spray2 texture{SprayTex2 scale 1.5 translate y*-2}
scale <.7,.9,1>
rotate y*180
rotate z*-70
rotate y*-30 

translate<1.5,0.15,0>
}  
object{Spray2 texture{SprayTex2 scale 1.5 translate y*-2}
scale <.7,.9,1>/1.1
rotate y*180
rotate z*-75
rotate y*-35 

translate<1.6,0.175,-0.1>
}

#end 

//--------------------------------------------------------------------------------------
#if (Figures_on = 1)
//-------------------------------------BODY--------------------------------------------- 

#declare OBJuvPOV_Texture = texture{pigment{image_map{tga "ManTex2.tga"}}finish{ambient.375 specular.325}}

#declare OBJuvPOV_Texture_OBJuvPOVskin = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVeyeLash = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVtongue = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVteeth = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVeyeBrow = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVlips = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVinnerMouth = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVpupil = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOViris = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVeyeBall = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVnipple = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVnailsH = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVnailsF = texture {OBJuvPOV_Texture}

#declare Body = union{#include "Body.inc"}

//-------------------------------------JEANS--------------------------------------------- 

#declare OBJuvPOV_Texture = texture{pigment{rgb<2,2,0>}}

#declare OBJuvPOV_Texture_OBJuvPOVpants = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVbelt = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVbuckle = texture {OBJuvPOV_Texture}

#declare Jeans = union{#include "BodyJeans.inc"} 

//-------------------------------------JUMPER--------------------------------------------

#declare OBJuvPOV_Texture = texture{pigment{rgb<.5,.25,.1>}normal{bumps 5 scale.01}finish{specular .3}}

#declare OBJuvPOV_Texture_OBJuvPOVshirt = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVshirtTrim = texture {OBJuvPOV_Texture}

#declare Jumper = union{#include "BodyJumper.inc"}
#include"oilskinCrew.inc"

#declare PullingFig = union{
    object {OilskinCrew scale.1 translate<0,.4,0.00>}
    object {Body} 
    object {Jeans}
    object {Jumper}
}


object{PullingFig scale 1.75 rotate y*45 translate<1.05,.125,2> no_shadow}

//---------------------------------------HELM---------------------------------------------------------------

#declare OBJuvPOV_Texture = texture{pigment{image_map{tga "ManTex.tga"}}finish{ambient .275 specular .4}}

#declare OBJuvPOV_Texture_OBJuvPOVskin = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVeyeLash = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVtongue = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVteeth = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVeyeBrow = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVlips = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVinnerMouth = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVpupil = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOViris = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVeyeBall = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVnipple = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVnailsH = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVnailsF = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVhair = texture {pigment{rgb 0}finish{specular 1 roughness.05}normal{bumps 5 scale .025}} 

#declare HelmBdy = union{#include "Helmsman.inc"} 
//object{HelmsmanBdy}

//---------------------------------------JEANS-----------------------------------------------------

#declare OBJuvPOV_Texture = texture{pigment{rgb<2,2,0>}}

#declare OBJuvPOV_Texture_OBJuvPOVpants = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVbelt = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVbuckle = texture {OBJuvPOV_Texture}
#declare OBJuvPOV_Texture_OBJuvPOVskin = texture {OBJuvPOV_Texture}

#declare HelmsmanJeans = union{#include "HelmJeans.inc"}

//---------------------------------------JUMPER----------------------------------------------------

#declare OBJuvPOV_Texture = texture{pigment{rgb<.1,.4,.5>}normal{bumps 5 scale.01}finish{specular .3}}

#declare OBJuvPOV_Texture_OBJuvPOVshirt = texture {OBJuvPOV_Texture}

#declare HelmsmanJumper = union{#include "HelmJumper.inc"}

#include"oilskin2.inc"

#declare Helm = union{
    object{Oilskin scale .1 translate <0.025,.505,0>}
    object{HelmBdy}
    object{HelmsmanJeans}
    object{HelmsmanJumper}
}

object{Helm scale 1.9 rotate z*8 rotate y*78 rotate x*-15 translate<.75,.125,2.95> no_shadow}
 
#end