// -----  Hugh S. Steele
#version unofficial MegaPov 0.5;

/*
From: "Chris Huff" <chrishuff@mac.com>
Subject: Smoke macro source code
Date: Saturday, July 29, 2000 1:48 PM

This is just a very simple particle system for simulating smoke. It 
should work fine in the official version, it doesn't use any MegaPOV 
features.
*/

  #declare ShinyBubble = texture
  {
    pigment{ color rgb 1  transmit .97 }
    finish
    {
      ambient 0.5
      specular 1 
      roughness .0001 
      phong 1
      phong_size 200
      reflection .2 
      irid{ 0.15  thickness 0.4  turbulence 0.4 }
    }
  }


// -----

  #macro SRand( pSeed )  (( rand( pSeed ) * 2 ) - 1 )  #end

  #macro SmokeParticle( pIter, pStartPos, pStartVel, pRadius, pRandRadius, pJitter, pWind, pRSeed )

    #declare Drag = 0.07;  // .25;
    #declare Buoyancy = 0.1; // 0.1;
    #declare StartTemperature = 5;
    #declare CoolRate = 0.5;  // 0.7;

    #local lPos = pStartPos;
    #local lVel = pStartVel + <SRand( pRSeed ) * pJitter, SRand( pRSeed ) * pJitter, SRand( pRSeed ) * pJitter>;
    #local T = StartTemperature;
    #local J = 0;

    #while( J < pIter )
      #local T = T * CoolRate;
      #local lForce = ( y * T * Buoyancy ) + (( pWind - lVel ) * Drag );
      #local lVel = lVel + lForce;
      #local lPos = lPos + lVel;
      #local J = J + 1;
    #end

    sphere{ lPos, ( pRadius + pRandRadius * rand( pRSeed )), rand( pRSeed )  scale <1,rand( pRSeed ),1> }

  #end


  #macro AirBubbles( pLocation, pTravel )

    #declare lRSeed = seed( tick_count );
    #declare lWind = pTravel;
    #declare lPos = pLocation;

    #declare J = 0;
    #declare Parts = 150;

    blob
    {
      threshold .25

      #while(J < Parts)

        SmokeParticle( 35*(1-J/Parts), lPos, y*0.5, 0.25, 0.25, 0.5, lWind, lRSeed )
        SmokeParticle( 45*(1-J/Parts), lPos, y*0.5, 0.25, 0.5, 0.25, lWind, lRSeed )
        SmokeParticle( 55*(1-J/Parts), lPos, y*0.5, 0.5, 0.5, 0.25, lWind, lRSeed )

        #declare lPos = lPos - ( y * 0.1 );
        #declare J = J + 1;
      #end

      texture{ ShinyBubble }
      interior{ ior 1.35 caustics 50 }
    }
  #end
