// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 0.5
// Desc: Sea Topic
// Date: Aug 31, 2000
// Auth: Jim Charter

#version unofficial MegaPov 0.5;     
#include "kolors.inc" //Ken Tyler w additions       
#include "Macs.inc"   //John Vansickle

#include "sea_textures.inc"
#include "sea_build_arrays.inc"
#include "sea_bird_wings.inc"
#include "sea_bird.inc"
#include "sea_reed.inc" 
#include "sea_bird_body_3_uv2.inc" //uvmapper

     
global_settings { max_trace_level 30 }
global_settings { motion_blur 8, 5 }

              
$ camera_location = <  600,   200,   200 >;     
 
camera
{    //location < 4000, 2000, 4000 >
     location camera_location     
     look_at < -300, 150, 00> 
     //look_at <0,0,0>
     angle 30
}

$ render_background     = 1;
$ render_birds          = 1;
$ render_area_light     = 1;
$ render_fill_light     = 1;

#if ( render_area_light ) 
    light_source
    {
      0*x  
      color 1.5*PapayaWhip         
      area_light
      <80, 0, 0> <0, 0, 80>  
      4, 4                 
      adaptive 0           
      jitter               
      translate < 500, 4000, 250 >   
    }
#else    
    light_source { 0  PapayaWhip      translate < 500, 4000, 250 > }
#end

#if ( render_fill_light )
    light_source { 0  0.5*LightSkyBlue  shadowless  } 
#end                                                     

#if ( render_background )
    # include "sea_background.inc"
#else 
    plane { y, -30 pigment { LightSkyBlue } }
    sky_sphere { pigment { gradient y color_map { [0 Pink][.1 LightSkyBlue][1 RichBlue] } } }     
#end

#if ( render_birds )
    $ R = seed(55777); 
  //$ R = seed(12345);
 
  $ c1 = 0;#while ( c1 < 2 )  //2
       $ c2 = 2.5;#while ( c2 < 8  )
          $ c3 = 0;#while ( c3 < 8   )
          
             $ random_value =  .999*rand(R); 
             object { sea_bird(random_value,1     )   
                      translate < 60-(c1*60), 6+(c2*36),  (30*c1)+((c3*36)-(c2*18)-(c1*36)) >+< (24*rand(R))-12, (18*rand(R))-9, (18*rand(R))-9 >     
                   
             }
             #if ( mod(c3,2)=0 )    
                 object { reed(random_value)  
           
                    translate < 60-(c1*90), 6,  (6+c1)+((c3*6)-(c2*18)-(c1*36)) >+< (40*rand(R))-20, (10*rand(R))-5, (18*rand(R))-9 >     
           
                 }
             #end
             $ c3 = c3+1;               
          #end//inner loop
          $ c2 = c2+1;
      #end//middle loop
      $ c1 = c1+1;     
  #end//outer loop
  #while ( c1 < 5 ) //7
   $ c2 = 1;#while ( c2 < 12  )
      $ c3 = 1;#while ( c3 < 10   )
             
             $ random_value =  .999*rand(R); 
             object { sea_bird(random_value,2)   
                      translate < -(c1*60),  c2*32,  (20*c1)+((c3*45)-(c2*45)-(c1*30)) >+< (24*rand(R))-12, (18*rand(R))-9, (18*rand(R))-9 >     
                   
             }
             #if ( mod(c3,2)=0 & c2 > 7 )    
                 object { reed(random_value)  
           
                    translate < 60-(c1*90), 6,  (6+c1)+((c3*6)-(c2*18)-(c1*36)) >+< (40*rand(R))-20, (10*rand(R))-5, (18*rand(R))-9 >     
           
                 }
             #end
      
             $ c3 = c3+1;
          #end//inner loop
          $ c2 = c2+1;
      #end//middle loop
      $ c1 = c1+1;     
  #end//outer loop
      #while ( c1 < 0  )  //10
       $ c2 = 1;#while ( c2 < 12  )
          $ c3 = 1;#while ( c3 < 12   )
              
              $ random_value =  .999*rand(R);
              object { sea_bird(random_value,3)   
                       translate < -(c1*72),  c2*26,  (20*c1)+((c3*50)-(c2*45)-(c1*30)) >+< (24*rand(R))-12, (20*rand(R))-10, (30*rand(R))-15 >                         
              }
                           
              $ c3 = c3+1;
          #end//inner loop
          $ c2 = c2+1;
      #end//middle loop    
      $ c1 = c1+1;     
  #end//outer loop

#end //render birds 

