// Persistence of Vision Ray Tracer Scene Description File
// File: .inc
// Vers: 0.5
// Desc: Sea Topic
// Date: Aug 31, 2000
// Auth: Jim Charter

#version unofficial MegaPov 0.5;     


#macro sea_bird(random_value,detail_level)

union {
 
$ index = int(100*random_value);
$ angle_of_stroke = (int(90*random_value))-45;



//sea_bird_wings 
#if ( detail_level = 1 )                                                                

        #if ( mod ( index, 2 ) = 0 ) 
                                     
              union {
                          object { wing_left_1 scale <.8,1,.8>  
                          AxisRotate(<0,-.5*(1-random_value),1>,  angle_of_stroke )   
                              AxisRotate(v_radius, -angle_of_incidence[index])
                                  translate < 3,0,-1.5 >
                                                    
                          }
                          object { wing_right_1 scale <.8,1,.8>   
                           AxisRotate(<0,-.5*(1-random_value),1>,  -angle_of_stroke )   
                              AxisRotate(v_radius, -angle_of_incidence[index])
                                  translate < -3,0,-1.5 >                      
                          } 
                          
              }
                    
        #else
              
              motion_blur  {
        
                  union {
                              object { wing_left_1 scale <.8,1,.8>  
                              AxisRotate(<0,-.5*(1-random_value),1>,   (angle_of_stroke+(.1*angle_of_stroke*clock)) )   
                                  AxisRotate(v_radius, -angle_of_incidence[index])
                                      translate < 3,0,-1.5 >
                                                        
                              }
                              object { wing_right_1 scale <.8,1,.8>   
                               AxisRotate(<0,-.5*(1-random_value),1>,  -(angle_of_stroke+(.1*angle_of_stroke*clock)) )   
                                  AxisRotate(v_radius, -angle_of_incidence[index])
                                      translate < -3,0,-1.5 >                      
                              } 
                              
                  }
              
              }
              

        
        #end   //if   
              
              
              
              
              
#end // detail level 1


#if ( detail_level = 2 )

        #if ( mod ( index, 3 ) = 0 ) 

              motion_blur  {
        

    
                    union {
                              object { wing_left_2 scale <.8,1,.8>  
                              AxisRotate(<0,-.5*(1-random_value),1>, (angle_of_stroke+(.1*angle_of_stroke*clock))  )   
                                  AxisRotate(v_radius, -angle_of_incidence[index])
                                      translate < 3,0,-1.5 >
                                                        
                              }
                              object { wing_right_2 scale <.8,1,.8>   
                               AxisRotate(<0,-.5*(1-random_value),1>, -(angle_of_stroke+(.1*angle_of_stroke*clock))  )   
                                  AxisRotate(v_radius, -angle_of_incidence[index])
                                      translate < -3,0,-1.5 >                      
                              } 
                             
                    }
                
              }
                
       #else
        
          union {
                      object { wing_left_2 scale <.8,1,.8>  
                      AxisRotate(<0,-.5*(1-random_value),1>,  angle_of_stroke  )   
                          AxisRotate(v_radius, -angle_of_incidence[index]  )
                              translate < 3,0,-1.5 >
                                                
                      }
                      object { wing_right_2 scale <.8,1,.8>   
                       AxisRotate(<0,-.5*(1-random_value),1>,  -angle_of_stroke )   
                          AxisRotate(v_radius, -angle_of_incidence[index])
                              translate < -3,0,-1.5 >                      
                      } 
                     
          }
          
      
      
                                             
      #end  //if
      
      
      
#end //detail level 2


 //sea_bird_body 
 #if ( detail_level < 3 ) 
        
       object { sea_bird_body
 
                   rotate x*5
                   translate y*.12  //-.1*(1-random_value)  
                   scale 8

       }
       cone { <0,.3,-2.5>, .01, <0,.3,0>, .15 scale 2.75 translate < 0, -1.0, -3.0 > rotate x*-20 texture { t_bird_beak }   } 

 #end


//sea_bird_legs ======================================================================================   
 
$ R2 = seed(random_value*1000)
$ v_h = vaxis_rotate ( <0,-.5,0>,  < 1,0,0>, -90*rand(R2) ); //heel
$ v_k = vaxis_rotate ( <0,-2.0,0>, < 1,0,0>,  30*rand(R2) );//knuckle
$ v_t = vaxis_rotate ( <0,-0.5,0>, < 1,0,0>,  10*rand(R2) ); //tip
 
 
#if ( detail_level < 3 ) 

 
mesh {
    triangle { <0,0,0>                      v_h                     v_h+<0,0,.1>            }   
    
    triangle { v_k                          v_h                     v_h+<0,0,.1>            }   
    
    triangle { v_k+<0, .2,0>                v_k+<0,0,.02>           v_k+v_t+<  0, 0, 0>       }   
    triangle { v_k+<0, .2,0>                v_k+v_t+<-.1, 0, .1>    v_k+v_t+<-.2, 0, .15>        }   
    triangle { v_k+<0, .2,0>                v_k+<0,0,.02>           v_k+v_t+< .2, 0, .3>        }
  
       scale 3.2 rotate x*-(30+(30*random_value)) translate <1,-3.1,5> pigment { DarkTan*.4 }
              
}

$ v_h = vaxis_rotate ( <0,-.5,0>,  < 1,0,0>, -30*rand(R2) ) ; //heel
$ v_k = vaxis_rotate ( <0,-2.0,0>, < 1,0,0>,  30*rand(R2) );//knuckle
$ v_t = vaxis_rotate ( <0,-0.5,0>, < 1,0,0>,  10*rand(R2) ); //tip

mesh {
    triangle { <0,0,0>                      v_h                     v_h+<0,0,.1>            }   
                                                                                                             
    triangle { v_k                          v_h                     v_h+<0,0,.1>            }   
    
    triangle { v_k+<0, .2,0>                v_k+<0,0,.02>           v_k+v_t+<  0, 0, 0>       }   
    triangle { v_k+<0, .2,0>                v_k+v_t+<-.1, 0, .1>    v_k+v_t+<-.2, 0, .15>        }   
    triangle { v_k+<0, .2,0>                v_k+<0,0,.02>           v_k+v_t+< .2, 0, .3>        }
  
      scale 3.8 rotate x*-(30+(30*random_value)) translate <-1,-3.1,5> pigment { DarkTan*.4 } 
  
}
//end legs============================================================================================ 

//sea_bird_tail  
 
mesh {
    triangle { <0,0,1.8> < .25,-.05,3.65> <0,0,3.8>     uv_vectors < 1, 2.5> <0, 3> <0, 0>    }
    triangle { <0,0,1.8> <-.25,-.05,3.65> <0,0,3.8>     uv_vectors <-1, 2.5> <0, 3> <0, 0>    } 
    
    triangle { <0,0,1.8> < .5,-.15,3.35> <0,-.05,3.65>  uv_vectors < 1, 2.5> <0, 3> <0, 0>    }               
    triangle { <0,0,1.8> <-.5,-.15,3.35> <0,-.05,3.65>  uv_vectors <-1, 2.5> <0, 3> <0, 0>    }               
    
    triangle { <0,0,1.8> < .75,-.25,3.05> <0,-.1,3.3>   uv_vectors < 1, 2.5> <0, 3> <0, 0>    }               
    triangle { <0,0,1.8> <-.75,-.25,3.05> <0,-.1,3.3>   uv_vectors <-1, 2.5> <0, 3> <0, 0>    } 
                  
    uv_mapping
    texture { pigment { cylindrical  color_map { [ 0 DarkTan ][ .93 Silver*1.5 ][ 1 DarkTan ]  } } scale 9.5 }
    scale 5
    rotate x*20
    translate y*3    
}

#end//detail level 1, 2

 
bounded_by { box { < -24,-24,-18 > <24, 24, 18 > } } 


}//end overall union 

#end// end sea_bird macro 
 

