// Persistence of Vision Ray Tracer Scene Description File
// File: .inc
// Vers: 0.5
// Desc: Sea Topic
// Date: Aug 31, 2000
// Auth: Jim Charter

#version unofficial MegaPov 0.5; 
#include "sea_feathers.inc"

$ l_wing        =   24;
$ l_humorous    =   l_wing * 1/12;
$ l_radius      =   l_wing * 1/3;
$ l_carpal      =   l_wing * 1/6;
$ l_digit       =   l_wing * 1/12;
$ l_wingtip     =   l_wing * 1/3;

$ w_wing        =   l_wing * 7/12;
$ w_wrist       =   l_wing * 6/12;
$ w_knuckle     =   l_wing * 7/12;

$ r_humorous    =  < 0, -10,  0 >;
$ r_radius      =  < 0,  15,  3 >;
$ r_carpal      =  < 0, -02, -2 >;
#ifndef ( r_digit ) $ r_digit =  < 0, -01, -2 >; #end

$ v_humorous    =   vrotate ( < l_humorous,0,0 >,   r_humorous );
$ v_radius      =   vrotate ( < l_radius  ,0,0 >,   r_radius   );$ v_radius_cntl3 =   vrotate ( <   .25,  -.2,  -.25 >,   r_radius   );$ v_radius_cntl0 =   vrotate ( <  -.25,  0,  -.25 >,   r_radius   );
$ v_carpal      =   vrotate ( < l_carpal  ,0,0 >,   r_carpal   );$ v_carpal_cntl3 =   vrotate ( <   .25,  -.2,  -.25 >,   r_carpal   );$ v_carpal_cntl0 =   vrotate ( <  -.25,  0,  -.25 >,   r_carpal   );
$ v_digit       =   vrotate ( < l_digit   ,0,0 >,   r_digit    );$ v_digit_cntl3  =   vrotate ( <   .25,  -.2,  -.25 >,   r_digit    );$ v_digit_cntl0  =   vrotate ( <  -.25,  0,  -.25 >,   r_digit    );
$ v_wingtip     =   vrotate ( < l_wingtip ,0,0 >,   r_digit    );

$ l_primary_max =   l_wingtip;
$ l_primary_mid =   w_knuckle;
$ l_primary_min =   w_wrist;
$ l_primary_range1 = l_primary_max - l_primary_mid;
$ l_primary_range2 = l_primary_mid - l_primary_min;
 
$ l_secondary_min = l_primary_min;
$ l_secondary_max = w_wing;
$ l_secondary_range = abs(l_secondary_max-l_secondary_min);

$ end_humorous  =   v_humorous;
$ end_radius    =   end_humorous+v_radius;
$ end_carpal    =   end_radius+v_carpal;
$ end_digit     =   end_carpal+v_digit;


$ r_primary_min =   (r_digit.y); 
$ r_primary_mid =   40;
$ r_primary_max =   59;
$ r_primary_range1 = abs(r_primary_mid-r_primary_min);
$ r_primary_range2 = abs(r_primary_max-r_primary_mid);
$ r_secondary_min = 58;
$ r_secondary_max = 110;
$ r_secondary_range = abs(r_secondary_max-r_secondary_min);

// level 1
//////////////////////////////////////////////////////////////////////////////////

//main digit feathers

$ number_of_feathers = 5;

$ digit_feathers_left_1 =

union {
                    
    $ spline_smoothness = ( 1 / number_of_feathers );               
    $ spline_segments = 1;
    $ prev_pos = <0,.001,0>;
    $ prev_scl = .25;                                                               
    $ spline_clock = 0; #while (spline_clock < 1) 
    
        $ point0 = v_digit_cntl0;
        $ point1 = <0,0,0>;
        $ point2 = v_digit;  
        $ point3 = v_digit_cntl3; 
           
        #include "SplineR.inc"
                
        $ feather_rotation = abs(( r_primary_range1 * (1-spline_clock) ) + r_primary_min);
        $ feather_length   = abs( l_primary_range1 * spline_clock ) + l_primary_mid;

        object {
                primary_feather_left_1
                scale feather_length
                rotate x*-(r_digit.z-3)            //tilt along feather's axis      
                rotate z*-(3+(5*(spline_clock)))   //stack feathers so they interleave    
                rotate y*-feather_rotation         //fanning                        
                translate spline_pos
                
        } 
        
        object {
                primary_covert_left_1
                scale feather_length*3/5
                rotate x*-(r_digit.z-1)             //tilt along feather's axis
                rotate z*-(0+(5*(spline_clock)))    //stack feathers so they interleave
                rotate y*-feather_rotation          //fanning
                translate spline_pos+<0,.2,0> 
                
        }
       //  marginal_converts_left
        $ scl = .25-(.15*spline_clock) 
        cone { prev_pos, prev_scl, spline_pos, scl 
               texture { t_marginal_covert }           
        }
 
        $ prev_scl = scl;      
        $ prev_pos = spline_pos;                                                                                                   
        $ spline_clock = (spline_clock + spline_smoothness); 
    
    #end //end while

}//end union


$ thumb_feathers_left_1 =

union {
                    
    $ spline_smoothness = ( 1 / number_of_feathers );               
    $ spline_segments = 1;
                                                                
    $ spline_clock = 0; #while (spline_clock < 1) 
    
        $ point0 = v_digit_cntl0;
        $ point1 = <0,0,0>;
        $ point2 = v_digit;  
        $ point3 = v_digit_cntl3; 
           
        #include "SplineR.inc"
                
        $ feather_rotation = abs(( r_primary_range1 * (1-spline_clock) ) + r_primary_min);
        $ feather_length   = abs( l_primary_range1 * spline_clock ) + l_primary_mid;
        //#debug concat( "fl 1 ",str(feather_length,3,3) ,"\n") 

        
        object {
                primary_covert_left_1
                scale <.6,1,1>*feather_length*(2+(1.5*spline_clock))/5
                rotate x*-(r_digit.z+1)             //tilt along feather's axis
                rotate z*-(0 +(5*(spline_clock)))    //stack feathers so they interleave z*-(3+(5*(spline_clock))) 
                rotate y*-feather_rotation          //fanning
                translate spline_pos+<0,.4,0> 
               
        }
      
        $ spline_clock = (spline_clock + spline_smoothness); 
    
    #end //end while

}//end union
 


$ number_of_feathers = 8;

$ carpal_feathers_left_1 =

union {
                    
    $ spline_smoothness = (1 / number_of_feathers );               
    $ spline_segments = 1;
    $ prev_pos = <0,0,0>;
    $ prev_scl = .5;     
    $ spline_clock = spline_smoothness; #while (spline_clock < 1) 
                                     
        $ point0 = v_carpal_cntl0;
        $ point1 = <0,0,0>;
        $ point2 = v_carpal;                   
        $ point3 = v_carpal_cntl3; 
        
        #include "SplineR.inc"

                
        $ feather_rotation = abs(( r_primary_range2 * (1-spline_clock) ) + r_primary_mid);
        $ feather_length   = abs( l_primary_range2 * (spline_clock) ) + l_primary_min;     //( l_primary_range2 * (1-spline_clock) ) +
                                         
        object {primary_feather_left_1
                scale feather_length 
                rotate x*-(r_carpal.z-3)         //tilt along feather's axis      
                rotate z*-(3*(spline_clock))     //stack feathers so they interleave    
                rotate y*-feather_rotation       //fanning                        
                translate spline_pos
              
        } 
        object {primary_covert_left_1
                scale feather_length*3/5 
                rotate x*-(r_carpal.z-1)         //tilt along feather's axis      
                rotate z*-(1*(spline_clock))     //stack feathers so they interleave    
                rotate y*-feather_rotation       //fanning                        
                translate spline_pos+<0,.2,0>
                
        } 
        
    //  marginal_converts_left
        $ scl = .5-(.25*spline_clock) 
        cone { prev_pos, prev_scl, spline_pos, scl 
               texture { t_marginal_covert }           
        }
 
 
        $ prev_scl = scl;
        $ prev_pos = spline_pos;                                                                                                
        $ spline_clock = (spline_clock + spline_smoothness); 
    
    #end //end while

}//end union


$ number_of_feathers = 12;

$ radial_feathers_left_1 =

union {
                    
    $ spline_smoothness = (1 / number_of_feathers );               
    $ spline_segments = 1;
    $ prev_pos = <0,0,0>;
    $ prev_scl = .75;        
    $ spline_clock = spline_smoothness; #while (spline_clock < 1) 
    
        $ point0 = v_radius_cntl0;
        $ point1 = <0,0,0>;
        $ point2 = v_radius;  
        $ point3 = v_radius_cntl3; 
 
        #include "SplineR.inc"

                
        $ feather_rotation = abs(( r_secondary_range * (1-spline_clock) ) + r_secondary_min);
        $ feather_length   = abs( l_secondary_range * (1-spline_clock) ) + l_secondary_min;     //( l_primary_range2 * (1-spline_clock) ) +
        //main feathers                                 
        object {secondary_feather_left_1
                scale feather_length
                rotate x*-(r_radius.z-5)       //tilt along feather's axis      
                rotate z*0                     //stack feathers so they interleave    
                rotate y*-feather_rotation     //fanning                        
                translate spline_pos
                       
        }
        //second tier
        object {secondary_covert_left_1
                scale feather_length*(4.5-(1.5*spline_clock))/5
                rotate x*-(r_radius.z-5)       //tilt along feather's axis      
                rotate z*0                     //stack feathers so they interleave    
                rotate y*-feather_rotation     //fanning                        
                translate spline_pos+<0,.2,0>
                            
        }
        //third tier
        object {secondary_covert_left_1
                scale feather_length*<1,1,2>*(3-(2.5*spline_clock))/5
                //rotate x*-(r_radius.z-5)       //tilt along feather's axis      
                rotate z*0                     //stack feathers so they interleave    
                rotate y*-feather_rotation     //fanning                        
                translate spline_pos+<0,.3,0>
                           
        }
      //  marginal_converts_left
        $ scl = .75-(.25*spline_clock) 
        cone { prev_pos, prev_scl, spline_pos, scl 
               texture { t_marginal_covert }           
        }
 
 
        $ prev_scl = scl;
        $ prev_pos = spline_pos;                                                                                                 
        $ spline_clock = (spline_clock + spline_smoothness); 
    
    #end //end while

}//end union

//////////////////////////////////////////////////////////////////////////////////
//level 2


//main digit feathers

$ number_of_feathers = 5;

$ digit_feathers_left_2 =

union {
                    
    $ spline_smoothness = ( 1 / number_of_feathers );               
    $ spline_segments = 1;
    $ prev_pos = <0,.001,0>;
    $ prev_scl = .25;                                                                
    $ spline_clock = 0; #while (spline_clock < 1) 
    
        $ point0 = v_digit_cntl0;
        $ point1 = <0,0,0>;
        $ point2 = v_digit;  
        $ point3 = v_digit_cntl3; 
           
        #include "SplineR.inc"
                
        $ feather_rotation = abs(( r_primary_range1 * (1-spline_clock) ) + r_primary_min);
        $ feather_length   = abs( l_primary_range1 * spline_clock ) + l_primary_mid;

        object {
                primary_feather_left_2
                scale feather_length
                rotate x*-(r_digit.z-3)            //tilt along feather's axis      
                rotate z*-(3+(5*(spline_clock)))   //stack feathers so they interleave    
                rotate y*-feather_rotation         //fanning                        
                translate spline_pos
                
        } 
        
        object {
                primary_covert_left_2
                scale feather_length*3/5
                rotate x*-(r_digit.z-1)             //tilt along feather's axis
                rotate z*-(0+(5*(spline_clock)))    //stack feathers so they interleave
                rotate y*-feather_rotation          //fanning
                translate spline_pos+<0,.2,0> 
                
        }
       //  marginal_converts_left
        $ scl = .25-(.15*spline_clock) 
        cone { prev_pos, prev_scl, spline_pos, scl 
               texture { t_marginal_covert }           
        }
 
        $ prev_scl = scl;      
        $ prev_pos = spline_pos;                                                                                                                                                                                                                  
        $ spline_clock = (spline_clock + spline_smoothness); 
    
    #end //end while

}//end union


$ thumb_feathers_left_2 =

union {
                    
    $ spline_smoothness = ( 1 / number_of_feathers );               
    $ spline_segments = 1;
                                                                
    $ spline_clock = 0; #while (spline_clock < 1) 
    
        $ point0 = v_digit_cntl0;
        $ point1 = <0,0,0>;
        $ point2 = v_digit;  
        $ point3 = v_digit_cntl3; 
           
        #include "SplineR.inc"
                
        $ feather_rotation = abs(( r_primary_range1 * (1-spline_clock) ) + r_primary_min);
        $ feather_length   = abs( l_primary_range1 * spline_clock ) + l_primary_mid;
        //#debug concat( "fl 1 ",str(feather_length,3,3) ,"\n") 

        
        object {
                primary_covert_left_2
                scale <.6,1,1>*feather_length*(2+(1.5*spline_clock))/5
                rotate x*-(r_digit.z+1)             //tilt along feather's axis
                rotate z*-(0 +(5*(spline_clock)))    //stack feathers so they interleave z*-(3+(5*(spline_clock))) 
                rotate y*-feather_rotation          //fanning
                translate spline_pos+<0,.4,0> 
               
        }
      
        $ spline_clock = (spline_clock + spline_smoothness); 
    
    #end //end while

}//end union
 


$ number_of_feathers = 8;

$ carpal_feathers_left_2 =

union {
                    
    $ spline_smoothness = (1 / number_of_feathers );               
    $ spline_segments = 1;
    $ prev_pos = <0,0,0>;
    $ prev_scl = .5;     
    $ spline_clock = spline_smoothness; #while (spline_clock < 1) 
                                     
        $ point0 = v_carpal_cntl0;
        $ point1 = <0,0,0>;
        $ point2 = v_carpal;  
        $ point3 = v_carpal_cntl3; 
        
        #include "SplineR.inc"

                
        $ feather_rotation = abs(( r_primary_range2 * (1-spline_clock) ) + r_primary_mid);
        $ feather_length   = abs( l_primary_range2 * (spline_clock) ) + l_primary_min;     //( l_primary_range2 * (1-spline_clock) ) +
                                         
        object {primary_feather_left_2
                scale feather_length 
                rotate x*-(r_carpal.z-3)         //tilt along feather's axis      
                rotate z*-(3*(spline_clock))     //stack feathers so they interleave    
                rotate y*-feather_rotation       //fanning                        
                translate spline_pos
              
        } 
        object {primary_covert_left_2
                scale feather_length*3/5 
                rotate x*-(r_carpal.z-1)         //tilt along feather's axis      
                rotate z*-(1*(spline_clock))     //stack feathers so they interleave    
                rotate y*-feather_rotation       //fanning                        
                translate spline_pos+<0,.2,0>
                
        } 
        
      //  marginal_converts_left
        $ scl = .5-(.25*spline_clock) 
        cone { prev_pos, prev_scl, spline_pos, scl 
               texture { t_marginal_covert }           
        }
 
 
        $ prev_scl = scl;
        $ prev_pos = spline_pos;                                                                                                
        $ spline_clock = (spline_clock + spline_smoothness); 
    
    #end //end while

}//end union


$ number_of_feathers = 12;

$ radial_feathers_left_2 =

union {
                    
    $ spline_smoothness = (1 / number_of_feathers );               
    $ spline_segments = 1;
    $ prev_pos = <0,0,0>;
    $ prev_scl = .75;     
    $ spline_clock = spline_smoothness; #while (spline_clock < 1) 
    
        $ point0 = v_radius_cntl0;
        $ point1 = <0,0,0>;
        $ point2 = v_radius;  
        $ point3 = v_radius_cntl3; 
 
        #include "SplineR.inc"

                
        $ feather_rotation = abs(( r_secondary_range * (1-spline_clock) ) + r_secondary_min);
        $ feather_length   = abs( l_secondary_range * (1-spline_clock) ) + l_secondary_min;     //( l_primary_range2 * (1-spline_clock) ) +
        //main feathers                                 
        object {secondary_feather_left_2
                scale feather_length
                rotate x*-(r_radius.z-5)       //tilt along feather's axis      
                rotate z*0                     //stack feathers so they interleave    
                rotate y*-feather_rotation     //fanning                        
                translate spline_pos
                       
        }
        //second tier
        object {secondary_covert_left_2
                scale feather_length*(4.5-(1.5*spline_clock))/5
                rotate x*-(r_radius.z-5)       //tilt along feather's axis      
                rotate z*0                     //stack feathers so they interleave    
                rotate y*-feather_rotation     //fanning                        
                translate spline_pos+<0,.2,0>
                            
        }
        //third tier
        object {secondary_covert_left_2
                scale feather_length*<1,1,2>*(3-(2.5*spline_clock))/5
                //rotate x*-(r_radius.z-5)       //tilt along feather's axis      
                rotate z*0                     //stack feathers so they interleave    
                rotate y*-feather_rotation     //fanning                        
                translate spline_pos+<0,.3,0>
                           
        }
      //  marginal_converts_left
        $ scl = .75-(.25*spline_clock) 
        cone { prev_pos, prev_scl, spline_pos, scl 
               texture { t_marginal_covert }           
        }
 
 
        $ prev_scl = scl;
        $ prev_pos = spline_pos;                                                                                                 
        $ spline_clock = (spline_clock + spline_smoothness); 
    
    #end //end while

}//end union

$ mirror_x = 
transform { 
                matrix <-1, 0, 0,  
                       0,  1, 0,  
                       0, 0,  1,
                       0, 0, 0 >       
}

$ wing_left_1 = 
    union {
        object { digit_feathers_left_1    translate end_carpal  }      
        object { carpal_feathers_left_1   translate end_radius  }      
        object { radial_feathers_left_1   translate end_humorous}    
        object { thumb_feathers_left_1    translate end_radius  }      
    }
    
$  wing_right_1 = 
object {  wing_left_1 transform { mirror_x } }






$ wing_left_2 = 
    union {
        object { digit_feathers_left_2    translate end_carpal  }      
        object { carpal_feathers_left_2   translate end_radius  }      
        object { radial_feathers_left_2   translate end_humorous}    
        object { thumb_feathers_left_2    translate end_radius  }      
    }
    
$  wing_right_2 = 
object {  wing_left_2 transform { mirror_x } }


                                                                        