// Persistence of Vision Ray Tracer Scene Description File
// File: .inc
// Vers: 0.5
// Desc: Sea Topic
// Date: Aug 31, 2000
// Auth: Jim Charter

#version unofficial MegaPov 0.5;     
 
$ t_primary_feather =    
texture { pigment { cylindrical color_map { [ 0  DarkTan*.8 ][ .25 Silver*1.2  ][ 1  DarkTan*.8 ] } } }

$ t_primary_feather_2 =    
texture { pigment { cylindrical turbulence .4*z color_map { [ .05  Beige*DarkTan*.9  ][ .1 Beige*Silver*1.2  ][ .5 Beige*DarkTan*.5  ][ .9  Beige*Silver*1.2  ][ .95  Beige*DarkTan*.9  ] } } }

$ t_wing_dorsal =    
texture { pigment { cylindrical turbulence .4*z color_map { [ .05  Beige*DarkTan*.7  ][ .1 Beige*Silver*1.2  ][ .5 Beige*DarkTan*.9  ][ .9  Beige*Silver*1.2  ][ .95  Beige*DarkTan*.7  ] } } }

$ t_wing_ventral =    
texture { pigment { cylindrical turbulence .4*z color_map { [ 0  DarkTan*.9  ][ .95 Silver  ][ 1  Beige  ] } } }

        

$ t_primary_covert =
texture { pigment { cylindrical color_map {  [ 0  Silver ][ .05  Silver ][ .3 DarkTan*Silver  ][ .9 DarkTan*.6 ][ 1  Silver ] } } } 

$ t_secondary_feather =
texture { pigment { cylindrical color_map {  [ 0  DarkTan*.6 ][ .1 Silver ][ 1  DarkTan*.6 ] } } } 
 

$ t_secondary_covert =
texture { pigment { cylindrical color_map {  [ 0  Silver ][ .05  Silver ][ .3 DarkTan*Silver  ][ .9 DarkTan*.6 ][ 1  Silver ] } } } 

$ t_marginal_covert =
texture { pigment {Silver} } 

$ t_pigment_1 = pigment { dents scale <.3,.05,.3> color_map {[0 White ][.25 Beige ][.5 DarkTan*.8 ][1 White ]} }
$ t_pigment_2 = pigment { granite scale <.3,.1,.3>*.1 color_map {[0   Beige ][.25 DarkTan*.8  ][.5 DarkTan*.8 ][.75 DarkTan*.8 ][1   Beige  ]} }
$ t_bird_body = pigment { gradient y scale <1,6,1>  pigment_map { [0 t_pigment_1 ][ .5 t_pigment_2 ][1 t_pigment_1 ] } }

$ t_bird_beak = texture { pigment { Black } }  

$ t_reed = texture { pigment { PaleGreen } }


$ t_wet_sand =  texture { pigment { Tan } }

#declare t_water =  texture {
    pigment {color rgbf <1, 1, 1, 1>} 
    finish {phong 1 phong_size 90 diffuse 0 
                conserve_energy
                reflection_min .1
                reflection_max .9
                reflection_falloff 2
    }                                             
    normal { average normal_map { [ quilted turbulence .05 scale <15,5,25>*100 ][ bumps 1 turbulence 1 scale <5,3,10>*3  ]  } rotate y*40  }
} 
 
#declare interior_water = interior {
    ior 1.33
    media {
            absorption <.1, .05, .05>
            samples 2, 2
    }
}