/* IRTC July-August Submission
   Topic: The Sea */
                    
#include "colors.inc"
#include "textures.inc"
                  
//***** THE ENVIRONMENT *****

// Star Light
light_source {  
  <0, 15000, 0>
  color White*.2
  //area_light <5000, 0, 0>, <0, 0, 5000>, 2, 2
  //adaptive 1
  //jitter
  shadowless
}

// Stars
sky_sphere { 
  pigment {
    granite  
    color_map {
      [0.72 rgb 0.00 ] // No Stars in this area
      [0.72 rgb 0.20 ] // Very Very Faint Stars
      [0.75 rgb 0.40 ] // Very Very Faint Stars
      [0.78 rgb 0.60 ] // Very Faint Stars
      [0.81 rgb 0.80 ] // Faint Stars
      [0.85 rgb 0.95 ] // Medium White Stars
      [0.91 rgb 1.00 ] // White Stars 
      [0.91 rgb 0.00 ] // No Stars in this area
    }
  scale .015
  }
}    

// Clouds
box {
  <0,0,0>
  <1,1,1>
  pigment {
    bozo
    turbulence 1
    rotate y*180
    //translate <0,-.2,0>
    scale .5
    color_map {
      [0 rgb .2]
      [.5 rgb 1]
      [.6 rgbt 1]
      [1 rgbt 1]
    }
  }
  scale <5000,550,5000>
  translate <-5000,300,0>
  
  //rotate x*70
  //translate <-5500,2500,1500>
}

// Ocean Waves
height_field {
  tga "irtc20.tga"
  smooth
  pigment { color Navy*.25 }
  finish { reflection 1 }
  scale <2500,-40, 2500>
  translate <-1000,0,-500>
}

// Camera View
camera {
  location <4,19,-13> //sweet spot
  //location <0,30,-100>
  look_at <-18,22,15> //sweet spot
  //look_at <0,30,0>
}

// Ground Fog
fog {
  fog_type 2
  distance 1500
  color rgb <.07,.07,.07>
  turbulence 1
  fog_offset 100
  fog_alt 400
} 

//***** END OF ENVIRONMENT****

//***** BOAT *****

// Hull
#declare Boat = union { 
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -0.125, 1.750> <0.000, -0.087, 1.750> <0.000, -0.027, 1.723> <0.000, 0.000, 1.750> 
		<-0.168, -0.125, 1.750> <-0.168, -0.087, 1.750> <-0.168, -0.027, 1.723> <-0.168, 0.000, 1.750> 
		<-0.215, -0.125, 1.414> <-0.251, -0.116, 1.414> <-0.189, -0.027, 1.414> <-0.215, 0.000, 1.414> 
		<-0.250, -0.125, 1.250> <-0.286, -0.116, 1.250> <-0.224, -0.027, 1.250> <-0.250, 0.000, 1.250> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -0.125, 1.750> <0.000, -0.125, 1.750> <0.000, -0.125, 1.750> <0.000, -0.125, 1.750> 
		<0.168, -0.125, 1.750> <0.000, -0.125, 1.750> <0.000, -0.125, 1.750> <-0.168, -0.125, 1.750> 
		<0.215, -0.125, 1.414> <0.065, -0.125, 1.414> <-0.069, -0.161, 1.414> <-0.215, -0.125, 1.414> 
		<0.250, -0.125, 1.250> <0.100, -0.125, 1.250> <-0.104, -0.161, 1.250> <-0.250, -0.125, 1.250> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -0.125, 1.750> <0.168, -0.125, 1.750> <0.215, -0.125, 1.414> <0.250, -0.125, 1.250> 
		<0.000, -0.087, 1.750> <0.168, -0.087, 1.750> <0.215, -0.087, 1.414> <0.250, -0.087, 1.250> 
		<0.000, -0.027, 1.723> <0.168, -0.027, 1.723> <0.188, -0.027, 1.414> <0.223, -0.027, 1.250> 
		<0.000, 0.000, 1.750> <0.168, 0.000, 1.750> <0.215, 0.000, 1.414> <0.250, 0.000, 1.250> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -0.125, -1.750> <0.000, -0.125, -1.750> <0.000, -0.125, -1.750> <0.000, -0.125, -1.750> 
		<0.202, -0.125, -1.750> <0.000, -0.125, -1.750> <0.000, -0.125, -1.750> <-0.202, -0.125, -1.750> 
		<0.208, -0.125, -1.322> <0.058, -0.125, -1.322> <-0.025, -0.125, -1.313> <-0.175, -0.125, -1.313> 
		<0.250, -0.125, -1.125> <0.100, -0.125, -1.125> <-0.100, -0.125, -1.125> <-0.250, -0.125, -1.125> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -0.125, -1.750> <0.202, -0.125, -1.750> <0.208, -0.125, -1.322> <0.250, -0.125, -1.125> 
		<0.000, -0.087, -1.750> <0.202, -0.087, -1.750> <0.208, -0.087, -1.322> <0.250, -0.087, -1.125> 
		<0.000, -0.027, -1.723> <0.202, -0.027, -1.723> <0.175, -0.038, -1.313> <0.250, -0.038, -1.125> 
		<0.000, 0.000, -1.750> <0.202, 0.000, -1.750> <0.175, 0.000, -1.313> <0.250, 0.000, -1.125> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -0.125, -1.750> <0.000, -0.087, -1.750> <0.000, -0.027, -1.723> <0.000, 0.000, -1.750> 
		<-0.202, -0.125, -1.750> <-0.202, -0.087, -1.750> <-0.202, -0.027, -1.723> <-0.202, 0.000, -1.750> 
		<-0.175, -0.125, -1.313> <-0.175, -0.087, -1.313> <-0.208, -0.038, -1.322> <-0.208, 0.000, -1.322> 
		<-0.250, -0.125, -1.125> <-0.250, -0.087, -1.125> <-0.250, -0.038, -1.125> <-0.250, 0.000, -1.125> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -0.125, 1.750> <0.000, -0.087, 1.750> <0.000, -0.038, 1.750> <0.000, 0.000, 1.750> 
		<-0.168, -0.125, 1.750> <-0.168, -0.087, 1.750> <-0.168, -0.038, 1.750> <-0.168, 0.000, 1.750> 
		<-0.215, -0.125, 1.414> <-0.215, -0.087, 1.414> <-0.175, -0.038, 1.400> <-0.175, 0.000, 1.400> 
		<-0.250, -0.125, 1.250> <-0.250, -0.087, 1.250> <-0.250, -0.038, 1.250> <-0.250, 0.000, 1.250> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -0.125, 1.750> <0.168, -0.125, 1.750> <0.215, -0.125, 1.414> <0.250, -0.125, 1.250> 
		<0.000, -0.087, 1.750> <0.168, -0.087, 1.750> <0.215, -0.087, 1.414> <0.250, -0.087, 1.250> 
		<0.000, -0.038, 1.750> <0.168, -0.038, 1.750> <0.215, -0.038, 1.414> <0.250, -0.038, 1.250> 
		<0.000, 0.000, 1.750> <0.168, 0.000, 1.750> <0.215, 0.000, 1.414> <0.250, 0.000, 1.250> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.250, -0.125, 1.250> <0.329, -0.125, 0.881> <0.375, -0.125, 0.377> <0.375, -0.125, 0.000> 
		<0.250, -0.087, 1.250> <0.329, -0.087, 0.881> <0.375, -0.087, 0.377> <0.375, -0.087, 0.000> 
		<0.250, -0.038, 1.250> <0.329, -0.038, 0.881> <0.375, -0.038, 0.377> <0.375, -0.038, 0.000> 
		<0.250, 0.000, 1.250> <0.329, 0.000, 0.881> <0.375, 0.000, 0.377> <0.375, 0.000, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.375, -0.125, 0.000> <0.375, -0.125, -0.340> <0.321, -0.125, -0.793> <0.250, -0.125, -1.125> 
		<0.375, -0.087, 0.000> <0.375, -0.087, -0.340> <0.321, -0.087, -0.793> <0.250, -0.087, -1.125> 
		<0.375, -0.038, 0.000> <0.375, -0.038, -0.340> <0.287, -0.038, -0.788> <0.250, -0.038, -1.125> 
		<0.375, 0.000, 0.000> <0.375, 0.000, -0.340> <0.287, 0.000, -0.788> <0.250, 0.000, -1.125> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.250, -0.125, -1.125> <0.208, -0.125, -1.322> <0.202, -0.125, -1.750> <0.000, -0.125, -1.750> 
		<0.250, -0.087, -1.125> <0.208, -0.087, -1.322> <0.202, -0.087, -1.750> <0.000, -0.087, -1.750> 
		<0.250, -0.038, -1.125> <0.175, -0.038, -1.313> <0.202, -0.038, -1.750> <0.000, -0.038, -1.750> 
		<0.250, 0.000, -1.125> <0.175, 0.000, -1.313> <0.202, 0.000, -1.750> <0.000, 0.000, -1.750> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -0.125, -1.750> <-0.202, -0.125, -1.750> <-0.175, -0.125, -1.313> <-0.250, -0.125, -1.125> 
		<0.000, -0.087, -1.750> <-0.202, -0.087, -1.750> <-0.175, -0.087, -1.313> <-0.250, -0.087, -1.125> 
		<0.000, -0.038, -1.750> <-0.202, -0.038, -1.750> <-0.175, -0.038, -1.313> <-0.250, -0.038, -1.125> 
		<0.000, 0.000, -1.750> <-0.202, 0.000, -1.750> <-0.175, 0.000, -1.313> <-0.250, 0.000, -1.125> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -0.750, 0.000> <0.270, -0.750, 0.000> <0.350, -0.225, 0.000> <0.500, 0.000, 0.000> 
		<0.000, -0.750, -0.340> <0.270, -0.750, -0.340> <0.349, -0.224, -0.339> <0.499, 0.001, -0.339> 
		<0.000, -0.751, -0.810> <0.219, -0.749, -0.809> <0.297, -0.185, -0.786> <0.408, 0.004, -0.785> 
		<0.000, -0.625, -1.125> <0.219, -0.623, -1.124> <0.258, -0.183, -1.123> <0.368, 0.006, -1.122> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -0.750, 0.000> <0.000, -0.750, -0.340> <0.000, -0.751, -0.810> <0.000, -0.625, -1.125> 
		<-0.270, -0.750, 0.000> <-0.270, -0.750, -0.340> <-0.219, -0.753, -0.811> <-0.219, -0.627, -1.126> 
		<-0.350, -0.225, 0.000> <-0.350, -0.226, -0.340> <-0.350, -0.188, -0.797> <-0.262, -0.188, -1.125> 
		<-0.500, 0.000, 0.000> <-0.500, -0.001, -0.340> <-0.462, 0.000, -0.797> <-0.375, 0.000, -1.125> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -0.750, 0.000> <0.000, -0.750, 0.377> <0.000, -0.765, 0.900> <0.000, -0.625, 1.250> 
		<0.270, -0.750, 0.000> <0.270, -0.750, 0.377> <0.219, -0.768, 0.901> <0.219, -0.628, 1.251> 
		<0.350, -0.225, 0.000> <0.351, -0.226, 0.377> <0.360, -0.188, 0.886> <0.262, -0.188, 1.250> 
		<0.500, 0.000, 0.000> <0.501, -0.001, 0.377> <0.472, 0.000, 0.886> <0.375, 0.000, 1.250> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, -0.750, 0.000> <-0.270, -0.750, 0.000> <-0.350, -0.225, 0.000> <-0.500, 0.000, 0.000> 
		<0.000, -0.750, 0.377> <-0.270, -0.750, 0.377> <-0.350, -0.224, 0.376> <-0.500, 0.001, 0.376> 
		<0.000, -0.765, 0.900> <-0.221, -0.762, 0.899> <-0.361, -0.181, 0.885> <-0.474, 0.009, 0.884> 
		<0.000, -0.625, 1.250> <-0.221, -0.622, 1.249> <-0.264, -0.181, 1.249> <-0.377, 0.009, 1.248> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.500, 0.000, 0.000> <-0.500, -0.001, -0.340> <-0.462, 0.000, -0.797> <-0.375, 0.000, -1.125> 
		<-0.463, 0.000, 0.000> <-0.462, -0.001, -0.340> <-0.425, 0.000, -0.797> <-0.338, 0.000, -1.125> 
		<-0.412, 0.000, 0.000> <-0.412, 0.000, -0.340> <-0.359, 0.000, -0.793> <-0.287, 0.000, -1.125> 
		<-0.375, 0.000, 0.000> <-0.375, 0.000, -0.340> <-0.321, 0.000, -0.793> <-0.250, 0.000, -1.125> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.500, 0.000, 0.000> <-0.463, 0.000, 0.000> <-0.412, 0.000, 0.000> <-0.375, 0.000, 0.000> 
		<-0.500, 0.001, 0.376> <-0.463, 0.001, 0.376> <-0.412, 0.000, 0.377> <-0.375, 0.000, 0.377> 
		<-0.474, 0.009, 0.884> <-0.436, 0.006, 0.885> <-0.355, 0.028, 0.881> <-0.329, 0.000, 0.881> 
		<-0.377, 0.009, 1.248> <-0.339, 0.006, 1.249> <-0.276, 0.028, 1.250> <-0.250, 0.000, 1.250> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.375, 0.000, 0.000> <-0.375, 0.000, -0.340> <-0.321, 0.000, -0.793> <-0.250, 0.000, -1.125> 
		<-0.375, -0.038, 0.000> <-0.375, -0.038, -0.340> <-0.321, -0.038, -0.793> <-0.250, -0.038, -1.125> 
		<-0.375, -0.087, 0.000> <-0.375, -0.087, -0.340> <-0.287, -0.087, -0.788> <-0.250, -0.087, -1.125> 
		<-0.375, -0.125, 0.000> <-0.375, -0.125, -0.340> <-0.287, -0.125, -0.788> <-0.250, -0.125, -1.125> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.375, 0.000, 0.000> <-0.375, -0.038, 0.000> <-0.375, -0.087, 0.000> <-0.375, -0.125, 0.000> 
		<-0.375, 0.000, 0.377> <-0.375, -0.038, 0.377> <-0.375, -0.087, 0.377> <-0.375, -0.125, 0.377> 
		<-0.329, 0.000, 0.881> <-0.303, -0.027, 0.882> <-0.365, -0.116, 0.881> <-0.329, -0.125, 0.881> 
		<-0.250, 0.000, 1.250> <-0.224, -0.027, 1.250> <-0.286, -0.116, 1.250> <-0.250, -0.125, 1.250> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.250, 0.000, 1.250> <-0.215, 0.000, 1.414> <-0.168, 0.000, 1.750> <0.000, 0.000, 1.750> 
		<-0.276, 0.028, 1.250> <-0.241, 0.028, 1.414> <-0.168, 0.027, 1.777> <0.000, 0.027, 1.777> 
		<-0.339, 0.006, 1.249> <-0.283, 0.006, 1.461> <-0.220, 0.003, 1.837> <0.000, 0.000, 1.837> 
		<-0.377, 0.009, 1.248> <-0.321, 0.009, 1.460> <-0.220, 0.003, 1.874> <0.000, 0.000, 1.875> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.000, 1.875> <0.000, 0.000, 1.875> <0.000, 0.000, 1.875> <0.000, 0.000, 1.875> 
		<-0.220, 0.003, 1.874> <-0.220, -0.185, 1.687> <-0.220, -0.185, 1.687> <0.000, -0.188, 1.688> 
		<-0.321, 0.009, 1.460> <-0.208, -0.181, 1.461> <-0.221, -0.524, 1.496> <0.000, -0.527, 1.496> 
		<-0.377, 0.009, 1.248> <-0.264, -0.181, 1.249> <-0.221, -0.622, 1.249> <0.000, -0.625, 1.250> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.000, 1.875> <0.219, -0.003, 1.876> <0.319, 0.000, 1.461> <0.375, 0.000, 1.250> 
		<-0.220, 0.003, 1.874> <-0.001, 0.000, 1.875> <0.206, -0.188, 1.461> <0.262, -0.188, 1.250> 
		<-0.321, 0.009, 1.460> <-0.208, -0.181, 1.461> <-0.003, -0.625, 1.250> <0.219, -0.628, 1.251> 
		<-0.377, 0.009, 1.248> <-0.264, -0.181, 1.249> <-0.221, -0.622, 1.249> <0.000, -0.625, 1.250> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.000, 1.875> <0.000, 0.000, 1.837> <0.000, 0.027, 1.777> <0.000, 0.000, 1.750> 
		<0.219, -0.003, 1.876> <0.219, -0.003, 1.838> <0.168, 0.027, 1.777> <0.168, 0.000, 1.750> 
		<0.319, 0.000, 1.461> <0.281, 0.000, 1.461> <0.241, 0.027, 1.414> <0.215, 0.000, 1.414> 
		<0.375, 0.000, 1.250> <0.338, 0.000, 1.250> <0.277, 0.027, 1.250> <0.250, 0.000, 1.250> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.000, 1.875> <0.000, 0.000, 1.875> <0.000, 0.000, 1.875> <0.000, 0.000, 1.875> 
		<0.000, -0.188, 1.688> <0.219, -0.190, 1.688> <0.219, -0.190, 1.688> <0.219, -0.003, 1.876> 
		<0.000, -0.527, 1.496> <0.219, -0.529, 1.497> <0.206, -0.188, 1.461> <0.319, 0.000, 1.461> 
		<0.000, -0.625, 1.250> <0.219, -0.628, 1.251> <0.262, -0.188, 1.250> <0.375, 0.000, 1.250> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.250, 0.000, -1.125> <-0.208, 0.000, -1.322> <-0.202, 0.000, -1.750> <0.000, 0.000, -1.750> 
		<-0.287, 0.000, -1.125> <-0.245, 0.000, -1.322> <-0.202, 0.027, -1.777> <0.000, 0.027, -1.777> 
		<-0.338, 0.000, -1.125> <-0.273, 0.000, -1.368> <-0.252, 0.025, -1.903> <0.000, 0.027, -1.902> 
		<-0.375, 0.000, -1.125> <-0.310, 0.000, -1.368> <-0.252, -0.002, -1.876> <0.000, 0.000, -1.875> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.000, -1.875> <0.000, 0.027, -1.902> <0.000, 0.027, -1.777> <0.000, 0.000, -1.750> 
		<0.251, 0.002, -1.874> <0.251, 0.028, -1.900> <0.202, 0.027, -1.777> <0.202, 0.000, -1.750> 
		<0.258, 0.004, -1.348> <0.222, 0.002, -1.349> <0.210, 0.002, -1.312> <0.175, 0.000, -1.313> 
		<0.368, 0.006, -1.122> <0.333, 0.004, -1.123> <0.285, 0.002, -1.124> <0.250, 0.000, -1.125> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.000, -1.875> <0.000, 0.000, -1.875> <0.000, 0.000, -1.875> <0.000, 0.000, -1.875> 
		<0.000, -0.207, -1.668> <0.251, -0.205, -1.667> <0.251, -0.205, -1.667> <0.251, 0.002, -1.874> 
		<0.000, -0.516, -1.397> <0.219, -0.515, -1.396> <0.147, -0.185, -1.349> <0.258, 0.004, -1.348> 
		<0.000, -0.625, -1.125> <0.219, -0.623, -1.124> <0.258, -0.183, -1.123> <0.368, 0.006, -1.122> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.000, -1.875> <0.251, 0.002, -1.874> <0.258, 0.004, -1.348> <0.368, 0.006, -1.122> 
		<-0.252, -0.002, -1.876> <-0.000, -0.000, -1.875> <0.147, -0.185, -1.349> <0.258, -0.183, -1.123> 
		<-0.310, 0.000, -1.368> <-0.198, -0.188, -1.368> <0.000, -0.625, -1.125> <0.219, -0.623, -1.124> 
		<-0.375, 0.000, -1.125> <-0.262, -0.188, -1.125> <-0.219, -0.627, -1.126> <0.000, -0.625, -1.125> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.000, 0.000, -1.875> <0.000, 0.000, -1.875> <0.000, 0.000, -1.875> <0.000, 0.000, -1.875> 
		<0.000, -0.207, -1.668> <-0.252, -0.209, -1.669> <-0.252, -0.209, -1.669> <-0.252, -0.002, -1.876> 
		<0.000, -0.516, -1.397> <-0.219, -0.518, -1.398> <-0.198, -0.188, -1.368> <-0.310, 0.000, -1.368> 
		<0.000, -0.625, -1.125> <-0.219, -0.627, -1.126> <-0.262, -0.188, -1.125> <-0.375, 0.000, -1.125> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.250, 0.000, -1.125> <0.287, 0.000, -0.788> <0.375, 0.000, -0.340> <0.375, 0.000, 0.000> 
		<0.285, 0.002, -1.124> <0.323, 0.002, -0.787> <0.402, 0.027, -0.340> <0.402, 0.027, 0.000> 
		<0.333, 0.004, -1.123> <0.372, 0.002, -0.786> <0.462, 0.001, -0.339> <0.463, 0.000, 0.000> 
		<0.368, 0.006, -1.122> <0.408, 0.004, -0.785> <0.499, 0.001, -0.339> <0.500, 0.000, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.250, 0.000, -1.125> <0.250, -0.038, -1.125> <0.250, -0.087, -1.125> <0.250, -0.125, -1.125> 
		<0.287, 0.000, -0.788> <0.287, -0.038, -0.788> <0.321, -0.087, -0.793> <0.321, -0.125, -0.793> 
		<0.375, 0.000, -0.340> <0.348, -0.027, -0.340> <0.412, -0.119, -0.340> <0.375, -0.125, -0.340> 
		<0.375, 0.000, 0.000> <0.348, -0.027, 0.000> <0.412, -0.119, 0.000> <0.375, -0.125, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.375, 0.000, 0.000> <0.375, 0.000, 0.377> <0.329, 0.000, 0.881> <0.250, 0.000, 1.250> 
		<0.348, -0.027, 0.000> <0.348, -0.027, 0.377> <0.302, -0.027, 0.881> <0.223, -0.027, 1.250> 
		<0.412, -0.119, 0.000> <0.412, -0.119, 0.377> <0.329, -0.087, 0.881> <0.250, -0.087, 1.250> 
		<0.375, -0.125, 0.000> <0.375, -0.125, 0.377> <0.329, -0.125, 0.881> <0.250, -0.125, 1.250> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.375, 0.000, 0.000> <0.375, 0.000, 0.377> <0.329, 0.000, 0.881> <0.250, 0.000, 1.250> 
		<0.402, 0.027, 0.000> <0.402, 0.027, 0.377> <0.355, 0.027, 0.881> <0.277, 0.027, 1.250> 
		<0.463, 0.000, 0.000> <0.464, -0.001, 0.377> <0.435, 0.000, 0.886> <0.338, 0.000, 1.250> 
		<0.500, 0.000, 0.000> <0.501, -0.001, 0.377> <0.472, 0.000, 0.886> <0.375, 0.000, 1.250> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.250, -0.125, 1.250> <-0.329, -0.125, 0.881> <-0.375, -0.125, 0.377> <-0.375, -0.125, 0.000> 
		<-0.104, -0.161, 1.250> <-0.183, -0.161, 0.881> <-0.150, -0.125, 0.377> <-0.150, -0.125, 0.000> 
		<0.100, -0.125, 1.250> <0.179, -0.125, 0.881> <0.153, -0.162, 0.377> <0.153, -0.162, 0.000> 
		<0.250, -0.125, 1.250> <0.329, -0.125, 0.881> <0.375, -0.125, 0.377> <0.375, -0.125, 0.000> 
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.375, -0.125, 0.000> <0.153, -0.162, 0.000> <-0.150, -0.125, 0.000> <-0.375, -0.125, 0.000> 
		<0.375, -0.125, -0.340> <0.153, -0.162, -0.340> <-0.150, -0.125, -0.340> <-0.375, -0.125, -0.340> 
		<0.321, -0.125, -0.793> <0.171, -0.125, -0.793> <-0.137, -0.125, -0.788> <-0.287, -0.125, -0.788> 
		<0.250, -0.125, -1.125> <0.100, -0.125, -1.125> <-0.100, -0.125, -1.125> <-0.250, -0.125, -1.125> 
	}   
}

// End of Hull

//Hull texture
#declare Planks = texture {
    brick texture {pigment {color Black}}, texture { DMFWood2 }
    brick_size <.07,.07,10>
    mortar .005
  }  


// Place Hull
object {
  Boat
  texture {Planks}
  scale 30
  rotate y*90
  translate y*15
}

//Mast
cylinder {
  <0,10,0>
  <0,75,0>,1
  texture { DMFDarkOak rotate x*90}
}

//Cabin
difference { // Outer Shell
  union { 
    box { <-15,10,-7.5>, <-35,21,7.5> }
    cylinder { <-35,35,0>,<-15,35,0>,7.5 scale y*.6 }
    union { // Door
      box { <-.15,0,0>,<.15,20,4> } 
      union { // Door Knob
        sphere { <.3,15,3.6>,.25 }
        sphere { <-.3,15,3.6>,.25 }
        box {<-.13,14.8,4.01>,<.13,15.2,3> }
        texture { Polished_Brass }
      }
    rotate y*140
    translate <-15,0,-2>  
    }
  }  
  union { 
    box { <-15.2,0,-7.3>,<-34.8,21.8,7.3> } // Door Way
    box { <-14.9,0,2>,<-15.2,20,-2>}
    cylinder { <-14.8,18.5,4.5>,<-15.3,18.5,4.5>,1.25}  // Windows
    cylinder { <-14.8,18.5,-4.5>,<-15.3,18.5,-4.5>,1.25}
  }
  texture {
    brick texture {pigment {color Black}}, texture {pigment {color DarkBrown }finish {ambient .35} }
    brick_size <1,1,8>
    mortar .1
    translate y*.1
    rotate x*90
  }  
}
   
// Other Objects On the Boat

light_source {  //Lantern
  <-30,17,2>
  color Yellow*2.5
}

//Table
union {
  box { // Table Top
    <-15.2,15,7.5>
    <-20.2,15.5,2>
    texture { DMFDarkOak }
  }
  box {  // visible Leg 1
    <-19.5,10,2.5>
    <-20,15.5,2>
    texture { DMFDarkOak rotate x*90}
  }
  box { // Visible Leg 2
    <-19.5,10,7.5>
    <-20,15.5,7>
    texture { DMFDarkOak rotate x*90}
  }
}

// Chair
union {
  box { 
    <-19.2,13.5,6.25>
    <-23.2,14,3.25>
  }
  cylinder {
    <-23.2,10,3.45>
    <-23.2,17.5,3.45>,.2
  }
  cylinder {
    <-23.2,10,6.45>
    <-23.2,17.5,6.45>,.2
  }
  cylinder {
    <-19.2,10,3.45>
    <-19.2,14,3.45>,.2
  }
  cylinder {
    <-19.2,10,6.45>
    <-19.2,14,6.45>,.2
  }
  box { 
    <-23.1,17,6.3>
    <-23.3,16.5,3.3>
  }
  box { 
    <-23.1,16,6.3>
    <-23.3,15.5,3.3>
  }
  texture { DMFWood3 }
}

polygon { //Map
5
<0,.2,0>
<0,2.9,0>
<3,2.9,0>
<3,.2,0>
<0,.2,0>

pigment { 
image_map { 
gif "imap.gif" 
}
scale 3
}
rotate x*90
translate <-19.5,15.53,2.5>
}



//union {
  polygon { //Picture
    5
    <0,0,0>
    <0,3,0>
    <5,3,0>
    <5,0,0>
    <0,0,0>
    pigment { 
      image_map { 
        tga "picture.tga" 
      } 
      scale <5,3,1>
    }
  translate <-32,17.5,7.2>
  }
  //union {
  //  box {<-.2,-0.2,.1>,<.1,3.2,-.1>}
  //  box {<-.2,3.2,.1>,<3.2,2.9,-.1>}
  // box {<3.2,3.2,.1>,<3.2,-0.2,-.1>}
  //  box {<-.2,-0.2,.1>,<3.2,-0.2,-.1>}
  //  texture { DMFWood3 }
  //}
//translate <-26,17.5,5>
//}



//Ropes
#declare coil_point1 = <-8.5, 10, 7>;
#declare coil_point2 = <-8.5, 13.5, 7>;
#declare coil_revolutions = 8;
#declare coil_radius = 3;
#declare coil_radius2= 2;

object {#include "Coil.inc"
  pigment {
    gradient x+y
    scale .25
    color_map {
        [0.25 rgb <0.52,0.37,0.26>]
        [0.25 rgb <0.42,0.26,0.15>]
        [0.75 rgb <0.42,0.26,0.15>]
        [0.75 rgb <0.52,0.37,0.26>]
    }
  }
  //pigment {
    //planar
    //scale .1
    //rotate y*45
    //color_map {
    //    [0.1 rgb <0.52, 0.37, 0.26>]
    //    [0.6 rgb <0.42, 0.26, 0.15>]
    //    [1.0 rgb <0,0,0>]
    //} 
  //}
  rotate y * 360
}


#declare coil_point1 = <0, 15, 6>;
#declare coil_point2 = <0, 75, 6>;
#declare coil_revolutions = 4;
#declare coil_radius = 1;
#declare coil_radius2= 1;

object {#include "Coil.inc"
  pigment {
      gradient x+y
      scale .25
      color_map {
        [0.25 rgb <0.52,0.37,0.26>]
        [0.25 rgb <0.42,0.26,0.15>]
        [0.75 rgb <0.42,0.26,0.15>]
        [0.75 rgb <0.52,0.37,0.26>]
    }
  }
  //texture { DMFWood2 rotate z*50}
  //rotate y * 360
}


light_source {
  <4,19,-13> 
  color White*.35
}


// Stains
box {
  <0,0,0>
  <1,1,1>
  pigment {
    marble
    turbulence 1
    scale .15
    color_map {
      [0 rgb .1 transmit .5]
      [1 rgb .1 transmit 1]
    }
  }
  scale <50,1,10>
  translate <-25,10.15,0>
}