// Fish Scene File
// (POV-Ray ver 3.1g)
// Written by S.Nishimura 


#include "coordinate_color.mcr.inc"

#include "fish.dat.inc"


#include "textures.inc"

global_settings { assumed_gamma 2.2 max_trace_level 5 }


// CAMERA POSITION
camera { right < -4/3, 0, 0 > 
         angle 60 
         location < 0, 0, 100 > 
         look_at  < 0, 0, 0 >
 
         focal_point < 0,-20, 20 > 
         aperture 0.8     
         blur_samples 10
}
// LIGHT
light_source { < -100, 0, 100 > color 1.5 }
light_source { < 0, 40, 250 > color 1 }


//
coordinate_color( 150, 0.84, 0.5, 1, 1 )
background { color rgbf <  R1, G1, B1, 0.95 > }

//
coordinate_color( 180, 0.80, 0.5, 1, 1 )
coordinate_color( 172, 0.81, 0.5, 1, 2 )
coordinate_color( 188, 0.79, 0.5, 1, 4 )
coordinate_color( 196, 0.77, 0.5, 1, 5 )
coordinate_color( 203, 0.75, 0.5, 1, 6 )
coordinate_color( 360, 0.00, 0.1, 1, 7 )
#declare Eye =
 pigment { gradient x
           color_map { [ 0.00 color rgb < R1, G1, B1 > ]
                       [ 0.30 color rgb < R2, G2, B2 > ]
                       [ 0.32 color rgb < R1, G1, B1 > ]
                       [ 0.34 color rgb < R4, G4, B4 > ]
                       [ 0.36 color rgb < R5, G5, B5 > ]
                       [ 0.40 color rgb < R6, G6, B6 > ]
                       [ 1.00 color rgb < R7, G7, B7 > ] } }
#declare R_eye =
 texture { pigment { Eye } scale < 0.8, 40, 40 >*.5 }
#declare L_eye =
 texture { pigment { Eye } scale < 0.8, 40, 40 >* 2 } 
//
coordinate_color( -30, 1, 0.5, 1, 8 )
coordinate_color( 360, 0, 0.9, 1, 9 )
#declare Fish =
 union {
  object { dxfobj0
  texture { 
   pigment { agate
             turbulence 0.5
             pigment_map { [ 0.0 DMFWood4 scale 0.3 ]
                           [ 0.1 Silver2_Colour ]
                           [ 0.7 color rgb < R8, G8, B8 > ]
                           [ 0.9 Pine_Wood scale 0.1 ]
                           [ 1.0 color rgb < R8, G8, B8 > ] } 
             scale 20
             rotate < 0, 0, 90 >
             translate < 0, 40, 0 > } }
 }
 sphere { < 5, 50, -29 >,1.0 // R_eye
  texture { pigment { color rgb < R7, G7, B7 > } }
 }
 sphere { < 5, 50, -29 >,2.0
  texture { R_eye rotate 30*y }
  finish { phong 1 phong_size 100 }
 }
sphere { < 5, 50, -29 >,2.5
  texture { pigment { color rgbf < R9, G9, B9, 0.9 > } }
  finish { phong 1 phong_size 100 }
 } 
sphere { < -6, 50, -29 >,1.0 // L_eye
  texture { pigment { color rgb < R7, G7, B7 > } }
 }
 sphere { < -6, 50, -29 >,2.0
  texture { L_eye rotate -30*y }
  finish { phong 1 phong_size 100 }
 }
sphere { < -6, 50, -29 >,2.5
  texture { pigment { color rgbf < R9, G9, B9, 0.9 > } }
  finish { phong 1 phong_size 100 }
 } 
}

object { Fish translate <  0, -32,  10 >  rotate < 0, 180+45, 0 > }
object { Fish translate <  0, -35, 100 >  rotate < 0, 180+45, 0 > }
object { Fish translate < -5, -75, -13 >  rotate < 0, 180-45, 0 > }
object { Fish translate <  0, -75,  90 >  rotate < 0, 180-45, 0 > }
object { Fish translate < 10, -15, 140 >  rotate < 0, 180-45, 0 > }

//
coordinate_color( 255, 0.90, 0.90, 1, 1 )
coordinate_color( 255, 0.91, 0.78, 1, 3 )
coordinate_color( 255, 0.92, 0.56, 1, 5 )
#declare Sea =
 color_map { [ 0.00 rgbf < 1, 1, 1, 0 > ]
             [ 0.15 rgbf < R1, G1, B1, 0.65 > ]
             [ 0.25 rgbf < R1, G1, B1, 0.65 > ]
             [ 0.30 rgbf < R3, G3, B3, 0.85 > ]
             [ 0.40 rgbf < R3, G3, B3, 0.85 > ]
             [ 0.45 rgbf < R5, G5, B5, 0.95 > ] }
//
plane { z, -1000
 texture {
  pigment { bozo 
            color_map { [ 0.00 rgbf < 1, 1, 1, 0.99 > ]
                        [ 0.15 rgbf < R1, G1, B1, 0.98 > ]
                        [ 0.25 rgbf < R1, G1, B1, 0.96 > ]
                        [ 0.30 rgbf < R3, G3, B3, 0.92 > ]
                        [ 0.40 rgbf < R3, G3, B3, 0.96 > ]
                        [ 0.45 rgbf < R5, G5, B5, 0.98 > ] }
            turbulence 0.6 }
  finish { ambient }
  scale 0.4 }
}
plane { y, 60 hollow
 texture {
  pigment { marble color_map { Sea } turbulence 0.6 }
  finish { ambient } 
  scale 8 
  rotate < 0, 10, 0 > }
}
plane { y, -60
 texture {
  pigment { bozo color_map { Sea } turbulence 0.6 }
  finish { ambient }
  scale 8
  rotate  < 0, 30, 0 > }
}

// natu
prism {
 linear_sweep
 bezier_spline 0,0.5,460
 <-0.063,-0.008><-0.063,-0.008><0.063,-0.008><0.063,-0.008>
 <0.063,-0.008><0.063,-0.008><0.063,0.077><0.063,0.077>
 <0.063,0.077><0.063,0.077><0.063,0.12><0.063,0.12>
 <0.063,0.12><0.063,0.12><0.063,0.753><0.063,0.753>
 <0.063,0.753><-0.005,0.753><-0.075,0.742><-0.148,0.72>
 <-0.148,0.72><-0.22,0.697><-0.277,0.666><-0.318,0.625>
 <-0.318,0.625><-0.318,0.625><-0.318,0.583><-0.318,0.583>
 <-0.318,0.583><-0.307,0.583><-0.278,0.584><-0.23,0.588>
 <-0.23,0.588><-0.182,0.592><-0.144,0.593><-0.116,0.593>
 <-0.116,0.593><-0.073,0.593><-0.04,0.589><-0.016,0.581>
 <-0.016,0.581><0.008,0.573><0.02,0.559><0.02,0.54>
 <0.02,0.54><0.02,0.485><-0.008,0.443><-0.064,0.415>
 <-0.064,0.415><-0.12,0.387><-0.204,0.372><-0.318,0.372>
 <-0.318,0.372><-0.318,0.372><-0.318,0.287><-0.318,0.287>
 <-0.318,0.287><-0.302,0.287><-0.273,0.29><-0.23,0.297>
 <-0.23,0.297><-0.187,0.303><-0.158,0.306><-0.142,0.306>
 <-0.142,0.306><-0.118,0.306><-0.105,0.3><-0.105,0.287>
 <-0.105,0.287><-0.105,0.22><-0.121,0.18><-0.153,0.167>
 <-0.153,0.167><-0.185,0.155><-0.24,0.139><-0.318,0.12>
 <-0.318,0.12><-0.318,0.12><-0.443,0.077><-0.443,0.077>
 <-0.443,0.077><-0.443,0.077><-0.443,0.54><-0.443,0.54>
 <-0.443,0.54><-0.464,0.54><-0.485,0.552><-0.507,0.577>
 <-0.507,0.577><-0.528,0.602><-0.539,0.63><-0.539,0.662>
 <-0.539,0.662><-0.539,0.68><-0.535,0.696><-0.528,0.71>
 <-0.528,0.71><-0.48,0.735><-0.433,0.776><-0.387,0.833>
 <-0.387,0.833><-0.341,0.889><-0.318,0.947><-0.318,1.005>
 <-0.318,1.005><-0.325,1.005><-0.414,0.978><-0.584,0.924>
 <-0.584,0.924><-0.754,0.87><-0.869,0.843><-0.93,0.843>
 <-0.93,0.843><-0.967,0.843><-0.998,0.849><-1.023,0.86>
 <-1.023,0.86><-1.048,0.872><-1.065,0.892><-1.076,0.92>
 <-1.076,0.92><-1.064,0.919><-1.044,0.918><-1.017,0.918>
 <-1.017,0.918><-0.936,0.918><-0.814,0.942><-0.652,0.99>
 <-0.652,0.99><-0.489,1.037><-0.316,1.089><-0.13,1.144>
 <-0.13,1.144><0.055,1.199><0.218,1.237><0.358,1.258>
 <0.358,1.258><0.434,1.246><0.505,1.216><0.57,1.168>
 <0.57,1.168><0.636,1.12><0.669,1.075><0.669,1.032>
 <0.669,1.032><0.669,0.984><0.618,0.96><0.515,0.96>
 <0.515,0.96><0.495,0.962><0.48,0.963><0.47,0.963>
 <0.47,0.963><0.47,0.963><0.443,0.963><0.443,0.963>
 <0.443,0.963><0.303,0.986><0.195,1.002><0.121,1.011>
 <0.121,1.011><0.046,1.02><-0.01,1.024><-0.049,1.024>
 <-0.049,1.024><-0.108,1.024><-0.155,1.018><-0.19,1.005>
 <-0.19,1.005><-0.133,0.986><-0.098,0.967><-0.084,0.948>
 <-0.084,0.948><-0.07,0.93><-0.063,0.906><-0.063,0.878>
 <-0.063,0.878><-0.041,0.874><-0.025,0.872><-0.015,0.872>
 <-0.015,0.872><0.014,0.872><0.05,0.882><0.094,0.902>
 <0.094,0.902><0.139,0.921><0.169,0.931><0.185,0.931>
 <0.185,0.931><0.199,0.931><0.213,0.927><0.227,0.918>
 <0.227,0.918><0.242,0.909><0.258,0.882><0.275,0.838>
 <0.275,0.838><0.29,0.811><0.299,0.782><0.305,0.75>
 <0.305,0.75><0.31,0.718><0.313,0.682><0.313,0.641>
 <0.313,0.641><0.313,0.623><0.306,0.528><0.294,0.354>
 <0.294,0.354><0.282,0.18><0.275,0.045><0.275,-0.05>
 <0.275,-0.05><0.275,-0.1><0.257,-0.162><0.22,-0.235>
 <0.22,-0.235><0.182,-0.309><0.144,-0.346><0.105,-0.346>
 <0.105,-0.346><0.105,-0.346><0.105,-0.391><0.105,-0.391>
 <0.105,-0.391><0.105,-0.446><0.103,-0.486><0.1,-0.511>
 <0.1,-0.511><0.096,-0.536><0.084,-0.579><0.063,-0.641>
 <0.063,-0.641><0.125,-0.689><0.194,-0.739><0.27,-0.79>
 <0.27,-0.79><0.346,-0.841><0.442,-0.883><0.557,-0.914>
 <0.557,-0.914><0.672,-0.945><0.775,-0.974><0.865,-1.001>
 <0.865,-1.001><0.954,-1.029><1.025,-1.077><1.076,-1.146>
 <1.076,-1.146><1.064,-1.185><1.038,-1.214><1,-1.232>
 <1,-1.232><0.962,-1.249><0.913,-1.258><0.853,-1.258>
 <0.853,-1.258><0.798,-1.258><0.749,-1.255><0.708,-1.248>
 <0.708,-1.248><0.666,-1.241><0.605,-1.232><0.525,-1.221>
 <0.525,-1.221><0.446,-1.21><0.356,-1.16><0.255,-1.069>
 <0.255,-1.069><0.155,-0.979><0.063,-0.893><-0.02,-0.811>
 <-0.02,-0.811><-0.082,-0.888><-0.164,-0.956><-0.265,-1.018>
 <-0.265,-1.018><-0.366,-1.079><-0.451,-1.109><-0.52,-1.109>
 <-0.52,-1.109><-0.582,-1.109><-0.613,-1.08><-0.613,-1.021>
 <-0.613,-1.021><-0.517,-1.002><-0.429,-0.96><-0.347,-0.895>
 <-0.347,-0.895><-0.266,-0.83><-0.199,-0.76><-0.148,-0.684>
 <-0.148,-0.684><-0.188,-0.643><-0.232,-0.604><-0.278,-0.568>
 <-0.278,-0.568><-0.324,-0.531><-0.365,-0.513><-0.4,-0.513>
 <-0.4,-0.513><-0.439,-0.552><-0.481,-0.608><-0.525,-0.681>
 <-0.525,-0.681><-0.57,-0.754><-0.599,-0.797><-0.613,-0.811>
 <-0.613,-0.811><-0.652,-0.865><-0.685,-0.907><-0.71,-0.939>
 <-0.71,-0.939><-0.736,-0.971><-0.777,-0.987><-0.834,-0.987>
 <-0.834,-0.987><-0.853,-0.987><-0.878,-0.984><-0.908,-0.979>
 <-0.908,-0.979><-0.914,-0.954><-0.916,-0.933><-0.916,-0.915>
 <-0.916,-0.915><-0.916,-0.871><-0.908,-0.836><-0.893,-0.81>
 <-0.893,-0.81><-0.877,-0.784><-0.833,-0.736><-0.761,-0.664>
 <-0.761,-0.664><-0.689,-0.592><-0.623,-0.513><-0.563,-0.428>
 <-0.563,-0.428><-0.502,-0.343><-0.462,-0.287><-0.443,-0.261>
 <-0.443,-0.261><-0.459,-0.264><-0.528,-0.298><-0.652,-0.36>
 <-0.652,-0.36><-0.775,-0.423><-0.875,-0.461><-0.951,-0.474>
 <-0.951,-0.474><-1.008,-0.434><-1.036,-0.394><-1.036,-0.351>
 <-1.036,-0.351><-1.036,-0.324><-1.022,-0.303><-0.994,-0.286>
 <-0.994,-0.286><-0.965,-0.269><-0.923,-0.261><-0.866,-0.261>
 <-0.866,-0.261><-0.772,-0.238><-0.696,-0.206><-0.637,-0.165>
 <-0.637,-0.165><-0.578,-0.119><-0.528,-0.081><-0.485,-0.05>
 <-0.485,-0.05><-0.498,-0.038><-0.504,-0.025><-0.504,-0.011>
 <-0.504,-0.011><-0.504,0.002><-0.499,0.014><-0.49,0.027>
 <-0.49,0.027><-0.48,0.039><-0.464,0.056><-0.443,0.077>
 <-0.443,0.077><-0.443,0.077><-0.318,0.12><-0.318,0.12>
 <-0.318,0.12><-0.318,0.12><-0.318,0.035><-0.318,0.035>
 <-0.318,0.035><-0.263,0.052><-0.215,0.077><-0.173,0.109>
 <-0.173,0.109><-0.131,0.141><-0.095,0.172><-0.063,0.202>
 <-0.063,0.202><-0.05,0.191><-0.033,0.179><-0.012,0.164>
 <-0.012,0.164><0.009,0.149><0.034,0.134><0.063,0.12>
 <0.063,0.12><0.063,0.12><0.063,0.077><0.063,0.077>
 <0.063,0.077><0.063,0.077><-0.063,-0.008><-0.063,-0.008>
 <-0.063,-0.008><-0.063,-0.008><-0.105,-0.05><-0.105,-0.05>
 <-0.105,-0.05><-0.105,-0.05><-0.358,-0.431><-0.358,-0.431>
 <-0.358,-0.431><-0.336,-0.431><-0.295,-0.446><-0.233,-0.476>
 <-0.233,-0.476><-0.171,-0.506><-0.128,-0.533><-0.105,-0.556>
 <-0.105,-0.556><-0.105,-0.556><-0.105,-0.388><-0.105,-0.388>
 <-0.105,-0.388><-0.105,-0.388><-0.137,-0.388><-0.137,-0.388>
 <-0.137,-0.388><-0.176,-0.388><-0.204,-0.386><-0.221,-0.382>
 <-0.221,-0.382><-0.238,-0.377><-0.256,-0.365><-0.275,-0.346>
 <-0.275,-0.346><-0.19,-0.261><-0.105,-0.218><-0.02,-0.218>
 <-0.02,-0.218><-0.02,-0.197><-0.029,-0.168><-0.048,-0.133>
 <-0.048,-0.133><-0.066,-0.098><-0.086,-0.07><-0.105,-0.05>
 <-0.105,-0.05><-0.105,-0.05><-0.063,-0.008><-0.063,-0.008>
texture { pigment { marble color_map { Sea } turbulence 0.6 } scale 8 }
rotate -40*x
scale 10
translate < -350, -60-30, -600 >
}

// umi
union{
prism {
 linear_sweep
 bezier_spline 0,0.5,88
 <0.031,1.17><0.125,1.155><0.199,1.125><0.251,1.08>
 <0.251,1.08><0.304,1.034><0.33,0.979><0.33,0.913>
 <0.33,0.913><0.33,0.845><0.301,0.775><0.242,0.702>
 <0.242,0.702><0.256,0.696><0.268,0.693><0.277,0.693>
 <0.277,0.693><0.279,0.693><0.311,0.709><0.376,0.74>
 <0.376,0.74><0.44,0.771><0.494,0.787><0.539,0.787>
 <0.539,0.787><0.571,0.787><0.598,0.779><0.62,0.763>
 <0.62,0.763><0.643,0.747><0.654,0.729><0.654,0.709>
 <0.654,0.709><0.654,0.665><0.615,0.634><0.539,0.616>
 <0.539,0.616><0.492,0.593><0.433,0.544><0.362,0.469>
 <0.362,0.469><0.291,0.394><0.244,0.357><0.223,0.357>
 <0.223,0.357><0.218,0.357><0.21,0.359><0.199,0.362>
 <0.199,0.362><0.199,0.38><0.204,0.4><0.213,0.424>
 <0.213,0.424><0.222,0.447><0.231,0.469><0.242,0.491>
 <0.242,0.491><0.229,0.485><0.204,0.474><0.167,0.457>
 <0.167,0.457><0.13,0.44><0.092,0.425><0.055,0.413>
 <0.055,0.413><0.017,0.4><-0.012,0.394><-0.033,0.394>
 <-0.033,0.394><-0.069,0.394><-0.098,0.405><-0.119,0.426>
 <-0.119,0.426><-0.14,0.448><-0.151,0.476><-0.151,0.512>
 <-0.151,0.512><-0.151,0.533><-0.147,0.554><-0.14,0.573>
 <-0.14,0.573><-0.107,0.634><-0.073,0.695><-0.039,0.758>
 <-0.039,0.758><0.007,0.87><0.031,1.007><0.031,1.17>
}
prism {
 linear_sweep
 bezier_spline 0,0.5,304
 <0.157,-0.02><0.176,-0.034><0.195,-0.053><0.214,-0.078>
 <0.214,-0.078><0.233,-0.102><0.242,-0.14><0.242,-0.194>
 <0.242,-0.194><0.242,-0.194><0.231,-0.333><0.231,-0.333>
 <0.231,-0.333><0.231,-0.351><0.213,-0.385><0.178,-0.435>
 <0.178,-0.435><0.142,-0.484><0.106,-0.533><0.068,-0.579>
 <0.068,-0.579><0.068,-0.579><-0.001,-0.753><-0.001,-0.753>
 <-0.001,-0.753><-0.078,-0.744><-0.15,-0.739><-0.218,-0.739>
 <-0.218,-0.739><-0.218,-0.739><-0.261,-0.739><-0.261,-0.739>
 <-0.261,-0.739><-0.307,-0.739><-0.341,-0.737><-0.362,-0.733>
 <-0.362,-0.733><-0.384,-0.728><-0.394,-0.703><-0.394,-0.656>
 <-0.394,-0.656><-0.394,-0.637><-0.388,-0.608><-0.376,-0.568>
 <-0.376,-0.568><-0.363,-0.529><-0.349,-0.491><-0.333,-0.453>
 <-0.333,-0.453><-0.333,-0.453><-0.239,-0.496><-0.239,-0.496>
 <-0.239,-0.496><-0.257,-0.528><-0.266,-0.553><-0.266,-0.571>
 <-0.266,-0.571><-0.266,-0.571><-0.055,-0.571><-0.055,-0.571>
 <-0.055,-0.571><-0.055,-0.571><0.031,-0.36><0.031,-0.36>
 <0.031,-0.36><0.031,-0.36><-0.186,-0.405><-0.186,-0.405>
 <-0.186,-0.405><-0.204,-0.434><-0.221,-0.464><-0.239,-0.496>
 <-0.239,-0.496><-0.239,-0.496><-0.333,-0.453><-0.333,-0.453>
 <-0.333,-0.453><-0.345,-0.457><-0.387,-0.472><-0.457,-0.5>
 <-0.457,-0.5><-0.527,-0.528><-0.577,-0.541><-0.605,-0.541>
 <-0.605,-0.541><-0.65,-0.541><-0.679,-0.523><-0.691,-0.485>
 <-0.691,-0.485><-0.552,-0.439><-0.455,-0.405><-0.401,-0.384>
 <-0.401,-0.384><-0.347,-0.362><-0.302,-0.34><-0.266,-0.317>
 <-0.266,-0.317><-0.221,-0.215><-0.169,-0.11><-0.11,0>
 <-0.11,0><-0.05,0.109><0.025,0.216><0.114,0.319>
 <0.114,0.319><0.114,0.319><0.114,0.194><0.114,0.194>
 <0.114,0.194><0.176,0.24><0.243,0.287><0.314,0.334>
 <0.314,0.334><0.385,0.381><0.446,0.405><0.496,0.405>
 <0.496,0.405><0.555,0.405><0.602,0.385><0.639,0.346>
 <0.639,0.346><0.675,0.307><0.694,0.236><0.694,0.135>
 <0.694,0.135><0.694,0.062><0.684,-0.02><0.664,-0.111>
 <0.664,-0.111><0.716,-0.111><0.772,-0.115><0.831,-0.122>
 <0.831,-0.122><0.891,-0.129><0.945,-0.148><0.993,-0.179>
 <0.993,-0.179><1.041,-0.211><1.075,-0.239><1.093,-0.265>
 <1.093,-0.265><1.112,-0.291><1.121,-0.314><1.121,-0.336>
 <1.121,-0.336><1.121,-0.357><1.113,-0.375><1.097,-0.389>
 <1.097,-0.389><1.081,-0.403><1.062,-0.41><1.039,-0.41>
 <1.039,-0.41><1.028,-0.41><1.017,-0.408><1.006,-0.403>
 <1.006,-0.403><0.98,-0.403><0.931,-0.392><0.861,-0.372>
 <0.861,-0.372><0.79,-0.351><0.705,-0.333><0.606,-0.317>
 <0.606,-0.317><0.606,-0.317><0.509,-0.665><0.509,-0.665>
 <0.509,-0.665><0.572,-0.691><0.626,-0.716><0.671,-0.738>
 <0.671,-0.738><0.716,-0.76><0.757,-0.789><0.793,-0.825>
 <0.793,-0.825><0.826,-0.85><0.851,-0.877><0.866,-0.905>
 <0.866,-0.905><0.881,-0.934><0.889,-0.964><0.889,-0.996>
 <0.889,-0.996><0.889,-1.028><0.881,-1.053><0.866,-1.072>
 <0.866,-1.072><0.851,-1.091><0.831,-1.1><0.806,-1.1>
 <0.806,-1.1><0.788,-1.1><0.77,-1.094><0.753,-1.082>
 <0.753,-1.082><0.71,-1.039><0.663,-0.997><0.612,-0.956>
 <0.612,-0.956><0.561,-0.915><0.508,-0.886><0.453,-0.868>
 <0.453,-0.868><0.425,-0.928><0.397,-0.988><0.37,-1.047>
 <0.37,-1.047><0.324,-1.129><0.278,-1.17><0.231,-1.17>
 <0.231,-1.17><0.224,-1.17><0.214,-1.168><0.199,-1.164>
 <0.199,-1.164><0.162,-1.109><0.125,-1.061><0.09,-1.02>
 <0.09,-1.02><0.054,-0.979><0.02,-0.943><-0.012,-0.91>
 <-0.012,-0.91><-0.012,-0.91><0.199,-0.91><0.199,-0.91>
 <0.199,-0.91><0.199,-0.91><0.25,-0.809><0.25,-0.809>
 <0.25,-0.809><0.159,-0.78><0.075,-0.762><-0.001,-0.753>
 <-0.001,-0.753><-0.001,-0.753><0.068,-0.579><0.068,-0.579>
 <0.068,-0.579><0.068,-0.579><0.301,-0.619><0.301,-0.619>
 <0.301,-0.619><0.301,-0.619><0.381,-0.317><0.381,-0.317>
 <0.381,-0.317><0.381,-0.317><0.231,-0.333><0.231,-0.333>
 <0.231,-0.333><0.231,-0.333><0.242,-0.194><0.242,-0.194>
 <0.242,-0.194><0.242,-0.194><0.413,-0.146><0.413,-0.146>
 <0.413,-0.146><0.413,-0.146><0.453,0.108><0.453,0.108>
 <0.453,0.108><0.453,0.108><0.157,-0.02><0.157,-0.02>
 <0.157,-0.02><0.157,-0.02><0.075,-0.111><0.075,-0.111>
 <0.075,-0.111><0.069,-0.099><0.056,-0.092><0.036,-0.092>
 <0.036,-0.092><-0.001,-0.087><-0.035,-0.106><-0.064,-0.15>
 <-0.064,-0.15><-0.093,-0.194><-0.12,-0.239><-0.143,-0.285>
 <-0.143,-0.285><-0.143,-0.285><0.074,-0.231><0.074,-0.231>
 <0.074,-0.231><0.077,-0.219><0.08,-0.205><0.082,-0.19>
 <0.082,-0.19><0.083,-0.175><0.084,-0.165><0.084,-0.162>
 <0.084,-0.162><0.084,-0.14><0.081,-0.123><0.075,-0.111>
 <0.075,-0.111><0.075,-0.111><0.157,-0.02><0.157,-0.02>
}
prism {
 linear_sweep
 bezier_spline 0,0.5,52
 <-0.862,0.573><-0.828,0.586><-0.804,0.601><-0.789,0.619>
 <-0.789,0.619><-0.773,0.637><-0.766,0.655><-0.766,0.675>
 <-0.766,0.675><-0.766,0.689><-0.776,0.721><-0.795,0.771>
 <-0.795,0.771><-0.815,0.821><-0.825,0.858><-0.825,0.881>
 <-0.825,0.881><-0.825,0.888><-0.823,0.898><-0.819,0.913>
 <-0.819,0.913><-0.805,0.916><-0.793,0.918><-0.782,0.918>
 <-0.782,0.918><-0.716,0.918><-0.642,0.882><-0.56,0.811>
 <-0.56,0.811><-0.478,0.74><-0.437,0.675><-0.437,0.616>
 <-0.437,0.616><-0.464,0.582><-0.489,0.558><-0.513,0.543>
 <-0.513,0.543><-0.537,0.527><-0.559,0.52><-0.579,0.52>
 <-0.579,0.52><-0.596,0.52><-0.629,0.53><-0.678,0.549>
 <-0.678,0.549><-0.726,0.569><-0.769,0.579><-0.809,0.579>
 <-0.809,0.579><-0.819,0.579><-0.837,0.577><-0.862,0.573>
}
prism {
 linear_sweep
 bezier_spline 0,0.5,84
 <-0.988,0.319><-0.947,0.298><-0.908,0.262><-0.873,0.21>
 <-0.873,0.21><-0.837,0.158><-0.819,0.11><-0.819,0.065>
 <-0.819,0.065><-0.819,0.015><-0.85,-0.052><-0.913,-0.138>
 <-0.913,-0.138><-0.975,-0.223><-1.006,-0.337><-1.006,-0.48>
 <-1.006,-0.48><-1.006,-0.546><-1,-0.619><-0.988,-0.699>
 <-0.988,-0.699><-0.92,-0.583><-0.865,-0.48><-0.823,-0.39>
 <-0.823,-0.39><-0.781,-0.3><-0.752,-0.233><-0.734,-0.189>
 <-0.734,-0.189><-0.728,-0.219><-0.726,-0.255><-0.726,-0.298>
 <-0.726,-0.298><-0.726,-0.455><-0.752,-0.625><-0.806,-0.808>
 <-0.806,-0.808><-0.859,-0.99><-0.92,-1.082><-0.988,-1.082>
 <-0.988,-1.082><-1.041,-1.082><-1.077,-1.063><-1.095,-1.027>
 <-1.095,-1.027><-1.112,-0.99><-1.121,-0.941><-1.121,-0.878>
 <-1.121,-0.878><-1.121,-0.861><-1.12,-0.836><-1.119,-0.805>
 <-1.119,-0.805><-1.117,-0.774><-1.116,-0.753><-1.116,-0.742>
 <-1.116,-0.742><-1.116,-0.69><-1.104,-0.6><-1.08,-0.471>
 <-1.08,-0.471><-1.056,-0.341><-1.025,-0.22><-0.988,-0.106>
 <-0.988,-0.106><-0.979,-0.088><-0.973,-0.07><-0.969,-0.052>
 <-0.969,-0.052><-0.965,-0.034><-0.964,-0.017><-0.964,-0.002>
 <-0.964,-0.002><-0.964,0.029><-0.972,0.071><-0.988,0.124>
 <-0.988,0.124><-1.004,0.178><-1.012,0.216><-1.012,0.239>
 <-1.012,0.239><-1.012,0.269><-1.004,0.296><-0.988,0.319>
}
texture { pigment { marble color_map { Sea } turbulence 0.6 } scale 8 }
rotate -40*x
scale 10
translate < -325, -60-30, -600 >
}

// nami
union {
prism {
 linear_sweep
 bezier_spline 0,0.5,216
 <0.004,0.694><0.016,0.742><0.023,0.785><0.023,0.824>
 <0.023,0.824><0.023,0.865><0.018,0.898><0.009,0.925>
 <0.009,0.925><0.001,0.951><-0.015,0.987><-0.038,1.03>
 <-0.038,1.03><0.057,1.015><0.128,0.988><0.174,0.95>
 <0.174,0.95><0.219,0.912><0.242,0.852><0.242,0.771>
 <0.242,0.771><0.242,0.688><0.215,0.575><0.16,0.433>
 <0.16,0.433><0.375,0.519><0.513,0.562><0.573,0.562>
 <0.573,0.562><0.608,0.562><0.636,0.553><0.657,0.536>
 <0.657,0.536><0.677,0.518><0.698,0.487><0.719,0.443>
 <0.719,0.443><0.653,0.311><0.6,0.221><0.559,0.173>
 <0.559,0.173><0.517,0.126><0.434,0.102><0.308,0.102>
 <0.308,0.102><0.308,0.102><0.213,0.107><0.213,0.107>
 <0.213,0.107><0.273,0.126><0.325,0.166><0.368,0.225>
 <0.368,0.225><0.411,0.284><0.443,0.357><0.465,0.443>
 <0.465,0.443><0.405,0.424><0.349,0.4><0.296,0.373>
 <0.296,0.373><0.244,0.345><0.18,0.309><0.102,0.263>
 <0.102,0.263><0.084,0.224><0.068,0.174><0.052,0.112>
 <0.052,0.112><0.052,0.075><0.084,0.057><0.15,0.057>
 <0.15,0.057><0.215,0.057><0.248,0.001><0.248,-0.11>
 <0.248,-0.11><0.248,-0.14><0.245,-0.178><0.24,-0.223>
 <0.24,-0.223><0.234,-0.268><0.226,-0.323><0.213,-0.388>
 <0.213,-0.388><0.254,-0.425><0.328,-0.473><0.437,-0.531>
 <0.437,-0.531><0.545,-0.589><0.662,-0.651><0.786,-0.718>
 <0.786,-0.718><0.911,-0.784><1.013,-0.845><1.094,-0.901>
 <1.094,-0.901><1.094,-0.946><1.074,-0.971><1.032,-0.977>
 <1.032,-0.977><0.991,-0.983><0.942,-0.986><0.885,-0.986>
 <0.885,-0.986><0.75,-0.986><0.641,-0.953><0.559,-0.887>
 <0.559,-0.887><0.477,-0.821><0.337,-0.699><0.139,-0.52>
 <0.139,-0.52><0.12,-0.577><0.07,-0.639><-0.011,-0.706>
 <-0.011,-0.706><-0.091,-0.773><-0.171,-0.806><-0.25,-0.806>
 <-0.25,-0.806><-0.314,-0.806><-0.369,-0.782><-0.417,-0.735>
 <-0.417,-0.735><-0.316,-0.71><-0.226,-0.674><-0.147,-0.628>
 <-0.147,-0.628><-0.068,-0.581><-0.007,-0.513><0.036,-0.425>
 <0.036,-0.425><-0.029,-0.37><-0.096,-0.312><-0.163,-0.252>
 <-0.163,-0.252><-0.23,-0.191><-0.272,-0.142><-0.29,-0.105>
 <-0.29,-0.105><-0.341,-0.322><-0.391,-0.509><-0.439,-0.666>
 <-0.439,-0.666><-0.488,-0.823><-0.564,-0.901><-0.668,-0.901>
 <-0.668,-0.901><-0.617,-0.85><-0.559,-0.715><-0.495,-0.494>
 <-0.495,-0.494><-0.43,-0.273><-0.398,-0.093><-0.398,0.049>
 <-0.398,0.049><-0.398,0.11><-0.404,0.157><-0.417,0.189>
 <-0.417,0.189><-0.385,0.173><-0.353,0.157><-0.321,0.141>
 <-0.321,0.141><-0.293,0.12><-0.279,0.084><-0.279,0.033>
 <-0.279,0.033><-0.279,0.003><-0.283,-0.029><-0.29,-0.062>
 <-0.29,-0.062><-0.239,-0.08><-0.179,-0.111><-0.111,-0.155>
 <-0.111,-0.155><-0.043,-0.199><0.021,-0.243><0.081,-0.288>
 <0.081,-0.288><0.081,-0.288><0.086,-0.147><0.086,-0.147>
 <0.086,-0.147><0.086,-0.107><0.058,-0.08><0.003,-0.068>
 <0.003,-0.068><-0.053,-0.056><-0.081,-0.01><-0.081,0.07>
 <-0.081,0.07><-0.081,0.103><-0.075,0.148><-0.065,0.205>
 <-0.065,0.205><-0.065,0.205><-0.213,0.162><-0.213,0.162>
 <-0.213,0.162><-0.202,0.199><-0.178,0.233><-0.14,0.262>
 <-0.14,0.262><-0.102,0.291><-0.066,0.318><-0.033,0.342>
 <-0.033,0.342><-0.024,0.395><-0.017,0.453><-0.012,0.516>
 <-0.012,0.516><-0.007,0.578><-0.001,0.638><0.004,0.694>
}
prism {
 linear_sweep
 bezier_spline 0,0.5,36
 <-0.88,0.652><-0.866,0.656><-0.852,0.658><-0.839,0.66>
 <-0.839,0.66><-0.826,0.662><-0.814,0.663><-0.803,0.663>
 <-0.803,0.663><-0.743,0.663><-0.692,0.643><-0.65,0.605>
 <-0.65,0.605><-0.607,0.566><-0.586,0.526><-0.586,0.485>
 <-0.586,0.485><-0.586,0.45><-0.607,0.433><-0.65,0.433>
 <-0.65,0.433><-0.669,0.433><-0.69,0.436><-0.711,0.443>
 <-0.711,0.443><-0.704,0.45><-0.7,0.459><-0.7,0.47>
 <-0.7,0.47><-0.7,0.492><-0.716,0.519><-0.748,0.55>
 <-0.748,0.55><-0.779,0.581><-0.824,0.615><-0.88,0.652>
}
prism {
 linear_sweep
 bezier_spline 0,0.5,60
 <-1.004,0.189><-0.976,0.161><-0.953,0.134><-0.934,0.109>
 <-0.934,0.109><-0.916,0.085><-0.907,0.045><-0.907,-0.01>
 <-0.907,-0.01><-0.907,-0.045><-0.912,-0.091><-0.922,-0.147>
 <-0.922,-0.147><-0.938,-0.198><-0.948,-0.259><-0.953,-0.328>
 <-0.953,-0.328><-0.957,-0.398><-0.96,-0.464><-0.962,-0.526>
 <-0.962,-0.526><-0.943,-0.505><-0.912,-0.431><-0.869,-0.305>
 <-0.869,-0.305><-0.827,-0.178><-0.774,-0.084><-0.711,-0.02>
 <-0.711,-0.02><-0.711,-0.17><-0.742,-0.38><-0.803,-0.651>
 <-0.803,-0.651><-0.865,-0.922><-0.932,-1.048><-1.004,-1.029>
 <-1.004,-1.029><-1.041,-1.004><-1.066,-0.976><-1.077,-0.945>
 <-1.077,-0.945><-1.089,-0.914><-1.094,-0.872><-1.094,-0.82>
 <-1.094,-0.82><-1.094,-0.8><-1.093,-0.767><-1.092,-0.72>
 <-1.092,-0.72><-1.09,-0.673><-1.089,-0.636><-1.089,-0.608>
 <-1.089,-0.608><-1.089,-0.463><-1.075,-0.3><-1.047,-0.12>
 <-1.047,-0.12><-1.019,0.061><-1.004,0.164><-1.004,0.189>
}
texture { pigment { marble color_map { Sea } turbulence 0.6 } scale 8 }
rotate -40*x
scale 10
translate < -300, -60-30, -600 >
}

