//*********************************************************
// Contact curve (xy) macro Ver 0.1a including file
// (POV-Ray ver 3.1g)
// Written by S.Nishimura
//*********************************************************


//*********************************************************
#macro Beginning_center(Mx,Px1,Py1,Px2,Py2,Ox0,Oy0)
 #local A=2*(Mx*(Px1-Px2)+(Py2-Py1));
 #local B=2*(Mx*Py1+Px1)*(Py2-Py1);
 #local C=Mx*(Px2*Px2+Py2*Py2-Px1*Px1-Py1*Py1);
 #local Ox0= (B-C)/A;
 #local Oy0= (Mx*Py1+Px1-Ox0)/Mx;
#end
//*********************************************************
#macro Curve_element(Lw,Px1,Py1,Px2,Py2,Ox0,Oy0)
// center point
#local Vxp=Px2;
#local Vy=(-(Px1-Ox0)/(Py1-Oy0))*(Vxp-Px1)+Py1;       // vartical cross line
//
#if(Py2=Vy)
 #local Ox = Ox0+(Px2-Px1);
 #local Oy = Oy0+(Py2-Py1);
 #declare Curve_seg =
 cylinder { < Px1, Py1, 0 >,< Px2, Py2, 0 >,Lw }
#else
 #local A=2*(Px2-Px1)*(Px1-Ox0)+2*(Py2-Py1)*(Py1-Oy0);
 #local B=2*(Py1-Py2)*(Px1*Oy0-Py1*Ox0);
 #local C=(Px1-Ox0)*(Px1*Px1+Py1*Py1-Px2*Px2-Py2*Py2);
 #local Ox = (B-C)/A;                                 // center x
 #local Oy = ((Py1-Oy0)/(Px1-Ox0))*(Ox-Px1)+Py1;      // center y
 #local Tr=sqrt((Px2-Ox)*(Px2-Ox)+(Py2-Oy)*(Py2-Oy)); // radius r
#if(Px1<Px2 & Py2<Vy)
 #local Ra1=degrees(atan2(Py1-Oy,Px1-Ox))+90;
 #local Ra2=degrees(atan2(Py2-Oy,Px2-Ox))-90;
#end
#if(Px1<Px2 & Py2>Vy)
 #local Ra1=degrees(atan2(Py1-Oy,Px1-Ox))-90;
 #local Ra2=degrees(atan2(Py2-Oy,Px2-Ox))+90;
#end
#if(Px1>Px2 & Py2<Vy)
 #local Ra1=degrees(atan2(Py1-Oy,Px1-Ox))-90;
 #local Ra2=degrees(atan2(Py2-Oy,Px2-Ox))+90;
#end
#if(Px1>Px2 & Py2>Vy)
 #local Ra1=degrees(atan2(Py1-Oy,Px1-Ox))+90;
 #local Ra2=degrees(atan2(Py2-Oy,Px2-Ox))-90;
#end
 #declare Curve_seg =
 object {
  torus { Tr,Lw } rotate -90*x
  clipped_by { plane { x, 0 } rotate (Ra1)*z }
  clipped_by { plane { x, 0 } rotate (Ra2)*z }
  translate < Ox, Oy, 0 > }
#end
 #local Ox0 = Ox;
 #local Oy0 = Oy;
#end // macro end
//*********************************************************
#macro Curve_line(Lw,Bp,Ep,Ap,Mx,Func_type)
 #local Px0=0; #local Py0=0; #local Ox0=0; #local Oy0=0;
 #local Sp=Bp; #while(Sp<Ep)
//
 Curve_function(Sp,   Px0,Py0,Func_type) #local Px1=Px0; #local Py1=Py0;
 Curve_function(Sp+Ap,Px0,Py0,Func_type) #local Px2=Px0; #local Py2=Py0;
//
 #if(Sp=Bp) Beginning_center(Mx,Px1,Py1,Px2,Py2,Ox0,Oy0) #end
 Curve_element(Lw,Px1,Py1,Px2,Py2,Ox0,Oy0)
 Curve_obj()
//
 #local Sp=Sp+Ap; #end // while end
#end  // macro end
//*********************************************************
//*********************************************************
#macro Contact_curve_function(Sp,E1,E2,X0,Y0,X1,Y1,X2,Y2,Px0,Py0)
 #local Px0=(X0*pow(1-Sp,2)+(2+E1)*X1*Sp*(1-Sp)+(1+E1+E2)*X2*pow(Sp,2))/(1+E1*Sp+E2*pow(Sp,2));
 #local Py0=(Y0*pow(1-Sp,2)+(2+E1)*Y1*Sp*(1-Sp)+(1+E1+E2)*Y2*pow(Sp,2))/(1+E1*Sp+E2*pow(Sp,2));
#end
//*********************************************************
#macro Contact_curve(Lw,E1,E2)
#local Px0=0; #local Py0=0; #local Ox0=0; #local Oy0=0;
#local i=0; #while(i<Pmax-2)
 #local X0=Vx[i];   #local Y0=Vy[i];
 #local X1=Vx[i+1]; #local Y1=Vy[i+1];
 #local X2=Vx[i+2]; #local Y2=Vy[i+2]; 
// curve segment
#local Sp=0; #local Ep=1; #local Ap=0.12; #local Mx=(Y1-Y0-pow(.1,10))/(X1-X0-pow(.1,10));
#while(Sp<Ep)
 Contact_curve_function(Sp,E1,E2,X0,Y0,X1,Y1,X2,Y2,Px0,Py0)
 #local Px1=Px0; #local Py1=Py0;
 Contact_curve_function(Sp+Ap,E1,E2,X0,Y0,X1,Y1,X2,Y2,Px0,Py0)
 #local Px2=Px0; #local Py2=Py0;
 #if(Sp=0) Beginning_center(Mx,Px1,Py1,Px2,Py2,Ox0,Oy0) #end
 Curve_element(Lw,Px1,Py1,Px2,Py2,Ox0,Oy0)
 Curve_obj()
 #local Sp=Sp+Ap; #end // while end
#local i=i+2; #end     // while end
#end  // macro end
//*********************************************************
//*********************************************************
#macro Trammel_function(Sp,Va,Vl,Px0,Py0)
 #local Px0=Vl*cos(Sp);    #local Py0=(Va-Vl)*sin(Sp);
#end
//*********************************************************
#macro Trammel(Lw,Va,Vl)
 #local Sp=-pi; #local Ep= pi; #local Ap= pi/42; #local Mx=-((Va-Vl)*cos(Sp))/(Vl*sin(Sp+Ap/64));
 #local Px0=0; #local Py0=0; #local Ox0=0; #local Oy0=0;
 #while(Sp<Ep)
 Trammel_function(Sp,Va,Vl,Px0,Py0)   #local Px1=Px0; #local Py1=Py0;
 Trammel_function(Sp+Ap,Va,Vl,Px0,Py0)#local Px2=Px0; #local Py2=Py0;
 #if(Sp=-pi) Beginning_center(Mx,Px1,Py1,Px2,Py2,Ox0,Oy0) #end
 Curve_element(Lw,Px1,Py1,Px2,Py2,Ox0,Oy0)
 Curve_obj()
 #local Sp=Sp+Ap; #end // while end
#end  // macro end
//*********************************************************