// Contact curve Scene File
// (POV-Ray ver 3.1g)
// Written by S.Nishimura


#include "coordinate_color.mcr.inc"

#include "contact_curve.mcr.inc"

global_settings { assumed_gamma 2.2 }


//
camera { angle 60
	 location < 0, 0, -200 >
	 look_at < 0, 0, 0 >
}

light_source { < 300, 0, -1000 > color rgb 1*0.5 }
light_source { < 0, 450, -1000 > color rgb 1*0.8 }
light_source { <   0, 0, -1000 > color rgb 1*0.5 }


//
coordinate_color( 174, 0.8, 0.4, 1, 0 )
background { color rgb < R0, G0, B0 > }
//*********************************************************
plane { z, 0 clipped_by { superellipsoid { < 0.24, 0.24 > } }
 pigment { image_map { png "Bg_fish" map_type 0 interpolate 2 once }
  scale 2 translate < -(2)/2, -(2)/2, 0 > }
 finish { reflection 0.5 diffuse 0.4 }
 scale < 4/3, 1, 1 >*84
 }
//*****************************************************************
#macro Curve_obj()
coordinate_color( 180+360*((i+90)*Sp*20)/(Pmax*Ep*20), 0.7, 0.8, 1, 1 )
object { Curve_seg 
 pigment { color rgbt < R1, G1, B1, 0.3 > }
 finish { reflection 0 ambient 0.4 phong 0.2 brilliance 0.5 diffuse 0.5 }
 transform Tfm_curve
 no_shadow }
#end
//*****************************************************************
#declare Tfm_curve = transform { scale 2 }
//*****************************************************************
// initialize
#local Pmax=1+2*6; #declare Vx=array[Pmax] #declare Vy=array[Pmax]
#local i=0; #while(i<Pmax) #declare Vx[i]=0; #declare Vy[i]=0; #local i=i+1; #end
// position vector
#declare Vx[0]=-48;   #declare Vy[0]= 32;   #declare Vx[1]=-43; #declare Vy[1]= 40;
#declare Vx[2]=-38;   #declare Vy[2]= 32;   #declare Vx[3]=-33; #declare Vy[3]= 40;
#declare Vx[4]=-28;   #declare Vy[4]= 32;   #declare Vx[5]=-18; #declare Vy[5]= 27;
#declare Vx[6]=-28;   #declare Vy[6]= 23;   #declare Vx[7]=-33; #declare Vy[7]= 15;
#declare Vx[8]=-38;   #declare Vy[8]= 23;   #declare Vx[9]=-43; #declare Vy[9]= 15;
#declare Vx[10]=-48;  #declare Vy[10]= 23;  #declare Vx[11]=-58;#declare Vy[11]= 27;
#declare Vx[12]=Vx[0];#declare Vy[12]=Vy[0];
// contact curve // Lw:line width E1:E2:De=pow(E1,2)-4*E2
Contact_curve(0.8, 4, 8) // cloud
//*****************************************************************
#local Pmax=1+2*4;
// position vector
#declare Vx[0]= 40;   #declare Vy[0]= -5;   #declare Vx[1]= 42; #declare Vy[1]=  2;
#declare Vx[2]= 32;   #declare Vy[2]=  6;   #declare Vx[3]= 38; #declare Vy[3]=  0;
#declare Vx[4]=Vx[0]; #declare Vy[4]=Vy[0]; #declare Vx[5]= 52; #declare Vy[5]= -8;
#declare Vx[6]= 50;   #declare Vy[6]= -10;  #declare Vx[7]= 48; #declare Vy[7]= -8;
#declare Vx[8]=Vx[0]; #declare Vy[8]=Vy[0];
Contact_curve(0.8, 4, 4) // gull
//*****************************************************************
#local Pmax=1+2*3;
// position vector
#declare Vx[0]=-15;   #declare Vy[0]=-22;   #declare Vx[1]=-14.9; #declare Vy[1]= 18.0;
#declare Vx[2]= 30;   #declare Vy[2]= 18;   #declare Vx[3]= 30.0; #declare Vy[3]= -7.1;
#declare Vx[4]=-25;   #declare Vy[4]= -7;   #declare Vx[5]=-15.0; #declare Vy[5]= -7.0;
#declare Vx[6]=Vx[0]; #declare Vy[6]=Vy[0];
Contact_curve(0.8, 4, 4) // fish
//*****************************************************************
#declare Vx[0]= 10;  #declare Vy[0]= 16;  #declare Vx[1]=  6; #declare Vy[1]= 24;
#declare Vx[2]=  2;  #declare Vy[2]= 20;  #declare Vx[3]= -8; #declare Vy[3]= 18;
#declare Vx[4]=-18;  #declare Vy[4]=  2;  #declare Vx[5]=-10; #declare Vy[5]=  8;
#declare Vx[6]=-10;  #declare Vy[6]= -1;
Contact_curve(0.8, 4, 4) // dorsal fin
//*****************************************************************
#declare Vx[0]= 20;  #declare Vy[0]=  2;  #declare Vx[1]= 19; #declare Vy[1]= -3;
#declare Vx[2]= 18;  #declare Vy[2]= -9;  #declare Vx[3]= 16; #declare Vy[3]= -8;
#declare Vx[4]= 14;  #declare Vy[4]= -7;  #declare Vx[5]= 13; #declare Vy[5]= -2;
#declare Vx[6]= 16;  #declare Vy[6]= -1;
Contact_curve(0.8, 4, 4) // fin (1)
//*****************************************************************
#declare Vx[0]= 10;  #declare Vy[0]= -3;  #declare Vx[1]= 11; #declare Vy[1]= -5;
#declare Vx[2]=  8;  #declare Vy[2]=-12;  #declare Vx[3]=  6; #declare Vy[3]=-13;
#declare Vx[4]=  4;  #declare Vy[4]=-10;  #declare Vx[5]=  3; #declare Vy[5]= -6;
#declare Vx[6]=  6;  #declare Vy[6]= -4;
Contact_curve(0.8, 4, 4) // fin (2)
//*****************************************************************
#local Pmax=1+2*1;
// position vector
#declare Vx[0]= -2;  #declare Vy[0]= 18;   #declare Vx[1]= 1; #declare Vy[1]= 16;
#declare Vx[2]=  2;  #declare Vy[2]= 12;
Contact_curve(0.8, 4, 4) // (1)
//
#declare Vx[0]= -8;  #declare Vy[0]= 14;   #declare Vx[1]= -3; #declare Vy[1]= 13;
#declare Vx[2]= -3;  #declare Vy[2]=  9;
Contact_curve(0.8, 4, 4) // (2)
//
#declare Vx[0]=-12;  #declare Vy[0]= 10;   #declare Vx[1]= -7; #declare Vy[1]= 7;
#declare Vx[2]= -8;  #declare Vy[2]=  4;
Contact_curve(0.8, 4, 4) // (3)
//*****************************************************************
// position vector
#declare Vx[0]= 18;  #declare Vy[0]= 17;   #declare Vx[1]= 16; #declare Vy[1]= 8;
#declare Vx[2]= 22;  #declare Vy[2]=  3;
Contact_curve(0.8, 4, 4) // gills (era)
//*****************************************************************
sphere { < 25, 13, 0 >,0.8 
 pigment { color rgbt < R1, G1, B1, 0.3 > }
 finish { reflection 0 ambient 0.4 phong 0.2 brilliance 0.5 diffuse 0.5 }
 transform Tfm_curve }
//*****************************************************************
#local Pmax=1+2*2;
// position vector
#declare Vx[0]= 15;  #declare Vy[0]= 17;   #declare Vx[1]= 14; #declare Vy[1]= 13;
#declare Vx[2]= 17;  #declare Vy[2]=  9;   #declare Vx[3]= 16; #declare Vy[3]=  6;
#declare Vx[4]= 19;  #declare Vy[4]=  2;
Contact_curve(0.8, 4, 8) // scale
//*****************************************************************
#local Pmax=1+2*3;
// position vector
#declare Vx[0]= 12;  #declare Vy[0]= 16;   #declare Vx[1]=  9; #declare Vy[1]= 14;
#declare Vx[2]= 12;  #declare Vy[2]= 11;   #declare Vx[3]= 10; #declare Vy[3]=  9;
#declare Vx[4]= 14;  #declare Vy[4]=  6;   #declare Vx[5]= 13; #declare Vy[5]=  3;
#declare Vx[6]= 16;  #declare Vy[6]=  1;
Contact_curve(0.8, 4, 8) // uroko(1)
//
#declare Vx[0]=  8;  #declare Vy[0]= 15;   #declare Vx[1]= 5; #declare Vy[1]= 12;
#declare Vx[2]=  8;  #declare Vy[2]=  9;   #declare Vx[3]= 6; #declare Vy[3]=  7;
#declare Vx[4]= 10;  #declare Vy[4]=  4;   #declare Vx[5]= 9; #declare Vy[5]=  1;
#declare Vx[6]= 12;  #declare Vy[6]= -1;
Contact_curve(0.8, 4, 8) // uroko(2)
//
#declare Vx[0]= 4;  #declare Vy[0]= 13;   #declare Vx[1]= 1; #declare Vy[1]= 10;
#declare Vx[2]= 4;  #declare Vy[2]=  7;   #declare Vx[3]= 2; #declare Vy[3]=  5;
#declare Vx[4]= 6;  #declare Vy[4]=  2;   #declare Vx[5]= 5; #declare Vy[5]= -1;
#declare Vx[6]= 8;  #declare Vy[6]= -3;
Contact_curve(0.8, 4, 8) // uroko(3)
//
#declare Vx[0]=  0;  #declare Vy[0]= 11;   #declare Vx[1]= -3; #declare Vy[1]=  8;
#declare Vx[2]=  0;  #declare Vy[2]=  5;   #declare Vx[3]= -2; #declare Vy[3]=  3;
#declare Vx[4]=  2;  #declare Vy[4]=  0;   #declare Vx[5]=  1; #declare Vy[5]= -2;
#declare Vx[6]=  4;  #declare Vy[6]= -4;
Contact_curve(0.8, 4, 8) // uroko(4)
//*****************************************************************
// position vector
#declare Vx[0]=-50;  #declare Vy[0]=-15;  #declare Vx[1]=-58; #declare Vy[1]= -9;
#declare Vx[2]=-55;  #declare Vy[2]= -7;  #declare Vx[3]=-35; #declare Vy[3]= -4;
#declare Vx[4]=-15;  #declare Vy[4]= -7;  #declare Vx[5]=-12; #declare Vy[5]= -9;
#declare Vx[6]=-15;  #declare Vy[6]=-15;
Contact_curve(0.8, 4, 4)  // ship(1)
//
#declare Vx[0]=-40;  #declare Vy[0]= -5;  #declare Vx[1]=-42; #declare Vy[1]= -3;
#declare Vx[2]=-40;  #declare Vy[2]=  0;  #declare Vx[3]=-30; #declare Vy[3]=  2;
#declare Vx[4]=-20;  #declare Vy[4]=  0;  #declare Vx[5]=-18; #declare Vy[5]= -2;
#declare Vx[6]=-20;  #declare Vy[6]= -5;
Contact_curve(0.8, 4, 4)  // ship(2)
//
#declare Vx[0]=-30;  #declare Vy[0]=  0;  #declare Vx[1]=-29; #declare Vy[1]=  5;
#declare Vx[2]=-30;  #declare Vy[2]= 11;  #declare Vx[3]=-27; #declare Vy[3]= 12;
#declare Vx[4]=-24;  #declare Vy[4]= 11;  #declare Vx[5]=-25; #declare Vy[5]=  5;
#declare Vx[6]=-24;  #declare Vy[6]=  0;
Contact_curve(0.8, 8, 4)  // ship(3)
//*****************************************************************
cylinder { < -55, -10, 0 >,< -14, -10, 0 >, 0.8 open
 pigment { color rgbt < R1, G1, B1, 0.3 > }
 finish { reflection 0 ambient 0.4 phong 0.2 brilliance 0.5 diffuse 0.5 }
 transform Tfm_curve }
//*****************************************************************
#local Pmax=1+2*1;
// position vector
#declare Vx[0]=-45;  #declare Vy[0]= -5;   #declare Vx[1]=-25; #declare Vy[1]=-15;
#declare Vx[2]=-30;  #declare Vy[2]=-25;
Contact_curve(0.8, 4, 4) // splash(1)
//
#declare Vx[0]= 10;  #declare Vy[0]=-20;   #declare Vx[1]= -5; #declare Vy[1]= -15;
#declare Vx[2]=-10;  #declare Vy[2]=-25;
Contact_curve(0.8, 4, 4) // splash(2)
//*****************************************************************
#macro Curve_function(Sp,Px0,Py0,Func_type)
 #switch(Func_type)
 #case(0) #local Px0= 10*pow(0.99,6*Sp)*cos(Sp); #local Py0= 10*pow(0.99,6*Sp)*sin(Sp); #break
 #case(1) #local Px0= 10/4*Sp; #local Py0= 10/4*cos(Sp)-15; #break
 #case(2) #local Px0= 10/4*Sp; #local Py0= 10/4*sin(Sp)-25; #break
 #case(3) #local Px0= 10/4*Sp; #local Py0= 10/4*cos(Sp)-35; #break
 #case(4) #local Px0= 20*cos(Sp)-20; #local Py0= 8*sin(Sp)-25; #break
 #case(5) #local Px0= 40*cos(Sp)-20; #local Py0= 12*sin(Sp)-25; #break
 #case(6) #local Px0= 3*cos(Sp)-20; #local Py0= 3*sin(Sp)+16; #break
 #case(7) #local Px0= 4*cos(Sp)-6; #local Py0= 4*sin(Sp)+24; #break
 #case(8) #local Px0= 5*cos(Sp)+10; #local Py0= 5*sin(Sp)+27; #break
 #end
#end
//*****************************************************************
// parameter Lw:Bp:Ep:Ap:Mx:Func_type
Curve_line(0.8,-pi*7,7*pi,pi/8,-sin(-pi*7-pow(.1,10)),1) // wave
Curve_line(0.8,-pi*7,7*pi,pi/8,cos(-pi*7-pow(.1,10)),2)
Curve_line(0.8,-pi*7,7*pi,pi/8,-sin(-pi*7-pow(.1,10)),3)
//*****************************************************************
Curve_line(0.8,0,pi*2,pi/16,((-8/20)/sin(pi/64)),4)  // ripple
Curve_line(0.8,0,pi*2,pi/24,((-12/40)/sin(pi/64)),5)
//*****************************************************************
Curve_line(0.8,0,pi*2,pi/8,(-1/sin(pi/64)),6) // smoke
Curve_line(0.8,0,pi*2,pi/8,(-1/sin(pi/64)),7)
Curve_line(0.8,0,pi*2,pi/8,(-1/sin(pi/64)),8)
//*****************************************************************
#declare Tfm_curve = transform { translate < 40, 25, 0 > scale 2 }
//*****************************************************************
Curve_line(0.8,0,9*pi,pi/24,tan(radians(90)+pow(.1,10)),0) // sun
union {
 cylinder { < -11, 0, 0 >,< -20, 0, 0 >,0.8 open rotate  60*z }
 cylinder { < -11, 0, 0 >,< -20, 0, 0 >,0.8 open rotate 120*z }
 cylinder { < -11, 0, 0 >,< -20, 0, 0 >,0.8 open rotate 180*z }
 cylinder { < -11, 0, 0 >,< -20, 0, 0 >,0.8 open rotate 240*z }
 cylinder { < -11, 0, 0 >,< -20, 0, 0 >,0.8 open rotate 300*z }
 cylinder { < -11, 0, 0 >,< -20, 0, 0 >,0.8 open rotate 360*z }
 pigment { color rgbt < R1, G1, B1, 0.3 > }
 finish { reflection 0 ambient 0.4 phong 0.2 brilliance 0.5 diffuse 0.5 }
 translate < 40+1, 25+1, 0 > scale 2 }
//*****************************************************************

// Signature
//#include "Sealreverse.sgn.inc"
//object {Sealing scale 2 translate < -105, -76, 0 > }