#declare sub = union{
  //hull of submarine
  cylinder{
    <-200,0,0>, <100,0,0>, 50
  }

  difference{
    difference{
      sphere{
        <0,0,0>, 50
      }
      box{
        <0,60,60>, <60,-60,-60>
      }
      scale x*3
    }

    //those holes in the front of the sub
    box{
      <-2.5, -2.5, -1.5>, <2.5,100,1.5>
      translate <-50, 45, 0>
      rotate x*-45
    }
    box{
      <-2.5, -2.5, -1.5>, <2.5,100,1.5>
      translate <-44, 45, 0>
      rotate x*-45
    }
    box{
      <-2.5, -2.5, -1.5>, <2.5,100,1.5>
      translate <-48, 45, 0>
      rotate x*-50
    }
    translate x*-200
  }

  difference{
    sphere{
      <0,0,0>, 50
    }
    box{
      <0,60,60>, <-60,-60,-60>
    }
    scale x*10
    translate x*100
  }

  //fins of submarine
  difference{
    box{
      <0, -30, -.1>, <45, 30, .1>
    }
    box{
      <0, 150, -1>, <50, 0, 1>
      rotate z*45
    }
    box{
      <0, -150, -1>, <50, 0, 1>
      rotate z*-45
    }
    translate x*590
  }
  difference{
    box{
      <0, -30, -.1>, <45, 30, .1>
    }
    box{
      <0, 150, -1>, <50, 0, 1>
      rotate z*45
    }
    box{
      <0, -150, -1>, <50, 0, 1>
      rotate z*-45
    }
    rotate x*90
    translate x*590
  }

  //propellers of submarine
  //  propeller housing
  #declare Count=1;
  #while (Count < 5)
    difference{
      cylinder{
        <0,0,0>, <15,0,0>, 7  
      }
      cylinder{
        <-1,0,0>, <50, 0, 0>, 6.8
      }
      translate <613, 7.1, 7.1>
      rotate x*90*Count
    }
    #declare Count=Count+1;
  #end

  //That thing jutting out of the submarine
  union{
    difference{
      superellipsoid{
        <1,.25>
        rotate x*90
      }
      box{
        <0, 50, 50>, <50,-50,-50>
      }
    }
    difference{
      superellipsoid{
        <1,.25>  
        rotate x*90 
      }
      box{
        <0, 50, 50>, <50,-50,-50>
      }
      scale x*5
      rotate y*180
    }
    pigment{Black}
    scale <15,40,15> 
    translate <-160, 60, 0>
    finish{
      ambient .1
      reflection .1 
      specular .05 roughness .05
      brilliance 5 
    }
  }

  //Little cylinder along the hull
  union{
    cylinder{
      <-75, 0, 0>, <-75, 54, 0>, 3
    }
    cylinder{
      <-50, 0, 0>, <-50, 54, 0>, 3
    }

    cylinder{
      <110, 0, 0>, <110, 54, 0>, 3
    }
    cylinder{
      <135, 0, 0>, <135, 54, 0>, 3
    }
  }

  //periscope tube (on the thing jutting out of the sub)
  union{
    cylinder{
      <0, 0, 0>, <0, 130, 0>, 3
    }  
    cylinder{
      <0, 0, 0>, <0, 150, 0>, 2
    }
    translate x*-130
    pigment{Black}
    finish{
      ambient .1
      reflection .1
      specular .05 roughness .05
      brilliance 5
    }
  }

  //the thing next to the periscope
  cylinder{
    <-140, 0, 0>, <-140, 105, 3>, 3 
  } 

  //the railing along the top of the sub
  union{
    difference{
      torus{
        10, .5
      }
      box{
        <0, 50, 50>, <50, -50, -50>
      }
    }

    difference{
      torus{
        10, .5
      }
      box{
        <0, 50, 50>, <50, -50, -50>
      }
      scale x*6
      rotate y*180
    }
  
    cylinder{
      <-10, 0,0>, <-10, -20,0>, .4
    }
    cylinder{
      <0, 0, 10>, <0, -20, 10>, .4
    }
    cylinder{
      <0, 0, -10>, <0, -20, -10>, .4
    }
    cylinder{
      <60, 0, 0>, <60, -20, 0>, .7
    }
    translate <-160, 105, 0> 
  }

  pigment{Black}
  finish{
    ambient .1
    reflection .16
    specular .4 roughness .3
    metallic 
    brilliance 10
  }    
  normal{
    bozo
    scale 3
  }
}
