//note: this is a file by Greg M. Johnson.
// this file will enable you to do the textures & media and see how I did things
// but I'm not including the whole deal because of:
// 1) laziness
// 2) the inefficient way I did things, for example, the fish positions are taken off a pre-existing file w/ data at 374 time frames: little value to you, right?
// 3) The DXF model I used for the sub comes off of the CorelDream3D CD; it is probably not public domain.

#version unofficial MegaPov 0.5;
#include "colors.inc"
#include "textures.inc"
#include "stones.inc"
#include "metals.inc"
#include "sharkb05.pov" // this is an original sPatch file of the shark I used, not included
#include "fish03.pov"   // this is an original sPatch file of the fish I used, not included.
#include "corelsub3.pov" // this is a DXF model of a sub I got off the CorelDream3D CD, not included.
#include "flyby15c1.inc" // this is 

//#include "corelshark2.pov"

#declare zedd=<0,0,0>;

camera {                 
//orthographic 
  location <-2, 2.5, 4>+zedd
 // right <4/3, 0, 0>*8
   // up <0, 1, 0>*8
angle 43  
  look_at <-0, 1.5, 30>+zedd
}


//fog {  fog_type 1  distance 13000     color rgb <.2,.4,.8>/5     up <0,1,0>    }
//background {rgb <.2,.4,.8>/5} 

/*
media{
    absorption rgb <0,0,0> // <.8,.6,.4>
    intervals 10
    samples 1, 10         
  confidence 0.9999
  variance 1/1000
  ratio 0.9
  }
*/



                /*
media {                         //media scattering
  intervals 10
  scattering { 1, red 0.00001 blue 0.90001 green 0.000101}   // red 0.05 blue 0.001 green 0.02} 
  samples 1, 10         
  confidence 0.9999
  variance 1/1000
  ratio 0.9
} 
*/
  
  
media {                         //media scattering
        density {bumps 
                color_map{
                        [0.00 rgb <1,1,1>*7]
                        [0.15 rgb <1,1,1>*7]
                        [0.16 rgb <1,1,1>*.1]//<0,0,0>]
                        [1.00 rgb <1,1,1>*.1]//<0,0,0>]
                        }
        scale .04// was 20                
                }

  intervals 100
  scattering { 1, rgb <0.030,0.010,0.005>*4} // red 0.05 blue 0.001 green 0.02} //rgb <0.05,0.001,0.02>} 
  samples 1, 10         
  confidence 0.9999
  variance 1/1000
  ratio 0.9
} 
/*
media {                         //media scattering
  intervals 10
  emission rgb <.02,.04,.08> // red 0.05 blue 0.001 green 0.02} //rgb <0.05,0.001,0.02>} 
  samples 1, 10         
  confidence 0.9999
  variance 1/1000
  ratio 0.9
} 
*/  

media {                         //media scattering
        /*density {gradient z
                color_map{
                        [0.00 rgb <0,0,0>]
                        //[0.50 rgb <0.3,0.30,0.30>]
                        //[1.00 rgb <0,0,0>]
                        //[0.00 rgb <1,1,1>]
                        [1.00 rgb <1,1,1>*1]
                        }
        scale 400// was 20                
        translate <0,0,-17>
                }
        */        

  intervals 100
  //scattering { 1, rgb <0.0160,0.0030,0.0010>*1} // red 0.05 blue 0.001 green 0.02} //rgb <0.05,0.001,0.02>} 
  absorption rgb <0.0160,0.0030,0.0010>*0.35 //<0.0340,0.0085,0.0025>
  //scattering { 1, rgb <0.180,0.032,0.006>} // red 0.05 blue 0.001 green 0.02} //rgb <0.05,0.001,0.02>} 
  samples 1, 10         
  confidence 0.9999
  variance 1/1000
  ratio 0.9
} 


//note: change this to area lights or something.                  
light_source { <0, 15000, -0> color rgb 0.65  media_interaction off }                                           


#declare subcol=DarkSlateBlue/8 +Bronze2/3.5;

                  
#declare Intensity = .002;
#declare subfinish=
        texture {
                pigment{
                bozo
                pigment_map{
                        [0.00 subcol*0.7]
                        //[0.50 rgb <0.3,0.30,0.30>]
                        //[1.00 rgb <0,0,0>]
                        //[0.00 rgb <1,1,1>]
                        [1.00 subcol*1.1]
                        }
                scale 0.5        
                        }
                
                finish {metallic roughness 1 ambient 0.1}//1.22}
                normal{ gradient x 1 
                        slope_map{
                                [0.00 <1,0>]
                                [0.45 <1,0>]
                                [0.45 <1,-1>]
                                [0.5 <-.5,-1>]
                                [0.5 <-.5,1>]
                                [0.55 <1,-1>] 
                                [0.55 <1,0>]
                                [1.00 <1,0>]
                                }
                         scale 1
                      }
                }

    
#declare vect= <0,-1.85,-2.5> ;
#declare headpoz=5;                      
#declare headlight=
union{
      torus{.55,.05  
        translate <0,headpoz,0>} 
      difference{
                 sphere {<0,headpoz,0>,.52
                         }
                 sphere {<0,headpoz,0>,.2
                         } 
                 cylinder {<0,headpoz,0>,<0, -10, 0>,.35
                          }        
                          
                 }         
      light_source {
                   <0,headpoz,0,>  color rgb<1.4,1.15, 1>*2
                   spotlight point_at <0, 0, 0> //was at spotlight point_at <0, -5, -17>
                   radius 12
                   falloff 25
                   //tightness 1
                   media_attenuation on
                  //translate vect 
                  }
     pigment{DarkSlateBlue/8 +Bronze2/3.5}
     finish {metallic roughness 1 ambient 0.25}//1.22}
                
                  
     }
                                 
//#declare p1=min_extent(corelsub);
//#declare p2=max_extent(corelsub);
                         
                          
                          
#declare suby=
//union{
        object{corelsub
        //sphere {0,36
        rotate <-90,-0,0>
        rotate <0,180,0>
        scale 0.85   
        texture {subfinish
        //finish {ambient .58}
        }
        
        texture{pigment {
                image_map {
                        tga "hmsempire3.tga"
                        map_type 0
                        once
                        }
                scale <1,.2,.01>*4
                rotate <0,0,-1.8>
                //
                translate <-23,-2.3,0> 
                }                        
          }  
        
        finish {ambient .2}
        }
             

#declare she0=min_extent(suby);
#declare she1=max_extent(suby);

#debug str(she0.x,3,2)
#debug " "
#debug str(she0.y,3,2)
#debug " "
#debug str(she0.z,3,2)
#debug " "
#debug "\n"

#debug str(she1.x,3,2)
#debug " "
#debug str(she1.y,3,2)
#debug " "
#debug str(she1.z,3,2)
#debug " "

#declare yadda3=function{pigment{wrinkles}}          

#declare floory=  
isosurface{function{y-
        yadda3(x,y,z)/2-
        yadda3(x+0.02,y,z+0.015)/2}
        //accuracy 0.01 
          accuracy 0.00001
        threshold 0
        contained_by {sphere{0,3600}}
        scale <150,95,150>   
        translate <-2,-62,-89>
        pigment {
                wrinkles
                pigment_map{
                        [0.0 Bronze2]
                        [1 Bronze2/3]
                           } 
                      scale 0.1                            
                }          
        finish {ambient 0.08 }
        normal {bumps}


        
        }

object{floory}

object {headlight rotate <-40,0,-45> translate <-11,0,-10> translate <10.0, 1,38.5>                  }               


#declare jed=0;
#declare Norm=<0,0,0>;
#declare pos1=<10.0, 1,40>; 
#declare pos1=trace(floory,pos1+1000*y,-y,Norm)+3.7*y;
  
  
object {suby                       
        rotate <8,20,0>
        translate pos1
        } 
object {spashark         rotate <0,92,0>         translate <8,8,34>         }                   



#declare tee=50;
#declare dag1=<1,5,18>;//ideal location of center of fish
#declare dag2= <-371.223,156.847,-43.7705>        ;//position from inc
        
                       
#macro Reorient(Axis1,Axis2)
                #local vX1=vnormalize(Axis1);                   //john vansickle
                #local vX2=vnormalize(Axis2);
                #local vY=vnormalize(vcross(vX1,vX2));
                #local vZ1=vnormalize(vcross(vX1,vY));
                #local vZ2=vnormalize(vcross(vX2,vY));
                matrix < vX1.x, vY.x,vZ1.x, vX1.y,vY.y,vZ1.y, vX1.z,vY.z, vZ1.z, 0,0,0 >
                matrix < vX2.x,vX2.y,vX2.z,  vY.x,vY.y, vY.z, vZ2.x,vZ2.y,vZ2.z, 0,0,0 >
              #end
#declare num=100;                
#declare framenum=374;
               

#declare rrr=1.5;                               
                       
#declare n=2    ;
#while (n<num)
//#while (n<3)

#declare dagfile=<Position[tee][n][0],Position[tee][n][1],Position[tee][n][2]>;
#declare fishpos= (dagfile-dag2)/6+dag1;



object{ spafish
        scale 0.125
     Reorient(z,<-Position[tee][n][3],Position[tee][n][4],Position[tee][n][5]>)
     translate fishpos
     }
     
#declare n=n+1   ;
#end          
        