// Persistence of Vision Ray Tracer Scene Description File
// File: cup.inc
// Vers: 3.1g.wmp.0.5
// Desc: cup inc
// Date: mm/dd/yy
// Auth: Tom Melly, http://www.tomandlu.f9.co.uk, tom@tomandlu.f9.co.uk
//

#version unofficial MegaPov 0.5;

#declare myShiny =
finish{Shiny diffuse 0.75 brilliance 0.5 reflection_type 1 reflection_max 0.40 reflection_min 0.20 metallic}

#declare Base_Tex =
texture{
  pigment{rgb<1,1,0.9>}
  normal{marble 0.05 scale 0.1 turbulence 0.25}
  finish{myShiny}
}

#declare Pattern_Base_Pig =
pigment{rgb<1,1,0.95>}

#declare Pattern_Pig1 =
pigment{rgb<0.75,0.1,0.0>}

#declare Pattern_Pig2 =
pigment{rgb<0.0,0.1,0.75>}

#declare Pattern_Pig3 =
pigment{rgb<0.0,0.75,0.1>}

#declare Pattern_Tex =
texture{
  pigment{
    mandel 50
    pigment_map{
      [0.09  Pattern_Base_Pig]
      [0.10  Pattern_Pig1]
      [0.15  Pattern_Pig1]
      [0.16  Pattern_Pig2]
      [0.30  Pattern_Pig2]
      [0.31  Pattern_Pig3]
      [0.98  Pattern_Pig3]
      [0.99  Pattern_Base_Pig]
    }
    scale <0.35,0.25,1>
    rotate z*90
    translate <0,0.30,0>
  }
  normal{marble 0.01 scale 0.1 turbulence 0.25}
  finish{myShiny}
}

#declare base_cup_solid =
difference{
  cylinder{<0,-1,0>,  <0,1,0>,  0.75} //main block
  #declare loop = 0;
  #declare max_loop = 8;//1 more than required no. of sides
  #while(loop < max_loop)
 
    sphere{ // sides
      <0,0,2>, 1.5
      texture{Pattern_Tex}
      rotate y * (loop * (360/max_loop)) scale <1,2,1>
    }
    sphere{ // stem indents
      <0,0,0>, 0.25 scale <6.5,1.5,6.5> translate<0,-0.25,2> rotate y * (loop * (360/max_loop))
    }
    #declare loop = loop + 1;
  #end
  box{<-1,-1.1,-1>,<1,-0.45,1>} //lower limit at y*-0.45
}

#declare base_cup_cut = // inner cup to remove from base cup solid
difference{
  cylinder{<0,0.125,0>,  <0,1,0>,  0.75}
  
  #declare loop = 0;
  #declare max_loop = 8;//1 more than required no. of sides
  #while(loop < max_loop)
    sphere{<0,0,2>, 1.5 rotate y * (loop * (360/max_loop)) scale <1,2,1>}
    #declare loop = loop + 1;
  #end
}

#declare cup_solid =  
#union{
  difference{
    object{base_cup_solid}
  
    difference{ //top scallops
      box{<-0.75, 0.9,-0.75>, <0.75,1.5,0.75>}
      #declare loop = 0;
      #declare max_loop = max_loop/2;
      #while(loop < 4)
        cylinder{<0,0.9,-2>, <0,0.9,2>, 0.05 scale <5,1,1> rotate y *(loop * (180/max_loop))}
        #declare loop = loop + 1;
      #end 
    }
    box{<-1,-1,-1>,<1,-0.26,1>} // take out lower base to replace with diff. below
  }
  difference{ //smoother base
    sphere{<0,-0.40,0>,0.3 scale <1.5,1,1.5>}
    box{<-1,-1,-1>,<1,-0.40,1>}
  }
} 

#declare cup_hollow =
difference{
  object{cup_solid}
  object{base_cup_cut scale<0.98, 1,0.98> translate y*0.1}
}

#declare base_handle =
sphere_sweep {
  catmull_rom_spline_sphere_sweep, 7,
  <0.2, 0.0, 0.0>, 0.10
  <0.0, 0.0, 0.0>, 0.06
  <-0.2, 0.2, 0.0>, 0.04
  <-0.4, 0.6, 0.0>, 0.04
  <-0.3, 0.8, 0.0>, 0.04
  <0.0, 0.7, 0.0>, 0.06
  <0.0, 0.2, 0.0>, 0.10
  sphere_sweep_depth_tolerance 1.0e-3
  scale 0.95
}

#declare handle =
#difference{
  object{base_handle translate <-0.45, 0.1,0.0>}
  object{base_cup_solid scale<0.99,1,0.99>}
}

#if(do_Rim = 1)
  #declare cupRand = seed(141298);
  #declare cup_rim=
  blob{
    threshold 1
    #declare rim_norm = <0, 0, 0>; 
    #declare x_loop = 1;
    #while (x_loop > -1)
      #declare z_loop = 1;
      #while (z_loop > -1)
        #declare rim_pos= trace(cup_hollow, <x_loop, 2, z_loop>, <x_loop, -1, z_loop>, rim_norm);
        #if (rim_norm.y > 0.75 & rim_pos.y > 0.5) 
          #declare randomShift = rand(cupRand)/200;
          sphere{rim_pos, 0.0375+randomShift, 1}
        #end
        #declare randomShift = rand(cupRand)/175;
        #declare z_loop = z_loop - 0.01 + randomShift;
      #end
        #declare randomShift = rand(cupRand)/175;
      #declare x_loop = x_loop - 0.01 + randomShift;
    #end
    texture{T_Gold_3D}
  }
#end

#declare full_cup =
union{
  object{cup_hollow}
  #if(do_Rim = 1)
    object{cup_rim}
  #end
  object{handle}
  translate y*0.40  //  not 1 due to box diff in base_cup_solid and new base
  scale<1.25,1,1.25>
}

#declare saucer=
union{
  lathe {
    cubic_spline
    10,
    <-.1,0.0>,
    <0.0,0.0>,
    <0.4,0.0>,
    <0.7,0.2>,
    <1.0,0.4>,  
    <0.9,0.4>,  
    <0.7,0.3>,  
    <0.4,0.1>,  
    <0.0,0.1>,
    <-.1,0.1>
  }
  
  torus
  {
    1.0,
    0.02
    texture{T_Gold_3D}
    translate y*0.4
  }
}

#declare cup_and_saucer = // 1.46 units high, 2.5 units wide inc, saucer (cup 1.5 ?) center base at 0
union{
  object{full_cup translate y*0.11}
  object{saucer scale<1.15,1,1.15>}
  texture{Base_Tex}
}
