// "The Toon Sea" full source code by Eric David
// for the 07/2000 and 08/2000 IRTC

#version 3.1;
global_settings { assumed_gamma 1.2 }

#include "colors.inc"
#include "textures.inc"

#declare CAM = <0,-10,-120>;

#declare FISHONLY = 0; // allows you to see only the horned fish
                      
camera { location CAM look_at <20,-18,0> }
//camera { location CAM look_at <40,-58,0> angle 10 } // gems only

// misc *********************************************************************************
                                        
light_source { CAM color Gray30 fade_distance 120 fade_power 3 }
light_source { CAM+<-30,0,30> color Gray70 fade_distance 120 fade_power 3 }

#declare Eye1 = union {
sphere { < 0,0,0>,4  pigment { White*1 } finish { ambient 0.3 diffuse 1}}
sphere { < 0,0,-2>,2.2  pigment { Gray10 }}
}

#if (FISHONLY = 0)

#declare A = 10000;

#declare Or = texture { pigment { rgb <1,1,0> } finish { ambient 0.4 diffuse 0.3 specular 1 roughness 0.3 } }

#declare Rocher = texture { pigment { White*0.8 }
                 finish { ambient 0.5 diffuse 0.5 specular 0.4 } normal { crackle 20 scale 0.6 }}
	
#declare Grass  = texture { pigment { color Green } finish { ambient 0.3 diffuse 0.4 specular 0.4 } normal { bozo 10 scale 0.5 }}
	
#declare col = color <0.1,0.2,0.4>*2;
#declare Ocean  = texture { pigment { ripples color_map{[0 color col][1 color Black]} scale 50 }
                          finish { ambient 1 diffuse 0 specular 0 }
                          }

#declare Eye2 = union {
sphere { < 0,0,0>,4  pigment { White*1 } finish { ambient 0.3 diffuse 1}}
sphere { < 0,0,-0.5>,3.6  pigment { Gray10 } finish { ambient 0.3 diffuse 1}}
}

// le decor *********************************************************************************

#declare Fond_marin = texture {   
    bozo
    texture_map {
      [0.4  Rocher]
      [0.6  Grass ]} 
      turbulence 0.6
      scale 10
  }

// fond marin
height_field { gif "hfield.gif" scale <1,-1,1> translate <-.5,1,-.5> 
        scale <1000,260,1000> translate y*-60 smooth
texture {Fond_marin } no_shadow hollow }

// brouillard
fog { color rgbf <0,0,0> fog_type 1 distance 300 } 

// irregularites du sol
/*blob { threshold 0.3
#declare i = 0;
#declare M = 100;
#while (i < M)
sphere {<sin(i)*80*(1+cos(8*i))+20,-60,
         cos(i)*80*(1+cos(i*i))>,8+sin(i+i*i)*2,0.5 }
#declare i = i+1;
#end
texture { Fond_marin }
}*/

// flotte (pas infinie : on s'en fout car fog)

#declare SURF = 80;
polygon {
    5,
    <-A,SURF, -A>, <-A,SURF, A>, <A,SURF, A>, <A,SURF, -A>, <-A,SURF,-A>
    texture {Ocean}
    no_shadow
    }                        

                                                                             

// petits poissons
#declare Poisson = texture { pigment { bozo color_map {[0 rgb <0.5,1,1.5>][1 rgb <0.5,1.5,1>]} scale 0.5 }
finish { ambient 0.2 diffuse 0.2 specular 0.5 roughness 0.1 }
normal { ripples 1 scale 1 } }

#declare chtit_poisson = 
union {
sor {
#declare N = 10; // resolution - 10 est largement suffisant.
  N+2,
#declare i = 0; 
  <1,-1>
#declare beta = 0;
#while (i <= N)
  <abs(cos(beta)),beta>
#declare i = i + 1;
#declare beta = i*(pi-0.3)/N;
#end
  rotate z*90 
  texture { Poisson }
 scale <1,1,1> 
} 
difference {
 sphere { <0,0,0>,1} // on n'a pas le bout de la sphere, sinon :(
 box { <-2,-2,-2>,<0,2,2> }
 texture { Poisson }
 scale <1,1,1> 
 }  

//object { Eye2 rotate y*-90 scale 0.1 translate <1,0.4, 0.5> } // :)
object { Eye2 rotate y*-90 scale 0.1 translate <0.5,0.4,-0.5> }
no_shadow
}

#declare i = 0;
#declare M = 20; // nombre de petits poissons
#while (i<M)
#declare i = i+1;
#declare pos = <-50+sin(tan(i))*20,-6+cos(i*i)*5,20+sin(tan(i+.5))*5>; // CA c'est du fake random :)	
object { chtit_poisson translate pos }
#end

// crabe
union {
#declare halfpince = difference { sphere { <0,0,0>,1 } sphere { <0,0.1,0>,1 } scale <1,.5,1> }
#declare Crab = texture { pigment { color rgb <1,0.4,0.1> } finish { ambient 0.4 diffuse 0.5 specular 0.5 }}
blob { threshold 0.3
	sphere { <0,2,1>,10,1 scale <1,0.5,1> } // global
	cylinder { <-3,2,-3>,<-3,8,-8>,0.5,1 } // pour l'oeil
	cylinder { <3,2,-3>,< 3,8,-8>,0.5,1 }
	cylinder { <-5,2,0>,<-10,5,-4>,1.5,1 } // pour pinces
	cylinder { < 5,2,0>,< 10,5,-4>,1.5,1 }
	cylinder { <-10,5,-5>,<-10,5,-10>,1.5,1 } // vers pinces
	cylinder { < 10,5,-5>,< 10,5,-10>,1.5,1 }
	cylinder { <-5,2,1>,<-10,5,5>,1,1 } // pattes 
	cylinder { < 5,2,1>,< 10,5,5>,1,1 } 
	cylinder { <-10,5,5>,<-13,0,7>,1,1 }
	cylinder { < 10,5,5>,< 13,0,7>,1,1 }
	cylinder { <-5,2,3>,<-8,4,7>,1,1 } // pattes 
	cylinder { < 5,2,3>,< 8,4,7>,1,1 } 
	cylinder { <-8,4,7>,<-10,0,10>,1,1 }
	cylinder { < 8,4,7>,< 10,0,10>,1,1 }
	cylinder { <-4,4,10>,<-3,2,7>,1,1 } // pattes 
	cylinder { < 4,4,10>,< 3,2,7>,1,1 } 
	cylinder { <-4,4,10>,<-6,0,15>,1,1 }
	cylinder { < 4,4,10>,< 6,0,15>,1,1 }
	texture { Crab }
}
object { Eye2 scale 0.3 rotate y*-60 translate <-3,8,-8> }
object { Eye2 scale 0.3 rotate y*-60 translate < 3,8,-8> }
object { halfpince                translate <0,0,-1> scale 3 rotate x*-20 translate <-10,5,-10> texture { Crab }}
object { halfpince scale <1,-1,1> translate <0,0,-1> scale 3 rotate x*20 translate <-10,5,-10> texture { Crab } }

object { halfpince                translate <0,0,-1> scale 3 rotate x*-20 translate <10,5,-10> texture { Crab }}
object { halfpince scale <1,-1,1> translate <0,0,-1> scale 3 rotate x*20 translate <10,5,-10> texture { Crab } }
scale 0.5
//rotate y*120
rotate y*-130
translate <10,-60,-15>
}

// le tresor *********************************************************************************

#declare cbois = color <0.3,0.15,0.075>;

#declare woody = texture {
pigment { gradient x color_map {
[0 color cbois]
[0.1 color cbois*1.5]
[0.9 color cbois*2]
[1 color cbois]
} }
finish { ambient 0.4 diffuse 0.8 specular 1.3 }
rotate y*45
scale 1
}

#declare wext = color <0.5,0.5,0.5>;

#declare woodyext = 
texture {
pigment { gradient x color_map {
[0 color wext]
[0.1 color wext*1.5]
[0.9 color wext*2]
[1 color wext]
} }
finish { ambient 0.4 diffuse 0.8 specular 1.3 }
rotate y*45
scale 1
}


// bouffe par les algues
//#declare Z = 1; // a l'interieur 
//#declare t_int = texture { bozo texture_map { [0.7 woody scale 1/Z][0.9 Grass finish {diffuse 0.4}] }  scale Z }
//#declare t_ext = texture { bozo texture_map { [0.7 woodyext scale 1/Z][0.9 Grass finish {diffuse 0.4}] } scale Z }

// un peu casse
//#declare Z = 1; // a l'interieur 
//#declare t_int = texture { bozo  texture_map { [0 woody finish { ambient 0 } scale 1/Z ][0.3 woody scale 1/Z] } scale Z}
//#declare Z = 3; // le truc blanc
//#declare t_ext = texture { crackle texture_map { [0 woodyext finish { ambient 0 } scale 1/Z ][0.1 woodyext scale 1/Z] } scale Z}

// normal
#declare t_int = texture { woody }
#declare t_ext = texture { woodyext }

#declare t_int_cyl = texture { t_int rotate y*-45 scale sqrt(2) }
#declare t_ext_cyl = texture { t_ext rotate y*-45 scale sqrt(2) }
                                                
#declare tn = 0.5; // thickness
#declare e = 0.01; // epsilon

#declare lower_chest = 
union {
difference { // partie d'en bas
box { <-5   ,2,-4   >,<5   ,5,4> texture {t_ext}}
box { <-5+tn,tn+2,-4+tn>,<5-tn,5.1,4-tn> texture { t_int}}
box { <-5+tn+e,tn+2-e,-4+tn-e>,<5-tn-e,5.1,4-tn+e> texture { t_int_cyl }}
}           

// charnieres
cylinder { <-3,5,-4>,<-2.1,5,-4>,tn/2 texture { Or }}
cylinder { <-1.9,5,-4>,<-1,5,-4>,tn/2 texture { Or }}
cylinder { < 3,5,-4>,< 2.1,5,-4>,tn/2 texture { Or }}
cylinder { < 1.9,5,-4>,< 1,5,-4>,tn/2 texture { Or }}
}

#declare upper_chest =
union { // le haut
difference {  
union{          
        cylinder { <-5-e,5,0>,<5+e,5,0>,4 texture {t_ext}}
        cylinder { <-5,5,0>,<5,5,0>,4+e texture {t_ext_cyl}} }
cylinder { <-5+tn,5,0>,<5-tn,5,0>,4-tn texture {t_int}}
cylinder { <-5+tn+e,5,0>,<5-tn-e,5,0>,4-tn+e texture {t_int_cyl}}
box { <-100,-100,-100>,<100,5,100> texture {t_int_cyl}}
}
difference {
box { <-.5,6,4>,<.5,4,4.2> texture { Or finish {ambient 0.6}}}
box { <-.25,5.5,4.01>,<.25,4.5,4.3> texture { Or  finish {ambient 0.6}}}
}
} // union dessus


// * gold coins

#declare piece = 
union {
cylinder { <0,0,0>,<0,1,0>,5 }
sphere { <0,0,0>,5 scale <1,0.2,1> translate y }
sphere { <0,0,0>,5 scale <1,0.2,1> }
texture { Or } 
scale 0.1 }

union {           
object { lower_chest translate y*-2  }
object { upper_chest translate <0,-5,4> rotate x*-60 translate <0,5,-4> translate y*-2 }

#declare Z = 0;
#declare MX = 12;
#declare MZ = 10;
#while (Z <= MZ)
#declare X = 0;
#while (X <= MX)

#if (mod(X+Z,2) = 0 | sin(X*5+Z*Z) > 0)
object { piece translate <(X-MX/2)*4*2/MX,
			  mod(X+Z,2)*0.3+5/3,
			  (Z-MZ/2)*3*2/MZ> }
#else
object { piece translate <(X-MX/2)*4*2/MX,
		          mod(X+Z,2)*0.3-0.6+5/3,
			  (Z-MZ/2)*3*2/MZ> }

#end
#declare X = X + 1;
#end
#declare Z = Z + 1;
#end

light_source { <0,3,0> color Yellow/2 fade_distance 20 fade_power 3 }

scale 3
rotate y*120
translate <-20,-60,0>
}


// * diamonds
       
#macro TEXT(U) 
pigment { color V+<0,0,0,0.7> } 
#if (V.x + V.y + V.z = 3) // diamonds
finish { ambient 0.2 diffuse 0.4 specular 0.8 roughness 0.5 }
#else
finish { ambient 0.4 diffuse 0.4 specular 1.3 roughness 1 }
#end
#end

#macro gem1(V) // octaedre
triangle { < 1,0,0>,<0,0, 1>,<0, 1,0> TEXT( 1.0) }
triangle { < 1,0,0>,<0,0, 1>,<0,-1,0> TEXT( 0.6) }
triangle { < 1,0,0>,<0,0,-1>,<0, 1,0> TEXT( 0.5) }
triangle { < 1,0,0>,<0,0,-1>,<0,-1,0> TEXT(-0.4) }
triangle { <-1,0,0>,<0,0, 1>,<0, 1,0> TEXT( 0.4) }
triangle { <-1,0,0>,<0,0, 1>,<0,-1,0> TEXT(-0.6) }
triangle { <-1,0,0>,<0,0,-1>,<0, 1,0> TEXT(-0.5) }
triangle { <-1,0,0>,<0,0,-1>,<0,-1,0> TEXT(-1.0) }
scale 1.2
#end       

#macro gem2(V) // patate + pyramide
#local l=0;
#local Ml=5;
#while (l<Ml)
#local p1 = l/Ml;
#local p2 = (l+1)/Ml;
#local beta1 = p1*2*pi;
#local beta2 = p2*2*pi;
#local R1 = 0.8;
#local Z1 = 0.6;
triangle { <0, 1,0>,<cos(beta1)*R1,1,sin(beta1)*R1>,<cos(beta2)*R1,1,sin(beta2)*R1> TEXT(0) }
triangle { <0, 0,0>,<cos(beta1),Z1,sin(beta1)>,<cos(beta2),Z1,sin(beta2)> TEXT( -cos(beta2)) }
triangle { <cos(beta1),Z1,sin(beta1)>     ,<cos(beta2),Z1,sin(beta2)>, <cos(beta1)*R1,1,sin(beta1)*R1> TEXT(sin(beta1)) }
triangle { <cos(beta2)*R1,1,sin(beta2)*R1>,<cos(beta2),Z1,sin(beta2)>, <cos(beta1)*R1,1,sin(beta1)*R1> TEXT(sin((beta2+beta1)/2)) }
#local l = l + 1;
#end
scale 1.2
#end

#macro gem(I,ang,sat)   
#local _V = (<sin(ang.x)*cos(ang.y)*0.5+0.5,
             cos(ang.x)*cos(ang.y)*0.5+0.5,
             sin(ang.y)*0.5+0.5> *sat+<1,1,1>*(1-sat)); // never black :)
#local norm = max(max(_V.x,_V.y),_V.z);
#local _V = _V/norm;
#if (mod(I,2) = 1)
gem1(_V)
#else
gem2(_V)
#end 
#end       

#macro gempos() <-3-Y*2/MY, Y*3/MY+0.3, (Z-MZ/2)*3*2/MZ> #end
union {           
object { lower_chest translate y*-2  }
object { upper_chest translate <0,-5,4> rotate x*-60 translate <0,5,-4> translate y*-2 }

#declare Z = 0;                  
#declare MY = 4;
#declare MZ = 5;
#while (Z <= MZ)
#declare Y = 0;
#while (Y <= MY)
union { gem(Z*Y,<0,0>,0) scale 0.5 
        rotate <sin(4*Y+Z*Z)*360,cos(Y*Z)*360,0> translate gempos() }
        // le scale 0.5 est compense plus bas
#declare Y = Y + 1;
#end
#declare Z = Z + 1;
#end

scale 2
rotate z*90
translate y*5
rotate y*240
translate <20,-54,20>
}

// gems dispercees
#macro gemdisppos() <20+sin(i*9+2)*10,-58,10-abs(cos(i+tan(i)))*10> #end
#declare i = 0;
#declare M = 20;
#while (i < M)   
union { gem(i,<0,0>,0)
        rotate <sin(5*i+i*i)*360,cos(i*8)*360,0> 
        translate gemdisppos() }
#declare i = i+1;
#end

// lumiere des gems
difference {
blob { threshold 0.3
#declare Z = 0;                  
#while (Z <= MZ)
#declare Y = 0;
#while (Y <= MY)
sphere { gempos()*2,6,0.5
rotate z*90 translate y*5 rotate y*240 translate <20,-54,20>  }
#declare Y = Y + 1;
#end
#declare Z = Z + 1;
#end
#declare i = 0;
#while (i < M)   
sphere { gemdisppos(),6,0.5 }
#declare i = i+1;
#end
hollow
texture { pigment { color Clear } } 
interior { media { emission White*0.05 } } 
} // blob
box { <-100,-100,20>,<100,100,100> pigment { Clear }}
box { <-100,-100,10>,<20-5,100,100> pigment { Clear }}
}


// * jewelery and colored gems
     
union {           
object { lower_chest translate y*-2  }
object { upper_chest translate <0,-5,4> rotate x*-120 translate <0,5,-4> translate y*-2 }
            
blob { threshold 0.3
#declare i=0;
#declare M=300;
// mega-necklace !
#declare Z = 0.08;
#while (i<M)
        sphere { <sin(i*Z)*4,abs(sin(i*Z*1.5))*3,cos(i*Z*1.25)*3>,0.3,0.5 }
#declare i = i+1;
#end
texture { Or }
}

#declare Z = 0;
#declare MX = 8;
#declare MZ = 6;
#while (Z <= MZ)
#declare X = 0;
#while (X <= MX)

#if (mod(X+Z,2) = 0 | sin(X*5+Z*Z) > 0)
union { gem(X*Z,<X*Z,X*X>,1.5) scale 0.5 translate <(X-MX/2)*4*2/MX,
			  mod(X+Z,2)*0.3+4/3,
			  (Z-MZ/2)*3*2/MZ> }
#else
union { gem(X*Z,<X*Z,Z*Z>,1.5) scale 0.5 translate <(X-MX/2)*4*2/MX,
		          mod(X+Z,2)*0.3-0.6+4/3,
			  (Z-MZ/2)*3*2/MZ> }

#end
#declare X = X + 1;
#end
#declare Z = Z + 1;
#end


scale 2
rotate y*-80
translate <50,-60,-15>
}



#end // FISHONLY

// la bete ! *********************************************************************************

#declare col  = rgb (<0.3,0.8,0.4>/2 + <.5,.5,.5>/2); 
       
#declare la_bete =       
union { 

#declare Z = 3;
#declare Skin = texture { pigment { col }  
		finish { ambient 0.5 diffuse 0.5 specular 0.5 roughness 0.01 }
//                normal { crackle 4 scale 4 }
                normal { bozo 1 scale 2 }
                }

blob { threshold 0.3
       sphere { <0,0,0>,22,1 scale <0.8,1,2> } // main truc
       sphere { <0,-10,0>,22,1 scale <0.8,0.5,2> } // main truc
       sphere { <0,0,0>,20,-20 scale <1,0.1,1> rotate x*-20 translate <0,-5,-20>} // bouche
       sphere { <0,0,50>,20,2 scale <0.2,1,1> } // queue
       sphere { <0,0,60>,20,-1 scale <0.5,1,1> }

// CORNES
#declare i = 0;
#declare MI = 5;
#while (i<MI)
#declare MX = 20;
#declare a = 0;
#while (a <= MX)
#declare p = a/MX;
#declare q = p*(1-p)*2;
	sphere { < 0,10+p*20*3/(3+i),-18+i*10+q*5-p*10*3/(3+i)>,5*(1.5-p*p)*3/(3+i),0.1 }
#declare a = a+1;
#end
#declare i = i+1;
#end
        texture { Skin } 
      } // fin blob

// jaw
intersection
{
sphere { <0,0,0>,20 
       scale <1,1,1> } // bouche
 
blob { threshold 0.3
       sphere { <0,0,0>,22,1 scale <0.75,1,2> } // main truc
       sphere { <0,-10,0>,22,1 scale <0.75,0.5,2> } // main truc
		 translate <0,5,20> 
		rotate x*20 }
texture { pigment {image_map {gif "jaw.gif" map_type 1}} finish { ambient 0.5 diffuse 1 } rotate y*-90 } 
rotate x*-20 
translate <0,-5,-20>
} // fin d'intersion jaw

// yeux
object { Eye1 rotate <-30,-30,0> translate <4,4,-27> }
object { Eye1 rotate <-30,-30,0> translate <-4,4,-27> }

translate <0,-5,24>
no_shadow
} // union Bete

// bulles
#declare Bulle = 
	sphere { <0.5,0,0>,0.5 texture { pigment { 
		//gradient x color_map {[0 color rgbf <1,1,1,1>][0.7 rgbf <1,1,1,1>][1 rgbf <1,1,1,0>]} 
		bozo color_map {[0 color Clear][0.3 color Clear][1 color White]} scale 0.5
		//Clear
		} 
	// CA c'est de l'astuce :)
        finish { ambient 1 } 
        //finish { ambient 1 diffuse 0 specular 1 roughness 0.05 }
        } interior { ior 1.5 }
        scale 2 translate x*-1 rotate z*(-45+180) rotate y*-30
        no_shadow
        }
	// je sais, l'ior n'est pas le bon, mais c'est plus joli comme ca :)
	 
#macro Bulles(X,Y,Z)
#if (FISHONLY = 0)
#declare i = 0;
#declare M = int(SURF-Y)/5;
#while (i <= M)
#declare i = i + 1;
#declare q = i/M;                                 
#declare pos = <X+sin(i*i*2)*5,SURF-q*(SURF-Y),cos(i*6)*5+Z>;
object { Bulle scale 1.2+sin(i*i)*.3 translate pos }
#end                      
#end
#end

// Sourcils    
#macro Sourcil_mac()
blob { threshold 0.4
#declare a = 0;
#declare a_max = 20;
#while (a <= a_max)
#declare p = a/a_max; 
#declare q = p*(1-p)*2;
#declare r = p*p*(1-p)*3;
#declare s = p*(1-p)*(1-p)*3;
sphere { pos_mac(),1.5+q*2,0.3 }
sphere { pos_mac(),1.5+q*2,0.3 scale <-1,1,1> }
#declare a = a+1;
#end             
texture { pigment { color col + (<0.5,0.5,0.5>-col)*-3 }  // saturation is bigger
         finish { ambient 0.3 diffuse 0.5 specular 0.5 }}
translate <0,-5,24>
}
#end

// poisson principal : Hugues
#macro pos_mac() < p*10,5+p*8-r*5+s*5,-27+(p-q)*4> #end
union { object { la_bete } Sourcil_mac() 
        rotate y*45 rotate x*-10 translate <0,-25,0> } 
#if (FISHONLY = 0)                    
        Bulles(-10,-20,0)

// poisson de gauche : Jean
#macro pos_mac() < p*10,5+p*2+q*6,-27+(p-q)*4> #end
union { object { la_bete } Sourcil_mac() scale <-1,1,1> 
        rotate y*-45 rotate x*-10 translate <20,15,80> } Bulles(30,20,80)

// poisson centre : Guillaume
#macro pos_mac() < p*10,8+p*4-q*4,-27+(p-q)*4> #end
union { object { la_bete } Sourcil_mac() scale <-1,1,1> 
        rotate y*-10 rotate x*-30 translate <40,20,20> } Bulles(45,25,20)

// poisson de droite : Pierre
#macro pos_mac() < p*10,8+sin(p*4*pi)+p*4,-27+(p-q)*4> #end
union { object { la_bete } Sourcil_mac() scale <-1,1,1> 
        rotate y*60 rotate x*20 translate <70,5,50> } Bulles(60,10,50)
#end
// la symetrie sert a changer la position du regard

//text { ttf "timrom.ttf" "Eric David" 0.01,0 scale 4
//    pigment { Yellow } rotate z*90 translate <-53,-58,-10>
//  }

/* --- EOF --- */