//global_settings { assumed_gamma 1 } // 1 = home 1.5 = work
//#include "colors.inc"
//
//camera {
//      //  location <-0, 1.5, -17>
//      //  look_at  <-3, 1.5, 0>
//
//       location <5, 31,2>
//       look_at  <5,  0,2>
//       }
//
//light_source {<-100, 500, -1000> White }
//light_source {< 0, 10, 100> White }
//
//background {Gray}
//plane {<0,1,0>,-0 pigment {Tan}}

/////////////////////
//  stack of books //
/////////////////////
#declare detail = 1;       //1=yes, 0=no books

#declare height = 84;     //bookcase height
#declare bc_width = 48;    //bookcase width
#declare space = 16;       //distance between shelves
#declare shelf_ht = 3;     //starting location of bottom shelf (above skirt)
#declare bookcount = 5;   //number of books to create
#declare num_covers = 22;  //number of unique book cover gif's
#declare counter = 0;      //counter for books
#declare num_shelves = 1;  //number of shelves the books will be on
#declare num_of_books = 0; //number of books per shelf
#declare R1 = seed(20);     //random number
#declare y_loc = 3;        //bottom shelf height for books
#declare cases = 0;         //counter for number of bookcases

#declare books_on_side = union {
union {
//////////////////////////////////////////
// creates several books with different //
//////////////////////////////////////////
#if (detail = 1) //if 1, show books, no books with any other number
    #while (counter < num_shelves)
     #declare x_loc = 0.75;  //starting location x
     #declare z_loc = 3;  //starting location z
      #while (num_of_books <bookcount)
          
         #declare covers = int(num_covers*rand(R1))+1; //randomly pick a book cover image
         #declare book_height = (10+(2*rand(R1)));     //random height between 10-12
         #declare book_width = 2+rand(R1);             //random width between 2-3
         #declare book_angle = rand(R1)*4;             //rendom book tilt angle between 0-5 degrees
        
         box {<0,0,0> <1,1,1> pigment {  
              image_map {gif concat("book test", str(covers,1,0), ".gif") map_type 0 interpolate 2}}
              scale <book_width,book_height,8> 
              #declare rotate_dist = 2-(4*rand(R1));
               rotate <rotate_dist,0,0>
              #declare x_loc=x_loc;
                #if (x_loc+book_width < bc_width-0.75)
                  translate <x_loc, y_loc, z_loc>
                #else
                  #declare num_of_books = bookcount;
                #end     
             }
          #declare x_loc = x_loc + book_width;
          #declare num_of_books = num_of_books + 1;
        #end
      #declare counter=counter+1;
      #declare num_of_books = 0;
      #declare y_loc=y_loc+space;
     #end  
   #end
 rotate <0,0,-90> translate <0,10.8,0> 
 }
 box {<11.5,-0.1,11.25> <0,0.01,3.2> translate <3,10.15,0>} 
}
//object {books_on_side }

