/* bunsenBurner.inc */
/* Date: Sat 23 Sep 2000 */
/* Author: Adrian Koh */
/* Purpose:
        IRTC, 1 Sep - 31 Oct 2000 Stills Round
        Topic: The Laboratory

        This file stores definitions for the following objects:
            BunsenBurnerObj
            BunsenFlameObj
            BunsenFlameFlareObj
*/

#include "globalVars.inc"

/* ========================================================================== */
#declare BunsenBurnerObj= union {
    // base
    difference {
        sphere {
            0, BunsenBaseRadius
        }
        box {
            <-BunsenBaseRadius - 0.1, -BunsenBaseRadius - 0.1, 
             -BunsenBaseRadius - 0.1>, 
            <BunsenBaseRadius + 0.1, 0, BunsenBaseRadius + 0.1> 
        }
        scale <1, 0.45, 1>
    }
    //top
    cylinder {
        <0, BunsenHeight - 2, 0>, <0, BunsenHeight, 0>, BunsenStemRadius + 0.1
        open
    }
    //stem
    cylinder {
        <0, 0.1, 0>, <0, BunsenHeight, 0>, BunsenStemRadius
        open
    }
    //ring near base
    cylinder {
        <0, 0.1, 0>, <0, 2, 0>, BunsenStemRadius + 0.1
        open
    }
}

/* -------------------------------------------------------------------------- */
#declare BunsenFlameObj = difference {
    sphere {
        0, 1.2
        hollow
        interior {
            media {
                emission rgb 10.0
                intervals 30
                samples 1, 30
                density {
                    spherical
                    //cubic_wave
                    color_map {
                        [0.0 color rgb <0, 0, 0>]
                        [0.2 color rgb <0, 0.01, 1>]
                        [0.3 color rgb <0, 0.05, 1>]
                        [0.5 color rgb <0, 0.05, 1>]
                        [0.6 color rgb <0, 0, 0>]
                        [0.7 color rgb <0, 0, 0>]
                    }
                    frequency 2
                    turbulence 0.15
                    omega 0.45
                    //lambda 6
                    //omega 0.7
                }
            }

        }
    }
    box {
        <-1.3, -1.3, -1.3>, <1.3, 0, 1.3>
    }
    pigment {
        color rgbt <1, 1, 1, 1>
        quick_color rgb <0, 1, 0>
    }
    scale <0.5, 1, 0.5>
}

/* -------------------------------------------------------------------------- */
#declare BunsenFlameFlareObj = difference {
    sphere {
        0, 1.2
        hollow
        interior {
            media {
                emission rgb 10.0
                intervals 30
                samples 1, 30
                density {
                    spherical
                    color_map {
                        [0.0 color rgb <0, 0, 0>]
                        [0.2 color rgb <0, 0.01, 1>]
                        [0.3 color rgb <0, 0.05, 1>]
                        [0.5 color rgb <0, 0.05, 1>]
                        [0.6 color rgb <0, 0, 0>]
                        [0.7 color rgb <0, 0, 0>]
                    }
                    frequency 2
                    //turbulence 2.0
                }
            }

        }
    }
    box {
        //<-1.3, -1.3, -1.3>, <1.3, 0, 1.3> // upsided down Flare 
        <-1.3, 0, -1.3>, <1.3, 1.3, 1.3>
    }
    pigment {
        color rgbt <1, 1, 1, 1>
        quick_color rgb <0, 1, 0>
    }
}

/* ========================================================================== */
