/* crucible.inc*/
/* Date: Sat 23 Sep 2000 */
/* Author: Adrian Koh */
/* Purpos:
        IRTC, 1 Sep - 31 Oct 2000 Stills Round
        Topic: The Laboratory

        This file stores definitions for the following objects:
            CrucibleObj
            CrucibleLiquidObj
            CrucibleSteamObj

*/

#include "globalVars.inc"

/* ========================================================================== */
#declare CrucibleObj = difference {
    sphere {
        0, CrucibleRadius
    }
    box {
        <-CrucibleRadius - 0.1, 0, -CrucibleRadius - 0.1>, 
        <CrucibleRadius + 0.1, CrucibleRadius + 0.1, CrucibleRadius + 0.1> 
    }
    sphere {
        0, CrucibleRadius - CrucibleEdgeWidth
        //translate <0, CrucibleRadius - 1, 0>
    }
    translate <0, CrucibleRadius, 0>
    scale <1, 0.7, 1>
}

/* -------------------------------------------------------------------------- */
#declare CrucibleLiquidObj = union {
    disc {
        0, y, CrucibleRadius - 0.1
        hollow
        texture {
            pigment  {
                //color rgbf <1, 0, 0, 1>
                color rgbf <1, 1, 1, 1>
                quick_color rgb <1, 0, 0>
            }
            normal {
                spotted, 0.75
                scale 0.5
            }
        }
        interior {
            ior 1.33
            // using media gives better results at edges of liquid compared to
            // just a filtered, red pigment
            media {
                absorption 5*<0, 1.0, 1.0>
                samples 2, 20
            }
        }

        translate <0, TripodHeight + 0.8*(CrucibleRadius*0.7), 0>
    }

    // bubbles on surface of water.
    #local currBubble = 0;
    #local Bubbles_R1 = seed(0);
    #local Bubbles_R2 = seed(1);
    #local Bubbles_R3 = seed(1);
    #while ( currBubble < 40 )
        #local dispUnitVector = 
            vrotate( <1, 0, 0>, <0, rand(Bubbles_R1)*360, 0> );
        #local BubbleRadius = rand(Bubbles_R3)*CrucibleRadius*0.1;

        sphere {
            0, BubbleRadius 
            pigment { color rgbt <1, 0.1, 0.1, 0.8> }
            translate <0, TripodHeight + 0.8*(CrucibleRadius*0.7), 0>
            translate rand(Bubbles_R2)*
                ( CrucibleRadius - CrucibleEdgeWidth - BubbleRadius)*
                dispUnitVector
        }

        #local currBubble = currBubble + 1;
    #end
}

/* -------------------------------------------------------------------------- */
#declare CrucibleSteamObj = difference {
    sphere {
        0, CrucibleRadius - CrucibleEdgeWidth
        hollow
    }
    box {
        <-CrucibleRadius, -CrucibleRadius, -CrucibleRadius>,
        <CrucibleRadius, 0, CrucibleRadius>
    }
    texture {
        pigment  {
            color rgbt <1, 1, 1, 1>
            quick_color rgb <1, 0, 0>
        }
    }
    interior {
        media {
            emission 1.0
            samples 2, 20
            density {
                spherical
                color_map {
                    [0.0 color rgb <0, 0, 0>]
                    [0.5 color rgb 0.25*<1.0, 0.3, 0.6>]
                    [0.5 color rgb <0, 0, 0>]
                    [1.0 color rgb <0, 0, 0>]
                }
                turbulence 0.8
            }
            //rotate <0, -180, 0>
            scale <3, 2, 3>
            matrix <    1, 0, 0,
                        1, 1, 0,
                        0, 0, 1,
                        0, 0, 0 >
                    
        }
    }
    translate <0, TripodHeight + 0.8*(CrucibleRadius*0.7), 0>
    translate <0, 0.01, 0> // to prevent coincidence with liquid surface
}

/* ========================================================================== */
