#include "colors.inc"
#include "textures.inc"
#include "glass.inc"
#include "woods.inc"
#include "metals.inc"

//background { color White }


light_source {
    <7.9,7,4>
    rgb <.5,.5,.1>
    fade_distance 8
    fade_power 1
} 

light_source {
    <7.9,7,-4>
    rgb <.5,.5,.1>
    fade_distance 8
    fade_power 1
} 

light_source {
    <-7.9,7,4>
    rgb <.5,.5,.1>
    fade_distance 8
    fade_power 1
} 

light_source {
    <-7.9,7,-4>
    rgb <.5,.5,.1>
    fade_distance 8
    fade_power 1
} 


camera {
    //location <0,20,-20>
    //look_at <0,2,5>
    location <-3,6,2>
    look_at <3,4.5,8>
}

#declare T_Floor = texture {
    normal {bumps .5 scale .05}
    pigment {color DarkBrown }
}



//***** THE ROOM *****


box { // Floor
    <-8,-1,-8>
    <8,0,8>
    texture { T_Floor }
}

box { //Left Wall
    <-8,-1,-8>
    <-9,10,8>
    normal { bumps .2 scale .001 }
    pigment { color Gray50 }
}

box { //Right Wall
    <8,-1,-8>
    <9,10,8>
    normal { bumps .2 scale .001 }
    pigment { color Gray50 }
}

box { //Back Wall
  <-8,-1,8>
  <8,10,9>
  normal { bumps .2 scale .001 }
  pigment {color Gray50 }
}

box { // Ceiling
  <-8,10,-8>
  <8,11,8>
  pigment { color Brown }
}

//* * * T H E   W A L L S * * *

#declare Rock= superellipsoid 
  { 
    <.6,.6>
    normal {bumps .5 scale .001 }
    scale <1,.8,.25>
  }

#declare colorrand=seed(002001);

#declare loc=-10;
#declare random = seed(100200);
#while (loc < 10)
  #declare loc= loc+(rand(random)*1);
  object { Rock pigment { rgb <rand(colorrand)*.2+.5,.6,.6> } translate <loc,1,8.15> }
  object { Rock pigment { rgb <rand(colorrand)*.2+.5,.6,.6> } rotate y*90 translate <-8.15,1,loc> }
  object { Rock pigment { rgb <rand(colorrand)*.2+.5,.6,.6> } rotate y*-90 translate <8.15,1,loc> }
  #declare loc = loc+1.7+(rand(random)*.05);
#end

#declare loc=-10;
#declare random = seed(100201);
#while (loc < 10)
  #declare loc= loc+(rand(random)*1);
  object { Rock pigment { rgb <rand(colorrand)*.2+.5,.6,.6> } translate <loc,2.6,8.15> }
  object { Rock pigment { rgb <rand(colorrand)*.2+.5,.6,.6> } rotate y*90 translate <-8.15,2.6,loc> }
  object { Rock pigment { rgb <rand(colorrand)*.2+.5,.6,.6> } rotate y*-90 translate <8.15,2.6,loc> }
  #declare loc = loc+1.7+(rand(random)*.05);
#end

#declare loc=-10;
#declare random = seed(100205);
#while (loc < 10)
  #declare loc= loc+(rand(random)*1);
  object { Rock pigment { rgb <rand(colorrand)*.2+.5,.6,.6> } translate <loc,4.2,8.15> }
  object { Rock pigment { rgb <rand(colorrand)*.2+.5,.6,.6> } rotate y*90 translate <-8.15,4.2,loc> }
  object { Rock pigment { rgb <rand(colorrand)*.2+.5,.6,.6> } rotate y*-90 translate <8.15,4.2,loc> }
  #declare loc = loc+1.7+(rand(random)*.05);
#end

#declare loc=-10;
#declare random = seed(100203);
#while (loc < 10)
  #declare loc= loc+(rand(random)*1);
  object { Rock pigment { rgb <rand(colorrand)*.2+.5,.6,.6> } translate <loc,5.8,8.15> }
  object { Rock pigment { rgb <rand(colorrand)*.2+.5,.6,.6> } rotate y*90 translate <-8.15,5.8,loc> }
  object { Rock pigment { rgb <rand(colorrand)*.2+.5,.6,.6> } rotate y*-90 translate <8.15,5.8,loc> }
  #declare loc = loc+1.7+(rand(random)*.05);
#end

#declare loc=-10;
#declare random = seed(100204);
#while (loc < 10)
  #declare loc= loc+(rand(random)*1);
  object { Rock pigment { rgb <rand(colorrand)*.2+.5,.6,.6> } translate <loc,7.4,8.15> }
  object { Rock pigment { rgb <rand(colorrand)*.2+.5,.6,.6> } rotate y*90 translate <-8.15,7.4,loc> }
  object { Rock pigment { rgb <rand(colorrand)*.2+.5,.6,.6> } rotate y*-90 translate <8.15,7.4,loc> }
  #declare loc = loc+1.7+(rand(random)*.05);
#end

#declare loc=-10;
#declare random = seed(100202);
#while (loc < 10 )
  #declare loc= loc+(rand(random)*1);
  object { Rock pigment { rgb <rand(colorrand)*.2+.5,.6,.6> } translate <loc,9,8.15> }
  object { Rock pigment { rgb <rand(colorrand)*.2+.5,.6,.6> } rotate y*90 translate <-8.15,9,loc> }
  object { Rock pigment { rgb <rand(colorrand)*.2+.5,.6,.6> } rotate y*-90 translate <8.15,9,loc> }
  #declare loc = loc+1.7+(rand(random)*.05);
#end

// * * * E N D   W A L L S * * *


// * * * T H E   B E N C H * * *

#declare WoodGrain = 
pigment {
    wood
    rotate y*90
    turbulence 0.05
    scale .5
    color_map {
        [0.1 rgb <0.888, 0.600, 0.3>]
        [0.9 rgb <0.600, 0.400, 0.2>]
    }
}


#declare Loc=7.9 // Table Top
#while ( Loc >= 4.5 )
  box { 
  <-8,4.5,Loc>
  <8,4.4,Loc-.45>
  texture { T_Wood15 rotate y*90 } 
  texture {
    pigment {
        bozo
        scale .5
        translate Loc
        turbulence 1
        color_map {
            [0 rgb .2 transmit .6]
            [.4 rgb .2 transmit .6]
            [.41 rgbt 1]
            [1 rgbt 1]
        }
    }
  }  
}
  #declare Loc=Loc-.5
#end

box {
  <8,4.4,4.5>
  <7.75,0,4.75>
  texture { T_Wood15 rotate x*90 }
}

box {
  <7.8,4.4,7.8>
  <7.55,0,7.55>
  texture { T_Wood15 rotate x*90 }
}
  



//* * * E N D   B E N C H

//* * * T U B E S * * *

#declare Bend = difference { //All tube bends done with this Object
  torus {
    .2,.1
    hollow
  }
  union { 
    box {
      <-.3,-.1,-.3>
      <.3,.1,0>
    }    
    box {
      <.3,-.1,.3>
      <0,.1,-0.1>
    }
  }
}

// From Left to Right

#declare Bend = difference { //All tube bends done with this Object
  torus {
    .1,.05
    hollow
  }
  union { 
    box {
      <-.15,-.05,-.15>
      <.15,.05,0>
    }    
    box {
      <.15,-.05,.15>
      <0,.05,-0.05>
    }
  }
}

merge { // Left Segment
    cone { 
        <-1.6,6.3,6>,.05
        <-1.6,6.4,6>,.2
        open
    }
    cylinder { 
        <-1.6,6.2,6>
        <-1.6,6.3,6>,.05
        open
    }
    texture { T_Old_Glass }
}


object { //Left Upper Bend
  Bend  
  texture { T_Old_Glass }
  rotate x*90
  translate <-1.5,6.2,6>
}

cylinder { //Upper Straight Tube
  <-1.5,6.1,6>
  <-.5,6.1,6>,.05
  open
  texture { T_Old_Glass }
}

merge { //Middle Segment
    cone { 
        <-1.2,6.3,6>,.05
        <-1.2,6.4,6>,.2
        open
    }
    cylinder { 
        <-1.2,6.1,6>
        <-1.2,6.3,6>,.05
        open
    }
    texture { T_Old_Glass }
}

merge {
    cone { 
        <-.8,6.3,6>,.05
        <-.8,6.4,6>,.2
        open
    }
    cylinder { //Right Segment
        <-.8,6.1,6>
        <-.8,6.3,6>,.05
        open
    }
    texture { T_Old_Glass }
}

object { //Right Upper Bend
  Bend
  texture { T_Old_Glass }
  rotate <-90,0,-90>
  translate <-.5,6,6>
}

cylinder { //Lower to Upper Connector Segment
  <-.4,6,6>
  <-.4,5.5,6>,.05
  open
  texture { T_Old_Glass }
}

object { //Left Lower Bend
  Bend
  texture { T_Old_Glass }
  rotate <-90,0,90>
  translate <-.3,5.5,6>
}

cylinder { //Lower Straight Tube
  <-.3,5.4,6>
  <0,5.4,6>,.05
  open
  texture { T_Old_Glass }
}

merge { 
  sphere {<0,1,0>,.3 }
  cylinder { <0,1,0> <0,2.3,0>,.3 open }
  scale y*.5
  texture { T_Old_Glass }
  translate <.3,4.8,6>
}  

cylinder { //Upper Segment
  <.6,5.8,6>
  <1,5.8,6>,.05
  open
  texture { T_Old_Glass }
}

#declare coil_point1 = <0, 0, 0>;
#declare coil_point2 = <1, 0, 0>;
#declare coil_revolutions = 5;
#declare coil_radius = .2;
#declare coil_thickness = .05;

object {
    #include "Coil.inc" 
    pigment { rgbt <1,1,1,1> }
    rotate x*-90
    translate <1,6,6>
}

union {
    merge {
        cylinder { //Coil Cover
            <-.1,6,6>
            <2.1,6,6>,.3
            open
        }        
        sphere {
            <-.1,6,6>,.3
        }
        sphere {
            <2.1,6,6>,.3        
        }
        texture { T_Old_Glass }
    }
    merge {
        cylinder { //Coil Cover
            <-.05,6,6>
            <2.05,6,6>,.27
        }        
        sphere {
            <-.05,6,6>,.27
        }
        sphere {
            <2.05,6,6>,.27        
        }
        pigment { rgbt <.2,1,1,.5> }
    }
    scale x*.4
    translate x*1.1    
}

merge { //Cooling System Tube
    cone { 
        <1.8,7,6>,.05
        <1.8,7.2,6>,.2
        open
    }
    cylinder { 
        <1.8,6,6>
        <1.8,7,6>,.05
        open
    }
    texture { T_Old_Glass }
}

cylinder { // Cooling System Lower Tube
  <1.2,6,6>
  <1.2,4.5,6>,.05
  open
  texture { T_Old_Glass }
}    

merge { 
  sphere {<0,1,0>,.3 }
  cylinder { <0,1,0> <0,2.3,0>,.3 open }
  scale <.6,.35,.5>
  texture { T_Old_Glass }
  
  translate <1.2,4.25,6>
}  


cylinder { //Upper Segment
  <2.6,5.8,6>
  <2,5.8,6>,.05
  open
  texture { T_Old_Glass }
}

object { //Right Upper Bend
  Bend
  texture { T_Old_Glass }
  rotate <90,0,180>
  translate <2.6,5.7,6>
}

cylinder { //Right Most Connector Segment
  <2.7,5.7,6>
  <2.7,4.7,6>,.05
  open
  texture { T_Old_Glass }
} 

merge { 
  sphere {<0,1,0>,.3 }
  cylinder { <0,1,0> <0,2.3,0>,.3 open }
  scale <1,.5,1>
  texture { T_Old_Glass }
  translate <2.7,4,6>
}  


//* * * E N D   T U B E S

//* * * T U B E   S U P P O R T S

#declare Tall_Support = merge { // Left Segment
    cone { 
        <-1.4,4.5,6>,.18
        <-1.4,4.55,6>,.03
    }
    cylinder { 
        <-1.4,4.55,6>
        <-1.4,6.048,6>,.03
        open
    }
    cylinder { 
        <-1.37,6.1,6>
        <-1.43,6.1,6>,.052
        open
    }
    pigment { P_Brass3 }
    finish { F_MetalB }
}

object {
    Tall_Support
}

merge { // Short Support
    cone { 
        <-.2,4.5,6>,.18
        <-.20,4.55,6>,.03
    }
    cylinder { 
        <-.2,4.55,6>
        <-.2,5.348,6>,.03
        open
    }
    cylinder { 
        <-.17,5.4,6>
        <-.23,5.4,6>,.052
        open
    }
    pigment { P_Brass3 }
    finish { F_MetalB }
}

merge { // Short Support
    cone { 
        <.7,4.5,6>,.18
        <.7,4.55,6>,.03
    }
    cylinder { 
        <.7,4.55,6>
        <.7,5.748,6>,.03
        open
    }
    cylinder { 
        <.67,5.8,6>
        <.73,5.8,6>,.052
        open
    }
    pigment { P_Brass3 }
    finish { F_MetalB }
}

merge { // Short Support
    cone { 
        <2.3,4.5,6>,.18
        <2.3,4.55,6>,.03
    }
    cylinder { 
        <2.3,4.55,6>
        <2.3,5.748,6>,.03
        open
    }
    cylinder { 
        <2.27,5.8,6>
        <2.33,5.8,6>,.052
        open
    }
    pigment { P_Brass3 }
    finish { F_MetalB }
}


union {
    difference {
        cylinder {
          <0,5.1,0>
          <0,5.13,0>,.35
        }
        cylinder { 
            <0,5.099,0>
            <0,5.131,0>,.30
        }
        
    }
    cylinder {
        <.5,4.5,0>
        <.34,5.1,0>,.03
        rotate y*30
    }
    cylinder {
        <.5,4.5,0>
        <.34,5.1,0>,.03
        rotate y*150
    }
    cylinder {
        <.5,4.5,0>
        <.34,5.1,0>,.03
        rotate y*-90
    }
    texture { Silver1 }
    translate <.3,0,6>
}

disc {
    <.3,5.132,6>,y,.3
    pigment { color rgb .6 transmit .2 }
        
} 

// E N D   S U P P O R T S

// B U R N E R 


merge {
    sphere {
        <.3,4.6,6>,.2
    }
    cylinder {
        <.3,4.7,6>
        <.3,4.9,6>,.05
    }
    cylinder {
        <.3,4.8,6>,
        <.3,5,6>,.04
        pigment { color Black }
    }
    pigment { color Gray }
}
    
// B A C K   S H E L F


union {
    box { <8,4.5,7.9>,<7.03,9,7.8> }
    box { <7,4.5,7.9>,<6.03,9,7.8> }
    box { <6,4.5,7.9>,<5.03,9,7.8> }
    box { <5,4.5,7.9>,<4.03,9,7.8> }
    box { <7.8,4.5,7.9>,<7.94,9,7>}
    box { <4,4.5,7.9>,<4.06,9,7>}
    texture { T_Wood15 rotate x*90 }
}

union {
    box { <7.8,8.9,7.9>, <4,9,7> }
    box { <7.8,7.4,7.9>, <4,7.5,7> }
    box { <7.8,5.9,7.9>, <4,6,7> }
    box { <4,6.4,7.9>,<-8,6.5,7.3> }
    box { <4,7.4,7.9>,<-8,7.5,7.3> }
    texture { T_Wood15 rotate y*90}
}
    
// E N D   O F   S H E L V E S

// B O T T L E S

#declare Bottle_1= 
merge {
  sphere {
    <0,.5,0>,.5
  }
  cone {
    <0,.5,0>,.1
    <0,1.5,0>,.2
  }
}

#declare Bottle_2 = 
merge {
  sphere {
    <0,.5,0>,.5
    scale <1,1.25,1>
  }
  cone {
    <0,.5,0>,.1
    <0,1.5,0>,.2
  }
}

#declare Bottle_4 = 
lathe {
    quadratic_spline
    4,
    <0,0>, <.5,.1>, <.15,.6>, <.16,1>//, <.1,.7>//, <.2,.6>
}

#declare Bottle_6 = lathe {
    quadratic_spline
    5,
    <0,0>, <.4,.1>, <.4,.75>, <.3,.85>, <.3,1>//, <.2,.6>
} 


object {
    Bottle_1
    texture { T_Glass1 }
    scale .5
    translate <3.6,7.5,7.75>
}
sphere {
    <0,.5,0>,.5
    pigment { color Aquamarine transmit .5 }
    scale .48
    translate <3.6,7.5,7.75>
  }

object {
    Bottle_2
    texture { T_Glass3 }
    scale .5
    translate <2.9,7.5,7.75>
}
sphere {
    <0,.5,0>,.5
    scale <1,1.25,1>
    pigment { color BlueViolet transmit .75 }
    scale .48
    translate <2.9,7.5,7.75>
}

object {
    Bottle_4
    texture { T_Glass4 }
    scale .7
    translate <2.1,7.5,7.75>
}
        
lathe {
    quadratic_spline
    4,
    <0,0>, <.5,.1>, <.15,.6>, <.16,.6>
    pigment { color Brown transmit .75 }
    scale .68
    translate <2.1,7.5,7.75>
}


object {
    Bottle_2
    texture { T_Old_Glass }
    scale .5
    translate <1.4,7.5,7.75>
}
sphere {
    <0,.5,0>,.5
    scale <1,1.25,1>
    pigment { color DustyRose transmit .1 }
    scale .48
    translate <1.4,7.5,7.75>
}

object {
    Bottle_6
    texture { T_Winebottle_Glass }
    scale .5
    translate <.7,7.5,7.75>
}
        
lathe {
    quadratic_spline
    5,
    <0,0>, <.4,.1>, <.4,.75>, <.3,.85>, <.3,.6>
    pigment { color Coral transmit .85 }
    scale .48
    translate <.7,7.5,7.75>
}

object {
    Bottle_1
    texture { T_Beerbottle_Glass }
    scale .5
    translate <.1,7.5,7.75>
}
sphere {
    <0,.5,0>,.5
    pigment { color CornflowerBlue transmit .85 }
    scale .48
    translate <.1,7.5,7.75>
  }
  
object {
    Bottle_1
    texture { T_Ruby_Glass }
    scale .5
    translate <-.6,7.5,7.75>
}
sphere {
    <0,.5,0>,.5
    pigment { color DarkGreen transmit .85 }
    scale .48
    translate <-.6,7.5,7.75>
  }

object {
    Bottle_2
    texture { T_Green_Glass }
    scale .5
    translate <3.6,6.5,7.75>
}
sphere {
    <0,.5,0>,.5
    pigment { color DarkOliveGreen transmit .85 }
    scale .48
    translate <3.6,6.5,7.75>
  }

object {
    Bottle_4
    texture { T_Dark_Green_Glass }
    scale .7
    translate <2.9,6.5,7.75>
}
        
lathe {
    quadratic_spline
    4,
    <0,0>, <.5,.1>, <.15,.6>, <.16,.5>
    pigment { color DarkOrchid transmit .75 }
    scale .68
    translate <2.9,6.5,7.75>
}
  
object {
    Bottle_6
    texture { T_Yellow_Glass }
    scale .6
    translate <2.2,6.5,7.75>
}
        
lathe {
    quadratic_spline
    5,
    <0,0>, <.4,.1>, <.4,.75>, <.3,.85>, <.3,.6>
    pigment { color DarkSlateBlue transmit .85 }
    scale .58
    translate <2.2,6.5,7.75>
}

object {
    Bottle_6
    texture { T_Orange_Glass }
    scale .6
    translate <1.6,6.5,7.75>
}
        
lathe {
    quadratic_spline
    5,
    <0,0>, <.4,.1>, <.4,.75>, <.3,.85>, <.3,.6>
    pigment { color DarkSlateGray transmit .85 }
    scale .58
    translate <1.6,6.5,7.75>
}  

object {
    Bottle_2
    texture { T_Vicksbottle_Glass }
    scale .5
    translate <1,6.5,7.75>
}
sphere {
    <0,.5,0>,.5
    pigment { color DarkTurquoise transmit .85 }
    scale .48
    translate <1,6.5,7.75>
  }
  
object {
    Bottle_1
    texture { T_Glass1 }
    scale .5
    translate <.4,6.5,7.75>
}
sphere {
    <0,.5,0>,.5
    pigment { color Firebrick transmit .85 }
    scale .48
    translate <.4,6.5,7.75>
  }  
  
object {
    Bottle_1
    texture { T_Glass3 }
    scale .5
    translate <-.2,6.5,7.75>
}
sphere {
    <0,.5,0>,.5
    pigment { color ForestGreen transmit .5 }
    scale .48
    translate <-.2,6.5,7.75>
  }    
  
object {
    Bottle_4
    texture { T_Old_Glass }
    scale <.5,.7,.5>
    translate <-.8,6.5,7.75>
}
        
lathe {
    quadratic_spline
    4,
    <0,0>, <.5,.1>, <.15,.6>, <.16,.5>
    pigment { color Gold transmit .75 }
    scale <.48,.68,.48>
    translate <-.8,6.5,7.75>
}  

object {
    Bottle_6
    texture { T_Glass3 }
    scale .6
    translate <-1.3,6.5,7.75>
}
        
lathe {
    quadratic_spline
    5,
    <0,0>, <.4,.1>, <.4,.75>, <.3,.85>, <.3,.6>
    pigment { color Goldenrod transmit .85 }
    scale .58
    translate <-1.3,6.5,7.75>
}  

object {
    Bottle_2
    texture { T_Winebottle_Glass }
    scale .5
    translate <-1.8,6.5,7.75>
}
sphere {
    <0,.5,0>,.5
    pigment { color GreenYellow transmit .85 }
    scale .48
    translate <-1.8,6.5,7.75>
  }
  
// E N D   O F   B O T T L E S

// B O O K S

#declare Book = union {
    cylinder {
      <.42,0,0>
      <.42,1,0>,.07
    }
    box {
        <-.38,0,-.07>
        <.38,1,.07>
    }
    normal { crackle .15 scale .05 }
}
    
object {
    Book
    rotate y*90
    translate <7.7,6,7.5>
    pigment { color Brown }
}  
      
object {
    Book
    scale 1.2
    rotate y*90
    translate <7.5,6,7.5>
    pigment { color Gray }
}  

object {
    Book
    rotate y*90
    translate <7.4,6,7.5>
    pigment { color Tan }
}    

object {
    Book
    scale <1,1.2,1.6>
    rotate y*90
    translate <7.2,6,7.5>
    pigment { color IndianRed }
}    

object {
    Book
    scale <1,1.3,1.4>
    rotate y*90
    translate <6.7,6,7.5>
    pigment { color Maroon }
}    

object {
    Book
    scale z*1.2
    rotate y*90
    translate <6.4,6,7.5>
    pigment { color Gray10 }
}    

object {
    Book
    scale z*1.2
    rotate y*90
    
    translate <6.2,6,7.5>
    pigment { color DarkBrown }
}    

object {
    Book
    scale z*2
    rotate y*90
    translate <5.9,6,7.5>
    pigment { color Gray20 }
}    

