//  Persistence of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 5 lights, 17 materials and 172 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.2 For Windows Copyright (c) 1993-2000 Lutz + Kretzschmar
//

//  Date : 10/25/2000    (25.10.2000)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/* // Scene Comment

This scene was created with Moray For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 20
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera StdCam
  location  <      5.035,      -2.544,       2.065>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.38225,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         54.75558    // Vertical      41.077
  look_at   <     -4.859,       1.405,      -0.397>
}

//    Other cameras are commented out.
/*
camera {  //  Camera TestMCamera
  location  <    -11.873,     -12.124,       0.674>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.37370,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         50.00000    // Vertical      37.500
  look_at   <      1.346,       1.465,      -0.003>
}

*/

//
// *******  L I G H T S *******
//

light_source {   // Light003
  <0.0, 0.0, 0.0>
  color rgb <0.686, 0.857, 1.000>*0.1000
  scale 10.0
  translate  <1727.874766, 2801.214096, -34.250093>
}

#declare Light002 = light_source {
  <0.0, 0.0, 0.0>
  color rgb <0.514, 0.657, 0.543>*0.9999
  fade_distance  0.2
  fade_power 2.0
  translate  <3.750304, -0.037132, 0.0>
}

#declare Light001 = light_source {
  <0.0, 0.0, 0.0>
  color rgb <0.514, 0.657, 0.543>*0.9999
  fade_distance  0.2
  fade_power 2.0
  translate  <3.750304, -0.037132, 0.0>
}

light_source {   // sun
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>*6.4277
  scale 100.0
  rotate 12.965935*y
  translate  <-176752.686529, 144416.535123, -70105.569084>
}

#declare fusionMlight = light_source {
  <0.0, 0.0, 0.0>
  color rgb <0.000, 0.643, 0.929>*2.8567
  shadowless
  fade_distance  0.6
  fade_power 1.5
}


//  Moray V3.2 For Windows Copyright (c) 1993-2000 Lutz + Kretzschmar
//

//
// ********  MATERIALS  *******
//

#include "antimatt.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#declare lifeMmodule = union {
  sphere { // Sphere009
    <0,0,0>,1
    scale <2.0, 2.0, 1.0>
    translate  6.012344*z
  }
  cone { // Cone001
    <0,0,0>, 0.5, <0,0,1>, 1.0
    scale 2.0
    translate  -2.000324*z
  }
  cylinder { // Cylndr052
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 6.0>
  }
  material {
    spaceMmatMlightMsMtex
  }
  translate  <0.0, 10.372182, 2.386968>
}
#declare lifeMmodMgroup = union {
  object { // lifeMmodule2->life-module
    lifeMmodule
    rotate <-180.0, 60.0, -180.0>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // lifeMmodule1->life-module
    lifeMmodule
    rotate <-180.0, -60.0, -180.0>
  }
  object { lifeMmodule }
  translate  <0.0, 29.594812, 0.0>
}
#declare panel = union {
  box { // Cube024
    <-1, -1, -1>, <1, 1, 1>
    material {
      black
    }
    scale <1.05, 2.1, 0.02>
  }
  box { // Cube023
    <-1, -1, -1>, <1, 1, 1>
    material {
      solarMpannelMtex
    }
    scale <1.0, 2.0, 0.05>
  }
  cylinder { // Cylndr049
    <0,0,1>, <0,0,0>, 1 
    material {
      spaceMmatMdarkMtex
    }
    scale <0.1, 0.1, 1.0>
    rotate <90.0, -31.345366, 0.0>
    translate  -2.025118*y
  }
  rotate -10.0*y
}
#declare panel6 = object {
  object { // panel6->panel
    panel
    rotate <0.0, 20.0, 180.0>
    translate  -6.182544*y
  }
}
#declare panelMblock = union {
  cylinder { // Cylndr050
    <0,0,1>, <0,0,0>, 1 
    material {
      spaceMmatMlightMcMtex
    }
    scale <0.2, 0.1, 20.0>
    rotate <180.0, 90.0, 180.0>
    translate  <-0.935369, -3.094291, -0.011419>
  }
  object { // panel11->panel6
    panel6
    rotate <0.0, 0.0, 0.0>
    translate  <15.0, 0.0, 0.0>
  }
  object { // panel10->panel6
    panel6
    rotate <0.0, 0.0, 0.0>
    translate  <12.0, 0.0, 0.0>
  }
  object { // panel9->panel6
    panel6
    rotate <0.0, 0.0, 0.0>
    translate  <9.0, 0.0, 0.0>
  }
  object { // panel8->panel6
    panel6
    rotate <0.0, 0.0, 0.0>
    translate  <6.0, 0.0, 0.0>
  }
  object { // panel7->panel6
    panel6
    rotate <0.0, 0.0, 0.0>
    translate  <3.0, 0.0, 0.0>
  }
  object { panel6 }
  object { // panel5->panel
    panel
    rotate 0.0*y
    translate  15.0*x
  }
  object { // panel4->panel
    panel
    rotate 0.0*y
    translate  12.0*x
  }
  object { // panel3->panel
    panel
    rotate 0.0*y
    translate  9.0*x
  }
  object { // panel2->panel
    panel
    rotate 0.0*y
    translate  6.0*x
  }
  object { // panel1->panel
    panel
    rotate 0.0*y
    translate  3.0*x
  }
  object { panel }
  scale <1.5, 1.5, 1.0>
  translate  <-29.267431, 3.0, 0.346739>
}
#declare panelMblock2 = object {
  object { // panelMblock2->panel-block
    panelMblock
    rotate <180.0, 0.0, 180.0>
    translate  0.664483*z
  }
}
#declare lifeMmodule3 = union {
  cone { // Cone002
    <0,0,0>, 0.5, <0,0,1>, 1.0
    scale <2.0, 2.0, 1.0>
    translate  <0.0, 0.0, -0.981035>
  }
  cylinder { // Cylndr053
    <0,0,1>, <0,0,0>, 1 
    scale <2.0, 2.0, 6.0>
  }
  cone { // Cone003
    <0,0,0>, 0.5, <0,0,1>, 1.0
    scale <2.0, 2.0, 1.0>
    rotate <180.0, 0.0, -0.0>
    translate  <0.0, 0.000116, 7.000332>
  }
  material {
    spaceMmatMlightMsMtex
  }
  scale <1.5, 1.5, 2.0>
  rotate 90.0*x
  translate  <0.0, -37.622733, 0.00884>
}
#declare lifeMmodule4 = object {
  object { // lifeMmodule4->life-module3
    lifeMmodule3
    translate  -21.0*y
  }
}
#declare lifeMmodule5 = object {
  object { // lifeMmodule5->life-module4
    lifeMmodule4
    translate  -22.0*y
  }
}
#declare wing = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-6.919600, -0.132682, 0.059428>, <-4.664716, -1.521320, 0.130556>, <-0.708144, -1.521320, 0.201685>, <4.417628, -0.015635, 0.059428>, 
      <-6.976509, -0.042713, 7.315056>, <-4.625482, -0.115739, 7.689446>, <-0.739544, -0.115739, 1.167249>, <4.417628, -0.005033, 1.024993>, 
      <-6.976509, 0.028715, 7.260114>, <-4.625482, 0.077808, 7.634503>, <-0.739544, 0.077808, 1.112306>, <4.417628, 0.003384, 1.024993>, 
      <-6.919600, 0.101174, 0.000000>, <-4.696116, 0.336950, 0.071128>, <-0.739544, 0.336950, 0.142257>, <4.417628, 0.011922, 0.000000>
    }
  }
  material {
    spaceMmatMlightMtex
  }
  scale 0.4
  rotate <-90.0, 0.0, 90.0>
  translate  <-0.581142, -1.283355, 0.0>
}


#declare engine = union {
  cylinder { // Cylndr013
    <0,0,1>, <0,0,0>, 1 
    material {
      black
    }
    scale <0.16, 0.16, 0.5>
    translate  0.562514*z
  }
  cylinder { // Cylndr012
    <0,0,1>, <0,0,0>, 1 
    material {
      spaceMmatMdarkMtex
    }
    scale <0.2, 0.2, 1.0>
  }
  scale 1.2
  rotate -90.0*x
  translate  0.184103*y
}
#declare engineMgroup = union {
  object { // engine3->engine
    engine
    scale 1.5
    rotate -90.0*x
    translate  0.65459*z
  }
  object { // engine1->engine
    engine
    rotate -90.0*z
  }
  object { engine }
}
#declare engineMcarrier = union {
  sphere { // Sphere005
    <0,0,0>,1
    translate  8.0*z
  }
  sphere { // Sphere004
    <0,0,0>,1
  }
  cylinder { // Cylndr011
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 8.0>
  }
  material {
    spaceMmatMlightMcMtex
  }
}
#declare engineMsystem = union {
  object { // engineMgroup1->engine-group
    engineMgroup
    rotate <-0.0, -180.0, -90.0>
    translate  8.0*z
  }
  object { engineMgroup }
  object { engineMcarrier }
  rotate <90.0, 0.0, 90.0>
  translate  <-4.0, 2.5, 1.517784>
}
#declare engineMsystem2 = object {
  object { // engineMsystem2->engine-system
    engineMsystem
    rotate <180.0, 0.0, 180.0>
  }
}
#declare lightsystem = union {
  cylinder { // Cylndr029
    <0,0,1>, <0,0,0>, 1 
    material {
      lightMpointMtex
    }
    scale <0.3, 0.3, 1.0>
    translate  0.064877*z
  }
  cylinder { // Cylndr028
    <0,0,1>, <0,0,0>, 1 
    material {
      spaceMmatMlightMcMtex
    }
    scale <0.4, 0.4, 1.0>
  }
  scale <1.0, 1.0, 3.0>
  rotate <180.0, 85.865936, 180.0>
  translate  <2.145446, 1.502895, 2.018485>
}


#declare Cube006 = object {
  box { // Cube006
    <-1, -1, -1>, <1, 1, 1>
    rotate 0.0*y
    translate  <1.278827, 0.0, 0.959762>
    material {
      spaceMmatMdarkMtex
    }
    scale <1.5, 0.2, 0.2>
    rotate <0.0, 40.858334, 0.0>
    translate  <0.080334, -0.0, 0.877378>
  }
}
#declare shieldMstructM01 = union {
  object { Cube006 }
  cylinder { // Cylndr009
    <0,0,1>, <0,0,0>, 1 
    material {
      outerMshieldMtex
    }
  }
  object { // Cube007->Cube006
    Cube006
    rotate <-0.0, 0.0, -72.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Cube008->Cube006
    Cube006
    rotate <-0.0, 0.0, -144.0>
    translate  <0.0, -0.0, 0.0>
  }
  object { // Cube009->Cube006
    Cube006
    rotate <-0.0, 0.0, 144.0>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // Cube010->Cube006
    Cube006
    rotate <-0.0, 0.0, 72.0>
    translate  <-0.0, 0.0, 0.0>
  }
  scale 0.3
  rotate <-90.0, 17.645134, 0.0>
  translate  0.955316*y
}
#declare CSG002 = union {
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    material {
      innerMshieldMtex
    }
    translate  1.7*z
  }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    material {
      innerMshieldMtex
    }
    rotate -72.0*y
    translate  <-1.616796, 0.0, 0.525329>
  }
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    material {
      innerMshieldMtex
    }
    rotate <180.0, -36.0, 180.0>
    translate  <-0.999235, 0.0, -1.375329>
  }
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    material {
      innerMshieldMtex
    }
    rotate <180.0, 36.0, 180.0>
    translate  <0.999235, 0.0, -1.375329>
  }
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    material {
      innerMshieldMtex
    }
    rotate 72.0*y
    translate  <1.616796, 0.0, 0.525329>
  }
  sphere { // Sphere002
    <0,0,0>,1
    material {
      innerMshieldMtex
    }
    scale 1.1
    translate  -0.2*y
  }
}
#declare CSG001 = difference {
  sphere { // Sphere001
    <0,0,0>,1
    material {
      outerMshieldMtex
    }
  }
  object { CSG002 }
}
#declare shield = union {
  object { shieldMstructM01 }
  object { CSG001 }
  translate  1.0*y
}
#declare Cylndr003 = object {
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    material {
      outerMshieldMtex
    }
    scale <0.05, 0.05, 2.5>
    translate  <-0.305707, 0.0, 0.618105>
  }
}
#declare Torus001 = object {
  torus { // Torus001
    1.9, 0.1  rotate -x*90
    material {
      innerMshieldMtex
    }
    scale 0.18
    translate  1.280837*z
  }
}
#declare LaserM01 = union {
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    material {
      innerMshieldMtex
    }
    scale <0.2, 0.2, 2.0>
    translate  0.487672*z
  }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    material {
      fusionMglowMtexMcyl
    }
    hollow
    scale <0.11, 0.11, 2.0>
    translate  -0.919618*z
  }
  object { Cylndr003 }
  object { // Cylndr004->Cylndr003
    Cylndr003
    rotate -60.0*z
    translate  <-0.0, -0.5295, 0.0>
  }
  object { // Cylndr008->Cylndr003
    Cylndr003
    rotate 60.0*z
    translate  <0.0, 0.5295, 0.0>
  }
  object { // Cylndr007->Cylndr003
    Cylndr003
    rotate 120.0*z
    translate  <0.0, 0.5295, 0.0>
  }
  object { // Cylndr006->Cylndr003
    Cylndr003
    rotate -180.0*z
    translate  -0.0*y
  }
  object { // Cylndr005->Cylndr003
    Cylndr003
    rotate -120.0*z
    translate  <-0.0, -0.5295, 0.0>
  }
  object { Torus001 }
  object { // Torus004->Torus001
    Torus001
    translate  1.170676*z
  }
  object { // Torus002->Torus001
    Torus001
    translate  0.390225*z
  }
  object { // Torus003->Torus001
    Torus001
    translate  0.780451*z
  }
  cylinder { // Cylndr010
    <0,0,1>, <0,0,0>, 1 
    material {
      fusionMcoreMtex
    }
    scale <0.033333, 0.033333, 2.5>
    translate  -1.01496*z
  }
  translate  0.993611*z
  scale 0.6
  rotate <7.265411, -55.818413, -62.702446>
  translate  0.012809*z
}
#declare LaserM06 = object {
  object { // LaserM06->Laser-01
    LaserM01
    rotate <0.0, -89.368958, -4.074439>
    translate  <-0.0, 0.0, 0.0>
  }
}




//
// ********  OBJECTS  *******
//



#declare shuttleMengine2 = union {
  cylinder { // Cylndr060
    <0,0,1>, <0,0,0>, 1 
    material {
      black
    }
    scale <0.4, 0.4, 0.8>
    translate  0.254043*z
  }
  cylinder { // Cylndr061
    <0,0,1>, <0,0,0>, 1 
    material {
      spaceMmatMdarkMtex
    }
    scale <0.5, 0.5, 1.0>
  }
  scale 0.7
  rotate 90.0*x
  translate  <0.347626, -4.432613, -0.195883>
}
#declare shuttleMengine1 = union {
  cylinder { // Cylndr058
    <0,0,1>, <0,0,0>, 1 
    material {
      black
    }
    scale <0.4, 0.4, 0.8>
    translate  0.254043*z
  }
  cylinder { // Cylndr059
    <0,0,1>, <0,0,0>, 1 
    material {
      spaceMmatMdarkMtex
    }
    scale <0.5, 0.5, 1.0>
  }
  scale 0.7
  rotate 90.0*x
  translate  <-0.354721, -4.432613, -0.188789>
}
#declare shuttleMengine = union {
  cylinder { // Cylndr057
    <0,0,1>, <0,0,0>, 1 
    material {
      black
    }
    scale <0.4, 0.4, 0.8>
    translate  0.254043*z
  }
  cylinder { // Cylndr056
    <0,0,1>, <0,0,0>, 1 
    material {
      spaceMmatMdarkMtex
    }
    scale <0.5, 0.5, 1.0>
  }
  scale 0.7
  rotate 90.0*x
  translate  <0.0, -4.432613, 0.428425>
}
#declare shuttleMbody1 = union {
  cylinder { // Cylndr055
    <0,0,1>, <0,0,0>, 1 
    material {
      spaceMmatMlightMtex
    }
    scale <1.0, 1.0, 5.0>
    rotate -90.0*x
    translate  -5.017261*y
  }
  sphere { // Sphere011
    <0,0,0>,1
    material {
      spaceMmatMlightMtex
    }
    scale <1.0, 2.0, 1.0>
  }
  scale <0.5, 0.8, 0.5>
  translate  <0.0, -0.983965, 0.790686>
}
#declare shuttleMbody = union {
  cylinder { // Cylndr054
    <0,0,1>, <0,0,0>, 1 
    material {
      spaceMmatMlightMtex
    }
    scale <1.0, 1.0, 5.0>
    rotate -90.0*x
    translate  -5.017261*y
  }
  sphere { // Sphere010
    <0,0,0>,1
    material {
      spaceMmatMlightMtex
    }
    scale <1.0, 2.0, 1.0>
  }
}
#declare Group001 = union {
  object { shuttleMbody1 }
  object { shuttleMbody }
  scale <1.007094, 1.0, 0.737507>
  translate  <0.0, 0.277038, -0.00469>
}
#declare wing2 = object {   object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-6.919600, -0.132682, 0.059428>, <-3.448806, -0.367857, 0.005361>, <-2.183940, -0.367857, 0.013891>, <4.417628, -0.015635, 0.059428>, 
      <-8.040672, -0.042713, 6.689078>, <-3.373526, -0.115739, 7.564250>, <-2.179294, -0.115739, 0.979456>, <4.417628, -0.005033, 1.024993>, 
      <-8.040672, 0.028715, 6.634135>, <-3.373526, 0.077808, 7.509307>, <-2.179294, 0.077808, 0.924513>, <4.417628, 0.003384, 1.024993>, 
      <-6.919600, 0.101174, 0.000000>, <-3.444160, 0.336950, -0.054067>, <-2.179294, 0.336950, -0.045537>, <4.417628, 0.011922, 0.000000>
    }
  }
  material {
    spaceMmatMlightMtex
  }
  scale 0.2
  rotate <0.0, -0.0, 90.0>
  translate  <-0.00461, -3.310351, 0.808224>
}
#declare shuttle = union {
  object { shuttleMengine2 }
  object { shuttleMengine1 }
  object { shuttleMengine }
  object { Group001 }
  object { wing2 }
  object { // wing1->wing
    wing
    scale -1.0
    rotate <180.0, 0.0, -0.0>
  }
  object { wing }
  scale <2.0, 2.25, 2.0>
  rotate <-14.876513, -4.978364, 158.131073>
  translate  <10.506576, -95.426027, -3.88922>
}
union { // powerMstation
  object { // lifeMmodMgroup1->life-mod-group
    lifeMmodMgroup
    translate  <0.0, 24.138379, 0.0>
  }
  object { lifeMmodMgroup }
  object { // panelMblock3->panel-block2
    panelMblock2
    translate  <-0.0, -22.146818, -0.0>
  }
  object { panelMblock2 }
  object { // panelMblock1->panel-block
    panelMblock
    translate  <-0.0, -22.464052, -0.0>
  }
  cylinder { // Cylndr051
    <0,0,1>, <0,0,0>, 1 
    material {
      spaceMmatMlightMsMtexM2
    }
    scale <1.0, 1.0, 200.0>
    rotate 90.0*x
    translate  <0.0, 72.597244, 0.0>
  }
  object { panelMblock }
  object { // lifeMmodMgroup2->life-mod-group
    lifeMmodMgroup
    rotate <-0.0, 0.0, 0.0>
    translate  <0.003786, -140.608773, 0.024251>
  }
  object { lifeMmodule3 }
  object { lifeMmodule4 }
  object { // lifeMmodule6->life-module5
    lifeMmodule5
    translate  99.389901*y
  }
  object { lifeMmodule5 }
  object { shuttle }
  scale 0.2
  rotate <10.595963, 13.532517, 40.305054>
  translate  <-32.313967, 21.897759, 5.720049>
}


#declare engine5 = union {
  cylinder { // Cylndr030
    <0,0,1>, <0,0,0>, 1 
    material {
      black
    }
    scale <0.16, 0.16, 0.5>
    translate  0.562514*z
  }
  cylinder { // Cylndr031
    <0,0,1>, <0,0,0>, 1 
    material {
      spaceMmatMdarkMtex
    }
    scale <0.2, 0.2, 1.0>
  }
  scale 1.2
  rotate -90.0*x
  translate  0.184103*y
}
#declare engineMgroup3 = union {
  object { // engine4->engine
    engine
    scale 1.5
    rotate -90.0*x
    translate  0.65459*z
  }
  object { // engine2->engine
    engine
    rotate -90.0*z
  }
  object { engine5 }
}
#declare engineMcarrier1 = union {
  sphere { // Sphere006
    <0,0,0>,1
    translate  8.0*z
  }
  sphere { // Sphere007
    <0,0,0>,1
  }
  cylinder { // Cylndr032
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 8.0>
  }
  material {
    spaceMmatMlightMcMtex
  }
}
#declare engineMsystem7 = union {
  object { // engineMgroup2->engine-group
    engineMgroup
    rotate <-0.0, -180.0, -90.0>
    translate  8.0*z
  }
  object { engineMgroup3 }
  object { engineMcarrier1 }
  rotate <90.0, 0.0, 90.0>
  translate  <-4.0, 2.5, 1.517784>
}
#declare CSG004 = difference {
  sphere { // craftMbody1
    <0,0,0>,1
    material {
      spaceMmatMlightMsMtex
    }
    scale <6.0, 4.0, 3.0>
  }
  sphere { // Sphere008
    <0,0,0>,1
    material {
      spaceMmatMdarkMtex
    }
    scale 2.0
    translate  4.406637*x
  }
}
#declare lowerMarm2 = union {
  box { // Cube017
    <-1, -1, -1>, <1, 1, 1>
    material {
      spaceMmatMlightMtex
    }
    scale <0.8, 0.15, 0.4>
    rotate 5.969313*z
    translate  <9.95849, -0.510879, 0.698929>
  }
  box { // Cube018
    <-1, -1, -1>, <1, 1, 1>
    material {
      spaceMmatMlightMtex
    }
    scale <0.8, 0.15, 0.4>
    rotate -9.229875*z
    translate  <9.95849, 0.280984, 0.698929>
  }
  box { // Cube019
    <-1, -1, -1>, <1, 1, 1>
    material {
      spaceMmatMdarkMtex
    }
    scale 0.5
    translate  <9.031093, -0.106074, 0.68844>
  }
  cylinder { // Cylndr037
    <0,0,1>, <0,0,0>, 1 
    material {
      spaceMmatMlightMtex
    }
    scale <0.2, 0.2, 4.0>
    rotate 90.0*y
    translate  <5.001488, -0.42367, 0.681906>
  }
  cylinder { // Cylndr038
    <0,0,1>, <0,0,0>, 1 
    material {
      spaceMmatMlightMtex
    }
    scale <0.4, 0.4, 4.0>
    rotate 90.0*y
    translate  <5.036793, 0.0, 0.681906>
  }
  cylinder { // Cylndr039
    <0,0,1>, <0,0,0>, 1 
    material {
      spaceMmatMdarkMtex
    }
    scale <0.8, 0.8, 1.0>
    translate  <4.978118, -0.105917, 0.198889>
  }
  rotate -0.0*z
  translate  <-5.006615, 0.153264, 0.0>
  rotate 58.821957*z
  translate  <5.006615, -0.153264, 0.0>
}
#declare upperMarm2 = union {
  cylinder { // Cylndr034
    <0,0,1>, <0,0,0>, 1 
    material {
      spaceMmatMlightMtex
    }
    scale <0.2, 0.2, 5.0>
    rotate 90.0*y
    translate  <0.0, -0.529587, 0.681906>
  }
  cylinder { // Cylndr035
    <0,0,1>, <0,0,0>, 1 
    material {
      spaceMmatMlightMtex
    }
    scale <0.5, 0.5, 5.0>
    rotate 90.0*y
    translate  0.681906*z
  }
  cylinder { // Cylndr036
    <0,0,1>, <0,0,0>, 1 
    material {
      spaceMmatMdarkMtex
    }
    scale <1.3, 1.3, 1.5>
    translate  -0.091327*z
  }
  object { lowerMarm2 }
  rotate -10.49572*z
}
#declare armMstruct2 = union {
  cylinder { // Cylndr033
    <0,0,1>, <0,0,0>, 1 
    material {
      spaceMmatMlightMtex
    }
    scale <1.0, 1.0, 4.0>
    translate  -1.353136*z
  }
  object { upperMarm2 }
  scale <0.5, 0.5, 0.7>
  rotate <7.378304, -3.218762, -21.884466>
  translate  <4.012605, -2.722702, -0.466547>
}
#declare lowerMarm3 = union {
  box { // Cube020
    <-1, -1, -1>, <1, 1, 1>
    material {
      spaceMmatMlightMtex
    }
    scale <0.8, 0.15, 0.4>
    rotate 5.969313*z
    translate  <9.95849, -0.510879, 0.698929>
  }
  box { // Cube021
    <-1, -1, -1>, <1, 1, 1>
    material {
      spaceMmatMlightMtex
    }
    scale <0.8, 0.15, 0.4>
    rotate -9.229875*z
    translate  <9.95849, 0.280984, 0.698929>
  }
  box { // Cube022
    <-1, -1, -1>, <1, 1, 1>
    material {
      spaceMmatMdarkMtex
    }
    scale 0.5
    translate  <9.031093, -0.106074, 0.68844>
  }
  cylinder { // Cylndr044
    <0,0,1>, <0,0,0>, 1 
    material {
      spaceMmatMlightMtex
    }
    scale <0.2, 0.2, 4.0>
    rotate 90.0*y
    translate  <5.001488, -0.42367, 0.681906>
  }
  cylinder { // Cylndr045
    <0,0,1>, <0,0,0>, 1 
    material {
      spaceMmatMlightMtex
    }
    scale <0.4, 0.4, 4.0>
    rotate 90.0*y
    translate  <5.036793, 0.0, 0.681906>
  }
  cylinder { // Cylndr046
    <0,0,1>, <0,0,0>, 1 
    material {
      spaceMmatMdarkMtex
    }
    scale <0.8, 0.8, 1.0>
    translate  <4.978118, -0.105917, 0.198889>
  }
  rotate -0.0*z
  translate  <-5.006615, 0.153264, 0.0>
  rotate <0.0, 0.0, 50.936764>
  translate  <5.006615, -0.153264, 0.0>
}
#declare upperMarm3 = union {
  cylinder { // Cylndr041
    <0,0,1>, <0,0,0>, 1 
    material {
      spaceMmatMlightMtex
    }
    scale <0.2, 0.2, 5.0>
    rotate 90.0*y
    translate  <0.0, -0.529587, 0.681906>
  }
  cylinder { // Cylndr042
    <0,0,1>, <0,0,0>, 1 
    material {
      spaceMmatMlightMtex
    }
    scale <0.5, 0.5, 5.0>
    rotate 90.0*y
    translate  0.681906*z
  }
  cylinder { // Cylndr043
    <0,0,1>, <0,0,0>, 1 
    material {
      spaceMmatMdarkMtex
    }
    scale <1.3, 1.3, 1.5>
    translate  -0.091327*z
  }
  object { lowerMarm3 }
  rotate <0.0, 0.0, 5.171301>
}
#declare armMstruct3 = union {
  cylinder { // Cylndr040
    <0,0,1>, <0,0,0>, 1 
    material {
      spaceMmatMlightMtex
    }
    scale <1.0, 1.0, 4.0>
    translate  -1.353136*z
  }
  object { upperMarm3 }
  scale <0.5, 0.5, 0.7>
  rotate <172.512009, 8.913528, 30.992649>
  translate  <3.973324, 2.647286, 0.374289>
}
#declare lightsystem2 = union {
  cylinder { // Cylndr047
    <0,0,1>, <0,0,0>, 1 
    material {
      lightMpointMtex
    }
    scale <0.3, 0.3, 1.0>
    translate  0.064877*z
  }
  cylinder { // Cylndr048
    <0,0,1>, <0,0,0>, 1 
    material {
      spaceMmatMlightMcMtex
    }
    scale <0.4, 0.4, 1.0>
  }
  scale <1.0, 1.0, 3.0>
  rotate <180.0, 85.865936, 180.0>
  translate  <2.145446, 1.502895, 2.018485>
}
union { // craft1
  object { // engineMsystem4->engine-system2
    engineMsystem2
    rotate 180.0*z
  }
  object { // engineMsystem5->engine-system
    engineMsystem
    rotate <180.0, 0.0, 180.0>
  }
  object { // engineMsystem6->engine-system
    engineMsystem
    rotate <0.0, -0.0, 180.0>
  }
  object { engineMsystem7 }
  object { CSG004 }
  sphere { // cabineMglass1
    <0,0,0>,1
    material {
      spaceMmatMlightMsMtex
    }
    scale 2.0
    translate  4.406637*x
  }
  torus { // Torus006
    1.85, 0.15  rotate -x*90
    material {
      spaceMmatMdarkMtex
    }
    scale <1.1, 1.1, 1.8>
    rotate -90.0*y
    translate  4.671338*x
  }
  object { armMstruct2 }
  object { armMstruct3 }
  object { Light002 }
  object { lightsystem2 }
  object { // lightsystem3->lightsystem
    lightsystem
    rotate <0.0, -0.0, -0.0>
    translate  <-0.030827, -3.051875, 0.0>
  }
  scale 0.05
  rotate <1.421717, -1.495598, 46.441582>
  translate  <-1.701741, -2.223897, 0.185658>
}


#declare CSG003 = difference {
  sphere { // craftMbody
    <0,0,0>,1
    material {
      spaceMmatMlightMsMtex
    }
    scale <6.0, 4.0, 3.0>
  }
  sphere { // Sphere003
    <0,0,0>,1
    material {
      spaceMmatMdarkMtex
    }
    scale 2.0
    translate  4.406637*x
  }
}
#declare lowerMarm = union {
  box { // Cube013
    <-1, -1, -1>, <1, 1, 1>
    material {
      spaceMmatMlightMtex
    }
    scale <0.8, 0.15, 0.4>
    rotate 5.969313*z
    translate  <9.95849, -0.510879, 0.698929>
  }
  box { // Cube012
    <-1, -1, -1>, <1, 1, 1>
    material {
      spaceMmatMlightMtex
    }
    scale <0.8, 0.15, 0.4>
    rotate -9.229875*z
    translate  <9.95849, 0.280984, 0.698929>
  }
  box { // Cube011
    <-1, -1, -1>, <1, 1, 1>
    material {
      spaceMmatMdarkMtex
    }
    scale 0.5
    translate  <9.031093, -0.106074, 0.68844>
  }
  cylinder { // Cylndr020
    <0,0,1>, <0,0,0>, 1 
    material {
      spaceMmatMlightMtex
    }
    scale <0.2, 0.2, 4.0>
    rotate 90.0*y
    translate  <5.001488, -0.42367, 0.681906>
  }
  cylinder { // Cylndr019
    <0,0,1>, <0,0,0>, 1 
    material {
      spaceMmatMlightMtex
    }
    scale <0.4, 0.4, 4.0>
    rotate 90.0*y
    translate  <5.036793, 0.0, 0.681906>
  }
  cylinder { // Cylndr018
    <0,0,1>, <0,0,0>, 1 
    material {
      spaceMmatMdarkMtex
    }
    scale <0.8, 0.8, 1.0>
    translate  <4.978118, -0.105917, 0.198889>
  }
  rotate -0.0*z
  translate  <-5.006615, 0.153264, 0.0>
  rotate 58.821957*z
  translate  <5.006615, -0.153264, 0.0>
}
#declare upperMarm = union {
  cylinder { // Cylndr017
    <0,0,1>, <0,0,0>, 1 
    material {
      spaceMmatMlightMtex
    }
    scale <0.2, 0.2, 5.0>
    rotate 90.0*y
    translate  <0.0, -0.529587, 0.681906>
  }
  cylinder { // Cylndr016
    <0,0,1>, <0,0,0>, 1 
    material {
      spaceMmatMlightMtex
    }
    scale <0.5, 0.5, 5.0>
    rotate 90.0*y
    translate  0.681906*z
  }
  cylinder { // Cylndr015
    <0,0,1>, <0,0,0>, 1 
    material {
      spaceMmatMdarkMtex
    }
    scale <1.3, 1.3, 1.5>
    translate  -0.091327*z
  }
  object { lowerMarm }
  rotate -10.49572*z
}
#declare armMstruct0 = union {
  cylinder { // Cylndr014
    <0,0,1>, <0,0,0>, 1 
    material {
      spaceMmatMlightMtex
    }
    scale <1.0, 1.0, 4.0>
    translate  -1.353136*z
  }
  object { upperMarm }
  scale <0.5, 0.5, 0.7>
  rotate <7.378304, -3.218762, -21.884466>
  translate  <4.012605, -2.722702, -0.466547>
}
#declare lowerMarm1 = union {
  box { // Cube014
    <-1, -1, -1>, <1, 1, 1>
    material {
      spaceMmatMlightMtex
    }
    scale <0.8, 0.15, 0.4>
    rotate 5.969313*z
    translate  <9.95849, -0.510879, 0.698929>
  }
  box { // Cube015
    <-1, -1, -1>, <1, 1, 1>
    material {
      spaceMmatMlightMtex
    }
    scale <0.8, 0.15, 0.4>
    rotate -9.229875*z
    translate  <9.95849, 0.280984, 0.698929>
  }
  box { // Cube016
    <-1, -1, -1>, <1, 1, 1>
    material {
      spaceMmatMdarkMtex
    }
    scale 0.5
    translate  <9.031093, -0.106074, 0.68844>
  }
  cylinder { // Cylndr025
    <0,0,1>, <0,0,0>, 1 
    material {
      spaceMmatMlightMtex
    }
    scale <0.2, 0.2, 4.0>
    rotate 90.0*y
    translate  <5.001488, -0.42367, 0.681906>
  }
  cylinder { // Cylndr026
    <0,0,1>, <0,0,0>, 1 
    material {
      spaceMmatMlightMtex
    }
    scale <0.4, 0.4, 4.0>
    rotate 90.0*y
    translate  <5.036793, 0.0, 0.681906>
  }
  cylinder { // Cylndr027
    <0,0,1>, <0,0,0>, 1 
    material {
      spaceMmatMdarkMtex
    }
    scale <0.8, 0.8, 1.0>
    translate  <4.978118, -0.105917, 0.198889>
  }
  rotate -0.0*z
  translate  <-5.006615, 0.153264, 0.0>
  rotate <0.0, 0.0, 50.936764>
  translate  <5.006615, -0.153264, 0.0>
}
#declare upperMarm1 = union {
  cylinder { // Cylndr022
    <0,0,1>, <0,0,0>, 1 
    material {
      spaceMmatMlightMtex
    }
    scale <0.2, 0.2, 5.0>
    rotate 90.0*y
    translate  <0.0, -0.529587, 0.681906>
  }
  cylinder { // Cylndr023
    <0,0,1>, <0,0,0>, 1 
    material {
      spaceMmatMlightMtex
    }
    scale <0.5, 0.5, 5.0>
    rotate 90.0*y
    translate  0.681906*z
  }
  cylinder { // Cylndr024
    <0,0,1>, <0,0,0>, 1 
    material {
      spaceMmatMdarkMtex
    }
    scale <1.3, 1.3, 1.5>
    translate  -0.091327*z
  }
  object { lowerMarm1 }
  rotate <0.0, 0.0, 5.171301>
}
#declare armMstruct1 = union {
  cylinder { // Cylndr021
    <0,0,1>, <0,0,0>, 1 
    material {
      spaceMmatMlightMtex
    }
    scale <1.0, 1.0, 4.0>
    translate  -1.353136*z
  }
  object { upperMarm1 }
  scale <0.5, 0.5, 0.7>
  rotate <172.512009, 8.913528, 30.992649>
  translate  <3.973324, 2.647286, 0.374289>
}
union { // craft
  object { // engineMsystem3->engine-system2
    engineMsystem2
    rotate 180.0*z
  }
  object { engineMsystem2 }
  object { // engineMsystem1->engine-system
    engineMsystem
    rotate <0.0, -0.0, 180.0>
  }
  object { engineMsystem }
  object { CSG003 }
  sphere { // cabineMglass
    <0,0,0>,1
    material {
      spaceMmatMlightMsMtex
    }
    scale 2.0
    translate  4.406637*x
  }
  torus { // Torus005
    1.85, 0.15  rotate -x*90
    material {
      spaceMmatMdarkMtex
    }
    scale <1.1, 1.1, 1.8>
    rotate -90.0*y
    translate  4.671338*x
  }
  object { armMstruct0 }
  object { armMstruct1 }
  object { Light001 }
  object { lightsystem }
  object { // lightsystem1->lightsystem
    lightsystem
    rotate <0.0, -0.0, -0.0>
    translate  <-0.030827, -3.051875, 0.0>
  }
  scale 0.05
  rotate <8.602275, 12.283394, 35.415184>
  translate  <-1.886682, -2.78919, 0.772588>
}




union { // planet
  sphere { // PlanetMglobe
    <0,0,0>,1
    material {
      PlanetMSky
    }
    // Scaling fixed
    // Rotation fixed
    scale 20000.0
    translate  <-11814.110232, -571.209237, 18451.303204>
  }
  sphere { // PlanetMhull
    <0,0,0>,1
    material {
      athmosphere
    }
    hollow
    scale 20300.0
    translate  <-11814.110232, -571.209237, 18451.303204>
  }
  // All transformations fixed
}


union { // labMglobe
  object { shield }
  object { LaserM01 }
  sphere { // fusionMcloud
    <0,0,0>,1
    material {
      fusionMglowMtexMsphere
    }
    hollow
  }
  torus { // Link_Torus
    1.95, 0.05  rotate -x*90
    material {
      outerMshieldMtex
    }
    scale 1.2
  }
  object { // LaserM10->Laser-06
    LaserM06
    rotate 72.000008*z
    translate  <-0.0, 0.0, -0.0>
  }
  object { // LaserM09->Laser-06
    LaserM06
    rotate 144.0*z
    translate  <-0.0, 0.0, -0.0>
  }
  object { // LaserM08->Laser-06
    LaserM06
    rotate -144.0*z
    translate  <-0.0, -0.0, -0.0>
  }
  object { // LaserM07->Laser-06
    LaserM06
    rotate -72.0*z
    translate  <-0.0, 0.0, -0.0>
  }
  object { LaserM06 }
  object { // LaserM05->Laser-01
    LaserM01
    rotate <-0.0, -0.0, 71.999992>
    translate  <-0.0, 0.0, 0.0>
  }
  object { // LaserM04->Laser-01
    LaserM01
    rotate <-0.0, -0.0, 144.0>
    translate  <-0.0, -0.0, 0.0>
  }
  object { // LaserM03->Laser-01
    LaserM01
    rotate <-0.0, -0.0, -144.0>
    translate  -0.0*y
  }
  object { // LaserM02->Laser-01
    LaserM01
    rotate <-0.0, -0.0, -72.0>
    translate  <0.0, 0.0, 0.0>
  }
  object { // shield6->shield
    shield
    scale <1.2, 1.0, 1.2>
    rotate -90.0*x
    translate  0.637883*z
  }
  object { // shield5->shield
    shield
    scale <1.2, 1.0, 1.2>
    rotate <90.0, 0.0, -142.737183>
    translate  -0.776397*z
  }
  object { // shield4->shield
    shield
    rotate 72.0*z
    translate  -0.0*x
  }
  object { // shield3->shield
    shield
    rotate 144.0*z
    translate  <0.0, -0.0, 0.0>
  }
  object { // shield2->shield
    shield
    rotate -144.0*z
    translate  -0.0*y
  }
  object { // shield1->shield
    shield
    rotate -72.0*z
  }
  sphere { // fusionMpoint
    <0,0,0>,1
    material {
      fusionMpointMtex
    }
    scale 0.1
  }
  object { fusionMlight }
}


