#version unofficial MegaPOV 0.5;

#declare test_dossier_inc=off;


#macro Dossier(t_feuille, t_pochette, st)

#local haut=t_pochette.y;
#local larg=t_feuille.x;
#local larg2=t_pochette.x;
#local long=t_feuille.z;
#local long2=t_pochette.z;

union {
	merge {
		cylinder { -long2*.51*z, long2*.51*z, haut*.25 translate haut*.25*y }
		cylinder { -long2*.51*z, long2*.51*z, haut*.25 translate -haut*.25*y }
		box { <-haut*.25, -haut*.25, -long2*.51>, <0, haut*.25, long2*.51> }
		box { <0, -haut*.5, -long2*.51>, <larg2*1.05, haut*.5, long2*.51> }
		clipped_by { box {<-haut*.26, -haut*.51, -long2*.5>, <larg2, haut*.51, long2*.5>} }
		#local sat=.3+.4*rand(st);
		texture {
			pigment { color rgb<sat+.3*rand(st), sat+.3*rand(st), sat+.3*rand(st)> }
			finish { brilliance .5 phong .1 phong_size 20 }
		}
	}
	merge {
	#local i=-haut*.499;
	#while (i<(haut*.498))
		#local i_old=i;
		#local i=i+haut*.08*rand(st);
		#if (i>=(haut*.498))
			#local i=haut*.499;
		#end
		box { <0, i_old, -long*.5>, <larg, i, long*.5>
			#if (rand(st)>.5)
				translate long*.5*z
				rotate pow(rand(st),2)*10*y
				translate -long*.5*z
			#else
				translate -long*.5*z
				rotate -pow(rand(st),2)*10*y
				translate long*.5*z
			#end
			translate pow(rand(st),2)*larg*.1*x
		}
	#end
		texture {
			pigment { rgb .95 }
			normal { gradient y scale 1/haut*100 }
		}
	}
	translate y*haut*.5
}

#end

#macro Pile_Dossiers(t_feuille, t_pochette, hauteur, max_rot, st)

union {
#local i=0;
#while (i<hauteur)
	#local l_haut = .6*(t_pochette.y)*rand(st);
	object { Dossier(t_feuille, t_pochette - l_haut*y, st)
		translate -(t_pochette.x)*.3
		rotate (-1+2*rand(st))*max_rot*y
		translate (t_pochette.x)*.3
		translate i*y
	}
	#local i=i+(t_pochette.y - l_haut);
#end	
}

#end


#macro Feuilles_Vrac(nbf, taillef, taillev, st)

#local feuille =  mesh {
	triangle{ 0, x, x+z }
	triangle{ 0, z, x+z }
	pigment { image_map { gif "images/texte2.gif" map_type 0 once } rotate x*90 }
	translate <-.5,0,-.5>
	scale  taillef
}

union {
#local i = 0;
#while (i<nbf)
	#local tmpx = taillev.x*(-.5+rand(st));
	#local tmpz = taillev.z*(-.5+rand(st));
	#local tmpy = rand(st)*taillev.y;
	object {
		feuille
		rotate 3651*rand(st)*y
		translate <tmpx, tmpy, tmpz>
	}
	#local i=i+1;
#end
}
#end



//========================

// Maze( M_Dim, M_Complex, M_Randseed )
//
// M_Dim is the dimensions for the tile. '4' would let you place it on a
// 4-unit square cube
//
// M_Complex is how complex you want it. Values range from 0 to 2.
// good values are from 1 to 2
//
// M_Randseed is just the seed value for the maze. Enter any value to
// see different patterns

#macro Maze( M_Dim, M_Complex, M_Randseed )
#local M_Dim=M_Dim*8;
#local M_Rand=M_Dim/20;
#local M_Pat = function {
	pigment {
		image_map {
			pattern M_Dim, M_Dim {
				function noise3d(x,y,z)
				scale ( .25/M_Rand)/M_Complex
				translate y*rand( seed( M_Randseed ) )
			}
			map_type 0    //include 'once' to test the tiling
		}
		translate<-.5, -.5, -.5> rotate x*90 scale M_Dim/4
	}
}
#local M_Pigm = function {
	pigment{
		function M_Pat( x, y, z )
		scale .5
		pigment_map {
			[.5 function x*2 sine_wave color_map{ [.3 rgb 0][.3 rgb 1] } ]
			[.5 function z*2 sine_wave color_map{ [.3 rgb 0][.3 rgb 1] } ]
		}
		warp { turbulence .5 }
	}
}

	function{ M_Pigm( x, y, z ) }
#end

#macro Paragraphe(nb_ligne, st)

	pigment_pattern {
		boxed
		scale <.5,.5,1>
		translate <.5,.5,0>
	}
	pigment_map {
		[.1 rgb 1]
		[.1 gradient y scale <1,1/nb_ligne,1> pigment_map { [.3 rgb 1][.3 Maze(4,1.1,st) scale <.1,.5,1>] } ]
	}
	

#end
//========================================




#if (test_dossier_inc)

#include "colors.inc"
#include "woods.inc"

camera {
	location <2,3,-8>*.6
	right x*5
	up y*3
	angle 5
	look_at <-.05,.15,0>
}

#declare Use_Rad = off;

#if (Use_Rad)

global_settings {
	assumed_gamma 1.0
	ini_option "+QR"
	radiosity{
		count 100
		nearest_count 5
		error_bound .1
		recursion_limit 1
		brightness 1.0

		pretrace_start  .1
		pretrace_end  .01

		low_error_factor .5
		gray_threshold 0.0
		minimum_reuse 0.015
		normal on

		max_sample 1
		adc_bailout 0.05
	}
}

#default { texture { finish { diffuse 1 ambient 0 } } }

sky_sphere { pigment { gradient y color_map { [.5 rgb <1, .99, .95>*.7] [.9 rgb <1, 1, 1>*.9] } } }

#else


global_settings {
	assumed_gamma 1.6
}


light_source { <-15,15,-15>*100, color rgb .9 }
light_source { <15,5,-5>*100, color rgb .3 shadowless }

#default { texture { finish { diffuse 0.9 ambient 0.1 } } }

#end

#declare st_d = seed(1234);


plane { y, 0
	texture { T_Wood22 }
}

object {
	Pile_Dossiers(<.21, .05, .297>, <.23, .05, .32>, .2, 15, st_d)
	translate .002*y +.02*x
}
object {
	Pile_Dossiers(<.21, .05, .297>, <.23, .05, .32>, .15, 15, st_d)
	translate .002*y - .27*x
}
object {
	Pile_Dossiers(<.21, .05, .297>, <.23, .05, .32>, .18, 15, st_d)
	rotate -y*87
	translate .002*y + .3*z
}

object {
	Feuilles_Vrac(50, <.21, 0, .297>, <1, .002, 2>, st_d)
	translate .0001*y + .5*z
}

#end
