#version unofficial megapov 0.5;

#declare test_grilles_inc = off;

#macro Grille(x1,x2,y1,y2,nx,ny,rx,ry)
union {
	#local i=x1;
	#local inc=(x2-x1)/nx;
	#while (i<(x2+inc*.5))
		#if (i=x1)
		cylinder { <i, y1-.02, 0>, <i, y2+.02, 0>, rx }
		#else
		cylinder { <i, y1, 0>, <i, y2, 0>, rx }
		#end
		#local i=i+inc;
	#end
	#local i=y1;
	#local inc=(y2-y1)/ny;
	#while (i<(y2+inc*.5))
		cylinder { <x1, i, 0>, <x2, i, 0>, ry }
		#local i=i+inc;
	#end
}
#end


#declare Lambda = 2;
#declare Omega = .2;
#declare Octaves = 2;

#macro Grille_Tordue(x1,x2,y1,y2,nx,ny,rx,ry,turb,sturb)
union {
	#local i=x1;
	#local incx=(x2-x1)/nx;
	#local incy=(y2-y1)/ny;
	#while (i<(x2+incx*.1))
		#local j=y1;
		#while (j<(y2+incy*.1))
			#local point1 = <i,j,0>;
			#local point1=point1 + turb*vturbulence(Lambda, Omega, Octaves, point1*sturb);
			#if (j<((y2-incy*.1)))
				#local point2 = <i,j+incy,0>;
				#local point2=point2 + turb*vturbulence(Lambda, Omega, Octaves, point2*sturb);
				cylinder { point1, point2, ry }
			#else
				sphere { point1, ry }
			#end
			#if (i<((x2-incx*.1)))
				#local point2 = <i+incx,j,0>;
				#local point2=point2 + turb*vturbulence(Lambda, Omega, Octaves, point2*sturb);
				cylinder { point1, point2, rx }
			#else
				sphere { point1, rx }
			#end
			#local j=j+incy;
		#end
		#local i=i+incx;
	#end
}
#end

#macro Loquet(ferme)
union {
	union {
		sphere { <-.03, 0, 0>, .0048 }
		cylinder { <-.03, 0, 0>, < .03, 0, 0>, .0048 }
		sphere { < .03, 0, 0>, .0048 }
		cone { <0, 0, 0>, .0012, <0, -.02, 0>, .002 }
		sphere { <0, -.02, 0>, .002 }
		#if (ferme)
			rotate x*20
			translate .015*x
		#else
			rotate x*65
			translate -.015*x
		#end
	}
	difference {
		cylinder {<-.022, 0, 0>, < .022, 0, 0>, .006 }
		cylinder {<-.023, 0, 0>, < .023, 0, 0>, .005 }
		union {
			cylinder { <-.015, 0, 0>, < .015, 0, 0>, .002 }
			sphere { <-.015, 0, 0>, .002 }
			cylinder { <-.015, 0, 0>, <-.015, -.03, 0>, .002 }
			sphere { < .015, 0, 0>, .002 }
			cylinder { < .015, 0, 0>, < .015, -.03, 0>, .002 }
			translate -.0055*z
		}
	}
}
#end


#if (test_grilles_inc)

camera {
	location <1,3,-5>
	angle 5
	look_at <.8,.5,0>
}

light_source { <15,5,-15>, color rgb 1 }

plane { y, 0
	pigment { rgb <.98, .98.93> }
}

/*
object {
	// Grille_Tordue(x1,x2,y1,y2,nx,ny,rx,ry)
	Grille_Tordue(.05, .95, 0.06, 0.94, 4, 8, .004, .004, <.1, .1, .4>, <1.2,.8,1>)
	pigment { rgb .6 }
	finish { brilliance 2 specular .6 roughness .05 }
	translate -.45*x
	rotate x*77
	translate -.14*y
}
*/

object {
	// Grille(x1,x2,y1,y2,nx,ny,rx,ry)
	Grille(.05, .95, 0.06, 0.94, 4, 8, .004, .004)
	pigment { rgb .6 }
	finish { brilliance 2 specular .6 roughness .05 }
}

object {
	Loquet(on)
	scale 2
	translate <.95-2*.022, .5, -.010>
	pigment { rgb .6 }
	finish { brilliance 2 specular .6 roughness .05 }
}


#end
